//==============================================================================
// ** Escape Fix
// by: Jeneeus Guruman
//------------------------------------------------------------------------------
 
 
/*:
 * @plugindesc v1.0.0 Fixes the escape command to not remove the states if failed to escape.
 * @author Jeneeus Guruman
 *
 * @help Just put this above all plugins. No exceptions.
 */
 
BattleManager.processEscape = function() {
    var success = this._preemptive ? true : (Math.random() < this._escapeRatio);
    if (success) {
        $gameParty.removeBattleStates();
    }
    $gameParty.performEscape();
    SoundManager.playEscape();
    if (success) {
        this.displayEscapeSuccessMessage();
        this._escaped = true;
        this.processAbort();
    } else {
        this.displayEscapeFailureMessage();
        this._escapeRatio += 0.1;
        $gameParty.clearActions();
        this.startTurn();
    }
    return success;
};