#include "mnem.h"

const char *const ud_mnemonics_str[] = {
  "3dnow",
  "aaa",
  "aad",
  "aam",
  "aas",
  "adc",
  "add",
  "addpd",
  "addps",
  "addsd",
  "addss",
  "addsubpd",
  "addsubps",
  "and",
  "andpd",
  "andps",
  "andnpd",
  "andnps",
  "arpl",
  "movsxd",
  "bound",
  "bsf",
  "bsr",
  "bswap",
  "bt",
  "btc",
  "btr",
  "bts",
  "call",
  "cbw",
  "cwde",
  "cdqe",
  "clc",
  "cld",
  "clflush",
  "clgi",
  "cli",
  "clts",
  "cmc",
  "cmovo",
  "cmovno",
  "cmovb",
  "cmovae",
  "cmovz",
  "cmovnz",
  "cmovbe",
  "cmova",
  "cmovs",
  "cmovns",
  "cmovp",
  "cmovnp",
  "cmovl",
  "cmovge",
  "cmovle",
  "cmovg",
  "cmp",
  "cmppd",
  "cmpps",
  "cmpsb",
  "cmpsw",
  "cmpsd",
  "cmpsq",
  "cmpss",
  "cmpxchg",
  "cmpxchg8b",
  "comisd",
  "comiss",
  "cpuid",
  "cvtdq2pd",
  "cvtdq2ps",
  "cvtpd2dq",
  "cvtpd2pi",
  "cvtpd2ps",
  "cvtpi2ps",
  "cvtpi2pd",
  "cvtps2dq",
  "cvtps2pi",
  "cvtps2pd",
  "cvtsd2si",
  "cvtsd2ss",
  "cvtsi2ss",
  "cvtss2si",
  "cvtss2sd",
  "cvttpd2pi",
  "cvttpd2dq",
  "cvttps2dq",
  "cvttps2pi",
  "cvttsd2si",
  "cvtsi2sd",
  "cvttss2si",
  "cwd",
  "cdq",
  "cqo",
  "daa",
  "das",
  "dec",
  "div",
  "divpd",
  "divps",
  "divsd",
  "divss",
  "emms",
  "enter",
  "f2xm1",
  "fabs",
  "fadd",
  "faddp",
  "fbld",
  "fbstp",
  "fchs",
  "fnclex",
  "fcmovb",
  "fcmove",
  "fcmovbe",
  "fcmovu",
  "fcmovnb",
  "fcmovne",
  "fcmovnbe",
  "fcmovnu",
  "fucomi",
  "fcom",
  "fcom2",
  "fcomp3",
  "fcomi",
  "fucomip",
  "fcomip",
  "fcomp",
  "fcomp5",
  "fcompp",
  "fcos",
  "fdecstp",
  "fdiv",
  "fdivp",
  "fdivr",
  "fdivrp",
  "femms",
  "ffree",
  "ffreep",
  "ficom",
  "ficomp",
  "fild",
  "fincstp",
  "fninit",
  "fiadd",
  "fidivr",
  "fidiv",
  "fisub",
  "fisubr",
  "fist",
  "fistp",
  "fisttp",
  "fld",
  "fld1",
  "fldl2t",
  "fldl2e",
  "fldpi",
  "fldlg2",
  "fldln2",
  "fldz",
  "fldcw",
  "fldenv",
  "fmul",
  "fmulp",
  "fimul",
  "fnop",
  "fpatan",
  "fprem",
  "fprem1",
  "fptan",
  "frndint",
  "frstor",
  "fnsave",
  "fscale",
  "fsin",
  "fsincos",
  "fsqrt",
  "fstp",
  "fstp1",
  "fstp8",
  "fstp9",
  "fst",
  "fnstcw",
  "fnstenv",
  "fnstsw",
  "fsub",
  "fsubp",
  "fsubr",
  "fsubrp",
  "ftst",
  "fucom",
  "fucomp",
  "fucompp",
  "fxam",
  "fxch",
  "fxch4",
  "fxch7",
  "fxrstor",
  "fxsave",
  "fxtract",
  "fyl2x",
  "fyl2xp1",
  "getsec",
  "haddpd",
  "haddps",
  "hlt",
  "hsubpd",
  "hsubps",
  "idiv",
  "in",
  "imul",
  "inc",
  "insb",
  "insw",
  "insd",
  "int1",
  "int3",
  "int",
  "into",
  "invd",
  "invlpg",
  "invlpga",
  "iretw",
  "iretd",
  "iretq",
  "jo",
  "jno",
  "jb",
  "jae",
  "jz",
  "jnz",
  "jbe",
  "ja",
  "js",
  "jns",
  "jp",
  "jnp",
  "jl",
  "jge",
  "jle",
  "jg",
  "jcxz",
  "jecxz",
  "jrcxz",
  "jmp",
  "lahf",
  "lar",
  "lddqu",
  "ldmxcsr",
  "lds",
  "lea",
  "les",
  "lfs",
  "lgs",
  "lidt",
  "lss",
  "leave",
  "lfence",
  "lgdt",
  "lldt",
  "lmsw",
  "lock",
  "lodsb",
  "lodsw",
  "lodsd",
  "lodsq",
  "loopnz",
  "loope",
  "loop",
  "lsl",
  "ltr",
  "maskmovq",
  "maskmovdqu",
  "maxpd",
  "maxps",
  "maxsd",
  "maxss",
  "mfence",
  "minpd",
  "minps",
  "minsd",
  "minss",
  "monitor",
  "mov",
  "movapd",
  "movaps",
  "movd",
  "movddup",
  "movdqa",
  "movdqu",
  "movdq2q",
  "movhpd",
  "movhps",
  "movlhps",
  "movlpd",
  "movlps",
  "movhlps",
  "movmskpd",
  "movmskps",
  "movntdq",
  "movnti",
  "movntpd",
  "movntps",
  "movntq",
  "movq",
  "movdqa",
  "movq2dq",
  "movsb",
  "movsw",
  "movsd",
  "movsq",
  "movsldup",
  "movshdup",
  "movss",
  "movsx",
  "movupd",
  "movups",
  "movzx",
  "mul",
  "mulpd",
  "mulps",
  "mulsd",
  "mulss",
  "mwait",
  "neg",
  "nop",
  "not",
  "or",
  "orpd",
  "orps",
  "out",
  "outsb",
  "outsw",
  "outsd",
  "outsq",
  "packsswb",
  "packssdw",
  "packuswb",
  "paddb",
  "paddw",
  "paddd",
  "paddq",
  "paddsb",
  "paddsw",
  "paddusb",
  "paddusw",
  "pand",
  "pandn",
  "pause",
  "pavgb",
  "pavgw",
  "pcmpeqb",
  "pcmpeqw",
  "pcmpeqd",
  "pcmpgtb",
  "pcmpgtw",
  "pcmpgtd",
  "pextrw",
  "pinsrw",
  "pmaddwd",
  "pmaxsw",
  "pmaxub",
  "pminsw",
  "pminub",
  "pmovmskb",
  "pmulhuw",
  "pmulhw",
  "pmullw",
  "pmuludq",
  "pop",
  "popa",
  "popad",
  "popcnt",
  "popfw",
  "popfd",
  "popfq",
  "por",
  "prefetch",
  "prefetchnta",
  "prefetcht0",
  "prefetcht1",
  "prefetcht2",
  "psadbw",
  "pshufd",
  "pshufhw",
  "pshuflw",
  "pshufw",
  "pslldq",
  "psllw",
  "pslld",
  "psllq",
  "psraw",
  "psrad",
  "psrlw",
  "psrld",
  "psrlq",
  "psrldq",
  "psubb",
  "psubw",
  "psubd",
  "psubq",
  "psubsb",
  "psubsw",
  "psubusb",
  "psubusw",
  "punpckhbw",
  "punpckhwd",
  "punpckhdq",
  "punpckhqdq",
  "punpcklbw",
  "punpcklwd",
  "punpckldq",
  "punpcklqdq",
  "pi2fw",
  "pi2fd",
  "pf2iw",
  "pf2id",
  "pfnacc",
  "pfpnacc",
  "pfcmpge",
  "pfmin",
  "pfrcp",
  "pfrsqrt",
  "pfsub",
  "pfadd",
  "pfcmpgt",
  "pfmax",
  "pfrcpit1",
  "pfrspit1",
  "pfsubr",
  "pfacc",
  "pfcmpeq",
  "pfmul",
  "pfrcpit2",
  "pmulhrw",
  "pswapd",
  "pavgusb",
  "push",
  "pusha",
  "pushad",
  "pushfw",
  "pushfd",
  "pushfq",
  "pxor",
  "rcl",
  "rcr",
  "rol",
  "ror",
  "rcpps",
  "rcpss",
  "rdmsr",
  "rdpmc",
  "rdtsc",
  "rdtscp",
  "repne",
  "rep",
  "ret",
  "retf",
  "rsm",
  "rsqrtps",
  "rsqrtss",
  "sahf",
  "sal",
  "salc",
  "sar",
  "shl",
  "shr",
  "sbb",
  "scasb",
  "scasw",
  "scasd",
  "scasq",
  "seto",
  "setno",
  "setb",
  "setnb",
  "setz",
  "setnz",
  "setbe",
  "seta",
  "sets",
  "setns",
  "setp",
  "setnp",
  "setl",
  "setge",
  "setle",
  "setg",
  "sfence",
  "sgdt",
  "shld",
  "shrd",
  "shufpd",
  "shufps",
  "sidt",
  "sldt",
  "smsw",
  "sqrtps",
  "sqrtpd",
  "sqrtsd",
  "sqrtss",
  "stc",
  "std",
  "stgi",
  "sti",
  "skinit",
  "stmxcsr",
  "stosb",
  "stosw",
  "stosd",
  "stosq",
  "str",
  "sub",
  "subpd",
  "subps",
  "subsd",
  "subss",
  "swapgs",
  "syscall",
  "sysenter",
  "sysexit",
  "sysret",
  "test",
  "ucomisd",
  "ucomiss",
  "ud0",
  "ud1",
  "ud2",
  "unpckhpd",
  "unpckhps",
  "unpcklps",
  "unpcklpd",
  "verr",
  "verw",
  "vmcall",
  "vmclear",
  "vmxon",
  "vmptrld",
  "vmptrst",
  "vmlaunch",
  "vmresume",
  "vmread",
  "vmwrite",
  "vmxoff",
  "vmrun",
  "vmmcall",
  "vmload",
  "vmsave",
  "wait",
  "wbinvd",
  "wrmsr",
  "xadd",
  "xchg",
  "xgetbv",
  "xsetbv",
  "xrstor",
  "xsaveopt",
  "xsave",
  "xlatb",
  "xor",
  "xorpd",
  "xorps",
  "pshufb",
  "phaddw",
  "phaddd",
  "phaddsw",
  "pmaddubsw",
  "phsubw",
  "phsubd",
  "phsubsw",
  "roundps",
  "psignb",
  "roundpd",
  "psignw",
  "roundss",
  "psignd",
  "roundsd",
  "pmulhrsw",
  "blendps",
  "blendpd",
  "pblendw",
  "palignr",
  "pblendvb",
  "blendvps",
  "pextrb",
  "blendvpd",
  "pextrd",
  "extractps",
  "ptest",
  "pabsb",
  "pabsw",
  "pabsd",
  "pmovsxbw",
  "pinsrb",
  "pmovsxbd",
  "insertps",
  "pmovsxbq",
  "pinsrd",
  "pmovsxwd",
  "pmovsxwq",
  "pmovsxdq",
  "pmuldq",
  "pcmpeqq",
  "movntdqa",
  "packusdw",
  "pmovzxbw",
  "pmovzxbd",
  "pmovzxbq",
  "pmovzxwd",
  "pmovzxwq",
  "pmovzxdq",
  "pcmpgtq",
  "pminsb",
  "pminsd",
  "pminuw",
  "pminud",
  "pmaxsb",
  "pmaxsd",
  "pmaxuw",
  "pmaxud",
  "pmulld",
  "dpps",
  "phminposuw",
  "dppd",
  "mpsadbw",
  "pclmulqdq",
  "pcmpestrm",
  "pcmpestri",
  "pcmpistrm",
  "pcmpistri",
  "invept",
  "invvpid",
  "aesimc",
  "aesenc",
  "aesenclast",
  "aesdec",
  "aesdeclast",
  "aeskeygenassist",
  "movbe",
  "crc32",
  "movntsd",
  "movntss",
  "tzcnt",
  "lzcnt",
  "db",
  "invalid",
};


/* Looks up mnemonic code in the mnemonic string table
 * Returns NULL if the mnemonic code is invalid
 */
const char * ud_lookup_mnemonic( enum ud_mnemonic_code c )
{
    if ( c < UD_Id3vil )
        return ud_mnemonics_str[ c ];
    return NULL;
}
