screen s_corruption_stats(charids):
    python:
        if config.developer:
            assert isinstance(charids, list), "charids need to be a list"
    frame:
        xalign 1.0
        xpadding 10
        ypadding 10

        for charid in charids:
            vbox:
                spacing 15
                use s_corruption_stats_base(charid)


screen s_corruption_stats_base(charid):
    python:
        characterClass = CharactersManager.getCharacterClassByName(charid)
        character_name = get_character_name(characterClass)

    hbox:
        spacing 15
        text "[character_name]" xalign 0.5
    
    hbox:
        spacing 30
        vbox:
            xsize 250
            spacing 20
            use corruption_bar(charid)
            use annoyance_bar(charid)

screen corruption_bar(charid):
    python:
        characterCorruption = CharactersManager.getCharacterClassByName(charid, 'Corruption')
        bar_color = characterCorruption.get_corruption_bar_color()
    vbox:
        hbox:
            bar:
                value characterCorruption.corruption
                range max_value_corruption
                xmaximum 200
                ysize 15
                left_bar bar_color
                right_bar '#046842'
        text "Corruption" size 15 xpos 5

screen annoyance_bar(charid):
    python:
        characterCorruption = CharactersManager.getCharacterClassByName(charid, 'Corruption')
        bar_color = characterCorruption.get_annoyance_bar_color()
    vbox:
        hbox:
            bar:
                value characterCorruption.annoyance
                range max_value_annoyance
                xmaximum 200
                ysize 15
                left_bar bar_color
                right_bar '#046842'
        text "Annoyance" size 15 xpos 5


label l_value_change(characterCorruption, change_value = True):
    $ value_shown = False
    if characterCorruption.corruption_change != 0:
        $ value_shown = True
        show screen s_value_change_corruption(characterCorruption.corruption_change)
    if characterCorruption.annoyance_change != 0:
        $ value_shown = True
        show screen s_value_change_annoyance(characterCorruption.annoyance_change)
    
    if value_shown:
        pause(3.0)
        hide screen s_value_change_corruption
        hide screen s_value_change_annoyance
        if change_value:
            $ characterCorruption.change_value()
    return


screen s_value_change_corruption(value):
    python:
        if value > 0:
            text_value = "+ " + str(value)
        else:
            text_value = str(value)
    frame:
        xpos 1830
        ypos 60
        xpadding 5
        ypadding 5
        style 'gui_frame_alert'
        at transform:
            on show: 
                zoom 0 
                easein 0.2 zoom 1.0
            on hide:
                easeout 0.2 zoom 0.0
        hbox:
            text "[text_value]" size 30

screen s_value_change_annoyance(value):
    python:
        if value > 0:
            text_value = "+ " + str(value)
        else:
            text_value = str(value)
    frame:
        xpos 1830
        ypos 120
        xpadding 5
        ypadding 5
        style 'gui_frame_alert'
        at transform:
            on show: 
                zoom 0 
                easein 0.2 zoom 1.0
            on hide:
                easeout 0.2 zoom 0.0
        hbox:
            text "[text_value]" size 30