default protocol = ProtocolClass()

define protocol_id_hint_sauna = 'hint_sauna'
define protocol_id_intro_lockercabin_used = 'lockers_cabines_used'
define protocol_id_intro_lockerroom_socksview = 'lockerroom_stared_diegos_socks'
define protocol_id_intro_lockerroom_barefeetview = 'lockerroom_stared_diegos_barefeet'

init python:
    class ProtocolClass:
        def __init__(self):
            self.entries = []

        def add_entry(self, entry_id, value=True, additional_data=None):
            entry = ProtocolEntry(entry_id, value, additional_data)
            self.entries.append(entry)

        def get_entries(self):
            return list(self.entries)  # gibt eine Kopie der Liste zurück

        def clear(self):
            self.entries.clear()

        def getEntriesById(self, entry_id):
            # returns empty list [] when no entry was found
            return [entry for entry in self.entries if entry.entry_id == entry_id]

        def getLastEntryById(self, entry_id):
            matches = self.getEntriesById(entry_id)
            if not matches:
                return None
            return matches[-1]

        def getEntriesByIdValue(self, entry_id, value):
            # returns empty list [] when no entry was found
            return [entry for entry in self.entries if entry.entry_id == entry_id and entry.value == value]

        def getLastEntryByIdValue(self, entry_id, value):
            matches = self.getEntriesByIdValue(entry_id, value)
            if not matches:
                return None
            return matches[-1]

        def entryExists(self, entry_id):
            return any(entry.entry_id == entry_id for entry in self.entries)




    class ProtocolEntry:
        def __init__(self, entry_id, value = True, additional_data=None):
            if config.developer == True:
                assert isinstance(entry_id, str), "entry_id needs to be a string"
                if value:
                    assert (isinstance(value, str) or isinstance(value, int) or isinstance(value, boolean)), "The value for a protocol entry needs to be a boolean, a string or an integer. Maybe you want to use additional_data for some more complex data."
                if additional_data:
                    assert (isinstance(additional_data, dict) or isinstance(additional_data, list)), "additional_data needs to be a dictionary or a list."

            self.entry_id = entry_id    # eine string- oder int-basierte ID
            self.value = value          # a possible value for the protocol entry
            self.additional_data = additional_data            # can be anything which may be needed for later

        def __repr__(self):
            return f"<ProtocolEntry id={self.entry_id}, data={self.data}>"

        def get_protocol_value(self):
            return self.value