python:
    '''
        @file - collects information about player's characters stats and players choices for his character
    '''

define kink_feet = 'feet'
define kink_armpits = 'armpits'
define allowed_kinks = [kink_feet, kink_armpits]

define kink_choice_yes = 'yes'
define kink_choice_no = 'no'
define kink_choice_nomatter = 'nomatter'
define allowed_kink_choices = [kink_choice_yes, kink_choice_no, kink_choice_nomatter]

default PlayerStats = PlayerStatsClass()

init -1 python:
    class PlayerStatsClass:
        def __init__(self):
            self.lust = 0    # at the moment just a counter for lust rising actions
            self.kinks = {}

        def add_kink(self, kink_id, kink_choice):
            if config.developer == True:
                assert isinstance(kink_id, str), "kink_id needs to be a string"
                assert kink_id in allowed_kinks, kink_id + " is not an allowed kink"
                assert isinstance(kink_choice, str), "kink_choice needs to be a string"
                assert kink_choice in allowed_kink_choices, kink_choice + " is not an allowed kink choice"
            
            self.kinks.update({kink_id: kink_choice})

        ### 
        ### we only hide a kink if the player chose so
        def kink_show(self, kink_id):
            if config.developer == True:
                assert isinstance(kink_id, str), "kink_id needs to be a string"
                assert kink_id in allowed_kinks, kink_id + " is not an allowed kink"
            kink_choice = self.get_kink_choice(kink_id)
            if kink_choice and kink_choice == kink_choice_no:
                return False
            return True

            
        def get_kink_choice(self, kink_id):
            if config.developer == True:
                assert isinstance(kink_id, str), "kink_id needs to be a string"
                assert kink_id in allowed_kinks, kink_id + " is not an allowed kink"

            return self.kinks.get(kink_id, None)

        def add_lust(self):
            self.lust += 1

        def reset_lust(self):
            self.lust = 0

        def get_lust(self):
            return self.lust

### 
### Helper to let the player set a kink
###
label l_kink_detection(text_menu, kink_id):
    menu:
        "[text_menu]"(prompt=True, description="You can set here your personal preference if you want to see more of this kind of kink / content in future."):
            pass
        "Yes, show me more of this.":
            $ PlayerStats.add_kink(kink_id, kink_choice_yes)
        "I don't care / surprise me":
            $ PlayerStats.add_kink(kink_id, kink_choice_nomatter)
        "No - this is not my kink and I don't want to see content related to it.":
            $ PlayerStats.add_kink(kink_id, kink_choice_no)

    return