init -1:
    define CharactersManager = CharacterManagerClass()

init -10 python:

    #########
    ######### This class is for managing characters, their classes and to validate charcter Ids
    class CharacterManagerClass:
        def __init__(self):
            self.charactersInGame = {}

        def registerCharacter(self, charid):
            if config.developer == True:
                assert isinstance(charid, str), "charid needs to be a string"
            self.charactersInGame.update({charid: charid})

        def isValidCharid(self, charid):
            if config.developer == True:
                assert isinstance(charid, str), "charid needs to be a string"
            return charid in self.charactersInGame

        #### get the character related class by his short charid
        #### type_of_class can be Character, Relationship, Schedule, ContactInfo, ContactInteractions
        def getCharacterClassByName(self, charid: str, type_of_class="Character"):
            if config.developer == True:
                assert isinstance(charid, str), "charid needs to be a string"
                assert CharactersManager.isValidCharid(charid), charid + " is not a valid charid"
                assert (type_of_class in ["Character", "Corruption", "BubbleSetting", "SceneInfo"]), f"{type_of_class} is not a valid value"

            charid = charid.lower()
            if type_of_class =="Character":
                class_name = f"{charid}"
            elif type_of_class =="Corruption":
                class_name = f"{charid}Corruption"
            elif type_of_class == 'BubbleSetting':
                class_name = f"{charid}BubbleSetting"
            elif type_of_class == 'SceneInfo':
                class_name = f"{charid}SceneInfo"

            return globals()[class_name]       