define max_value_corruption = 40
define max_value_annoyance = 40

define action_result_harsh = 'harsh'  # klare ablehung und zurechtweisung
define action_result_rejection = 'rejection' # ablehung, bitte grenzen zu respektieren
define action_result_neutral= 'neutral' # keine klare reaktion
define action_result_accept = 'accept'  # grinsen, spruch auf gleichem level zurück 
define action_result_allin = 'allin'    # npc greift auf und teibt selbst voran

# all values are >=
define reaction_score_harsh = 2
define reaction_score_rejection = 1
define reaction_score_neutral = 0
define reaction_score_accept = -1
# < -1 -> all in

init python:
    import random

    class CharacterCorruptionClass(object):
        def __init__(self, charid, corruption=0, annoyance=0, personality="neutral"):
            self.charid = charid
            # Werte 0..39
            self.corruption = int(max(0, min(max_value_corruption, corruption)))
            self.annoyance = int(max(0, min(max_value_annoyance, annoyance)))
            self.personality = personality   # ob der charakter eher corrupt oder aware reagiert

            # Änderungen
            self.context_mods = None
            self.action_level = None

            self.corruption_change = 0
            self.annoyance_change = 0
            self.reaction_score = 0
            self.result = ''

        def level(self, value):
            """0..3"""
            return min(value // 10, 3)

        @property
        def corruption_level(self):
            return self.level(self.corruption)

        @property
        def annoyance_level(self):
            return self.level(self.annoyance)

        def calculate_action_result(self, action_level, context_mods=None):
            """
            action_level: 0..3
            context_mods: optional dict, z.B.
                {
                    "others_present": {"c_mult":0.8, "a_mult":1.3},
                    "drink_given": {"c_mult":1.5, "a_mult":0.7}
                }
            Gibt zurück: 'harsch', 'ablehnung', 'neutral', 'annehmen', 'darauf_einsteigen'
            Nach Aufruf sind self.corruption_change / self.annoyance_change gesetzt.
            """
            self.action_level = action_level
            self.context_mods = context_mods or {}

            ## reset
            self.corruption_change = 0
            self.annoyance_change = 0
            self.reaction_score = 0
            self.result = ''

            # Personality-Modifier
            personality_mods = {
                "shy": {"c_mult": 0.5, "a_mult": 1.5, "tolerance_mod": -1},
                "neutral": {"c_mult": 1.0, "a_mult": 1.0, "tolerance_mod": 0},
                "bold": {"c_mult": 1.2, "a_mult": 0.75, "tolerance_mod": 1},
            }
            mods = personality_mods.get(self.personality, personality_mods["neutral"])
            total_c_mult = mods["c_mult"]
            total_a_mult = mods["a_mult"]
            tolerance_mod = mods["tolerance_mod"]

            # Kontext-Modifikatoren multiplizieren
            context_c_mult = 1.0
            context_a_mult = 1.0
            for m in self.context_mods.values():
                context_c_mult *= m.get("c_mult", 1.0)
                context_a_mult *= m.get("a_mult", 1.0)

            total_c_mult *= context_c_mult
            total_a_mult *= context_a_mult

            # --- Einfluss von Annoyance ---
            annoyance_factor = 1 + (self.annoyance / 10.0)   # je höher, desto stärker Ablehnung
            corruption_resist = 1 - min(0.8, self.annoyance / 20.0)  
            # dämpft Corruption-Steigerung (bei hoher Annoyance fast null)

            # Reaction-Score (feiner Diff in Punkten)
            diff_points = (action_level * 10 - self.corruption) / 10.0
            if diff_points > 0:
                # Aktion über aktuellem Korruptionslevel
                self.reaction_score = diff_points * annoyance_factor - tolerance_mod * 0.5
            else:
                self.reaction_score = diff_points * (1 + self.annoyance / 10.0)

            # Basis-Annoyance für Werteupdate
            delta_a = int(round((action_level + 1) * total_a_mult))

            # Score auf 5 Reaktionsstufen abbilden
            if self.reaction_score >= reaction_score_harsh:
                delta_c = -2
                delta_a = int(delta_a * 1.5)
                self.result = action_result_harsh
            elif self.reaction_score >= reaction_score_rejection:
                delta_c = -1
                delta_a = int(delta_a * 1.2)
                self.result = action_result_rejection
            elif self.reaction_score >= reaction_score_neutral:
                delta_c = 1
                delta_a = int(delta_a * 0.8)
                self.result = action_result_neutral
            elif self.reaction_score >= reaction_score_accept:
                delta_c = 2
                delta_a = -1
                self.result = action_result_accept
            else:
                delta_c = 2
                delta_a = -2
                self.result = action_result_allin

            # Personality + Context auf Corruption anwenden
            delta_c = int(round(delta_c * total_c_mult * corruption_resist))

            # --- Progressions-Deckel ---
            corruption_level = self.corruption // 10  # 0..3
            if corruption_level >= action_level + 1:
                delta_c = 0
                delta_a = 0

            self.set_corruption_change(delta_c)
            self.set_annoyance_change(delta_a)

            return self.result

        def change_value(self):
            self.corruption = min(max_value_corruption, max(0, self.corruption + self.corruption_change))
            self.annoyance = min(max_value_annoyance, max(0, self.annoyance + self.annoyance_change))

            self.corruption_change = 0
            self.annoyance_change = 0

        def is_corrupted(self):
            return self.corruption >= max_value_corruption

        def get_corruption_bar_color(self):
            if self.corruption_level == 0:
                return "#810707"
            elif self.corruption_level == 1:
                return "#622ce0"
            elif self.corruption_level == 2:
                return "#2c9ee0"
            elif self.corruption_level == 3:
                return "#2ce0d191"
            else:
                return '#188f18'

        def get_annoyance_bar_color(self):
            return '#188f18'

        def set_annoyance_change(self, delta_a):
            if delta_a < 0 and self.annoyance == 0:
                self.annoyance_change = 0
            else:
                self.annoyance_change = delta_a
            
        def set_corruption_change(self, delta_c):
            if delta_c < 0 and self.annoyance == 0:
                self.corruption_change = 0
            else:
                self.corruption_change = delta_c

        def protocol_last_action(self, action_id, action_group):
            new_protocol = ActionProtocolEntry(self.charid, action_id, action_group, self.action_level, self.result, self.reaction_score)
            actionProtocol.add_entry(new_protocol)