
define action_group_under_shower_apologized = 'under_shower_apologized'
define action_group_under_shower_keep_company = 'under_shower_keep_company'
define action_group_under_shower_join = 'under_shower_join'
define action_group_glance_naked_dick = 'glance_naked_dick'
define action_group_apologize_afterwards = 'apologizes_afterwards'
define action_group_compliment_body = 'compliment_body'
define action_group_caught_by_diego = 'caught_by_diego'
define action_group_runaround_naked_with_boner = 'runaround_naked_with_boner'  # selbstsicher, offen
define action_group_hide_boner = 'hide_boner'  # any attempt to hide a boner
define action_group_excuse = 'excuse'  # ausrede
define action_group_appease = 'appease'  # beschwichtigen
define action_group_offensive = 'offensive'  # offensiver spruch
define action_group_offensive_grab_crotch = 'offensive_grab_crotch'  # offensiver spruch mit griff in den eignen schritt
define action_group_silent = 'silent'  # nichts sagen, kopf in den sand stecken
define allowed_action_groups = [action_group_under_shower_keep_company, action_group_under_shower_apologized, action_group_glance_naked_dick, action_group_under_shower_join, action_group_apologize_afterwards, action_group_compliment_body, action_group_caught_by_diego, action_group_runaround_naked_with_boner, action_group_excuse, action_group_appease, action_group_offensive, action_group_offensive_grab_crotch, action_group_silent, action_group_hide_boner]

default actionProtocol = ActionProtocol()

init -10 python:
    # Ein einzelner Protokolleintrag
    class ActionProtocolEntry:
        def __init__(self, charid, action_id, action_group, action_level, result, reaction_score):
            if config.developer:
                assert isinstance(charid, str), "charid needs to be a string"
                assert isinstance(action_id, str), "action_id needs to be a string"
                assert isinstance(action_group, str), "action_group needs to be a string"
                assert isinstance(result, str), "result needs to be a string"
                assert isinstance(action_level, int), "action_level needs to be an integer"
                assert isinstance(reaction_score, float), "reaction_score needs to be a float"

                assert CharactersManager.isValidCharid(charid), charid + " is not a valid character"
                assert action_group in allowed_action_groups, action_group + " is not an allowed action group"
            self._charid = charid
            self._action_id = action_id
            self._action_group = action_group
            self._action_level = action_level
            self._result = result
            self._reaction_score = reaction_score

        # Getter
        def get_charid(self):
            return self._charid

        def get_action_id(self):
            return self._action_id

        def get_action_group(self):
            return self._action_group

        def get_action_level(self):
            return self._action_level

        def get_result(self):
            return self._result

        def get_reaction_score(self):
            return self._reaction_score

        def __repr__(self):
            return f"<ProtocolEntry char={self._charid}, action={self._action_id}, action_group={self._action_group}m level={self._action_level}, result={self._result}, score={self._reaction_score}>"

    # Verwaltung der Protokolle
    class ActionProtocol:
        def __init__(self):
            self._entries = []

        def add_entry(self, entry):
            """Fügt einen neuen Eintrag in chronologischer Reihenfolge hinzu."""
            self._entries.append(entry)

        def get_char_protocol(self, charid, action_id=None, action_group=None, result=None, action_level=None):
            """
            Liefert alle Protokolle für eine bestimmte charid.
            Optional: nach action_id, result und action_level filtern.
            """
            return [
                e for e in self._entries
                if e.get_charid() == charid
                and (action_id is None or e.get_action_id() == action_id)
                and (result is None or e.get_result() == result)
                and (action_level is None or e.get_action_level() == action_level)
                and (action_group is None or e.get_action_group() == action_group)
            ]

        def get_action_protocol(self, action_id, action_group=None, charid=None, result=None, action_level=None):
            """
            Liefert alle Protokolle für eine bestimmte action_id.
            Optional: nach charid, result und action_level filtern.
            """
            return [
                e for e in self._entries
                if e.get_action_id() == action_id
                and (charid is None or e.get_charid() == charid)
                and (result is None or e.get_result() == result)
                and (action_level is None or e.get_action_level() == action_level)
                and (action_group is None or e.get_action_group() == action_group)
            ]
        def get_last_char_protocol(self, charid, action_id=None, action_group=None, result=None, action_level=None):
            """Gibt den letzten passenden Eintrag für einen Character zurück oder None."""
            matches = self.get_char_protocol(charid, action_id, action_group, result, action_level)
            return matches[-1] if matches else None

        def get_last_action_protocol(self, action_id, action_group=None, charid=None, result=None, action_level=None):
            """Gibt den letzten passenden Eintrag für eine Action zurück oder None."""
            matches = self.get_action_protocol(action_id, action_group, charid, result, action_level)
            return matches[-1] if matches else None

        def __repr__(self):
            return f"<ActionProtocol entries={len(self._entries)}>"
