init python:
    import renpy.character as character
    def get_character_name(characterClass):
        if config.developer:
            assert isinstance(characterClass, character.ADVCharacter) , 'characterClass needs to be an instance of character.ADVCharacter'
        name = ''
        if callable(characterClass.name):
            callable_class = characterClass.name()
            name = callable_class()
        else:
            name = Text(characterClass.name, None, None, True).get_all_text()

        return name

label l_next_daytime:
    scene blackscreen with dissolve
    play sound sound_ticking fadein 0.5 volume 0.5
    show screen s_show_text(GameManager.getTimeString()) with dissolve
    $ renpy.pause(1.5, hard=True)
    hide screen s_show_text with dissolve
    $ GameManager.next_daytime()
    show screen s_show_text(GameManager.getTimeString()) with dissolve
    $ renpy.pause(2.0, hard=True)
    hide screen s_show_text with dissolve
    stop sound fadeout 0.5
    return

label l_change_location(text=None):
    scene blackscreen with dissolve
    play sound sound_ticking fadein 0.5 volume 0.5

    if text:
        show screen s_show_text(text) with dissolve
        $ renpy.pause(4.0, hard=True)
        hide screen s_show_text with dissolve
    else:
        $ renpy.pause(3.0, hard=True)
    stop sound fadeout 0.5
    $ renpy.pause(0.5, hard=True)
    return

label show_free_game_screens:
    show screen player_stats_screen
    return

label hide_free_game_screens:
    hide screen player_stats_screen
    return

label l_get_dressed(new_clothing = None):
    scene blackscreen with dissolve
    play sound sound_cloth_1
    pause(1.0)
    play sound sound_zipper

    python:
        if new_clothing:
            pabloSceneInfo.setClothing(new_clothing)
    return

label l_undress(new_clothing = None):
    play sound sound_zipper
    scene blackscreen with dissolve
    pause(1.0)
    play sound sound_cloth_2

    python:
        if new_clothing:
            pabloSceneInfo.setClothing(new_clothing)
    return

python:
    def set_mouse_for_animation(seconds, pointer_type = "no_interaction"):
        global default_mouse
        default_mouse =  "no_interaction"
        renpy.pause(seconds, hard=True)
        default_mouse = None