(begin-module 'flexgui)
(module-export '(
  flexlay
  lgfx
  ;;
  parse-layout
  ;;
  new-gui-event
  route-sdl-event
  ;; reset mouse and keyboard modifier flags
  reset-modifiers
  ;;
  post-event
  post-broadcast-event
  process-event-queue
  ;;
  desktop ;; WARNING! do not manually modify this object! it is exposed only for debug reasons.
  ;;
  append-window
  center-window ;; should be already added
  desktop-empty?
  draw-desktop
  close-all-windows
  ;;
  find-window-by-id
  ;;
  register-style
  ;;
  need-repaint?
  need-repaint-reset!
  ;;
  simple-item-object
  ;;
  HORIZ
  VERT
  ;;
  ;; constants, to not depend on SDL in widget code
  BUTTON-LEFT
  BUTTON-RIGHT
  BUTTON-MIDDLE
  BUTTON-LEFT-MASK
  BUTTON-RIGHT-MASK
  BUTTON-MIDDLE-MASK
  KMOD-LEFT-SHIFT-MASK
  KMOD-RIGHT-SHIFT-MASK
  KMOD-SHIFT-MASK
  KMOD-LEFT-ALT-MASK
  KMOD-RIGHT-ALT-MASK
  KMOD-ALT-MASK
  KMOD-LEFT-CTRL-MASK
  KMOD-RIGHT-CTRL-MASK
  KMOD-CTRL-MASK
  KMOD-LEFT-HYPER-MASK
  KMOD-RIGHT-HYPER-MASK
  KMOD-HYPER-MASK
))
(import '(
  ::sdl
))

(constant debug-layout-time #f)
(constant debug-render-time #f)

define do-layout(root)
  define stt (if debug-layout-time ticks-msec() 0)
  flexlay:layout root
  if debug-layout-time
    then
      {stt := {ticks-msec() - stt}}
      printf "layout time: %,d milliseconds.\n" stt


(require 'flexlay)

(constant HORIZ flexlay:HORIZ)
(constant VERT flexlay:VERT)

;(printf "loading flexgui...\n")
(load "flexgui-10-lgfx.lsp")
(load "flexgui-20-event.lsp")
(load "flexgui-26-widget-list.lsp")
(load "flexgui-28-styles.lsp")
(load "flexgui-29-default-styles.lsp")
(load "flexgui-30-basic-widget.lsp")
(load "flexgui-36-widgets-10-simple.lsp")
(load "flexgui-36-widgets-20-containers.lsp")
(load "flexgui-38-widgets-10-titlebar.lsp")
(load "flexgui-38-widgets-20-window-frame.lsp")
(load "flexgui-40-widgets-10-button.lsp")
(load "flexgui-40-widgets-12-radio.lsp")
(load "flexgui-40-widgets-14-checkbox.lsp")
(load "flexgui-40-widgets-20-listbox.lsp")
(load "flexgui-40-widgets-30-editline.lsp")
(load "flexgui-40-widgets-40-scrollbar.lsp")
(load "flexgui-40-widgets-50-textbox.lsp")
(load "flexgui-50-desktop.lsp")
(load "flexgui-60-sdl-events.lsp")
;(printf "flexgui loaded.\n")


define parse-layout(list)
  define res flexlay:parse-layout(create-widget list)
  invoke res %setup-style-defaults:
  res

(end-module 'flexgui)
