(require 'pp)
(load "flexgui-main.lsp")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
define create-layout()
  flexgui:parse-layout
    window-frame:
      style: 'normal-window
      title-bar: text: "Button Test"
      ;activate-widget: "lbox-0" ;; activate this widget when the window is created
      ;pref-width: 400
      ;pref-width: 570
      ;pref-height: 370
      v-container: inset: 2
        spring: default:
        v-container:
          label: text: "Radio Group 1"
          padding: default:
          radio:
            id: "radio-1-1"
            text: "choice ~1"
            hotkey: "M-1"
            group: "radio-1"
            on-change:
              lambda (self new-value)
                printf "radio-1: item 1 %s!\n" (if new-value "set" "reset")
          padding: default:
          radio:
            id: "radio-1-2"
            text: "choice ~2"
            hotkey: "M-2"
            group: "radio-1"
            on-change:
              lambda (self new-value)
                printf "radio-1: item 2 %s!\n" (if new-value "set" "reset")
          padding: default:
          radio:
            id: "radio-1-3"
            text: "choice ~3"
            hotkey: "M-3"
            group: "radio-1"
            on-change:
              lambda (self new-value)
                printf "radio-1: item 3 %s!\n" (if new-value "set" "reset")
        ;
        spring: default:
        padding: default:
        v-container:
          label: text: "Radio Group 2"
          padding: default:
          radio:
            id: "radio-2-1"
            text: "choice 1"
            group: "radio-2"
          padding: default:
          radio:
            id: "radio-2-2"
            text: "choice 2"
            group: "radio-2"
          padding: default:
          radio:
            id: "radio-2-3"
            text: "choice 3"
            group: "radio-2"
        ;
        spring: default:
        padding: default:
        v-container:
          label: text: "Checkboxes"
          padding: default:
          checkbox:
            id: "check-1"
            text: "checkbox 1"
            on-change:
              lambda (self new-value)
                printf "check-1: %s!\n" (if new-value "set" "reset")
          padding: default:
          checkbox:
            id: "check-2"
            text: "checkbox 1"
            on-init:
              lambda (self)
                {self[mark:] := #t}
          padding: default:
          checkbox:
            id: "check-3"
            text: "checkbox 3"
        ;
        spring: default:
        padding: default:
        h-container:
          spring: default:
          button: text: "~Quit"
            hotkey: "M-q"
            escape: #t
            action:
              lambda (self)
                (sdl:post-quit-event)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
define main-test()
  flexgui:lgfx:open-window {1156 div 2} {760 div 2} "Flexlay Test SDL" 2
  ;;
  define need-show #t
  define main-win create-layout()
  main-win[initialize:]
  flexgui:append-window main-win
  flexgui:center-window main-win
  ;;
  define render-screen()
    ;printf "repaint!\n"
    {need-show := #f}
    flexgui:lgfx:set-draw-color #@color:#000
    flexgui:lgfx:clear()
    flexgui:draw-desktop()
    flexgui:lgfx:present()
  ;;
  define process-event(evt)
    define gevt flexgui:route-sdl-event(evt)
    if {{null? gevt} or gevt[alive?:]}
      case (sdl:event-type evt)
        (QUIT)
          #f
        (KEY-DOWN)
          case (sdl:event-scan-name evt)
            ;(ESCAPE)
            ;  (lgfx:close-window)
            ;  #f
            (X)
              if {evt sdl:event-scan? "M-x"}
                then
                  (sdl:post-quit-event)
                  #f
                #t
            else
              #t
        (WINDOW)
          if {(sdl:event-window-action evt) eq? 'EXPOSED}
            {need-show := #t}
          #t
        else
          #t
      else
        if {{not need-show} and gevt[dirty?:]}
          {need-show := #t}
        #t
  ;;
  define evt (sdl:wait-event evt)
  while {flexgui:lgfx:window?() and {not flexgui:desktop-empty?()} and process-event(evt)}
    if {need-show or flexgui:need-repaint?()}
      render-screen()
    if {not flexgui:desktop-empty?()}
      {evt := (sdl:wait-event evt)}
  ;;
  define srb main-win[radio-get-marked: "radio-1"]
  if {not-null? srb}
    printf "radio-1: %s\n" srb[id:]
  {srb := main-win[radio-get-marked: "radio-2"]}
  if {not-null? srb}
    printf "radio-2: %s\n" srb[id:]
  ;;
  flexgui:lgfx:close-window()


(main-test)
