;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; window title bar
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
register-widget title-bar:
  lambda title-bar-ctor ()
    define super new-basic-widget()
    ;;
    method-lambda title-widget
      super: (self)
        ;printf "me=%d; title-super: %d\n" box-debug-id(title-widget) box-debug-id(super)
        super
      type: (self)
        title-bar:
      real-text-color: (self)
        if self[active-window?:]
          self[style-prop: text-color:]
          self[style-prop: text-color-inactive:]
      real-back-color: (self)
        define bc
        cond
          self[active-window?:]
            {bc := self[style-prop: back-color:]}
            if {zero? sdl:color-a(bc)}
              self[top-widget:][real-frame-color:]
              bc
          else
            {bc := self[style-prop: back-color-inactive:]}
            if {zero? sdl:color-a(bc)}
              self[top-widget:][real-frame-color:]
              bc
      ;;
      paint: (self)
        define wdt self[final-width:]
        define hgt self[final-height:]
        lgfx:fill-rect 0 0 wdt {hgt - 1} self[real-back-color:]
        define text self[text:]
        define x0 {{wdt - lgfx:text-width(text)} div 2}
        lgfx:print-str x0 lgfx:text-ascender() text self[real-text-color:]
        self
      ;;
      handle-event: (self evt)
        if evt[alive?:]
          case evt[type:]
            (MOUSE-DOWN)
              if {zero? mouse-button-state}
                self[top-widget:][start-mouse-moving:]
            else
              inherited handle-event: evt
      ;;
      else
        super
