;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; default styles
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
register-style 'normal-window
  ;; here go common properties for all widgets.
  ;; font does nothing for now, it just sits here.
  font-name: "my-font"
  font-size: 10
  ;; widget properties
  ;;
  widget: window-frame:
    frame-color: #@color:#fff
    back-color: #@color:#040
    frame-color-inactive: #@color:#888
    back-color-inactive: #@color:#002A00
    inactive-shade: #x70
    ;; default values for known widget properties
    defaults:
      direction: vert:
      inset-left: 1
      inset-right: 1
      inset-top: 1
      inset-bottom: 1
  ;;
  widget: title-bar:
    back-color: #@color:transparent
    text-color: #@color:#000
    back-color-inactive: #@color:transparent
    text-color-inactive: #@color:#000
    defaults:
      pref-height:
        lambda (self) ;; "self" is widget
          {lgfx:text-height() + 2}
      min-height:
        lambda (self) ;; "self" is widget
          {lgfx:text-height() + 2}
      max-height:
        lambda (self) ;; "self" is widget
          {lgfx:text-height() + 2}
  ;;
  widget: padding:
    defaults:
      size: 2
  ;;
  widget: spring:
    defaults:
      flex: 1
  ;;
  widget: label:
    text-color: #@color:#fff
    hi-color: #@color:#0cc
    defaults:
      pref-width: 42
      pref-height:
        lambda (self) ;; "self" is widget
          lgfx:text-height()
  ;;
  widget: containers:
    frame-color: #@color:transparent
    back-color: #@color:transparent
  ;;
  widget: v-container:
    inherit: containers:
    defaults:
      direction: vert:
  widget: h-container:
    inherit: containers:
    defaults:
      direction: horiz:
  ;;
  widget: button:
    text-color: #@color:#004
    hi-color: #@color:#800
    back-color: #@color:#fff
    text-color-inactive: #@color:#000
    hi-color-inactive: #@color:#700
    back-color-inactive: #@color:#ccc
    defaults:
      pref-width: 24
      pref-height:
        lambda (self) ;; "self" is widget
          {lgfx:text-height() + 2}
  ;;
  widget: radio:
    text-color: #@color:#fff
    hi-color: #@color:#0e0
    mark-color: #@color:#0f6
    text-color-inactive: #@color:#0dd
    hi-color-inactive: #@color:#0d0
    mark-color-inactive: #@color:#0c3
    defaults:
      pref-width: 24
      pref-height:
        lambda (self) ;; "self" is widget
          {lgfx:text-height() + 2}
  ;;
  widget: checkbox:
    text-color: #@color:#fff
    hi-color: #@color:#0e0
    mark-color: #@color:#0f6
    text-color-inactive: #@color:#0dd
    hi-color-inactive: #@color:#0d0
    mark-color-inactive: #@color:#0c3
    defaults:
      pref-width: 24
      pref-height:
        lambda (self) ;; "self" is widget
          {lgfx:text-height() + 2}
  ;;
  widget: listbox:
    frame-color: #@color:#fff
    back-color: #@color:#000
    text-even-color: #@color:#ff0
    text-odd-color: #@color:#bb0
    text-selection-color: #@color:#000
    back-selection-color: #@color:#0cc
    frame-color-inactive: #@color:#ccc
    back-color-inactive: #@color:#000
    text-even-color-inactive: #@color:#cc0
    text-odd-color-inactive: #@color:#990
    text-selection-color-inactive: #@color:#000
    back-selection-color-inactive: #@color:#0aa
    defaults:
      min-height:
        lambda (self) ;; "self" is widget
          {lgfx:text-height() + 2}
      pref-width: 96
      pref-height:
        lambda (self) ;; "self" is widget
          {{lgfx:text-height() * 12} + 2}
  ;;
  widget: editline:
    frame-color: #@color:#fff
    back-color: #@color:#000
    cursor-color: #@color:#0f0
    text-initial-color: #@color:#0ff
    text-color: #@color:#ff0
    read-only-color: #@color:#bbb
    frame-color-inactive: #@color:#ccc
    back-color-inactive: #@color:#000
    cursor-color-inactive: #@color:#0c0
    text-initial-color-inactive: #@color:#0cc
    text-color-inactive: #@color:#cc0
    read-only-color-inactive: #@color:#bbb
    defaults:
      min-width:
        lambda (self) ;; "self" is widget
          {lgfx:text-width("WW") + 4}
      min-height:
        lambda (self) ;; "self" is widget
          {lgfx:text-height() + 2}
      pref-width: 128
      pref-height:
        lambda (self) ;; "self" is widget
          {lgfx:text-height() + 2}
  ;;
  widget: scrollbar:
    frame-color: #@color:#fff
    full-color: #@color:#fff
    empty-color: #@color:#666
    frame-color-inactive: #@color:#fff
    full-color-inactive: #@color:#fff
    empty-color-inactive: #@color:#666
    defaults:
      min-width: 4
      min-height: 4
  ;;
  widget: v-scrollbar:
    inherit: scrollbar:
    defaults:
      direction: VERT
      pref-width: 8
      pref-height: 64
  ;;
  widget: h-scrollbar:
    inherit: scrollbar:
    defaults:
      direction: HORIZ
      pref-width: 64
      pref-height: 8
  ;;
  widget: textbox:
    frame-color: #@color:#eee
    back-color: #@color:#000
    text-color: #@color:#f80
    frame-color-inactive: #@color:#ccc
    back-color-inactive: #@color:#000
    text-color-inactive: #@color:#f80
    defaults:
      min-width:
        lambda (self) ;; "self" is widget
          {{lgfx:text-width("W") * 32} + 4}
      min-height:
        lambda (self) ;; "self" is widget
          {{lgfx:text-height() * 6} + 4}
      pref-width:
        lambda (self) ;; "self" is widget
          {{lgfx:text-width("W") * 32} + 4}
      pref-height:
        lambda (self) ;; "self" is widget
          {{lgfx:text-height() * 6} + 4}


register-style 'error-box
  base-style: 'normal-window
  ;; widget overrides
  widget: window-frame:
    back-color: #@color:#c00
    back-color-inactive: #700
  ;;
  widget: label:
    text-color: #@color:#ff0
    defaults:
      min-width: 128
