;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define known-widgets #nil)

define register-widget(type ctor)
  assert {keyword? type} "invalid widget type keyword"
  assert {procedure? ctor} "invalid widget constructor"
  gset! known-widgets cons(cons(type ctor) known-widgets)
  #void


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; #nil if widget type is not known
define create-widget(parent type)
  assert {keyword? type} "invalid widget type keyword"
  define wg #nil
  define qp assq(type known-widgets)
  if {pair? qp}
    then
      ;printf "creating: %o\n" type
      {wg := cdr(qp)()}
      ;printf "cw: %o -- %o\n" type invoke(wg type:)
      if {{not-null? wg} and {not-null? parent}}
        parent[append-child: wg]
  wg
