
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define quit-requested #f)

define run-gui-loop(exit-checker)
  define need-show #t
  ;;
  define render-screen()
    ;printf "repaint!\n"
    {need-show := #f}
    flexgui:lgfx:set-draw-color #@color:#000
    flexgui:lgfx:clear()
    flexgui:draw-desktop()
    flexgui:lgfx:present()
  ;;
  define process-event(evt)
    define gevt flexgui:route-sdl-event(evt)
    if {{null? gevt} or gevt[alive?:]}
      case (sdl:event-type evt)
        (QUIT)
          gset! quit-requested #t
          #f
        (KEY-DOWN)
          case (sdl:event-scan-name evt)
            ;(ESCAPE)
            ;  (lgfx:close-window)
            ;  #f
            (X)
              if {evt sdl:event-scan? "M-x"}
                then
                  (sdl:post-quit-event)
                  gset! quit-requested #t
                  #f
                #t
            else
              #t
        (WINDOW)
          if {(sdl:event-window-action evt) eq? 'EXPOSED}
            {need-show := #t}
          #t
        else
          #t
      else
        if {{not need-show} and gevt[dirty?:]}
          {need-show := #t}
        #t
  ;;
  gset! quit-requested #f
  render-screen()
  define evt (sdl:wait-event evt)
  while (and flexgui:lgfx:window?()
             {not quit-requested}
             {not flexgui:desktop-empty?()}
             {{null? exit-checker} or {not exit-checker()}}
             process-event(evt))
    if {need-show or flexgui:need-repaint?()}
      render-screen()
    if {not flexgui:desktop-empty?()}
      {evt := (sdl:wait-event evt)}
  if quit-requested
    lgfx:close-window()


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(load "bd-80-gui-10-options.lsp")
(load "bd-80-gui-70-select-cave.lsp")
(load "bd-80-gui-80-select-game.lsp")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
define game-select-gui()
  define need-show #t
  flexgui:close-all-windows()
  define main-win new-game-select-window()
  fill-listbox main-win "lbox-0"
  flexgui:append-window main-win
  gset! selected-game-id #f
  gset! selected-cave-index #f
  gset! action-replay-data #nil
  gset! action-replay-otypes #nil
  run-gui-loop #nil
