;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
define new-options-window()
  define win
    flexgui:parse-layout
      window-frame:
        style: 'normal-window
        title-bar: text: string-append("Game Options")
        ;min-width: 128
        ;pref-width: 440
        on-key-down:
          lambda (self evt)
            if sdl:names-equal?("escape" evt[keysym:])
              then
                self[close-window:]
                evt[eat!:]
        on-window-blur:
          lambda (self evt)
            self[close-window:]
        ;
        v-container: inset: 2
          h-container:
            ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
            ;; camera shake group
            v-container: inset: 2
              over-style:
                properties:
                  frame-color: #@color:#ddd
                  back-color: #@color:#030
              label: text: "Camera Shake"
              padding: size: 4
              checkbox:
                id: "explosion-shake"
                text: "~Explosion"
                hotkey: "M-e"
                on-init:
                  lambda (self)
                    self[mark-set!: player-prop-ref-bool("camera-explosion-shake" #t)]
                on-change:
                  lambda (self new-value)
                    player-prop-set! "camera-explosion-shake" new-value
              checkbox:
                id: "exit-opened-shake"
                text: "E~xit opened"
                hotkey: "M-x"
                on-init:
                  lambda (self)
                    self[mark-set!: player-prop-ref-bool("camera-exit-opened-shake" #t)]
                on-change:
                  lambda (self new-value)
                    player-prop-set! "camera-exit-opened-shake" new-value
              checkbox:
                id: "death-explosion-shake"
                text: "Player ~death"
                hotkey: "M-d"
                on-init:
                  lambda (self)
                    self[mark-set!: player-prop-ref-bool("camera-death-explosion-shake" #f)]
                on-change:
                  lambda (self new-value)
                    player-prop-set! "camera-death-explosion-shake" new-value
              checkbox:
                id: "hatch-shake"
                text: "Player ~hatch"
                hotkey: "M-h"
                on-init:
                  lambda (self)
                    self[mark-set!: player-prop-ref-bool("camera-hatch-shake" #t)]
                on-change:
                  lambda (self new-value)
                    player-prop-set! "camera-hatch-shake" new-value
              spring: default:
            ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
            ;; speed group
            padding: default:
            v-container: inset: 2
              over-style:
                properties:
                  frame-color: #@color:#ddd
                  back-color: #@color:#030
              label: text: "Scroll Speed"
              padding: size: 4
              radio:
                group: "scroll-speed"
                text: "~1 pixel"
                hotkey: "M-1"
                on-init:
                  lambda (self)
                    self[mark-set!: {player-prop-ref("camera-scroll-speed" 1) = 1}]
                on-change:
                  lambda (self new-value)
                    if new-value
                      player-prop-set! "camera-scroll-speed" 1
              radio:
                group: "scroll-speed"
                text: "~2 pixels"
                hotkey: "M-2"
                on-init:
                  lambda (self)
                    self[mark-set!: {player-prop-ref("camera-scroll-speed" 1) = 2}]
                on-change:
                  lambda (self new-value)
                    if new-value
                      player-prop-set! "camera-scroll-speed" 2
              radio:
                group: "scroll-speed"
                text: "~4 pixels"
                hotkey: "M-4"
                on-init:
                  lambda (self)
                    self[mark-set!: {player-prop-ref("camera-scroll-speed" 1) = 4}]
                on-change:
                  lambda (self new-value)
                    if new-value
                      player-prop-set! "camera-scroll-speed" 4
              radio:
                group: "scroll-speed"
                text: "~8 pixels"
                hotkey: "M-8"
                on-init:
                  lambda (self)
                    self[mark-set!: {player-prop-ref("camera-scroll-speed" 1) = 8}]
                on-change:
                  lambda (self new-value)
                    if new-value
                      player-prop-set! "camera-scroll-speed" 8
              radio:
                group: "scroll-speed"
                text: "1~6 pixels"
                hotkey: "M-6"
                on-init:
                  lambda (self)
                    self[mark-set!: {player-prop-ref("camera-scroll-speed" 1) = 16}]
                on-change:
                  lambda (self new-value)
                    if new-value
                      player-prop-set! "camera-scroll-speed" 16
              radio:
                group: "scroll-speed"
                text: "~32 pixels"
                hotkey: "M-3"
                on-init:
                  lambda (self)
                    self[mark-set!: {player-prop-ref("camera-scroll-speed" 1) = 32}]
                on-change:
                  lambda (self new-value)
                    if new-value
                      player-prop-set! "camera-scroll-speed" 32
              spring: default:
        v-container: inset: 2
          h-container:
            ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
            ;; camera scroll delay
            v-container: inset: 2
              over-style:
                properties:
                  frame-color: #@color:#ddd
                  back-color: #@color:#030
              label: text: "Scroll Delay"
              padding: size: 4
              radio:
                group: "scroll-delay"
                text: "~0 frames"
                hotkey: "M-0"
                on-init:
                  lambda (self)
                    self[mark-set!: {player-prop-ref("camera-scroll-delay" 0) = 0}]
                on-change:
                  lambda (self new-value)
                    if new-value
                      player-prop-set! "camera-scroll-delay" 0
              radio:
                group: "scroll-delay"
                text: "1 frame"
                on-init:
                  lambda (self)
                    self[mark-set!: {player-prop-ref("camera-scroll-delay" 0) = 1}]
                on-change:
                  lambda (self new-value)
                    if new-value
                      player-prop-set! "camera-scroll-delay" 1
              radio:
                group: "scroll-delay"
                text: "2 frames"
                on-init:
                  lambda (self)
                    self[mark-set!: {player-prop-ref("camera-scroll-delay" 0) = 2}]
                on-change:
                  lambda (self new-value)
                    if new-value
                      player-prop-set! "camera-scroll-delay" 2
              radio:
                group: "scroll-delay"
                text: "3 frames"
                on-init:
                  lambda (self)
                    self[mark-set!: {player-prop-ref("camera-scroll-delay" 0) = 3}]
                on-change:
                  lambda (self new-value)
                    if new-value
                      player-prop-set! "camera-scroll-delay" 3
              radio:
                group: "scroll-delay"
                text: "4 frames"
                on-init:
                  lambda (self)
                    self[mark-set!: {player-prop-ref("camera-scroll-delay" 0) = 4}]
                on-change:
                  lambda (self new-value)
                    if new-value
                      player-prop-set! "camera-scroll-delay" 4
              spring: default:
          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
          ;; "close" button
          spring: default:
          padding: default:
          h-container:
            spring: default:
            button: text: "~Close"
              hotkey: "M-c"
              escape: #t
              default: #t
              action:
                lambda (self)
                  self[close-window:]
  ;;
  win[initialize:]
  flexgui:append-window win
  flexgui:center-window win
