;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; called once at the start of the application.
;; initialises console commands.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
define init-console()
  concmd:new-simple-command 'quit "quit game"
    lambda (argv)
      (sdl:post-quit-event)
  ;;
  concmd:new-simple-command 'recolor "recolor tiles"
    lambda (argv)
      if in-game
        recolor-gfx-texture()
        printf "no game started.\n"
  ;;
  concmd:new-simple-command 'suicide "kill Rockford"
    lambda (argv)
      if in-game
        gset! game:player-suicide-request #t
        printf "no game started.\n"
  ;;
  concmd:new-simple-command 'restart "restart the current cave"
    lambda (argv)
      if in-game
        gset! reload-cave #t
        printf "no game started.\n"
  ;;
  concmd:new-complex-command 'pause "change pause mode"
  concmd:new-complex-command 'toggle "toggle pause mode"
  ;; "pause toggle" subcommands
  concmd:new-simple-command 'all "toggle game and animation pause"
    lambda (argv)
      if in-game
        then
          gset! anim-paused (gset! game-paused {not game-paused})
          if game-paused pause-all-sound() resume-all-sound()
          gset! need-show #t
        printf "no game started.\n"
  concmd:new-simple-command 'game "toggle game pause mode"
    lambda (argv)
      if in-game
        then
          gset! game-paused {not game-paused}
          if game-paused pause-all-sound() resume-all-sound()
          gset! need-show #t
        printf "no game started.\n"
  concmd:new-simple-command 'animation "toggle animation pause mode"
    lambda (argv)
      if in-game
        then
          gset! anim-paused {not anim-paused}
          gset! need-show #t
        printf "no game started.\n"
  concmd:end-complex-command()
  ;; "pause" subcommands
  concmd:new-simple-command 'tan "set pause mode"
    lambda (argv)
      if in-game
        then
          gset! anim-paused #t
          gset! game-paused #t
          pause-all-sound()
          gset! need-show #t
        printf "no game started.\n"
  concmd:new-simple-command 'ona "reset pause mode"
    lambda (argv)
      if in-game
        then
          gset! anim-paused #f
          gset! game-paused #f
          resume-all-sound()
          gset! need-show #t
        printf "no game started.\n"
  concmd:end-complex-command()
  ;;
  concmd:new-complex-command 'game-speed "change game speed"
  concmd:new-simple-command 'toggle "toggle game speed mode (normal/fixed)"
    lambda (argv)
      if in-game
        then
          gset! use-fixed-level-speed {not use-fixed-level-speed}
          cond
            use-fixed-level-speed
              gset! game:cave-step-time fixed-level-speed
              printf "using fixed level speed: %o msecs.\n" game:cave-step-time
            else
              gset! game:cave-step-time game:option-ref('level-speed)
              printf "using author level speed: %o msecs.\n" game:cave-step-time
          gset! game-time game:cave-step-time
        printf "no game started.\n"
  concmd:new-simple-command 'set "set game speed (frame delay) in msecs: [30-1000]"
    lambda (argv)
      if in-game
        then
          define speed
          cond
            {vector-length(argv) <> 1}
              printf "wut?\n"
            {false? {speed := string->number(argv[0])}}
              printf "this is not a number: \"%s\"\n" argv[0]
            between?(speed 30 1000)
              printf "invalid frame delay: %d\n" speed
            else
              if {not use-fixed-level-speed}
                gset! use-fixed-level-speed #t
              gset! fixed-level-speed speed
              gset! game:cave-step-time speed
              gset! game-time speed
              printf "using fixed level speed: %o msecs.\n" game:cave-step-time
        printf "no game started.\n"
  concmd:new-simple-command 'normal "set normal game speed (from cave data)"
    lambda (argv)
      if in-game
        then
          if use-fixed-level-speed
            then
              gset! use-fixed-level-speed #f
              gset! game:cave-step-time game:option-ref('level-speed)
              printf "using author level speed: %o msecs.\n" game:cave-step-time
              gset! game-time game:cave-step-time
        printf "no game started.\n"
  concmd:new-simple-command 'fixed "set fixed game speed"
    lambda (argv)
      if in-game
        then
          if {not use-fixed-level-speed}
            then
              gset! use-fixed-level-speed #t
              gset! game:cave-step-time fixed-level-speed
              printf "using fixed level speed: %o msecs.\n" game:cave-step-time
              gset! game-time game:cave-step-time
        printf "no game started.\n"
  concmd:end-complex-command()
  ;;
  concmd:new-complex-command 'mobiles "change mobile reaction options"
  concmd:new-simple-command 'toggle-harmless "toggle harmless mode"
    lambda (argv)
      if in-game
        then
          gset! game:cheat-harmless-mobiles {not game:cheat-harmless-mobiles}
          printf "harmless mobiles: %s\n" (if game:cheat-harmless-mobiles "tan" "ona")
          gset! cheated #t
        printf "no game started.\n"
  concmd:new-simple-command 'harmless "set harmless mode"
    lambda (argv)
      if in-game
        then
          if {not game:cheat-harmless-mobiles}
            then
              gset! game:cheat-harmless-mobiles #t
              printf "harmless mobiles: tan\n"
              gset! cheated #t
        printf "no game started.\n"
  concmd:new-simple-command 'deadly "reset harmless mode"
    lambda (argv)
      if in-game
        then
          if game:cheat-harmless-mobiles
            then
              gset! game:cheat-harmless-mobiles #f
              printf "harmless mobiles: ona\n"
        printf "no game started.\n"
  concmd:end-complex-command()
  ;;
  concmd:new-simple-command 'gate-open "open exit game (works when the player is hatched)"
    lambda (argv)
      if in-game
        if game:player-hatched
          then
            game:cheat-open-gate()
            gset! cheated #t
        printf "no game started.\n"
  ;;
  concmd:new-simple-command 'cave-exit "immediately finish the current cave"
    lambda (argv)
      ;if {game:player-hatched and {not game:cave-finished}}
      if in-game
        then
          if {not game:cave-finished}
            then
              ginc! cave-idx
              gset! reload-cave #t
              gset! need-recolor #t
              ;gset! con-cave-skipped #t
              gset! cheated #t
              record-cave-skipped()
              ;play-sound 'GD_S_FINISHED
              ;gset! game:cave-finished #t
              ;explode-no-center game:player-x game:player-y etype:O_EXPLODE_1
        printf "no game started.\n"
  ;;
  concmd:new-simple-command 'explode "spawn explosion"
    lambda (argv)
      if in-game
        if game:player-hatched
          then
            explode-no-center game:player-x game:player-y etype:O_EXPLODE_1
            gset! cheated #t
        printf "no game started.\n"
  ;;
  concmd:new-complex-command 'gimme "give various things"
  concmd:new-simple-command 'bomb "give the bomb"
    lambda (argv)
      if in-game
        then
          gset! game:bombs-collected {game:bombs-collected + 1}
          gset! game:bomb-is-k8 #t
          gset! cheated #t
        printf "no game started.\n"
  concmd:new-simple-command 'sweet "give the sweet"
    lambda (argv)
      if in-game
        then
          gset! game:sweet-eaten #t
          gset! cheated #t
        printf "no game started.\n"
  concmd:new-complex-command 'key "give various keys"
  concmd:new-simple-command string->symbol("key#1") "give key #1"
    lambda (argv)
      if in-game
        then
          gset! cheated #t
          game:key-collected(1)
        printf "no game started.\n"
  concmd:new-simple-command string->symbol("key#2") "give key #2"
    lambda (argv)
      if in-game
        then
          game:key-collected(2)
          gset! cheated #t
        printf "no game started.\n"
  concmd:new-simple-command string->symbol("key#3") "give key #3"
    lambda (argv)
      if in-game
        then
          game:key-collected(3)
          gset! cheated #t
        printf "no game started.\n"
  concmd:new-simple-command 'diamond "give diamond key"
    lambda (argv)
      if in-game
        then
          game:key-collected(game:DIAMOND_KEY_IDX)
          gset! cheated #t
        printf "no game started.\n"
  concmd:end-complex-command()
  concmd:end-complex-command()
  ;;
  concmd:new-complex-command 'single-step "control single-step mode"
  concmd:new-simple-command 'toggle "toggle single-step mode"
    lambda (argv)
      if in-game
        then
          gset! single-step-mode {not single-step-mode}
          printf "single-step mode: %s\n" (if single-step-mode "tan" "ona")
          if {single-step-mode and game-paused}
            then
              gset! game-paused #f
              gset! anim-paused #f
              resume-all-sound()
          gset! need-show #t
        printf "no game started.\n"
  concmd:new-simple-command 'tan "set harmless mode"
    lambda (argv)
      if in-game
        if {not single-step-mode}
          then
            gset! single-step-mode #t
            printf "single-step mode: %s\n" (if single-step-mode "tan" "ona")
            if {single-step-mode and game-paused}
              then
                gset! game-paused #f
                gset! anim-paused #f
                resume-all-sound()
        printf "no game started.\n"
  concmd:new-simple-command 'ona "reset harmless mode"
    lambda (argv)
      if in-game
        if single-step-mode
          then
            gset! single-step-mode #f
            printf "single-step mode: %s\n" (if single-step-mode "tan" "ona")
        printf "no game started.\n"
  concmd:end-complex-command()
