(define last-master-volume -666)

define set-master-volume(vol)
  if {last-master-volume <> vol}
    then
      gset! last-master-volume vol
      sdl:mixer-set-channel-volume #t vol

define pause-all-sound()
  sdl:mixer-pause-channel #t

define resume-all-sound()
  sdl:mixer-resume-channel #t


define do-play-sound(id)
  ;; id is symbol here. need to convert it
  ;game:replay-put-word -46
  ;game:replay-put-word id
  play-sound(id)

define play-sound-with-id(id)
  ;printf "otype=%o; snd=%o\n" otype snd
  if {symbol? id}
    case id
      (GD_S_AMOEBA)
        if game:option-ref('amoeba-sound)
          do-play-sound(id)
      (GD_S_AMOEBA_MAGIC)
        if game:option-ref('amoeba-sound)
          if game:option-ref('magic-wall-sound)
            do-play-sound(id)
            do-play-sound('GD_S_AMOEBA)
          if game:option-ref('magic-wall-sound)
            do-play-sound('GD_S_MAGIC_WALL)
      (GD_S_MAGIC_WALL)
        if game:option-ref('magic-wall-sound)
          do-play-sound(id)
      (GD_S_REPLICATOR)
        if game:option-ref('replicator-sound)
          do-play-sound(id)
      (GD_S_WATER)
        if game:option-ref('water-sound)
          do-play-sound(id)
      (GD_S_GRAVITY_CHANGE)
        if game:option-ref('gravity-change-sound)
          do-play-sound(id)
      (GD_S_NUT GD_S_NUT_CRACK)
        if game:option-ref('nut-sound)
          do-play-sound(id)
      (GD_S_STONE)
        if game:option-ref('stone-sound)
          do-play-sound(id)
      (GD_S_NITRO)
        if game:option-ref('nitro-sound)
          do-play-sound(id)
      (GD_S_PNEUMATIC_HAMMER)
        if game:option-ref('pneumatic-hammer-sound)
          do-play-sound(id)
      (GD_S_FALLING_WALL)
        if game:option-ref('falling-wall-sound)
          do-play-sound(id)
      (GD_S_EXPANDING_WALL)
        if game:option-ref('expanding-wall-sound)
          do-play-sound(id)
      (GD_S_DIAMOND_RANDOM)
        if game:option-ref('diamond-sound)
          do-play-sound(id)
      (GD_S_BLADDER_SPENDER)
        if game:option-ref('bladder-spender-sound)
          do-play-sound(id)
      (GD_S_BLADDER_CONVERT)
        if game:option-ref('bladder-convert-sound)
          do-play-sound(id)
      (GD_S_SLIME)
        if game:option-ref('slime-sound)
          do-play-sound(id)
      (GD_S_LAVA)
        if game:option-ref('lava-sound)
          do-play-sound(id)
      (GD_S_ACID_SPREAD)
        if game:option-ref('acid-spread-sound)
          do-play-sound(id)
      (GD_S_BLADDER_MOVE)
        if game:option-ref('bladder-sound)
          do-play-sound(id)
      (GD_S_BITER_EAT)
        if game:option-ref('biter-sound)
          do-play-sound(id)
      else
        do-play-sound(id)


define play-sound-of-edef(def)
  define snd edef:get-prop(def 'P_SOUND)
  if {pair? snd}
    play-sound-with-id cdr(snd)

define play-sound-of-otype(otype)
  game:replay-put-word -60
  game:replay-put-word otype
  play-sound-of-edef {entity-defs[otype]}


define play-walk-sound-of-edef(def)
  define snd edef:get-prop(def 'P_WALK_SOUND)
  if {pair? snd}
    play-sound-with-id cdr(snd)

define play-walk-sound-of-otype(otype)
  game:replay-put-word -61
  game:replay-put-word otype
  play-walk-sound-of-edef {entity-defs[otype]}


define play-push-sound-of-edef(def)
  define snd edef:get-prop(def 'P_PUSH_SOUND)
  if {pair? snd}
    play-sound-with-id cdr(snd)

define play-push-sound-of-otype(otype)
  game:replay-put-word -62
  game:replay-put-word otype
  play-push-sound-of-edef {entity-defs[otype]}


define play-fall-sound-of-edef(def)
  define snd edef:get-prop(def 'P_FALL_SOUND)
  if {pair? snd}
    play-sound-with-id cdr(snd)

define play-fall-sound-of-otype(otype)
  game:replay-put-word -63
  game:replay-put-word otype
  play-fall-sound-of-edef {entity-defs[otype]}
