;; GD_TYPE_EFFECT: (effect: #t)
;; Effect=effect-name effect-value
(define default-cave-options new-options-list())

(add-option default-cave-options 'name "Untitled Cave" (list
  bdcff: "Name"
  help: "Cave name."
))
(add-option default-cave-options 'author "" (list
  bdcff: "Author"
  help: "Cave author."
))
(add-option default-cave-options 'date "" (list
  bdcff: "Date"
  help: "Cave creation date."
))
(add-option default-cave-options 'description "" (list
  bdcff: "Description"
  help: "Cave description."
))
(add-option default-cave-options 'story "" (list
  bdcff: "Story"
  help: "Story for the cave. It will be shown when the cave is played."
))
(add-option default-cave-options 'remark "" (list
  bdcff: "Remark"
  help: "Remark (informative). Can contain supplementary information about \
the design of the cave. It is not shown during the game, only when the user \
requests the cave info dialog, so can also contain spoilers and hints."
))
(add-option default-cave-options 'difficulty "" (list
  bdcff: "Difficulty"
  help: "Difficulty notes (informative)."
))
(add-option default-cave-options 'selectable #t (list
  bdcff: "Selectable"
  help: "This sets whether the game can be started at this cave."
))
(add-option default-cave-options 'intermission #f (list
  bdcff: "Intermission"
  help: "Intermission caves are usually small and fast caves, which are \
not required to be solved. The player will not lose a life if he is not successful. \
The game always proceeds to the next cave."
))
(add-option default-cave-options 'intermission-instantlife #f (list
  bdcff: "IntermissionProperties.instantlife"
  help: "If true, an extra life is given to the player, when the \
intermission cave is reached."
))
(add-option default-cave-options 'intermission-rewardlife #t (list
  bdcff: "IntermissionProperties.rewardlife"
  help: "If true, an extra life is given to the player, when the \
intermission cave is successfully finished."
))

;; set by "Size" key handler
;; Size=40 22 0 0 39 21
(add-option default-cave-options 'width 40)
(add-option default-cave-options 'height 22)
(add-option default-cave-options 'viewport-w 40)
(add-option default-cave-options 'viewport-h 22)
(add-option default-cave-options 'viewport-x 0)
(add-option default-cave-options 'viewport-y 0)

;; C64 gfx colors
;; special handling
(add-option default-cave-options 'colorb 0 (list
  help: "Border color for C64 graphics. Only for compatibility, not used."
))
(add-option default-cave-options 'color0 0 (list
  help: "Background color for C64 graphics."
))
(add-option default-cave-options 'color1 8 (list
  help: "Foreground color 1 for C64 graphics."
))
(add-option default-cave-options 'color2 11 (list
  help: "Foreground color 2 for C64 graphics."
))
(add-option default-cave-options 'color3 1 (list
  help: "Foreground color 3 for C64 graphics."
))
(add-option default-cave-options 'color4 5 (list
  help: "Amoeba color for C64 graphics."
))
(add-option default-cave-options 'color5 6 (list
  help: "Slime color for C64 graphics."
))

; difficulty
(add-option default-cave-options 'diamonds-required #(10 10 10 10 10) (list
  min-value: -100
  max-value: 999
  cave-hash: #t
  out-of-range-clamp: (lambda (val) (if {positive? val} 0 -666_666))
  bdcff: "DiamondsRequired"
  help: "Here zero means automatically count diamonds before level start. \
If negative, the value is subtracted from that. \
This is useful for totally random caves."
))
;; special handling for "DiamondValue"
(add-option default-cave-options 'diamond-value #(10 10 10 10 10) (list
  min-value: 0
  max-value: 100
  cave-hash: #t
  help: "Number of points per diamond collected, before opening the exit."
))
;; special handling for "DiamondValue"
(add-option default-cave-options 'extra-diamond-value #(0 0 0 0 0) (list
  min-value: 0
  max-value: 100
  cave-hash: #t
  help: "Number of points per diamond collected, after opening the exit."
))
(add-option default-cave-options 'level-time #(999 999 999 999 999) (list
  min-value: 1
  max-value: 999
  cave-hash: #t
  out-of-range-clamp: (lambda (val) (if {positive? val} 999 101))
  bdcff: "CaveTime"
  help: "Time available to solve the cave, in seconds."
))
(add-option default-cave-options 'max-time 999 (list
  min-value: 60
  max-value: 999
  cave-hash: #t
  bdcff: "CaveMaxTime"
  help: "If you reach this time by collecting too many clocks, the timer will overflow."
))
(add-option default-cave-options 'level-time-value #(1 1 1 1 1) (list
  min-value: 0
  max-value: 50
  cave-hash: #t
  bdcff: "TimeValue"
  help: "Points for each seconds remaining, when the player exits the level."
))
(add-option default-cave-options 'pal-timing #f (list
  bdcff: "PALTiming"
  help: "On the PAL version of the C64 computer, the timer was actually slower than normal seconds. \
This flag is used to compensate for this. If enabled, one game second will last 1.2 real seconds. \
Most original games were authored for the PAL version. \
This is a compatibility setting for imported caves; it is not recommended to enable it for newly authored ones."
))
;(add-option default-cave-options 'scheduling 'MILLISECONDS (list
;  help: "This flag sets whether the game uses an emulation of the original timing (c64-style), \
;or a more modern milliseconds-based timing. The original game used a delay (empty loop) based \
;timing of caves; this is selected by setting this to BD1, BD2, Construction Kit or Crazy Dream 7. \
;This is a compatibility setting only; milliseconds-based timing is recommended for every new cave."
;  bdcff: "CaveScheduling"
;))
;; "CaveDelay" is ignored by the engine: we always using millisecond scheduling.
;(add-option default-cave-options 'level-ckdelay #(0 0 0 0 0) (list
;  min-value: 0
;  max-value: 32
;  bdcff: "CaveDelay"
;  help: "The length of the delay loop between game frames. \
;Used when milliseconds-based timing is inactive, ie. some kind of C64 or Atari scheduling is selected."
;))
;; "FrameTime" is ignored by the engine: game speed is controlled by the user.
;; it is not even set in GDash-CrLi BDCFF files.
(add-option default-cave-options 'level-speed #(200 200 200 200 200) (list
  min-value: 50
  max-value: 400
  cave-hash: #t
  out-of-range-clamp: (lambda (val) (if {val > 400} 200 100))
  bdcff: "FrameTime"
  help: "Number of milliseconds between game frames. \
Used when milliseconds-based timing is active, ie. C64 scheduling is off."
))
;; may be used by the engine if no "HatchingDelay" specified
(add-option default-cave-options 'level-hatching-delay-time #(2 2 2 2 2) (list
  min-value: 1
  max-value: 40
  bdcff: "HatchingTime"
  help: "This value sets how much the cave will move until the player enters the cave. \
This is used for the C64-like schedulings."
))
;; 21 frame (default in GDash) is: 21*200/1000=4.2 seconds. wtf?!
;; "delay time" is only 2 seconds (2.4 for PAL).
;; it is basically never this big (except the one BDCFF export),
;; so i adjusted it to more sensible value.
(add-option default-cave-options 'level-hatching-delay-frame #(21 21 21 21 21) (list
  min-value: 1
  max-value: 40
  cave-hash: #t
  bdcff: "HatchingDelay"
  help: "This value sets how much the cave will move until the player \
enters the cave, and is expressed in frames. This is used for the milliseconds-based scheduling."
))
(add-option default-cave-options 'level-rand #(#x1E #x1E #x1E #x1E #x1E) (list
  min-value: -1
  max-value: 255
  cave-hash: #t
  bdcff: "RandSeed"
  help: "Initial predictable random seed."
))

;; initial fill
(add-option default-cave-options 'gen-initial-border etype:O_STEEL (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "InitialBorder"
  help: "Draw initial room border with this element."
))
(add-option default-cave-options 'gen-initial-fill etype:O_DIRT (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "InitialFill"
  help: "Initially fill the room with this element."
))
;; "RandomFill" is processed specially
(add-option default-cave-options 'gen-random-fill (make-vector 4 etype:O_DIRT) (list
  type: 'ELEMENT
  cave-hash: #t
))
(add-option default-cave-options 'gen-random-prob (make-vector 4 0) (list
  min-value: 0
  max-value: 255
  cave-hash: #t
))

;; player
(add-option default-cave-options 'diagonal-movements #f (list
  bdcff: "DiagonalMovement"
  cave-hash: #t
  help: "Controls if the player can move diagonally."
))
;; default was #f
(add-option default-cave-options 'active-is-first-found #t (list
  bdcff: "ActiveGuyIsFirst"
  help: "In 1stB, cave is scrolled to the uppermost and leftmost player found, \
whereas in the original game to the last one. Chasing stones also follow the active player."
))
(add-option default-cave-options 'snap-element etype:O_SPACE (list
  type: 'ELEMENT
  bdcff: "SnapEffect"
  cave-hash: #t
  help: "Snapping (pressing fire while moving) usually creates space, but it can create any other element."
))
;;"PushingBoulderProb": first number is normal, second number is sweet
(add-option default-cave-options 'pushing-stone-prob 250_000 (list
  type: 'PROBABILITY
  ;bdcff: "PushingBoulderProb"
  cave-hash: #t
  help: "Chance of player managing to push a stone, every game cycle he tries. This is the normal probability."
))
(add-option default-cave-options 'pushing-stone-prob-sweet 1_000_000 (list
  type: 'PROBABILITY
  miho-bd: #t
  cave-hash: #t
  bdcff: "PushingBoulderProbAfterSweet" ;; k8: it is integrated in PushingBoulderProb, but i added it anyway
  help: "Chance of player managing to push a stone, every game cycle he tries. This is used after eating sweet."
))
(add-option default-cave-options 'mega-stone-pushable-with-sweet #t (list
  bdcff: "PushingMegaStonesAfterSweet"
  help: "If it is true, mega stones can be pushed after eating sweet."
))
(add-option default-cave-options 'level-bonus-time #(30 30 30 30 30) (list
  min-value: -100
  ;max-value: 100
  max-value: 999  ;; k8: why not?
  cave-hash: #t
  bdcff: "BonusTime"
  help: "Bonus time when a clock is collected."
))
(add-option default-cave-options 'pneumatic-hammer-frame 5 (list
  min-value: 1
  max-value: 100
  bdcff: "PneumaticHammer.frames"
  help: "This is the number of game frames, a pneumatic hammer is required to break a wall."
))
(add-option default-cave-options 'hammered-walls-reappear #f (list
  bdcff: "PneumaticHammer.wallsreappear"
  help: "If this is set to true, walls broken with a pneumatic hammer will reappear later."
))
(add-option default-cave-options 'hammered-wall-reappear-frame 100 (list
  min-value: 1
  ;max-value: 200
  max-value: 255  ;; k8: why not?
  bdcff: "PneumaticHammer.wallsreappearframes"
  help: "This sets the number of game frames, after hammered walls reappear, \
when allowed by the corresponding option."
))
(add-option default-cave-options 'voodoo-collects-diamonds #f (list
  cave-hash: #t
  bdcff: "DummyProperties.diamondcollector"
  help: "Controls if a voodoo doll can collect diamonds for the player."
))
(add-option default-cave-options 'voodoo-disappear-in-explosion #t (list
  cave-hash: #t
  bdcff: "DummyProperties.destructable"
  help: "Controls if the voodoo can be destroyed by an explosion nearby. \
If not, it is converted to a gravestone, and you get a time penalty. \
If yes, the voodoo simply disappears."
))
(add-option default-cave-options 'voodoo-dies-by-stone #f (list
  cave-hash: #t
  bdcff: "DummyProperties.penalty"
  help: "Controls if the voodoo doll dies if it is hit by a stone. \
Then the player gets a time penalty, and it is turned to a gravestone surrounded by steel wall."
))
(add-option default-cave-options 'voodoo-any-hurt-kills-player #f (list
  cave-hash: #t
  bdcff: "DummyProperties.alwayskillsplayer"
  help: "If this setting is enabled, the player will explode if the voodoo is hurt \
in any possible way, ie. touched by a firefly, hit by a stone or an explosion."
))
(add-option default-cave-options 'level-penalty-time #(30 30 30 30 30) (list
  min-value: 0
  ;max-value: 100
  max-value: 999  ;; k8: why not?
  cave-hash: #t
  bdcff: "PenaltyTime"
  help: "Penalty time when the voodoo is destroyed by a stone."
))

;; magic wall
(add-option default-cave-options 'level-magic-wall-time #(999 999 999 999 999) (list
  min-value: 0
  ;max-value: 999
  max-value: 65536  ;; k8: some games using "65535" as "infinite", oops
  cave-hash: #t
  bdcff: "MagicWallTime"
  help: "Magic wall will stop after this time, and it cannot be activated again."
))
(add-option default-cave-options 'reveal-magic-walls #t (list
  help: "Use different graphics even for inactive magic walls."
))
;; not implemented, and i don't care. stupid C64 bug.
(add-option default-cave-options 'magic-wall-stops-amoeba #f (list
  bdcff: "MagicWallProperties.convertamoeba"
  help: "When the magic wall is activated, it can convert amoeba into diamonds."
))
(add-option default-cave-options 'magic-timer-wait-for-hatching #t (list
  cave-hash: #t
  bdcff: "MagicWallProperties.waitforhatching"
  help: "This determines if the magic wall timer starts before the player appearing. \
Magic can always be activated before that; but if this is set to true, the timer will not start."
))
(add-option default-cave-options 'magic-timer-zero-is-infinite #t (list
  cave-hash: #t
  bdcff: "MagicWallProperties.zeroisinfinite"
  help: "This determines if the magic wall timer 0 is interpreted as infinite."
))
;; "MagicWallProperties": first value is for diamonds, second is for stones
(add-option default-cave-options 'magic-diamond-to etype:O_STONE_F (list
  type: 'ELEMENT
  cave-hash: #t
  ;bdcff: "MagicWallProperties"
  help: "As a special effect, magic walls can convert diamonds to any other element."
))
(add-option default-cave-options 'magic-stone-to etype:O_DIAMOND_F (list
  type: 'ELEMENT
  cave-hash: #t
  ;bdcff: "MagicWallProperties"
  help: "As a special effect, magic walls can convert stones to any other element."
))
(add-option default-cave-options 'magic-mega-stone-to etype:O_NITRO_PACK_F (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "MagicWallProperties.megastoneto"
  help: "If a mega stone falls into the magic wall, it will drop this element."
))
(add-option default-cave-options 'magic-nitro-pack-to etype:O_MEGA_STONE_F (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "MagicWallProperties.nitropackto"
  help: "If a nitro pack falls into the magic wall, it will be turned to this element."
))
(add-option default-cave-options 'magic-nut-to etype:O_NUT_F (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "MagicWallProperties.nutto"
  help: "As a special effect, magic walls can convert nuts to any other element."
))
(add-option default-cave-options 'magic-flying-stone-to etype:O_FLYING_DIAMOND_F (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "MagicWallProperties.flyingstoneto"
  help: "If a flying stone climbs up into the magic wall, it will be turned to this element. \
Remember that flying stones enter the magic wall from its bottom, not from the top!"
))
(add-option default-cave-options 'magic-flying-diamond-to etype:O_FLYING_STONE_F (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "MagicWallProperties.flyingdiamondto"
  help: "If a flying diamond enters the magic wall, it will be turned to this element. \
Remember that flying diamonds enter the magic wall from its bottom, not from the top!"
))

;; amoeba
(add-option default-cave-options 'level-amoeba-threshold #(200 200 200 200 200) (list
  type: 'RATIO
  min-value: 0
  max-value: 16383
  cave-hash: #t
  out-of-range-clamp: (lambda (val) (if {positive? val} 65536 0))
  bdcff: "AmoebaThreshold"
  help: "If the amoeba grows more than this fraction of the cave, \
it is considered too big and it converts to the element specified below."
))
(add-option default-cave-options 'level-amoeba-time #(999 999 999 999 999) (list
  min-value: 0
  max-value: 999
  cave-hash: #t
  out-of-range-clamp: (lambda (val) (if {positive? val} 65536 0))
  bdcff: "AmoebaTime"
  help: "After this time, amoeba will grow very quickly."
))
;; "AmoebaGrowthProb": first number is normal, second number is fast
(add-option default-cave-options 'amoeba-growth-prob 31_250 (list
  type: 'PROBABILITY
  ;bdcff: "AmoebaGrowthProb"
  cave-hash: #t
  help: "This sets the speed at which a slow amoeba grows."
))
(add-option default-cave-options 'amoeba-fast-growth-prob 250_000 (list
  type: 'PROBABILITY
  ;bdcff: "AmoebaGrowthProb"
  cave-hash: #t
  help: "This sets the speed at which a fast amoeba grows."
))
(add-option default-cave-options 'amoeba-timer-started-immediately #t (list
  bdcff: "AmoebaProperties.immediately"
  help: "If this flag is enabled, the amoeba slow growth timer will start at \
the beginning of the cave, regardless of the amoeba being let free or not. \
This can make a big difference when playing the cave!"
))
(add-option default-cave-options 'amoeba-timer-wait-for-hatching #f (list
  cave-hash: #t
  bdcff: "AmoebaProperties.waitforhatching"
  help: "This determines if the amoeba timer starts before the player appearing. \
Amoeba can always be activated before that; but if this is set to true, the timer \
will not start. This setting is for compatiblity for some old imported caves. \
As the player is usually born within a few seconds, changing this setting makes \
not much difference. It is not advised to change it, set the slow growth time to \
fit your needs instead."
))
(add-option default-cave-options 'amoeba-too-big-effect etype:O_STONE (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "AMOEBABOULDEReffect"
  help: "Controls which element an overgrown amoeba converts to."
))
(add-option default-cave-options 'amoeba-enclosed-effect etype:O_DIAMOND (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "AMOEBADIAMONDeffect"
  help: "Controls which element an enclosed amoeba converts to."
))

;; amoeba 2
(add-option default-cave-options 'level-amoeba-2-threshold #(200 200 200 200 200) (list
  type: 'RATIO
  min-value: 0
  max-value: 16383
  cave-hash: #t
  out-of-range-clamp: (lambda (val) (if {positive? val} 65536 0))
  bdcff: "Amoeba2Threshold"
  help: "If the amoeba grows more than this fraction of the cave, \
it is considered too big and it converts to the element specified below."
))
;; "Amoeba2GrowthProb": first number is normal, second number is fast
(add-option default-cave-options 'amoeba-2-growth-prob 31_250 (list
  type: 'PROBABILITY
  cave-hash: #t
  ;bdcff: "Amoeba2GrowthProb"
  help: "This sets the speed at which a slow amoeba grows."
))
(add-option default-cave-options 'amoeba-2-fast-growth-prob 250_000 (list
  type: 'PROBABILITY
  cave-hash: #t
  ;bdcff: "Amoeba2GrowthProb"
  help: "This sets the speed at which a fast amoeba grows."
))
(add-option default-cave-options 'level-amoeba-2-time #(999 999 999 999 999) (list
  cave-hash: #t
  bdcff: "Amoeba2Time"
  help: "After this time, amoeba will grow very quickly."
))
(add-option default-cave-options 'amoeba-2-too-big-effect etype:O_STONE (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "AMOEBA2BOULDEReffect"
  help: "Controls which element an overgrown amoeba converts to."
))
(add-option default-cave-options 'amoeba-2-enclosed-effect etype:O_DIAMOND (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "AMOEBA2DIAMONDeffect"
  help: "Controls which element an enclosed amoeba converts to."
))
(add-option default-cave-options 'amoeba-2-explodes-by-amoeba #t (list
  bdcff: "Amoeba2Properties.explode"
  help: "If this setting is enabled, an amoeba 2 will explode \
if it is touched by a normal amoeba."
))
(add-option default-cave-options 'amoeba-2-looks-like etype:O_AMOEBA_2 (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "AMOEBA2LOOKSLIKEeffect"
  help: "Amoeba 2 can look like any other element. \
Hint: it can also look like a normal amoeba. Or it can look like slime, \
and then you have two different colored amoebas!"
))
(add-option default-cave-options 'amoeba-2-explosion-effect etype:O_SPACE (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "AMOEBA2EXPLOSIONeffect"
  help: "An amoeba 2 explodes to this element, when touched by the original amoeba."
))

;; water
(add-option default-cave-options 'water-does-not-flow-down #f (list
  cave-hash: #t
  bdcff: "WaterProperties.doesnotflowdown"
  help: "In CrDr, the water element had the odd property that it \
did not flow downwards, only in other directions. This flag emulates this behaviour."
))

;; nut
(add-option default-cave-options 'nut-turns-to-when-crushed etype:O_NUT_EXPL_1 (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "Nut.whencrushed"
  help: "Normally, a nut contains a diamond. If you crush it with a stone, \
the diamond will appear after the usual nut explosion sequence. \
This setting can be used to change the element the nut contains."
))

;; replicator
(add-option default-cave-options 'replicator-delay-frame 4 (list
  min-value: 0
  max-value: 100
  cave-hash: #t
  bdcff: "ReplicatorDelayFrame"
  help: "Number of frames to wait between replicating elements."
))
(add-option default-cave-options 'replicators-active #t (list
  cave-hash: #t
  bdcff: "ReplicatorActive"
  help: "Whether the replicators are turned on or off at the cave start."
))

;; conveyor belt
(add-option default-cave-options 'conveyor-belts-active #t (list
  cave-hash: #t
  bdcff: "ConveyorBeltActive"
  help: "Whether the conveyor belts are moving when the cave starts."
))
(add-option default-cave-options 'conveyor-belts-direction-changed #f (list
  cave-hash: #t
  bdcff: "ConveyorBeltDirection.changed"
  help: "If the conveyor belts' movement is changed, ie. they are running in \
the opposite direction. As you can freely use left and right going versions of \
the conveyor belt in a cave, it is not recommended to change this setting, \
rather you should select the correct one from the element box when drawing."
))

;; slime
(add-option default-cave-options 'slime-predictable #t (list
  cave-hash: #t
  bdcff: "SlimePredictable"
  help: "Controls if the predictable random generator is used for slime. \
It is required for compatibility with some older caves."
))
(add-option default-cave-options 'level-slime-seed-c64 #(-1 -1 -1 -1 -1) (list
  min-value: -1
  max-value: 65535
  cave-hash: #t
  bdcff: "SlimePredictableC64.seed"
  help: "The random number seed for predictable slime. Use -1 to leave on its default. \
Not recommended to change. Does not affect unpredictable slime."
))
(add-option default-cave-options 'level-slime-permeability-c64 #(0 0 0 0 0) (list
  min-value: 0
  max-value: 255
  cave-hash: #t
  bdcff: "SlimePermeabilityC64"
  help: "This controls the rate at which elements go through the slime. \
This one is for predictable slime, and the value is used for a bitwise AND function. \
The values used by the C64 engines are 0, 128, 192, 224, 240, 248, 252, 254 and 255."
))
(add-option default-cave-options 'level-slime-permeability #(1_000_000 1_000_000 1_000_000 1_000_000 1_000_000) (list
  type: 'PROBABILITY
  cave-hash: #t
  bdcff: "SlimePermeability"
  help: "This controls the rate at which elements go through the slime. \
Higher values represent higher probability of passing. This one is for unpredictable slime."
))
;; "SlimeProperties" has 3 pair of values (6 of them):
;; first is "eats", second is "converts"
(add-option default-cave-options 'slime-eat-convert
  (make-vector #t etype:O_DIAMOND etype:O_DIAMOND_F
                  etype:O_STONE etype:O_STONE_F
                  etype:O_NUT etype:O_NUT_F)
(list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "SlimeProperties"
  help: "Slime can let other elements than stone and diamond go through. \
  It always lets a waiting or a chasing stone pass, though. \
  Also, flying diamonds and stones, as well as bladders are always passed."
))

;; acid
;; "AcidProperties": eat-element spread-ratio
(add-option default-cave-options 'acid-eats-this etype:O_DIRT (list
  type: 'ELEMENT
  cave-hash: #t
  help: "The element which acid eats. If it cannot find any, it simply disappears."
))
(add-option default-cave-options 'acid-spread-ratio 31_250 (list
  type: 'PROBABILITY
  cave-hash: #t
  help: "The probability at which an acid will explode and eat neighbouring elements."
))
(add-option default-cave-options 'acid-turns-to etype:O_EXPLODE_3 (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "ACIDEffect"
  help: "If acid converts to an explosion puff on spreading or any other element."
))

;; biter
;; "BiterProperties": delay eat-element
(add-option default-cave-options 'biter-delay-frame 0 (list
  min-value: 0
  max-value: 3
  cave-hash: #t
  out-of-range-clamp: (lambda (val) clamp(val 0 15))  ;; Crazy Dream 7
  help: "Number of frames biters wait between movements."
))
(add-option default-cave-options 'biter-eat etype:O_DIAMOND (list
  type: 'ELEMENT
  cave-hash: #t
  help: "Biters eat this element. (They always eat dirt.)"
))

;; bladder
(add-option default-cave-options 'bladder-converts-by etype:O_VOODOO (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "BladderProperties"
  help: "Bladder converts to this element by touching."
))

;; expanding wall
(add-option default-cave-options 'expanding-wall-changed #f (list
  cave-hash: #t
  bdcff: "ExpandingWallDirection.changed"
  help: "If this option is enabled, the direction of growing for the \
horizontal and vertical expanding wall is switched. As you can use both \
horizontal and vertical expanding walls in a cave, it is not recommended \
to change this setting, as it might be confusing. You should rather select \
the type with the correct direction from the element box when drawing the cave."
))

;; sound
(add-option default-cave-options 'amoeba-sound #t (list
  bdcff: "AmoebaProperties.sound"
  help: "Controls if the living amoeba has sound or not."
))
(add-option default-cave-options 'magic-wall-sound #t (list
  bdcff: "MagicWallProperties.sound"
  help: "If true, the activated magic wall will have sound."
))
(add-option default-cave-options 'slime-sound #t (list
  bdcff: "SlimeProperties.sound"
  help: "If true, the elements passing slime will have sound."
))
(add-option default-cave-options 'lava-sound #t (list
  bdcff: "LavaProperties.sound"
  help: "If true, the elements sinking in lava will have sound."
))
(add-option default-cave-options 'replicator-sound #t (list
  bdcff: "ReplicatorProperties.sound"
  help: "If true, the new element appearing under the replicator will make sound."
))
(add-option default-cave-options 'acid-spread-sound #t (list
  bdcff: "AcidProperties.sound"
  help: "If true, the acid spreading will have sound."
))
(add-option default-cave-options 'biter-sound #t (list
  bdcff: "BiterProperties.sound"
  help: "Biters eating something or pushing a stone will have sound."
))
(add-option default-cave-options 'bladder-sound #t (list
  bdcff: "BladderProperties.sound"
  help: "Bladders moving and being pushed can have sound."
))
(add-option default-cave-options 'water-sound #t (list
  bdcff: "WaterProperties.sound"
  help: "If true, the cave containing water will have sound."
))
(add-option default-cave-options 'stone-sound #t (list
  bdcff: "Stone.sound"
  help: "If true, falling and pushed stones will have sound."
))
(add-option default-cave-options 'nut-sound #t (list
  bdcff: "Nut.sound"
  help: "If true, falling and cracked nuts have sound."
))
(add-option default-cave-options 'diamond-sound #t (list
  bdcff: "Diamond.sound"
  help: "If true, falling diamonds will have sound."
))
(add-option default-cave-options 'falling-wall-sound #t (list
  bdcff: "FallingWall.sound"
  help: "If true, falling wall will have sound."
))
(add-option default-cave-options 'expanding-wall-sound #t (list
  bdcff: "ExpandingWall.sound"
  help: "If true, expanding wall will have sound."
))
(add-option default-cave-options 'nitro-sound #t (list
  bdcff: "NitroPack.sound"
  help: "If true, falling and pushed nitro packs will have sound."
))
(add-option default-cave-options 'pneumatic-hammer-sound #t (list
  bdcff: "PneumaticHammer.sound"
  help: "If true, using the pneumatic hammer will have sound."
))
(add-option default-cave-options 'bladder-spender-sound #t (list
  bdcff: "BladderSpender.sound"
  help: "If true, the bladder spender will make sound, when the bladder appears."
))
(add-option default-cave-options 'bladder-convert-sound #t (list
  bdcff: "BladderConvert.sound"
  help: "If true, the bladder converting to a clock will make sound."
))
(add-option default-cave-options 'gravity-change-sound #t (list
  bdcff: "GravityChange.sound"
  help: "If true, the gravity changing will make sound."
))
(add-option default-cave-options 'creature-direction-auto-change-sound #t (list
  bdcff: "EnemyDirectionProperties.sound"
  help: "If this is set to true, creatures changing direction will be signaled by a sound."
))

;; creature effects
(add-option default-cave-options 'creatures-backwards #f (list
  cave-hash: #t
  bdcff: "EnemyDirectionProperties.startbackwards"
  help: "Whether the direction creatures travel will already be switched at the cave start."
))
(add-option default-cave-options 'creatures-direction-auto-change-time 0 (list
  min-value: 0
  max-value: 999
  cave-hash: #t
  bdcff: "EnemyDirectionProperties.time"
  help: "If this is greater than zero, creatures will automatically \
change direction in every x seconds."
))
(add-option default-cave-options 'creatures-direction-auto-change-on-start #f (list
  cave-hash: #t
  bdcff: "EnemyDirectionProperties.changeathatching"
  help: "If this is set to true, creatures also turn at the start signal. \
If false, the first change in direction occurs only later."
))

;; cave effects
(add-option default-cave-options 'explosion-effect etype:O_SPACE (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "EXPLOSIONEffect"
  help: "This element appears in places where an explosion finishes."
))
;; some old caves are using this
(add-option default-cave-options 'explosion-3-effect etype:O_SPACE (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "EXPLOSION3S"
  help: "This element appears in places where an explosion frame 3 finishes."
))
(add-option default-cave-options 'diamond-birth-effect etype:O_DIAMOND (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "DIAMONDBIRTHEffect"
  help: "When a diamond birth animation reaches its end, it will leave \
this element there. This can be used to change the element butterflies explode to."
))
(add-option default-cave-options 'bomb-explosion-effect etype:O_BRICK (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "BOMBEXPLOSIONeffect"
  help: "Use this setting to select the element the exploding bomb creates."
))
(add-option default-cave-options 'nitro-explosion-effect etype:O_SPACE (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "NITROEXPLOSIONeffect"
  help: "The nitro explosions can create some element other than space."
))
(add-option default-cave-options 'firefly-explode-to etype:O_EXPLODE_1 (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "FireflyExplodeTo"
  help: "When a firefly explodes, it will create this element. \
Change this setting wisely. The firefly is a traditional element \
which is expected to explode to empty space."
))
(add-option default-cave-options 'alt-firefly-explode-to etype:O_EXPLODE_1 (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "AltFireflyExplodeTo"
  help: "When an alternative firefly explodes, it will create this element. \
Use this setting wisely. Do not create a firefly which explodes to stones, \
for example: use the stonefly instead."
))
(add-option default-cave-options 'butterfly-explode-to etype:O_PRE_DIA_1 (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "ButterflyExplodeTo"
  help: "When a butterfly explodes, it will create this element. \
Use this setting wisely. Butterflies should explode to diamonds. \
If you need a creature which explodes to space, use the firefly instead."
))
(add-option default-cave-options 'alt-butterfly-explode-to etype:O_PRE_DIA_1 (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "AltButterflyExplodeTo"
  help: "When an alternative butterfly explodes, it will create this element. \
Use this setting wisely."
))
(add-option default-cave-options 'stonefly-explode-to etype:O_PRE_STONE_1 (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "StoneflyExplodeTo"
  help: "When a stonefly explodes, it will create this element."
))
(add-option default-cave-options 'dragonfly-explode-to etype:O_EXPLODE_1 (list
  type: 'ELEMENT
  cave-hash: #t
  bdcff: "DragonflyExplodeTo"
  help: "When a dragonfly explodes, it will create this element."
))

(add-option default-cave-options 'stone-falling-effect etype:O_STONE_F (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "BOULDERfallingeffect"
  help: "When a stone begins falling, it converts to this element."
))
(add-option default-cave-options 'stone-bouncing-effect etype:O_STONE (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "BOULDERbouncingeffect"
  bdcff-old: "BOUNCING_BOULDER"
  help: "When a stone stops falling and rolling, it converts to this element."
))
(add-option default-cave-options 'diamond-falling-effect etype:O_DIAMOND_F (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "DIAMONDfallingeffect"
  bdcff-old: "STARTING_FALING_DIAMOND"  ;; with ine "L", yep
  help: "When a diamond begins falling, it converts to this element."
))
(add-option default-cave-options 'diamond-bouncing-effect etype:O_DIAMOND (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "DIAMONDbouncingeffect"
  help: "When a diamond stops falling and rolling, it converts to this element."
))

;; visual effects
(add-option default-cave-options 'expanding-wall-looks-like etype:O_BRICK (list
  type: 'ELEMENT
  effect: #t
  can-be-empty: #t
  cave-hash: #t
  bdcff: "EXPANDINGWALLLOOKSLIKEeffect"
  help: "This is a compatibility setting for old caves. \
If you need an expanding wall which looks like steel, you should \
rather choose the expanding steel wall from the element box."
))
(add-option default-cave-options 'respect-expanding-wall-looks-like #f (list
  help: "I (k8) strongly believe that hiding expanding walls was The Very Bad Idea."
))
(add-option default-cave-options 'dirt-looks-like etype:O_DIRT (list
  type: 'ELEMENT
  effect: #t
  cave-hash: #t
  bdcff: "DIRTLOOKSLIKEeffect"
  bdcff-old: "DIRT"
  help: "Compatibility setting. Use it wisely! Anything other than Dirt 2 \
(which can be used to emulate the Dirt Mod) is not recommended."
))
(add-option default-cave-options 'respect-dirt-looks-like #f (list
  help: "I (k8) strongly believe that hiding dirt was The Very Bad Idea."
))

;; gravity
;; i will not support this. this is fuckin' stupidity.
;; "Gravitation": DIRECTION
(add-option default-cave-options 'gravity-x 0)
(add-option default-cave-options 'gravity-y -1)
(add-option default-cave-options 'gravity-switch-active #f (list
  bdcff: "GravitationSwitchActive"
  help: "If set to true, the gravitation switch will be already activated, \
when the cave is started, as if a pot has already been collected."
))
(add-option default-cave-options 'gravity-change-time 10 (list
  min-value: 1
  max-value: 60
  bdcff: "GravitationChangeDelay"
  help: "The gravitation changes after a while using the gravitation switch. \
This option sets the number of seconds to wait."
))

(add-option default-cave-options 'skeletons-needed-for-pot 5 (list
  min-value: 0
  max-value: 50
  cave-hash: #t
  bdcff: "SkeletonsForPot"
  help: "The number of skeletons to be collected to be able to use a pot."
))

;; compatibility
;; ignored by the engine
(add-option default-cave-options 'border-scan-first-and-last #t (list
  cave-hash: #t
  bdcff: "BorderProperties.scan"
  help: "Elements move on first and last row, too. Usually those rows are the border. \
The games created by the original editor were not allowed to put \
anything but steel wall there, so it was not apparent that the \
borders were not processed by the engine. Some old caves need this \
for compatibility; it is not recommended to change this setting \
for newly designed caves, though."
))
;; ignored by the engine (but used by some map object renderers)
(add-option default-cave-options 'lineshift #f (list
  cave-hash: #t
  bdcff: "BorderProperties.lineshift"
  help: "If this is set to true, the player exiting on either side \
will appear one row lower or upper on the other side."
))
;; #f in GDash; always active in our engine
;; need to be set to #f to read correct defaults, though
(add-option default-cave-options 'wraparound-objects #f (list
  cave-hash: #t
  bdcff: "BorderProperties.objectwraparound"
  help: "If true, objects will wrap around the cave borders as well, \
ie. if you drag a line to the left, part of it will appear on the \
right hand side of the cave. The drawing in this case is also \
affected by the line shifting border property. If that one is \
enabled, too, crossing the left hand side or right hand side \
boundary will decrement or increment the row, and crossing the \
top or the bottom boundary will have no effect at all."
))
(add-option default-cave-options 'short-explosions #t (list
  cave-hash: #t
  bdcff: "ShortExplosions"
  help: "In 1stB and newer engines, explosions were longer, they took five \
cave frames to complete, as opposed to four frames in the original.\n\
In the original engine, already scanned cells were changed to \"explo1\", \
while not scanned yet were set to \"explo0\".\n\
This way, at the end of the scan all cells will contain \"explo1\" (second explosion frame)."
))
(add-option default-cave-options 'skeletons-worth-diamonds 0 (list
  cave-hash: #t
  bdcff: "SkeletonsWorthDiamonds"
  help: "The number of diamonds each skeleton is worth. \
Normally skeletons are used for letting the player use the pot! \
They are not intended to be used as a second kind of diamond."
))
;; do not even bother reporting this, as we have no way to change the gravity.
(add-option default-cave-options 'gravity-affects-all #t (list
  bdcff: "GravityAffectsAll"
  help: "If this is enabled, changing the gravity will also affect \
bladders (moving and pushing), bladder spenders, falling walls and waiting stones. \
Otherwise, those elements behave as gravity was always pointing downwards. \
This is a compatibility setting which is not recommended to change. \
It is intended for imported caves."
))

(add-option default-cave-options 'reveal-invisible-outbox #t (list
  help: "Replace all invisible (pre)outboxes with visible ones on map loading?"
))

(add-option default-cave-options 'reveal-pre-outbox #t (list
  help: "Use different graphics for inactive outbox?"
))


(define bdcff-option-map #nil)

;; option BDCFF name -> internal option name
define build-bdcff-option-map()
  define map dict:new()
  define appender(key defval props)
    define nn lax-cdr(assq(bdcff: props))
    if {string? nn}
      dict:put! map nn key
    {nn := lax-cdr(assq(bdcff-old: props))}
    if {string? nn}
      dict:put! map nn key
  options-foreach default-cave-options appender
  gset! bdcff-option-map map

(build-bdcff-option-map)

(printf "%o known options.\n" (dict:length default-cave-options))
