(register-entity (edef:parse-new
  index: etype:O_SPACE
  name: "Space"
  bdcff-name: "SPACE"
  bdcff-char: 32
  editor-image: 0
  simple-image: 0
  game-image: 0
  props: '(P_AMOEBA_CONSUMES P_PLAYER_EDIBLE
           (P_WALK_SOUND . GD_S_WALK_EMPTY))
))
(register-entity (edef:parse-new
  index: etype:O_DIRT
  name: "Dirt"
  bdcff-name: "DIRT"
  bdcff-char: #\.
  editor-image: 2
  simple-image: 2
  game-image: 2
  props: '(P_AMOEBA_CONSUMES P_VISUAL_EFFECT P_DIRT P_PLAYER_EDIBLE
           (P_WALK_SOUND . GD_S_WALK_EARTH))
))
(register-entity (edef:parse-new
  index: etype:O_DIRT_SLOPED_UP_RIGHT
  name: "Sloped dirt (up & right)"
  bdcff-name: "DIRTSLOPEDUPRIGHT"
  editor-image: 280
  simple-image: 280
  game-image: 280
  props: '(P_DIRT P_SLOPED_UP P_SLOPED_RIGHT P_AMOEBA_CONSUMES P_PLAYER_EDIBLE
           (P_WALK_SOUND . GD_S_WALK_EARTH))
))
(register-entity (edef:parse-new
  index: etype:O_DIRT_SLOPED_UP_LEFT
  name: "Sloped dirt (up & left)"
  bdcff-name: "DIRTSLOPEDUPLEFT"
  editor-image: 281
  simple-image: 281
  game-image: 281
  props: '(P_DIRT P_SLOPED_UP P_SLOPED_LEFT P_AMOEBA_CONSUMES P_PLAYER_EDIBLE
           (P_WALK_SOUND . GD_S_WALK_EARTH))
))
(register-entity (edef:parse-new
  index: etype:O_DIRT_SLOPED_DOWN_LEFT
  name: "Sloped dirt (down & left)"
  bdcff-name: "DIRTSLOPEDDOWNLEFT"
  editor-image: 282
  simple-image: 282
  game-image: 282
  props: '(P_DIRT P_SLOPED_DOWN P_SLOPED_LEFT P_AMOEBA_CONSUMES P_PLAYER_EDIBLE
           (P_WALK_SOUND . GD_S_WALK_EARTH))
))
(register-entity (edef:parse-new
  index: etype:O_DIRT_SLOPED_DOWN_RIGHT
  name: "Sloped dirt (down & right)"
  bdcff-name: "DIRTSLOPEDDOWNRIGHT"
  editor-image: 283
  simple-image: 283
  game-image: 283
  props: '(P_DIRT P_SLOPED_DOWN P_SLOPED_RIGHT P_AMOEBA_CONSUMES P_PLAYER_EDIBLE
           (P_WALK_SOUND . GD_S_WALK_EARTH))
))
(register-entity (edef:parse-new
  index: etype:O_DIRT_BALL
  name: "Dirt ball"
  bdcff-name: "DIRTBALL"
  editor-image: 289
  simple-image: 289
  game-image: 289
  props: '(P_DIRT P_SLOPED P_AMOEBA_CONSUMES P_MOVED_BY_CONVEYOR_TOP P_PLAYER_EDIBLE
           (P_FALL_SOUND . GD_S_DIRT_BALL)
           (P_WALK_SOUND . GD_S_WALK_EARTH))
))
(register-entity (edef:parse-new
  index: etype:O_DIRT_BALL_F
  name: "Dirt ball (falling)"
  bdcff-name: "DIRTBALLf"
  editor-image: 289
  simple-image: 289
  game-image: 289
  props: '((P_FALL_SOUND . GD_S_DIRT_BALL))
))
(register-entity (edef:parse-new
  index: etype:O_DIRT_LOOSE
  name: "Loose dirt"
  bdcff-name: "DIRTLOOSE"
  editor-image: 352
  simple-image: 352
  game-image: 352
  props: '(P_DIRT P_AMOEBA_CONSUMES P_MOVED_BY_CONVEYOR_TOP P_PLAYER_EDIBLE
           (P_FALL_SOUND . GD_S_DIRT_BALL)
           (P_WALK_SOUND . GD_S_WALK_EARTH))
))
(register-entity (edef:parse-new
  index: etype:O_DIRT_LOOSE_F
  name: "Loose dirt (falling)"
  bdcff-name: "DIRTLOOSEf"
  editor-image: 352
  simple-image: 352
  game-image: 352
  props: '((P_FALL_SOUND . GD_S_DIRT_BALL))
))
(register-entity (edef:parse-new
  index: etype:O_DIRT2
  name: "Dirt 2"
  bdcff-name: "DIRT2"
  editor-image: 3
  simple-image: 3
  game-image: 3
  props: '(P_DIRT P_AMOEBA_CONSUMES P_PLAYER_EDIBLE
           (P_WALK_SOUND . GD_S_WALK_EARTH))
))
(register-entity (edef:parse-new
  index: etype:O_BRICK
  name: "Brick wall"
  bdcff-name: "WALL"
  bdcff-char: #\w
  editor-image: 5
  simple-image: 5
  game-image: 5
  props: `(P_SLOPED P_BLADDER_SLOPED
           P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE))
))
(register-entity (edef:parse-new
  index: etype:O_BRICK_SLOPED_UP_RIGHT
  name: "Sloped brick wall (up & right)"
  bdcff-name: "WALLSLOPEDUPRIGHT"
  editor-image: 276
  simple-image: 276
  game-image: 276
  props: `(P_SLOPED_UP P_SLOPED_RIGHT P_BLADDER_SLOPED
           P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE))
))
(register-entity (edef:parse-new
  index: etype:O_BRICK_SLOPED_UP_LEFT
  name: "Sloped brick wall (up & left)"
  bdcff-name: "WALLSLOPEDUPLEFT"
  editor-image: 277
  simple-image: 277
  game-image: 277
  props: `(P_SLOPED_UP P_SLOPED_LEFT P_BLADDER_SLOPED
           P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE))
))
(register-entity (edef:parse-new
  index: etype:O_BRICK_SLOPED_DOWN_LEFT
  name: "Sloped brick wall (down & left)"
  bdcff-name: "WALLSLOPEDDOWNLEFT"
  editor-image: 278
  simple-image: 278
  game-image: 278
  props: `(P_SLOPED_DOWN P_SLOPED_LEFT P_BLADDER_SLOPED
           P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE))
))
(register-entity (edef:parse-new
  index: etype:O_BRICK_SLOPED_DOWN_RIGHT
  name: "Sloped brick wall (down & right)"
  bdcff-name: "WALLSLOPEDDOWNRIGHT"
  editor-image: 279
  simple-image: 279
  game-image: 279
  props: `(P_SLOPED_DOWN P_SLOPED_RIGHT P_BLADDER_SLOPED
           P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE))
))
(register-entity (edef:parse-new
  index: etype:O_BRICK_NON_SLOPED
  name: "Non-sloped brick wall"
  bdcff-name: "WALLNONSLOPED"
  editor-image: eximg:brick_non_sloped
  simple-image: eximg:brick_non_sloped
  game-image: 5
  props: `(P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE))
))
(register-entity (edef:parse-new
  index: etype:O_MAGIC_WALL
  name: "Magic wall"
  bdcff-name: "MAGICWALL"
  bdcff-char: #\M
  editor-image: 184
  simple-image: (- 184)
  game-image: (- 184)
  inactive-image: 5
  props: `(P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_OUTBOX
  name: "Outbox"
  bdcff-name: "OUTBOX"
  bdcff-char: #\X
  editor-image: eximg:pre_outbox_nonblink
  simple-image: (- eximg:pre_outbox_frame_1)
  game-image: 22
))
(register-entity (edef:parse-new
  index: etype:O_OUTBOX
  name: "Outbox (open)"
  bdcff-name: "OUTBOXopen"
  editor-image: eximg:outbox
  simple-image: eximg:outbox
  game-image: 22
  inactive-image: 23
))
(register-entity (edef:parse-new
  index: etype:O_PRE_INVIS_OUTBOX
  name: "Invisible outbox"
  bdcff-name: "HIDDENOUTBOX"
  bdcff-char: #\H
  editor-image: eximg:pre_invis_outbox
  simple-image: eximg:pre_invis_outbox
  game-image: 22
))
(register-entity (edef:parse-new
  index: etype:O_INVIS_OUTBOX
  name: "Invisible outbox (open)"
  bdcff-name: "HIDDENOUTBOXopen"
  editor-image: eximg:invis_outbox
  simple-image: eximg:invis_outbox
  game-image: 22
))
(register-entity (edef:parse-new
  index: etype:O_STEEL
  name: "Steel wall"
  bdcff-name: "STEELWALL"
  bdcff-char: #\W
  editor-image: 4
  simple-image: 4
  game-image: 4
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_STEEL_SLOPED_UP_RIGHT
  name: "Sloped steel wall (up & right)"
  bdcff-name: "STEELWALLSLOPEDUPRIGHT"
  editor-image: 284
  simple-image: 284
  game-image: 284
  props: '(P_SLOPED_UP P_SLOPED_RIGHT P_NON_EXPLODABLE)
))
(register-entity (edef:parse-new
  index: etype:O_STEEL_SLOPED_UP_LEFT
  name: "Sloped steel wall (up & left)"
  bdcff-name: "STEELWALLSLOPEDUPLEFT"
  editor-image: 285
  simple-image: 285
  game-image: 285
  props: '(P_SLOPED_UP P_SLOPED_LEFT P_NON_EXPLODABLE)
))
(register-entity (edef:parse-new
  index: etype:O_STEEL_SLOPED_DOWN_LEFT
  name: "Sloped steel wall (down & left)"
  bdcff-name: "STEELWALLSLOPEDDOWNLEFT"
  editor-image: 286
  simple-image: 286
  game-image: 286
  props: '(P_SLOPED_DOWN P_SLOPED_LEFT P_NON_EXPLODABLE)
))
(register-entity (edef:parse-new
  index: etype:O_STEEL_SLOPED_DOWN_RIGHT
  name: "Sloped steel wall (down & right)"
  bdcff-name: "STEELWALLSLOPEDDOWNRIGHT"
  editor-image: 287
  simple-image: 287
  game-image: 287
  props: '(P_SLOPED_DOWN P_SLOPED_RIGHT P_NON_EXPLODABLE)
))
(register-entity (edef:parse-new
  index: etype:O_STEEL_EXPLODABLE
  name: "Explodable steel wall"
  bdcff-name: "STEELWALLDESTRUCTABLE"
  bdcff-char: #\E
  editor-image: 72
  simple-image: 72
  game-image: 4
  props: `(P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE)
           (P_ALT_NAME . "WALL2"))
))
(register-entity (edef:parse-new
  index: etype:O_STEEL_EATABLE
  name: "Eatable steel wall"
  bdcff-name: "STEELWALLEATABLE"
  editor-image: eximg:steel_eatable
  simple-image: eximg:steel_eatable
  game-image: 4
  props: '(P_PLAYER_EDIBLE (P_WALK_SOUND . GD_S_WALK_EARTH))
))
(register-entity (edef:parse-new
  index: etype:O_BRICK_EATABLE
  name: "Eatable brick wall"
  bdcff-name: "WALLEATABLE"
  editor-image: eximg:brick_eatable
  simple-image: eximg:brick_eatable
  game-image: 5
  props: '(P_PLAYER_EDIBLE (P_WALK_SOUND . GD_S_WALK_EARTH))
))
(register-entity (edef:parse-new
  index: etype:O_STONE
  name: "Stone"
  bdcff-name: "BOULDER"
  bdcff-char: #\r
  editor-image: 1
  simple-image: 1
  game-image: 1
  props: '(P_SLOPED P_MOVED_BY_CONVEYOR_TOP
           (P_PUSH_SOUND . GD_S_STONE)
           (P_FALL_SOUND . GD_S_STONE))
))
(register-entity (edef:parse-new
  index: etype:O_STONE_F
  name: "Stone, falling"
  bdcff-name: "BOULDERf"
  bdcff-char: #\R
  editor-image: eximg:stone_f
  simple-image: eximg:stone_f
  game-image: 1
  props: '((P_PUSH_SOUND . GD_S_STONE)
           (P_FALL_SOUND . GD_S_STONE)
           (P_ALT_NAME . "FALLING_BOULDER"))
))
(register-entity (edef:parse-new
  index: etype:O_FLYING_STONE
  name: "Flying stone"
  bdcff-name: "FLYINGBOULDER"
  editor-image: 357
  simple-image: 357
  game-image: 357
  props: '(P_SLOPED P_MOVED_BY_CONVEYOR_BOTTOM
           (P_PUSH_SOUND . GD_S_STONE)
           (P_FALL_SOUND . GD_S_STONE))
))
(register-entity (edef:parse-new
  index: etype:O_FLYING_STONE_F
  name: "Flying stone, flying"
  bdcff-name: "FLYINGBOULDERf"
  editor-image: eximg:flying_stone_f
  simple-image: eximg:flying_stone_f
  game-image: 357
  props: '((P_PUSH_SOUND . GD_S_STONE)
           (P_FALL_SOUND . GD_S_STONE))
))
(register-entity (edef:parse-new
  index: etype:O_MEGA_STONE
  name: "Mega stone"
  bdcff-name: "MEGABOULDER"
  editor-image: 272
  simple-image: 272
  game-image: 272
  props: '(P_SLOPED P_MOVED_BY_CONVEYOR_TOP
           (P_PUSH_SOUND . GD_S_STONE)
           (P_FALL_SOUND . GD_S_STONE))
))
(register-entity (edef:parse-new
  index: etype:O_MEGA_STONE_F
  name: "Mega stone, falling"
  bdcff-name: "MEGABOULDERf"
  editor-image: eximg:mega_stone_falling
  simple-image: eximg:mega_stone_falling
  game-image: 272
  props: '((P_PUSH_SOUND . GD_S_STONE)
           (P_FALL_SOUND . GD_S_STONE))
))
(register-entity (edef:parse-new
  index: etype:O_DIAMOND
  name: "Diamond"
  bdcff-name: "DIAMOND"
  bdcff-char: #\d
  editor-image: 248
  simple-image: (- 248)
  game-image: (- 248)
  props: '(P_SLOPED P_MOVED_BY_CONVEYOR_TOP
           P_DIAMOND
           (P_PUSH_SOUND . GD_S_DIAMOND_COLLECT)
           (P_FALL_SOUND . GD_S_DIAMOND_RANDOM))
))
(register-entity (edef:parse-new
  index: etype:O_DIAMOND_F
  name: "Diamond, falling"
  bdcff-name: "DIAMONDf"
  bdcff-char: #\D
  editor-image: eximg:diamond_f
  simple-image: eximg:diamond_f
  game-image: (- 248)
  props: '(P_DIAMOND
           (P_PUSH_SOUND . GD_S_DIAMOND_COLLECT)
           (P_FALL_SOUND . GD_S_DIAMOND_RANDOM)
           (P_ALT_NAME . "FALLING_DIAMOND"))
))
(register-entity (edef:parse-new
  index: etype:O_FLYING_DIAMOND
  name: "Flying diamond"
  bdcff-name: "FLYINGDIAMOND"
  editor-image: 344
  simple-image: (- 344)
  game-image: (- 344)
  props: '(P_SLOPED P_MOVED_BY_CONVEYOR_BOTTOM
           P_DIAMOND
           (P_PUSH_SOUND . GD_S_DIAMOND_COLLECT)
           (P_FALL_SOUND . GD_S_DIAMOND_RANDOM))
))
(register-entity (edef:parse-new
  index: etype:O_FLYING_DIAMOND_F
  name: "Flying diamond, flying"
  bdcff-name: "FLYINGDIAMONDf"
  editor-image: eximg:flying_diamond_f
  simple-image: eximg:flying_diamond_f
  game-image: (- 344)
  props: '(P_DIAMOND
           (P_PUSH_SOUND . GD_S_DIAMOND_COLLECT)
           (P_FALL_SOUND . GD_S_DIAMOND_RANDOM))
))
(register-entity (edef:parse-new
  index: etype:O_NUT
  name: "Nut"
  bdcff-name: "NUT"
  editor-image: 358
  simple-image: 358
  game-image: 358
  props: '(P_SLOPED P_MOVED_BY_CONVEYOR_TOP
           (P_PUSH_SOUND . GD_S_NUT)
           (P_FALL_SOUND . GD_S_NUT))
))
(register-entity (edef:parse-new
  index: etype:O_NUT_F
  name: "Nut, falling"
  bdcff-name: "NUTf"
  editor-image: eximg:nut_f
  simple-image: eximg:nut_f
  game-image: 358
  props: '((P_PUSH_SOUND . GD_S_NUT)
           (P_FALL_SOUND . GD_S_NUT))
))
(register-entity (edef:parse-new
  index: etype:O_BLADDER_SPENDER
  name: "Bladder Spender"
  bdcff-name: "BLADDERSPENDER"
  editor-image: 6
  simple-image: 6
  game-image: 6
  props: '((P_SOUND . GD_S_BLADDER_SPENDER))
))
(register-entity (edef:parse-new
  index: etype:O_INBOX
  name: "Inbox"
  bdcff-name: "INBOX"
  bdcff-char: #\P
  editor-image: 35
  simple-image: 35
  inactive-image: 23
  game-image: 22
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_H_EXPANDING_WALL
  name: "Expanding wall, horizontal"
  bdcff-name: "HEXPANDINGWALL"
  bdcff-char: #\x
  editor-image: eximg:h_expanding_wall
  simple-image: eximg:h_expanding_wall
  ;game-image: 5
  game-image: 40  ;; i don't think that having them hidden was The Great Idea
  props: `(P_VISUAL_EFFECT
           P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE)
           (P_SOUND . GD_S_EXPANDING_WALL)
           (P_ALT_NAME . "HEXPANDING_WALL"))
))
(register-entity (edef:parse-new
  index: etype:O_V_EXPANDING_WALL
  name: "Expanding wall, vertical"
  bdcff-name: "VEXPANDINGWALL"
  bdcff-char: #\v
  editor-image: eximg:v_expanding_wall
  simple-image: eximg:v_expanding_wall
  ;game-image: 5
  game-image: 41  ;; i don't think that having them hidden was The Great Idea
  props: `(P_VISUAL_EFFECT
           P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE)
           (P_SOUND . GD_S_EXPANDING_WALL))
))
(register-entity (edef:parse-new
  index: etype:O_EXPANDING_WALL
  name: "Expanding wall"
  bdcff-name: "EXPANDINGWALL"
  bdcff-char: #\e
  editor-image: eximg:expanding_wall
  simple-image: eximg:expanding_wall
  ;game-image: 5
  game-image: 364  ;; i don't think that having them hidden was The Great Idea
  props: `(P_VISUAL_EFFECT
           P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE)
           (P_SOUND . GD_S_EXPANDING_WALL))
))
(register-entity (edef:parse-new
  index: etype:O_H_EXPANDING_STEEL_WALL
  name: "Expanding steel wall, horizontal"
  bdcff-name: "HEXPANDINGSTEELWALL"
  editor-image: eximg:h_expanding_steel_wall
  simple-image: eximg:h_expanding_steel_wall
  ;game-image: 4
  game-image: 365  ;; i don't think that having them hidden was The Great Idea
  props: '(P_NON_EXPLODABLE (P_SOUND . GD_S_EXPANDING_WALL))
))
(register-entity (edef:parse-new
  index: etype:O_V_EXPANDING_STEEL_WALL
  name: "Expanding steel wall, vertical"
  bdcff-name: "VEXPANDINGSTEELWALL"
  editor-image: eximg:v_expanding_steel_wall
  simple-image: eximg:v_expanding_steel_wall
  ;game-image: 4
  game-image: 366  ;; i don't think that having them hidden was The Great Idea
  props: '(P_NON_EXPLODABLE (P_SOUND . GD_S_EXPANDING_WALL))
))
(register-entity (edef:parse-new
  index: etype:O_EXPANDING_STEEL_WALL
  name: "Expanding steel wall"
  bdcff-name: "EXPANDINGSTEELWALL"
  editor-image: eximg:expanding_steel_wall
  simple-image: eximg:expanding_steel_wall
  ;game-image: 4
  game-image: 367  ;; i don't think that having them hidden was The Great Idea
  props: '(P_NON_EXPLODABLE (P_SOUND . GD_S_EXPANDING_WALL))
))
(register-entity (edef:parse-new
  index: etype:O_EXPANDING_WALL_SWITCH
  name: "Expanding wall switch"
  bdcff-name: "EXPANDINGWALLSWITCH"
  editor-image: 40
  simple-image: 40
  game-image: 40
))
(register-entity (edef:parse-new
  index: etype:O_CREATURE_SWITCH
  name: "Creature direction switch"
  bdcff-name: "FIREFLYBUTTERFLYSWITCH"
  editor-image: 18
  simple-image: 18
  game-image: 18
))
(register-entity (edef:parse-new
  index: etype:O_BITER_SWITCH
  name: "Biter switch"
  bdcff-name: "BITERSWITCH"
  editor-image: 12
  simple-image: 12
  game-image: 12
))
(register-entity (edef:parse-new
  index: etype:O_REPLICATOR_SWITCH
  name: "Replicator switch"
  bdcff-name: "REPLICATORSWITCH"
  editor-image: 290
  simple-image: 290
  game-image: 290
))
(register-entity (edef:parse-new
  index: etype:O_CONVEYOR_SWITCH
  name: "Conveyor belt power switch"
  bdcff-name: "CONVEYORSWITCH"
  editor-image: 356
  simple-image: 356
  game-image: 356
))
(register-entity (edef:parse-new
  index: etype:O_CONVEYOR_DIR_SWITCH
  name: "Conveyor belt direction switch"
  bdcff-name: "CONVEYORDIRECTIONSWITCH"
  editor-image: 353
  simple-image: 353
  game-image: 353
))
(register-entity (edef:parse-new
  index: etype:O_ACID
  name: "Acid"
  bdcff-name: "ACID"
  editor-image: 20
  simple-image: 20
  game-image: 20
  props: '((P_SOUND . GD_S_ACID_SPREAD))
))
(register-entity (edef:parse-new
  index: etype:O_FALLING_WALL
  name: "Falling wall"
  bdcff-name: "FALLINGWALL"
  editor-image: eximg:falling_wall
  simple-image: eximg:falling_wall
  game-image: 5
  props: `(P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE)
           (P_FALL_SOUND . GD_S_FALLING_WALL))
))
(register-entity (edef:parse-new
  index: etype:O_FALLING_WALL_F
  name: "Falling wall, falling"
  bdcff-name: "FALLINGWALLf"
  editor-image: eximg:falling_wall_falling
  simple-image: eximg:falling_wall_falling
  game-image: 5
  props: `(P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_SPACE)
           (P_FALL_SOUND . GD_S_FALLING_WALL))
))
(register-entity (edef:parse-new
  index: etype:O_BOX
  name: "Box"
  bdcff-name: "SOKOBANBOX"
  editor-image: 21
  simple-image: 21
  game-image: 21
  props: '((P_PUSH_SOUND . GD_S_BOX_PUSH))
))
(register-entity (edef:parse-new
  index: etype:O_TIME_PENALTY
  name: "Time penalty"
  bdcff-name: "TIMEPENALTY"
  editor-image: eximg:time_penalty
  simple-image: eximg:time_penalty
  game-image: 9
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_GRAVESTONE
  name: "Gravestone"
  bdcff-name: "GRAVESTONE"
  bdcff-char: #\G
  editor-image: 9
  simple-image: 9
  game-image: 9
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_STONE_GLUED
  name: "Glued stone"
  bdcff-name: "GLUEDBOULDER"
  editor-image: eximg:stone_glued
  simple-image: eximg:stone_glued
  game-image: 1
  props: 'P_SLOPED
))
(register-entity (edef:parse-new
  index: etype:O_DIAMOND_GLUED
  name: "Glued diamond"
  bdcff-name: "GLUEDDIAMOND"
  editor-image: eximg:diamond_glued
  simple-image: eximg:diamond_glued
  game-image: (- 248)
  props: 'P_SLOPED
))
(register-entity (edef:parse-new
  index: etype:O_DIAMOND_KEY
  name: "Diamond key"
  bdcff-name: "DIAMONDRELEASEKEY"
  editor-image: 11
  simple-image: 11
  game-image: 11
  props: '((P_PUSH_SOUND . GD_S_KEY_COLLECT))
))
(register-entity (edef:parse-new
  index: etype:O_TRAPPED_DIAMOND
  name: "Trapped diamond"
  bdcff-name: "TRAPPEDDIAMOND"
  editor-image: 10
  simple-image: 10
  game-image: 10
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_CLOCK
  name: "Clock"
  bdcff-name: "CLOCK"
  editor-image: 16
  simple-image: 16
  game-image: 16
  props: '((P_PUSH_SOUND . GD_S_CLOCK_COLLECT))
))
(register-entity (edef:parse-new
  index: etype:O_DIRT_GLUED
  name: "Glued dirt"
  bdcff-name: "GLUEDDIRT"
  editor-image: eximg:dirt_glued
  simple-image: eximg:dirt_glued
  game-image: 2
))
(register-entity (edef:parse-new
  index: etype:O_KEY_1
  name: "Key 1"
  bdcff-name: "KEY1"
  editor-image: 67
  simple-image: 67
  game-image: 67
  props: '((P_PUSH_SOUND . GD_S_KEY_COLLECT))
))
(register-entity (edef:parse-new
  index: etype:O_KEY_2
  name: "Key 2"
  bdcff-name: "KEY2"
  editor-image: 68
  simple-image: 68
  game-image: 68
  props: '((P_PUSH_SOUND . GD_S_KEY_COLLECT))
))
(register-entity (edef:parse-new
  index: etype:O_KEY_3
  name: "Key 3"
  bdcff-name: "KEY3"
  editor-image: 69
  simple-image: 69
  game-image: 69
  props: '((P_PUSH_SOUND . GD_S_KEY_COLLECT))
))
(register-entity (edef:parse-new
  index: etype:O_DOOR_1
  name: "Door 1"
  bdcff-name: "DOOR1"
  editor-image: 64
  simple-image: 64
  game-image: 64
  props: '((P_PUSH_SOUND . GD_S_DOOR_OPEN))
))
(register-entity (edef:parse-new
  index: etype:O_DOOR_2
  name: "Door 2"
  bdcff-name: "DOOR2"
  editor-image: 65
  simple-image: 65
  game-image: 65
  props: '((P_PUSH_SOUND . GD_S_DOOR_OPEN))
))
(register-entity (edef:parse-new
  index: etype:O_DOOR_3
  name: "Door 3"
  bdcff-name: "DOOR3"
  editor-image: 66
  simple-image: 66
  game-image: 66
  props: '((P_PUSH_SOUND . GD_S_DOOR_OPEN))
))
(register-entity (edef:parse-new
  index: etype:O_POT
  name: "Pot"
  bdcff-name: "POT"
  editor-image: 63
  simple-image: 63
  game-image: 63
))
(register-entity (edef:parse-new
  index: etype:O_GRAVITY_SWITCH
  name: "Gravity switch"
  bdcff-name: "GRAVITY_SWITCH"
  editor-image: 274
  simple-image: 274
  game-image: 274
  props: '((P_PUSH_SOUND . GD_S_SWITCH_GRAVITY))
))
(register-entity (edef:parse-new
  index: etype:O_PNEUMATIC_HAMMER
  name: "Pneumatic hammer"
  bdcff-name: "PNEUMATIC_HAMMER"
  editor-image: 62
  simple-image: 62
  game-image: 62
  props: '((P_PUSH_SOUND . GD_S_PNEUMATIC_COLLECT))
))
(register-entity (edef:parse-new
  index: etype:O_TELEPORTER
  name: "Teleporter"
  bdcff-name: "TELEPORTER"
  editor-image: 61
  simple-image: 61
  game-image: 61
))
(register-entity (edef:parse-new
  index: etype:O_SKELETON
  name: "Skeleton"
  bdcff-name: "SKELETON"
  editor-image: 273
  simple-image: 273
  game-image: 273
))
(register-entity (edef:parse-new
  index: etype:O_WATER
  name: "Water"
  bdcff-name: "WATER"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_1
  name: "Water (1)"
  bdcff-name: "WATER1"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_2
  name: "Water (2)"
  bdcff-name: "WATER2"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_3
  name: "Water (3)"
  bdcff-name: "WATER3"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_4
  name: "Water (4)"
  bdcff-name: "WATER4"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_5
  name: "Water (5)"
  bdcff-name: "WATER5"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_6
  name: "Water (6)"
  bdcff-name: "WATER6"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_7
  name: "Water (7)"
  bdcff-name: "WATER7"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_8
  name: "Water (8)"
  bdcff-name: "WATER8"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_9
  name: "Water (9)"
  bdcff-name: "WATER9"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_10
  name: "Water (10)"
  bdcff-name: "WATER10"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_11
  name: "Water (11)"
  bdcff-name: "WATER11"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_12
  name: "Water (12)"
  bdcff-name: "WATER12"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_13
  name: "Water (13)"
  bdcff-name: "WATER13"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_14
  name: "Water (14)"
  bdcff-name: "WATER14"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_15
  name: "Water (15)"
  bdcff-name: "WATER15"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_WATER_16
  name: "Water (16)"
  bdcff-name: "WATER16"
  editor-image: 96
  simple-image: (- 96)
  game-image: (- 96)
))
(register-entity (edef:parse-new
  index: etype:O_COW_1
  name: "Cow (left)"
  bdcff-name: "COWl"
  editor-image: eximg:cow_1
  simple-image: (- 88)
  game-image: (- 88)
  props: 'P_CCW
))
(register-entity (edef:parse-new
  index: etype:O_COW_2
  name: "Cow (up)"
  bdcff-name: "COWu"
  editor-image: eximg:cow_2
  simple-image: (- 88)
  game-image: (- 88)
  props: 'P_CCW
))
(register-entity (edef:parse-new
  index: etype:O_COW_3
  name: "Cow (right)"
  bdcff-name: "COWr"
  editor-image: eximg:cow_3
  simple-image: (- 88)
  game-image: (- 88)
  props: 'P_CCW
))
(register-entity (edef:parse-new
  index: etype:O_COW_4
  name: "Cow (down)"
  bdcff-name: "COWd"
  editor-image: eximg:cow_4
  simple-image: (- 88)
  game-image: (- 88)
  props: 'P_CCW
))
(register-entity (edef:parse-new
  index: etype:O_COW_ENCLOSED_1
  name: "Cow (enclosed, 1)"
  bdcff-name: "COW_ENCLOSED1"
  editor-image: eximg:cow_enclosed
  simple-image: (- 88)
  game-image: (- 88)
))
(register-entity (edef:parse-new
  index: etype:O_COW_ENCLOSED_2
  name: "Cow (enclosed, 2)"
  bdcff-name: "COW_ENCLOSED2"
  editor-image: eximg:cow_enclosed
  simple-image: (- 88)
  game-image: (- 88)
))
(register-entity (edef:parse-new
  index: etype:O_COW_ENCLOSED_3
  name: "Cow (enclosed, 3)"
  bdcff-name: "COW_ENCLOSED3"
  editor-image: eximg:cow_enclosed
  simple-image: (- 88)
  game-image: (- 88)
))
(register-entity (edef:parse-new
  index: etype:O_COW_ENCLOSED_4
  name: "Cow (enclosed, 4)"
  bdcff-name: "COW_ENCLOSED4"
  editor-image: eximg:cow_enclosed
  simple-image: (- 88)
  game-image: (- 88)
))
(register-entity (edef:parse-new
  index: etype:O_COW_ENCLOSED_5
  name: "Cow (enclosed, 5)"
  bdcff-name: "COW_ENCLOSED5"
  editor-image: eximg:cow_enclosed
  simple-image: (- 88)
  game-image: (- 88)
))
(register-entity (edef:parse-new
  index: etype:O_COW_ENCLOSED_6
  name: "Cow (enclosed, 6)"
  bdcff-name: "COW_ENCLOSED6"
  editor-image: eximg:cow_enclosed
  simple-image: (- 88)
  game-image: (- 88)
))
(register-entity (edef:parse-new
  index: etype:O_COW_ENCLOSED_7
  name: "Cow (enclosed, 7)"
  bdcff-name: "COW_ENCLOSED7"
  editor-image: eximg:cow_enclosed
  simple-image: (- 88)
  game-image: (- 88)
))
(register-entity (edef:parse-new
  index: etype:O_WALLED_DIAMOND
  name: "Walled diamond"
  bdcff-name: "WALLED_DIAMOND"
  editor-image: eximg:walled_diamond
  simple-image: eximg:walled_diamond
  game-image: 5
  props: `(P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_DIAMOND))
))
(register-entity (edef:parse-new
  index: etype:O_WALLED_KEY_1
  name: "Walled key 1"
  bdcff-name: "WALLED_KEY1"
  editor-image: eximg:walled_key_1
  simple-image: eximg:walled_key_1
  game-image: 5
  props: `(P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_KEY_1))
))
(register-entity (edef:parse-new
  index: etype:O_WALLED_KEY_2
  name: "Walled key 2"
  bdcff-name: "WALLED_KEY2"
  editor-image: eximg:walled_key_2
  simple-image: eximg:walled_key_2
  game-image: 5
  props: `(P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_KEY_2))
))
(register-entity (edef:parse-new
  index: etype:O_WALLED_KEY_3
  name: "Walled key 3"
  bdcff-name: "WALLED_KEY3"
  editor-image: eximg:walled_key_3
  simple-image: eximg:walled_key_3
  game-image: 5
  props: `(P_CAN_BE_HAMMERED (P_HAMMERED_TO . ,etype:O_KEY_3))
))
(register-entity (edef:parse-new
  index: etype:O_AMOEBA
  name: "Amoeba"
  bdcff-name: "AMOEBA"
  bdcff-char: #\a
  editor-image: 192
  simple-image: (- 192)
  game-image: (- 192)
  props: 'P_BLOWS_UP_FLIES
))
(register-entity (edef:parse-new
  index: etype:O_AMOEBA_2
  name: "Amoeba 2"
  bdcff-name: "AMOEBA2"
  editor-image: 296
  simple-image: (- 296)
  game-image: (- 296)
  props: '(P_BLOWS_UP_FLIES P_VISUAL_EFFECT)
))
(register-entity (edef:parse-new
  index: etype:O_REPLICATOR
  name: "Replicator"
  bdcff-name: "REPLICATOR"
  editor-image: 304
  simple-image: (- 304)
  game-image: (- 304)
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_CONVEYOR_LEFT
  name: "Conveyor belt (left)"
  bdcff-name: "CONVEYORLEFT"
  editor-image: eximg:conveyor_left
  simple-image: (- 328)
  game-image: (- 328)
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_CONVEYOR_RIGHT
  name: "Conveyor belt (right)"
  bdcff-name: "CONVEYORRIGHT"
  editor-image: eximg:conveyor_right
  simple-image: (- 320)
  game-image: (- 320)
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_LAVA
  name: "Lava"
  bdcff-name: "LAVA"
  editor-image: 312
  simple-image: (- 312)
  game-image: (- 312)
  props: '(P_NON_EXPLODABLE (P_SOUND . GD_S_LAVA))
))
(register-entity (edef:parse-new
  index: etype:O_SWEET
  name: "Sweet"
  bdcff-name: "SWEET"
  editor-image: 8
  simple-image: 8
  game-image: 8
  props: '((P_PUSH_SOUND . GD_S_SWEET_COLLECT))
))
(register-entity (edef:parse-new
  index: etype:O_VOODOO
  name: "Voodoo doll"
  bdcff-name: "DUMMY"
  bdcff-char: #\F
  editor-image: 7
  simple-image: 7
  game-image: 7
  props: '(P_BLOWS_UP_FLIES (P_EXPLOSION_TYPE . VOODOO))
))
(register-entity (edef:parse-new
  index: etype:O_SLIME
  name: "Slime"
  bdcff-name: "SLIME"
  bdcff-char: #\s
  editor-image: 200
  simple-image: (- 200)
  game-image: (- 200)
  props: '((P_SOUND . GD_S_SLIME))
))
(register-entity (edef:parse-new
  index: etype:O_BLADDER
  name: "Bladder"
  bdcff-name: "BLADDER"
  editor-image: 176
  simple-image: (- 176)
  game-image: (- 176)
  props: '((P_SOUND . GD_S_BLADDER_MOVE))
))
(register-entity (edef:parse-new
  index: etype:O_BLADDER_1
  name: "Bladder (1)"
  bdcff-name: "BLADDERd1"
  editor-image: 176
  simple-image: (- 176)
  game-image: (- 176)
))
(register-entity (edef:parse-new
  index: etype:O_BLADDER_2
  name: "Bladder (2)"
  bdcff-name: "BLADDERd2"
  editor-image: 176
  simple-image: (- 176)
  game-image: (- 176)
))
(register-entity (edef:parse-new
  index: etype:O_BLADDER_3
  name: "Bladder (3)"
  bdcff-name: "BLADDERd3"
  editor-image: 176
  simple-image: (- 176)
  game-image: (- 176)
))
(register-entity (edef:parse-new
  index: etype:O_BLADDER_4
  name: "Bladder (4)"
  bdcff-name: "BLADDERd4"
  editor-image: 176
  simple-image: (- 176)
  game-image: (- 176)
))
(register-entity (edef:parse-new
  index: etype:O_BLADDER_5
  name: "Bladder (5)"
  bdcff-name: "BLADDERd5"
  editor-image: 176
  simple-image: (- 176)
  game-image: (- 176)
))
(register-entity (edef:parse-new
  index: etype:O_BLADDER_6
  name: "Bladder (6)"
  bdcff-name: "BLADDERd6"
  editor-image: 176
  simple-image: (- 176)
  game-image: (- 176)
))
(register-entity (edef:parse-new
  index: etype:O_BLADDER_7
  name: "Bladder (7)"
  bdcff-name: "BLADDERd7"
  editor-image: 176
  simple-image: (- 176)
  game-image: (- 176)
))
(register-entity (edef:parse-new
  index: etype:O_BLADDER_8
  name: "Bladder (8)"
  bdcff-name: "BLADDERd8"
  editor-image: 176
  simple-image: (- 176)
  game-image: (- 176)
  props: '((P_ALT_NAME . "BLADDERd9")) ; compatibility with old bd-faq (pre disassembly of bladder)
))
(register-entity (edef:parse-new
  index: etype:O_WAITING_STONE
  name: "Waiting stone"
  bdcff-name: "WAITINGBOULDER"
  editor-image: eximg:waiting_stone
  simple-image: eximg:waiting_stone
  game-image: 1
  props: '(P_SLOPED
           (P_PUSH_SOUND . GD_S_STONE)
           (P_FALL_SOUND . GD_S_STONE))
))
(register-entity (edef:parse-new
  index: etype:O_CHASING_STONE
  name: "Chasing stone"
  bdcff-name: "CHASINGBOULDER"
  editor-image: 17
  simple-image: 17
  game-image: 17
  props: '(P_SLOPED
           (P_PUSH_SOUND . GD_S_STONE)
           (P_FALL_SOUND . GD_S_STONE))
))
(register-entity (edef:parse-new
  index: etype:O_GHOST
  name: "Ghost"
  bdcff-name: "GHOST"
  bdcff-char: #\g
  editor-image: 160
  simple-image: (- 160)
  game-image: (- 160)
  props: '((P_EXPLOSION_TYPE . GHOST))
))
(register-entity (edef:parse-new
  index: etype:O_FIREFLY_1
  name: "Guard, left"
  bdcff-name: "FIREFLYl"
  bdcff-char: #\Q
  editor-image: eximg:guard_1
  simple-image: (- 136)
  game-image: (- 136)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . firefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_FIREFLY_2
  name: "Guard, up"
  bdcff-name: "FIREFLYu"
  bdcff-char: #\o
  editor-image: eximg:guard_2
  simple-image: (- 136)
  game-image: (- 136)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . firefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_FIREFLY_3
  name: "Guard, right"
  bdcff-name: "FIREFLYr"
  bdcff-char: #\O
  editor-image: eximg:guard_3
  simple-image: (- 136)
  game-image: (- 136)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . firefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_FIREFLY_4
  name: "Guard, down"
  bdcff-name: "FIREFLYd"
  bdcff-char: #\q
  editor-image: eximg:guard_4
  simple-image: (- 136)
  game-image: (- 136)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . firefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_ALT_FIREFLY_1
  name: "Alternative guard, left"
  bdcff-name: "A_FIREFLYl"
  editor-image: eximg:alt_guard_1
  simple-image: (- 104)
  game-image: (- 104)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . alt-firefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_ALT_FIREFLY_2
  name: "Alternative guard, up"
  bdcff-name: "A_FIREFLYu"
  editor-image: eximg:alt_guard_2
  simple-image: (- 104)
  game-image: (- 104)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . alt-firefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_ALT_FIREFLY_3
  name: "Alternative guard, right"
  bdcff-name: "A_FIREFLYr"
  editor-image: eximg:alt_guard_3
  simple-image: (- 104)
  game-image: (- 104)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . alt-firefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_ALT_FIREFLY_4
  name: "Alternative guard, down"
  bdcff-name: "A_FIREFLYd"
  editor-image: eximg:alt_guard_4
  simple-image: (- 104)
  game-image: (- 104)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . alt-firefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_BUTTER_1
  name: "Butterfly, left"
  bdcff-name: "BUTTERFLYl"
  bdcff-char: #\C
  editor-image: eximg:butter_1
  simple-image: (- 144)
  game-image: (- 144)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . butterfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_BUTTER_2
  name: "Butterfly, up"
  bdcff-name: "BUTTERFLYu"
  bdcff-char: #\b
  editor-image: eximg:butter_2
  simple-image: (- 144)
  game-image: (- 144)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . butterfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_BUTTER_3
  name: "Butterfly, right"
  bdcff-name: "BUTTERFLYr"
  bdcff-char: #\B
  editor-image: eximg:butter_3
  simple-image: (- 144)
  game-image: (- 144)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . butterfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_BUTTER_4
  name: "Butterfly, down"
  bdcff-name: "BUTTERFLYd"
  bdcff-char: #\c
  editor-image: eximg:butter_4
  simple-image: (- 144)
  game-image: (- 144)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . butterfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_ALT_BUTTER_1
  name: "Alternative butterfly, left"
  bdcff-name: "A_BUTTERFLYl"
  editor-image: eximg:alt_butter_1
  simple-image: (- 112)
  game-image: (- 112)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . alt-butterfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_ALT_BUTTER_2
  name: "Alternative butterfly, up"
  bdcff-name: "A_BUTTERFLYu"
  editor-image: eximg:alt_butter_2
  simple-image: (- 112)
  game-image: (- 112)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . alt-butterfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_ALT_BUTTER_3
  name: "Alternative butterfly, right"
  bdcff-name: "A_BUTTERFLYr"
  editor-image: eximg:alt_butter_3
  simple-image: (- 112)
  game-image: (- 112)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . alt-butterfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_ALT_BUTTER_4
  name: "Alternative butterfly, down"
  bdcff-name: "A_BUTTERFLYd"
  editor-image: eximg:alt_butter_4
  simple-image: (- 112)
  game-image: (- 112)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . alt-butterfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_STONEFLY_1
  name: "Stonefly, left"
  bdcff-name: "STONEFLYl"
  editor-image: eximg:stonefly_1
  simple-image: (- 152)
  game-image: (- 152)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . stonefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_STONEFLY_2
  name: "Stonefly, up"
  bdcff-name: "STONEFLYu"
  editor-image: eximg:stonefly_2
  simple-image: (- 152)
  game-image: (- 152)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . stonefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_STONEFLY_3
  name: "Stonefly, right"
  bdcff-name: "STONEFLYr"
  editor-image: eximg:stonefly_3
  simple-image: (- 152)
  game-image: (- 152)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . stonefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_STONEFLY_4
  name: "Stonefly, down"
  bdcff-name: "STONEFLYd"
  editor-image: eximg:stonefly_4
  simple-image: (- 152)
  game-image: (- 152)
  props: '(P_EXPLODES_BY_HIT (P_EXPLOSION_OPTION . stonefly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_BITER_1
  name: "Biter, up"
  bdcff-name: "BITERu"
  editor-image: eximg:biter_1
  simple-image: (- 168)
  game-image: (- 168)
  props: '((P_SOUND . GD_S_BITER_EAT))
))
(register-entity (edef:parse-new
  index: etype:O_BITER_2
  name: "Biter, right"
  bdcff-name: "BITERr"
  editor-image: eximg:biter_2
  simple-image: (- 168)
  game-image: (- 168)
  props: '((P_SOUND . GD_S_BITER_EAT))
))
(register-entity (edef:parse-new
  index: etype:O_BITER_3
  name: "Biter, down"
  bdcff-name: "BITERd"
  editor-image: eximg:biter_3
  simple-image: (- 168)
  game-image: (- 168)
  props: '((P_SOUND . GD_S_BITER_EAT))
))
(register-entity (edef:parse-new
  index: etype:O_BITER_4
  name: "Biter, left"
  bdcff-name: "BITERl"
  editor-image: eximg:biter_4
  simple-image: (- 168)
  game-image: (- 168)
  props: '((P_SOUND . GD_S_BITER_EAT))
))
(register-entity (edef:parse-new
  index: etype:O_DRAGONFLY_1
  name: "Dragonfly, left"
  bdcff-name: "DRAGONFLYl"
  editor-image: eximg:dragonfly_1
  simple-image: (- 336)
  game-image: (- 336)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . dragonfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_DRAGONFLY_2
  name: "Dragonfly, up"
  bdcff-name: "DRAGONFLYu"
  editor-image: eximg:dragonfly_2
  simple-image: (- 336)
  game-image: (- 336)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . dragonfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_DRAGONFLY_3
  name: "Dragonfly, right"
  bdcff-name: "DRAGONFLYr"
  editor-image: eximg:dragonfly_3
  simple-image: (- 336)
  game-image: (- 336)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . dragonfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_DRAGONFLY_4
  name: "Dragonfly, down"
  bdcff-name: "DRAGONFLYd"
  editor-image: eximg:dragonfly_4
  simple-image: (- 336)
  game-image: (- 336)
  props: '(P_EXPLODES_BY_HIT P_CCW (P_EXPLOSION_OPTION . dragonfly-explode-to))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_PL_1
  name: "Player birth (1)"
  bdcff-name: "GUYBIRTH1"
  editor-image: 32
  simple-image: 32
  game-image: 32
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_PRE_PL_2
  name: "Player birth (2)"
  bdcff-name: "GUYBIRTH2"
  editor-image: 33
  simple-image: 33
  game-image: 33
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_PRE_PL_3
  name: "Player birth (3)"
  bdcff-name: "GUYBIRTH3"
  editor-image: 34
  simple-image: 34
  game-image: 34
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_PLAYER
  name: "Player"
  bdcff-name: "GUY"
  editor-image: eximg:player
  simple-image: eximg:player
  game-image: 35
  props: '(P_BLOWS_UP_FLIES P_EXPLODES_BY_HIT P_PLAYER)
))
(register-entity (edef:parse-new
  index: etype:O_PLAYER_BOMB
  name: "Player with bomb"
  bdcff-name: "GUYBOMB"
  editor-image: 42
  simple-image: 42
  game-image: 42
  props: '(P_BLOWS_UP_FLIES P_EXPLODES_BY_HIT P_PLAYER)
))
(register-entity (edef:parse-new
  index: etype:O_PLAYER_GLUED
  name: "Glued player"
  bdcff-name: "GUYGLUED"
  editor-image: eximg:player_glued
  simple-image: eximg:player_glued
  game-image: 35
  props: '(P_BLOWS_UP_FLIES P_EXPLODES_BY_HIT)
))
(register-entity (edef:parse-new
  index: etype:O_PLAYER_STIRRING
  name: "Player stirring"
  bdcff-name: "GUYSTIRRING"
  editor-image: 256
  simple-image: (- 256)
  game-image: (- 256)
  props: '(P_BLOWS_UP_FLIES P_EXPLODES_BY_HIT P_PLAYER)
))
;;
(register-entity (edef:parse-new
  index: etype:O_BOMB
  name: "Bomb"
  bdcff-name: "BOMB"
  editor-image: 48
  simple-image: 48
  game-image: 48
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_TICK_1
  name: "Ticking bomb (1)"
  bdcff-name: "IGNITEDBOMB1"
  editor-image: 49
  simple-image: 49
  game-image: 49
  props: 'P_EXPLOSION_FIRST_STAGE
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_TICK_2
  name: "Ticking bomb (2)"
  bdcff-name: "IGNITEDBOMB2"
  editor-image: 50
  simple-image: 50
  game-image: 50
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_TICK_3
  name: "Ticking bomb (3)"
  bdcff-name: "IGNITEDBOMB3"
  editor-image: 51
  simple-image: 51
  game-image: 51
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_TICK_4
  name: "Ticking bomb (4)"
  bdcff-name: "IGNITEDBOMB4"
  editor-image: 52
  simple-image: 52
  game-image: 52
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_TICK_5
  name: "Ticking bomb (5)"
  bdcff-name: "IGNITEDBOMB5"
  editor-image: 53
  simple-image: 53
  game-image: 53
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_TICK_6
  name: "Ticking bomb (6)"
  bdcff-name: "IGNITEDBOMB6"
  editor-image: 54
  simple-image: 54
  game-image: 54
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_TICK_7
  name: "Ticking bomb (7)"
  bdcff-name: "IGNITEDBOMB7"
  editor-image: 55
  simple-image: 55
  game-image: 55
))
;;
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8
  name: "Bomb (k8)"
  editor-image: 48
  simple-image: 48
  game-image: 48
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8_TICK_1
  name: "Ticking bomb (k8; 1)"
  editor-image: 49
  simple-image: 49
  game-image: 49
  props: 'P_EXPLOSION_FIRST_STAGE
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8_TICK_2
  name: "Ticking bomb (k8; 2)"
  editor-image: 50
  simple-image: 50
  game-image: 50
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8_TICK_3
  name: "Ticking bomb (k8; 3)"
  editor-image: 51
  simple-image: 51
  game-image: 51
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8_TICK_4
  name: "Ticking bomb (k8; 4)"
  editor-image: 52
  simple-image: 52
  game-image: 52
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8_TICK_5
  name: "Ticking bomb (k8; 5)"
  editor-image: 53
  simple-image: 53
  game-image: 53
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8_TICK_6
  name: "Ticking bomb (k8; 6)"
  editor-image: 54
  simple-image: 54
  game-image: 54
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8_TICK_7
  name: "Ticking bomb (k8; 7)"
  editor-image: 55
  simple-image: 55
  game-image: 55
))
;;
(register-entity (edef:parse-new
  index: etype:O_NITRO_PACK
  name: "Nitro pack"
  bdcff-name: "NITRO"
  editor-image: 288
  simple-image: 288
  game-image: 288
  props: '(P_SLOPED P_EXPLODES_BY_HIT P_MOVED_BY_CONVEYOR_TOP
           (P_PUSH_SOUND . GD_S_NITRO)
           (P_FALL_SOUND . GD_S_NITRO))
))
(register-entity (edef:parse-new
  index: etype:O_NITRO_PACK_F
  name: "Nitro pack, falling"
  bdcff-name: "NITROf"
  editor-image: eximg:nitro_pack_f
  simple-image: eximg:nitro_pack_f
  game-image: 288
  props: '(P_EXPLODES_BY_HIT
           (P_PUSH_SOUND . GD_S_NITRO)
           (P_FALL_SOUND . GD_S_NITRO))
))
(register-entity (edef:parse-new
  index: etype:O_NITRO_PACK_EXPLODE
  name: "Nitro pack, triggered"
  bdcff-name: "NITROtriggered"
  editor-image: eximg:nitro_explode
  simple-image: eximg:nitro_explode
  game-image: 288
  props: 'P_EXPLODES_BY_HIT
))
(register-entity (edef:parse-new
  index: etype:O_PRE_CLOCK_1
  name: "Clock birth (1)"
  bdcff-name: "CLOCKBIRTH1"
  editor-image: 28
  simple-image: 28
  game-image: 28
  props: '(P_EXPLOSION_FIRST_STAGE
           (P_SOUND . GD_S_BLADDER_SPENDER)
           (P_SCANNED_NAME . "CLOCKBIRTH0"))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_CLOCK_2
  name: "Clock birth (2)"
  bdcff-name: "CLOCKBIRTH2"
  editor-image: 29
  simple-image: 29
  game-image: 29
))
(register-entity (edef:parse-new
  index: etype:O_PRE_CLOCK_3
  name: "Clock birth (3)"
  bdcff-name: "CLOCKBIRTH3"
  editor-image: 30
  simple-image: 30
  game-image: 30
))
(register-entity (edef:parse-new
  index: etype:O_PRE_CLOCK_4
  name: "Clock birth (4)"
  bdcff-name: "CLOCKBIRTH4"
  editor-image: 31
  simple-image: 31
  game-image: 31
  props: `((P_EXPLOSION_NEXT . ,etype:O_CLOCK))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_DIA_1
  name: "Diamond birth (1)"
  bdcff-name: "DIAMONDBIRTH1"
  editor-image: 56
  simple-image: 56
  game-image: 56
  props: '(P_EXPLOSION_FIRST_STAGE
           (P_SCANNED_NAME . "DIAMONDBIRTH0")
           (P_ALT_NAME . "EXPLOSION1D"))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_DIA_2
  name: "Diamond birth (2)"
  bdcff-name: "DIAMONDBIRTH2"
  editor-image: 57
  simple-image: 57
  game-image: 57
  props: '((P_ALT_NAME . "EXPLOSION2D"))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_DIA_3
  name: "Diamond birth (3)"
  bdcff-name: "DIAMONDBIRTH3"
  editor-image: 58
  simple-image: 58
  game-image: 58
  props: '((P_ALT_NAME . "EXPLOSION3D"))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_DIA_4
  name: "Diamond birth (4)"
  bdcff-name: "DIAMONDBIRTH4"
  editor-image: 59
  simple-image: 59
  game-image: 59
  props: '((P_ALT_NAME . "EXPLOSION4D"))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_DIA_5
  name: "Diamond birth (5)"
  bdcff-name: "DIAMONDBIRTH5"
  editor-image: 60
  simple-image: 60
  game-image: 60
  props: `((P_EXPLOSION_NEXT_OPTION . diamond-birth-effect))
))
(register-entity (edef:parse-new
  index: etype:O_EXPLODE_1
  name: "Explosion (1)"
  bdcff-name: "EXPLOSION1"
  editor-image: 43
  simple-image: 43
  game-image: 43
  props: '(P_EXPLOSION_FIRST_STAGE
           (P_SCANNED_NAME . "EXPLOSION0")
           (P_ALT_NAME . "EXPLOSION1S"))
))
(register-entity (edef:parse-new
  index: etype:O_EXPLODE_2
  name: "Explosion (2)"
  bdcff-name: "EXPLOSION2"
  editor-image: 44
  simple-image: 44
  game-image: 44
  props: '((P_ALT_NAME . "EXPLOSION2S"))
))
(register-entity (edef:parse-new
  index: etype:O_EXPLODE_3
  name: "Explosion (3)"
  bdcff-name: "EXPLOSION3"
  editor-image: 45
  simple-image: 45
  game-image: 45
  props: '((P_ALT_NAME . "EXPLOSION3S")
           (P_EXPLOSION_NEXT_OPTION . explosion-3-effect))
))
(register-entity (edef:parse-new
  index: etype:O_EXPLODE_4
  name: "Explosion (4)"
  bdcff-name: "EXPLOSION4"
  editor-image: 46
  simple-image: 46
  game-image: 46
  props: '((P_ALT_NAME . "EXPLOSION4S"))
))
(register-entity (edef:parse-new
  index: etype:O_EXPLODE_5
  name: "Explosion (5)"
  bdcff-name: "EXPLOSION5"
  editor-image: 47
  simple-image: 47
  game-image: 47
  props: '((P_EXPLOSION_NEXT_OPTION . explosion-effect)
           (P_ALT_NAME . "EXPLOSION5S"))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_STONE_1
  name: "Stone birth (1)"
  bdcff-name: "BOULDERBIRTH1"
  editor-image: 36
  simple-image: 36
  game-image: 36
  props: '(P_EXPLOSION_FIRST_STAGE (P_SCANNED_NAME . "BOULDERBIRTH0"))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_STONE_2
  name: "Stone birth (2)"
  bdcff-name: "BOULDERBIRTH2"
  editor-image: 37
  simple-image: 37
  game-image: 37
))
(register-entity (edef:parse-new
  index: etype:O_PRE_STONE_3
  name: "Stone birth (3)"
  bdcff-name: "BOULDERBIRTH3"
  editor-image: 38
  simple-image: 38
  game-image: 38
))
(register-entity (edef:parse-new
  index: etype:O_PRE_STONE_4
  name: "Stone birth (4)"
  bdcff-name: "BOULDERBIRTH4"
  editor-image: 39
  simple-image: 39
  game-image: 39
  props: `((P_EXPLOSION_NEXT . ,etype:O_STONE))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_STEEL_1
  name: "Steel birth (1)"
  bdcff-name: "STEELWALLBIRTH1"
  editor-image: 24
  simple-image: 24
  game-image: 24
  props: '(P_EXPLOSION_FIRST_STAGE (P_SCANNED_NAME . "STEELWALLBIRTH0"))
))
(register-entity (edef:parse-new
  index: etype:O_PRE_STEEL_2
  name: "Steel birth (2)"
  bdcff-name: "STEELWALLBIRTH2"
  editor-image: 25
  simple-image: 25
  game-image: 25
))
(register-entity (edef:parse-new
  index: etype:O_PRE_STEEL_3
  name: "Steel birth (3)"
  bdcff-name: "STEELWALLBIRTH3"
  editor-image: 26
  simple-image: 26
  game-image: 26
))
(register-entity (edef:parse-new
  index: etype:O_PRE_STEEL_4
  name: "Steel birth (4)"
  bdcff-name: "STEELWALLBIRTH4"
  editor-image: 27
  simple-image: 27
  game-image: 27
  props: `((P_EXPLOSION_NEXT . ,etype:O_STEEL))
))
(register-entity (edef:parse-new
  index: etype:O_GHOST_EXPL_1
  name: "Ghost explosion (1)"
  bdcff-name: "GHOSTEXPLOSION1"
  editor-image: 80
  simple-image: 80
  game-image: 80
  props: '(P_EXPLOSION_FIRST_STAGE (P_SCANNED_NAME . "GHOSTEXPLOSION0"))
))
(register-entity (edef:parse-new
  index: etype:O_GHOST_EXPL_2
  name: "Ghost explosion (2)"
  bdcff-name: "GHOSTEXPLOSION2"
  editor-image: 81
  simple-image: 81
  game-image: 81
))
(register-entity (edef:parse-new
  index: etype:O_GHOST_EXPL_3
  name: "Ghost explosion (3)"
  bdcff-name: "GHOSTEXPLOSION3"
  editor-image: 82
  simple-image: 82
  game-image: 82
))
(register-entity (edef:parse-new
  index: etype:O_GHOST_EXPL_4
  name: "Ghost explosion (4)"
  bdcff-name: "GHOSTEXPLOSION4"
  editor-image: 83
  simple-image: 83
  game-image: 83
))
;;
(register-entity (edef:parse-new
  index: etype:O_BOMB_EXPL_1
  name: "Bomb explosion (1)"
  bdcff-name: "BOMBEXPLOSION1"
  editor-image: 84
  simple-image: 84
  game-image: 84
  props: '(P_EXPLOSION_FIRST_STAGE (P_SCANNED_NAME . "BOMBEXPLOSION0"))
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_EXPL_2
  name: "Bomb explosion (2)"
  bdcff-name: "BOMBEXPLOSION2"
  editor-image: 85
  simple-image: 85
  game-image: 85
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_EXPL_3
  name: "Bomb explosion (3)"
  bdcff-name: "BOMBEXPLOSION3"
  editor-image: 86
  simple-image: 86
  game-image: 86
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_EXPL_4
  name: "Bomb explosion (4)"
  bdcff-name: "BOMBEXPLOSION4"
  editor-image: 87
  simple-image: 87
  game-image: 87
  props: `((P_EXPLOSION_NEXT_OPTION . bomb-explosion-effect))
))
;;
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8_EXPL_1
  name: "Bomb explosion (k8; 1)"
  editor-image: 84
  simple-image: 84
  game-image: 84
  props: 'P_EXPLOSION_FIRST_STAGE
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8_EXPL_2
  name: "Bomb explosion (k8; 2)"
  editor-image: 85
  simple-image: 85
  game-image: 85
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8_EXPL_3
  name: "Bomb explosion (k8; 3)"
  editor-image: 86
  simple-image: 86
  game-image: 86
))
(register-entity (edef:parse-new
  index: etype:O_BOMB_K8_EXPL_4
  name: "Bomb explosion (k8; 4)"
  editor-image: 87
  simple-image: 87
  game-image: 87
  props: `((P_EXPLOSION_NEXT . ,etype:O_SPACE))
))
;;
(register-entity (edef:parse-new
  index: etype:O_NITRO_EXPL_1
  name: "Nitro pack explosion (1)"
  bdcff-name: "NITROEXPLOSION1"
  editor-image: 44
  simple-image: 44
  game-image: 44
  props: '(P_EXPLOSION_FIRST_STAGE (P_SCANNED_NAME . "NITROEXPLOSION0"))
))
(register-entity (edef:parse-new
  index: etype:O_NITRO_EXPL_2
  name: "Nitro pack explosion (2)"
  bdcff-name: "NITROEXPLOSION2"
  editor-image: 45
  simple-image: 45
  game-image: 45
))
(register-entity (edef:parse-new
  index: etype:O_NITRO_EXPL_3
  name: "Nitro pack explosion (3)"
  bdcff-name: "NITROEXPLOSION3"
  editor-image: 46
  simple-image: 46
  game-image: 46
))
(register-entity (edef:parse-new
  index: etype:O_NITRO_EXPL_4
  name: "Nitro pack explosion (4)"
  bdcff-name: "NITROEXPLOSION4"
  editor-image: 47
  simple-image: 47
  game-image: 47
  props: `((P_EXPLOSION_NEXT_OPTION . nitro-explosion-effect))
))
(register-entity (edef:parse-new
  index: etype:O_AMOEBA_2_EXPL_1
  name: "Amoeba 2 explosion (1)"
  bdcff-name: "AMOEBA2EXPLOSION1"
  editor-image: 292
  simple-image: 292
  game-image: 292
  props: '(P_EXPLOSION_FIRST_STAGE (P_SCANNED_NAME . "AMOEBA2EXPLOSION0"))
))
(register-entity (edef:parse-new
  index: etype:O_AMOEBA_2_EXPL_2
  name: "Amoeba 2 explosion (2)"
  bdcff-name: "AMOEBA2EXPLOSION2"
  editor-image: 293
  simple-image: 293
  game-image: 293
))
(register-entity (edef:parse-new
  index: etype:O_AMOEBA_2_EXPL_3
  name: "Amoeba 2 explosion (3)"
  bdcff-name: "AMOEBA2EXPLOSION3"
  editor-image: 294
  simple-image: 294
  game-image: 294
))
(register-entity (edef:parse-new
  index: etype:O_AMOEBA_2_EXPL_4
  name: "Amoeba 2 explosion (4)"
  bdcff-name: "AMOEBA2EXPLOSION4"
  editor-image: 295
  simple-image: 295
  game-image: 295
  props: `((P_EXPLOSION_NEXT . ,etype:O_SPACE))
))
(register-entity (edef:parse-new
  index: etype:O_NUT_EXPL_1
  name: "Nut explosion (1)"
  bdcff-name: "NUTEXPLOSION1"
  editor-image: 360
  simple-image: 360
  game-image: 360
  props: '(P_SLOPED P_EXPLOSION_FIRST_STAGE (P_SCANNED_NAME . "NUTEXPLOSION0"))
))
(register-entity (edef:parse-new
  index: etype:O_NUT_EXPL_2
  name: "Nut explosion (2)"
  bdcff-name: "NUTEXPLOSION2"
  editor-image: 361
  simple-image: 361
  game-image: 361
  props: 'P_SLOPED
))
(register-entity (edef:parse-new
  index: etype:O_NUT_EXPL_3
  name: "Nut explosion (3)"
  bdcff-name: "NUTEXPLOSION3"
  editor-image: 362
  simple-image: 362
  game-image: 362
  props: 'P_SLOPED
))
(register-entity (edef:parse-new
  index: etype:O_NUT_EXPL_4
  name: "Nut explosion (4)"
  bdcff-name: "NUTEXPLOSION4"
  editor-image: 363
  simple-image: 363
  game-image: 363
  props: '(P_SLOPED (P_EXPLOSION_NEXT . ,etype:O_DIAMOND))
))

(register-entity (edef:parse-new
  index: etype:O_PLAYER_PNEUMATIC_LEFT
  bdcff-name: "GUYHAMMERl"
  editor-image: 265
  simple-image: 265
  game-image: 265
  props: '(P_BLOWS_UP_FLIES P_EXPLODES_BY_HIT P_PLAYER)
))
(register-entity (edef:parse-new
  index: etype:O_PLAYER_PNEUMATIC_RIGHT
  bdcff-name: "GUYHAMMERr"
  editor-image: 268
  simple-image: 268
  game-image: 268
  props: '(P_BLOWS_UP_FLIES P_EXPLODES_BY_HIT P_PLAYER)
))
(register-entity (edef:parse-new
  index: etype:O_PNEUMATIC_ACTIVE_LEFT
  bdcff-name: "HAMMERACTIVEl"
  editor-image: 264
  simple-image: 264
  game-image: 264
))
(register-entity (edef:parse-new
  index: etype:O_PNEUMATIC_ACTIVE_RIGHT
  bdcff-name: "HAMMERACTIVEr"
  editor-image: 269
  simple-image: 269
  game-image: 269
))
(register-entity (edef:parse-new
  index: etype:O_UNKNOWN
  name: "Unknown element"
  bdcff-name: "UNKNOWN"
  editor-image: eximg:unknown
  simple-image: eximg:unknown
  game-image: 4
  props: 'P_NON_EXPLODABLE
))

(register-entity (edef:parse-new
  index: etype:O_NONE
  name: "No element"
  bdcff-name: "NONE"
  editor-image: 79
  simple-image: 79
  game-image: 79
))
(register-entity (edef:parse-new
  index: etype:O_FAKE_BONUS
  editor-image: 120
  simple-image: (- 120)
  game-image: (- 120)
))
(register-entity (edef:parse-new
  index: etype:O_OUTBOX_CLOSED
  editor-image: 22
  simple-image: 22
  game-image: 22
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_OUTBOX_OPEN
  editor-image: 23
  simple-image: 23
  game-image: 23
  props: 'P_NON_EXPLODABLE
))
(register-entity (edef:parse-new
  index: etype:O_COVERED
  editor-image: 128
  simple-image: (- 128)
  game-image: (- 128)
))

(register-entity (edef:parse-new
  index: etype:O_PLAYER_LEFT
  editor-image: 232
  simple-image: (- 232)
  game-image: (- 232)
  props: '(P_BLOWS_UP_FLIES P_EXPLODES_BY_HIT P_PLAYER)
))
(register-entity (edef:parse-new
  index: etype:O_PLAYER_RIGHT
  editor-image: 240
  simple-image: (- 240)
  game-image: (- 240)
  props: '(P_BLOWS_UP_FLIES P_EXPLODES_BY_HIT P_PLAYER)
))
(register-entity (edef:parse-new
  index: etype:O_PLAYER_TAP
  editor-image: 216
  simple-image: (- 216)
  game-image: (- 216)
  props: '(P_BLOWS_UP_FLIES P_EXPLODES_BY_HIT P_PLAYER)
))
(register-entity (edef:parse-new
  index: etype:O_PLAYER_BLINK
  editor-image: 208
  simple-image: (- 208)
  game-image: (- 208)
  props: '(P_BLOWS_UP_FLIES P_EXPLODES_BY_HIT P_PLAYER)
))
(register-entity (edef:parse-new
  index: etype:O_PLAYER_TAP_BLINK
  editor-image: 224
  simple-image: (- 224)
  game-image: (- 224)
  props: '(P_BLOWS_UP_FLIES P_EXPLODES_BY_HIT P_PLAYER)
))
(register-entity (edef:parse-new
  index: etype:O_CREATURE_SWITCH_ON
  editor-image: 19
  simple-image: 19
  game-image: 19
))
(register-entity (edef:parse-new
  index: etype:O_EXPANDING_WALL_SWITCH_HORIZ
  editor-image: 40
  simple-image: 40
  game-image: 40
))
(register-entity (edef:parse-new
  index: etype:O_EXPANDING_WALL_SWITCH_VERT
  editor-image: 41
  simple-image: 41
  game-image: 41
))
(register-entity (edef:parse-new
  index: etype:O_GRAVITY_SWITCH_ACTIVE
  editor-image: 275
  simple-image: 275
  game-image: 275
))
(register-entity (edef:parse-new
  index: etype:O_REPLICATOR_SWITCH_ON
  editor-image: 290
  simple-image: 290
  game-image: 290
))
(register-entity (edef:parse-new
  index: etype:O_REPLICATOR_SWITCH_OFF
  editor-image: 291
  simple-image: 291
  game-image: 291
))
(register-entity (edef:parse-new
  index: etype:O_CONVEYOR_DIR_NORMAL
  editor-image: 353
  simple-image: 353
  game-image: 353
))
(register-entity (edef:parse-new
  index: etype:O_CONVEYOR_DIR_CHANGED
  editor-image: 354
  simple-image: 354
  game-image: 354
))
(register-entity (edef:parse-new
  index: etype:O_CONVEYOR_SWITCH_OFF
  editor-image: 355
  simple-image: 355
  game-image: 355
))
(register-entity (edef:parse-new
  index: etype:O_CONVEYOR_SWITCH_ON
  editor-image: 356
  simple-image: 356
  game-image: 356
))
(register-entity (edef:parse-new
  index: etype:O_QUESTION_MARK
  editor-image: 70
  simple-image: 70
  game-image: 70
))
(register-entity (edef:parse-new
  index: etype:O_EATABLE
  editor-image: 71
  simple-image: 71
  game-image: 71
  props: 'P_PLAYER_EDIBLE
))
(register-entity (edef:parse-new
  index: etype:O_DOWN_ARROW
  editor-image: 73
  simple-image: 73
  game-image: 73
))
(register-entity (edef:parse-new
  index: etype:O_LEFTRIGHT_ARROW
  editor-image: 74
  simple-image: 74
  game-image: 74
))
(register-entity (edef:parse-new
  index: etype:O_EVERYDIR_ARROW
  editor-image: 75
  simple-image: 75
  game-image: 75
))
(register-entity (edef:parse-new
  index: etype:O_GLUED
  editor-image: 76
  simple-image: 76
  game-image: 76
))
(register-entity (edef:parse-new
  index: etype:O_OUT
  editor-image: 77
  simple-image: 77
  game-image: 77
))
(register-entity (edef:parse-new
  index: etype:O_EXCLAMATION_MARK
  editor-image: 78
  simple-image: 78
  game-image: 78
))


(register-entity (edef:parse-new
  index: etype:O_ROCKET_LAUNCHER
  name: "Rocket launcher (not supported!)"
  bdcff-name: "ROCKET_LAUNCHER"
  editor-image: 1
  simple-image: 1
  game-image: 1
))


(check-entities)
(build-bdcff-entity-map)
(build-bdcff-legend-map)
