@echo off
:: AutoCut Pro Complete Uninstaller
:: Removes ALL components including registry entries

setlocal enabledelayedexpansion

:: Check admin rights with timeout
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo Requesting administrator privileges...
    powershell -command "Start-Process -Verb RunAs -FilePath '%0' -ArgumentList '%*'"
    timeout /t 3
    exit /b
)

:: Configuration
set "SHORTCUT_NAME=AutoCut Pro"
set "STARTMENU_FOLDER=AutoCut Pro"
set "INSTALL_DIR=C:\Program Files\AutoCutPro"
set "APP_DATA_DIR=%LOCALAPPDATA%\AutoCutPro"

echo [UNINSTALL] AutoCut Pro
echo ----------------------------------------

:: 1. Remove Shortcuts (All Users)
echo Removing shortcuts...
:: Current User
set "USER_STARTMENU=%APPDATA%\Microsoft\Windows\Start Menu\Programs\%STARTMENU_FOLDER%"
rmdir /s /q "!USER_STARTMENU!" 2>nul
del "%USERPROFILE%\Desktop\!SHORTCUT_NAME!.lnk" 2>nul

:: All Users (Admin-only)
set "ALL_USERS_STARTMENU=%ProgramData%\Microsoft\Windows\Start Menu\Programs\%STARTMENU_FOLDER%"
rmdir /s /q "!ALL_USERS_STARTMENU!" 2>nul
del "%PUBLIC%\Desktop\!SHORTCUT_NAME!.lnk" 2>nul

:: 2. Uninstall Python Packages
echo Removing Python packages...
python -m pip uninstall auto-editor sv_ttk -y 2>nul

:: 3. Remove Installation Directories
echo Deleting program files...
rmdir /s /q "%INSTALL_DIR%" 2>nul
rmdir /s /q "%APP_DATA_DIR%" 2>nul

:: 4. Clean Registry (Admin-only)
echo Cleaning registry...
reg delete "HKCU\Software\Microsoft\Windows\CurrentVersion\Run" /v "AutoCutPro" /f 2>nul
reg delete "HKLM\Software\Microsoft\Windows\CurrentVersion\Run" /v "AutoCutPro" /f 2>nul
reg delete "HKCR\Applications\auto_editor_gui.py" /f 2>nul

:: 5. Update PATH (System-wide)
echo Updating system PATH...
powershell -command "[Environment]::SetEnvironmentVariable('PATH', [Environment]::GetEnvironmentVariable('PATH', 'Machine').Replace(';%INSTALL_DIR%', ''), 'Machine')"

:: 6. Refresh System
echo Refreshing system...
taskkill /f /im explorer.exe >nul 2>&1
start explorer.exe
timeout /t 2 >nul

echo ----------------------------------------
echo [SUCCESS] Uninstallation complete!
echo All components removed:
echo - Program files
echo - Shortcuts
echo - Python packages
echo - Registry entries
pause