@echo off
:: AutoCut Pro Complete Installer
:: Downloads files from GitHub | Skips existing components

setlocal enabledelayedexpansion

:: Check admin rights
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo Requesting administrator privileges...
    powershell -command "Start-Process -Verb RunAs -FilePath '%0' -ArgumentList '%*'"
    exit /b
)

:: Configuration
set "PRIMARY_DIR=C:\Program Files\AutoCutPro"
set "SECONDARY_DIR=%LOCALAPPDATA%\AutoCutPro"
set "SHORTCUT_NAME=AutoCut Pro"
set "STARTMENU_FOLDER=AutoCut Pro"
set "PY_SCRIPT_URL=https://raw.githubusercontent.com/RSK48/Auto-editor-mint-/main/auto_editor_gui.py"
set "ICON_URL=https://raw.githubusercontent.com/RSK48/Auto-editor-mint-/refs/heads/main/autocut.ico"

:: 1. Python Check (Skip if exists)
where python >nul 2>&1
if %errorLevel% equ 0 (
    echo Python is already installed [Skipping]
) else (
    echo Installing Python 3.13...
    start ms-windows-store://pdp/?ProductId=9NRWMJP3717K
    timeout /t 5
    echo Please complete Python installation if prompted
    timeout /t 5
)

:: 2. Determine Install Directory
if exist "%PRIMARY_DIR%" (
    set "INSTALL_DIR=%PRIMARY_DIR%"
    echo Using existing Program Files installation
) else (
    if exist "%SECONDARY_DIR%" (
        set "INSTALL_DIR=%SECONDARY_DIR%"
        echo Using existing AppData installation
    ) else (
        mkdir "%PRIMARY_DIR%" 2>nul && (
            set "INSTALL_DIR=%PRIMARY_DIR%"
        ) || (
            mkdir "%SECONDARY_DIR%" 2>nul && set "INSTALL_DIR=%SECONDARY_DIR%"
        )
        if not defined INSTALL_DIR (
            echo Error: Failed to create installation directory
            pause
            exit /b 1
        )
    )
)

:: 3. Package Installation (Skip if exists)
echo Checking Python packages...
python -c "import auto_editor, sv_ttk" 2>nul
if %errorLevel% equ 0 (
    echo Required packages already installed [Skipping]
) else (
    echo Ensuring pip is available...
    python -m ensurepip --default-pip
    echo Upgrading pip...
    python.exe -m pip install --upgrade pip
    
    echo Installing auto-editor and sv_ttk...
    python -m pip install auto-editor sv_ttk --user
)

:: 4. Download Main Script
echo Downloading auto_editor_gui.py...
powershell -command "Invoke-WebRequest -Uri '%PY_SCRIPT_URL%' -OutFile '%INSTALL_DIR%\auto_editor_gui.py'"
if not exist "%INSTALL_DIR%\auto_editor_gui.py" (
    echo Error: Failed to download auto_editor_gui.py
    echo URL: %PY_SCRIPT_URL%
    pause
    exit /b 1
)

:: 5. Download Icon (Critical - will fail if missing)
echo Downloading icon file...
powershell -command "Invoke-WebRequest -Uri '%ICON_URL%' -OutFile '%INSTALL_DIR%\autocut.ico'"
if not exist "%INSTALL_DIR%\autocut.ico" (
    echo Error: Failed to download required icon file
    echo URL: %ICON_URL%
    pause
    exit /b 1
)

:: 6. Create/Update Shortcuts (with icon refresh)
echo Configuring shortcuts...
set "STARTMENU_PATH=%APPDATA%\Microsoft\Windows\Start Menu\Programs\%STARTMENU_FOLDER%"
mkdir "%STARTMENU_PATH%" 2>nul

powershell -command "$s=(New-Object -COM WScript.Shell).CreateShortcut('%STARTMENU_PATH%\%SHORTCUT_NAME%.lnk'); $s.TargetPath='python'; $s.Arguments='\"%INSTALL_DIR%\auto_editor_gui.py\"'; $s.WorkingDirectory='%INSTALL_DIR%'; $s.IconLocation='%INSTALL_DIR%\autocut.ico'; $s.Description='AutoCut Pro Video Editor'; $s.Save()"

powershell -command "$s=(New-Object -COM WScript.Shell).CreateShortcut('%USERPROFILE%\Desktop\%SHORTCUT_NAME%.lnk'); $s.TargetPath='python'; $s.Arguments='\"%INSTALL_DIR%\auto_editor_gui.py\"'; $s.WorkingDirectory='%INSTALL_DIR%'; $s.IconLocation='%INSTALL_DIR%\autocut.ico'; $s.Description='AutoCut Pro Video Editor'; $s.Save()"

:: 7. Refresh icon cache
echo Refreshing icon cache...
taskkill /f /im explorer.exe >nul 2>&1
start explorer.exe
timeout /t 2 >nul

:: 8. Create Uninstaller
echo Creating uninstaller...
echo @echo off > "%INSTALL_DIR%\uninstall.bat"
echo :: AutoCut Pro Uninstaller >> "%INSTALL_DIR%\uninstall.bat"
echo setlocal enabledelayedexpansion >> "%INSTALL_DIR%\uninstall.bat"
echo set "STARTMENU_PATH=%%APPDATA%%\Microsoft\Windows\Start Menu\Programs\%STARTMENU_FOLDER%" >> "%INSTALL_DIR%\uninstall.bat"
echo rmdir /s /q "!STARTMENU_PATH!" >> "%INSTALL_DIR%\uninstall.bat"
echo del "%%USERPROFILE%%\Desktop\%SHORTCUT_NAME%.lnk" 2^>nul >> "%INSTALL_DIR%\uninstall.bat"
echo python -m pip uninstall auto-editor sv_ttk -y >> "%INSTALL_DIR%\uninstall.bat"
echo rmdir /s /q "%INSTALL_DIR%" >> "%INSTALL_DIR%\uninstall.bat"
echo echo Uninstallation complete! >> "%INSTALL_DIR%\uninstall.bat"
echo pause >> "%INSTALL_DIR%\uninstall.bat"

echo Installation successful!
echo Installed to: %INSTALL_DIR%
echo Shortcuts created in Start Menu and Desktop
timeout /t 5