-- name: warp-helpers.lua
-- description: Mostly contains functions and variables that are important for the main purpose of the mod.

--Multiple types of desyncs can if any player has a weak machine or spotty connection. Multiple people trying to use reset or restart commands at the exact same time or coop.net being fucked up might cause problems too.
gGlobalSyncTable.saveDue = false --Can't allow players in multiplayer to manually call save_pos() and on_warp() anymore since it's a part of gGlobalSyncTable now instead of staying local.
gGlobalSyncTable.BowserFix = true --Enable or disable the fix attempt. Enabled by default.
gGlobalSyncTable.allBowser = true --Determines if everyone gets to see Bowser's dialogue and intro cutscenes. The "not all" fix was a failed attempt to preserve and be as faithful as possible to the original logic of Bowser's behavior script (read: only 1 person initiates the cutscene and dialogue). Enabled by default.
gGlobalSyncTable.BowserCut = true --Bowser's intro cutscenes enabled or disabled. Enabled by default.
gGlobalSyncTable.sameID = nil --Only used for the "solo" Bowser fix.

local save_y = nil
local save_x = nil
local save_z = nil
local save_angle_y = nil
local save_angle_x = nil

local resetDue = false

afterCutscene = false --Player finished viewing the Bowser entrance cutscene. Only used for the "solo" Bowser fix.
isBowserHere = false

--[[ Bowser's behavior script will bug out and have him do nothing if you restart the level with more than a single person in it. Most likely has to do with lines 210-224 or 1409-1415.
Level example: https://github.com/djoslin0/sm64ex-coop/blob/coop/levels/bowser_1/script.c
Behavior script: https://github.com/djoslin0/sm64ex-coop/blob/coop/src/game/behaviors/bowser.inc.c ]]
--Everyone warping to the arena at the same time from outside the level is completely fine. Why does the game fail to completely reinitialize Bowser otherwise? Is it related to how Mario 64 saves levels?
local function bowser_fix_attempt() --Moving the main body of the function to mario_update() should also work.
    if gGlobalSyncTable.BowserFix then
        if isBowserHere then --Only letting the rest the body run if Bowser is supposed to be in the level.
            if gGlobalSyncTable.sameID == gNetworkPlayers[0].globalIndex or gGlobalSyncTable.allBowser then --It would take less time and effort for Bowser to automatically sync with everyone if everyone gets to see the cutscene. Allowed as an option since the "faithful" recreation is poor and most people don't mind the inaccuracy of the "all" option.
                if count_objects_with_behavior(get_behavior_from_id(id_bhvBowser)) ~= 0 then
                    if find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oAction == 20 then --bowser_act_nothing
                        if gGlobalSyncTable.BowserCut then
                            find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oAction = 5 --bowser_act_text_wait
                            start_cutscene(gMarioStates[0].area.camera, CUTSCENE_ENTER_BOWSER_ARENA) --oAction is usually 0 after this. Waiting, resetting again, or moving closer to and then away from Bowser usually fix it. Inconsistent on when this happens or who needs to do it.
                        else
                            if find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oBehParams2ndByte == 1 then --BitFS. The game seems to struggle with synchronizing this fight because of the high jump and tilting platform.
                                find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oAction = 13 --High jump.
                            else find_object_with_behavior(get_behavior_from_id(id_bhvBowser)).oAction = 0 end
                        end
                        if gGlobalSyncTable.sameID == gNetworkPlayers[0].globalIndex then
                            if gGlobalSyncTable.allBowser ~= true and gGlobalSyncTable.BowserCut ~= false then afterCutscene = true end --Not necessary if everyone sees the cutscene or NO ONE sees the cutscene.
                            --network_send_object(find_object_with_behavior(get_behavior_from_id(id_bhvBowser)), true) --This should be unnecesary because his behavior script should've already taken care of this. Though by that same logic, it might also be the same reason why desyncs can happen in the beginning.
                            gGlobalSyncTable.sameID = nil
                        end
                    end --Ironically, this will likely break Bowser in romhacks where people try to make him do something fancy or different.
                end
            end
            isBowserHere = false
        end
    end
end --Does nothing for when people decide to spawn another Bowser when he's still alive or when they're outside of an arena.

--Modified functions from GroovyBeardLover's "Save and Load Position" mod. Very simple in hindsight but I needed something that I knew that definitely works to bug test the "/warp reset" command.
local function save_pos() --I don't intend to save more than the position coordinates and face angles for now. Camera details will probably take priority first after I figure out how to save it.
    if gGlobalSyncTable.saveDue then
        save_y = gMarioStates[0].pos.y
        save_x = gMarioStates[0].pos.x
        save_z = gMarioStates[0].pos.z
        save_angle_y = gMarioStates[0].faceAngle.y
        save_angle_x = gMarioStates[0].faceAngle.x
    end
end

local function on_warp() --Preserving the camera's details is more difficult than it looks.
    if gMarioStates[0].health == 0x0FF or gMarioStates[0].action == ACT_BUBBLED then
        gMarioStates[0].health = 0x880
        gMarioStates[0].healCounter = 0
        gMarioStates[0].hurtCounter = 0
    end
    if resetDue then
        if save_y ~= nil then
            gMarioStates[0].pos.y = save_y
            gMarioStates[0].pos.x = save_x
            gMarioStates[0].pos.z = save_z
            gMarioStates[0].faceAngle.y = save_angle_y --Some levels have the player automatically turn towards something after spawning for some reason. Using a different event hook might deal with it, but it'll make resets look more awkward because of the very apparent delays.
            gMarioStates[0].faceAngle.x = save_angle_x
            
            hide_attempt = true

            save_y, save_x, save_z, save_angle_y, save_angle_x = nil
        else log_to_console("Load failed. save_y == nil") end
        resetDue = false
        gGlobalSyncTable.saveDue = false
    end
end

local function level_restart(msg, level_check, area_check, act_check, message_name, name_colour)
    if (gNetworkPlayers[0].currLevelNum == level_check) and (gNetworkPlayers[0].currAreaIndex == area_check) and (gNetworkPlayers[0].currActNum == act_check) then
        save_pos()
        local verb = nil --To customize the level notification popup message.
        if msg == "RESET" then --Hopefully will prevent cases where "/warp restart" can theoretically save and load positions upon level restart if someone else uses "/warp reset" at the same time in a different level.
            verb = "reset"
            resetDue = true --Easy way of letting players (other than the restart initiator) know to load their saved pos if they're in the same level as the initiator since gGlobalSyncTable is strict.
        else --"RESTART"
            verb = "restarted"
            resetDue = false --Just to be sure.
            save_y, save_x, save_z, save_angle_y, save_angle_x = nil
        end

        --Most of these ideas are also from Agent X's "Flood" mod.
        init_single_mario(gMarioStates[0]) --Actually clears gMarioStates[0].action before the if-statement below. This includes the ACT_BUBBLE action but I'll keep that condition in as a reminder.
        if msg == "RESTART" or gMarioStates[0].health == 0x0FF or gMarioStates[0].action == ACT_BUBBLED then --It probably did not make sense to restore health when resetting instead of only restarting in the first place.
            gMarioStates[0].health = 0x880
            gMarioStates[0].healCounter = 0
            gMarioStates[0].hurtCounter = 0
        end
        pseudo_global_popup(verb, level_check, area_check, act_check, message_name, name_colour)
        if gGlobalSyncTable.BowserFix then
            if count_objects_with_behavior(get_behavior_from_id(id_bhvBowser)) ~= 0 then
                afterCutscene = false
                isBowserHere = true
                --obj_mark_for_deletion(find_object_with_behavior(get_behavior_from_id(id_bhvBowser))) --Not sure if marking Bowser for deletion before restarts actually does anything to help re-init him.
            end
        end
        warp_restart_level()
    end
end

function level_res(msg) --Resets the current level instance. May move you to the start of the level. Might also still break if multiple people are trying to use it at the same time across separate levels.
    if warp_restart_level() == false then
        local_popup("Unable to restart or reset the level.")
        return false
    else
        if msg == "RESET" then gGlobalSyncTable.saveDue = true end

        if gGlobalSyncTable.BowserFix then
            if count_objects_with_behavior(get_behavior_from_id(id_bhvBowser)) ~= 0 then
                gGlobalSyncTable.sameID = gNetworkPlayers[0].globalIndex
            end
        end

        network_send(true, { restart = msg, cLevel = gNetworkPlayers[0].currLevelNum, cArea = gNetworkPlayers[0].currAreaIndex, cAct = gNetworkPlayers[0].currActNum, sName = gNetworkPlayers[0].name, nameColour = network_get_player_text_color_string(0)})
        level_restart(msg, gNetworkPlayers[0].currLevelNum, gNetworkPlayers[0].currAreaIndex, gNetworkPlayers[0].currActNum, gNetworkPlayers[0].name, network_get_player_text_color_string(0))
    end
    return true
end

function warp_to(warpLevel, warpArea, warpAct, wpNode)
    if tonumber(warpLevel) ~= nil and tonumber(warpArea) ~= nil and tonumber(warpAct) ~= nil and tonumber(wpNode) ~= nil then --int aLevel aArea aAct aWarpId
        if warp_to_warpnode(tonumber(warpLevel), tonumber(warpArea), tonumber(warpAct), tonumber(wpNode)) == false then
            local_popup("Warp to level \\#ff0000\\" .. warpLevel .. "\\#ffffff\\, area \\#ff0000\\" .. warpArea .. "\\#ffffff\\, act \\#ff0000\\" .. warpAct .. "\\#ffffff\\, warp node \\#ff0000\\" .. wpNode .. "\\#ffffff\\ failed.")
        else warp_to_warpnode(tonumber(warpLevel), tonumber(warpArea), tonumber(warpAct), tonumber(wpNode)) end
    elseif tonumber(warpLevel) ~= nil and tonumber(warpArea) ~= nil and tonumber(warpAct) ~= nil then --int LevelNum AreaIndex ActNum
        if warp_to_level(tonumber(warpLevel), tonumber(warpArea), tonumber(warpAct)) == false then
            local_popup("Warp to level \\#ff0000\\" .. warpLevel .. "\\#ffffff\\, area \\#ff0000\\" .. warpArea .. "\\#ffffff\\, act \\#ff0000\\" .. warpAct .. "\\#ffffff\\ failed.")
        else warp_to_level(tonumber(warpLevel), tonumber(warpArea), tonumber(warpAct)) --Be careful with the ActNum parameter. The game actually usually allows you to warp to that act (read: star level) regardless if they're normally ever accessible.
        end
    else pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp to \\#10ff10\\LevelNum AreaIndex ActNum (Optional)WarpId") end --level = course id, area = default "1", act = star number, WarpId = seems to actually ask for destNode instead of aWarpId
end

function warp_exit(userInput)
    if tonumber(userInput) == 1 or tonumber(userInput) == nil then --Same behavior as selecting "Exit Course" from the pause menu.
        if level_trigger_warp(gMarioStates[0], WARP_OP_EXIT) ~= nil then
            level_trigger_warp(gMarioStates[0], WARP_OP_EXIT) --Can work on maps where you can't normally access the "Exit Course" option from the pause menu.
        else local_popup("Unable to exit the course.") end
    elseif tonumber(userInput) == 2 then --Completely exit the level. Usually doesn't force you into an animation unlike the traditional "Exit Course option".
        if warp_exit_level(10) ~= true then local_popup("Unable to exit the level.")
        else warp_exit_level(10) end --arg is just warp delay (int).
    else pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp exit \\#10ff10\\[ |1|2]") end
end

function warp_get(getType, getInput)
    if getType == 'b' then
        if tonumber(getInput) ~= nil then
            if level_is_vanilla_level(tonumber(getInput)) ~= true and smlua_level_util_get_info(tonumber(getInput)) ~= nil then --int LevelId
                log_to_console("Custom level num: " .. tostring(smlua_level_util_get_info(tonumber(getInput)).levelNum))
                log_to_console("Custom level course num: " .. tostring(smlua_level_util_get_info(tonumber(getInput)).courseNum))
                log_to_console("Custom level full name: " .. tostring(smlua_level_util_get_info(tonumber(getInput)).fullName))
                log_to_console("Custom level mod index: " .. tostring(smlua_level_util_get_info(tonumber(getInput)).modIndex))
                if smlua_level_util_get_info(tonumber(getInput)).next ~= nil then
                    log_to_console("Next custom level: " .. tostring(smlua_level_util_get_info(tonumber(getInput)).next.fullName))
                else log_to_console("No next custom level") end
                log_to_console("Custom level script entry name: " .. tostring(smlua_level_util_get_info(tonumber(getInput)).scriptEntryName))
                log_to_console("Custom level short name: " .. tostring(smlua_level_util_get_info(tonumber(getInput)).shortName))
            else local_popup("/warp get: custom level N/A") end
        else pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp get \\#10ff10\\LevelNum") end
    elseif getType == 'c' then
        if tonumber(getInput) ~= nil then
            if level_is_vanilla_level(tonumber(getInput)) ~= true and smlua_level_util_get_info_from_course_num(tonumber(getInput)) ~= nil then --int CourseNum
                log_to_console("Custom level num: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(getInput)).levelNum))
                log_to_console("Custom level course num: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(getInput)).courseNum))
                log_to_console("Custom level full name: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(getInput)).fullName))
                log_to_console("Custom level mod index: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(getInput)).modIndex))
                if smlua_level_util_get_info_from_course_num(tonumber(getInput)).next ~= nil then
                    log_to_console("Next custom level: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(getInput)).next.fullName))
                else log_to_console("No next custom level") end
                log_to_console("Custom level script entry name: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(getInput)).scriptEntryName))
                log_to_console("Custom level short name: " .. tostring(smlua_level_util_get_info_from_course_num(tonumber(getInput)).shortName))
            else local_popup("/warp cget: custom level N/A") end
        else pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp cget \\#10ff10\\CourseNum") end
    elseif getType == 's' then
        if tostring(getInput) ~= nil then
            if smlua_level_util_get_info_from_short_name(tostring(getInput)) ~= nil then --string ShortName. This shit is actually case-sensitive.
                log_to_console("Custom level num: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(getInput)).levelNum))
                log_to_console("Custom level course num: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(getInput)).courseNum))
                log_to_console("Custom level full name: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(getInput)).fullName))
                log_to_console("Custom level mod index: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(getInput)).modIndex))
                if smlua_level_util_get_info_from_short_name(tostring(getInput)).next then
                    log_to_console("Next custom level: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(getInput)).next.fullName))
                else log_to_console("No next custom level") end
                log_to_console("Custom level script entry name: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(getInput)).scriptEntryName))
                log_to_console("Custom level short name: " .. tostring(smlua_level_util_get_info_from_short_name(tostring(getInput)).shortName))
            else local_popup("/warp sget: custom level N/A") end
        else pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp sget \\#10ff10\\ShortName") end
    elseif getType == 'n' then
        if tonumber(getInput) ~= nil then --int WarpNodeId
            if area_get_warp_node(tonumber(getInput)) ~= nil then --Command fails for warp node id 0 even if teleporting to it is valid.
                log_to_console("destLevel: " .. tostring(area_get_warp_node(tonumber(getInput)).node.destLevel))
                log_to_console("destArea: " .. tostring(area_get_warp_node(tonumber(getInput)).node.destArea))
                log_to_console("destNode: " .. tostring(area_get_warp_node(tonumber(getInput)).node.destNode))
                log_to_console("id: " .. tostring(area_get_warp_node(tonumber(getInput)).node.id))
                log_to_console("Next WarpNode id: " .. tostring(area_get_warp_node(tonumber(getInput)).next.node.id))
            else local_popup("/warp nget: warp node N/A") end
        else pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp nget \\#10ff10\\WarpId") end
    elseif getType == 'i' then
        if SM64COOPDX_VERSION ~= nil then
            if tonumber(getInput) ~= nil then --int instantWarpIndex
                if get_instant_warp(tonumber(getInput)) ~= nil then
                    log_to_console("area: " .. tostring(get_instant_warp(tonumber(getInput)).area))
                    log_to_console("displacement: " .. tostring(get_instant_warp(tonumber(getInput)).displacement.x) .. ", " .. tostring(get_instant_warp(tonumber(getInput)).displacement.y) .. ", " .. tostring(get_instant_warp(tonumber(getInput)).displacement.z))
                    log_to_console("id: " .. tostring(get_instant_warp(tonumber(getInput)).id))
                else local_popup("/warp iget: instant warp N/A") end
            else pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp iget \\#10ff10\\WarpIndex") end
        else pseudo_error_handler("COOPDX", nil) end
    end
end

--Modified function from Agent X's "Flood" mod. Helps makes sure that everyone "exits" the level at the same time to create a new level instance.
local function on_packet_receive(dataTable)
    if dataTable.restart == "RESTART" or dataTable.restart == "RESET" then level_restart(dataTable.restart, dataTable.cLevel, dataTable.cArea, dataTable.cAct, dataTable.sName, dataTable.nameColour)
    elseif dataTable.extra == "peach" then level_trigger_warp(gMarioStates[0], 23)
    elseif dataTable.extra == "cake" then level_trigger_warp(gMarioStates[0], WARP_OP_CREDITS_END) end
end

hook_event(HOOK_ON_SYNC_VALID, bowser_fix_attempt) --What a fucking mess.
hook_event(HOOK_ON_PACKET_RECEIVE, on_packet_receive)
hook_event(HOOK_ON_WARP, on_warp) --There will still be a slight delay where you can see the models of the other players render into existence.