-- name: Taunts: The insult expansion
-- description: Adds more taunts like Waving and Star dance, they can be used by holding L and pressing x or y, crouching while pressing the d-pad or crouching while holding L and pressing the d-pad

local gStateExtras = {}
for i=0,(MAX_PLAYERS-1) do
    gStateExtras[i] = {}
    local e = gStateExtras[i]
    e.animFrame = 0
    e.wave = false
    e.starDance = false
    e.fedora = false
    e.shrug = false
    e.mLady = false
    e.peterGriffin = false
    e.dead = false
    e.deadOnBack = false
    e.deadOnStomach = false
    e.suck = false
end

function mario_update(m)
    local e = gStateExtras[m.playerIndex]

    if (m.controller.buttonDown & R_TRIG) ~= 0 and m.action == ACT_IDLE then
        if (m.controller.buttonPressed & X_BUTTON) ~= 0 then
            e.wave = true
        end
    end

    if m.action == ACT_CROUCHING then
        if (m.controller.buttonDown & R_TRIG) == 0 then
            if (m.controller.buttonPressed & L_JPAD) ~= 0 then
                e.fedora = true
                e.animFrame = 1
                m.flags = m.flags | MARIO_CAP_IN_HAND
                m.flags = m.flags & ~MARIO_CAP_ON_HEAD
            end
            if (m.controller.buttonPressed & R_JPAD) ~= 0 then
                e.shrug = true
                e.animFrame = 1
            end
            if (m.controller.buttonPressed & D_JPAD) ~= 0 then
                e.mLady = true
                e.animFrame = 1
                m.flags = m.flags | MARIO_CAP_IN_HAND
                m.flags = m.flags & ~MARIO_CAP_ON_HEAD
            end
            if (m.controller.buttonPressed & U_JPAD) ~= 0 then
                e.peterGriffin = true
                e.animFrame = 1
            end
			if (m.controller.buttonPressed & Y_BUTTON) ~= 0 then
				e.starDance = true
				e.animFrame = 1
			end
        end
        if (m.controller.buttonDown & R_TRIG) ~= 0 then
            if (m.controller.buttonPressed & L_JPAD) ~= 0 then
                e.dead = true
                e.animFrame = 1
            end
            if (m.controller.buttonPressed & R_JPAD) ~= 0 then
                e.deadOnBack = true
                e.animFrame = 1
            end
            if (m.controller.buttonPressed & D_JPAD) ~= 0 then
                e.deadOnStomach = true
                e.animFrame = 1
            end
            if (m.controller.buttonPressed & U_JPAD) ~= 0 then
                e.suck = true
                e.animFrame = 1
            end
        end
    end

    if e.wave == true then
        e.starDance = false
        e.fedora = false
        e.shrug = false
        e.mLady = false
        e.peterGriffin = false
        e.dead = false
        e.deadOnBack = false
        e.deadOnStomach = false
        e.suck = false
        set_mario_animation(m, MARIO_ANIM_CREDITS_WAVING)
        set_anim_to_frame(m, e.animFrame)
        e.animFrame = e.animFrame + 1
        if e.animFrame >= m.marioObj.header.gfx.animInfo.curAnim.loopEnd then
            e.animFrame = e.animFrame - m.marioObj.header.gfx.animInfo.curAnim.loopEnd
        end
    end

    if e.starDance == true then
        e.wave = false
        e.fedora = false
        e.shrug = false
        e.mLady = false
        e.peterGriffin = false
        e.dead = false
        e.deadOnBack = false
        e.deadOnStomach = false
        e.suck = false
        set_mario_animation(m, MARIO_ANIM_STAR_DANCE)
        set_anim_to_frame(m, e.animFrame)
        e.animFrame = e.animFrame + 1
        if e.animFrame == 40 then
            play_character_sound(m, CHAR_SOUND_HERE_WE_GO)
        end
        if e.animFrame > 40 then
            m.marioBodyState.handState = MARIO_HAND_PEACE_SIGN
        end
    end

    if e.fedora == true then
        e.wave = false
        e.starDance = false
        e.shrug = false
        e.mLady = false
        e.peterGriffin = false
        e.dead = false
        e.deadOnBack = false
        e.deadOnStomach = false
        e.suck = false
        if e.animFrame > 80 then
            m.flags = m.flags & ~MARIO_CAP_IN_HAND
            m.flags = m.flags | MARIO_CAP_ON_HEAD
        end
        set_mario_animation(m, MARIO_ANIM_TAKE_CAP_OFF_THEN_ON)
        set_anim_to_frame(m, e.animFrame)
        e.animFrame = e.animFrame + 1
    end

    if e.shrug == true then
        e.wave = false
        e.starDance = false
        e.fedora = false
        e.mLady = false
        e.peterGriffin = false
        e.dead = false
        e.deadOnBack = false
        e.deadOnStomach = false
        e.suck = false
        set_mario_animation(m, MARIO_ANIM_MISSING_CAP)
        set_anim_to_frame(m, e.animFrame)
        e.animFrame = e.animFrame + 1
    end

    if e.mLady == true then
        e.wave = false
        e.starDance = false
        e.fedora = false
        e.shrug = false
        e.peterGriffin = false
        e.dead = false
        e.deadOnBack = false
        e.deadOnStomach = false
        e.suck = false
        set_mario_animation(m, MARIO_ANIM_CREDITS_TAKE_OFF_CAP)
        set_anim_to_frame(m, e.animFrame)
        e.animFrame = e.animFrame + 1
    end

    if e.peterGriffin == true then
        e.wave = false
        e.starDance = false
        e.fedora = false
        e.shrug = false
        e.mLady = false
        e.dead = false
        e.deadOnBack = false
        e.deadOnStomach = false
        e.suck = false
        set_mario_animation(m, MARIO_ANIM_ELECTROCUTION)
        set_anim_to_frame(m, e.animFrame)
        e.animFrame = e.animFrame + 1
    end

    if e.dead == true then
        e.wave = false
        e.starDance = false
        e.fedora = false
        e.shrug = false
        e.mLady = false
        e.peterGriffin = false
        e.deadOnBack = false
        e.deadOnStomach = false
        e.suck = false
        set_mario_animation(m, MARIO_ANIM_DYING_FALL_OVER)
        set_anim_to_frame(m, e.animFrame)
        e.animFrame = e.animFrame + 1
    end

    if e.deadOnBack == true then 
        e.wave = false
        e.starDance = false
        e.fedora = false
        e.shrug = false
        e.mLady = false
        e.peterGriffin = false
        e.dead = false
        e.deadOnStomach = false
        e.suck = false
        set_mario_animation(m, MARIO_ANIM_DYING_ON_BACK)
        set_anim_to_frame(m, e.animFrame)
        e.animFrame = e.animFrame + 1
    end

    if e.deadOnStomach == true then
        e.wave = false
        e.starDance = false
        e.fedora = false
        e.shrug = false
        e.mLady = false
        e.peterGriffin = false
        e.dead = false
        e.deadOnBack = false
        e.suck = false
        set_mario_animation(m, MARIO_ANIM_DYING_ON_STOMACH)
        set_anim_to_frame(m, e.animFrame)
        e.animFrame = e.animFrame + 1
    end

    if e.suck == true then
        e.wave = false
        e.starDance = false
        e.fedora = false
        e.shrug = false
        e.mLady = false
        e.peterGriffin = false
        e.dead = false
        e.deadOnBack = false
        e.deadOnStomach = false
        set_mario_animation(m, MARIO_ANIM_DYING_IN_QUICKSAND)
        set_anim_to_frame(m, e.animFrame)
        e.animFrame = e.animFrame + 1
        m.marioObj.header.gfx.pos.y = m.marioObj.header.gfx.pos.y - e.animFrame
        if e.animFrame > 150 then
            set_mario_action(m, ACT_QUICKSAND_DEATH, 0)
            e.animFrame = 1
        end
    end


    if m.action ~= ACT_IDLE and m.action ~= ACT_CROUCHING and m.action ~= ACT_STOP_CROUCHING then
        e.wave = false
        e.starDance = false
        e.fedora = false
        e.shrug = false
        e.mLady = false
        e.peterGriffin = false
        e.dead = false
        e.deadOnBack = false
        e.deadOnStomach = false
        e.suck = false
        m.flags = m.flags & ~MARIO_CAP_IN_HAND
        m.flags = m.flags | MARIO_CAP_ON_HEAD
    end

    if m.action == ACT_STOP_CROUCHING then
        set_mario_action(m, ACT_IDLE, 0)
    end
end

-- hook_event(HOOK_MARIO_UPDATE, mario_update)
_G.Moi64Mods.hook_mario_update(mario_update)
