-- name: Sprays EX
-- description: Adds a Source-like spray system to Mario 64! \nDPAD_DOWN to spray! \nChange sprays with /spray-type! \nMade by BuckleyTim and Birdekek
---Modified by Twin Drive System
---bing
---
local debug = false
local msg_timer = 0

local current_spray = 0
if mod_storage_exists("current_spray") then current_spray = mod_storage_load_number("current_spray") end

local E_MODEL_SOURCE_SPRAY = smlua_model_util_get_id("icon_display_geo")
local SFX_SPRAY = audio_sample_load("spray.ogg")

--add spray textures
local spray_table = {}

local defaultIcons = {
  [CT_MARIO]   = get_texture_info("spray_mario"),
  [CT_LUIGI]   = get_texture_info("spray_luigi"),
  [CT_TOAD]    = get_texture_info("spray_toad"),
  [CT_WALUIGI] = get_texture_info("spray_waluigi"),
  [CT_WARIO]   = get_texture_info("spray_wario")
}

local fe_mat = gfx_get_from_name("mat_icon_display_icon")
local changed_objects = {}

function vec3f() return { x = 0, y = 0, z = 0 } end

local function get_beh_param(behParams, param) -- credits to xLuigiGamerx
  return (behParams >> (8 * (4 - param))) & 0xFF
end

local function set_beh_param(behParams, param, value)
  local shift = 8 * (4 - param)
  behParams = behParams & ~(0xFF << shift)
  return behParams | ((value & 0xFF) << shift)
end

local function get_icon(o)
  local icon

  if o.oBehParams2ndByte ~= 1 then
    local char_table = _G.charSelect.character_get_current_table(o.oBehParams2ndByte, get_beh_param(o.oBehParams, 4))
    icon = char_table.lifeIcon
  else
    if _G.charSelectExists then
      icon = defaultIcons[(o.oBehParams & 0xFF) - 1]
    else
      icon = defaultIcons[o.oBehParams & 0xFF]
    end
  end

  return icon
end

function display_icon_geo_func(node, matStackIndex)
  local o = geo_get_current_object()

  local ptr = o._pointer
  local geo = cast_graph_node(node.next)

  local dlHead = gfx_get_from_name("fe_displaylist" .. ptr)

  if not dlHead then
    dlHead = gfx_create("fe_displaylist" .. ptr, 16)
    gfx_copy(dlHead, fe_mat, gfx_get_length(fe_mat))
  end

  local texture

  if o.oBehParams2ndByte ~= 0 then
    texture = get_icon(o)
  else
    texture = spray_table[get_beh_param(o.oBehParams, 4)].texture
  end

  if type(texture) == "table" and not texture.texture then
    local time = o.oTimer / 10
    local frames = #texture[1]
    local fps = texture[2]
    local frame = math.min(math.max(math.floor((time*fps) % frames), 1), frames)
    texture = texture[1][frame]
    if texture.texture ~= changed_objects[o] then
      changed_objects[o] = nil
    end
  end

  if changed_objects[o] == nil then
    local cmdt = gfx_get_command(dlHead, 7)
    gfx_set_command(cmdt, "gsDPSetTextureImage(G_IM_FMT_RGBA, G_IM_SIZ_16b_LOAD_BLOCK, 1, %t)", texture.texture)

    changed_objects[o] = texture.texture
  end

  geo.displayList = dlHead
end

function spawn_mist_spray(obj, scale)
  local spi = obj_get_temp_spawn_particles_info(E_MODEL_MIST)
  if spi == nil then
    return nil
  end

  spi.behParam = 3
  spi.count = 5
  spi.offsetY = 25
  spi.forwardVelBase = 6 * scale
  spi.forwardVelRange = -12 * scale
  spi.velYBase = 6 * scale
  spi.velYRange = -12 * scale
  spi.gravity = 0
  spi.dragStrength = 5
  spi.sizeBase = 10 * scale
  spi.sizeRange = 16 * scale

  cur_obj_spawn_particles(spi)
end

function bhv_spray_init(o)
  obj_scale(o, 0.4)
end

id_bhvCustomSpray = hook_behavior(nil, OBJ_LIST_GENACTOR, true, bhv_spray_init, nil, "bhvCustomSpray")


local function debug_spray(x,y,z)
  if not debug then return end
  djui_chat_message_create('Play spray sound: {x:' .. x .. ", y:" .. y .. ", z:" .. z .. "}")
  print('Play spray sound: {x:' .. x .. ", y:" .. y .. ", z:" .. z .. "}")
end

-----------
-- MARIO UPDATE

local function mario_update(m) -- ALL Mario_Update hooked commands.,
  if is_player_active(m) == 0 or m ~= gMarioStates[0] then return end

  if (m.wall and (m.controller.buttonPressed & D_JPAD ~= 0)) then
    ---@param o Object
    local spray = spawn_sync_object(id_bhvCustomSpray, E_MODEL_SOURCE_SPRAY, m.pos.x, m.pos.y + 175, m.pos.z, function(o)
      local z, normal = vec3f(), m.wall.normal
      local x, xnormal = vec3f(), m.wall.normal
      --remove 16384 for floor spray variant
      o.oFaceAnglePitch = calculate_pitch(x, xnormal)
      o.oFaceAngleYaw = calculate_yaw(z, normal)
      o.oFaceAngleRoll = obj_resolve_collisions_and_turn(o.oFaceAngleYaw, 0)
      o.oPosX = o.oPosX - (48 * sins(o.oFaceAngleYaw))
      o.oPosZ = o.oPosZ - (48 * coss(o.oFaceAngleYaw))
      if current_spray == 0 then
        if _G.charSelectExists then
          o.oBehParams2ndByte = _G.charSelect.character_get_current_number(0)
          o.oBehParams = set_beh_param(o.oBehParams, 4, _G.charSelect.character_get_current_costume(0))
        else
          o.oBehParams2ndByte = 1
          o.oBehParams = set_beh_param(o.oBehParams, 4, gMarioStates[0].character.type)
        end
      else
        o.oBehParams = set_beh_param(o.oBehParams, 4, current_spray)
      end
    end)
    spawn_mist_spray(spray, 3)
    audio_sample_play(SFX_SPRAY, m.pos, 1)
    debug_spray(m.pos.x + 0.0, m.pos.y + 0.0, m.pos.z + 0.0)
    network_send(false, {
      type = "spray",
      x = m.pos.x + 0.0, -- adding 0.0 forces value to be float
      y = m.pos.y + 0.0,
      z = m.pos.z + 0.0,
      course = gNetworkPlayers[0].currCourseNum,
      level = gNetworkPlayers[0].currLevelNum,
      area = gNetworkPlayers[0].currAreaIndex,
    })
  end
end

local function on_spray_packet_recv(data)
  if data.type == "spray" then
    local p0 = gNetworkPlayers[0]
    if data.course == p0.currCourseNum and data.level == p0.currLevelNum and data.area == p0.currAreaIndex then
      debug_spray(data.x, data.y, data.z)
      audio_sample_play(SFX_SPRAY, { x = data.x, y = data.y, z = data.z }, 1)
    end
  end
end

hook_event(HOOK_ON_PACKET_RECEIVE, on_spray_packet_recv)
hook_event(HOOK_MARIO_UPDATE, mario_update)

-- Print the sprays as a chat message
-- Too many sprays will get truncated in chat so
-- divide into blocks
---@param msg string
---@param color string
---@param spray_name_table table
local function print_spray_names(msg, color, spray_name_table)
  local block = 35
  local msgPrefix = msg

  for i = 1, #spray_name_table, block do
    local last = math.min(i + block - 1, #spray_name_table)
    djui_chat_message_create(msgPrefix .. table.concat(spray_name_table, " | ", i, last))
    msgPrefix = color
  end
end

local function change_spray(msg) -- for future reference please don't name your functions like chat_changeSprayType. it's very cursed
  if msg == 'debug' then
    debug = not debug
    if debug then
      djui_chat_message_create("Debug toggled \\#00ff01\\on")
    else
      djui_chat_message_create("Debug toggled \\#fe0000\\off")
    end
    return true
  end
  local spray_name_table = {}
  local anim_spray_name_table = {}

  for i = 1, #spray_table do
    local spray_name = spray_table[i].name

    if msg == spray_name then
      current_spray = i
      mod_storage_save_number("current_spray", current_spray)
      djui_chat_message_create('Spray changed to ' .. spray_name .. '!')
      return true
    end


    local texture = spray_table[i].texture
    if type(texture) == "table" and not texture.texture then
      table.insert(anim_spray_name_table, spray_name)
    else
      table.insert(spray_name_table, spray_name)
    end
  end

  if msg == 'character' then
    current_spray = 0
    mod_storage_save_number("current_spray", current_spray)
    djui_chat_message_create('Spray changed to character!')
    return true
  end

  print_spray_names('Static Sprays: \\#00ffff\\ character | ', "\\#00ffff\\", spray_name_table)
  print_spray_names('Animated Sprays:  \\#fbec5d\\', "\\#fbec5d\\", anim_spray_name_table)

  return true
end

local function obj_unload(o)
  if changed_objects[o] then
    changed_objects[o] = nil
  end
end

local function update()
  msg_timer = msg_timer + 1

  if msg_timer == 10 then
    djui_chat_message_create('This server has Spray mod enabled. Press DPAD Down to spray.')
    djui_chat_message_create('"/spray" can also be used to change what type of spray you have!')
    msg_timer = 20
  end
  
  -- Reset current spray to default if the loaded index is out of bounds
  if current_spray ~= 0 and spray_table[current_spray] == nil then
	print('Spray reset to default')
	current_spray = 0
  end
end

hook_event(HOOK_UPDATE, update)
hook_event(HOOK_ON_OBJECT_UNLOAD, obj_unload)

hook_chat_command("spray", "\\#00ffff\\[ character | spray ]", change_spray)


--credits
--BuckleyTim made the thing
--Holc is a genius for Goremod which is where a lot of this code is cribbed from
--Birdekek is another genius where the retexture function is from


-- ===============================================================================
-- API
-- ===============================================================================

---@param name string The access name of the spray.
---@param texture TextureInfo|table The texture of the spray.
---@return boolean
local function api_create_spray(name, texture) -- Creates a custom spray. Use get_texture_info to get the texture.
  table.insert(spray_table, { name = name, texture = texture })
  log_to_console('Spray added via API with name "' .. name .. '"', CONSOLE_MESSAGE_INFO)
  return true
end

---@param name string The access name of the spray to edit.
---@param func function This can take in the old spray: {name = string, texture = TextureInfo}, and return the new edited spray to replace the old one with.
---@return boolean
local function api_edit_spray(name, func) -- Edits a spray based on the function you provide it. [ DOES NOT EDIT EXISTING SPRAYS ]
  for i = 1, #spray_table do
    local spray = spray_table[i]

    if spray.name == name then
      spray_table[i] = func(spray)       -- assume function takes in the spray, and also returns the edited spray
      log_to_console('Spray "' .. name .. '" was changed via API', CONSOLE_MESSAGE_INFO)
      return true
    end
  end

  log_to_console('Unable to find spray with name "' .. name .. '"', CONSOLE_MESSAGE_WARNING)
  return false
end

_G.sprayModExists = true

_G.sprayMod = {
  create_spray = api_create_spray,
  edit_spray = api_edit_spray,
}
