-- menu and hud

level_list = {
    LEVEL_CASTLE_GROUNDS,   -- Course 0
    LEVEL_CASTLE,           -- Course 0
    LEVEL_CASTLE_COURTYARD, -- Course 0
    LEVEL_BOB,              -- Course 1
    LEVEL_WF,               -- Course 2
    LEVEL_JRB,              -- Course 3
    LEVEL_CCM,              -- Course 4
    LEVEL_BBH,              -- Course 5
    LEVEL_HMC,              -- Course 6
    LEVEL_LLL,              -- Course 7
    LEVEL_SSL,              -- Course 8
    LEVEL_DDD,              -- Course 9
    LEVEL_SL,               -- Course 10
    LEVEL_WDW,              -- Course 11
    LEVEL_TTM,              -- Course 12
    LEVEL_THI,              -- Course 13
    LEVEL_TTC,              -- Course 14
    LEVEL_RR,               -- Course 15
    LEVEL_BITDW,            -- Course 16
    LEVEL_BOWSER_1,         -- Course 16
    LEVEL_BITFS,            -- Course 17
    LEVEL_BOWSER_2,         -- Course 17
    LEVEL_BITS,             -- Course 18
    LEVEL_BOWSER_3,         -- Course 18
    LEVEL_PSS,              -- Course 19
    LEVEL_COTMC,            -- Course 20
    LEVEL_TOTWC,            -- Course 21
    LEVEL_VCUTM,            -- Course 22
    LEVEL_WMOTR,            -- Course 23
    LEVEL_SA,               -- Course 24
    LEVEL_ENDING,           -- Course 25 (will not appear in MiniHunt)
}

local frameCounter = 0
local ssInformCounter = 0
function on_hud_render()
    djui_hud_set_resolution(RESOLUTION_DJUI)
    djui_hud_set_font(FONT_NORMAL)

    if viewScreenshot ~= 0 or ssWaitForWarp ~= 0 then
        if ssWaitForWarp ~= 0 or not gNetworkPlayers[0].currAreaSyncValid then
            local screenWidth = djui_hud_get_screen_width()
            local screenHeight = djui_hud_get_screen_height()
            djui_hud_set_color(0, 0, 0, 255)
            djui_hud_render_rect(0, 0, screenWidth + 10, screenHeight + 10)
            djui_hud_set_color(255, 255, 255, 255)
            local text = "Loading..."
            local scale = 4
            local width = djui_hud_measure_text(text) * scale
            djui_hud_print_text(text, (screenWidth - width) * 0.5, (screenHeight - 32 * scale) * 0.5, 4)
        else
            local data = screenshots[viewScreenshot]
            if not data then return end
            djui_hud_set_color(0, 0, 0, 255)
            local screenWidth = djui_hud_get_screen_width()
            local screenHeight = djui_hud_get_screen_height()
            local aspectRatio = screenWidth / screenHeight
            local ssAspectRatio = data.screenWidth / data.screenHeight
            if aspectRatio > ssAspectRatio then
                local diff = (screenWidth - (ssAspectRatio * screenHeight)) / 2
                djui_hud_render_rect(0, 0, diff, screenHeight + 10)
                djui_hud_render_rect(screenWidth - diff + 10, 0, diff, screenHeight + 10)
            end
        end
        toggle_hud(false)
        return
    elseif screenshotMode then
        toggle_hud(false)

        local hideIndex = get_hide_index()
        if hideIndex == 0 and autoSSTimer ~= 0 and autoSSTimer < gGlobalSyncTable.seekTimer and not gGlobalSyncTable.hiding then
            local seconds = math.ceil(autoSSTimer / 30)
            if seconds <= 15 and autoSSTimer % 30 == 0 then
                play_sound(SOUND_GENERAL2_SWITCH_TICK_FAST, gMarioStates[0].marioObj.header.gfx.cameraToObject)
            end
        end

        return screenshot_hud()
    elseif inMenu then
        toggle_hud(false)
        return render_menu()
    elseif gPlayerSyncTable[0].afk then
        toggle_hud(false)
        local screenWidth = djui_hud_get_screen_width()
        local screenHeight = djui_hud_get_screen_height()
        djui_hud_set_color(0, 0, 0, 200)
        djui_hud_render_rect(0, 0, screenWidth + 10, screenHeight + 10)
        djui_hud_set_color(255, 255, 255, 255)
        local text = "AFK"
        local scale = 4
        local width = djui_hud_measure_text(text) * scale
        djui_hud_print_text(text, (screenWidth - width) * 0.5, (screenHeight - 32 * scale) * 0.5, 4)
    else
        toggle_hud(true)
    end

    local hideIndex = get_hide_index()
    local scale = 2
    local timer = 0
    local text = ""
    local addHead = 255
    local width = 0

    if cheatTimer ~= 0 then
        text = string.format("No cheating! You will be removed from this round in %d.", (150-cheatTimer)//30)
        addHead = 255
    elseif hideIndex == 255 then
        if gGlobalSyncTable.selectionType ~= 0 then
            local name = "???"
            local np = network_player_from_global_index(gGlobalSyncTable.nextHider)
            if np then
                local playerColor = network_get_player_text_color_string(np.localIndex)
                name = playerColor .. np.name
                addHead = np.localIndex
            end
            text = "\\#ffff50\\Next: " .. name .. "\\HEAD" .. addHead .. "\\"
            width = width + 30 * scale
            if gGlobalSyncTable.selectionType == 2 and np then
                for i = 1, 2 do
                    np = network_player_from_global_index(get_next_hider(np.globalIndex))
                    if np then
                        local playerColor = network_get_player_text_color_string(np.localIndex)
                        name = playerColor .. np.name
                        addHead = np.localIndex
                    else
                        break
                    end
                    text = text .. ", " .. name .. "\\HEAD" .. addHead .. "\\"
                    width = width + 30 * scale
                end
            end
            timer = gGlobalSyncTable.autoTimer
        elseif network_is_server() or network_is_moderator() then
            text = "Open menu with \\#ffff50\\/geo\\#ffffff\\ or \\#ffff50\\L + START"
        else
            text = "Waiting for host..."
        end
    elseif hideIndex == 0 then
        if gGlobalSyncTable.hiding then
            text = "Use \\#ffff50\\L + R\\#ffffff\\ or \\#ffff50\\/hide\\#ffffff\\ to pick spot"
            timer = gGlobalSyncTable.hideTimer
        else
            text =
            "Press \\#ffff50\\X\\#ffffff\\ or \\#ffff50\\L + R\\#ffffff\\ to take a screenshot, or use \\#ffff50\\/hint\\#ffffff\\ to give hints"
            timer = gGlobalSyncTable.seekTimer
        end
    else
        local name = "the hider"
        local np = network_player_from_global_index(gGlobalSyncTable.hider)
        if np then
            local playerColor = network_get_player_text_color_string(np.localIndex)
            name = playerColor .. np.name
            addHead = np.localIndex
        end
        if gGlobalSyncTable.hiding then
            if ssInformCounter > 60 then
                text = "Press \\#ffff50\\L + R\\#ffffff\\ to take pictures!"
                addHead = 255
            else
                text = "\\#ffff50\\Waiting for " ..
                    name ..
                    "\\#ffff50\\\\HEAD" .. addHead .. "\\ to hide..."
                width = width + 30 * scale
            end
            ssInformCounter = ssInformCounter + 1
            if ssInformCounter >= 120 then ssInformCounter = 0 end
            timer = gGlobalSyncTable.hideTimer
        else
            if (gPlayerSyncTable[0].found == nil or gPlayerSyncTable[0].found == 0) then
                text = "\\#ffff50\\Find " .. name .. "\\#ffff50\\\\HEAD" .. addHead .. "\\!"
            else
                text = "\\#ffff50\\You found " .. name .. "\\#ffff50\\\\HEAD" .. addHead .. "\\!"
            end
            width = width + 30 * scale
            timer = gGlobalSyncTable.seekTimer
        end
    end
    local screenWidth = djui_hud_get_screen_width()
    if is_game_paused() or djui_hud_is_pause_menu_created() then
        screenWidth = screenWidth * 1.6
        scale = scale / 2
        width = width / 2
    end
    width = width + djui_hud_measure_text(remove_color(text)) * scale
    local x = (screenWidth - width) * 0.5
    local y = 0

    djui_hud_set_color(0, 0, 0, 128)
    djui_hud_render_rect(x - 12, y, width + 24, 32 * scale + 12)
    djui_hud_print_text_with_color(text, x, y, scale, 255)

    if timer and timer ~= 0 then
        local seconds = math.ceil(timer / 30)
        local minutes = seconds // 60
        seconds = seconds % 60

        text = string.format("%d:%02d", minutes, seconds)
        if hideIndex == 0 and autoSSTimer ~= 0 and autoSSTimer < timer and not gGlobalSyncTable.hiding then
            seconds = math.ceil(autoSSTimer / 30)
            local minutes = seconds // 60
            seconds = seconds % 60
            text = text .. " \\#ff8080\\(Auto screenshot in " .. string.format("%d:%02d", minutes, seconds) .. ")"
            if minutes == 0 and seconds <= 15 and autoSSTimer % 30 == 0 then
                play_sound(SOUND_GENERAL2_SWITCH_TICK_FAST, gMarioStates[0].marioObj.header.gfx.cameraToObject)
            end
        end

        local screenHeight = djui_hud_get_screen_height()
        width = djui_hud_measure_text(remove_color(text)) * scale
        x = (screenWidth - width) * 0.5
        y = screenHeight - 32 * scale

        if minutes > 0 then
            djui_hud_set_color(0, 0, 0, 128)
        else
            djui_hud_set_color(sins(frameCounter * 500) * 150, 0, 0, 128)
        end
        djui_hud_render_rect(x - 12, y, width + 24, 32 * scale + 12)
        djui_hud_set_color(255, 255, 255, 255)
        djui_hud_print_text_with_color(text, x, y, scale)
    end
    frameCounter = frameCounter + 1
    if frameCounter >= 60 then frameCounter = 0 end

    if gGlobalSyncTable.hiding and hideIndex ~= 0 then
        scale = 1
        width = 0
        local leadBoard = {}
        for i = 0, MAX_PLAYERS - 1 do
            if is_player_active(gMarioStates[i]) ~= 0 and gPlayerSyncTable[i].points and gPlayerSyncTable[i].points ~= 0 then
                local np = gNetworkPlayers[i]
                local playerColor = network_get_player_text_color_string(i)
                local name = playerColor .. np.name
                local thisWidth = djui_hud_measure_text(remove_color(name)) * scale
                if width < thisWidth then
                    width = thisWidth
                end
                table.insert(leadBoard, { name, i, gPlayerSyncTable[i].points or i })
            end
        end

        if #leadBoard == 0 then return end

        width = width + 30 * scale + 16 * 8 * scale

        table.sort(leadBoard, function(a, b)
            return a[3] > b[3]
        end)
        local screenHeight = djui_hud_get_screen_height()
        x = 12
        y = screenHeight * 0.5 - #leadBoard * 16 * scale
        djui_hud_set_color(0, 0, 0, 128)
        djui_hud_render_rect(x - 12, y, width + 24, #leadBoard * 32 * scale + 12)
        djui_hud_set_color(255, 255, 255, 255)
        local place = 0
        local prevPoints = 0
        for i, data in ipairs(leadBoard) do
            local name = data[1]
            local points = data[3]
            if prevPoints ~= points then
                place = i
                prevPoints = points
            end
            text = "\\#ffff50\\" .. placeString(place)
            text = text .. " " .. name .. "\\HEAD" .. data[2] .. "\\: " .. "\\#ffff50\\" .. points
            djui_hud_print_text_with_color(text, x, y, scale, 255)
            y = y + 32 * scale
        end
    end
end

hook_event(HOOK_ON_HUD_RENDER, on_hud_render)

function remove_hud_elements()
    hud_set_value(HUD_DISPLAY_FLAGS,
        hud_get_value(HUD_DISPLAY_FLAGS) &
        ~(HUD_DISPLAY_FLAG_LIVES | HUD_DISPLAY_FLAG_STAR_COUNT | HUD_DISPLAY_FLAG_COIN_COUNT| HUD_DISPLAY_FLAG_TIMER))
end

hook_event(HOOK_ON_HUD_RENDER_BEHIND, remove_hud_elements)

-- from shine thief
inMenu = false
local menuOption = 1
local menuID = 1
local stickCooldownX = 0
local stickCooldownY = 0
local menu_history = {}
-- menu data
local menu_data = {
    [1] = {
        {
            "View Hint",
            function(x)
                view_past_hints(x)
                inMenu = false
            end,
            false,
            1,
            currNum = 0,
            minNum = 0,
            maxNum = 100,
            nameRef = { "All" },
            optionPrefix = "Last ",
        },
        {
            "View Screenshot",
            function(x)
                view_command(x)
                inMenu = false
            end,
            false,
            1,
            currNum = 0,
            minNum = 0,
            maxNum = "total_ss",
            nameRef = { "Current", "Previous" },
            optionPrefix = "Back ",
        },
        { "Hide Here", function()
            hide_command()
            inMenu = false
        end, false, 2 },
        { "Screenshot", function()
            enter_screenshot_mode()
            inMenu = false
        end, false, 3 },
        {
            "View Queue Spot",
            function()
                queue_command()
                inMenu = false
            end,
            false,
            4,
        },
        {
            "View Blacklist",
            function()
                view_blacklist()
                inMenu = false
            end,
        },
        { "Manage Game", function() enter_menu(2) end, true },
    },
    [2] = {
        { "New Game",      function() enter_menu(3) end, true },
        { "Cancel Game", function()
            stop_command()
            inMenu = false
        end, true },
        { "Game Settings", function() enter_menu(4) end, true },
        {
            "Chat History",
            function(x)
                history_command(x)
            end,
            true,
            currNum = 10,
            minNum = 1,
            maxNum = 200,
            optionPrefix = "Last ",
        },
    },
    [3] = {
        {
            "Select Hider",
            function(x)
                local gIndex = network_global_index_from_local(x)
                if gIndex == 255 then return end
                start_game_command(gIndex)
                inMenu = false
            end,
            playerRef = true,
            currNum = 0,
            minNum = 0,
            maxNum = MAX_PLAYERS - 1,
        },
        {
            "Auto",
            function(x)
                gGlobalSyncTable.selectionType = x
                gGlobalSyncTable.autoTimer = 20 * 30
                if gNetworkPlayers[0].connected then -- prevents running on startup
                    gGlobalSyncTable.nextHider = get_next_hider(gGlobalSyncTable.hider)
                end
            end,
            currNum = 0,
            minNum = 0,
            maxNum = 3,
            nameRef = { "Off", "Random", "Round Robin", "Winner" },
            runOnChange = true,
            save = "auto",
        },
    },
    [4] = {
        {
            "Hiding Time",
            function(x)
                hide_time_command(x)
            end,
            timeRef = true,
            currNum = gGlobalSyncTable.maxHideTime,
            minNum = 0,
            maxNum = 60 * 60, -- 1 hour
            runOnChange = true,
            save = "maxHideTime",
        },
        {
            "Seeking Time",
            function(x)
                seek_time_command(x)
            end,
            timeRef = true,
            currNum = gGlobalSyncTable.maxSeekTime,
            minNum = 0,
            maxNum = 60 * 60, -- 1 hour
            runOnChange = true,
            save = "maxSeekTime",
        },
        {
            "End when % found",
            function(x)
                gGlobalSyncTable.foundPercent = x
            end,
            currNum = 80,
            minNum = 1,
            maxNum = 100,
            runOnChange = true,
            save = "foundPercent",
        },
        {
            "Auto SS Time",
            function(x)
                gGlobalSyncTable.laterSSTime = x
            end,
            timeRef = true,
            currNum = gGlobalSyncTable.laterSSTime,
            minNum = 0,
            maxNum = 60 * 60, -- 1 hour
            runOnChange = true,
            nameRef = { "\\#ff5050\\Off" },
            save = "laterSSTime",
        },
        {
            "Auto SS Time (First)",
            function(x)
                gGlobalSyncTable.firstSSTime = x
            end,
            timeRef = true,
            currNum = gGlobalSyncTable.firstSSTime,
            minNum = 0,
            maxNum = 60 * 60, -- 1 hour
            runOnChange = true,
            nameRef = { "\\#ff5050\\Off" },
            save = "firstSSTime",
        },
        {
            "BLJ and OOB",
            function(x)
                gGlobalSyncTable.glitch = (x == 1)
            end,
            currNum = 0,
            minNum = 0,
            maxNum = 1,
            nameRef = { "\\#ff5050\\Off", "\\#50ff50\\On" },
            runOnChange = true,
            save = "glitch",
        },
        {
            "Object Sounds",
            function(x)
                gGlobalSyncTable.sound = (x == 1)
            end,
            currNum = 1,
            minNum = 0,
            maxNum = 1,
            nameRef = { "\\#ff5050\\Off", "\\#50ff50\\On" },
            runOnChange = true,
            save = "sound",
        },
        {
            "Seekers Can See Each Other",
            function(x)
                gGlobalSyncTable.seekerSee = (x == 1)
            end,
            currNum = 1,
            minNum = 0,
            maxNum = 1,
            nameRef = { "\\#ff5050\\Off", "\\#50ff50\\On" },
            runOnChange = true,
            save = "seekerSee",
        },
        {
            "Seekers Can Speak",
            function(x)
                gGlobalSyncTable.seekerSpeak = (x == 1)
            end,
            currNum = 1,
            minNum = 0,
            maxNum = 1,
            nameRef = { "\\#ff5050\\Off", "\\#50ff50\\On" },
            runOnChange = true,
            save = "seekerSpeak",
        },
        {
            "Level Blacklist",
            function()
                enter_menu(5)
            end
        },
    },
    [5] = {
        {
            "",
            currNum = 1,
            minNum = 1,
            maxNum = #level_list,
            levelRef = true,
        },
        {
            "Area",
            currNum = 0,
            minNum = 0,
            maxNum = 8,
            nameRef = { "All" }
        },
        {
            "Add",
            function()
                local level = level_list[get_menu_option(5, 1)]
                local area = get_menu_option(5, 2)
                local store = level * 10 + area
                if level == gLevelValues.entryLevel and area < 2 then
                    djui_chat_message_create("Can't blacklist this level!")
                elseif game_blacklist[store] or game_blacklist[level * 10] then
                    djui_chat_message_create("This area is already blacklisted.")
                else
                    djui_chat_message_create("Blacklisted this area.")
                    game_blacklist[store] = 1
                    if area == 0 then
                        for data, v in pairs(game_blacklist) do
                            if type(data) == "number" and data // 10 == level and data % 10 ~= 0 then
                                game_blacklist[store] = nil
                            end
                        end
                    end
                    network_send_include_self(true, game_blacklist)
                end
            end,
        },
        {
            "Remove",
            function()
                local level = level_list[get_menu_option(5, 1)]
                local area = get_menu_option(5, 2)
                local store = level * 10 + area
                local unblackOne = false
                if game_blacklist[store] then
                    game_blacklist[store] = nil
                    unblackOne = true
                end

                if area == 0 then
                    for data, v in pairs(game_blacklist) do
                        if type(data) == "number" and data // 10 == level then
                            game_blacklist[data] = nil
                            unblackOne = true
                        end
                    end
                elseif game_blacklist[level * 10] then
                    game_blacklist[level * 10] = nil
                    unblackOne = true
                    for i = 1, 8 do
                        game_blacklist[level * 10 + i] = 1
                    end
                end

                if unblackOne then
                    djui_chat_message_create("Unblacklisted this area.")
                    network_send_include_self(true, game_blacklist)
                else
                    djui_chat_message_create("This area isn't blacklisted.")
                end
            end,
        },
        {
            "List",
            view_blacklist,
        },
        {
            "Reset",
            function()
                game_blacklist = { id = PACKET_SEND_BLACKLIST }
                network_send_include_self(true, game_blacklist)
                djui_chat_message_create("Removed all blacklisted levels.")
            end,
        },
    },
}
if network_is_server() then -- never nesters be crying rn
    for a, menu in ipairs(menu_data) do
        for b, button in ipairs(menu) do
            if button.save then
                local value = tonumber(mod_storage_load(button.save))
                if value and value % 1 == 0 then
                    button[2](value)
                    button.currNum = value
                end
            end
        end
    end
end

-- show the menu
function render_menu()
    djui_hud_set_resolution(RESOLUTION_DJUI)
    djui_hud_set_font(FONT_NORMAL)

    local screenWidth = djui_hud_get_screen_width()
    local screenHeight = djui_hud_get_screen_height()

    djui_hud_set_color(0, 0, 0, 200)
    djui_hud_render_rect(0, 0, screenWidth + 10, screenHeight + 10)

    local menu = menu_data[menuID]
    if not menu then return end

    -- first, determine menu size
    local scroll = false
    local scale = 2
    local renderButtons = 0
    for i, button in ipairs(menu) do
        if option_valid(button) then
            renderButtons = renderButtons + 1
        end
    end
    local totalButtons = renderButtons
    while (renderButtons * 40 * scale) > screenHeight do
        scroll = true
        renderButtons = renderButtons - 1
    end

    local x = 0
    local y = (screenHeight * 0.5) - (renderButtons * 20 * scale)
    if (renderButtons % 2 == 0) then
        y = y + 10 * scale
    end
    local downBy = 0
    while renderButtons + downBy < totalButtons and menuOption > totalButtons * 0.5 + downBy do
        y = y - 40 * scale
        downBy = downBy + 1
    end

    for i, button in ipairs(menu) do
        local text = button[1]
        if button.levelRef then
            local level = level_list[button.currNum] or 6
            local area = get_menu_option(5, 2)
            local optionText = get_level_name_custom(level_to_course[level], level, area)
            if level == LEVEL_CASTLE and area == 0 then
                optionText = "Inside Castle"
            elseif level == LEVEL_BOWSER_1 then
                optionText = "Bowser 1"
            elseif level == LEVEL_BOWSER_2 then
                optionText = "Bowser 2"
            elseif level == LEVEL_BOWSER_3 then
                optionText = "Bowser 3"
            end
            text = "\\#5050ff\\< " .. optionText .. " \\#5050ff\\>"
        elseif button.currNum then
            local optionText = ""
            if button.playerRef then
                local np = gNetworkPlayers[button.currNum]
                if not np.connected then
                    button.currNum = 0
                    np = gNetworkPlayers[0]
                end
                local playerColor = network_get_player_text_color_string(np.localIndex)
                optionText = playerColor .. np.name
            elseif button.nameRef and button.nameRef[button.currNum - button.minNum + 1] then
                optionText = button.nameRef[button.currNum - button.minNum + 1]
            elseif button.timeRef then
                if button.currNum ~= 0 then
                    local seconds = button.currNum
                    local minutes = seconds // 60
                    seconds = seconds % 60
                    optionText = string.format("%d:%02d", minutes, seconds)
                else
                    optionText = "Infinite"
                end
            else
                optionText = tostring(button.currNum)
                if button.optionPrefix then
                    optionText = button.optionPrefix .. optionText
                end
            end
            text = text .. "\\#5050ff\\  < " .. optionText .. " \\#5050ff\\>"
        end
        local width = djui_hud_measure_text(remove_color(text)) * scale

        x = (screenWidth - width) * 0.5

        if option_valid(button) then
            --djui_hud_set_color(255, 255, 255, 255)
            djui_hud_print_text_with_color(text, x, y, scale)
            if i == menuOption then
                djui_hud_set_color(64, 128, 64, sins(frameCounter * 500) * 50 + 25)
                frameCounter = frameCounter + 1
                if frameCounter >= 60 then frameCounter = 0 end
                djui_hud_render_rect(x - 6, y - 6, width + 12, 36 * scale + 12)
                if button.currNum and (not button.playerRef) and tonumber(button.maxNum) and button.maxNum >= 10 then
                    x = x + width + 20
                    djui_hud_set_color(255, 255, 255, 255)
                    djui_hud_print_text("Hold X to change by 10", x, y+10*scale, scale*0.5)
                end
            end
            y = y + 40 * scale
        end
    end

    if scroll then
        x = screenWidth - 50
        y = 50
        djui_hud_set_color(0, 0, 0, 255)
        djui_hud_render_rect(x, y, 20, screenHeight - 100)
        local portion = renderButtons / totalButtons
        local height = (screenHeight - 104) * portion
        y = y + ((screenHeight - 104) - height) * downBy / (totalButtons - renderButtons)
        djui_hud_set_color(155, 155, 155, 255)
        djui_hud_render_rect(x + 2, y + 2, 16, height)
    end
end

-- menu controls
sMenuInputsPressed = 0
sMenuInputsDown = 0
---@param m MarioState
function menu_controls(m)
    if m.playerIndex ~= 0 then return end

    if m.freeze < 3 then m.freeze = 3 end

    -- Disable controls for everything but the menu
    sMenuInputsPressed = m.controller.buttonDown & (m.controller.buttonDown ~ sMenuInputsDown)
    sMenuInputsDown = m.controller.buttonDown
    m.controller.buttonDown = 0
    m.controller.buttonPressed = 0
    m.controller.stickX = 0
    m.controller.stickY = 0

    local stickX = m.controller.rawStickX
    if (sMenuInputsDown & L_JPAD) ~= 0 then
        stickX = stickX - 65
    end
    if (sMenuInputsDown & R_JPAD) ~= 0 then
        stickX = stickX + 65
    end
    local stickY = m.controller.rawStickY
    if (sMenuInputsDown & D_JPAD) ~= 0 then
        stickY = stickY - 65
    end
    if (sMenuInputsDown & U_JPAD) ~= 0 then
        stickY = stickY + 65
    end

    if stickCooldownY > 0 then stickCooldownY = stickCooldownY - 1 end
    if stickCooldownX > 0 then stickCooldownX = stickCooldownX - 1 end

    local menu = menu_data[menuID]
    if not menu then
        inMenu = false
        return
    end
    local button = menu[menuOption]

    if (sMenuInputsPressed & A_BUTTON) ~= 0 and button and button[2] and not button.runOnChange then
        if not option_valid(button) then
            play_sound(SOUND_MENU_CAMERA_BUZZ, m.marioObj.header.gfx.cameraToObject)
        else
            play_sound(SOUND_MENU_CLICK_FILE_SELECT, m.marioObj.header.gfx.cameraToObject)
            button[2](button.currNum)
        end
    elseif (sMenuInputsPressed & B_BUTTON) ~= 0 then
        if #menu_history ~= 0 then
            play_sound(SOUND_MENU_CLICK_FILE_SELECT, m.marioObj.header.gfx.cameraToObject)
            enter_menu(menu_history[#menu_history][1], menu_history[#menu_history][2], true)
            table.remove(menu_history, #menu_history)
        else
            play_sound(SOUND_MENU_CLICK_FILE_SELECT, m.marioObj.header.gfx.cameraToObject)
            m.controller.buttonDown = B_BUTTON
            inMenu = false
        end
    elseif (sMenuInputsPressed & START_BUTTON) ~= 0 then
        play_sound(SOUND_MENU_CLICK_FILE_SELECT, m.marioObj.header.gfx.cameraToObject)
        m.controller.buttonDown = START_BUTTON
        inMenu = false
    end

    if not button then return end

    if button.currNum and stickCooldownX == 0 then
        local change = (sMenuInputsDown & X_BUTTON ~= 0 and 10) or 1
        if stickX > 64 then
            play_sound(SOUND_MENU_CHANGE_SELECT, m.marioObj.header.gfx.cameraToObject)
            button.currNum = button.currNum + change
            local max = button.maxNum or 999
            if max == "total_ss" then
                max = #screenshots - 1
                if max < 0 then max = 0 end
            end

            if max < button.currNum then
                button.currNum = button.minNum or 1
            elseif max == button.excludeNum then
                button.currNum = button.currNum + 1
            end

            if button.playerRef then
                local np = gNetworkPlayers[button.currNum]
                while not np.connected do
                    button.currNum = button.currNum + 1
                    if max < button.currNum then
                        button.currNum = button.minNum or 1
                    elseif button.currNum == button.excludeNum then
                        button.currNum = button.currNum + 1
                    end
                    np = gNetworkPlayers[button.currNum]
                end
            end

            stickCooldownX = 5
            if button.runOnChange and button[2] then
                button[2](button.currNum)
                if network_is_server() and button.save then
                    mod_storage_save(button.save, tostring(button.currNum))
                end
            end
        elseif stickX < -64 then
            play_sound(SOUND_MENU_CHANGE_SELECT, m.marioObj.header.gfx.cameraToObject)
            button.currNum = button.currNum - change
            local min = button.minNum or 1
            local max = button.maxNum or 999
            if max == "total_ss" then
                max = #screenshots - 1
                if max < 0 then max = 0 end
            end
            if button.currNum < min then
                button.currNum = max
            elseif button.currNum == button.excludeNum then
                button.currNum = button.currNum - 1
            end

            if button.playerRef then
                local np = gNetworkPlayers[button.currNum]
                while not np.connected do
                    button.currNum = button.currNum - 1
                    if button.currNum < min then
                        button.currNum = button.maxNum
                    elseif button.currNum == button.excludeNum then
                        button.currNum = button.currNum - 1
                    end
                    np = gNetworkPlayers[button.currNum]
                end
            end

            stickCooldownX = 5
            if button.runOnChange and button[2] then
                button[2](button.currNum)
                if network_is_server() and button.save then
                    mod_storage_save(button.save, tostring(button.currNum))
                end
            end
        end
    end

    if #menu > 1 and stickCooldownY == 0 then
        if stickY > 64 then
            play_sound(SOUND_MENU_CHANGE_SELECT, m.marioObj.header.gfx.cameraToObject)
            local valid = true
            local LIMIT = #menu
            while valid and LIMIT ~= 0 do
                LIMIT = LIMIT - 1
                menuOption = menuOption - 1
                if menuOption < 1 then
                    menuOption = #menu
                end
                button = menu[menuOption]
                valid = not option_valid(button)
            end
            stickCooldownY = 5
        elseif stickY < -64 then
            play_sound(SOUND_MENU_CHANGE_SELECT, m.marioObj.header.gfx.cameraToObject)
            local valid = true
            local LIMIT = #menu
            while valid and LIMIT ~= 0 do
                LIMIT = LIMIT - 1
                menuOption = menuOption + 1
                if #menu < menuOption then
                    menuOption = 1
                end
                button = menu[menuOption]
                valid = not option_valid(button)
            end
            stickCooldownY = 5
        end
    end
end

function open_menu()
    inMenu = not inMenu
    if inMenu then
        menu_history = {}
        enter_menu(1, 1, true)
    end
    return true
end

hook_chat_command("geo", "- Opens the geoguessr menu", open_menu)

function enter_menu(id, option, back)
    if not back then
        table.insert(menu_history, { menuID, menuOption })
    end

    menuID = id or 1
    menuOption = option or 1

    -- check for valid options
    local menu = menu_data[menuID]
    local totalValid = 0
    local lastValidOption = 0
    for i = 1, #menu do
        if option_valid(menu[i]) then
            totalValid = totalValid + 1
            lastValidOption = i
        elseif menuOption == i then
            if lastValidOption == 0 then
                menuOption = menuOption + 1
            else
                menuOption = lastValidOption
            end
        end
    end

    if totalValid == 0 then
        if #menu_history ~= 0 then
            enter_menu(menu_history[#menu_history][1], menu_history[#menu_history][2], true)
            table.remove(menu_history, #menu_history)
        else
            inMenu = false
        end
        return
    elseif menuID == 1 and totalValid == 1 and (network_is_server() or network_is_moderator()) then
        menuID = 2
        menuOption = 1
    end

    menu = menu_data[menuID]
    for i, button in ipairs(menu) do
        if button.save then
            local value = gGlobalSyncTable[button.save]
            if type(value) == "boolean" then
                button.currNum = (value and 1) or 0
            elseif type(value) == "number" and value % 1 == 0 then
                button.currNum = value
            end
        end
    end
end

function set_menu_option(id, option, value)
    menu_data[id][option].currNum = value
end

function get_menu_option(id, option)
    return menu_data[id][option].currNum
end

function option_valid(button)
    local hideIndex = get_hide_index()
    if button[3] and not (network_is_server() or network_is_moderator()) then
        return false
    elseif button[4] == 1 and (hideIndex == 255 or hideIndex == 0) then
        return false
    elseif button[4] == 2 and (hideIndex == 255 or hideIndex ~= 0 or not gGlobalSyncTable.hiding) then
        return false
    elseif button[4] == 3 and (hideIndex == 255 or hideIndex ~= 0 or gGlobalSyncTable.hiding) then
        return false
    elseif button[4] == 4 and hideIndex == 0 then
        return false
    end
    return true
end

-- compatibility with custom huds
local expectedHudState = true
function toggle_hud(show)
    if hud_is_hidden() == expectedHudState then return end
    if show then
        hud_show()
        expectedHudState = true
    else
        hud_hide()
        expectedHudState = false
    end
end
