
local function prop_hunt_add_category(categoryIndex, categoryName)
    categoryIndex = categoryIndex + CATE_MAX
    if not sFakeObjectInfo[categoryIndex] then
        sFakeObjectInfo[categoryIndex] = {
            models = {},
            modelNames = {},
            miscObjInfo = {},
        }
    end

    table.insert(categoryNames, categoryName)
end

local function prop_hunt_add_prop(categoryIndex, propData)
    categoryIndex = categoryIndex + CATE_MAX  -- Offset categoryIndex to prevent collisions with existing ones

    -- Check if the category exists
    if not sFakeObjectInfo[categoryIndex] then
        print("Category does not exist. Use prop_hunt_add_category to create it first.")
        return
    end

    -- Add the prop's model and model name to the category
    table.insert(sFakeObjectInfo[categoryIndex].models, propData.model)
    table.insert(sFakeObjectInfo[categoryIndex].modelNames, propData.modelName)

    -- Add the prop's misc object information (modelInfo, scale, etc.) to the category's miscObjInfo
    table.insert(sFakeObjectInfo[categoryIndex].miscObjInfo, {
        modelInfo = propData.modelInfo or 0,          -- Model info (optional, defaults to 0)
        scale = propData.scale or {x = 1.0, y = 1.0, z = 1.0}, -- Scale (optional, defaults to {1,1,1})
        animations = propData.animations or nil,      -- Animations (optional, nil if not used)
        maxAnims = propData.maxAnims or nil,          -- Max animations (mandatory if animations are defined)
        loopFunc = propData.loopFunc or nil,          -- Looping function (optional)
        interactions = propData.interactions or nil,  -- Interactions (optional)
        collision = propData.collision or nil,        -- Collision data (optional)
        minYOffset = propData.minYOffset or nil,      -- Minimum Y offset (optional)
        maxYOffset = propData.maxYOffset or nil       -- Maximum Y offset (optional)
    })
end

--* shoutouts to ProfeJavix for the API!

---Returns if a local player index belongs to a hider (0) or a seeker (1)
---@param playerIndex integer
---@return integer | nil
local function is_seeker_or_hidder(playerIndex)
    return gPlayerSyncTable[playerIndex].team
end

---Returns if a round is currently being played or not and its specific state
---@return boolean, integer
local function is_round_running()
    return (gGlobalSyncTable.gameState == GAME_STATE_ACTIVE), gGlobalSyncTable.gameState
end

---Returns if a player is ready or not
---@param playerIndex integer
---@return boolean
local function is_player_ready(playerIndex)
    return gPlayerSyncTable[playerIndex].isReady
end

---Returns the selected round modifiers.
---@return integer
local function get_round_modifiers()
    return gGlobalSyncTable.roundModifiers
end

---Reads the value of the selected field
---@param playerIndex integer
---@param field string
local function get_player_field(playerIndex, field)
    return gPlayerSyncTable[playerIndex][field]
end

---Returns the currently binded button. Allowed values: 'PROP_BUTTON', 'FREEZE_BUTTON', 'FAKE_PROP_BUTTON', 'VERT_UP_BUTTON', 'VERT_DOWN_BUTTON', 'ANIM_LEFT_BUTTON', 'ANIM_RIGHT_BUTTON'. Any other value will return nil.
---@param buttonName string
---@return integer | nil
local function get_button(buttonName)
    if buttonName == 'PROP_BUTTON' then
        return PROP_BUTTON
    elseif buttonName == 'FREEZE_BUTTON' then
        return FREEZE_BUTTON
    elseif buttonName == 'FAKE_PROP_BUTTON' then
        return FAKE_PROP_BUTTON
    elseif buttonName == 'VERT_UP_BUTTON' then
        return VERT_UP_BUTTON
    elseif buttonName == 'VERT_DOWN_BUTTON' then
        return VERT_DOWN_BUTTON
    elseif buttonName == 'ANIM_LEFT_BUTTON' then
        return ANIM_LEFT_BUTTON
    elseif buttonName == 'ANIM_RIGHT_BUTTON' then
        return ANIM_RIGHT_BUTTON
    else
        return nil
    end
end

_G.hnsRebirthExists = true

_G.hnsRebirth = {
    prophunt = {
        add_category = prop_hunt_add_category,
        add_prop = prop_hunt_add_prop
    },
    general = {
        is_seeker_or_hidder = is_seeker_or_hidder,
        is_round_running = is_round_running,
        is_player_ready = is_player_ready,
        get_total_seekers = get_total_seekers_count,
        get_round_modifiers = get_round_modifiers,
        get_player_field = get_player_field,
        get_button = get_button
    }
}

--local MY_NEW_CATEGORY = 0
--
--local myCoolProp = {
--    model = E_MODEL_BLUE_COIN,
--    modelName = "Blue Coin (custom)",
--    modelInfo = 0,
--    scale = {x = 1.0, y = 1.0, z = 1.0},
--    animations = nil,
--    maxAnims = nil,
--    loopFunc = nil,
--    interactions = nil,
--    collision = nil,
--    minYOffset = nil,
--    maxYOffset = nil
--}
--
--if _G.hnsRebirthExists then
--    _G.hnsRebirth.prophunt.add_category(MY_NEW_CATEGORY, "My Cool Category")
--    _G.hnsRebirth.prophunt.add_prop(MY_NEW_CATEGORY, myCoolProp)
--end