-- literally my randomizer mod copy pasted

local obj_get_next_with_same_behavior_id,get_id_from_behavior,collision_find_surface_on_ray,ipairs,find_floor_height,bhv_init_room,cur_obj_set_home_once,
      obj_get_first,obj_get_next,set_background_music,warp_to_level,set_override_skybox,
      nearest_mario_state_to_object,obj_check_hitbox_overlap,spawn_non_sync_object,obj_set_billboard,obj_mark_for_deletion,obj_set_pos,obj_scale,obj_set_angle,
      hook_behavior,obj_get_first_with_behavior_id, hook_event
      =
      obj_get_next_with_same_behavior_id,get_id_from_behavior,collision_find_surface_on_ray,ipairs,find_floor_height,bhv_init_room,cur_obj_set_home_once,
      obj_get_first,obj_get_next,set_background_music,warp_to_level,set_override_skybox,
      nearest_mario_state_to_object,obj_check_hitbox_overlap,spawn_non_sync_object,obj_set_billboard,obj_mark_for_deletion,obj_set_pos,obj_scale,obj_set_angle,
      hook_behavior,obj_get_first_with_behavior_id, hook_event

E_MODEL_TRANS_PIPE = smlua_model_util_get_id("trans_pipe_geo")

function for_each_object_with_behavior(behavior, func_f) --* function by isaac
    local obj = obj_get_first_with_behavior_id(behavior)
    while obj ~= nil do
        func_f(obj)
        obj = obj_get_next_with_same_behavior_id(obj)
    end
end

local config = { --* there HAS to be a better way to do this..
    groundedObjects = {
        [id_bhvWarpPipe] = true,
        [id_bhvRockSolid] = true,
        [id_bhvMrI] = true,
        [id_bhvPiranhaPlant] = true,
        [id_bhvPushableMetalBox] = true,
        [id_bhvBreakableBox] = true,
        [id_bhvCoinFormation] = true,
        [id_bhvFallingPillar] = true,
        [id_bhvPillarBase] = true,
        [id_bhvBobomb] = true,
        [id_bhvGoomba] = true,
        [id_bhvWoodenPost] = true,
        [id_bhvMessagePanel] = true,
        [id_bhvToadMessage] = true,
        [id_bhvWhompKingBoss] = true,
        [id_bhvSmallWhomp] = true,
        [id_bhvThwomp] = true,
        [id_bhvThwomp2] = true,
        [id_bhvTree] = true,
        [id_bhvKickableBoard] = true,
    },
    skipBehaviors = {
        [id_bhvMario] = true,
        [id_bhvDoor] = true,
        [id_bhvUkikiCageStar] = true,
        [id_bhvUkikiCage] = true,
        [id_bhvDddWarp] = true,
        [id_bhvBigBoulderGenerator] = true,
        [id_bhvBigBoulder] = true,
        [id_bhvTreasureChestTop] = true,
        [id_bhvStarDoor] = true,
        [id_bhvDoorWarp] = true,
        [id_bhvAirborneWarp] = true,
        [id_bhvSpinAirborneWarp] = true,
        [id_bhvSnowmansHead] = true,
        [id_bhvSnowmansBodyCheckpoint] = true,
        [id_bhvSnowmansBottom] = true,
        [id_bhvJrbFloatingBox] = true,
        [id_bhvSwingPlatform] = true,
        [id_bhvWarp] = true,
        [id_bhvControllablePlatform] = true,
        [id_bhvPurpleSwitchHiddenBoxes] = true,
        [id_bhvHiddenObject] = true,
        [id_bhvPitBowlingBall] = true,
        [id_bhvBobBowlingBallSpawner] = true,
        [id_bhvThiBowlingBallSpawner] = true,
        [id_bhvTtmBowlingBallSpawner] = true,
        [id_bhvFreeBowlingBall] = true,
        [id_bhvKoopaRaceEndpoint] = true,
        [id_bhvKoopa] = true,
        [id_bhvOpenableCageDoor] = true,
        [id_bhvWaterLevelPillar] = true,
        [id_bhvCannon] = true,
        [id_bhvCannonClosed] = true,
        [id_bhvCannonBarrel] = true,
        [id_bhvCannonBarrelBubbles] = true,
        [id_bhvCannon] = true,
        [id_bhvCannonBarrel] = true,
        [id_bhvDDDPole] = true,
        [id_bhvSeesawPlatform] = true,
        [id_bhvChainChomp] = true,
        [id_bhvChainChompChainPart] = true,
        [id_bhvChainChompGate] = true,
        [id_bhvCheckerboardPlatformSub] = true,
        [id_bhvGiantPole] = true,
        [id_bhvHmcElevatorPlatform] = true,
        [id_bhvAnotherElavator] = true,
        [id_bhvTower] = true,
        [id_bhvTowerPlatformGroup] = true,
        [id_bhvTowerDoor] = true,
        [id_bhvDonutPlatform] = true,
        [id_bhvDonutPlatformSpawner] = true,
        [id_bhvBbhTiltingTrapPlatform] = true,
        [id_bhvPoleGrabbing] = true,
        [id_bhvDddMovingPole] = true,
        [id_bhvBowsersSub] = true,
        [id_bhvBowserBomb] = true,
        [id_bhvBowser] = true,
        [id_bhvCastleFloorTrap] = true,
        [id_bhvCastleFlagWaving] = true,
        [id_bhvFallingBowserPlatform] = true,
        [id_bhvTiltingBowserLavaPlatform] = true,
        [id_bhvWaterBombCannon] = true,
        [id_bhvMerryGoRound] = true,
        [id_bhvMerryGoRoundBigBoo] = true,
        [id_bhvMerryGoRoundBooManager] = true,
        [id_bhvClockHourHand] = true,
        [id_bhvClockMinuteHand] = true,
        [id_bhvDecorativePendulum] = true,
        [id_bhvDddMovingPole] = true,
        [id_bhvPurpleSwitchHiddenBoxes] = true,
        [id_bhvCapSwitchBase] = true,
        [id_bhvCapSwitch] = true,
        [id_bhvHiddenBlueCoin] = true,
        [id_bhvBlueCoinSwitch] = true,
        [id_bhvBigSnowmanWhole] = true,
        [id_bhvFloorSwitchHiddenObjects] = true,
        [id_bhvFloorSwitchHardcodedModel] = true,
        [id_bhvFloorSwitchGrills] = true,
        [id_bhvFloorSwitchAnimatesObject] = true,
        [id_bhvHiddenStaircaseStep] = true,
        [id_bhvFerrisWheelAxle] = true,
        [id_bhvFerrisWheelPlatform] = true,
        [id_bhvPlatformOnTrack] = true,
        [id_bhvTTCRotatingSolid] = true,
        [id_bhvTTC2DRotator] = true,
        [id_bhvTTCCog]       = true,
        [id_bhvTTCElevator]  = true,
        [id_bhvTTCMovingBar] = true,
        [id_bhvTTCPendulum]  = true,
        [id_bhvTTCPitBlock]  = true,
        [id_bhvTTCRotatingSolid] = true,
        [id_bhvHauntedBookshelfManager] = true,
        [id_bhvHauntedBookshelf] = true,
        [id_bhvTTCSpinner]   = true,
        [id_bhvTTCTreadmill] = true,
        [id_bhvLargeBomp] = true,
        [id_bhvSmallBomp] = true,
        [id_bhvWfBreakableWallLeft] = true,
        [id_bhvRacingPenguin] = true,
        [id_bhvWfBreakableWallRight] = true,
        [id_bhvWfRotatingWoodenPlatform] = true,
        [id_bhvRotatingPlatform] = true,
        [id_bhvSlidingPlatform2] = true,
        [id_bhvCoffin] = true,
        [id_bhvCoffinSpawner] = true,
        [id_bhvWfSlidingPlatform] = true,
        [id_bhvWfSlidingTowerPlatform] = true,
        [id_bhvLllSinkingRockBlock] = true,
        [id_bhvLllHexagonalMesh] = true,
        [id_bhvStaticCheckeredPlatform] = true,
        [id_bhvCheckerboardElevatorGroup] = true,
        [id_bhvSmallBomp] = true,
        [id_bhvOctagonalPlatformRotating] = true,
        [id_bhvFloorSwitchAnimatesObject] = true,
        [id_bhvPyramidTop] = true,
        [id_bhvPyramidPillarTouchDetector] = true,
        [id_bhvJetStream] = true,
        [id_bhvJetStreamRingSpawner] = true,
        [id_bhvJetStreamWaterRing] = true,
        [id_bhvPyramidElevator] = true,
        [id_bhvToxBox] = true,
        [id_bhvAnimatesOnFloorSwitchPress] = true,
        [id_bhvTumblingBridgePlatform] = true,
        [id_bhvBbhTumblingBridge] = true,
        [id_bhvFadingWarp] = true,
        [id_bhvSunkenShipPart] = true,
        [id_bhvInSunkenShip2] = true,
        [id_bhvShipPart3] = true,
        [id_bhvInSunkenShip] = true,
        [id_bhvInSunkenShip3] = true,
        [id_bhvSunkenShipPart2] = true,
        [id_bhvSunkenShipSetRotation] = true,
        [id_bhvOpenableGrill] = true,
        [id_bhvUnagi] = true,
        [id_bhvLllBowserPuzzle] = true,
        [id_bhvLllDrawbridge] = true,
        [id_bhvLllDrawbridgeSpawner] = true,
        [id_bhvLllRollingLog] = true,
        [id_bhvLllRotatingHexagonalPlatform] = true,
        [id_bhvLllRotatingHexagonalRing] = true,
        [id_bhvLllRotatingBlockWithFireBars] = true,
        [id_bhvLllSinkingRectangularPlatform] = true,
        [id_bhvLllTiltingInvertedPyramid] = true,
        [id_bhvLllSinkingSquarePlatforms] = true,
        [id_bhvLllMovingOctagonalMeshPlatform] = true,
        [id_bhvLllWoodPiece] = true,
        [id_bhvLllFloatingWoodBridge] = true,
        [id_bhvTtmRollingLog] = true,
        [id_bhvWfSolidTowerPlatform] = true,
        [id_bhvSquarishPathMoving] = true,
        [id_bhvSquarishPathParent] = true,
        [id_bhvWfSlidingTowerPlatform] = true,
        [id_bhvWfElevatorTowerPlatform] = true,
        [id_bhvWdwExpressElevator] = true,
        [id_bhvBitfsSinkingCagePlatform] = true,
        [id_bhvBitfsSinkingPlatforms] = true,
        [id_bhvMeshElevator] = true,
        [id_bhvSquishablePlatform] = true,
        [id_bhvWfTumblingBridge] = true,
        [id_bhvSLWalkingPenguin] = true,
        [id_bhvBulletBill] = true,
        [id_bhvBulletBillCannon] = true,
        [id_bhvSnowMoundSpawn] = true,
        [id_bhvWdwExpressElevatorPlatform] = true,
        [id_bhvStaticObject] = true, --* mostly the extra model geometry found in levels like CCM or WF
    },
}

local invalidSurfaces = {
    [SURFACE_INSTANT_QUICKSAND] = true,
    [SURFACE_INTANGIBLE] = true,
    [SURFACE_DEATH_PLANE] = true,
    [SURFACE_BURNING] = true,
    [SURFACE_VERTICAL_WIND] = true,
    [SURFACE_INSTANT_MOVING_QUICKSAND] = true,
    [SURFACE_INSTANT_WARP_1B] = true,
    [SURFACE_INSTANT_WARP_1C] = true,
    [SURFACE_INSTANT_WARP_1D] = true,
    [SURFACE_INSTANT_WARP_1E] = true,
    [SURFACE_WARP] = true,
}

function shuffleTable(t)
    local keys = {}
    local values = {}

    math.randomseed(gGlobalSyncTable.seed)

    for k, v in pairs(t) do
        table.insert(keys, k)
        table.insert(values, v)
    end

    for i = #values, 2, -1 do
        local j =math.random(1, i)
        values[i], values[j] = values[j], values[i]
    end

    local shuffled = {}
    for i, k in ipairs(keys) do
        shuffled[k] = values[i]
    end

    return shuffled
end

local objectData = {}

local vanillaAvoidancePoints = {
    [LEVEL_CASTLE_GROUNDS] = {
        {area = 1, pointA = {x = 513, y = 803, z = -3668}, pointB = {x = -512, y = 6000, z = -3206}},
    },
    [LEVEL_DDD] = {
        {area = 1, pointA = {x = 3628, y = 1000, z = -401}, pointB = {x = -1771, y = -2756, z = -402}},
        {area = 2, pointA = {x = 3628, y = 1000, z = -401}, pointB = {x = -1771, y = -2756, z = -402}},
    },
}

local StarRoadAvoidancePoints = {
    [LEVEL_BOB] = {
        {area = 1, pointA = {x = 7397, y = -2495, z = -7795}, pointB = {x = -7223, y = -99999, z = 6606}},
    },
}

local avoidancePoints = {
    ["Vanilla"] = vanillaAvoidancePoints,
    ["Star Road"] = StarRoadAvoidancePoints,
}

local function isWithinAvoidancePoint(level, area, position)
    local points = avoidancePoints[currHack][level]
    if not points then return false end

    for _, point in ipairs(points) do
        if point.area == area then
            local pA, pB = point.pointA, point.pointB
            if position.x >= math.min(pA.x, pB.x) and position.x <= math.max(pA.x, pB.x) and
               position.y >= math.min(pA.y, pB.y) and position.y <= math.max(pA.y, pB.y) and
               position.z >= math.min(pA.z, pB.z) and position.z <= math.max(pA.z, pB.z) then
                return true
            end
        end
    end

    return false
end

local function is_surface_valid(surface)
    if surface ~= nil and not invalidSurfaces[surface.type] and (surface.type < SURFACE_PAINTING_WARP_D3 or surface.type < SURFACE_PAINTING_WARP_FC) then
    return true end
end

local function randomize(o)
    --* don't randomize custom behaviors
    if config.skipBehaviors[get_id_from_behavior(o.behavior)] or get_id_from_behavior(o.behavior) >= id_bhv_max_count then return false end

    local originalPos = {x = o.oPosX, y = o.oPosY, z = o.oPosZ}
    objectData[o] = {originalPos = originalPos, randomized = false}

    local numRaycasts = 200
    local validHitPositions = {}
    local level = gNetworkPlayers[0].currLevelNum
    local area = gNetworkPlayers[0].currAreaIndex

    for i = 1, numRaycasts do
        local dirX = math.random(-32768, 32768)
        local dirY = math.random(-32768, 32768)
        local dirZ = math.random(-32768, 32768)

        local ray = collision_find_surface_on_ray(math.random(-8200, 8200), o.oPosY, math.random(-8200, 8200), dirX, dirY, dirZ)

        if is_surface_valid(ray.surface) then
            local normal = ray.surface.normal
            if normal.y > 0.9 then
                local hitPos = ray.hitPos
                local valid = true

                for _, prevHitPos in ipairs(validHitPositions) do
                    local distance = math.sqrt((hitPos.x - prevHitPos.x)^2 + (hitPos.y - prevHitPos.y)^2 + (hitPos.z - prevHitPos.z)^2)
                    if distance <= 500 then
                        valid = false
                        break
                    end
                end

                local distanceToOriginal = math.sqrt((hitPos.x - originalPos.x)^2 + (hitPos.y - originalPos.y)^2 + (hitPos.z - originalPos.z)^2)
                if distanceToOriginal <= 2000 then
                    valid = false
                end

                if isWithinAvoidancePoint(level, area, hitPos) then
                    valid = false
                end

                if valid then
                    table.insert(validHitPositions, hitPos)
                    o.oPosX = hitPos.x
                    o.oPosY = hitPos.y
                    o.oPosZ = hitPos.z
                    objectData[o].randomized = true
                end
            end
        end
    end

    if objectData[o].randomized then
        if config.groundedObjects[get_id_from_behavior(o.behavior)] then
            o.oPosY = find_floor_height(o.oPosX, o.oPosY, o.oPosZ)
        else
            o.oPosY = find_floor_height(o.oPosX, o.oPosY, o.oPosZ) + math.random(0, 800)
        end
        bhv_init_room()
        cur_obj_set_home_once()
    end
end

function delete_random_objects(o, chance)
    chance = clamp(chance, 0, 100)
    if not config.skipBehaviors[get_id_from_behavior(o.behavior)] and
       get_id_from_behavior(o.behavior) < id_bhv_max_count or get_id_from_behavior(o.behavior) == id_bhvCustomSign then

        if math.random(100) <= chance then
            obj_mark_for_deletion(o)
        end
    end
end

function randomize_all_objects()
    for objList = 0, NUM_OBJ_LISTS - 1 do
        local o = obj_get_first(objList)
        while o ~= nil do
            if gGlobalSyncTable.deleteObjs then
                delete_random_objects(o, gGlobalSyncTable.deleteObjectPercentage)
            end
            if gGlobalSyncTable.randomizeObj then
                randomize(o)
            end
            o = obj_get_next(o)
        end
    end
end

local np0 = gNetworkPlayers[0]

local currArea  = 0
local currLevel = 0
local function on_warp()
    if currLevel ~= np0.currLevelNum or currArea ~= np0.currAreaIndex and np0.currAreaSyncValid then
        currArea  = np0.currAreaIndex
        currLevel = np0.currLevelNum
        
        if get_level_player_count(currLevel, 0) == 1 then
            math.randomseed(gGlobalSyncTable.seed)
            randomize_all_objects()
        end
    end
end

local function sync_valid()
    on_warp()
end

local function level_init()
    on_warp()
end

local function break_box_in_water(o)
    local m = nearest_mario_state_to_object(o)
    if m.action == ACT_WATER_PUNCH and obj_check_hitbox_overlap(o, m.marioObj) and o.oAction == 2 then
        o.oExclamationBoxForce = true
        o.oAction = 3
        o.oExclamationBoxForce = false
    end
end

function invis_pipe(o)
    if obj_has_model_extended(o, E_MODEL_NONE) ~= 0 then
        obj_set_model_extended(o, E_MODEL_TRANS_PIPE)
    end
end

local function chest_number_init(o) --* code from the star number
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    obj_set_billboard(o)
end

local function chest_number_loop(o)
    local chest = o.parentObj
    if chest == nil or chest.activeFlags == ACTIVE_FLAG_DEACTIVATED then
        obj_mark_for_deletion(o)
        return
    end


    obj_set_pos(o, chest.header.gfx.pos.x, chest.header.gfx.pos.y + 200.0 * chest.header.gfx.scale.y, chest.header.gfx.pos.z)
    obj_set_angle(o, 0, 0, 0)
    obj_scale(o, 1.0)
    o.oAnimState = chest.oBehParams2ndByte
    o.oBehParams2ndByte = o.oAnimState
    o.header.gfx.node.flags = chest.header.gfx.node.flags
end

local id_bhvChestNumber = hook_behavior(nil, OBJ_LIST_DEFAULT, true, chest_number_init, chest_number_loop, "bhvRandomizerChestNumber")

local function spawn_chest_number(o)
    local chestNumber = obj_get_first_with_behavior_id(id_bhvStarNumber)
    local sanityDepth = 0
    while chestNumber do
        sanityDepth = sanityDepth + 1
        if sanityDepth >= 10000 then break end
        if not chestNumber or chestNumber.parentObj == o then
            break
        end
        chestNumber = obj_get_next_with_same_behavior_id(chestNumber)
    end

    -- If not, spawn a number
    if not chestNumber and o then
        spawn_non_sync_object(id_bhvChestNumber, E_MODEL_NUMBER, o.oPosX, o.oPosY, o.oPosZ, function (cNum)
            chestNumber = cNum
        end)
    end
    if chestNumber and o then
        chestNumber.parentObj = o
        chestNumber.activeFlags = chestNumber.activeFlags | ACTIVE_FLAG_INITIATED_TIME_STOP -- to make sure it's updated even during time stop
    end
end

local function treasure_chest_bottom(o)
    if o.oTimer <= 0 and o.oAction <= 0 then
        randomize(o)
        local floorHeight = find_floor_height(o.oPosX, o.oPosY, o.oPosZ)
        o.oPosY = floorHeight
        spawn_chest_number(o)
    end
end

local function treasure_chest_top(o)
    if o.oTimer <= 0 and o.oAction <= 0 then
        obj_copy_pos_and_angle(o, o.parentObj)
        obj_set_parent_relative_pos(o, 0, 102, -77)
        obj_build_relative_transform(o)
    end
end

local function mario_update(m)
    if m.playerIndex ~= 0 then return end
    if not gGlobalSyncTable.randomizeObj then return end
    for_each_object_with_behavior(id_bhvTreasureChestBottom, treasure_chest_bottom)
    for_each_object_with_behavior(id_bhvTreasureChestTop, treasure_chest_top)
    for_each_object_with_behavior(id_bhvExclamationBox, break_box_in_water)
    for_each_object_with_behavior(id_bhvWarpPipe, invis_pipe)
end

hook_event(HOOK_MARIO_UPDATE, mario_update)
hook_event(HOOK_ON_LEVEL_INIT, level_init)
hook_event(HOOK_ON_WARP, on_warp)
hook_event(HOOK_ON_SYNC_VALID, sync_valid)