#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"

#include "game/level_update.h"

#include "levels/scripts.h"

#include "make_const_nonconst.h"
#include "levels/watermap/header.h"

/* Fast64 begin persistent block [scripts] */
/* Fast64 end persistent block [scripts] */

const LevelScript level_watermap_entry[] = {
	INIT_LEVEL(),
	LOAD_MIO0(0x7, _watermap_segment_7SegmentRomStart, _watermap_segment_7SegmentRomEnd), 
	LOAD_MIO0(0xb, _effect_mio0SegmentRomStart, _effect_mio0SegmentRomEnd), 
	ALLOC_LEVEL_POOL(),
	MARIO(MODEL_MARIO, 0x00000001, bhvMario), 
	JUMP_LINK(script_func_global_1), 
	JUMP_LINK(script_func_global_2), 
	JUMP_LINK(script_func_global_3), 
	JUMP_LINK(script_func_global_4), 
	JUMP_LINK(script_func_global_5),
	JUMP_LINK(script_func_global_7), 
	JUMP_LINK(script_func_global_8),
	JUMP_LINK(script_func_global_11),
	JUMP_LINK(script_func_global_13), 
	JUMP_LINK(script_func_global_14), 
	JUMP_LINK(script_func_global_15), 
	LOAD_MODEL_FROM_GEO(MODEL_METALLIC_BALL, metallic_ball_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_CASTLE_KEY_DOOR, key_door_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_THI_BUBBLY_TREE, bubbly_tree_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_THI_WARP_PIPE, warp_pipe_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_HMC_WOODEN_DOOR, wooden_door_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_HMC_METAL_DOOR, metal_door_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_HMC_HAZY_MAZE_DOOR, hazy_maze_door_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_HMC_METAL_PLATFORM, hmc_geo_0005A0), 
	LOAD_MODEL_FROM_GEO(MODEL_HMC_METAL_ARROW_PLATFORM, hmc_geo_0005B8), 
	LOAD_MODEL_FROM_GEO(MODEL_HMC_ELEVATOR_PLATFORM, hmc_geo_0005D0), 
	LOAD_MODEL_FROM_GEO(MODEL_HMC_ROLLING_ROCK, hmc_geo_000548), 
	LOAD_MODEL_FROM_GEO(MODEL_HMC_ROCK_PIECE, hmc_geo_000570), 
	LOAD_MODEL_FROM_GEO(MODEL_HMC_ROCK_SMALL_PIECE, hmc_geo_000588), 
	LOAD_MODEL_FROM_GEO(MODEL_HMC_RED_GRILLS, hmc_geo_000530), 
	LOAD_MODEL_FROM_GEO(MODEL_BUB, bub_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_TREASURE_CHEST_BASE, treasure_chest_base_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_TREASURE_CHEST_LID, treasure_chest_lid_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_CYAN_FISH, cyan_fish_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_WATER_RING, water_ring_geo),
	LOAD_MODEL_FROM_GEO(MODEL_SEAWEED, seaweed_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_SKEETER, skeeter_geo), 
	/* Fast64 begin persistent block [level commands] */
	/* Fast64 end persistent block [level commands] */

	AREA(1, watermap_area_1),
		WARP_NODE(0x0A, 50, 0x01, 0x0A, WARP_NO_CHECKPOINT),
		WARP_NODE(0x0B, 51, 0x02, 0x0A, WARP_NO_CHECKPOINT),
		WARP_NODE(0x0C, 51, 0x02, 11, WARP_NO_CHECKPOINT),
		WARP_NODE(0x0D, 51, 0x02, 0x0B, WARP_NO_CHECKPOINT),
		OBJECT(MODEL_BLACK_BOBOMB, 3725, 0, 5407, 0, -47, 0, (1 << 24) | (37 << 16), id_bhvCustomSign),
		OBJECT(MODEL_BLACK_BOBOMB, -2724, 28, 8638, 0, -44, 0, (1 << 24) | (20 << 16), id_bhvCustomSign),
		OBJECT(MODEL_BLACK_BOBOMB, 1901, 935, 2468, 0, -47, 0, (1 << 24) | (13 << 16), id_bhvCustomSign),
		OBJECT(MODEL_BLACK_BOBOMB, -2889, 282, 15002, 0, -137, 0, (1 << 24) | (19 << 16), id_bhvCustomSign),
		OBJECT(MODEL_BLACK_BOBOMB, -3370, 282, 15002, 0, -47, 0, (1 << 24) | (19 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_BLUE_FLAME, 589, 471, 117, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, -589, 471, 110, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, 2069, 1437, 2451, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, 4142, 1437, 2451, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, 4322, 574, 3333, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, 1355, 1372, 4411, 0, 135, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, 1128, 1372, 8460, 0, 135, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, 4099, 1372, 8457, 0, 135, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, 1177, 470, 4273, 0, 135, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, -1177, 470, 4273, 0, 135, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, 0, 847, 8979, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, 0, 847, 4984, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, -50, 139, 14480, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, -4251, 248, 14159, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, 381, 139, 12757, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, 376, 139, 10853, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, -5453, 162, 10352, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, -5453, 162, 11454, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, -964, 139, 12476, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_BLUE_FLAME, -5333, 227, 14480, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(E_MODEL_HMC_METAL_DOOR, -863, -116, 3096, 0, 90, 0, 0x00000000, id_bhvDoor),
		OBJECT(E_MODEL_HMC_METAL_DOOR, 863, -116, 3096, 0, 90, 0, 0x00000000, id_bhvDoor),
		OBJECT(E_MODEL_HMC_METAL_DOOR, 0, 0, 4870, 0, -180, 0, 0x00000000, id_bhvDoor),
		OBJECT(E_MODEL_HMC_METAL_DOOR, 0, 0, 9093, 0, -180, 0, 0x00000000, id_bhvDoor),
		OBJECT(E_MODEL_HMC_METAL_DOOR, 1774, -116, 3096, 0, 90, 0, 0x00000000, id_bhvDoor),
		OBJECT(E_MODEL_HMC_METAL_DOOR, -1774, -116, 3096, 0, 90, 0, 0x00000000, id_bhvDoor),
		OBJECT(MODEL_NONE, 771, -1, 6190, 0, 90, 0, (1 << 16), id_bhvOpenableGrill),
		OBJECT(E_MODEL_PURPLE_SWITCH, 3105, 935, 1908, 0, 0, 0, 0x00000000, id_bhvFloorSwitchGrills),
		OBJECT(MODEL_NONE, -1708, -3433, 8528, 0, 56, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_NONE, -4062, -3110, 4278, 0, 133, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_NONE, -5136, -3061, 6410, 0, 156, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_NONE, -5789, -3433, 8319, 0, 4, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_NONE, -3981, -3173, 7865, 0, 88, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_NONE, -2809, -3115, 6388, 0, -161, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_SEAWEED, -3222, -3433, 2499, 0, 107, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_NONE, -5729, -3433, 2428, 0, 117, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_NONE, -5436, -3433, 3827, 0, -134, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_NONE, -5243, -601, 10513, 0, -158, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_NONE, -4988, -601, 10218, 0, -120, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_NONE, -4755, -601, 10405, 0, -48, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_EXCLAMATION_BOX, -3532, 327, 8638, 0, 90, 0, (3 << 16), bhvExclamationBox),
		OBJECT(MODEL_EXCLAMATION_BOX, 2200, 1141, 5303, 0, 90, 0, (6 << 16), bhvExclamationBox),
		OBJECT(MODEL_EXCLAMATION_BOX, 4142, 300, 2636, 0, 90, 0, (6 << 16), bhvExclamationBox),
		OBJECT(E_MODEL_BLUE_FLAME, 0, 471, -621, 0, 90, 0, 0x00000000, id_bhvFlame),
		OBJECT(MODEL_NONE, 0, 0, -579, 0, 90, 0, (0 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, 2200, 935, 6190, 0, 90, 0, (0 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, -3130, 28, 9555, 0, -180, 0, (0 << 16), bhvCoinFormation),
		OBJECT(MODEL_SKEETER, -1357, -58, 3080, 0, 90, 0, (1 << 16), bhvSkeeter),
		OBJECT(MODEL_SKEETER, -1054, -58, 2253, 0, 90, 0, (1 << 16), bhvSkeeter),
		OBJECT(MODEL_SKEETER, -3130, -392, 13759, 0, 90, 0, (1 << 16), bhvSkeeter),
		OBJECT(MODEL_SKEETER, -4698, -392, 11855, 0, 90, 0, (1 << 16), bhvSkeeter),
		OBJECT(MODEL_SKEETER, 3518, -58, 2698, 0, 90, 0, (1 << 16), bhvSkeeter),
		OBJECT(MODEL_SKEETER, 3175, -58, 3457, 0, 90, 0, (1 << 16), bhvSkeeter),
		OBJECT(MODEL_NONE, -3082, 417, 1044, 0, 90, 0, (0 << 16), bhvCoinFormation),
		OBJECT(MODEL_STAR, -4573, 795, 2902, 0, 90, 0, (0 << 16), bhvStar),
		OBJECT(MODEL_NONE, -4573, 495, 2902, 0, 90, 0, (2 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, 0, 300, 6190, 0, 90, 0, (0 << 16), bhvHiddenRedCoinStar),
		OBJECT(MODEL_NONE, -4573, 286, 3529, 0, 90, 0, (50 << 24) | (11 << 16), bhvWarp),
		OBJECT(MODEL_NONE, -4573, -1004, 5843, 0, 90, 0, (50 << 24) | (12 << 16), bhvSwimmingWarp),
		OBJECT(MODEL_NONE, -4573, -655, 5843, 0, 90, 0, (50 << 24) | (13 << 16), bhvWarp),
		OBJECT(MODEL_NONE, -3881, -450, 14159, 0, 90, 0, (2 << 16), bhvCoinFormation),
		OBJECT(MODEL_STAR, -5232, 100, 14119, 0, 90, 0, (0 << 16), bhvStar),
		OBJECT(MODEL_NONE, -4732, -450, 11647, 0, 90, 0, (2 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, -1828, -517, 12256, 0, 90, 0, (2 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, 2354, -187, 11654, 0, 90, 0, (2 << 16), bhvCoinFormation),
		OBJECT(MODEL_SEAWEED, -5586, -3433, 1511, 0, 117, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_SEAWEED, -4652, -3222, 5203, 0, 43, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_SEAWEED, -1998, -3433, 5587, 0, -113, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_SEAWEED, -5050, -3116, 7210, 0, 91, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_SEAWEED, -1224, -3433, 6963, 0, -29, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_SEAWEED, -5016, -601, 10355, 0, 69, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_SEAWEED, -5252, -601, 10243, 0, 0, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_SEAWEED, -4643, -601, 10181, 0, 37, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_SEAWEED, -4559, -601, 10525, 0, 144, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_EXCLAMATION_BOX, 3722, 300, 4981, 0, 90, 0, (1 << 16), bhvExclamationBox),
		OBJECT(MODEL_NONE, 1318, 0, 3572, 0, 68, 180, (0 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, 2170, 0, 5909, 0, 90, 0, (0 << 16), bhvGoombaTripletSpawner),
		OBJECT(MODEL_NONE, 3835, 935, 5876, 0, 90, 0, (0 << 16), bhvGoombaTripletSpawner),
		OBJECT(MODEL_CLAM_SHELL, -4568, -3433, 2142, 0, 59, 0, (0 << 16), bhvClamShell),
		OBJECT(MODEL_SEAWEED, -3188, -601, 12595, 0, 90, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_SEAWEED, -3025, -601, 13135, 0, 90, 0, 0x00000000, id_bhvSeaweed),
		OBJECT(MODEL_NONE, -3472, -601, 12862, 0, 90, 0, 0x00000000, id_bhvSeaweedBundle),
		OBJECT(MODEL_CLAM_SHELL, -3278, -3433, 1532, 0, -170, 0, (0 << 16), bhvClamShell),
		OBJECT(MODEL_CLAM_SHELL, -1225, -3433, 7904, 0, 1, 0, (0 << 16), bhvClamShell),
		OBJECT(MODEL_CLAM_SHELL, -4874, -3433, 8627, 0, -69, 0, (0 << 16), bhvClamShell),
		OBJECT(MODEL_CLAM_SHELL, -5702, -3433, 4446, 0, -80, 0, (0 << 16), bhvClamShell),
		OBJECT(MODEL_BLUE_COIN_SWITCH, -1839, -350, 13393, 0, 90, 0, (0 << 16), bhvBlueCoinSwitch),
		OBJECT(MODEL_BLUE_COIN, -1880, -350, 13122, 0, 90, 0, (0 << 16), bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -1828, -392, 12256, 0, 90, 0, (0 << 16), bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -602, -392, 12256, 0, 90, 0, (0 << 16), bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -602, -308, 11003, 0, 90, 0, (0 << 16), bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -602, -408, 10397, 0, 90, 0, (0 << 16), bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -1, -408, 10201, 0, 90, 0, (0 << 16), bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -1, -323, 10201, 0, 90, 0, (0 << 16), bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -1, -239, 10201, 0, 90, 0, (0 << 16), bhvHiddenBlueCoin),
		OBJECT(MODEL_SKEETER, 456, -392, 13480, 0, 90, 0, (1 << 16), bhvSkeeter),
		OBJECT(MODEL_EXCLAMATION_BOX, -3881, -150, 14159, 0, 90, 0, (1 << 16), bhvExclamationBox),
		OBJECT(MODEL_EXCLAMATION_BOX, -5364, -150, 11454, 0, 90, 0, (1 << 16), bhvExclamationBox),
		OBJECT(MODEL_NONE, -5331, -2456, 7676, 0, 4, 0, 0x00000000, bhvFishGroup),
		OBJECT(MODEL_NONE, -1650, -1361, 8148, 0, 4, 0, 0x00000000, bhvFishGroup),
		OBJECT(MODEL_NONE, -5563, -2816, 1936, 0, 4, 0, 0x00000000, bhvFishSpawner),
		OBJECT(MODEL_NONE, -4557, -1739, 4990, 0, 4, 0, 0x00000000, bhvFishSpawner),
		OBJECT(MODEL_1UP, -1849, 166, 8959, 0, 90, 0, (1 << 16), bhv1Up),
		OBJECT(MODEL_1UP, -4574, 1151, 4104, 0, 90, 0, (1 << 16), bhv1Up),
		OBJECT(MODEL_1UP, 2637, 1586, 8667, 0, 90, 0, (1 << 16), bhv1Up),
		OBJECT(MODEL_NONE, 2637, 935, 7683, 0, 90, 0, (0 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, 2069, 935, 3110, 0, -180, 0, (0 << 16), bhvCoinFormation),
		OBJECT(E_MODEL_BLUE_FLAME, 1544, 935, 8046, 0, 135, 0, 0x00000000, id_bhvFlame),
		OBJECT(MODEL_NONE, -40, -2412, 3096, 0, 90, 0, (2 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, -3976, -2662, 6814, 0, 90, 0, (18 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, 3105, 935, 1543, 0, -90, 0, (0 << 16), bhvCoinFormation),
		OBJECT(MODEL_EXCLAMATION_BOX, 3722, 300, 5198, 0, 90, 0, (2 << 16), bhvExclamationBox),
		OBJECT(MODEL_NONE, 4087, 0, 4072, 0, 90, 0, (117 << 16), bhvPoleGrabbing),
		OBJECT(MODEL_NONE, 1575, 0, 7214, 0, 90, 0, (117 << 16), bhvPoleGrabbing),
		OBJECT(MODEL_BREAKABLE_BOX, -849, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(E_MODEL_PURPLE_SWITCH, -465, 0, 7793, 0, -180, 0, 0x00000000, id_bhvFloorSwitchHiddenObjects),
		OBJECT(MODEL_BREAKABLE_BOX, -1049, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -1249, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -1449, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -1649, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -1849, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -2049, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -2249, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -2449, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -2649, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -2849, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -3049, -216, 7793, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -3049, -216, 7993, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -3049, -216, 8193, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -3049, -216, 8393, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -1849, -216, 8959, 0, 0, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, 2637, 1271, 8667, 0, 0, 0, 0x00000000, id_bhvHiddenObject),
		OBJECT(MODEL_BREAKABLE_BOX, -4239, 495, 4980, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4239, 495, 4780, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4438, 495, 4780, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4239, 695, 4780, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4683, 495, 5699, 0, 103, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4878, 495, 5745, 0, 103, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4833, 495, 5939, 0, 103, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4878, 695, 5745, 0, 88, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4888, 495, 5436, 0, 137, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4949, 495, 5162, 0, 100, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4660, 495, 5262, 0, 78, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4963, 495, 4623, 0, 112, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4988, 495, 4891, 0, 82, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4988, 695, 4891, 0, 91, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4154, 495, 5866, 0, 84, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4203, 495, 6110, 0, 67, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4162, 495, 5625, 0, 96, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -4154, 695, 5866, 0, 89, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 4948, 935, 5590, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 4948, 935, 5390, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 4748, 935, 5390, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 4948, 1135, 5390, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 620, 0, 5204, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 620, 0, 5004, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 420, 0, 5004, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 620, 200, 5004, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 570, 0, 5504, 0, 27, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 343, 0, 5286, 0, -38, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 620, 0, 8208, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 620, 0, 8008, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 620, 200, 8008, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 620, 0, 7543, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 620, 200, 7543, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 420, 0, 8008, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 620, 400, 8008, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 330, 0, 7698, 0, -58, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 357, 0, 8416, 0, -136, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 606, 0, 8558, 0, -98, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 606, 200, 8558, 0, -83, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 2805, -350, 12156, 0, -90, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3005, -350, 12156, 0, -90, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3005, -350, 11956, 0, -90, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3005, -150, 12156, 0, -90, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_METAL_BOX, 4972, 935, 6293, 0, 0, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 4972, 935, 6740, 0, 0, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 4972, 1242, 6740, 0, 0, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 4666, 935, 6740, 0, 0, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 4972, 935, 7123, 0, 0, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 4457, 935, 7216, 0, -40, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 4972, 935, 5986, 0, 0, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 4972, 1242, 5986, 0, 0, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 4586, 935, 5911, 0, -18, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_BREAKABLE_BOX, 4613, 935, 6244, 0, -48, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 4272, 935, 6862, 0, -31, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 4972, 1242, 7123, 0, 11, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3735, 0, 6123, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3735, 0, 5924, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3535, 0, 5924, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3735, 200, 5924, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3735, 0, 6363, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3421, 0, 6294, 0, -32, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3735, 200, 6363, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3735, 400, 6363, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 3239, 0, 6024, 0, -77, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_RED_COIN, -4882, -165, 10749, 0, 90, 0, (2 << 16), bhvRedCoin),
		OBJECT(MODEL_RED_COIN, -1828, -517, 12256, 0, 90, 0, (2 << 16), bhvRedCoin),
		OBJECT(MODEL_RED_COIN, -50, -404, 14259, 0, 90, 0, (2 << 16), bhvRedCoin),
		OBJECT(MODEL_RED_COIN, 4144, 1082, 2636, 0, 90, 0, (2 << 16), bhvRedCoin),
		OBJECT(MODEL_RED_COIN, -40, -2412, 3096, 0, 90, 0, (2 << 16), bhvRedCoin),
		OBJECT(MODEL_RED_COIN, -3976, -2763, 6814, 0, 90, 0, (2 << 16), bhvRedCoin),
		OBJECT(MODEL_RED_COIN, 3674, 213, 7103, 0, 90, 0, (2 << 16), bhvRedCoin),
		OBJECT(MODEL_RED_COIN, 1575, 1217, 7214, 0, 90, 0, (2 << 16), bhvRedCoin),
		OBJECT(MODEL_WOODEN_SIGNPOST, 0, -116, 2167, 0, -180, 0, (11 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 3074, 0, 5664, 0, -90, 0, (15 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 4371, 935, 7814, 0, -90, 0, (16 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 4371, 935, 7946, 0, -90, 0, (17 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 4371, 935, 8079, 0, -90, 0, (18 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, -5606, 596, 894, 0, 0, 0, (23 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, -5410, 596, 894, 0, 0, 0, (22 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 3074, 0, 6623, 0, -90, 0, (14 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 1246, -116, 1954, 0, -135, 0, (12 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 3026, -350, 11084, 0, 0, 0, (12 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, -4938, 495, 6158, 0, 41, 0, (21 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, -251, 0, 9028, 0, -180, 0, (39 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 250, 0, 9028, 0, -180, 0, (40 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 689, 0, 6736, 0, -90, 0, (38 << 16), id_bhvCustomSign),
		TERRAIN(watermap_area_1_collision),
		MACRO_OBJECTS(watermap_area_1_macro_objs),
		SET_BACKGROUND_MUSIC(0x00, SEQ_LEVEL_UNDERGROUND),
		TERRAIN_TYPE(TERRAIN_SAND),
		/* Fast64 begin persistent block [area commands] */
		/* Fast64 end persistent block [area commands] */
	END_AREA(),
	AREA(2, watermap_area_2),
		WARP_NODE(0x0A, 50, 0x01, 0x0A, WARP_NO_CHECKPOINT),
		WARP_NODE(0x0B, 51, 0x01, 12, WARP_NO_CHECKPOINT),
		OBJECT(MODEL_NONE, 0, -439, 2510, 0, 90, 0, (0 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, 0, -402, -2045, 0, 90, 0, (0 << 16), bhvCoinFormation),
		OBJECT(MODEL_METAL_BOX, -407, -531, -952, 0, -4, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, -425, -531, -528, 0, 8, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, -425, -224, -528, 0, -3, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 438, -531, -758, 0, 5, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 434, -531, 545, 0, -7, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 331, -531, 142, 0, 9, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, 434, -224, 545, 0, 6, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_METAL_BOX, -427, -531, 1415, 0, 4, 0, 0x00000000, bhvPushableMetalBox),
		OBJECT(MODEL_BREAKABLE_BOX, -45, -531, 492, 0, -48, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_NONE, 14, 542, -857, 0, 90, 0, (50 << 24) | (10 << 16), bhvAirborneWarp),
		OBJECT(MODEL_NONE, 0, -700, 1444, 0, -180, 0, (50 << 24) | (11 << 16), bhvWarp),
		TERRAIN(watermap_area_2_collision),
		MACRO_OBJECTS(watermap_area_2_macro_objs),
		SET_BACKGROUND_MUSIC(0x00, SEQ_LEVEL_UNDERGROUND),
		TERRAIN_TYPE(TERRAIN_WATER),
		/* Fast64 begin persistent block [area commands] */
		/* Fast64 end persistent block [area commands] */
	END_AREA(),
	FREE_LEVEL_POOL(),
	MARIO_POS(1, 0, 0, 0, 0),
	CALL(0, lvl_init_or_update),
	CALL_LOOP(1, lvl_init_or_update),
	CLEAR_LEVEL(),
	SLEEP_BEFORE_EXIT(1),
	EXIT(),
};