#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"

#include "game/level_update.h"

#include "levels/scripts.h"

#include "make_const_nonconst.h"
#include "levels/icelavamap/header.h"

/* Fast64 begin persistent block [scripts] */
/* Fast64 end persistent block [scripts] */

const LevelScript level_icelavamap_entry[] = {
	INIT_LEVEL(),
	LOAD_MIO0(0x7, _icelavamap_segment_7SegmentRomStart, _icelavamap_segment_7SegmentRomEnd), 
	LOAD_MIO0(0xb, _effect_mio0SegmentRomStart, _effect_mio0SegmentRomEnd), 
	LOAD_MIO0(0xa, _ccm_skybox_mio0SegmentRomStart, _ccm_skybox_mio0SegmentRomEnd), 
	ALLOC_LEVEL_POOL(),
	MARIO(MODEL_MARIO, 0x00000001, bhvMario), 
	/* Fast64 begin persistent block [level commands] */
        JUMP_LINK(script_func_global_1), 
	JUMP_LINK(script_func_global_3), 
	JUMP_LINK(script_func_global_11),
	JUMP_LINK(script_func_global_13), 
	JUMP_LINK(script_func_global_14), 
	JUMP_LINK(script_func_global_15), 
	LOAD_MODEL_FROM_GEO(MODEL_METALLIC_BALL, metallic_ball_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_CASTLE_KEY_DOOR, key_door_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_THI_BUBBLY_TREE, bubbly_tree_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_THI_WARP_PIPE, warp_pipe_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_GIANT_POLE, wf_geo_000AE0), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_ROTATING_PLATFORM, wf_geo_0009B8), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_SMALL_BOMP, wf_geo_000A00), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_LARGE_BOMP, wf_geo_000A40), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_ROTATING_WOODEN_PLATFORM, wf_geo_000A58), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_SLIDING_PLATFORM, wf_geo_000A98), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TUMBLING_BRIDGE_PART, wf_geo_000AB0), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TUMBLING_BRIDGE, wf_geo_000AC8), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TOWER_TRAPEZOID_PLATORM, wf_geo_000AF8), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TOWER_SQUARE_PLATORM, wf_geo_000B10), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TOWER_SQUARE_PLATORM_UNUSED, wf_geo_000B38), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TOWER_SQUARE_PLATORM_ELEVATOR, wf_geo_000B60), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_BREAKABLE_WALL_RIGHT, wf_geo_000B78), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_BREAKABLE_WALL_LEFT, wf_geo_000B90), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_KICKABLE_BOARD, wf_geo_000BA8), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TOWER_DOOR, wf_geo_000BE0), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_KICKABLE_BOARD_FELLED, wf_geo_000BC8), 
	/* Fast64 end persistent block [level commands] */

	AREA(1, icelavamap_area_1),
		WARP_NODE(0x0A, LEVEL_BOB, 0x01, 0x0A, WARP_NO_CHECKPOINT),
		WARP_NODE(0xF0, LEVEL_CASTLE, 0x01, 0x32, WARP_NO_CHECKPOINT),
		WARP_NODE(0xF1, LEVEL_CASTLE, 0x01, 0x64, WARP_NO_CHECKPOINT),
		WARP_NODE(0x01, 52, 0x01, 0x02, WARP_NO_CHECKPOINT),
		WARP_NODE(0x02, 52, 0x01, 0x01, WARP_NO_CHECKPOINT),
		WARP_NODE(0x03, 52, 0x01, 0x04, WARP_NO_CHECKPOINT),
		WARP_NODE(0x04, 52, 0x01, 0x03, WARP_NO_CHECKPOINT),
		OBJECT(MODEL_1UP, -4981, 289, -11255, 0, 90, 0, 0x00000000, bhv1Up),
		OBJECT(MODEL_1UP, 6020, 1368, -2485, 0, 90, 0, 0x00000000, bhv1Up),
		OBJECT(MODEL_1UP, 3752, 848, -10367, 0, 90, 0, 0x00000000, bhv1Up),
		OBJECT(MODEL_1UP, -1116, 1765, -14029, 0, 90, 0, 0x00000000, bhv1Up),
		OBJECT(MODEL_1UP, -3803, 319, 6215, 0, 90, 0, 0x00000000, bhv1Up),
		OBJECT(MODEL_1UP, 3094, 348, 7727, 0, 90, 0, 0x00000000, bhv1Up),
		OBJECT(MODEL_BLUE_COIN_SWITCH, -2884, 553, -12657, 0, 90, 0, 0x00000000, bhvBlueCoinSwitch),
		OBJECT(MODEL_WOODEN_SIGNPOST, -54, 553, -16137, 0, 0, 0, (41 << 16), id_bhvCustomSign),
		OBJECT(MODEL_BREAKABLE_BOX, 5296, 548, -3992, 0, 73, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 5881, 548, -5098, 0, 73, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, 5690, 548, -5157, 0, 73, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -1363, 553, -13162, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -1075, 553, -13162, 0, 0, 0, 0x00000000, bhvBreakableBox),
		OBJECT(MODEL_BREAKABLE_BOX, -1191, 553, -12923, 0, -40, 0, 0x00000000, bhvBreakableBox),
		OBJECT(E_MODEL_LLL_DRAWBRIDGE_PART, -8215, 258, -642, 0, 90, 0, 0x00000000, id_bhvLllDrawbridge),
		OBJECT(E_MODEL_LLL_DRAWBRIDGE_PART, -8215, 258, 638, 0, -90, 0, 0x00000000, id_bhvLllDrawbridge),
		OBJECT(E_MODEL_BULLY, -7234, 310, 5369, 0, 114, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_BULLY, -7234, 310, 5880, 0, -138, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_BULLY, -6723, 310, 5880, 0, -48, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_BULLY, -6723, 310, 5369, 0, 18, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_BULLY, 2545, 495, 1200, 0, 0, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_BULLY, 1512, 495, 1137, 0, 0, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_BULLY, 1870, 495, 2260, 0, 0, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_BULLY_BOSS, 2066, 495, 1629, 0, 0, 0, 0x00000000, id_bhvBigBully),
		OBJECT(E_MODEL_BULLY, -7430, 258, 932, 0, 0, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_BULLY, -7114, 258, 1270, 0, -161, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_BULLY, -6760, 258, 965, 0, -77, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_CHILL_BULLY, 9230, 228, -11876, 0, -65, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_CHILL_BULLY, 8436, 228, -12236, 0, 92, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_CHILL_BULLY, 8681, 228, -11385, 0, -146, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_CHILL_BULLY, 6927, 729, -15148, 0, 0, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_CHILL_BULLY, 5698, 729, -15184, 0, 0, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_CHILL_BULLY, 7069, 729, -14279, 0, 0, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_CHILL_BULLY, 8245, 228, -11736, 0, -127, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(MODEL_YELLOW_COIN, -486, 180, 6793, 0, 0, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_YELLOW_COIN, 2014, 180, 6793, 0, 0, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_YELLOW_COIN, 764, 180, 8043, 0, 90, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_YELLOW_COIN, 764, 180, 5543, 0, 90, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_YELLOW_COIN, -120, 180, 7677, 0, 45, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_YELLOW_COIN, 1648, 180, 5909, 0, 45, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_YELLOW_COIN, 1648, 180, 7677, 0, 135, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_YELLOW_COIN, -120, 180, 5909, 0, 135, 0, 0x00000000, bhvOneCoin),
		OBJECT(E_MODEL_CHILL_BULLY, 2625, 553, -14911, 0, -74, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(E_MODEL_CHILL_BULLY, 2529, 553, -13294, 0, 88, 0, 0x00000000, id_bhvSmallBully),
		OBJECT(MODEL_NONE, -5204, 79, 3539, 0, 90, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, -2853, 79, 3539, 0, 90, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, 3596, 79, 2818, 0, -180, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, 2066, 495, 2373, 0, -90, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, 2066, 495, 885, 0, -90, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, 5476, 1382, -4580, 0, -17, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, -3710, 96, 5544, 0, 72, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_YELLOW_COIN, -1951, 163, 2084, 0, 72, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_YELLOW_COIN, -1545, 89, 2125, 0, 72, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_YELLOW_COIN, -2274, 197, 1850, 0, 72, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_YELLOW_COIN, -2443, 163, 1488, 0, 72, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_YELLOW_COIN, -2401, 88, 1079, 0, 72, 0, 0x00000000, bhvOneCoin),
		OBJECT(MODEL_NONE, 3608, 648, 5459, 0, 148, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, -4358, 330, -1749, 0, -180, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_BLUE_COIN, -1190, 944, -14765, 0, 0, 0, 0x00000000, bhvHiddenBlueCoin),
		OBJECT(MODEL_NONE, -365, 337, -11341, 0, -131, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, 822, 1525, -13384, 0, 0, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, 3992, 575, -14215, 0, 90, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, 7502, 399, -12924, 0, 52, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_BLUE_COIN, 1527, 1207, -13735, 0, 0, 0, 0x00000000, bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -1103, 1433, -13585, 0, 0, 0, 0x00000000, bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -322, 620, -14765, 0, 0, 0, 0x00000000, bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -322, 620, -14123, 0, 0, 0, 0x00000000, bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -322, 620, -13481, 0, 0, 0, 0x00000000, bhvHiddenBlueCoin),
		OBJECT(MODEL_NONE, 7895, 310, -10077, 0, 152, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_BLUE_COIN, -1281, 553, -12196, 0, 0, 0, 0x00000000, bhvHiddenBlueCoin),
		OBJECT(MODEL_BLUE_COIN, -792, 553, -12657, 0, 0, 0, 0x00000000, bhvHiddenBlueCoin),
		OBJECT(MODEL_NONE, 897, 413, 3539, 0, -90, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, 2548, 413, 3539, 0, -90, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, -3023, 162, -8073, 0, -117, 0, 0x00000000, bhvCoinFormation),
		OBJECT(MODEL_NONE, 6496, 580, -728, 0, -90, 0, (1 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, 764, 371, 6793, 0, -90, 0, (1 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, -1122, 114, 3539, 0, 90, 0, (2 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, -6978, 310, 5624, 0, 90, 0, (2 << 16), bhvCoinFormation),
		OBJECT(MODEL_NONE, -4981, 120, -11255, 0, 90, 0, (2 << 16), bhvCoinFormation),
		OBJECT(MODEL_EXCLAMATION_BOX, -1121, 467, 3540, 0, 90, 0, (3 << 16), bhvExclamationBox),
		OBJECT(MODEL_EXCLAMATION_BOX, -6978, 610, 5624, 0, 90, 0, (3 << 16), bhvExclamationBox),
		OBJECT(MODEL_EXCLAMATION_BOX, -6580, 420, -11375, 0, 120, 0, (2 << 16), bhvExclamationBox),
		OBJECT(MODEL_EXCLAMATION_BOX, -4353, 543, -413, 0, 0, 0, (2 << 16), bhvExclamationBox),
		OBJECT(MODEL_EXCLAMATION_BOX, -5005, 505, -6775, 0, 122, 0, (5 << 16), bhvExclamationBox),
		OBJECT(MODEL_EXCLAMATION_BOX, 3853, 420, 0, 0, 0, 0, (1 << 16), bhvExclamationBox),
		OBJECT(MODEL_EXCLAMATION_BOX, -8215, 558, -1115, 0, 180, 0, (6 << 16), bhvExclamationBox),
		OBJECT(MODEL_EXCLAMATION_BOX, -303, 1565, -16573, 0, 0, 0, (5 << 16), bhvExclamationBox),
		OBJECT(MODEL_EXCLAMATION_BOX, 2878, 541, -7364, 0, 156, 0, (5 << 16), bhvExclamationBox),
		OBJECT(MODEL_NONE, -1421, -40, 6026, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -1421, -40, 5440, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -1421, -40, 4853, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -2007, -40, 6026, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -2594, -40, 4853, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -2007, -40, 4853, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -2594, -40, 6026, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -2594, -40, 5440, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -2007, -40, 5440, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -4216, -40, 1729, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -4216, -40, 1143, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -4216, -40, 556, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -4803, -40, 1729, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -5390, -40, 556, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -4803, -40, 556, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -5390, -40, 1729, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -5390, -40, 1143, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -4803, -40, 1143, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -870, 453, -16883, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -870, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -671, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -471, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -271, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, -71, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 129, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 328, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 528, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 728, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 928, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 1128, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 1327, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 1527, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 1727, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 1927, 453, -17083, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 1927, 453, -16883, 0, 90, 0, 0x00000000, bhvHiddenObject),
		OBJECT(MODEL_NONE, 1927, 453, -16683, 0, 90, 0, 0x00000000, bhvHiddenObject),
		MARIO_POS(0x01, 0, 0, 304, 0),
		OBJECT(E_MODEL_METAL_BOX, -5465, 651, -2519, 0, 90, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(E_MODEL_METAL_BOX, -5466, 454, -1136, 0, 90, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(E_MODEL_METAL_BOX, -6849, 258, -1136, 0, 90, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(E_MODEL_METAL_BOX, -6849, 454, -2519, 0, 90, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(E_MODEL_PENGUIN, 2444, -18, -1663, 0, 90, 0, 0x00000000, id_bhvTuxiesMother),
		OBJECT(E_MODEL_PENGUIN, -10, 783, -5575, 0, 0, 0, 0x00000000, id_bhvTuxiesMother),
		OBJECT(E_MODEL_PENGUIN, 7452, 545, -6817, 0, 0, 0, 0x00000000, id_bhvTuxiesMother),
		OBJECT(E_MODEL_PENGUIN, -6226, 120, -8260, 0, 0, 0, 0x00000000, id_bhvTuxiesMother),
		OBJECT(E_MODEL_PENGUIN, 2481, -18, -2440, 0, -97, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, 1644, -18, -1824, 0, 173, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, 1919, -18, -1070, 0, -14, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, 6899, 552, -5984, 0, 20, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, 6378, 574, -6834, 0, 90, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, 6376, 160, -2130, 0, 90, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, -1825, 120, -11166, 0, 90, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, -3438, 120, -11871, 0, 90, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, -1543, 122, -9756, 0, 90, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, -4680, 120, -10434, 0, 90, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, -6940, 120, -10423, 0, 90, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, -6889, 120, -8712, 0, 90, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, 6420, 155, -1705, 0, 173, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, 5707, 567, -5844, 0, 152, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, 2667, -18, -1177, 0, -106, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, 2039, -18, -2326, 0, 80, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, 2944, -18, -1920, 0, -14, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, 1570, 713, -15455, 0, 152, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(E_MODEL_PENGUIN, -1274, 553, -14399, 0, -47, 0, 0x00000000, id_bhvPenguinBaby),
		OBJECT(MODEL_PURPLE_SWITCH, -6216, 258, 1143, 0, 90, 0, 0x00000000, bhvFloorSwitchHiddenObjects),
		OBJECT(MODEL_PURPLE_SWITCH, -1618, 96, 6793, 0, 90, 0, 0x00000000, bhvFloorSwitchHiddenObjects),
		OBJECT(MODEL_PURPLE_SWITCH, -1253, 553, -15905, 0, 90, 0, 0x00000000, bhvFloorSwitchHiddenObjects),
		OBJECT(MODEL_RED_COIN, -1421, 216, 6026, 0, 90, 0, 0x00000000, bhvRedCoin),
		OBJECT(MODEL_RED_COIN, -1421, 216, 4853, 0, 90, 0, 0x00000000, bhvRedCoin),
		OBJECT(MODEL_RED_COIN, -2594, 216, 4853, 0, 90, 0, 0x00000000, bhvRedCoin),
		OBJECT(MODEL_RED_COIN, -2594, 216, 6026, 0, 90, 0, 0x00000000, bhvRedCoin),
		OBJECT(MODEL_RED_COIN, -4216, 216, 1143, 0, 90, 0, 0x00000000, bhvRedCoin),
		OBJECT(MODEL_RED_COIN, -4803, 216, 556, 0, 90, 0, 0x00000000, bhvRedCoin),
		OBJECT(MODEL_RED_COIN, -5390, 216, 1143, 0, 90, 0, 0x00000000, bhvRedCoin),
		OBJECT(MODEL_RED_COIN, -4803, 216, 1729, 0, 90, 0, 0x00000000, bhvRedCoin),
		OBJECT(MODEL_WOODEN_SIGNPOST, -4196, 120, -7993, 0, 111, 0, (28 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 7887, 553, -8835, 0, -28, 0, (31 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 5149, 553, -8596, 0, 43, 0, (32 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 5891, 120, -657, 0, -90, 0, (34 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 387, 114, 1082, 0, -90, 0, (24 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 387, 114, 1257, 0, -90, 0, (25 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 387, 114, 1431, 0, -90, 0, (26 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, -6018, 258, 1417, 0, -90, 0, (27 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 1029, 599, -12294, 0, 0, 0, (30 << 16), id_bhvCustomSign),
		OBJECT(MODEL_WOODEN_SIGNPOST, 5032, 548, -4407, 0, -107, 0, (33 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_LLL_SINKING_RECTANGULAR_PLATFORM, 3596, -40, 2818, 0, 0, 0, 0x00000000, id_bhvLllSinkingRectangularPlatform),
		OBJECT(E_MODEL_LLL_SINKING_RECTANGULAR_PLATFORM, -2853, -40, 3539, 0, 90, 0, 0x00000000, id_bhvLllSinkingRectangularPlatform),
		OBJECT(E_MODEL_LLL_SINKING_RECTANGULAR_PLATFORM, -5204, -40, 3539, 0, 90, 0, 0x00000000, id_bhvLllSinkingRectangularPlatform),
		OBJECT(MODEL_STAR, 1089, 1908, -15356, 0, 90, 0, (0 << 16), bhvStar),
		OBJECT(MODEL_STAR, -7343, 420, -9555, 0, 90, 0, (1 << 16), bhvStar),
		OBJECT(MODEL_NONE, -8215, 558, 1143, 0, 90, 0, (2 << 16), bhvHiddenRedCoinStar),
		OBJECT(E_MODEL_LLL_TILTING_SQUARE_PLATFORM, 0, -214, 4660, 0, 0, 0, 0x00000000, id_bhvLllTiltingInvertedPyramid),
		OBJECT(E_MODEL_LLL_TILTING_SQUARE_PLATFORM, -6978, -214, 2282, 0, 0, 0, 0x00000000, id_bhvLllTiltingInvertedPyramid),
		OBJECT(E_MODEL_SNOW_TREE, -1225, 310, -1298, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -3191, 231, -1190, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -2008, 219, -621, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -2667, 349, -2627, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -1752, 403, -1847, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -933, 432, -2844, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -1139, 524, -4149, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -2029, 560, -4283, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -2862, 397, -3753, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -2942, 473, -5517, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -2087, 535, -5243, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -1406, 542, -5441, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 6183, 568, -6274, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 6339, 553, -9332, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -2281, 122, -9175, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -980, 120, -9157, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -806, 120, -10125, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -2392, 120, -10062, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -1604, 123, -8844, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -147, 118, -9084, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -113, 119, -9870, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 8932, 228, -11811, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 9443, 228, -11468, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 5652, 800, -13855, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 6543, 859, -14467, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 5837, 806, -14712, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 1009, 553, -11036, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 802, 136, -9042, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 8058, 553, -8191, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -5237, 1550, -6056, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -6184, 1551, -6478, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -7726, 1551, -6090, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -7445, 1550, -6946, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -1924, 2992, -13301, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -4311, 2992, -12730, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -3164, 2992, -13716, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -1750, 2992, -15496, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 8782, 3196, -5986, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 9506, 3196, -6805, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 9222, 3196, -8006, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 10453, 3196, -8165, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 12464, 3196, -9289, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 12031, 3196, -8034, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 14180, 3196, -9073, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 7114, 2288, -1631, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 7970, 2288, -1064, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 7031, 2288, -629, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -271, 423, -3826, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(MODEL_NONE, -6157, 2, -1136, 0, 0, 0, (4 << 16), bhvFlamethrower),
		OBJECT(MODEL_NONE, -5466, 2, -1827, 0, 0, 0, (4 << 16), bhvFlamethrower),
		OBJECT(MODEL_NONE, -6157, 2, -2519, 0, 0, 0, (4 << 16), bhvFlamethrower),
		OBJECT(MODEL_NONE, -6849, 2, -1827, 0, 0, 0, (4 << 16), bhvFlamethrower),
		OBJECT(MODEL_NONE, 1723, 2, 3539, 0, 0, 0, (4 << 16), bhvFlamethrower),
		OBJECT(MODEL_NONE, 3708, 2, 1315, 0, 0, 0, (4 << 16), bhvFlamethrower),
		OBJECT(MODEL_NONE, -7543, 2, -1136, 0, 0, 0, 0x00000000, bhvFlamethrower),
		OBJECT(MODEL_NONE, -3803, 2, 6215, 0, 0, 0, (4 << 16), bhvFlamethrower),
		OBJECT(E_MODEL_SNOW_TREE, 3694, 149, -1338, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 4700, 180, -760, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 8793, 228, -12394, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 9302, 228, -12263, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 8972, 228, -11098, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 6219, 553, -8734, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 7979, 553, -7445, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 1645, 729, -13065, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 1609, 643, -16263, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -1227, 553, -15555, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, -3951, 120, -12044, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 3621, 347, -6434, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_SNOW_TREE, 4441, 548, -7489, 0, 90, 0, 0x00000000, id_bhvTree),
		OBJECT(MODEL_NONE, 2961, 148, 7664, 0, -115, 90, (0 << 16), bhvFlamethrower),
		OBJECT(MODEL_NONE, -4475, 149, 4207, 0, 180, 90, (0 << 16), bhvFlamethrower),
		OBJECT(MODEL_NONE, -5204, 149, 4207, 0, 180, 90, (0 << 16), bhvFlamethrower),
		OBJECT(MODEL_NONE, -5934, 149, 4207, 0, 180, 90, (0 << 16), bhvFlamethrower),
		OBJECT(E_MODEL_LLL_ROTATING_HEXAGONAL_RING, 764, -40, 6793, 0, 0, 0, 0x00000000, id_bhvLllRotatingHexagonalRing	),
		OBJECT(MODEL_NONE, 0, 304, 0, 0, 0, 0, (0x0A << 16), bhvSpinAirborneWarp),
		OBJECT(MODEL_HEART, -4475, 347, 4354, 0, 90, 0, 0x00000000, bhvRecoveryHeart),
		OBJECT(MODEL_NONE, 764, 159, 6793, 0, 90, 0, (8 << 24) | (0x02 << 16), bhvWarp),
		OBJECT(MODEL_NONE, 6496, 510, -728, 0, -90, 0, (0x04 << 16), bhvWarp),
		OBJECT(MODEL_NONE, -5892, -205, -9841, 0, 90, 0, (8 << 24) | (0x01 << 16), bhvWarp),
		OBJECT(MODEL_NONE, -1256, 911, -15156, 0, 90, 0, (0x03 << 16), bhvWarp),
		TERRAIN(icelavamap_area_1_collision),
		MACRO_OBJECTS(icelavamap_area_1_macro_objs),
		SET_BACKGROUND_MUSIC(0x00, SEQ_LEVEL_SNOW),
		TERRAIN_TYPE(TERRAIN_SNOW),
		/* Fast64 begin persistent block [area commands] */
		/* Fast64 end persistent block [area commands] */
	END_AREA(),
	FREE_LEVEL_POOL(),
	MARIO_POS(0x01, 0, 0, 304, 0),
	CALL(0, lvl_init_or_update),
	CALL_LOOP(1, lvl_init_or_update),
	CLEAR_LEVEL(),
	SLEEP_BEFORE_EXIT(1),
	EXIT(),
};