#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"

#include "game/level_update.h"

#include "levels/scripts.h"

#include "make_const_nonconst.h"
#include "levels/grassmap/header.h"

/* Fast64 begin persistent block [scripts] */
/* Fast64 end persistent block [scripts] */

const LevelScript level_grassmap_entry[] = {
	INIT_LEVEL(),
	LOAD_MIO0(0x7, _grassmap_segment_7SegmentRomStart, _grassmap_segment_7SegmentRomEnd), 
	LOAD_MIO0(0xa, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd), 
	ALLOC_LEVEL_POOL(),
	MARIO(MODEL_MARIO, 0x00000001, bhvMario), 
	/* Fast64 begin persistent block [level commands] */
	/* Fast64 end persistent block [level commands] */


    JUMP_LINK(script_func_global_1), 
	JUMP_LINK(script_func_global_2), 
	JUMP_LINK(script_func_global_3), 
	JUMP_LINK(script_func_global_4), 
	JUMP_LINK(script_func_global_5), 
	JUMP_LINK(script_func_global_6), 
	JUMP_LINK(script_func_global_7), 
	JUMP_LINK(script_func_global_8), 
	JUMP_LINK(script_func_global_9), 
	JUMP_LINK(script_func_global_11), 
	JUMP_LINK(script_func_global_12), 
	JUMP_LINK(script_func_global_13), 
	JUMP_LINK(script_func_global_14), 
	JUMP_LINK(script_func_global_15), 
	LOAD_MODEL_FROM_GEO(MODEL_METALLIC_BALL, metallic_ball_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_CASTLE_KEY_DOOR, key_door_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_THI_BUBBLY_TREE, bubbly_tree_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_THI_WARP_PIPE, warp_pipe_geo), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_GIANT_POLE, wf_geo_000AE0), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_ROTATING_PLATFORM, wf_geo_0009B8), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_SMALL_BOMP, wf_geo_000A00), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_LARGE_BOMP, wf_geo_000A40), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_ROTATING_WOODEN_PLATFORM, wf_geo_000A58), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_SLIDING_PLATFORM, wf_geo_000A98), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TUMBLING_BRIDGE_PART, wf_geo_000AB0), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TUMBLING_BRIDGE, wf_geo_000AC8), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TOWER_TRAPEZOID_PLATORM, wf_geo_000AF8), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TOWER_SQUARE_PLATORM, wf_geo_000B10), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TOWER_SQUARE_PLATORM_UNUSED, wf_geo_000B38), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TOWER_SQUARE_PLATORM_ELEVATOR, wf_geo_000B60), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_BREAKABLE_WALL_RIGHT, wf_geo_000B78), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_BREAKABLE_WALL_LEFT, wf_geo_000B90), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_KICKABLE_BOARD, wf_geo_000BA8), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_TOWER_DOOR, wf_geo_000BE0), 
	LOAD_MODEL_FROM_GEO(MODEL_WF_KICKABLE_BOARD_FELLED, wf_geo_000BC8), 

	AREA(1, grassmap_area_1),
		WARP_NODE(0x0A, LEVEL_BOB, 0x01, 0x0A, WARP_NO_CHECKPOINT),
		WARP_NODE(12, 50, 0x01, 13, WARP_NO_CHECKPOINT),
		WARP_NODE(13, 50, 0x01, 12, WARP_NO_CHECKPOINT),
		OBJECT(E_MODEL_BOBOMB_BUDDY, -1571, -514, 1339, 0, -180, 0, (1 << 24) | (36 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_BOBOMB_BUDDY, 3710, 604, 6179, 0, 157, 0, (1 << 24) | (29 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_BOBOMB_BUDDY, 105, -7, 2612, 0, 157, 0, (1 << 24) | (5 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_BOBOMB_BUDDY, -680, -514, -602, 0, 157, 0, (1 << 24) | (35 << 16), id_bhvCustomSign),
		OBJECT(MODEL_NONE, -6, -98, -1, 0, 0, 0, (10 << 16), bhvInstantActiveWarp),
		OBJECT(E_MODEL_CHAIN_CHOMP, 5529, 1, -1285, 0, 0, 0, 0x00000000, id_bhvChainChomp),
		OBJECT(E_MODEL_BUBBLY_TREE, 6506, 614, 4799, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 5686, 614, 4111, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 6276, 614, 3324, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 5753, 614, 3315, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 6149, 614, 2576, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 7173, 616, 2142, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 7990, 608, 2486, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 8450, 623, 3513, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 7378, 629, 4678, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 1085, 1, -2080, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 6556, 624, 3790, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 6666, 616, 2309, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_EXCLAMATION_BOX, -4148, 1238, -85, 0, 0, 0, (5 << 16), id_bhvExclamationBox),
		OBJECT(E_MODEL_EXCLAMATION_BOX, 948, 2211, 3136, 0, 0, 0, (5 << 16), id_bhvExclamationBox),
		OBJECT(E_MODEL_BUBBLY_TREE, 8590, 608, 4149, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_EXCLAMATION_BOX, 7046, 1252, 3068, 0, 0, 0, (5 << 16), id_bhvExclamationBox),
		OBJECT(E_MODEL_STAR, 6540, 370, -2222, 0, -137, 0, 0x00000000, id_bhvStar),
		OBJECT(MODEL_WF_GIANT_POLE, -4172, 487, 1551, 0, 177, 0, 0x00000000, bhvGiantPole),
		OBJECT(E_MODEL_BUBBLY_TREE, 6187, 608, 4248, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BREAKABLE_BOX, -3558, 487, 4544, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_BUBBLY_TREE, 5590, -7, 1594, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(MODEL_NONE, -3528, -504, -1162, 0, -90, 0, 0x00000000, id_bhvCoinFormation),
		OBJECT(E_MODEL_BUBBLY_TREE, 6758, 622, 4182, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_STAR, 1776, 2603, 5013, 0, -137, 0, 0x00000000, id_bhvStar),
		OBJECT(MODEL_NONE, -5226, -5, 227, 0, 0, 0, 0x00000000, id_bhvCoinFormation),
		OBJECT(MODEL_NONE, -1034, 195, 1640, 0, 90, 0, 0x00000000, id_bhvCoinFormation),
		OBJECT(MODEL_NONE, 2725, -753, -1, 0, 90, 0, 0x00000000, id_bhvCoinFormation),
		OBJECT(MODEL_NONE, 5529, 1, -1285, 0, 45, 0, (2 << 16), id_bhvCoinFormation),
		OBJECT(MODEL_NONE, -6, -423, -1, 0, 45, 0, (2 << 16), id_bhvCoinFormation),
		OBJECT(MODEL_NONE, -4217, 423, 3504, 0, 45, 0, (2 << 16), id_bhvCoinFormation),
		OBJECT(MODEL_NONE, 1275, 2022, 7223, 0, -90, 0, (13 << 16), bhvFadingWarp),
		OBJECT(E_MODEL_BLUE_COIN, -215, 493, 3033, 0, 45, 0, (2 << 16), id_bhvHiddenBlueCoin),
		OBJECT(E_MODEL_BLUE_COIN, -215, 799, 3622, 0, 45, 0, (2 << 16), id_bhvHiddenBlueCoin),
		OBJECT(E_MODEL_BLUE_COIN, -215, 1105, 4245, 0, 45, 0, (2 << 16), id_bhvHiddenBlueCoin),
		OBJECT(E_MODEL_BLUE_COIN, -215, 1411, 4868, 0, 45, 0, (2 << 16), id_bhvHiddenBlueCoin),
		OBJECT(E_MODEL_BLUE_COIN, -215, 1716, 5490, 0, 45, 0, (2 << 16), id_bhvHiddenBlueCoin),
		OBJECT(E_MODEL_BLUE_COIN, -250, 2022, 6148, 0, 45, 0, (2 << 16), id_bhvHiddenBlueCoin),
		OBJECT(E_MODEL_BLUE_COIN_SWITCH, -865, 493, 2290, 0, 90, 0, (2 << 16), id_bhvBlueCoinSwitch),
		OBJECT(E_MODEL_BUBBLY_TREE, 7155, 614, 5198, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 6551, 614, 5429, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_PURPLE_SWITCH, 8482, 614, 6500, 0, 45, 0, 0x00000000, id_bhvFloorSwitchHiddenObjects),
		OBJECT(E_MODEL_BUBBLY_TREE, 7664, 608, 6572, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 3687, -7, -2401, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(MODEL_WOODEN_POST, 6907, -7, 1575, 0, 0, 0, 0x00000000, bhvWoodenPost),
		OBJECT(E_MODEL_BREAKABLE_BOX, 8800, 408, 6818, 0, 45, 0, 0x00000000, id_bhvHiddenObject),
		OBJECT(MODEL_WOODEN_POST, 6907, -7, 1269, 0, 0, 0, 0x00000000, bhvWoodenPost),
		OBJECT(E_MODEL_BREAKABLE_BOX, 8942, 408, 6960, 0, 45, 0, 0x00000000, id_bhvHiddenObject),
		OBJECT(E_MODEL_BREAKABLE_BOX, 9083, 408, 7101, 0, 45, 0, 0x00000000, id_bhvHiddenObject),
		OBJECT(E_MODEL_BREAKABLE_BOX, 9225, 408, 7242, 0, 45, 0, 0x00000000, id_bhvHiddenObject),
		OBJECT(E_MODEL_BREAKABLE_BOX, 9366, 408, 7384, 0, 45, 0, 0x00000000, id_bhvHiddenObject),
		OBJECT(MODEL_WOODEN_POST, 2107, -7, -2405, 0, 0, 0, 0x00000000, bhvWoodenPost),
		OBJECT(E_MODEL_BREAKABLE_BOX, 9507, 408, 7525, 0, 45, 0, 0x00000000, id_bhvHiddenObject),
		OBJECT(MODEL_WOODEN_POST, 6907, -7, 963, 0, 0, 0, 0x00000000, bhvWoodenPost),
		OBJECT(MODEL_WOODEN_POST, 2107, -7, -1796, 0, 0, 0, 0x00000000, bhvWoodenPost),
		OBJECT(MODEL_WOODEN_POST, 2716, -7, -2405, 0, 0, 0, 0x00000000, bhvWoodenPost),
		OBJECT(MODEL_NONE, 3108, 614, 6799, 0, -90, 0, (4 << 16), id_bhvCoinFormation),
		OBJECT(MODEL_NONE, 444, 614, 6799, 0, 90, 0, (4 << 16), id_bhvCoinFormation),
		OBJECT(MODEL_NONE, 1776, 412, 6807, 0, -90, 0, (182 << 16), id_bhvPoleGrabbing),
		OBJECT(MODEL_WOODEN_POST, 2716, -7, -1796, 0, 0, 0, 0x00000000, bhvWoodenPost),
		OBJECT(MODEL_NONE, -4831, 487, -756, 0, -90, 0, (12 << 16), bhvFadingWarp),
		OBJECT(MODEL_NONE, 4332, 595, 6132, 0, -90, 0, (0 << 16), bhvGoombaTripletSpawner),
		OBJECT(MODEL_GOOMBA, 3212, -7, -1862, 0, -90, 0, (0 << 16), bhvGoomba),
		OBJECT(MODEL_NONE, 1984, -7, 2062, 0, -90, 0, (0 << 16), bhvGoombaTripletSpawner),
		OBJECT(MODEL_GOOMBA, 6031, 608, 3689, 0, -90, 0, (0 << 16), bhvGoomba),
		OBJECT(MODEL_GOOMBA, 8162, 608, 2959, 0, -90, 0, (0 << 16), bhvGoomba),
		OBJECT(MODEL_GOOMBA, 6306, 608, 2206, 0, -90, 0, (0 << 16), bhvGoomba),
		OBJECT(MODEL_GOOMBA, 7883, 608, 6499, 0, -90, 0, (0 << 16), bhvGoomba),
		OBJECT(MODEL_HEART, 2239, 2122, 7223, 0, 0, 0, 0x00000000, bhvRecoveryHeart),
		OBJECT(E_MODEL_BREAKABLE_BOX, 351, 1574, 3137, 0, 90, 0, 0x00000000, id_bhvHiddenObject),
		OBJECT(MODEL_1UP, 1776, 1609, 6607, 0, -137, 0, 0x00000000, bhv1Up),
		OBJECT(MODEL_NONE, 2489, 122, 2804, 0, -180, 0, (3 << 16), id_bhvCoinFormation),
		OBJECT(MODEL_NONE, 2725, -753, -1, 0, -90, 0, (0 << 16), id_bhvGoombaTripletSpawner),
		OBJECT(MODEL_NONE, 2412, 271, -2101, 0, -137, 0, 0x00000000, id_bhvHiddenRedCoinStar),
		OBJECT(E_MODEL_METAL_BOX, 3093, 2329, 4989, 0, 90, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(E_MODEL_METAL_BOX, 2787, 2022, 5296, 0, 90, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(E_MODEL_BREAKABLE_BOX, 94, -7, 1982, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_BREAKABLE_BOX, 94, 193, 1781, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_BREAKABLE_BOX, 481, -7, 1681, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_BREAKABLE_BOX, 481, -7, 2623, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_METAL_BOX, 2804, 2022, 4341, 0, 71, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(E_MODEL_BREAKABLE_BOX, -4846, -514, 50, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_BREAKABLE_BOX, -4646, -514, -308, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_BREAKABLE_BOX, -4846, -315, -308, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_METAL_BOX, 3224, 2022, 5892, 0, 75, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(E_MODEL_BREAKABLE_BOX, -1251, 429, 5381, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(MODEL_WF_ROTATING_PLATFORM, -1636, 487, 8871, 0, -90, 0, (8 << 24), id_bhvRotatingPlatform),
		OBJECT(E_MODEL_METAL_BOX, 674, 2022, 4232, 0, 52, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(MODEL_GOOMBA, 1804, -7, -2151, 0, -90, 0, (0 << 16), bhvGoomba),
		OBJECT(MODEL_GOOMBA, 2440, -7, -2098, 0, -90, 0, (0 << 16), bhvGoomba),
		OBJECT(MODEL_WF_ROTATING_PLATFORM, -1045, 487, 7627, 0, -90, 0, (8 << 24), id_bhvRotatingPlatform),
		OBJECT(MODEL_WF_ROTATING_PLATFORM, -2848, 487, 8236, 0, -90, 0, (8 << 24), id_bhvRotatingPlatform),
		OBJECT(MODEL_WF_ROTATING_PLATFORM, -1636, 487, 10294, 0, -90, 0, (8 << 24), id_bhvRotatingPlatform),
		OBJECT(E_MODEL_BUBBLY_TREE, 4079, -7, 1028, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 3863, -7, 2498, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 4955, 608, 6402, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, 8559, 608, 5692, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(MODEL_NONE, -1636, 520, 10294, 0, 45, 0, (18 << 16), id_bhvCoinFormation),
		OBJECT(E_MODEL_BUBBLY_TREE, -5637, 487, 8570, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, -3924, 487, 8570, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(E_MODEL_BUBBLY_TREE, -1636, 487, 8871, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(MODEL_NONE, -4172, 487, 1551, 0, 45, 0, (18 << 16), id_bhvCoinFormation),
		OBJECT(MODEL_NONE, 3324, -7, -1236, 0, 49, 0, 0x00000000, id_bhvCoinFormation),
		OBJECT(MODEL_NONE, 3324, -7, 1237, 0, -49, -180, 0x00000000, id_bhvCoinFormation),
		OBJECT(MODEL_NONE, -2848, 520, 8236, 0, 45, 0, (18 << 16), id_bhvCoinFormation),
		OBJECT(E_MODEL_BREAKABLE_BOX, -3556, 487, 5151, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_METAL_BOX, -3283, 794, 664, 0, 24, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(E_MODEL_BREAKABLE_BOX, -3556, 487, 5759, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_BREAKABLE_BOX, -3556, 687, 5350, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_BREAKABLE_BOX, -2975, 487, 5758, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_METAL_BOX, 2927, 2329, 5812, 0, 75, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(MODEL_BOWLING_BALL, -5090, 487, 6157, 0, 45, 0, (0 << 16), bhvFireSpitter),
		OBJECT(MODEL_BOWLING_BALL, -5090, 487, 7330, 0, 45, 0, (0 << 16), bhvFireSpitter),
		OBJECT(MODEL_BOWLING_BALL, -3989, 487, 7330, 0, 45, 0, (0 << 16), bhvFireSpitter),
		OBJECT(MODEL_BOWLING_BALL, -3989, 487, 6157, 0, 45, 0, (0 << 16), bhvFireSpitter),
		OBJECT(MODEL_WOODEN_POST, 6907, -7, 657, 0, 0, 0, 0x00000000, bhvWoodenPost),
		OBJECT(MODEL_HEART, -2950, 566, 5152, 0, 0, 0, 0x00000000, bhvRecoveryHeart),
		OBJECT(E_MODEL_BREAKABLE_BOX, 1776, 1574, 3137, 0, 90, 0, 0x00000000, id_bhvHiddenObject),
		OBJECT(MODEL_WF_TUMBLING_BRIDGE, -5781, 423, 5923, 0, 0, 0, 0x00000000, id_bhvWfTumblingBridge	),
		OBJECT(E_MODEL_PURPLE_SWITCH, 2489, 1919, 3137, 0, 90, 0, 0x00000000, id_bhvFloorSwitchHiddenObjects),
		OBJECT(E_MODEL_BREAKABLE_BOX, -2342, 487, 4544, 0, 0, 0, 0x00000000, id_bhvBreakableBox),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, -2697, 487, 4772, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BUBBLY_TREE, 4157, 608, 6608, 0, 0, 0, 0x00000000, id_bhvTree),
		OBJECT(MODEL_1UP, 3202, 1819, 3137, 0, -137, 0, 0x00000000, bhv1Up),
		OBJECT(E_MODEL_BREAKABLE_BOX, 3202, 1574, 3137, 0, 90, 0, 0x00000000, id_bhvHiddenObject),
		OBJECT(E_MODEL_BREAKABLE_BOX, 1776, 1310, 6607, 0, 90, 0, 0x00000000, id_bhvHiddenObject),
		OBJECT(E_MODEL_METAL_BOX, -2941, 487, 51, 0, -39, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(E_MODEL_METAL_BOX, -2385, 487, -625, 0, 1, 0, 0x00000000, id_bhvPushableMetalBox),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, -3601, 473, 5498, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, -3259, 687, 5759, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, -2517, 487, 4514, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, 2894, 608, 5829, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, 1467, 608, 5367, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, 1470, 808, 5170, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, 1458, 895, 5786, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, 307, -7, 2237, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, 79, 235, 2176, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, 579, -7, 2385, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, 683, -7, 1618, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, -4865, -514, 361, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, -4235, -514, 555, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(E_MODEL_BREAKABLE_BOX_SMALL, -4475, -514, -338, 0, 0, 0, 0x00000000, id_bhvBreakableBoxSmall),
		OBJECT(MODEL_1UP, -5737, 825, 5923, 0, -137, 0, 0x00000000, bhv1Up),
		OBJECT(MODEL_NONE, -4696, 487, 8204, 0, -90, 0, (0 << 16), id_bhvGoombaTripletSpawner),
		OBJECT(MODEL_NONE, -4540, 294, 5150, 0, -180, 0, 0x00000000, id_bhvCoinFormation),
		OBJECT(MODEL_NONE, -4540, -514, 2379, 0, -180, 0, 0x00000000, id_bhvCoinFormation),
		OBJECT(E_MODEL_EXCLAMATION_BOX, -1867, 187, 1685, 0, 0, 0, (5 << 16), id_bhvExclamationBox),
		OBJECT(MODEL_WOODEN_POST, 1013, -514, 1289, 0, 0, 0, 0x00000000, bhvWoodenPost),
		OBJECT(MODEL_WOODEN_POST, 245, -514, 1289, 0, 0, 0, 0x00000000, bhvWoodenPost),
		OBJECT(E_MODEL_EXCLAMATION_BOX, -4217, 723, 3504, 0, 0, 0, (5 << 16), id_bhvExclamationBox),
		OBJECT(MODEL_WOODEN_POST, 1782, -514, 1289, 0, 0, 0, 0x00000000, bhvWoodenPost),
		OBJECT(MODEL_BLACK_BOBOMB, -2936, 487, 1499, 0, 129, 0, 0x00000000, bhvBobomb),
		OBJECT(MODEL_BLACK_BOBOMB, -3131, 487, 2278, 0, -111, 0, 0x00000000, bhvBobomb),
		OBJECT(MODEL_BLACK_BOBOMB, -3552, 487, 1781, 0, 154, 0, 0x00000000, bhvBobomb),
		OBJECT(MODEL_BLACK_BOBOMB, -4345, 487, 812, 0, -109, 0, 0x00000000, bhvBobomb),
		MARIO_POS(0x01, 0, -6, -98, -1),
		OBJECT(E_MODEL_WOODEN_SIGNPOST, 4889, -7, 132, 0, -47, 0, (9 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_WOODEN_SIGNPOST, 1303, 1919, 2973, 0, 0, 0, (7 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_WOODEN_SIGNPOST, -2025, -504, -711, 0, 90, 0, (1 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_WOODEN_SIGNPOST, -2138, 493, 1778, 0, -90, 0, (2 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_WOODEN_SIGNPOST, 1246, 1, 2804, 0, -180, 0, (3 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_WOODEN_SIGNPOST, 881, 1, 2804, 0, -180, 0, (4 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_WOODEN_SIGNPOST, 1142, 1919, 2973, 0, 0, 0, (6 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_WOODEN_SIGNPOST, -3997, 487, 7613, 0, 0, 0, (8 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_WOODEN_SIGNPOST, -2283, 487, 5726, 0, -90, 0, (10 << 16), id_bhvCustomSign),
		OBJECT(E_MODEL_RED_COIN, 1776, 608, 6179, 0, 45, 0, (2 << 16), id_bhvRedCoin),
		OBJECT(E_MODEL_RED_COIN, 9507, 738, 7525, 0, 45, 0, (2 << 16), id_bhvRedCoin),
		OBJECT(E_MODEL_RED_COIN, 5529, 262, -1285, 0, 45, 0, (2 << 16), id_bhvRedCoin),
		OBJECT(E_MODEL_RED_COIN, 1085, 817, -2080, 0, 45, 0, (2 << 16), id_bhvRedCoin),
		OBJECT(E_MODEL_RED_COIN, -1636, 743, 10294, 0, 45, 0, (2 << 16), id_bhvRedCoin),
		OBJECT(E_MODEL_RED_COIN, -1251, 429, 5381, 0, 45, 0, (2 << 16), id_bhvRedCoin),
		OBJECT(E_MODEL_RED_COIN, 2489, 333, 2804, 0, 45, 0, (2 << 16), id_bhvRedCoin),
		OBJECT(E_MODEL_RED_COIN, -4540, 569, 6707, 0, 45, 0, (2 << 16), id_bhvRedCoin),
		TERRAIN(grassmap_area_1_collision),
		MACRO_OBJECTS(grassmap_area_1_macro_objs),
		SET_BACKGROUND_MUSIC(0x00, SEQ_LEVEL_GRASS),
		TERRAIN_TYPE(TERRAIN_GRASS),
		/* Fast64 begin persistent block [area commands] */
		/* Fast64 end persistent block [area commands] */
	END_AREA(),
	FREE_LEVEL_POOL(),
	MARIO_POS(0x01, 0, -6, -98, -1),
	CALL(0, lvl_init_or_update),
	CALL_LOOP(1, lvl_init_or_update),
	CLEAR_LEVEL(),
	SLEEP_BEFORE_EXIT(1),
	EXIT(),
};