
--* reused code from one of my mods that recreated SMB3/SMB1 on the hud, don't mind leftovers.

ANIM_FIRE = 0
SCALE = 1

local showBoard = false

local animationTable = {
    [ANIM_FIRE]      = {spritePos = {x = 0  , y = 0 , width = 32 , height = 32}, sprite = "fireSpriteSheet" , framerate = 30, spaceBetweenAnims = 32, frameStart = 0, frameEnd = 8},
}

local currAnim = ANIM_FIRE

local TEXT_TIMER_BG = get_texture_info("timer")

local function get_fire_color(m)
    local nearestMario = nearest_team_to_object(TEAM_HIDERS, m.marioObj)
    local r, g, b = 0,0,0
    if nearestMario then
        local distance = dist_between_objects(m.marioObj, nearestMario.marioObj) * 0.03
        --* go between blue and red based on distance
        r = clamp(255 - distance, 0, 255)

        --* same math as for blue but clamped at 100
        --* so it doesn't look dark blue
        g = clamp(0 + distance, 0, 100)
        b = clamp(0 + distance, 0, 255)
    end
    return r, g, b
end

local frameTimer = 0
local frameDelay = 0.1 --* general animation speed
local currentFrame = 0

function render_fire_animation()
    local currAnimInfo = animationTable[currAnim]
    -- Check if the animation is static
    if currAnimInfo.frameStart ~= 0 or currAnimInfo.frameEnd ~= 0 then
        -- Update frame timer
        frameTimer = frameTimer + 1 / currAnimInfo.framerate

        if frameTimer >= frameDelay then
            currentFrame = (currentFrame + 1) % (currAnimInfo.frameEnd - currAnimInfo.frameStart)
            frameTimer = 0
        end
    end
    -- Calculate fire color based on Mario's distance to the target
    local r, g, b = get_fire_color(gMarioStates[0])

    djui_hud_set_color(r, g, b, 255) -- texture itself is already transparent (ripped vanilla fire texture)

    djui_hud_render_texture_tile(get_texture_info(currAnimInfo.sprite), 0, djui_hud_get_screen_height() - (64 * SCALE), 1.5 * SCALE, 1.5 * SCALE,
                                 currAnimInfo.spritePos.x + currentFrame * currAnimInfo.spaceBetweenAnims, currAnimInfo.spritePos.y,
                                 currAnimInfo.spritePos.width, currAnimInfo.spritePos.height)
end

function render_round_timer(sHeight, sWidth)
    djui_hud_set_font(FONT_TINY)

    if gGlobalSyncTable.roundModifiers & MODIFIER_TIMED_ROUND ~= 0 then
        local timerBgPosX = (sWidth * 0.5) - 32
        local timerBgPosY = sHeight - 32

        local remainingTime = gGlobalSyncTable.roundTimerMax - gGlobalSyncTable.roundTimer

        local underOneMinute = remainingTime <= 60 * 30

        local redIntensity, greenIntensity, blueIntensity

        if underOneMinute then
            local fadeProgress = math.sin(get_global_timer() / 15)
            redIntensity = clamp((fadeProgress + 1) * 255, 0, 255)
            greenIntensity = clamp((1 - fadeProgress) * 255, 0, 255)
            blueIntensity = clamp((1 - fadeProgress) * 255, 0, 255)
        else
            redIntensity = 255
            greenIntensity = 255
            blueIntensity = 255
        end

        local currentTime = math.ceil(remainingTime / 30)
        local formattedTime = string.format("%02d:%02d:%02d", math.floor(currentTime / 3600), math.floor((currentTime % 3600) / 60), currentTime % 60)
        local formattedTimeLength = djui_hud_measure_text(formattedTime)

        djui_hud_set_color(255, 255, 255, 150)
        djui_hud_render_texture(TEXT_TIMER_BG, timerBgPosX, timerBgPosY, 1.25, 1)
        djui_hud_set_color(0, 0, 0, 50)
        djui_hud_print_text(formattedTime, timerBgPosX + (65 - formattedTimeLength), timerBgPosY + 9, 1)
        djui_hud_set_color(redIntensity, greenIntensity, blueIntensity, 255)
        djui_hud_print_text(formattedTime, timerBgPosX + (64 - formattedTimeLength), timerBgPosY + 8, 1)
    end
end

function render_win_text(sHeight, sWidth)
    djui_hud_set_font(FONT_TINY)
    if gGlobalSyncTable.winTextTimer > 0 then
        local text = gGlobalSyncTable.winText
        local textWidth = djui_hud_measure_text(text)

        local gameEndTextWidth = textWidth * 1.25
        local gameEndTextHeight = 25
        local gameEndTextX = (sWidth - textWidth) * 0.5
        local gameEndTextY = (sHeight - gameEndTextHeight) * 0.5

        djui_hud_set_color(100, 100, 255, 100)
        djui_hud_render_rect(gameEndTextX, gameEndTextY, gameEndTextWidth, gameEndTextHeight)
        djui_hud_set_color(0, 0, 0, 150)
        djui_hud_print_text(text, gameEndTextX + 1 + (gameEndTextWidth * 0.1), gameEndTextY + 6, 1)
        djui_hud_set_color(255, 255, 255, 255)
        djui_hud_print_text(text, gameEndTextX + (gameEndTextWidth * 0.1), gameEndTextY + 5, 1)
    end
end

local function render_tip(sWidth, sHeight)
    if gGlobalSyncTable.hiderHeadStartTimer < gGlobalSyncTable.hiderHeadStartTimerMax and gGlobalSyncTable.gameState == GAME_STATE_ACTIVE and tip then
        local tipWidth = djui_hud_measure_text(tip)
        local tipY = sHeight - 60
        local tipX = (sWidth - tipWidth) * 0.5
        djui_hud_set_color(0, 0, 15, 100)
        djui_hud_print_text(tip, tipX + 1.25, tipY + 1.25, 1)
        djui_hud_set_color(255, 255, 255, 255)
        djui_hud_print_text(tip, tipX, tipY, 1)
        djui_hud_set_font(FONT_TINY)
    end
end

local function waiting_for_players_text(sWidth, sHeight)
    local numPlayers = get_player_count()

    djui_hud_set_font(FONT_TINY)

    if numPlayers <= 1 then
        text = "Waiting for players.."
    elseif gGlobalSyncTable.autoRestart then
        text = "Starting in "..math.ceil((300 - gGlobalSyncTable.gameStartTimer) / 30)
    else
        text = "Waiting for host.. [/start]"
    end

    local textWidth = djui_hud_measure_text(text)
    textX = (sWidth - textWidth) * 0.5
    textY = 0

    djui_hud_set_color(0,0,0,160)
    djui_hud_print_text(text, textX + 1, textY + 1, 1)
    djui_hud_set_color(255,255,255,255)
    djui_hud_print_text(text, textX, textY, 1)
end

local function can_leave_text(sWidth, sHeight)
    djui_hud_set_font(FONT_HUD)
    local canLeaveTime = math.ceil((gGlobalSyncTable.pauseExitTimerMax - pauseExitTimer) / 30)
    local canLeaveText = "CAN LEAVE IN "..canLeaveTime
    local canLeaveTextWidth = djui_hud_measure_text(canLeaveText)
    local canLeaveTextX = (sWidth - canLeaveTextWidth) * 0.5
    local canLeaveTextY = (sHeight * 0.10)

    if canLeaveTime <= 0 then
        canLeaveText = "CAN EXIT COURSE"
    end
    if is_game_paused() and gNetworkPlayers[0].currCourseNum ~= COURSE_NONE then
        djui_hud_print_text(canLeaveText, canLeaveTextX, canLeaveTextY, 1)
        djui_hud_set_font(FONT_TINY)
    end
end

local function render_remaining_players(sWidth, sHeight)
    local players = {}
    for i = 0, MAX_PLAYERS - 1 do
        if npl[i].connected then
            table.insert(players, npl[i])
        end
    end

    djui_hud_set_font(FONT_RECOLOR_HUD)
    local teamStr = roleToString[ps[0].team].text:upper()
    local teamWidth = djui_hud_measure_text(teamStr)
    local teamX = (sWidth - teamWidth) * 0.5
    local teamY = 8

    djui_hud_set_color(roleToString[ps[0].team].color.r, roleToString[ps[0].team].color.g, roleToString[ps[0].team].color.b, 255)
    djui_hud_print_text(teamStr, teamX, teamY, 1)

    djui_hud_set_font(FONT_ALIASED)
    djui_hud_set_color(255, 255, 255, 255)
    local headerStr = "Players:"
    local headerWidth = djui_hud_measure_text(headerStr)

    local listX = sWidth - 10
    local listY = teamY + 20
    local scale = 0.75
    local lineHeight = 10 * scale
    local panelPadding = 4
    local panelWidth = math.max(headerWidth, 0)

    for i, npi in ipairs(players) do
        local name = name_without_hex(npi.name or "ERROR")
        panelWidth = math.max(panelWidth, djui_hud_measure_text(name) * scale)
    end
    panelWidth = panelWidth + panelPadding * 2
    local panelHeight = ((1 + #players) * lineHeight + panelPadding * 2) + 12

    listX = listX - panelWidth

    djui_hud_set_color(0, 0, 0, 150)
    djui_hud_render_rect(listX - panelPadding, listY - panelPadding, panelWidth + panelPadding * 2, panelHeight + panelPadding * 2)

    djui_hud_set_font(FONT_ALIASED)
    djui_hud_set_color(255, 255, 255, 255)
    djui_hud_print_text(headerStr, listX, listY, scale)

    djui_hud_set_font(FONT_TINY)
    for i, npi in ipairs(players) do
        local text = name_without_hex(npi.name or "ERROR")
        local textY = (listY + (lineHeight * i)) + 12
        local col = roleToString[ps[npi.localIndex].team].color

        djui_hud_set_color(0, 0, 0, 255)
        djui_hud_print_text(text, listX + 1, textY + 1, scale)

        djui_hud_set_color(col.r, col.g, col.b, 255)
        djui_hud_print_text(text, listX, textY, scale)
    end
end

local function hud_render()
    djui_hud_set_resolution(RESOLUTION_N64)
    djui_hud_set_font(FONT_TINY)

    local sHeight = djui_hud_get_screen_height()
    local sWidth = djui_hud_get_screen_width()

    hud_hide()

    djui_hud_set_font(FONT_HUD)
    hud_render_power_meter(gMarioStates[0].health, 0, 0, 64, 64)
    djui_hud_print_text("$@" .. gMarioStates[0].numCoins, 12, 54, 1)
    djui_hud_print_text("*@" .. gMarioStates[0].numStars, 12, 70, 1)

    if debug then
        djui_hud_print_text(" LEVEL ID ".. gNetworkPlayers[0].currLevelNum, 0, 90, 1)
        djui_hud_set_font(FONT_CUSTOM_HUD)
        djui_hud_print_text("[DEBUG]", sWidth - djui_hud_measure_text("[DEBUG]") - 15, sHeight - 45, 1)
        djui_hud_set_font(FONT_HUD)
    end

    djui_hud_set_font(FONT_TINY)

    local playerTeam = ps[0].team
    if playerTeam == TEAM_SEEKERS then
        if hurryUp and gGlobalSyncTable.gameState == GAME_STATE_ACTIVE then
            render_fire_animation()
        end
        render_tip(sWidth, sHeight)
        local bombText = "BOMB READY IN "..math.floor((gGlobalSyncTable.bombCooldownMax - bombCooldown) / 30)
        if bombCooldown >= gGlobalSyncTable.bombCooldownMax then
            bombText = "BOMB READY! [L]"
        end
        djui_hud_set_color(255, 255, 255, 255)
        djui_hud_set_font(FONT_CUSTOM_HUD)
        djui_hud_print_text(bombText, 20, sHeight - 16, 0.5)
        djui_hud_set_font(FONT_TINY)
    elseif playerTeam == TEAM_HIDERS then
        can_leave_text(sWidth, sHeight)
        --render_anti_camp()
    end

    local gameState = gGlobalSyncTable.gameState
    if gameState == GAME_STATE_INACTIVE then
        waiting_for_players_text(sWidth, sHeight)
    elseif gameState == GAME_STATE_ACTIVE then
        local headStartTimer = gGlobalSyncTable.hiderHeadStartTimer
        local headStartTimerMax = gGlobalSyncTable.hiderHeadStartTimerMax
        local timeLeft = headStartTimerMax - headStartTimer
        
        if timeLeft > 0 then

            djui_hud_set_font(FONT_HUD)
            local startingText = "STARTING IN " .. math.ceil(timeLeft / 30)
            local startingTextWidth = djui_hud_measure_text(startingText)
            local startingTextX = (sWidth - startingTextWidth) * 0.5
            local startingTextY = sHeight - 60
            djui_hud_print_text(startingText, startingTextX, startingTextY + 25, 1)
            djui_hud_set_font(FONT_TINY)
        else
            render_round_timer(sHeight, sWidth)
        end

        render_remaining_players(sWidth, sHeight)
    end

    render_win_text(sHeight, sWidth)

    if ps[0].skeltanJumpscareTimer > 0 then
        
        if ps[0].skeltanJumpscareTimer == 1 then
            audio_sample_play(AUDIO_SAMPLE_SKELTAN_JUMPSCARE, gMarioStates[0].pos, 3)
        end
        
        ps[0].skeltanJumpscareTimer = ps[0].skeltanJumpscareTimer + 1

        local skeltanTexture = get_texture_info("skeltan")

        local alpha = clamp(255 * (1 - (ps[0].skeltanJumpscareTimer / SKELTAN_JUMPSCARE_TIMER_MAX)), 0, 255)

        djui_hud_set_color(255, 255, 255, alpha)

        djui_hud_render_texture(skeltanTexture, 0, 0, sWidth / skeltanTexture.width, sHeight / skeltanTexture.height)

        if ps[0].skeltanJumpscareTimer >= SKELTAN_JUMPSCARE_TIMER_MAX then
            ps[0].skeltanJumpscareTimer = 0
        end
    end
end

hook_event(HOOK_ON_HUD_RENDER_BEHIND, hud_render)