HNS_VERSION = "1.1"

TEAM_HIDERS  = 0
TEAM_SEEKERS = 1
TEAM_MAX = 2

GAME_STATE_ACTIVE = 0
GAME_STATE_INACTIVE = 1
GAME_STATE_SEEKER_WIN = 2
GAME_STATE_HIDER_WIN = 3
GAME_STATE_VOTING = 4

VOTING_TIMER_MAX = 45 * 30
VOTING_TIMER_IDLE = 3 * 30

TEXT_NOTHING = get_texture_info("nothing")

-- get rid of shadows
texture_override_set("outside_0900BC00", TEXT_NOTHING)
texture_override_set("grass_0900B000", TEXT_NOTHING)
texture_override_set("generic_0900B000", TEXT_NOTHING)
texture_override_set("texture_shadow_quarter_square", TEXT_NOTHING)

gGlobalSyncTable.gameState = GAME_STATE_INACTIVE

ACT_FROZEN = ACT_BUBBLED--allocate_mario_action(ACT_FLAG_STATIONARY | ACT_FLAG_WATER_OR_TEXT)

pauseExitTimer = 0

removeEyeStrain = false

LEVEL_GG = level_register('level_grassmap_entry', COURSE_CAKE_END, 'Grassy Gardens', 'grassy_gardens', 28000, 0x08, 0x08, 0x08)
LEVEL_MM = level_register('level_watermap_entry', COURSE_CAKE_END, 'Mechanical Maze', 'watermap', 28000, 0x08, 0x08, 0x08)
LEVEL_BBB = level_register('level_icelavamap_entry', COURSE_CAKE_END, 'Blizz-Blaze Bay', 'icelavamap', 28000, 0x08, 0x08, 0x08)

gServerSettings.playerInteractions = 1
gServerSettings.stayInLevelAfterStar = 2
gServerSettings.nametags = 0
gServerSettings.bubbleDeath = 0

ps = gPlayerSyncTable
npl = gNetworkPlayers

MODEL_ANIMATED = 1
MODEL_BILLBOARDED = 2
MODEL_DONT_FOLLOW_YAW = 4
MODEL_BILLBOARDED_MIRRORED = 6

CATE_ENVIRONMENT = 0
CATE_COLLECTIBLES = 1
CATE_BOSSES = 2
CATE_ENEMIES = 3
CATE_FRIENDLY = 4
CATE_MAX = 5

BITS_PER_LEVEL = 4
COUNT_MASK = (1 << BITS_PER_LEVEL) - 1

gGlobalSyncTable.seed = 15012008
gGlobalSyncTable.randomizeObj = false
gGlobalSyncTable.deleteObjs = false
gGlobalSyncTable.votableLevels = (1 << COURSE_BOB) | (1 << COURSE_JRB) | (1 << COURSE_WF) | (1 << COURSE_SA)
gGlobalSyncTable.storedVotes = 0

votingEnabled = true

bombCooldown = 0

gGlobalSyncTable.bombCooldownMax = 30 * 30

SEQ_EVENT_HURRY_UP = 0x70 --* hopefully no one goes that far
SEQ_EVENT_HURRY_UP_HOT = 0x71

E_MODEL_SKELTAN = smlua_model_util_get_id('skeltan_geo')

vanillaLightDir = get_lighting_dir(1)

smlua_audio_utils_replace_sequence(SEQ_EVENT_HURRY_UP, 0x25, 100, "hurrysong")

N64FriendlyControls = false

sCamInfo = {
    pos = {x = 0, y = 0, z = 0},
    yaw = 0,
    pitch = 0
}

prevBgMusic = SEQ_EVENT_MERRY_GO_ROUND

mainMenu = false
propMenu = false

defaultButtons = {
    prop_button = X_BUTTON,
    freeze_button = L_TRIG,
    fake_prop_button = Y_BUTTON,
    vert_up_button = U_JPAD,
    vert_down_button = D_JPAD,
    anim_left_button = L_JPAD,
    anim_right_button = R_JPAD,
}

--* get the mod storage value and the hack name
--* if includeHack is false don't include the hack name into the string

--* if the value is nil then save the value with its default

function load_or_initialize_mod_storage(key, defaultValue, includeHack)
    local value = mod_storage_load(key)
    local hackString = currHack
    if not includeHack then
        hackString = ""
    end

    if not value then
        mod_storage_save(key, hackString..tostring(defaultValue))
        return defaultValue
    end
    return tonumber(value) or value
end

PROP_BUTTON = load_or_initialize_mod_storage("prop_button", defaultButtons.prop_button)
FREEZE_BUTTON = load_or_initialize_mod_storage("freeze_button", defaultButtons.freeze_button)
FAKE_PROP_BUTTON = load_or_initialize_mod_storage("fake_prop_button", defaultButtons.fake_prop_button)
VERT_UP_BUTTON = load_or_initialize_mod_storage("vert_up_button", defaultButtons.vert_up_button)
VERT_DOWN_BUTTON = load_or_initialize_mod_storage("vert_down_button", defaultButtons.vert_down_button)
ANIM_LEFT_BUTTON = load_or_initialize_mod_storage("anim_left_button", defaultButtons.anim_left_button)
ANIM_RIGHT_BUTTON = load_or_initialize_mod_storage("anim_right_button", defaultButtons.anim_right_button)

SKELTAN_JUMPSCARE_TIMER_MAX = 60
AUDIO_SAMPLE_SKELTAN_JUMPSCARE = audio_sample_load("skeltan_jumpscare.mp3")

for i = 0, MAX_PLAYERS - 1 do
    ps[i].team = TEAM_HIDERS
    ps[i].isUsingFreeCam = false
    ps[i].model = E_MODEL_BUBBLY_TREE
    ps[i].posYOffset = 0
    ps[i].curAnimIndex = 0
    ps[i].modelInfo = MODEL_ANIMATED | MODEL_BILLBOARDED
    ps[i].selectedCategory = CATE_ENVIRONMENT
    ps[i].selectedModelIndex = 1
    ps[i].frozen = false
    ps[i].validatedProp = true
    ps[i].time = 0
    ps[i].isSkeltan = false
    ps[i].skeltanJumpscareTimer = 0
    ps[i].isReady = false
    ps[i].isSlow = false
end

slowTimer = 0
currHack = "Vanilla"

local function on_mods_loaded()
    for i, mod in pairs(gActiveMods) do
        if mod.enabled then
            if mod.incompatible and mod.incompatible:find("romhack") then
                currHack = mod.name
            end
        end
    end 
end

hook_event(HOOK_ON_MODS_LOADED, on_mods_loaded)

tipTable = {
    "Tip: Fake Yellow Coins spin backwards.",
    "Tip: Try taking the place of an already existing prop.",
    "Tip: Sometimes hiding in plain sight is the best spot.",
    "Tip: Hiders become slower when next to seekers.",
    "Tip: When freezing you gain the properties of the fake object.",
    "Tip: When freezing enemies won't see you.",
    "Tip: You could try roleplaying into an enemy.",
    "Tip: Hiding as Browser probably isn't a good idea.",
    "Tip: Only some fake objects have a vertical offset.",
    "Tip: Sub areas are allowed.",
    "Tip: Try pressing pause to see if some red coins are missing.",
    "Tip: Areas past instant warps are broken don't go there.",

    "Mod made by Blocky. Maps by biobak. Settings Menu by Squishy",
}

tip = tipTable[math.random(1, #tipTable)]

sModdedCourses = {
    LEVEL_GG,
    LEVEL_MM,
    LEVEL_BBB,
}

sCourseToLevels = {
    [COURSE_BOB] = LEVEL_BOB,
    [COURSE_WF] = LEVEL_WF,
    [COURSE_JRB] = LEVEL_JRB,
    [COURSE_CCM] = LEVEL_CCM,
    [COURSE_BBH] = LEVEL_BBH,
    [COURSE_HMC] = LEVEL_HMC,
    [COURSE_LLL] = LEVEL_LLL,
    [COURSE_SSL] = LEVEL_SSL,
    [COURSE_DDD] = LEVEL_DDD,
    [COURSE_SL] = LEVEL_SL,
    [COURSE_WDW] = LEVEL_WDW,
    [COURSE_TTM] = LEVEL_TTM,
    [COURSE_THI] = LEVEL_THI,
    [COURSE_TTC] = LEVEL_TTC,
    [COURSE_RR] = LEVEL_RR,
    [COURSE_BITDW] = LEVEL_BITDW,
    [COURSE_BITFS] = LEVEL_BITFS,
    [COURSE_BITS] = LEVEL_BITS,
    [COURSE_PSS] = LEVEL_PSS,
    [COURSE_COTMC] = LEVEL_COTMC,
    [COURSE_TOTWC] = LEVEL_TOTWC,
    [COURSE_VCUTM] = LEVEL_VCUTM,
    [COURSE_WMOTR] = LEVEL_WMOTR,
    [COURSE_SA] = LEVEL_SA,
}

roleToString = {
    [TEAM_HIDERS] = {text = "Hider", color = {r = 0, g = 255, b = 255}},
    [TEAM_SEEKERS] = {text = "Seeker", color = {r = 255, g = 0, b = 0}},
}

combinedCourses = {}

for course, level in pairs(sCourseToLevels) do
    if not (currHack == "Vanilla" and course == COURSE_DDD) then --* most of DDD is past an instant warp, which breaks things
        table.insert(combinedCourses, {course = course, level = level})
    end
end

for _, moddedCourse in ipairs(sModdedCourses) do
    table.insert(combinedCourses, {course = #combinedCourses + 1, level = moddedCourse, isModded = true})
end

MODIFIER_PROP_HUNT = 1
MODIFIER_FOG = 2
MODIFIER_TIMED_ROUND = 4

gGlobalSyncTable.forcedFloor = nil

gGlobalSyncTable.roundModifiers = MODIFIER_PROP_HUNT | MODIFIER_TIMED_ROUND

gGlobalSyncTable.roundTimerMax = 9000
gGlobalSyncTable.roundTimer = 0
gGlobalSyncTable.seekerNum = 1
gGlobalSyncTable.hiderHeadStartTimer = 0
gGlobalSyncTable.hiderHeadStartTimerMax = 1800
gGlobalSyncTable.winText = "Uh oh, what did you do?"
gGlobalSyncTable.winTextTimer = 0
gGlobalSyncTable.gameStartTimer = 0
gGlobalSyncTable.pauseExitTimerMax = 900
gGlobalSyncTable.antiCamp = false
gGlobalSyncTable.autoRestart = true
gGlobalSyncTable.deleteObjectPercentage = 70

sBlacklist = {}

hurryUp = false

OUTSIDE = 1
MAIN_FLOOR = 2
BASEMENT_FLOOR = 3
UPPER_FLOOR = 4
FLOOR_MAX = 5

PACKET_GAME_STATE_CHANGE = 0
PACKET_SETUP_PROP = 1
PACKET_SETUP_STUN = 3

forcedFloor = {
    [MAIN_FLOOR] = {
        { level = LEVEL_CASTLE, area = 1 },
        { level = LEVEL_BOB },
        { level = LEVEL_WF },
        { level = LEVEL_JRB },
        { level = LEVEL_CCM },
        { level = LEVEL_TOTWC },
        { level = LEVEL_PSS },
        { level = LEVEL_SA },
        { level = LEVEL_BITDW }
    },
    [UPPER_FLOOR] = {
        { level = LEVEL_CASTLE, area = 2 },
        { level = LEVEL_SL },
        { level = LEVEL_WDW },
        { level = LEVEL_TTM },
        { level = LEVEL_THI },
        { level = LEVEL_TTC },
        { level = LEVEL_RR },
        { level = LEVEL_WMOTR },
        { level = LEVEL_BITS }
    },
    [BASEMENT_FLOOR] = {
        { level = LEVEL_CASTLE, area = 3 },
        { level = LEVEL_LLL },
        { level = LEVEL_SSL },
        { level = LEVEL_HMC },
        { level = LEVEL_DDD },
        { level = LEVEL_COTMC },
        { level = LEVEL_BITFS }
    },
    [OUTSIDE] = {
        { level = LEVEL_CASTLE_GROUNDS },
        { level = LEVEL_CASTLE_COURTYARD },
        { level = LEVEL_VCUTM },
        { level = LEVEL_BBH }
    },
}

sLastPos = {
    x = 0,
    y = 0,
    z = 0,
}

function get_button_combination_string(buttonPressed)
    local combo = {}
    
    -- Check each button and add its corresponding string if pressed
    if buttonPressed & A_BUTTON ~= 0 then table.insert(combo, "A") end
    if buttonPressed & B_BUTTON ~= 0 then table.insert(combo, "B") end
    if buttonPressed & X_BUTTON ~= 0 then table.insert(combo, "X") end
    if buttonPressed & Y_BUTTON ~= 0 then table.insert(combo, "Y") end
    if buttonPressed & START_BUTTON ~= 0 then table.insert(combo, "START") end

    if buttonPressed & Z_TRIG ~= 0 then table.insert(combo, "Z") end
    if buttonPressed & R_TRIG ~= 0 then table.insert(combo, "R") end
    if buttonPressed & L_TRIG ~= 0 then table.insert(combo, "L") end

    if buttonPressed & D_CBUTTONS ~= 0 then table.insert(combo, "C Down") end
    if buttonPressed & U_CBUTTONS ~= 0 then table.insert(combo, "C Up") end
    if buttonPressed & L_CBUTTONS ~= 0 then table.insert(combo, "C Left") end
    if buttonPressed & R_CBUTTONS ~= 0 then table.insert(combo, "C Right") end

    if buttonPressed & D_JPAD ~= 0 then table.insert(combo, "D Dpad") end
    if buttonPressed & U_JPAD ~= 0 then table.insert(combo, "U Dpad") end
    if buttonPressed & L_JPAD ~= 0 then table.insert(combo, "L Dpad") end
    if buttonPressed & R_JPAD ~= 0 then table.insert(combo, "R Dpad") end

    -- Join the button names with a "+" symbol to form the combination string
    return table.concat(combo, " + ")
end

function toggle_blacklist(course)
    if not sBlacklist then
        sBlacklist = {}
    end
    sBlacklist[course] = not sBlacklist[course]
end

function get_random_course()
    local availableCourses = {}

    for _, entry in ipairs(combinedCourses) do
        local courseId = entry.course
        if not sBlacklist or not sBlacklist[courseId] then
            table.insert(availableCourses, entry)
        end
    end

    if #availableCourses == 0 then
        djui_chat_message_create("ERROR: NO AVAILABLE COURSES FOUND, DEFAULTING TO COURSE 1.")
        return LEVEL_BOB
    end

    return availableCourses[math.random(#availableCourses)].level
end

gGlobalSyncTable.forcedLevel = LEVEL_BOB
gGlobalSyncTable.seekerWaitLevel = get_random_course()

local prevOutPos = { x = 0, y = 0 }
local prevScale = 1

function render_hud_icon(o, scale, text)
    local in_pos = {x = o.oPosX, y = o.oPosY + 200, z = o.oPosZ}
    local out_pos = {x = 0, y = 0, z = 0}
    djui_hud_world_pos_to_screen_pos(in_pos, out_pos)

    djui_hud_set_font(FONT_HUD)

    djui_hud_print_text_interpolated(text, prevOutPos.x, prevOutPos.y, prevScale, out_pos.x, out_pos.y, scale)

    prevOutPos.x = out_pos.x
    prevOutPos.y = out_pos.y
    prevScale = scale

    djui_hud_set_font(FONT_NORMAL)
end

function set_game_state(data)
    local gameState = data.param

    set_world_color(0, 255)
    set_world_color(1, 255)
    set_world_color(2, 255)
    set_override_skybox(-1)
    set_lighting_dir(1, vanillaLightDir)
    set_room_override(-1)

    gGlobalSyncTable.roundTimer = 0
    gGlobalSyncTable.hiderHeadStartTimer = 0
    reset_voting_state()

    ps[0].isReady = false

    gGlobalSyncTable.gameState = gameState

    slowTimer = 0

    if hurryUp then
        set_background_music(0, prevBgMusic, 0)
        hurryUp = false
    end

    gMarioStates[0].health = 0x880

    if gameState == GAME_STATE_INACTIVE then
        if network_is_server() then

            if gGlobalSyncTable.forcedLevel and gGlobalSyncTable.forcedLevel < 0 then
                gGlobalSyncTable.forcedLevel = -get_random_course()
            end
            if gGlobalSyncTable.forcedFloor and gGlobalSyncTable.forcedFloor < 0 then
                gGlobalSyncTable.forcedFloor = -math.random(1, FLOOR_MAX - 1)
            end
            gGlobalSyncTable.seed = math.random(0, 65535)
        end
        for i = 0, MAX_PLAYERS - 1 do
            ps[i].team = TEAM_HIDERS
            ps[i].isUsingFreeCam = false
            ps[i].model = E_MODEL_BUBBLY_TREE
            ps[i].posYOffset = 0
            ps[i].curAnimIndex = 0
            ps[i].modelInfo = MODEL_BILLBOARDED
            ps[i].selectedCategory = CATE_ENVIRONMENT
            ps[i].selectedModelIndex = 1
            ps[i].frozen = false
            ps[i].validatedProp = true
            ps[i].time = 0
            ps[i].isReady = false
        end

        for_each_object_with_behavior(id_bhvFakeObj, obj_mark_for_deletion)
        for_each_object_with_behavior(id_bhvStunObj, obj_mark_for_deletion)

        camera_unfreeze()
        gGlobalSyncTable.gameStartTimer = 0
        hasSeeker = false
    elseif gameState == GAME_STATE_ACTIVE then
        tip = tipTable[math.random(1, #tipTable)]
        warp_to_level(gLevelValues.entryLevel, 1, 0)
        play_sound(SOUND_OBJ_BOWSER_LAUGH, gMarioStates[0].marioObj.header.gfx.cameraToObject)
        if network_is_server() then
            assign_roles(gGlobalSyncTable.seekerNum)
            gGlobalSyncTable.seekerWaitLevel = get_random_course()
            if gGlobalSyncTable.forcedLevel and gGlobalSyncTable.forcedLevel < 0 then
                gGlobalSyncTable.forcedLevel = -get_random_course()
            end
            if gGlobalSyncTable.forcedFloor and gGlobalSyncTable.forcedFloor < 0 then
                gGlobalSyncTable.forcedFloor = -math.random(1, FLOOR_MAX - 1)
            end
        end
    elseif gameState == GAME_STATE_VOTING then
        local course_start = COURSE_BOB
        local course_end = COURSE_RR

        local possible_courses = {}
        for i = course_start, course_end do
            table.insert(possible_courses, i)
        end

        for i = #possible_courses, 2, -1 do
            local j = math.random(1, i)
            possible_courses[i], possible_courses[j] = possible_courses[j], possible_courses[i]
        end

        local course_count = math.random(3, 5)

        gGlobalSyncTable.votableLevels = 0
        for i = 1, course_count do
            local course = possible_courses[i]
            gGlobalSyncTable.votableLevels = gGlobalSyncTable.votableLevels | (1 << course)
        end
    end
end

function nearest_team_to_object(team, obj) --* thanks keeb
    local nearestDist = 0
    local mN = nil

    for i=0, MAX_PLAYERS-1 do
        local s = ps[i]
        local dist = dist_between_objects(obj, gMarioStates[i].marioObj)
        if (mN == nil or dist < nearestDist) and s.team == team and is_player_active_ignore_bubble(gMarioStates[i]) then
            mN = gMarioStates[i]
            nearestDist = dist
        end
    end

    return mN
end

function search_for_owned_obj(bhv, index)
    local o = obj_get_first_with_behavior_id(bhv)
    while o ~= nil do
        if o.oFakeObjOwner == index then
            return o
        end
        o = obj_get_next_with_same_behavior_id(o)
    end
    return nil
end

function packet_setup_prop(data)
    local o = search_for_owned_obj(id_bhvFakeObj ,data.owner)

    local syncValid =  npl[0].currLevelSyncValid and npl[0].currAreaSyncValid and npl[data.owner].currLevelSyncValid and npl[data.owner].currAreaSyncValid
    if o and syncValid then
        setup_fake_obj(o, data.owner, false)
    end
end

function packet_setup_stun(data)
    local o = search_for_owned_obj(id_bhvStunObj, data.owner)

    local syncValid =  npl[0].currLevelSyncValid and npl[0].currAreaSyncValid and npl[data.owner].currLevelSyncValid and npl[data.owner].currAreaSyncValid
    if o and syncValid then
        setup_stun_obj(o, data.owner)
    end
end

function is_player_active_ignore_bubble(m)
    if not m then return false end
    if m == gMarioStates[0] then return true end
    --if m.action == ACT_BUBBLED then return false end
    local np = gNetworkPlayers[m.playerIndex]
    if np.type ~= NPT_LOCAL then
        if not np.connected then return false end
        if npl[0] == nil then return false end
        local levelAreaMismatch =
            (np.currCourseNum   ~= npl[0].currCourseNum
            or np.currActNum    ~= npl[0].currActNum
            or np.currLevelNum  ~= npl[0].currLevelNum
            or np.currAreaIndex ~= npl[0].currAreaIndex)
        if levelAreaMismatch then return false end
    end
    return true
end

function active_player(m, np)
    -- check if this player is connected and in the same level
    if not np.connected or np.currCourseNum ~= npl[0].currCourseNum or np.currActNum ~= npl[0].currActNum or np.currLevelNum ~= npl[0].currLevelNum or
        np.currAreaIndex ~= npl[0].currAreaIndex then
        return false
    end
    return is_player_active_ignore_bubble(m)
end

function name_without_hex(name) --* Stolen from nametags
    local s = ''
    local inSlash = false
    for i = 1, #name do
        local c = name:sub(i,i)
        if c == '\\' then
            inSlash = not inSlash
        elseif not inSlash then
            s = s .. c
        end
    end
    return s
end

function djui_hud_print_text_with_shadow(text, x, y, offset, scale, shadowColor, textColor)
    if shadowColor then
        djui_hud_set_color(shadowColor.r, shadowColor.g, shadowColor.b, shadowColor.a)
    end
    djui_hud_print_text(text, x + offset, y + offset, scale)
    if textColor then
        djui_hud_set_color(textColor.r, textColor.g, textColor.b, textColor.a)
    end
    djui_hud_print_text(text, x, y, scale)
end

packetTable = {
    [PACKET_GAME_STATE_CHANGE] = set_game_state,
    [PACKET_SETUP_PROP] = packet_setup_prop,
    [PACKET_SETUP_STUN] = packet_setup_stun,
}

function network_send_include_self(reliable, data)
    network_send(reliable, data)
    if packetTable[data.id]then
        packetTable[data.id](data)
    end
end

function set_world_color(index, value)
    set_lighting_color(index, clamp(value, 0, 255))
    set_lighting_color(index, clamp(value, 0, 255))
    set_lighting_color(index, clamp(value, 0, 255))
    set_vertex_color(index, clamp(value, 0, 255))
    set_vertex_color(index, clamp(value, 0, 255))
    set_vertex_color(index, clamp(value, 0, 255))
    set_fog_color(index, clamp(value, 0, 255))
    set_fog_color(index, clamp(value, 0, 255))
    set_fog_color(index, clamp(value, 0, 255))
end

function get_player_count()
    if not debug then
        return network_player_connected_count()
    else
        return MAX_PLAYERS
    end
end

function get_player_global_index_by_name(partialName)
    local lowerPartialName = string.lower(partialName)

    for i = 0, MAX_PLAYERS - 1 do
        local player = gNetworkPlayers[i]
        if player ~= nil and player.connected then
            local lowerPlayerName = string.lower(name_without_hex(player.name))
            if string.find(lowerPlayerName, lowerPartialName, 1, true) then
                return player.globalIndex, player.name
            end
        end
    end
    return nil
end

function get_total_seekers_count()
    local count = 0
    for i = 0, MAX_PLAYERS - 1 do
        local np = gNetworkPlayers[i]
        if np.connected and ps[i].team == TEAM_SEEKERS then
            count = count + 1
        end
    end
    return count
end

function get_level_player_count(level, act)

    local playerCount = 0

    for i = 0, MAX_PLAYERS - 1 do
        local np = gNetworkPlayers[i]
        if np.connected and np.currLevelNum == level and np.currActNum == act then
            playerCount = playerCount + 1
        end
    end

    return playerCount
end

function get_level_shift(courseID)
    return courseID * BITS_PER_LEVEL
end

function decode_all_votes()
    local counts = {}
    local mask = gGlobalSyncTable.storedVotes or 0
    for courseID = 0, COURSE_MAX - 1 do
        local shift = get_level_shift(courseID)
        counts[courseID] = (mask >> shift) & COUNT_MASK
    end
    return counts
end

function count_votes_per_course()
    local voteCounts = {}
    local stored = gGlobalSyncTable.storedVotes or 0
    for i = 0, MAX_PLAYERS - 1 do
        for courseID = 0, COURSE_MAX - 1 do
            if ((stored >> (courseID + i * COURSE_MAX)) & 1) == 1 then
                voteCounts[courseID] = (voteCounts[courseID] or 0) + 1
            end
        end
    end
    return voteCounts
end

function get_winning_course()
    local votes = decode_all_votes()
    local winner = nil
    local max_votes = -1

    for course_id, count in pairs(votes) do
        if count > max_votes then
            max_votes = count
            winner = course_id
        end
    end

    return winner, max_votes
end

function notify_caught_player(id)
    local roundTimer = gGlobalSyncTable.roundTimer or 0
    if roundTimer < 0 then roundTimer = 0 end

    local currentTime = math.ceil(roundTimer / 30)
    local hours = math.floor(currentTime / 3600)
    local minutes = math.floor((currentTime % 3600) / 60)
    local seconds = currentTime % 60

    local timeText = ""
    if hours > 0 then
        timeText = string.format("%d hour%s, %d minute%s and %d second%s",
            hours, hours == 1 and "" or "s",
            minutes, minutes == 1 and "" or "s",
            seconds, seconds == 1 and "" or "s")
    elseif minutes > 0 then
        timeText = string.format("%d minute%s and %d second%s",
            minutes, minutes == 1 and "" or "s",
            seconds, seconds == 1 and "" or "s")
    else
        timeText = string.format("%d second%s", seconds, seconds == 1 and "" or "s")
    end

    local playerCount = get_player_count() - (get_total_seekers_count() + 1)
    local playerCountText = playerCount > 0 and string.format("\n%d player%s remain.", playerCount, playerCount == 1 and "" or "s") or ""

    djui_popup_create_global(network_get_player_text_color_string(id)..npl[id].name.."\\#ffff00\\ was caught at\n"..network_get_player_text_color_string(id)..timeText.."!\\#ffff00\\"..playerCountText, 3)
end


--*only way to have it so enemies don't see you is to make it so the player isn't an active player
--*and the only way to do that currently is to set the player in the ACT_BUBBLED action, which i repurpose here since it won't be used
local function act_bubbled(m)
    --*making it so the bubble action just does nothing, teehee!
    if ps[m.playerIndex].team == TEAM_SEEKERS then
        set_mario_action(m, m.prevAction, 0)
        if m.playerIndex == 0 then
            ps[0].frozen = false
            ps[0].isUsingFreeCam = false
        end
    end
end

hook_mario_action(ACT_FROZEN, act_bubbled)