showSettings = false

-- settings, width and height
local bgWidth = 600
local bgHeight = djui_hud_get_screen_height() - 80
local selection = 1

-- inputs
INPUT_A = 0
INPUT_JOYSTICK = 1

-- permissions
PERMISSION_NONE = 0
PERMISSION_SERVER = 1
PERMISSION_MODERATORS = 2

local function on_off_text(bool)
    if bool then return "On" else return "Off" end
end

local function has_permission(perm)
    if perm == PERMISSION_NONE then return true end
    if perm == PERMISSION_SERVER and network_is_server() then return true end
    if perm == PERMISSION_MODERATORS and (network_is_server() or network_is_moderator()) then return true end

    return false
end

local function get_controller_dir()
    -- get which direction we are facing
    local m = gMarioStates[0]
    local direction = CONT_LEFT

    if m.controller.buttonPressed & R_JPAD ~= 0
    or m.controller.stickX > 0.5 then direction = CONT_RIGHT end

    return direction
end

joystickCooldown = 0
local category = nil
local previousRgbValue = nil
local rgbValue = nil
local rgbAlphaEnabled = false
local oldTheme = nil

-- entries
local mainEntries = {}
local startEntries = {}
local gamemodeEntries = {}
local modifierEntries = {}
local settingEntries = {}
local gameEntries = {}
local generalEntries = {}
local themeEntries = {}
local themeManagerEntries = {}
local themeBuilderEntries = {}
local rgbSliderEntries = {}
local hudEntries = {}
local extraEntries = {}
local graphicEntries = {}
local serverEntries = {}
local enemyEntries = {}
local categoryEntries = {}
local romhackEntries = {}
local manualEntries = {}
local chapterEntries = {}
local creditEntries = {}
local gamemodeManualEntries = {}
local modifierManualEntries = {}
local commandEntries = {}
local musicEntries = {}
local entries = mainEntries

local EASY = 1
local CASUAL = 2
local NORMAL = 3
local HARD = 4
local LIGHT_KAIZO = 5
local KAIZO = 6
local ULTRA_KAIZO = 7
local VANILLA_EDITS = 8
local STAR_REVENGE = 9
local BOWSERS_DANK_RAVE = 10
local MEME = 11
local SHORT = 12
local LONG = 13
local ALL = 14
local romhackCategories = {
    [EASY] = "Easy",
    [CASUAL] = "Casual",
    [NORMAL] = "Normal",
    [HARD] = "Hard",
    [LIGHT_KAIZO] = "Light Kaizo",
    [KAIZO] = "Kaizo",
    [ULTRA_KAIZO] = "Ultra Kaizo",
    [VANILLA_EDITS] = "Vanilla Edits",
    [STAR_REVENGE] = "Star Revenge",
    [BOWSERS_DANK_RAVE] = "Bowser's Dank Rave",
    [MEME] = "Meme",
    [SHORT] = "Short",
    [LONG] = "Long",
    [ALL] = "All",
}

local function toggle_powerups()
    gGlobalSyncTable.modif_powerups = not gGlobalSyncTable.modif_powerups
    mod_storage_save_bool("Power-Ups", gGlobalSyncTable.modif_powerups)
end

local function toggle_instakill()
    gGlobalSyncTable.modif_instakill = not gGlobalSyncTable.modif_instakill
    mod_storage_save_bool("Instakill", gGlobalSyncTable.modif_instakill)
end

local function toggle_pursuit()
    gGlobalSyncTable.modif_pursuit = not gGlobalSyncTable.modif_pursuit
    mod_storage_save_bool("Pursuit", gGlobalSyncTable.modif_pursuit)
end

local function toggle_pvp()
    gGlobalSyncTable.modif_pvp = not gGlobalSyncTable.modif_pvp
    mod_storage_save_bool("PvP", gGlobalSyncTable.modif_pvp)
end

local function toggle_deathcoin()
    gGlobalSyncTable.modif_deathcoin = not gGlobalSyncTable.modif_deathcoin
    mod_storage_save_bool("Deathcoin", gGlobalSyncTable.modif_deathcoin)
end

local function toggle_winboost()
    gGlobalSyncTable.modif_winboost = not gGlobalSyncTable.modif_winboost
    mod_storage_save_bool("Winboost", gGlobalSyncTable.modif_winboost)
end

local function toggle_speed()
    gGlobalSyncTable.modif_speed = not gGlobalSyncTable.modif_speed
    mod_storage_save_bool("Speed", gGlobalSyncTable.modif_speed)
end

local function toggle_bbc()
    gGlobalSyncTable.modif_bbc = not gGlobalSyncTable.modif_bbc
    mod_storage_save_bool("BBC", gGlobalSyncTable.modif_bbc)
end

local function toggle_zbc()
    gGlobalSyncTable.modif_zbc = not gGlobalSyncTable.modif_zbc
    mod_storage_save_bool("ZBC", gGlobalSyncTable.modif_zbc)
end

local function toggle_coinrush()
    gGlobalSyncTable.modif_coinrush = not gGlobalSyncTable.modif_coinrush
    mod_storage_save_bool("Coinrush", gGlobalSyncTable.modif_coinrush)
end

local function toggle_tripping()
    gGlobalSyncTable.modif_tripping = not gGlobalSyncTable.modif_tripping
    mod_storage_save_bool("Tripping", gGlobalSyncTable.modif_tripping)
end

local function toggle_lowgravity()
    gGlobalSyncTable.modif_lowgravity = not gGlobalSyncTable.modif_lowgravity
    mod_storage_save_bool("Lowgravity", gGlobalSyncTable.modif_lowgravity)
end

local function toggle_highgravity()
    gGlobalSyncTable.modif_highgravity = not gGlobalSyncTable.modif_highgravity
    mod_storage_save_bool("Highgravity", gGlobalSyncTable.modif_highgravity)
end

local function toggle_flashflood()
    gGlobalSyncTable.modif_flashflood = not gGlobalSyncTable.modif_flashflood
    mod_storage_save_bool("FlashFlood", gGlobalSyncTable.modif_flashflood)
end

local function toggle_blj()
    gGlobalSyncTable.modif_blj = not gGlobalSyncTable.modif_blj
    mod_storage_save_bool("BLJ", gGlobalSyncTable.modif_blj)
end

local function toggle_capless()
    gGlobalSyncTable.modif_capless = not gGlobalSyncTable.modif_capless
    mod_storage_save_bool("Capless", gGlobalSyncTable.modif_capless)
end

local function toggle_fly()
    gGlobalSyncTable.modif_fly = not gGlobalSyncTable.modif_fly
    mod_storage_save_bool("Fly", gGlobalSyncTable.modif_fly)
end

local function toggle_slippery_floors()
    gGlobalSyncTable.modif_slippery = not gGlobalSyncTable.modif_slippery
    mod_storage_save_bool("Slippery", gGlobalSyncTable.modif_slippery)
end

local function toggle_hard_floors()
    gGlobalSyncTable.modif_hard = not gGlobalSyncTable.modif_hard
    mod_storage_save_bool("Hard", gGlobalSyncTable.modif_hard)
end

local function toggle_fog()
    gGlobalSyncTable.modif_fog = not gGlobalSyncTable.modif_fog
    mod_storage_save_bool("Fog", gGlobalSyncTable.modif_fog)
end

local function toggle_inverted()
    gGlobalSyncTable.modif_inverted = not gGlobalSyncTable.modif_inverted
    mod_storage_save_bool("Inverted", gGlobalSyncTable.modif_inverted)
end

local function toggle_tornadoes()
    gGlobalSyncTable.modif_tornadoes = not gGlobalSyncTable.modif_tornadoes
    mod_storage_save_bool("Tornadoes", gGlobalSyncTable.modif_tornadoes)
end

local function toggle_firsties()
    gGlobalSyncTable.modif_firsties = not gGlobalSyncTable.modif_firsties
    mod_storage_save_bool("Firsties", gGlobalSyncTable.modif_firsties)
end

local function toggle_stj()
    gGlobalSyncTable.modif_stj = not gGlobalSyncTable.modif_stj
    mod_storage_save_bool("STJ", gGlobalSyncTable.modif_stj)
end

local function toggle_earthquake()
    gGlobalSyncTable.modif_earthquake = not gGlobalSyncTable.modif_earthquake
    mod_storage_save_bool("Earthquake", gGlobalSyncTable.modif_earthquake)
end

local function set_coincount()

    -- get which direction we are facing
    local m = gMarioStates[0]
    local direction = get_controller_dir()

    -- get speed
    local speed = 1

    if m.controller.buttonPressed & R_JPAD ~= 0
    or m.controller.buttonPressed & L_JPAD ~= 0 then
        speed = 4
    end

    if direction == CONT_LEFT then
        gGlobalSyncTable.coinCount = gGlobalSyncTable.coinCount - speed

        if gGlobalSyncTable.coinCount <= 0 then
            gGlobalSyncTable.coinCount = 0
        end
    else
        gGlobalSyncTable.coinCount = gGlobalSyncTable.coinCount + speed
    end
end

local function set_flood_speed()

    -- get which direction we are facing
    local m = gMarioStates[0]
    local direction = get_controller_dir()

    -- get speed
    local speed = 1 * 2

    if m.controller.buttonPressed & R_JPAD ~= 0
    or m.controller.buttonPressed & L_JPAD ~= 0 then
        speed = 1
    end

    gGlobalSyncTable.speedMultiplier = clampf(gGlobalSyncTable.speedMultiplier, 0, 99)

    if direction == CONT_LEFT then
        gGlobalSyncTable.speedMultiplier = gGlobalSyncTable.speedMultiplier - speed

        if gGlobalSyncTable.speedMultiplier <= 0 then
            gGlobalSyncTable.speedMultiplier = 0
        end
    else
        gGlobalSyncTable.speedMultiplier = gGlobalSyncTable.speedMultiplier + speed
    end
end

local function set_mapmode()
    local direction = get_controller_dir()

    if direction == CONT_LEFT then
        gGlobalSyncTable.mapMode = gGlobalSyncTable.mapMode - 1
        if gGlobalSyncTable.mapMode < MAPMODE_NORMAL then
            gGlobalSyncTable.mapMode = MAPMODE_VOTING
        elseif gGlobalSyncTable.mapMode > MAPMODE_VOTING then
            gGlobalSyncTable.mapMode = MAPMODE_NORMAL
        end
    else
        gGlobalSyncTable.mapMode = gGlobalSyncTable.mapMode + 1
        if gGlobalSyncTable.mapMode > MAPMODE_VOTING then
            gGlobalSyncTable.mapMode = MAPMODE_NORMAL
        elseif gGlobalSyncTable.mapMode > MAPMODE_NORMAL then
            gGlobalSyncTable.mapMode = MAPMODE_VOTING
        end
    end
    mod_storage_save_number("mapMode", gGlobalSyncTable.mapMode)
end

local function toggle_auto_mode()
    gGlobalSyncTable.autoMode = not gGlobalSyncTable.autoMode
    mod_storage_save_bool("autoMode", gGlobalSyncTable.autoMode)
end

local function toggle_flood_gravity()
    gGlobalSyncTable.floodGravity = not gGlobalSyncTable.floodGravity
    mod_storage_save_bool("floodGravity", gGlobalSyncTable.floodGravity)
end

local function toggle_flood_interactions()
    gGlobalSyncTable.floodInteractions = not gGlobalSyncTable.floodInteractions
    mod_storage_save_bool("floodInteractions", gGlobalSyncTable.floodInteractions)
end

local function toggle_lobby_powerups()
    gGlobalSyncTable.lobbyPowerups = not gGlobalSyncTable.lobbyPowerups
    mod_storage_save_bool("lobbyPowerups", gGlobalSyncTable.lobbyPowerups)
end

local function toggle_lobby_pvp()
    gGlobalSyncTable.lobbyPvp = not gGlobalSyncTable.lobbyPvp
    mod_storage_save_bool("lobbyPvp", gGlobalSyncTable.lobbyPvp)
end

local function toggle_lobby_bosses()
    gGlobalSyncTable.lobbyBosses = not gGlobalSyncTable.lobbyBosses
    mod_storage_save_bool("lobbyBosses", gGlobalSyncTable.lobbyBosses)
end

local function toggle_kill_inactive()
    gGlobalSyncTable.killInactive = not gGlobalSyncTable.killInactive
    mod_storage_save_bool("killInactive", gGlobalSyncTable.killInactive)
end

local function toggle_start_shortcut()
    gGlobalSyncTable.startShortcut = not gGlobalSyncTable.startShortcut
    mod_storage_save_bool("startShortcut", gGlobalSyncTable.startShortcut)
end

local function set_start_bind()
    local direction = get_controller_dir()

    if direction == CONT_LEFT then
        if gGlobalSyncTable.startBind == A_BUTTON then
            gGlobalSyncTable.startBind = Y_BUTTON
        elseif gGlobalSyncTable.startBind == Y_BUTTON then
            gGlobalSyncTable.startBind = X_BUTTON
        elseif gGlobalSyncTable.startBind == X_BUTTON then
            gGlobalSyncTable.startBind = A_BUTTON
        end
    else
        if gGlobalSyncTable.startBind == A_BUTTON then
            gGlobalSyncTable.startBind = X_BUTTON
        elseif gGlobalSyncTable.startBind == X_BUTTON then
            gGlobalSyncTable.startBind = Y_BUTTON
        elseif gGlobalSyncTable.startBind == Y_BUTTON then
            gGlobalSyncTable.startBind = A_BUTTON
        end
    end
    mod_storage_save_number("startBind", gGlobalSyncTable.startBind)
end

local function toggle_fadeout()
    gGlobalSyncTable.roundFadeout = not gGlobalSyncTable.roundFadeout
    mod_storage_save_bool("roundFadeout", gGlobalSyncTable.roundFadeout)
end

local function toggle_custom_music()
    eFloodVariables.customMusic = not eFloodVariables.customMusic
    mod_storage_save_bool("customMusic", eFloodVariables.customMusic)
end

local function set_spectator_mode()
    local direction = get_controller_dir()

    if direction == CONT_LEFT then
        eFloodVariables.spectatorMode = eFloodVariables.spectatorMode - 1
        if eFloodVariables.spectatorMode < SPECTATOR_MODE_NORMAL then
            eFloodVariables.spectatorMode = SPECTATOR_MODE_FOLLOW
        end
    else
        eFloodVariables.spectatorMode = eFloodVariables.spectatorMode + 1
        if eFloodVariables.spectatorMode > SPECTATOR_MODE_FOLLOW then
            eFloodVariables.spectatorMode = SPECTATOR_MODE_NORMAL
        end
    end
    mod_storage_save_number("spectatorMode", eFloodVariables.spectatorMode)
end

local function set_round_cooldown()

    -- get which direction we are facing
    local m = gMarioStates[0]
    local direction = get_controller_dir()

    -- get speed
    local speed = 30 * 2

    if m.controller.buttonPressed & R_JPAD ~= 0
    or m.controller.buttonPressed & L_JPAD ~= 0 then
        speed = 30
    end

    if direction == CONT_LEFT then
        gGlobalSyncTable.timer = gGlobalSyncTable.timer - speed

        if gGlobalSyncTable.timer <= 0 then
            gGlobalSyncTable.timer = 0
        end
    else
        gGlobalSyncTable.timer = gGlobalSyncTable.timer + speed
    end
end

local function set_flood_difficulty()

    -- get which direction we are facing
    local m = gMarioStates[0]
    local direction = get_controller_dir()

    -- get speed
    local speed = 1 * 2

    if m.controller.buttonPressed & R_JPAD ~= 0
    or m.controller.buttonPressed & L_JPAD ~= 0 then
        speed = 1
    end

    if direction == CONT_LEFT then
        gGlobalSyncTable.difficulty = gGlobalSyncTable.difficulty - speed

        if gGlobalSyncTable.difficulty <= 0 then
            gGlobalSyncTable.difficulty = 0
        end
    else
        gGlobalSyncTable.difficulty = gGlobalSyncTable.difficulty + speed
    end
end

local function toggle_speedrun()
    local direction = get_controller_dir()

    if direction == CONT_LEFT then
        speedrunner = speedrunner - 1
        if speedrunner < SPEEDRUN_MODE_OFF then
            speedrunner = SPEEDRUN_MODE_MARATHON
        elseif speedrunner > SPEEDRUN_MODE_MARATHON then
            speedrunner = SPEEDRUN_MODE_RESTART
        elseif speedrunner > SPEEDRUN_MODE_RESTART then
            speedrunner = SPEEDRUN_MODE_PROGRESS
        end
    else
        speedrunner = speedrunner + 1
        if speedrunner > SPEEDRUN_MODE_MARATHON then
            speedrunner = SPEEDRUN_MODE_OFF
        elseif speedrunner < SPEEDRUN_MODE_OFF then
            speedrunner = SPEEDRUN_MODE_PROGRESS
        elseif speedrunner < SPEEDRUN_MODE_PROGRESS then
            speedrunner = SPEEDRUN_MODE_RESTART
        end
    end
end

local function toggle_quicksand()
    gGlobalSyncTable.quicksand = not gGlobalSyncTable.quicksand
    mod_storage_save_bool("quicksand", gGlobalSyncTable.quicksand)
end

local function toggle_slopejumps()
    gGlobalSyncTable.slopejumps = not gGlobalSyncTable.slopejumps
    mod_storage_save_bool("slopejumps", gGlobalSyncTable.slopejumps)
end

local function toggle_autodoors()
    gGlobalSyncTable.autodoors = not gGlobalSyncTable.autodoors
    mod_storage_save_bool("autodoors", gGlobalSyncTable.autodoors)
end

local function toggle_respawn()
    gGlobalSyncTable.respawn = not gGlobalSyncTable.respawn
    mod_storage_save_bool("respawn", gGlobalSyncTable.respawn)
end

local function toggle_nospectator()
    gGlobalSyncTable.nospectator = not gGlobalSyncTable.nospectator
    mod_storage_save_bool("nospectator", gGlobalSyncTable.nospectator)
end

local function set_pursuer_skin()
    local direction = get_controller_dir()

    if direction == CONT_LEFT then
        eTrollProperties.skin = eTrollProperties.skin - 1
        if eTrollProperties.skin < SKIN_POISONSHROOM then
            eTrollProperties.skin = SKIN_ANGRYSUN
        elseif eTrollProperties.skin > SKIN_ANGRYSUN then
            eTrollProperties.skin = SKIN_POISONSHROOM
        end
    else
        eTrollProperties.skin = eTrollProperties.skin + 1
        if eTrollProperties.skin > SKIN_ANGRYSUN then
            eTrollProperties.skin = SKIN_POISONSHROOM
        elseif eTrollProperties.skin > SKIN_GREENDEMON then
            eTrollProperties.skin = SKIN_ANGRYSUN
        end
    end
    mod_storage_save_number("skin", eTrollProperties.skin)
end

local function set_pursuer_speed()

    -- get which direction we are facing
    local m = gMarioStates[0]
    local direction = get_controller_dir()

    if direction == CONT_LEFT then
        gGlobalSyncTable.pursuerSpeed = gGlobalSyncTable.pursuerSpeed - 10

        if gGlobalSyncTable.pursuerSpeed <= 4 then
            gGlobalSyncTable.pursuerSpeed = 25
        end
    else
        gGlobalSyncTable.pursuerSpeed = gGlobalSyncTable.pursuerSpeed + 10
        if gGlobalSyncTable.pursuerSpeed > 26 then
            gGlobalSyncTable.pursuerSpeed = 5
	    end
    end
    mod_storage_save_number("pursuerSpeed", gGlobalSyncTable.pursuerSpeed)
end

local function toggle_cap_sparkles()
    capSparkles = not capSparkles
    mod_storage_save_bool("capSparkles", capSparkles)
end

local function toggle_warp_sparkles()
    warpSparkles = not warpSparkles
    mod_storage_save_bool("warpSparkles", warpSparkles)
end


local function toggle_romhack_cam()
    romhackCam = not romhackCam
    mod_storage_save_bool("romhackCam", romhackCam)
end

local function toggle_romhack_cam_cols()
    romhackCamCollision = not romhackCamCollision
    mod_storage_save_bool("romhackCamCollision", romhackCamCollision)
end

local function toggle_hardmode()
    gGlobalSyncTable.hardMode = not gGlobalSyncTable.hardMode
    mod_storage_save_bool("hardMode", gGlobalSyncTable.hardMode)
end

local function toggle_holiday_events()
    eFloodVariables.holidayEvents = not eFloodVariables.holidayEvents
    mod_storage_save_bool("holidayEvents", eFloodVariables.holidayEvents)
end

local function toggle_welcomemsg()
    eFloodVariables.welcomeMessage = not eFloodVariables.welcomeMessage
    mod_storage_save_bool("welcomeMessage", eFloodVariables.welcomeMessage)
end

local function toggle_popups()
    gGlobalSyncTable.popups = not gGlobalSyncTable.popups
    mod_storage_save_bool("popups", gGlobalSyncTable.popups)
end

local function toggle_scrollingflood()
    eFloodVariables.scrollingFlood = not eFloodVariables.scrollingFlood
    mod_storage_save_bool("scrollingFlood", eFloodVariables.scrollingFlood)
end

local function toggle_pauseanywhere()
    gGlobalSyncTable.pauseAnywhere = not gGlobalSyncTable.pauseAnywhere
    mod_storage_save_bool("pauseAnywhere", gGlobalSyncTable.pauseAnywhere)
end

local function toggle_bubbledeath()
    gGlobalSyncTable.bubbleDeath = not gGlobalSyncTable.bubbleDeath
    mod_storage_save_bool("bubbleDeath", gGlobalSyncTable.bubbleDeath)
end

local function toggle_nametags()
    gGlobalSyncTable.nametags = not gGlobalSyncTable.nametags
    mod_storage_save_bool("nametags", gGlobalSyncTable.nametags)
end

local function toggle_enableplayersinleveldisplay()
    gGlobalSyncTable.enablePlayersInLevelDisplay = not gGlobalSyncTable.enablePlayersInLevelDisplay
    mod_storage_save_bool("enablePlayersInLevelDisplay", gGlobalSyncTable.enablePlayersInLevelDisplay)
end

local function toggle_enableplayerlist()
    gGlobalSyncTable.enablePlayerList = not gGlobalSyncTable.enablePlayerList
    mod_storage_save_bool("enablePlayerList", gGlobalSyncTable.enablePlayerList)
end

local function toggle_cinematic_camera()
    cinematicCamera = not cinematicCamera
end

local function toggle_cinematic_borders()
    cinematicBorders = not cinematicBorders
end

local function set_theme()
    local direction = get_controller_dir()

    if direction == CONT_LEFT then
        selectedTheme = selectedTheme - 1
        if floodThemes[selectedTheme] == nil then
            selectedTheme = #floodThemes
        end
    else
        selectedTheme = selectedTheme + 1
        if floodThemes[selectedTheme] == nil then
            selectedTheme = 1
        end
    end

    mod_storage_save_number("theme", selectedTheme)
end

local function set_color_value(c)
    local m = gMarioStates[0]
    local direction = get_controller_dir()
    local speed = 1

    if m.controller.buttonPressed & R_JPAD ~= 0
    or m.controller.buttonPressed & L_JPAD ~= 0 then
        speed = 10
    end

    if direction == CONT_LEFT then
        c = c - speed
        if c < 0 then c = 255 end
    else
        c = c + speed
        if c > 255 then c = 0 end
    end

    return c
end

local function create_rgb_slider(rgb, alphaEnabled)
    if alphaEnabled == nil then alphaEnabled = false end
    entries = rgbSliderEntries
    selection = 1
    rgbAlphaEnabled = alphaEnabled
    rgbValue = rgb
    previousRgbValue = table.copy(rgbValue)
end

local function reset_modifier_settings()
    if network_is_server()
    or network_is_moderator() then
        gGlobalSyncTable.modif_powerups = false
        mod_storage_save_bool("Power-Ups", gGlobalSyncTable.modif_powerups)
        gGlobalSyncTable.modif_instakill = false
        mod_storage_save_bool("Instakill", gGlobalSyncTable.modif_instakill)
        gGlobalSyncTable.modif_pursuit = false
        mod_storage_save_bool("Pursuit", gGlobalSyncTable.modif_pursuit)
        gGlobalSyncTable.modif_pvp = false
        mod_storage_save_bool("PvP", gGlobalSyncTable.modif_pvp)
        gGlobalSyncTable.modif_deathcoin = false
        mod_storage_save_bool("Deathcoin", gGlobalSyncTable.modif_deathcoin)
        gGlobalSyncTable.coinCount = 4
        eTrollProperties.skin = SKIN_POISONSHROOM
        mod_storage_save_number("skin", eTrollProperties.skin)
        gGlobalSyncTable.pursuerSpeed = 15
        mod_storage_save_number("speed", gGlobalSyncTable.pursuerSpeed)
        gGlobalSyncTable.modif_winboost = false
        mod_storage_save_bool("Winboost", gGlobalSyncTable.modif_winboost)
        gGlobalSyncTable.modif_speed = false
        mod_storage_save_bool("Speed", gGlobalSyncTable.modif_speed)
        gGlobalSyncTable.modif_bbc = false
        mod_storage_save_bool("BBC", gGlobalSyncTable.modif_bbc)
        gGlobalSyncTable.modif_zbc = false
        mod_storage_save_bool("ZBC", gGlobalSyncTable.modif_zbc)
        gGlobalSyncTable.modif_coinrush = false
        mod_storage_save_bool("Coinrush", gGlobalSyncTable.modif_coinrush)
        gGlobalSyncTable.modif_tripping = false
        mod_storage_save_bool("Tripping", gGlobalSyncTable.modif_tripping)
        gGlobalSyncTable.modif_lowgravity = false
        mod_storage_save_bool("Lowgravity", gGlobalSyncTable.modif_lowgravity)
        gGlobalSyncTable.modif_highgravity = false
        mod_storage_save_bool("Highgravity", gGlobalSyncTable.modif_highgravity)
        gGlobalSyncTable.modif_flashflood = false
        mod_storage_save_bool("FlashFlood", gGlobalSyncTable.modif_flashflood)
        gGlobalSyncTable.modif_blj = false
        mod_storage_save_bool("BLJ", gGlobalSyncTable.modif_blj)
        gGlobalSyncTable.modif_capless = false
        mod_storage_save_bool("Capless", gGlobalSyncTable.modif_capless)
        gGlobalSyncTable.modif_fly = false
        mod_storage_save_bool("Fly", gGlobalSyncTable.modif_fly)
        gGlobalSyncTable.modif_slippery = false
        mod_storage_save_bool("Slippery", gGlobalSyncTable.modif_slippery)
        gGlobalSyncTable.modif_hard = false
        mod_storage_save_bool("Hard", gGlobalSyncTable.modif_hard)
        gGlobalSyncTable.modif_fog = false
        mod_storage_save_bool("Fog", gGlobalSyncTable.modif_fog)
        gGlobalSyncTable.modif_inverted = false
        mod_storage_save_bool("Inverted", gGlobalSyncTable.modif_tornadoes)
        gGlobalSyncTable.modif_tornadoes = false
        mod_storage_save_bool("Tornadoes", gGlobalSyncTable.modif_tornadoes)
        gGlobalSyncTable.modif_firsties = false
        mod_storage_save_bool("Firsties", gGlobalSyncTable.modif_firsties)
        gGlobalSyncTable.modif_stj = false
        mod_storage_save_bool("STJ", gGlobalSyncTable.modif_stj)
        gGlobalSyncTable.modif_earthquake = false
        mod_storage_save_bool("Earthquake", gGlobalSyncTable.modif_earthquake)
    end
end

local function reset_general_settings()
    if network_is_server()
    or network_is_moderator() then
        eFloodVariables.customMusic = true
        mod_storage_save_bool("customMusic", eFloodVariables.customMusic)
        eFloodVariables.spectatorMode = SPECTATOR_MODE_NORMAL
        mod_storage_save_number("spectatorMode", eFloodVariables.spectatorMode)
        romhackCam = true
        mod_storage_save_bool("romhackCam", romhackCam)
        romhackCamCollision = true
        mod_storage_save_bool("romhackCamCollision", romhackCamCollision)
        if network_is_server() then
            gGlobalSyncTable.popups = true
            mod_storage_save_bool("popups", gGlobalSyncTable.popups)
        end
        gGlobalSyncTable.popups = true
        mod_storage_save_bool("popups", gGlobalSyncTable.popups)
    end
end

local function reset_hud_settings()
    eHudVariables.levelDisplay = true
    mod_storage_save_bool("levelDisplay", eHudVariables.levelDisplay)
    eHudVariables.authorDisplay = true
    mod_storage_save_bool("authorDisplay", eHudVariables.authorDisplay)
    eHudVariables.modifiersDisplay = true
    mod_storage_save_bool("modifiersDisplay", eHudVariables.modifiersDisplay)
    eHudVariables.timeDisplay = true
    mod_storage_save_bool("timeDisplay", eHudVariables.timeDisplay)
    eHudVariables.leaderboard = true
    mod_storage_save_bool("leaderboard", eHudVariables.leaderboard)
    eHudVariables.healthMeter = true
    mod_storage_save_bool("healthMeter", eHudVariables.healthMeter)
    eHudVariables.font = FONT_MENU
    eHudVariables.levelScale = 0.20
    eHudVariables.authorScale = 0.15
    mod_storage_save_number("font", eHudVariables.font)
    mod_storage_save_number("levelScale", eHudVariables.levelScale)
    mod_storage_save_number("authorScale", eHudVariables.authorScale)
    eHudVariables.coinCounter = true
    mod_storage_save_bool("coinCounter", eHudVariables.coinCounter)
    eHudVariables.capDisplay = true
    mod_storage_save_bool("capDisplay", eHudVariables.capDisplay)
    eHudVariables.minimap = true
    mod_storage_save_bool("minimap", eHudVariables.minimap)
    eHudVariables.outlines = true
    mod_storage_save_bool("outlines", eHudVariables.outlines)
    eHudVariables.flagRadar = true
    mod_storage_save_bool("flagRadar", eHudVariables.flagRadar)
    eHudVariables.romhackLogos = true
    mod_storage_save_bool("romhackLogos", eHudVariables.romhackLogos)
    eHudVariables.tips = true
    mod_storage_save_bool("tips", eHudVariables.tips)
    eHudVariables.musicDisplay = true
    mod_storage_save_bool("musicDisplay", eHudVariables.musicDisplay)
    eHudVariables.typeDisplay = true
    mod_storage_save_bool("typeDisplay", eHudVariables.typeDisplay)
    eHudVariables.nextLevelIndicator = true
    mod_storage_save_bool("nextLevelIndicator", eHudVariables.nextLevelIndicator)
    eHudVariables.currentLevelIndicator = true
    mod_storage_save_bool("currentLevelIndicator", eHudVariables.currentLevelIndicator)
    eHudVariables.gamemodeText = true
    mod_storage_save_bool("gamemodeText", eHudVariables.gamemodeText)
end

local function disable_hud_settings()
    eHudVariables.levelDisplay = false
    mod_storage_save_bool("levelDisplay", eHudVariables.levelDisplay)
    eHudVariables.authorDisplay = false
    mod_storage_save_bool("authorDisplay", eHudVariables.authorDisplay)
    eHudVariables.modifiersDisplay = false
    mod_storage_save_bool("modifiersDisplay", eHudVariables.modifiersDisplay)
    eHudVariables.timeDisplay = false
    mod_storage_save_bool("timeDisplay", eHudVariables.timeDisplay)
    eHudVariables.leaderboard = false
    mod_storage_save_bool("leaderboard", eHudVariables.leaderboard)
    eHudVariables.healthMeter = false
    mod_storage_save_bool("healthMeter", eHudVariables.healthMeter)
    eHudVariables.coinCounter = false
    mod_storage_save_bool("coinCounter", eHudVariables.coinCounter)
    eHudVariables.capDisplay = false
    mod_storage_save_bool("capDisplay", eHudVariables.capDisplay)
    eHudVariables.minimap = false
    mod_storage_save_bool("minimap", eHudVariables.minimap)
    eHudVariables.outlines = false
    mod_storage_save_bool("outlines", eHudVariables.outlines)
    eHudVariables.flagRadar = false
    mod_storage_save_bool("flagRadar", eHudVariables.flagRadar)
    eHudVariables.romhackLogos = false
    mod_storage_save_bool("romhackLogos", eHudVariables.romhackLogos)
    eHudVariables.tips = false
    mod_storage_save_bool("tips", eHudVariables.tips)
    eHudVariables.musicDisplay = false
    mod_storage_save_bool("musicDisplay", eHudVariables.musicDisplay)
    eHudVariables.typeDisplay = false
    mod_storage_save_bool("typeDisplay", eHudVariables.typeDisplay)
    eHudVariables.nextLevelIndicator = false
    mod_storage_save_bool("nextLevelIndicator", eHudVariables.nextLevelIndicator)
    eHudVariables.currentLevelIndicator = false
    mod_storage_save_bool("currentLevelIndicator", eHudVariables.currentLevelIndicator)
    eHudVariables.gamemodeText = false
    mod_storage_save_bool("gamemodeText", eHudVariables.gamemodeText)
end

local function reset_extra_settings()
    eFloodVariables.welcomeMessage = true
    mod_storage_save_bool("welcomeMessage", eFloodVariables.welcomeMessage)
    capSparkles = true
    mod_storage_save_bool("capSparkles", capSparkles)
    warpSparkles = true
    mod_storage_save_bool("warpSparkles", warpSparkles)
    cinematicCamera = false
    cinematicBorders = false
end

local function reset_graphic_settings()
    eFloodVariables.scrollingFlood = true
    mod_storage_save_bool("scrollingFlood", eFloodVariables.scrollingFlood)
    eFloodVariables.trailParticleVisibility = true
    mod_storage_save_bool("trailParticleVisibility", eFloodVariables.trailParticleVisibility)
end

local function reset_server_settings()
    gGlobalSyncTable.pauseAnywhere = true
    mod_storage_save_bool("pauseAnywhere", gGlobalSyncTable.pauseAnywhere)
    gGlobalSyncTable.bubbleDeath = false
    mod_storage_save_bool("bubbleDeath", gGlobalSyncTable.bubbleDeath)
    gGlobalSyncTable.nametags = true
    mod_storage_save_bool("nametags", gGlobalSyncTable.nametags)
    gGlobalSyncTable.enablePlayersInLevelDisplay = false
    mod_storage_save_bool("enablePlayersInLevelDisplay", gGlobalSyncTable.enablePlayersInLevelDisplay)
    gGlobalSyncTable.enablePlayerList = true
    mod_storage_save_bool("enablePlayerList", gGlobalSyncTable.enablePlayerList)
end

local function reset_main_entries()
    local resetEntries = entries == mainEntries

    mainEntries = {
        {
            name = "Start",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = startEntries
                selection = 1
            end
        },
        {
            name = "Settings",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = settingEntries
                selection = 1
            end
        },
        {
            name = "Gamemodes",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = gamemodeEntries
                selection = 1
            end
        },
        {
            name = "Modifiers",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = modifierEntries
                selection = 1
            end
        },
        {
            name = "Romhacks",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                for categoryIndex, categoryName in pairs(romhackCategories) do
                    table.insert(categoryEntries, {
                        name = categoryName,
                        permission = PERMISSION_NONE,
                        input = INPUT_A,
                        func = function ()
                            entries = romhackEntries
                            category = categoryIndex
                            selection = 1
                        end,
                        separator = categoryIndex == 1 and "Categories" or nil
                    })
                end
                table.insert(categoryEntries, {
                    name = "Back",
                    permission = PERMISSION_NONE,
                    input = INPUT_A,
                    func = function ()
                        entries = mainEntries
                        selection = 1
                    end,
                    separator = "Total Romhacks: " .. totalRomhacks
                })
                entries = categoryEntries
                selection = 1
            end
        },
        {
            name = "Themes",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = themeEntries
                selection = 1
            end,
        },
        {
            name = "Manual",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = manualEntries
                selection = 1
            end
        },
        {
            name = "Credits",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = creditEntries
                selection = 1
            end
        },
        {
            name = "Close",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () showSettings = not showSettings end,
        },
    }

    if resetEntries then entries = mainEntries end
end

local function reset_modifier_entries()
    local resetModifierEntries = entries == modifierEntries

    pursuerSkin = {
        [SKIN_POISONSHROOM] = "Poisonshroom",
        [SKIN_GREENDEMON] = "Green Demon",
        [SKIN_ANGRYSUN] = "Angrysun"
    }

    pursuerSpeed = {
        [5] = "Slow",
        [15] = "Normal",
        [25] = "Fast"
    }

    modifierEntries = {
        {separator = "Modifiers",
        name = "Power-Ups",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_powerups,
        valueText = on_off_text(gGlobalSyncTable.modif_powerups),},
        {name = "Instakill",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_instakill,
        valueText = on_off_text(gGlobalSyncTable.modif_instakill),},
        {name = "Pursuit",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_pursuit,
        valueText = on_off_text(gGlobalSyncTable.modif_pursuit),},
        {name = "PvP",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_pvp,
        valueText = on_off_text(gGlobalSyncTable.modif_pvp),},
        {name = "Deathcoin",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_deathcoin,
        valueText = on_off_text(gGlobalSyncTable.modif_deathcoin),},
        {name = "Winboost",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_winboost,
        valueText = on_off_text(gGlobalSyncTable.modif_winboost),},
        {name = "Speed",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_speed,
        valueText = on_off_text(gGlobalSyncTable.modif_speed),},
        {name = "B Button Challenge",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_bbc,
        valueText = on_off_text(gGlobalSyncTable.modif_bbc),},
        {name = "Z Button Challenge",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_zbc,
        valueText = on_off_text(gGlobalSyncTable.modif_zbc),},
        {name = "Coin Rush",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_coinrush,
        valueText = on_off_text(gGlobalSyncTable.modif_coinrush),},
        {name = "Tripping",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_tripping,
        valueText = on_off_text(gGlobalSyncTable.modif_tripping),},
        {name = "Low Gravity",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_lowgravity,
        valueText = on_off_text(gGlobalSyncTable.modif_lowgravity),},
        {name = "High Gravity",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_highgravity,
        valueText = on_off_text(gGlobalSyncTable.modif_highgravity),},
        {name = "Flash Flood",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_flashflood,
        valueText = on_off_text(gGlobalSyncTable.modif_flashflood),},
        {name = "BLJ",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_blj,
        valueText = on_off_text(gGlobalSyncTable.modif_blj),},
        {name = "Capless",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_capless,
        valueText = on_off_text(gGlobalSyncTable.modif_capless),},
        {name = "Fly",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_fly,
        valueText = on_off_text(gGlobalSyncTable.modif_fly),},
        {name = "Slippery Floors",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_slippery_floors,
        valueText = on_off_text(gGlobalSyncTable.modif_slippery),},
        {name = "Hard Floors",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_hard_floors,
        valueText = on_off_text(gGlobalSyncTable.modif_hard),},
        {name = "Fog",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_fog,
        valueText = on_off_text(gGlobalSyncTable.modif_fog),},
        {name = "Inverted Controls",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_inverted,
        valueText = on_off_text(gGlobalSyncTable.modif_inverted),},
        {name = "Tornadoes",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_tornadoes,
        valueText = on_off_text(gGlobalSyncTable.modif_tornadoes),},
        {name = "Firsties",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_firsties,
        valueText = on_off_text(gGlobalSyncTable.modif_firsties),},
        {name = "Special Triple Jump",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_stj,
        valueText = on_off_text(gGlobalSyncTable.modif_stj),},
        {name = "Earthquake",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_earthquake,
        valueText = on_off_text(gGlobalSyncTable.modif_earthquake),},
        {separator = "Modifier Configurations",
        name = "Power-Up Coincount",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = set_coincount,
        valueText = math.floor(gGlobalSyncTable.coinCount)},
        {name = "Pursuer Skin",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = set_pursuer_skin,
        valueText = pursuerSkin[eTrollProperties.skin],
        disabled = pursuerSkin[eTrollProperties.skin] == nil},
        {name = "Pursuer Speed",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = set_pursuer_speed,
        valueText = pursuerSpeed[gGlobalSyncTable.pursuerSpeed]},		
        {name = "Reset Modifier Settings",
        permission = PERMISSION_MODERATORS,
        input = INPUT_A,
        func = reset_modifier_settings,},
        {name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = mainEntries
            selection = 1
        end,},
    }

    if resetModifierEntries then
        entries = modifierEntries
    end
end

local function reset_start_entries()
    local resetEntries = entries == startEntries

    startEntries = {
        {
            name = "Random",
            permission = PERMISSION_SERVER,
            input = INPUT_A,
            func = function ()
                gGlobalSyncTable.level = math.random(#gLevels)
                if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
                    network_send(true, { restart = true })
                    gGlobalSyncTable.level = math.random(#gLevels)
                    level_restart()
                    gGlobalSyncTable.totalRoundRestarts = 0
                else
                    gGlobalSyncTable.level = math.random(#gLevels)
                    round_start()
                    gGlobalSyncTable.totalRoundRestarts = 0
                end
                showSettings = false
            end
        }
    }

    for k in pairs(gLevels) do
        table.insert(startEntries, {
            name = name_of_level(gLevels[k].level, gLevels[k].area, gLevels[k].name, gLevels[k]),
            permission = PERMISSION_SERVER,
            input = INPUT_A,
            func = function ()
                gGlobalSyncTable.level = k
                if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
                    network_send(true, { restart = true })
                    level_restart()
                    gGlobalSyncTable.totalRoundRestarts = 0
                else
                    round_start()
                    gGlobalSyncTable.totalRoundRestarts = 0
                end
                showSettings = false
            end,
            separator = gLevels[k].separator ~= nil and gLevels[k].separator or nil
        })

        if k == 1 then
            startEntries[#startEntries].separator = FLOOD_LEVEL_COUNT .. " Levels"
        end
    end

    table.insert(startEntries, {
        name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = mainEntries
            selection = 1
        end
    })

    if resetEntries then entries = startEntries end
end

local function reset_gamemode_entries()
    local resetEntries = entries == gamemodeEntries

    gamemodeEntries = {}

    for k in pairs(gamemodes) do
        table.insert(gamemodeEntries, {
            name = gamemodes[k].name,
            permission = PERMISSION_SERVER,
            input = INPUT_A,
            func = function ()
                if gGlobalSyncTable.gamemode ~= k then
                    djui_popup_create_global("Set Gamemode to " .. gamemodes[k].name, 1)
                end
                gGlobalSyncTable.gamemode = k
                mod_storage_save_number("gamemode", gGlobalSyncTable.gamemode)
            end,
        })

        if k == 0 then
            gamemodeEntries[#gamemodeEntries].separator = "Gamemodes"
        end
    end

    table.insert(gamemodeEntries, {
        name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = mainEntries
            selection = 1
        end
    })

    if resetEntries then entries = gamemodeEntries end
end

local function reset_setting_selections()
    local resetEntries = entries == settingEntries

    settingEntries = {
        -- game settings
        {separator = "Settings",
        name = "Game Settings",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = gameEntries
            selection = 1
        end,
        valueText = ">",},
        -- general settings
        {name = "General Settings",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = generalEntries
            selection = 1
        end,
        valueText = ">",},
        -- hud settings
        {name = "Hud Settings",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = hudEntries
            selection = 1
        end,
        valueText = ">",},
        -- extra settings
        {name = "Extra Settings",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = extraEntries
            selection = 1
        end,
        valueText = ">",},
        -- graphic settings
        {name = "Graphic Settings",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = graphicEntries
            selection = 1
        end,
        valueText = ">",},
        -- server settings
        {name = "Server Settings",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = serverEntries
            selection = 1
        end,
        valueText = ">",},
        -- enemy settings
        {name = "Enemy Settings",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = enemyEntries
            selection = 1
        end,
        valueText = ">",},
        -- back selection
        {name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = mainEntries
            selection = 1
        end,},
    }

    if resetEntries then entries = settingEntries end
end

local function reset_game_selections()
    local resetGameEntries = entries == gameEntries

    local floodMapmode = {
        [0] = "Normal",
        [1] = "Random",
        [2] = "Voting"
    }

    local speedrunMode = {
        [SPEEDRUN_MODE_OFF] = "Off",
        [SPEEDRUN_MODE_PROGRESS] = "Progress",
        [SPEEDRUN_MODE_RESTART] = "Restart",
        [SPEEDRUN_MODE_MARATHON] = "Marathon"
    }

    gameEntries = {
        {separator = "Game Settings",
        name = "Flood Speed",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = set_flood_speed,
        valueText = math.floor(gGlobalSyncTable.speedMultiplier),},
        {name = "Flood Mapmode",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = set_mapmode,
        valueText = floodMapmode[gGlobalSyncTable.mapMode],},
        {name = "Hard Mode",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_hardmode,
        valueText = on_off_text(gGlobalSyncTable.hardMode),},
        {name = "Round Cooldown",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = set_round_cooldown,
        valueText = math.floor(gGlobalSyncTable.timer / 30),},
        {name = "Flood Difficulty",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = set_flood_difficulty,
        valueText = math.floor(gGlobalSyncTable.difficulty),},
        {name = "Speedrun Mode",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_speedrun,
        valueText = speedrunMode[speedrunner],},
        {name = "Auto Mode",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_auto_mode,
        valueText = on_off_text(gGlobalSyncTable.autoMode),},
        {name = "Flood Gravity",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_flood_gravity,
        valueText = on_off_text(gGlobalSyncTable.floodGravity),},
        {name = "Flood Interactions",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_flood_interactions,
        valueText = on_off_text(gGlobalSyncTable.floodInteractions),},			
        {name = "Lobby Powerups",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_lobby_powerups,
        valueText = on_off_text(gGlobalSyncTable.lobbyPowerups),},
        {name = "Lobby PvP",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_lobby_pvp,
        valueText = on_off_text(gGlobalSyncTable.lobbyPvp),},			
        {name = "Lobby Bosses",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_lobby_bosses,
        valueText = on_off_text(gGlobalSyncTable.lobbyBosses),},
        {name = "Kill If Inactive",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_kill_inactive,
        valueText = on_off_text(gGlobalSyncTable.killInactive),},
        {name = "Start Shortcut",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_start_shortcut,
        valueText = on_off_text(gGlobalSyncTable.startShortcut),},
        {name = "Start Bind",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = set_start_bind,
        valueText = startBinds[gGlobalSyncTable.startBind],},
        {name = "Round Fadeout",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_fadeout,
        valueText = on_off_text(gGlobalSyncTable.roundFadeout),},
        {name = "Quicksand",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_quicksand,
        valueText = on_off_text(gGlobalSyncTable.quicksand),
        disabled = gGlobalSyncTable.hardMode,},
        {name = "Slopejumps",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_slopejumps,
        valueText = on_off_text(gGlobalSyncTable.slopejumps),
        disabled = gGlobalSyncTable.hardMode,},
        {name = "Autodoors",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_autodoors,
        valueText = on_off_text(gGlobalSyncTable.autodoors),},
        {name = "Respawn",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_respawn,
        valueText = on_off_text(gGlobalSyncTable.respawn),},
        {name = "No Spectator",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_nospectator,
        valueText = on_off_text(gGlobalSyncTable.nospectator),},
        {name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = settingEntries
            selection = 1
        end,},
    }

    if resetGameEntries then
        entries = gameEntries
    end
end

local function reset_general_selections()
    local resetGeneralEntries = entries == generalEntries

    spectatorMode = {
        [SPECTATOR_MODE_NORMAL] = "Normal",
        [SPECTATOR_MODE_FOLLOW] = "Follow"
    }

    generalEntries = {
        {separator = "General Settings",
        name = "Custom Music",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = toggle_custom_music,
        valueText = on_off_text(eFloodVariables.customMusic),},
        {name = "Spectator Mode",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = set_spectator_mode,
        valueText = spectatorMode[eFloodVariables.spectatorMode],},
        {name = "Romhack Camera",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = toggle_romhack_cam,
        valueText = on_off_text(romhackCam),},
        {name = "Romhack Camera Collision",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = toggle_romhack_cam_cols,
        valueText = on_off_text(romhackCamCollision),},
        {name = "Holiday Events",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = toggle_holiday_events,
        valueText = on_off_text(eFloodVariables.holidayEvents),},
        {name = "Popups",
        permission = PERMISSION_MODERATORS,
        input = INPUT_JOYSTICK,
        func = toggle_popups,
        valueText = on_off_text(gGlobalSyncTable.popups),},
        {name = "Reset General Settings",
        permission = PERMISSION_MODERATORS,
        input = INPUT_A,
        func = reset_general_settings},
        {name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = settingEntries
            selection = 1
        end,},
    }

    if resetGeneralEntries then
        entries = generalEntries
    end
end

local function reset_theme_selections()
    local resetEntries = entries == themeEntries

    themeEntries = {
        {
            separator = "Themes",
            name = "Theme",
            permission = PERMISSION_NONE,
            input = INPUT_JOYSTICK,
            func = set_theme,
            valueText = get_selected_theme().name
        },
        {
            name = "Manage Themes",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = themeManagerEntries
                selection = 1
            end
        },
        {
            name = "Back",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = mainEntries
                selection = 1
            end,
        }
    }

    if resetEntries then entries = themeEntries end
end

local function reset_theme_manager_entries()
    local resetEntries = entries == themeManagerEntries

    local builtinThemes = 0
    for _, v in ipairs(floodThemes) do
        if v.builtin then
            builtinThemes = builtinThemes + 1
        end
    end

    themeManagerEntries = {
        {
            separator = "Theme Manager",
            name = "Create a Theme",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                local prevSelectedTheme = selectedTheme
                oldTheme = nil
                selectedTheme = #floodThemes + 1
                floodThemes[selectedTheme] = table.copy(floodThemes[prevSelectedTheme])
                floodThemes[selectedTheme].builtin = false
                entries = themeBuilderEntries
                selection = 1
            end,
            disabled = #floodThemes - builtinThemes >= 5
        },
    }

    for k, theme in ipairs(floodThemes) do
        if theme.builtin then goto continue end

        table.insert(themeManagerEntries, {
            name = theme.name,
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                selectedTheme = k
                oldTheme = table.copy(floodThemes[selectedTheme])
                entries = themeBuilderEntries
                selection = 1
            end
        })

        ::continue::
    end

    table.insert(themeManagerEntries, {
        name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = themeEntries
            selection = 1
        end
    })

    if resetEntries then entries = themeManagerEntries end
end

local function reset_theme_builder_entries()
    local resetEntries = entries == themeBuilderEntries
    local theme = get_selected_theme()

    themeBuilderEntries = {
        {
            separator = "Create a Theme",
            name = "Name",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                requestingThemeName = selectedTheme
                djui_chat_message_create("Type /flood [name] to input your name.")
            end,
            valueText = theme.name
        },
        {
            name = "Background",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.background) end,
            valueText = rgb_to_hex(theme.background.r, theme.background.g, theme.background.b)
        },
        {
            name = "Background Outline",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.backgroundOutline) end,
            valueText = rgb_to_hex(theme.backgroundOutline.r, theme.backgroundOutline.g, theme.backgroundOutline.b)
        },
        {
            name = "Rect",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.rect) end,
            valueText = rgb_to_hex(theme.rect.r, theme.rect.g, theme.rect.b)
        },
        {
            name = "Rect Outline",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.rectOutline) end,
            valueText = rgb_to_hex(theme.rectOutline.r, theme.rectOutline.g, theme.rectOutline.b)
        },
        {
            name = "Hover Rect",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.hoverRect) end,
            valueText = rgb_to_hex(theme.hoverRect.r, theme.hoverRect.g, theme.hoverRect.b)
        },
        {
            name = "Hover Rect Outline",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.hoverRectOutline) end,
            valueText = rgb_to_hex(theme.hoverRectOutline.r, theme.hoverRectOutline.g, theme.hoverRectOutline.b)
        },
        {
            name = "Text",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.text) end,
            valueText = rgb_to_hex(theme.text.r, theme.text.g, theme.text.b)
        },
        {
            name = "Selected Text",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.selectedText) end,
            valueText = rgb_to_hex(theme.selectedText.r, theme.selectedText.g, theme.selectedText.b)
        },
        {
            name = "Disabled Text",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.disabledText) end,
            valueText = rgb_to_hex(theme.disabledText.r, theme.disabledText.g, theme.disabledText.b)
        },
        {
            name = "Leaderboard",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.leaderboard, true) end,
            valueText = rgb_to_hex(theme.leaderboard.r, theme.leaderboard.g, theme.leaderboard.b)
        },
        {
            name = "Leaderboard Outline",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.leaderboardOutline) end,
            valueText = rgb_to_hex(theme.leaderboardOutline.r, theme.leaderboardOutline.g, theme.leaderboardOutline.b)
        },
        {
            name = "Minimap",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.minimap, true) end,
            valueText = rgb_to_hex(theme.minimap.r, theme.minimap.g, theme.minimap.b)
        },
        {
            name = "Minimap Outline",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.minimapOutline) end,
            valueText = rgb_to_hex(theme.minimapOutline.r, theme.minimapOutline.g, theme.minimapOutline.b)
        },
        {
            name = "Welcome Message",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.welcomeMessage, true) end,
            valueText = rgb_to_hex(theme.welcomeMessage.r, theme.welcomeMessage.g, theme.welcomeMessage.b)
        },
        {
            name = "Welcome Message Outline",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.welcomeMessageOutline, true) end,
            valueText = rgb_to_hex(theme.welcomeMessageOutline.r, theme.welcomeMessageOutline.g, theme.welcomeMessageOutline.b)
        },
        {
            name = "Pause Background",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function () create_rgb_slider(theme.pauseBackground, true) end,
            eText = rgb_to_hex(theme.pauseBackground.r, theme.pauseBackground.g, theme.pauseBackground.b)
        },
        {
            name = "Save",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                save_theme(selectedTheme)
                if mod_storage_load_number("theme") ~= nil then
                    selectedTheme = mod_storage_load_number("theme")
                else
                    selectedTheme = 1
                end
                entries = themeManagerEntries
                selection = 1
            end
        },
        {
            name = "Delete",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                local builtinThemes = 0
                for k, v in ipairs(floodThemes) do
                    if v.builtin then
                        builtinThemes = builtinThemes + 1
                    else
                        mod_storage_remove("theme_" .. k - builtinThemes)
                    end
                end
                table.remove(floodThemes, selectedTheme)
                for k, v in ipairs(floodThemes) do
                    if not v.builtin then
                        save_theme(k)
                    end
                end
                if mod_storage_load_number("theme") ~= nil then
                    selectedTheme = mod_storage_load_number("theme")
                else
                    selectedTheme = 1
                end
                if floodThemes[selectedTheme] == nil then
                    selectedTheme = 1
                end
                entries = themeManagerEntries
                selection = 1
            end
        }
    }

    if oldTheme ~= nil then
        table.insert(themeBuilderEntries, {
            name = "Cancel",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                floodThemes[selectedTheme] = oldTheme
                if mod_storage_load_number("theme") ~= nil then
                    selectedTheme = mod_storage_load_number("theme")
                else
                    selectedTheme = 1
                end
                entries = themeManagerEntries
                selection = 1
            end
        })
    end

    if resetEntries then
        entries = themeBuilderEntries
    else
        requestingThemeName = nil
    end
end

local function reset_rgb_slider_entries()
    local resetEntries = entries == rgbSliderEntries

    if rgbValue == nil then return end
    if previousRgbValue == nil then return end

    rgbSliderEntries = {
        {
            name = "R",
            permission = PERMISSION_NONE,
            input = INPUT_JOYSTICK,
            func = function ()
                rgbValue.r = set_color_value(rgbValue.r)
            end,
            valueText = rgbValue.r
        },
        {
            name = "G",
            permission = PERMISSION_NONE,
            input = INPUT_JOYSTICK,
            func = function ()
                rgbValue.g = set_color_value(rgbValue.g)
            end,
            valueText = rgbValue.g
        },
        {
            name = "B",
            permission = PERMISSION_NONE,
            input = INPUT_JOYSTICK,
            func = function ()
                rgbValue.b = set_color_value(rgbValue.b)
            end,
            valueText = rgbValue.b
        },
        {
            name = "A",
            permission = PERMISSION_NONE,
            input = INPUT_JOYSTICK,
            func = function ()
                rgbValue.a = set_color_value(rgbValue.a)
            end,
            valueText = rgbValue.a,
            disabled = not rgbAlphaEnabled
        },
        {
            name = "Hex",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                requestingThemeHex = true
                djui_chat_message_create("Type /flood [hexcode] to input your hex code.")
            end,
            valueText = rgb_to_hex(rgbValue.r, rgbValue.g, rgbValue.b),
        },
        {
            name = "Save",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = themeBuilderEntries
            end
        },
        {
            name = "Cancel",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                rgbValue.r = previousRgbValue.r
                rgbValue.g = previousRgbValue.g
                rgbValue.b = previousRgbValue.b
                rgbValue.a = previousRgbValue.a
                entries = themeBuilderEntries
            end
        },
    }

    if resetEntries then
        entries = rgbSliderEntries

        if requestingThemeHexCallback then
            local r, g, b = hex_to_rgb(requestingThemeHexCallback)
            rgbValue.r = r
            rgbValue.g = g
            rgbValue.b = b
            requestingThemeHexCallback = nil
        end
    else
        rgbValue = nil
        previousRgbValue = nil
        requestingThemeHexCallback = nil
    end
end

local function reset_hud_selections()
    local resetHudEntries = entries == hudEntries

    local fonts = {
        [FONT_MENU] = "Menu",
        [FONT_HUD] = "Hud",
        [FONT_NORMAL] = "Normal",
        [FONT_CUSTOM_HUD] = "Custom",
        [FONT_RECOLOR_HUD] = "Recolor",
        [FONT_ALIASED] = "Aliased",
        [FONT_SPECIAL] = "Special"
    }

    hudEntries = {
        {separator = "Hud Settings",
        name = "Level Display",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.levelDisplay = not eHudVariables.levelDisplay
            mod_storage_save_bool("levelDisplay", eHudVariables.levelDisplay)
        end,
        valueText = on_off_text(eHudVariables.levelDisplay),},
        {name = "Author Display",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.authorDisplay = not eHudVariables.authorDisplay
            mod_storage_save_bool("authorDisplay", eHudVariables.authorDisplay)
        end,
        valueText = on_off_text(eHudVariables.authorDisplay),},
        {name = "Modifiers Display",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.modifiersDisplay = not eHudVariables.modifiersDisplay
            mod_storage_save_bool("modifiersDisplay", eHudVariables.modifiersDisplay)
        end,
        valueText = on_off_text(eHudVariables.modifiersDisplay),},
        {name = "Time & Speed Display",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.timeDisplay = not eHudVariables.timeDisplay
            mod_storage_save_bool("timeDisplay", eHudVariables.timeDisplay)
        end,
        valueText = on_off_text(eHudVariables.timeDisplay),},
        {name = "Leaderboard",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.leaderboard = not eHudVariables.leaderboard
            mod_storage_save_bool("leaderboard", eHudVariables.leaderboard)
        end,
        valueText = on_off_text(eHudVariables.leaderboard),},
        {name = "Health Meter",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.healthMeter = not eHudVariables.healthMeter
            mod_storage_save_bool("healthMeter", eHudVariables.healthMeter)
        end,
        valueText = on_off_text(eHudVariables.healthMeter),},
        {name = "Font",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            local direction = get_controller_dir()

            if direction == CONT_LEFT then
                if eHudVariables.font == FONT_MENU then
                    eHudVariables.font = FONT_ALIASED
                    eHudVariables.levelScale = 0.4
                    eHudVariables.authorScale = 0.3
                elseif eHudVariables.font == FONT_ALIASED then
                    eHudVariables.font = FONT_SPECIAL
                    eHudVariables.levelScale = 0.4
                    eHudVariables.authorScale = 0.3
                elseif eHudVariables.font == FONT_SPECIAL then
                    eHudVariables.font = FONT_RECOLOR_HUD
                    eHudVariables.levelScale = 0.55
                    eHudVariables.authorScale = 0.40
                elseif eHudVariables.font == FONT_RECOLOR_HUD then
                    eHudVariables.font = FONT_CUSTOM_HUD
                    eHudVariables.levelScale = 0.55
                    eHudVariables.authorScale = 0.40
                elseif eHudVariables.font == FONT_CUSTOM_HUD then
                    eHudVariables.font = FONT_NORMAL
                    eHudVariables.levelScale = 0.4
                    eHudVariables.authorScale = 0.3
                elseif eHudVariables.font == FONT_NORMAL then
                    eHudVariables.font = FONT_HUD
                    eHudVariables.levelScale = 0.55
                    eHudVariables.authorScale = 0.40
                elseif eHudVariables.font == FONT_HUD then
                    eHudVariables.font = FONT_MENU
                    eHudVariables.levelScale = 0.20
                    eHudVariables.authorScale = 0.15
                end
            else
                if eHudVariables.font == FONT_MENU then
                    eHudVariables.font = FONT_HUD
                    eHudVariables.levelScale = 0.55
                    eHudVariables.authorScale = 0.40
                elseif eHudVariables.font == FONT_HUD then
                    eHudVariables.font = FONT_NORMAL
                    eHudVariables.levelScale = 0.4
                    eHudVariables.authorScale = 0.3
                elseif eHudVariables.font == FONT_NORMAL then
                    eHudVariables.font = FONT_CUSTOM_HUD
                    eHudVariables.levelScale = 0.55
                    eHudVariables.authorScale = 0.40
                elseif eHudVariables.font == FONT_CUSTOM_HUD then
                    eHudVariables.font = FONT_RECOLOR_HUD
                    eHudVariables.levelScale = 0.55
                    eHudVariables.authorScale = 0.40
                elseif eHudVariables.font == FONT_RECOLOR_HUD then
                    eHudVariables.font = FONT_SPECIAL
                    eHudVariables.levelScale = 0.4
                    eHudVariables.authorScale = 0.3
                elseif eHudVariables.font == FONT_SPECIAL then
                    eHudVariables.font = FONT_ALIASED
                    eHudVariables.levelScale = 0.4
                    eHudVariables.authorScale = 0.25
                elseif eHudVariables.font == FONT_ALIASED then
                    eHudVariables.font = FONT_MENU
                    eHudVariables.levelScale = 0.20
                    eHudVariables.authorScale = 0.15
                end
            end
            mod_storage_save_number("font", eHudVariables.font)
            mod_storage_save_number("levelScale", eHudVariables.levelScale)
            mod_storage_save_number("authorScale", eHudVariables.authorScale)
        end,
        valueText = fonts[eHudVariables.font],},
        {name = "Coin Counter",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.coinCounter = not eHudVariables.coinCounter
            mod_storage_save_bool("coinCounter", eHudVariables.coinCounter)
        end,
        valueText = on_off_text(eHudVariables.coinCounter),},
        {name = "Cap Display",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.capDisplay = not eHudVariables.capDisplay
            mod_storage_save_bool("capDisplay", eHudVariables.capDisplay)
        end,
        valueText = on_off_text(eHudVariables.capDisplay),},
        {name = "Minimap",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.minimap = not eHudVariables.minimap
            mod_storage_save_bool("minimap", eHudVariables.minimap)
        end,
        valueText = on_off_text(eHudVariables.minimap),},
        {name = "Outlines",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.outlines = not eHudVariables.outlines
            mod_storage_save_bool("outlines", eHudVariables.outlines)
        end,
        valueText = on_off_text(eHudVariables.outlines),},
        {name = "Flag Radar",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.flagRadar = not eHudVariables.flagRadar
            mod_storage_save_bool("flagRadar", eHudVariables.flagRadar)
        end,
        valueText = on_off_text(eHudVariables.flagRadar),},
        {name = "Romhack Logos",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.romhackLogos = not eHudVariables.romhackLogos
            mod_storage_save_bool("romhackLogos", eHudVariables.romhackLogos)
        end,
        valueText = on_off_text(eHudVariables.romhackLogos),},
        {name = "Tips",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.tips = not eHudVariables.tips
            mod_storage_save_bool("tips", eHudVariables.tips)
        end,
        valueText = on_off_text(eHudVariables.tips),},
        {name = "Music Display",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.musicDisplay = not eHudVariables.musicDisplay
            mod_storage_save_bool("musicDisplay", eHudVariables.musicDisplay)
        end,
        valueText = on_off_text(eHudVariables.musicDisplay),},
        {name = "Flood Type Display",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.typeDisplay = not eHudVariables.typeDisplay
            mod_storage_save_bool("typeDisplay", eHudVariables.typeDisplay)
        end,
        valueText = on_off_text(eHudVariables.typeDisplay),},
        {name = "Current Level Indicator",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.currentLevelIndicator = not eHudVariables.currentLevelIndicator
            mod_storage_save_bool("currentLevelIndicator", eHudVariables.currentLevelIndicator)
        end,
        valueText = on_off_text(eHudVariables.currentLevelIndicator),},
        {name = "Next Level Indicator",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.nextLevelIndicator = not eHudVariables.nextLevelIndicator
            mod_storage_save_bool("nextLevelIndicator", eHudVariables.nextLevelIndicator)
        end,
        valueText = on_off_text(eHudVariables.nextLevelIndicator),},
        {name = "Gamemode Text",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            eHudVariables.gamemodeText = not eHudVariables.gamemodeText
            mod_storage_save_bool("gamemodeText", eHudVariables.gamemodeText)
        end,
        valueText = on_off_text(eHudVariables.gamemodeText),},
        {name = "Disable All Hud",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = disable_hud_settings},
        {name = "Reset Hud Settings",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = reset_hud_settings},
        {name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = settingEntries
            selection = 1
        end,},
        separator = ""
    }

    if resetHudEntries then
        entries = hudEntries
    end
end

-- variables for eye states
local MARIO_EYES_DEFAULT = -1
local lockedEyeState = false
local customEyeState = MARIO_EYES_DEFAULT

-- variables for trail particles
local PARTICLE_NONE = 0
local lockedTrailParticle = false
local customTrailParticle = PARTICLE_NONE

local original_set_mario_particle_flags = set_mario_particle_flags

function set_mario_particle_flags(mario, particle, arg)
    if not eFloodVariables.trailParticleVisibility then
        return
    end
    original_set_mario_particle_flags(mario, particle, arg)
end

local function set_custom_trail_particle(newParticle)
    customTrailParticle = newParticle
    if customTrailParticle == PARTICLE_NONE then
        set_mario_particle_flags(gMarioStates[0], 0, 0)
    else
        set_mario_particle_flags(gMarioStates[0], customTrailParticle, 0)
    end
end

local function toggle_trail_particle_visibility()
    eFloodVariables.trailParticleVisibility = not eFloodVariables.trailParticleVisibility
    mod_storage_save_bool("trailParticleVisibility", eFloodVariables.trailParticleVisibility)
    if eFloodVariables.trailParticleVisibility then
        set_custom_trail_particle(customTrailParticle)
    else
        set_mario_particle_flags(gMarioStates[0], 0, 0)
    end
end

-- variables for run animations
local lockedRunAnimation = false
local customRunAnimation = 0

local function reset_extra_selections()
    local resetExtraEntries = entries == extraEntries

    eyeStates = {
        [MARIO_EYES_OPEN]         = "Open",
        [MARIO_EYES_HALF_CLOSED]  = "Half Closed",
        [MARIO_EYES_CLOSED]       = "Closed",
        [MARIO_EYES_BLINK]        = "Blink",
        [MARIO_EYES_LOOK_LEFT]    = "Look Left",
        [MARIO_EYES_LOOK_RIGHT]   = "Look Right",
        [MARIO_EYES_LOOK_UP]      = "Look Up",
        [MARIO_EYES_LOOK_DOWN]    = "Look Down",
        [MARIO_EYES_DEAD]         = "Dead",
        [MARIO_EYES_DEFAULT]      = "Default"
    }

    trailParticles = {
        [PARTICLE_SPARKLES] = "Sparkles",
        [PARTICLE_SNOW] = "Snow",
        [PARTICLE_LEAF] = "Leaves/Snowballs",
        [PARTICLE_DIRT] = "Dirt",
        [PARTICLE_DUST] = "Dust",
        [PARTICLE_FIRE] = "Fire",
        [PARTICLE_NONE] = "None",
        [PARTICLE_HORIZONTAL_STAR] = "Horizontal Stars",
        [PARTICLE_PLUNGE_BUBBLE] = "Plunge Bubbles",
        [PARTICLE_VERTICAL_STAR] = "Vertical Stars",
        [PARTICLE_BREATH] = "Breath",
        [PARTICLE_MIST_CIRCLE] = "Mist Circles",
        [PARTICLE_TRIANGLE] = "Triangles",
        [PARTICLE_BUBBLE] = "Bubbles"
    }

    runAnimations = {
        [0] = "Default",
        [1] = "Escape",
        [2] = "Beta",
        [3] = "Moonwalk",
        [4] = "Determined",
        [5] = "Chill",
        [6] = "Right Tilt",
        [7] = "Left Tilt",
        [8] = "Upside Down"
    }

    extraEntries = {
        {separator = "Extra Settings",
        name = "Welcome Message",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = toggle_welcomemsg,
        valueText = on_off_text(eFloodVariables.welcomeMessage),},
        {name = "Cap Sparkles",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = toggle_cap_sparkles,
        valueText = on_off_text(capSparkles),},
        {name = "Warp Sparkles",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = toggle_warp_sparkles,
        valueText = on_off_text(warpSparkles),},
        {name = "Cinematic Camera",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = toggle_cinematic_camera,
        valueText = on_off_text(cinematicCamera),},
        {name = "Cinematic Borders",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = toggle_cinematic_borders,
        valueText = on_off_text(cinematicBorders),},
        {name = "Run Animation",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            local direction = get_controller_dir()
            if direction == CONT_LEFT then
                if customRunAnimation == 0 then
                    customRunAnimation = 1
                elseif customRunAnimation == 1 then
                    customRunAnimation = 2
                elseif customRunAnimation == 2 then
                    customRunAnimation = 3
                elseif customRunAnimation == 3 then
                    customRunAnimation = 4
                elseif customRunAnimation == 4 then
                    customRunAnimation = 5
                elseif customRunAnimation == 5 then
                    customRunAnimation = 6
                elseif customRunAnimation == 6 then
                    customRunAnimation = 7
                elseif customRunAnimation == 7 then
                    customRunAnimation = 8
                elseif customRunAnimation == 8 then
                    customRunAnimation = 0
                else
                    customRunAnimation = 0
                end

            else
                if customRunAnimation == 0 then
                    customRunAnimation = 8
                elseif customRunAnimation == 8 then
                    customRunAnimation = 7
                elseif customRunAnimation == 7 then
                    customRunAnimation = 6
                elseif customRunAnimation == 6 then
                    customRunAnimation = 5
                elseif customRunAnimation == 5 then
                    customRunAnimation = 4
                elseif customRunAnimation == 4 then
                    customRunAnimation = 3
                elseif customRunAnimation == 3 then
                    customRunAnimation = 2
                elseif customRunAnimation == 2 then
                    customRunAnimation = 1
                elseif customRunAnimation == 1 then
                    customRunAnimation = 0
                else
                    customRunAnimation = 0
                end
            end
    
            if customRunAnimation == 0 then
                lockedRunAnimation = false
            else
                lockedRunAnimation = true
            end
        end,
        valueText = runAnimations[customRunAnimation]},
        {name = "Eye State",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            local direction = get_controller_dir()
            if direction == CONT_LEFT then
                if customEyeState == MARIO_EYES_OPEN then
                    customEyeState = MARIO_EYES_HALF_CLOSED
                elseif customEyeState == MARIO_EYES_HALF_CLOSED then
                    customEyeState = MARIO_EYES_CLOSED
                elseif customEyeState == MARIO_EYES_CLOSED then
                    customEyeState = MARIO_EYES_BLINK
                elseif customEyeState == MARIO_EYES_BLINK then
                    customEyeState = MARIO_EYES_LOOK_LEFT
                elseif customEyeState == MARIO_EYES_LOOK_LEFT then
                    customEyeState = MARIO_EYES_LOOK_RIGHT
                elseif customEyeState == MARIO_EYES_LOOK_RIGHT then
                    customEyeState = MARIO_EYES_LOOK_UP
                elseif customEyeState == MARIO_EYES_LOOK_UP then
                    customEyeState = MARIO_EYES_LOOK_DOWN
                elseif customEyeState == MARIO_EYES_LOOK_DOWN then
                    customEyeState = MARIO_EYES_DEAD
                elseif customEyeState == MARIO_EYES_DEAD then
                    customEyeState = MARIO_EYES_DEFAULT
                elseif customEyeState == MARIO_EYES_DEFAULT then
                    customEyeState = MARIO_EYES_OPEN
                else
                    customEyeState = MARIO_EYES_OPEN
                end

                if customEyeState == MARIO_EYES_DEFAULT then
                    lockedEyeState = false
                else
                    lockedEyeState = true
                    gMarioStates[0].marioBodyState.eyeState = customEyeState
                end
            else
                if customEyeState == MARIO_EYES_OPEN then
                    customEyeState = MARIO_EYES_DEFAULT
                elseif customEyeState == MARIO_EYES_DEFAULT then
                    customEyeState = MARIO_EYES_DEAD
                elseif customEyeState == MARIO_EYES_DEAD then
                    customEyeState = MARIO_EYES_LOOK_DOWN
                elseif customEyeState == MARIO_EYES_LOOK_DOWN then
                    customEyeState = MARIO_EYES_LOOK_UP
                elseif customEyeState == MARIO_EYES_LOOK_UP then
                    customEyeState = MARIO_EYES_LOOK_RIGHT
                elseif customEyeState == MARIO_EYES_LOOK_RIGHT then
                    customEyeState = MARIO_EYES_LOOK_LEFT
                elseif customEyeState == MARIO_EYES_LOOK_LEFT then
                    customEyeState = MARIO_EYES_BLINK
                elseif customEyeState == MARIO_EYES_BLINK then
                    customEyeState = MARIO_EYES_CLOSED
                elseif customEyeState == MARIO_EYES_CLOSED then
                    customEyeState = MARIO_EYES_HALF_CLOSED
                elseif customEyeState == MARIO_EYES_HALF_CLOSED then
                    customEyeState = MARIO_EYES_DEFAULT
                else
                    customEyeState = MARIO_EYES_OPEN
                end

                if customEyeState == MARIO_EYES_DEFAULT then
                    lockedEyeState = false
                else
                    lockedEyeState = true
                    gMarioStates[0].marioBodyState.eyeState = customEyeState
                end
            end
        end,
        valueText = (customEyeState == MARIO_EYES_DEFAULT) and "Default" or eyeStates[customEyeState],},
        {name = "Trail Particles",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = function ()
            local direction = get_controller_dir()
            if direction == CONT_LEFT then
                if customTrailParticle == PARTICLE_SPARKLES then
                    customTrailParticle = PARTICLE_SNOW
                elseif customTrailParticle == PARTICLE_SNOW then
                    customTrailParticle = PARTICLE_LEAF
                elseif customTrailParticle == PARTICLE_LEAF then
                    customTrailParticle = PARTICLE_DIRT
                elseif customTrailParticle == PARTICLE_DIRT then
                    customTrailParticle = PARTICLE_DUST
                elseif customTrailParticle == PARTICLE_DUST then
                    customTrailParticle = PARTICLE_FIRE
                elseif customTrailParticle == PARTICLE_FIRE then
                    customTrailParticle = PARTICLE_NONE
                elseif customTrailParticle == PARTICLE_NONE then
                    customTrailParticle = PARTICLE_HORIZONTAL_STAR
                elseif customTrailParticle == PARTICLE_HORIZONTAL_STAR then
                    customTrailParticle = PARTICLE_PLUNGE_BUBBLE
                elseif customTrailParticle == PARTICLE_PLUNGE_BUBBLE then
                    customTrailParticle = PARTICLE_VERTICAL_STAR
                elseif customTrailParticle == PARTICLE_VERTICAL_STAR then
                    customTrailParticle = PARTICLE_BREATH
                elseif customTrailParticle == PARTICLE_BREATH then
                    customTrailParticle = PARTICLE_MIST_CIRCLE
                elseif customTrailParticle == PARTICLE_MIST_CIRCLE then
                    customTrailParticle = PARTICLE_TRIANGLE
                elseif customTrailParticle == PARTICLE_TRIANGLE then
                    customTrailParticle = PARTICLE_BUBBLE
                elseif customTrailParticle == PARTICLE_BUBBLE then
                    customTrailParticle = PARTICLE_SPARKLES
                else
                    customTrailParticle = PARTICLE_NONE
                end
                lockedTrailParticle = true
                set_custom_trail_particle(customTrailParticle)
            else
                if customTrailParticle == PARTICLE_SPARKLES then
                    customTrailParticle = PARTICLE_BUBBLE
                elseif customTrailParticle == PARTICLE_BUBBLE then
                    customTrailParticle = PARTICLE_TRIANGLE
                elseif customTrailParticle == PARTICLE_TRIANGLE then
                    customTrailParticle = PARTICLE_MIST_CIRCLE
                elseif customTrailParticle == PARTICLE_MIST_CIRCLE then
                    customTrailParticle = PARTICLE_BREATH
                elseif customTrailParticle == PARTICLE_BREATH then
                    customTrailParticle = PARTICLE_VERTICAL_STAR
                elseif customTrailParticle == PARTICLE_VERTICAL_STAR then
                    customTrailParticle = PARTICLE_PLUNGE_BUBBLE
                elseif customTrailParticle == PARTICLE_PLUNGE_BUBBLE then
                    customTrailParticle = PARTICLE_HORIZONTAL_STAR
                elseif customTrailParticle == PARTICLE_HORIZONTAL_STAR then
                    customTrailParticle = PARTICLE_NONE
                elseif customTrailParticle == PARTICLE_NONE then
                    customTrailParticle = PARTICLE_FIRE
                elseif customTrailParticle == PARTICLE_FIRE then
                    customTrailParticle = PARTICLE_DUST
                elseif customTrailParticle == PARTICLE_DUST then
                    customTrailParticle = PARTICLE_DIRT
                elseif customTrailParticle == PARTICLE_DIRT then
                    customTrailParticle = PARTICLE_LEAF
                elseif customTrailParticle == PARTICLE_LEAF then
                    customTrailParticle = PARTICLE_SNOW
                elseif customTrailParticle == PARTICLE_SNOW then
                    customTrailParticle = PARTICLE_SPARKLES
                else
                    customTrailParticle = PARTICLE_NONE
                end
                lockedTrailParticle = true
                set_custom_trail_particle(customTrailParticle)
            end
        end,
        valueText = trailParticles[customTrailParticle]},
        {name = "Reset Extra Settings",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = reset_extra_settings},
        {name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = settingEntries
            selection = 1
        end},
    }

    if resetExtraEntries then
        entries = extraEntries
    end
end

local function reset_graphic_selections()
    local resetGraphicEntries = entries == graphicEntries

    graphicEntries = {
        {separator = "Graphic Settings",
        name = "Scrolling Flood",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = toggle_scrollingflood,
        valueText = on_off_text(eFloodVariables.scrollingFlood),},
        {name = "Trail Particle Visibility",
        permission = PERMISSION_NONE,
        input = INPUT_JOYSTICK,
        func = toggle_trail_particle_visibility,
        valueText = on_off_text(eFloodVariables.trailParticleVisibility),},
        {name = "Reset Graphic Settings",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = reset_graphic_settings},
        {name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = settingEntries
            selection = 1
        end}
    }

    if resetGraphicEntries then
        entries = graphicEntries
    end
end

local function reset_server_selections()
    local resetServerEntries = entries == serverEntries

    local knockbackStrengthNames = {
        [10] = "Weak",
        [25] = "Normal",
        [60] = "Too much"
    }

    local pvpTypeNames = {
        [0] = "Classic",
        [1] = "Revamped"
    }

    local bouncyLevelBoundsNames = {
        [0] = "Off",
        [1] = "On",
        [2] = "On (Capped)"
    }

    serverEntries = {
        {
            separator = "Server Settings",
            name = "Knockback Strength",
            permission = PERMISSION_MODERATORS,
            input = INPUT_JOYSTICK,
            func = function ()
                local direction = get_controller_dir()
                if direction == CONT_LEFT then
                    if gServerSettings.playerKnockbackStrength == 10 then
                        gServerSettings.playerKnockbackStrength = 60
                    elseif gServerSettings.playerKnockbackStrength == 60 then
                        gServerSettings.playerKnockbackStrength = 25
                    elseif gServerSettings.playerKnockbackStrength == 25 then
                        gServerSettings.playerKnockbackStrength = 10
                    end
                else
                    if gServerSettings.playerKnockbackStrength == 10 then
                        gServerSettings.playerKnockbackStrength = 25
                    elseif gServerSettings.playerKnockbackStrength == 25 then
                        gServerSettings.playerKnockbackStrength = 60
                    elseif gServerSettings.playerKnockbackStrength == 60 then
                        gServerSettings.playerKnockbackStrength = 10
                    end
                end
            end,
            valueText = knockbackStrengthNames[gServerSettings.playerKnockbackStrength]
        },
        {
            name = "PvP Mode",
            permission = PERMISSION_MODERATORS,
            input = INPUT_JOYSTICK,
            func = function ()
                if gServerSettings.pvpType == 0 then
                    gServerSettings.pvpType = 1
                else
                    gServerSettings.pvpType = 0
                end
            end,
            valueText = pvpTypeNames[gServerSettings.pvpType]
        },
        {
            name = "Bouncy Level Bounds",
            permission = PERMISSION_MODERATORS,
            input = INPUT_JOYSTICK,
            func = function ()
                local direction = get_controller_dir()
                if direction == CONT_LEFT then
                    if gServerSettings.bouncyLevelBounds == 0 then
                        gServerSettings.bouncyLevelBounds = 1
                    elseif gServerSettings.bouncyLevelBounds == 1 then
                        gServerSettings.bouncyLevelBounds = 2
                    elseif gServerSettings.bouncyLevelBounds == 2 then
                        gServerSettings.bouncyLevelBounds = 0
                    end
                else
                    if gServerSettings.bouncyLevelBounds == 0 then
                        gServerSettings.bouncyLevelBounds = 2
                    elseif gServerSettings.bouncyLevelBounds == 1 then
                        gServerSettings.bouncyLevelBounds = 0
                    elseif gServerSettings.bouncyLevelBounds == 2 then
                        gServerSettings.bouncyLevelBounds = 1
                    end
                end
            end,
            valueText = bouncyLevelBoundsNames[gServerSettings.bouncyLevelBounds]
        },
        {
            name = "Pause Anywhere",
            permission = PERMISSION_MODERATORS,
            input = INPUT_JOYSTICK,
            func = toggle_pauseanywhere,
            valueText = on_off_text(gGlobalSyncTable.pauseAnywhere)
        },
        {
            name = "Bubble On Death",
            permission = PERMISSION_MODERATORS,
            input = INPUT_JOYSTICK,
            func = toggle_bubbledeath,
            valueText = on_off_text(gGlobalSyncTable.bubbleDeath)
        },
        {
            name = "Nametags",
            permission = PERMISSION_MODERATORS,
            input = INPUT_JOYSTICK,
            func = toggle_nametags,
            valueText = on_off_text(gGlobalSyncTable.nametags)
        },
        {
            name = "Enable Players In Level Display",
            permission = PERMISSION_MODERATORS,
            input = INPUT_JOYSTICK,
            func = toggle_enableplayersinleveldisplay,
            valueText = on_off_text(gGlobalSyncTable.enablePlayersInLevelDisplay)
        },
        {
            name = "Enable Player List",
            permission = PERMISSION_MODERATORS,
            input = INPUT_JOYSTICK,
            func = toggle_enableplayerlist,
            valueText = on_off_text(gGlobalSyncTable.enablePlayerList)
        },
        {
            name = "Reset Server Settings",
            permission = PERMISSION_MODERATORS,
            input = INPUT_A,
            func = reset_server_settings
        },
        {
            name = "Back",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = settingEntries
                selection = 1
            end
        },
    }

    if resetServerEntries then
        entries = serverEntries
    end
end

local function reset_enemy_selections()
    local resetEntries = entries == enemyEntries

    enemyEntries = {}

    for _, enemy in pairs(enemies) do
        table.insert(enemyEntries, {
            name = enemy.name,
            permission = PERMISSION_SERVER,
            input = INPUT_JOYSTICK,
            func = function ()
                enemy.active = not enemy.active
            end,
            valueText = on_off_text(enemy.active),
            separator = _ == 1 and "Enemy Settings" or nil
        })
    end

    table.insert(enemyEntries, {
        name = "Reset To Default",
        permission = PERMISSION_SERVER,
        input = INPUT_A,
        func = function ()
            for _, enemy in pairs(enemies) do
                enemy.active = enemy.default
            end
        end
    })

    table.insert(enemyEntries, {
        name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = settingEntries
            selection = 1
        end
    })

    if resetEntries then
        entries = enemyEntries
    end
end

local function reset_romhack_entries()
    local resetRomhackEntries = entries == romhackEntries
    local romhacks = {
        {
            name = "Astral Dimension",
            categories = { ALL, NORMAL, CASUAL, SHORT },
            romhackAuthor = "MrCountryfruit",
            floodPorter = "Bomboclath",
            coopPorter = "Asra"
        },
        {
            name = "B3313",
            categories = { ALL, NORMAL, CASUAL, LONG },
            romhackAuthor = "ChrisRLillo",
            floodPorter = "~!TONO!~",
            coopPorter = "TikalSM64 & Blocky.cmd"
        },
        {
            name = "Beat Block Beatdown",
            categories = { ALL, HARD, SHORT },
            romhackAuthor = "usernamesarespiders",
            floodPorter = "SausRelics",
            coopPorter = "Fearl"
        },
        {
            name = "Blossoming Bluds",
            categories = { ALL, NORMAL, CASUAL, SHORT },
            romhackAuthor = "usernamesarespiders",
            floodPorter = "Jzzay",
            coopPorter = "Fearl"
        },
        {
            name = "Bowser's Dank Rave",
            categories = { ALL, MEME, BOWSERS_DANK_RAVE },
            romhackAuthor = "pieordie1",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "BDR 2: Return of the Illuminati Dubstep Party",
            categories = { ALL, MEME, BOWSERS_DANK_RAVE },
            romhackAuthor = "pieordie1",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Bowser's Dank Rave 3: Toadette's MLG Expansion",
            categories = { ALL, MEME, BOWSERS_DANK_RAVE },
            romhackAuthor = "pieordie1",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Brutal Mario 64",
            categories = { ALL, KAIZO, SHORT },
            romhackAuthor = "LinCrash",
            floodPorter = "Jzzay",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Classic Skylands",
            categories = { ALL, NORMAL, CASUAL, SHORT },
            romhackAuthor = "Tomatobird8",
            floodPorter = "Jzzay",
            coopPorter = "Sunk"
        },
        {
            name = "Compact Challenges 1",
            categories = { ALL, HARD, SHORT },
            romhackAuthor = "IwerSonsch",
            floodPorter = "~!TONO!~",
        },
        {
            name = "Convenient Conceit Coffin",
            categories = { ALL, KAIZO, SHORT },
            romhackAuthor = "mokkyun",
            floodPorter = "[TBD]",
            coopPorter = "Sunk"	
        },
        {
            name = "Creepy Canyon",
            categories = { ALL, CASUAL, SHORT },
            romhackAuthor = "djoslin0",
            floodPorter = "Jzzay",
            coopPorter = "[PC Port Exclusive]"
        },
        {
            name = "Cursed Winter Forest",
            categories = { ALL, ULTRA_KAIZO, SHORT },
            romhackAuthor = "Morningstorm SM64",
            floodPorter = "Jzzay",
            coopPorter = "Sunk"
        },
        {
            name = "Deadly Gas Mines",
            categories = { ALL, KAIZO, SHORT },
            romhackAuthor = "MorningStorm64 & thebloody7",
            floodPorter = "[TBD]",
            coopPorter = "Sunk"
        },
        {
            name = "Despair Mario's Gambit 64",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "GmdDoesDMG",
            floodPorter = "Bear64DX & Jzzay",
            coopPorter = "Sunk"
        },
        {
            name = "Diorama of Extreme Shenanigans 64",
            categories = { ALL, NORMAL, LIGHT_KAIZO, SHORT },
            romhackAuthor = "GmdDoesDMG",
            floodPorter = "~!TONO!~",
            coopPorter = "Sunk"
        },
        {
            name = "Dream 64",
            categories = { ALL, NORMAL, CASUAL, SHORT },
            romhackAuthor = "SonicandMarioGames1985",
            floodPorter = "Bear64DX & Jzzay",
            coopPorter = "TikalSM64"
        },
        {
            name = "Eternal Realm",
            categories = { ALL, LIGHT_KAIZO },
            romhackAuthor = "SomeBro",
            floodPorter = "~!TONO!~",
            coopPorter = "Sunk"
        },
        {
            name = "Eureka",
            categories = { ALL, CASUAL },
            romhackAuthor = "GooseDaJuice",
            floodPorter = "~!TONO!~",
            coopPorter = "Fearl"
        },
        {
            name = "Fractured Multiverse",
            categories = { ALL, KAIZO, LONG },
            romhackAuthor = "Team Vortex",
            floodPorter = "SuperRodrigo0",
            coopPorter = "Sunk & Fearl"
        },
        {
            name = "Gamer Mario's Destiny 64",
            categories = { ALL, NORMAL, SHORT },
            romhackAuthor = "GmdDoesDMG",
            floodPorter = "Bear64DX",
            coopPorter = "Woissil"
        },
        {
            name = "Katze Stuck in the Toilet 64",
            categories = { ALL, MEME },
            romhackAuthor = "Tomatobird8",
            floodPorter = "~!TONO!~",
            coopPorter = "Sunk"
        },
        {
            name = "Kaizo Mario 64",
            categories = { ALL, VANILLA_EDITS, LIGHT_KAIZO },
            romhackAuthor = "OmegaEdge29",
            floodPorter = "~!TONO!~",
            coopPorter = "Shai Guy"
        },
        {
            name = "Kaizo Mario 64 2",
            categories = { ALL, VANILLA_EDITS, LIGHT_KAIZO },
            romhackAuthor = "MarvMario & MrMarioTendo",
            floodPorter = "~!TONO!~",
            coopPorter = "Asra"
        },
        {
            name = "King Boo's Revenge 2",
            categories = { ALL, KAIZO },
            romhackAuthor = "sizzilingmario4 & thebloody7",
            floodPorter = "Jzzay, Bear64DX & ~!TONO!~",
            coopPorter = "Sunk"
        },
        {
            name = "Land94",
            categories = { ALL, NORMAL, EASY },
            romhackAuthor = "Beta Penguin 64",
            floodPorter = "Bear64DX",
            coopPorter = "Velipe Crack 21"
        },
        {
            name = "Lavabounce Challenge",
            categories = { ALL, KAIZO, SHORT },
            romhackAuthor = "Redmat527",
            floodPorter = "Jzzay",
            coopPorter = "Sunk"
        },
        {
            name = "Lava Lava Lava Lava",
            categories = { ALL, KAIZO, SHORT },
            romhackAuthor = "Tomatobird8",
            floodPorter = "Jzzay",
            coopPorter = "Sunk"
        },
        {
            name = "Lug's Delightful Dioramas",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Lugmillord",
            floodPorter = "~!TONO!~",
            coopPorter = "PeachyPeach"
        },
        {
            name = "Luigi's Mansion 64",
            categories = { ALL, VANILLA_EDITS, EASY },
            romhackAuthor = "LinCrash",
            floodPorter = "Jzzay",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Luigi's Mansion 64.5 [Easy Mode]",
            categories = { ALL, VANILLA_EDITS, EASY },
            romhackAuthor = "LinCrash",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Luigi's Mansion 64.5 [Super Player Mode]",
            categories = { ALL, VANILLA_EDITS, HARD },
            romhackAuthor = "LinCrash",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Luigi and the Forest Ruins",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "LinCrash & TheGael95",
            floodPorter = "Jzzay",
            coopPorter = "Mr.Needlemouse"
        },
        {
            name = "Luigi and the Violet Stars",
            categories = { ALL, NORMAL, CASUAL},
            romhackAuthor = "usernamesarespiders",
            floodPorter = "Bear64DX",
            coopPorter = "Fearl"
        },
        {
            name = "Mario's Maze Adventure",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Cryogeon",
            floodPorter = "Bomboclath",
            coopPorter = "Asra"
        },
        {
            name = "Mario's Nightmare 64",
            categories = { ALL, HARD },
            romhackAuthor = "Apioeus",
            floodPorter = "Bear64DX & Jzzay",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Mario's Treasure Dome",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Galacta",
            floodPorter = "Bear64DX",
            coopPorter = "Asra"
        },
        {
            name = "Mario in the Colorful Lands",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "BlueToonYoshi",
            floodPorter = "SausRelics",
            coopPorter = "Fearl"
        },
        {
            name = "Mario in the Dreamscape",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Angry",
            floodPorter = "Jzzay",
            coopPorter = "Fearl"
        },
        {
            name = "Mario Heroes 64",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "aglab2",
            floodPorter = "~!TONO!~",
            coopPorter = "Lukas"
        },
        {
            name = "Momentum Testing",
            categories = { ALL, KAIZO },
            romhackAuthor = "IwerSonsch & PhantoFantasma",
            floodPorter = "Jzzay",
            coopPorter = "Sunk"
        },
        {
            name = "Muhly 64",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "just_eh_cupcake",
            floodPorter = "Jzzay",
            coopPorter = "just_eh_cupcake"
        },
        {
            name = "Nice Mario 75",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "AirMate",
            floodPorter = "SuperRodrigo0",
            coopPorter = "Asra"
        },
        {
            name = "Omega Mario 64",
            categories = { ALL, NORMAL, HARD },
            romhackAuthor = "Omega_Merk",
            floodPorter = "SuperRodrigo0",
            coopPorter = "Fearl"
        },
        {
            name = "Peach's Fury",
            categories = { ALL, CASUAL },
            romhackAuthor = "Kaze Emanuar",
            floodPorter = "Bomboclath",
            coopPorter = "I'mYourCat2 and his Team"
        },
        {
            name = "Project Reimagined",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Mr.Needlemouse",
            floodPorter = "~!TONO!~",
            coopPorter = "[PC Port Exclusive]"
        },
        {
            name = "Refined Buffed Paradox",
            categories = { ALL, NORMAL, ULTRA_KAIZO },
            romhackAuthor = "MorningStorm64, thebloody7 & sizzilingmario4",
            floodPorter = "[TBD]",
            coopPorter = "Sunk"
        },
        {
            name = "Return to Retroland",
            categories = { ALL, NORMAL, CASUAL, SHORT },
            romhackAuthor = "cpuHacka101",
            floodPorter = "SuperRodrigo0",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Roblox 64",
            categories = { ALL, EASY },
            romhackAuthor = "SwiftySky",
            floodPorter = "Bomboclath",
            coopPorter = "Dragonary"
        },
        {
            name = "Super Mario 64: Rocky Mountain Revisited",
            categories = { ALL, NORMAL, CASUAL, SHORT },
            romhackAuthor = "DavidHolandaOne",
            floodPorter = "~!TONO!~",
            coopPorter = "Velipe Crack 21"
        },
        {
            name = "Scrooge 64",
            categories = { ALL, NORMAL, CASUAL, SHORT },
            romhackAuthor = "Kinopio",
            floodPorter = "Jzzay",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Senseless Delirium",
            categories = { ALL, NORMAL, LIGHT_KAIZO },
            romhackAuthor = "Redmat527",
            floodPorter = "~!TONO!~",
            coopPorter = "Sunk"
        },
        {
            name = "Servus 64",
            categories = { ALL, KAIZO },
            romhackAuthor = "NBKevin98",
            floodPorter = "Jzzay",
            coopPorter = "Sunk"
        },
        {
            name = "Shining Stars 2: Mirror Madness",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "sm64pie",
            floodPorter = "~!TONO!~",
            coopPorter = "Fearl"
        },
        {
            name = "Slope Challenge",
            categories = { ALL, KAIZO, SHORT },
            romhackAuthor = "Redmat527",
            floodPorter = "Jzzay",
        },
        {
            name = "SM64 Last Impact",
            categories = { ALL, CASUAL },
            romhackAuthor = "Kaze Emanuar",
            floodPorter = "Bear64DX",
            coopPorter = "I'mYourCat2 and his Team"
        },
        {
            name = "SM64 Madness",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Kaze Emanuar",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "SM64 Masters' Challenge",
            categories = { ALL, KAIZO },
            romhackAuthor = "TheGael95 & WWMResident",
            floodPorter = "Bear64DX & SuperRodrigo0",
            coopPorter = "Blocky.cmd"
        },
        {
            name = "SM64 Paradise Island",
            categories = { ALL, NORMAL, CASUAL, SHORT },
            romhackAuthor = "Leonitz",
            floodPorter = "Bear64DX",
            coopPorter = "wRadion & LeonixGamerIII"
        },
        {
            name = "SM64 Royal Legacy",
            categories = { ALL, CASUAL, SHORT },
            romhackAuthor = "StunningCactus",
            floodPorter = "SuperRodrigo0",
            coopPorter = "EmeraldLockdown"
        },
        {
            name = "SM64 Sapphire",
            categories = { ALL, NORMAL, EASY, SHORT },
            romhackAuthor = "Nebula",
            floodPorter = "Jzzay",
            coopPorter = "Chilly"
        },
        {
            name = "SM64 Shining Stars",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "sm64pie",
            floodPorter = "SausRelics & ~!TONO!~",
            coopPorter = "Fearl"
        },
        {
            name = "SM64 The Black Virus",
            categories = { ALL, ULTRA_KAIZO },
            romhackAuthor = "NormalX71",
            floodPorter = "SuperRodrigo0",
            coopPorter = "Fearl"
        },
        {
            name = "SM64 - Twisted Adventures",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "SomeRussianMarioDude",
            floodPorter = "SuperRodrigo0",
            coopPorter = "BlackJoystick"
        },
        {
            name = "SM64 - Twisted Adventures 2",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "SomeRussianMarioDude",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "SM64: Bowser's Beach",
            categories = { ALL, NORMAL, CASUAL, SHORT },
            romhackAuthor = "Halo",
            floodPorter = "Jzzay",
            coopPorter = "BlackJoystick"
        },
        {
            name = "SM64: It's a Crash!",
            categories = { ALL, CASUAL },
            romhackAuthor = "LinCrash",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "SM64: The Dark Stars",
            categories = { ALL, NORMAL, LIGHT_KAIZO },
            romhackAuthor = "Caasje",
            floodPorter = "Bear64DX & MarcoGamerOJ",
            coopPorter = "Fearl"
        },
        {
            name = "SM64: The Green Stars",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Kampel125",
            floodPorter = "Bear64DX & MarcoGamerOJ",
            coopPorter = "Isaac0-dev"
        },
        {
            name = "SM64: The Mushroom Cup",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "usernamesarespiders",
            floodPorter = "Jzzay",
            coopPorter = "Fearl"
        },
        {
            name = "Some Kind of a Crash Game",
            categories = { ALL, CASUAL },
            romhackAuthor = "LinCrash",
            floodPorter = "Bear64DX, Jzzay & ~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Sonic Adventure 64 DX",
            categories = { ALL, NORMAL, CASUAL, SHORT, EASY },
            romhackAuthor = "PablosCorner",
            floodPorter = "Jzzay",
            coopPorter = "steven."
        },
        {
            name = "Star Revenge 0.5: The Unused Levels",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "SausRelics",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Star Revenge 1: Star Takeover",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Star Revenge 1.3: Redone",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Star Revenge 1.5: Star Takeover Redone",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "Bear64DX & ~!TONO!~",
            coopPorter = "flipflop bell, TikalSM64 & Fearl"
        },
        {
            name = "Star Revenge 2: Night of Doom",
            categories = { ALL, STAR_REVENGE, KAIZO },
            romhackAuthor = "BroDute",
            floodPorter = "Bear64DX & SuperRodrigo0",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Star Revenge 2.5: Remnant of Doom",
            categories = { ALL, STAR_REVENGE, LIGHT_KAIZO },
            romhackAuthor = "BroDute",
            floodPorter = "SausRelics & ~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Star Revenge 3: Mario on an Saoire",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "Jzzay",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Star Revenge 4: The Kedama Takeover",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "MarcoGamerOJ",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Star Revenge 4.5: Kedema Takeover Rewritten",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "SausRelics",
            coopPorter = "Fearl"
        },
        {
            name = "Star Revenge 4.9: Adulterated Reality",
            categories = { ALL, STAR_REVENGE, LIGHT_KAIZO },
            romhackAuthor = "BroDute, thebloody7 & sizzilingmario4",
            floodPorter = "~!TONO!~",
            coopPorter = "Woissil & Blocky.cmd"
        },
        {
            name = "Star Revenge 5: Neo Blue Realm",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "Bear64DX",
            coopPorter = "Fearl"
        },
        {
            name = "Star Revenge 6: Luigi's Adventure",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "Jzzay",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Star Revenge 6.5: Wrath of the Dim. Flower",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "~!TONO!~",
            coopPorter = "EmeraldLockdown"
        },
        {
            name = "Star Revenge 6.9: Luigi Lost in Time",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "Bear64DX",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Star Revenge 7: Park of Time",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick & flipflop bell"
        },
        {
            name = "Star Revenge 7.5: Kedowser's Return",
            categories = { ALL, STAR_REVENGE, CASUAL },
            romhackAuthor = "BroDute",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Super Bell Thrill",
            categories = { ALL, CASUAL, SHORT },
            romhackAuthor = "Flipflop Bell",
            floodPorter = "Jzzay",
            coopPorter = "[PC Port Exclusive]"
        },
        {
            name = "Super Luigi 64: The Flower Cup",
            categories = { ALL, CASUAL, LONG },
            romhackAuthor = "usernamesarespiders",
            floodPorter = "~!TONO!~, MarcoGamerOJ & Jzzay",
            coopPorter = "Fearl"			
        },
        {
            name = "Super Mario and the Koopa Power",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "VenusFeuerFalle",
            floodPorter = "~!TONO!~",
            coopPorter = "1e5assas"
        },
        {
            name = "Super Mario Star Road",
            categories = { ALL, NORMAL, CASUAL, LONG },
            romhackAuthor = "Skelux",
            floodPorter = "Agent X, tweaked by MarcoGamerOJ",
            coopPorter = "djoslin0, PrinceFrizzy & Isaac0-dev"
        },
        {
            name = "Super Mario: Invasion of Chuckya",
            categories = { ALL, ULTRA_KAIZO },
            romhackAuthor = "Kougahei-honmono",
            floodPorter = "SuperRodrigo0",
            coopPorter = "Fearl"
        },
        {
            name = "Super Mario's Jammin' Journey 64",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "GooseDaJuice",
            floodPorter = "~!TONO!~",
            coopPorter = "Zeta64"
        },
        {
            name = "Super Mario Star",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Mizu",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Super Mario The Power Star Journey",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Fares242",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Super Mario 64 Extra",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Tomatobird8",
            floodPorter = "Jzzay",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Super Mario 64 Into Bowser's Castle",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Deinol",
            floodPorter = "SausRelics",
            coopPorter = "Lukas"
        },
        {
            name = "Super Mario 64 LentiLevels",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "TheLentiLP",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Super Mario 64 Moonshine",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "TurnFlashed, s4ys & Fito",
            floodPorter = "MarcoGamerOJ",
            coopPorter = "PeachyPeach"
        },
        {
            name = "Super Mario 64 Odyssey",
            categories = { ALL, CASUAL },
            romhackAuthor = "Biobak and Kaze",
            floodPorter = "Jzzay",
            coopPorter = "RoxasYTB"
        },
        {
            name = "Super Mario 64 Trouble Town",
            categories = { ALL, CASUAL },
            romhackAuthor = "Nobbie",
            floodPorter = "Bear64DX",
            coopPorter = "Skeltan"
        },
        {
            name = "Super Mario 64 - Year of the Plumber",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "DobieMeltfire",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Super Mario 74",
            categories = { ALL, NORMAL, CASUAL, LONG },
            romhackAuthor = "Lugmillord",
            floodPorter = "MarcoGamerOJ, tweaked by ~!TONO!~",
            coopPorter = "djoslin0"
        },
        {
            name = "Super Mario 74: Extreme Edition",
            categories = { ALL, NORMAL, KAIZO, LONG },
            romhackAuthor = "Lugmillord",
            floodPorter = "~!TONO!~",
            coopPorter = "djoslin0"
        },
        {
            name = "Super Mario 74 EEE",
            categories = { ALL, MEME, KAIZO },
            romhackAuthor = "agytoth",
            floodPorter = "SuperRodrigo0",
            coopPorter = "SuperRodrigo0"
        },
        {
            name = "Super Mario 74 EEEE",
            categories = { ALL, MEME, ULTRA_KAIZO },
            romhackAuthor = "CartoonBuffon",
            floodPorter = "SuperRodrigo0",
            coopPorter = "Asra"
        },
        {
            name = "Super Mario 74 EEEEEE",
            categories = { ALL, MEME, ULTRA_KAIZO },
            romhackAuthor = "CartoonBuffon & Tomatobird8",
            floodPorter = "SuperRodrigo0",
            coopPorter = "Sunk"
        },
        {
            name = "Super Mario 74 EEEEEE 2",
            categories = { ALL, MEME, ULTRA_KAIZO },
            romhackAuthor = "CartoonBuffon, Tomatobird8 & Goop",
            floodPorter = "SuperRodrigo0",
            coopPorter = "Asra"
        },
        {
            name = "Super Mario 74 - Ten Years After",
            categories = { ALL, LIGHT_KAIZO },
            romhackAuthor = "LinCrash",
            floodPorter = "~!TONO!~",
            coopPorter = "flipflop bell"
        },
        {
            name = "Super Mario 8MB",
            categories = { ALL, CASUAL, EASY },
            romhackAuthor = "PablosCorner",
            floodPorter = "Jzzay",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Super Mario and the Cursed Castles",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Foxen",
            floodPorter = "Jzzay, Bear64DX & ~!TONO!~",
            coopPorter = "Dominicentek"
        },
        {
            name = "Super Mario and the Grand Star",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Grand Star",
            floodPorter = "Bear64DX",
            coopPorter = "Lukas, helped by Asra"
        },
        {
            name = "Super Mario and the Marvel Adventure",
            categories = { ALL, CASUAL },
            romhackAuthor = "Kampel125",
            floodPorter = "SausRelics & ~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Super Mario Bros 64",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Tamkis",
            floodPorter = "Jzzay",
            coopPorter = "B. Bones Johnson"
        },
        {
            name = "Super Mario Fallen Stars",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Skillux",
            floodPorter = "Jzzay",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Super Mario Parallel Stars",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Mese_Insanity and Rambi_Rampage",
            floodPorter = "~!TONO!~ & Jzzay",
            coopPorter = "Sunk"
        },
        {
            name = "Super Mario Rainbow Road",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Skillux",
            floodPorter = "Bear64DX",
            coopPorter = "Sunk"	
        },
        {
            name = "Super Mario The Galactic Journey",
            categories = { ALL, CASUAL },
            romhackAuthor = "Fares242",
            floodPorter = "Bear64DX & ~!TONO!~",
            coopPorter = "Dragonary"
        },
        {
            name = "Super Mario Treasure World",
            categories = { ALL, KAIZO, LONG },
            romhackAuthor = "Rambi_Rampage",
            floodPorter = "SuperRodrigo0",
            coopPorter = "Sunk"
        },
        {
            name = "Super Mario Treasure World: Dream Edition",
            categories = { ALL, ULTRA_KAIZO },
            romhackAuthor = "Rambi_Rampage",
            floodPorter = "SuperRodrigo0",
            coopPorter = "Sunk"
        },
        {
            name = "Super Mario: The Stolen Stars",
            categories = { ALL, NORMAL, CASUAL},
            romhackAuthor = "JakeDower",
            floodPorter = "Jzzay",
            coopPorter = "ICUP321"
        },
        {
            name = "Super Trump 64",
            categories = { ALL, MEME, CASUAL, SHORT },
            romhackAuthor = "Kaze Emanuar",
            floodPorter = "Jzzay",
            coopPorter = "Warioplier"
        },
        {
            name = "The Gate of The Good",
            categories = { ALL, NORMAL, KAIZO },
            romhackAuthor = "MorningStorm64",
            floodPorter = "[TBD]",
            coopPorter = "Sunk"
        },
        {
            name = "Thousand-Year Door 64",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "ToasterKetchup & aglab2",
            floodPorter = "Jzzay",
            coopPorter = "Lukas"
        },
        {
            name = "Tomatobird8's Single Star Speedruns",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Tomatobird8",
            floodPorter = "Jzzay",
            coopPorter = "Sunk"
        },
        {
            name = "Tower of Delight",
            categories = { ALL, NORMAL, CASUAL },
            romhackAuthor = "Mese_Insanity & Japanese Community",
            floodPorter = "~!TONO!~",
            coopPorter = "1e5assas"
        },
        {
            name = "Transcending the Rainbow",
            categories = { ALL, KAIZO, LONG },
            romhackAuthor = "Serium",
            floodPorter = "SuperRodrigo0 & MarcoGamerOJ",
            coopPorter = "Fearl"
        },
        {
            name = "Waifu Cauldron",
            categories = { ALL, KAIZO },
            romhackAuthor = "Morningstorm SM64",
            floodPorter = "Jzzay",
            coopPorter = "Sunk"
        },
        {
            name = "Wallkick Challenge 2",
            categories = { ALL, KAIZO, SHORT },
            romhackAuthor = "Redmat",
            floodPorter = "Jzzay",
            coopPorter = "Sunk"	
        },
        {
            name = "Winterbottom's Pie Trials",
            categories = { ALL, NORMAL, CASUAL, SHORT },
            romhackAuthor = "Captain T",
            floodPorter = "Bear64DX",
            coopPorter = "[PC Port Exclusive]"
        },
        {
            name = "Unknown Romhack 1",
            categories = { ALL, NORMAL, EASY, SHORT  },
            romhackAuthor = "???",
            floodPorter = "~!TONO!~",
            coopPorter = "Asra"	
        },
        {
            name = "Uranium Mario 64",
            categories = { ALL, LIGHT_KAIZO },
            romhackAuthor = "usernamesarespiders",
            floodPorter = "~!TONO!~",
            coopPorter = "Fearl"
        },
        {
            name = "Warped Worlds / His Personalized Copy",
            categories = { ALL, NORMAL, CASUAL, SHORT },
            romhackAuthor = "jefftastic",
            floodPorter = "~!TONO!~",
            coopPorter = "BlackJoystick"
        },
        {
            name = "Yoshi's Adventure 64",
            categories = { ALL, CASUAL },
            romhackAuthor = "usernamesarespiders",
            floodPorter = "~!TONO!~",
            coopPorter = "Fearl"
        },
        {
            name = "Ztar Attack 2 - A Blast to the Past",
            categories = { ALL, CASUAL, LONG },
            romhackAuthor = "TheGael95",
            floodPorter = "Bear64DX",
            coopPorter = "Mr.Needlemouse"
        }
    }
    romhackEntries = {}

    for categoryIndex, categoryName in pairs(romhackCategories) do
        local separatorAddedForCategory = false
        for _, romhack in ipairs(romhacks) do
            table.insert(romhack.categories, ALL)
            if table.contains(romhack.categories, categoryIndex) and category == categoryIndex then
                local separator = nil
                if not separatorAddedForCategory then
                    separatorAddedForCategory = true
                    separator = categoryName
                end
                table.insert(romhackEntries, {
                    name = romhack.name,
                    permission = PERMISSION_NONE,
                    input = INPUT_A,
                    func = function ()
                        entries = {
                            {
                                name = "Name",
                                valueText = romhack.name
                            },
                            {
                                name = "Author",
                                valueText = romhack.romhackAuthor and romhack.romhackAuthor or "None"
                            },
                            {
                                name = "Flood Porter",
                                valueText = romhack.floodPorter and romhack.floodPorter or "None"
                            },
                            {
                                name = "Coop Porter",
                                valueText = romhack.coopPorter and romhack.coopPorter or "None"
                            },
                            {
                                name = "Back",
                                permission = PERMISSION_NONE,
                                input = INPUT_A,
                                func = function ()
                                    entries = romhackEntries
                                    selection = 1
                                end
                            }
                        }
                        selection = 1
                    end,
                    separator = separator
                })
            end
        end
    end

    table.insert(romhackEntries, {
        name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = categoryEntries
            selection = 1
        end,
        separator = ""
    })

    if resetRomhackEntries then entries = romhackEntries end
end

local function reset_manual_entries()
    local resetManualEntries = entries == manualEntries

    manualEntries = {
        {
            name = "Objective",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = {
                    {
                        text = "The main goal of Flood is to reach the flag before the flood catches you. The flood can come in a ton of different variants, such as Lava, Sand, Mud, Waste, etc."
                    },
                    {
                        name = "Back",
                        permission = PERMISSION_NONE,
                        input = INPUT_A,
                        func = function ()
                            entries = manualEntries
                            selection = 1
                        end
                    }
                }
                selection = 1
            end,
            separator = "How to Play"
        },
        {
            name = "Romhacks",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = {
                    {
                        text = "Flood + comes built-in with a ton of supported romhacks, which means that you'll be able to play Flood + with romhacks! To see all of the supported romhacks, go to the \"Romhacks\" menu in the main menu. You'll see every supported romhack, the person who made the hack, and the person who ported the hack to Flood. There's also a \"Kaizo\" category so you can see every kaizo hack supported with Flood +. To load up a hack, just turn on your desired romhack with Flood + enabled, and you'll be playing your romhack in no time. It's that simple!"
                    },
                    {
                        name = "Back",
                        permission = PERMISSION_NONE,
                        input = INPUT_A,
                        func = function ()
                            entries = manualEntries
                            selection = 1
                        end
                    }
                }
                selection = 1
            end,
        },
        {
            name = "Moderator Commands",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = {
                    {
                        text = "If you are granted moderator status by the person hosting the server in Flood +, you can affect a lot of what happens in the server. You can stop a round early and edit things like which modifiers are being used and the speed of the flood in the Flood Settings. The only things moderators can't do that the server hoster can is starting a round and restarting an ongoing round."
                    },
                    {
                        name = "Back",
                        permission = PERMISSION_NONE,
                        input = INPUT_A,
                        func = function ()
                            entries = manualEntries
                            selection = 1
                        end
                    }
                }
                selection = 1
            end,
        },
        {
            name = "Gamemodes",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = gamemodeManualEntries
                selection = 1
            end,
        },
        {
            name = "Modifiers",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = modifierManualEntries
                selection = 1
            end,
        },
        {
            name = "Commands",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = commandEntries
                selection = 1
            end,
        },
        {
            name = "Story",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = chapterEntries
                selection = 1
            end,
            separator = "Extras"
        },
        {
            name = "Music",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = musicEntries
                selection = 1
            end,
        },
        {
            name = "Emotes",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = {
                    {
                        text = "If you tap one of the four DPad directions, you can do a little emote! There are certain DPAD combinations you can use to emote in different ways. The combinations are L + DPad, X + DPad, and Y + DPad. Have fun emoting on players!"
                    },
                    {
                        name = "Back",
                        permission = PERMISSION_NONE,
                        input = INPUT_A,
                        func = function ()
                            entries = manualEntries
                            selection = 1
                        end
                    }
                }
                selection = 1
            end,
        },
        {
            name = "Back",
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = mainEntries
                selection = 1
            end,
            separator = ""
        }
    }

    if resetManualEntries then
        entries = manualEntries
    end
end

chapterEntries = {
        {name = "Chapter 0: Origin",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = {
                {
                    text = "A long time ago, in the depths of Wet-Dry World, an ancient civilization had foretold a dark prophecy; on 12/18/2022, a catastrophic flood would soon engulf the Castle Grounds and cause chaos in the Mushroom Kingdom. As the flood spread, it haunted the memories and grief of the fallen heroes. The world became a nightmare as residents of the Mushroom Kingdom began to panic, wondering if they'd ever make it out. Whispers echoed through the land, suggesting that the flood had reached other dimensions. Each flag represented a crucial checkpoint in their desperate struggle for survival. As they sprinted through the flooded landscape, they confronted the shadows of their past and Bowser's cunning traps designed to thwart their progress. The fate of the Mushroom Kingdom hangs in the balance. Only by unraveling the ancient predictions and confronting Bowser can they hope to restore order and reclaim their home. However, nobody knew what the true cause of the flood was..."
                },
                {
                    name = "Back",
                    permission = PERMISSION_NONE,
                    input = INPUT_A,
                    func = function ()
                        entries = chapterEntries
                        selection = 1
                    end,
                    separator = ""
                }
            }
            selection = 1
        end,
        separator = "Chapters"
    },
        {name = "Chapter 1: Consequences",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = {
                {
                    text = "Legends say that a mysterious machine caused a chemical reaction, causing different floods to be born across different worlds. They say it's managed to spread across the galaxies and even space itself. The residents were panicking from the intial chaos of the rising flood. They knew they had to do something quick, so they tried climbing as high as they could, as Bowser's deadly minions stood in their way. When a flag was reached, the flood rose faster and faster. The residents would be teleported to a new world everytime they had reached the flag, and the flood speed changed depending on where the residents were. The Battle for Survival has begun."
                },
                {
                    name = "Back",
                    permission = PERMISSION_NONE,
                    input = INPUT_A,
                    func = function ()
                        entries = chapterEntries
                        selection = 1
                    end,
                    separator = ""
                }
            }
            selection = 1
        end,
    },
    {
        name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = manualEntries
            selection = 1
        end,
        separator = ""
    }
}

gamemodeManualEntries = {}

for k in pairs(gamemodes) do
    table.insert(gamemodeManualEntries, {
        name = gamemodes[k].name,
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = {
                {
                    text = gamemodes[k].description
                },
                {
                    name = "Back",
                    permission = PERMISSION_NONE,
                    input = INPUT_A,
                    func = function ()
                        entries = gamemodeManualEntries
                        selection = 1
                    end
                }
            }
        end
    })
end

table.insert(gamemodeManualEntries, {
    name = "Back",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = mainEntries
        selection = 1
    end
})

modifierManualEntries = {
    {name = "Power-Ups",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Power-Ups makes it so that when you collect 4 coins, a power up spawns for you to collect. The 4 types of items you can get are a Wing Cap, Vanish Cap, Metal Cap, and a 1-Up. You can edit the amount of coins you need to collect using /flood coincount [number] or by using the Modifier menu."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,
    separator = "Modifiers",},
    {name = "Instakill",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Instakill makes it so that the flood instantly kills you when you're submerged in it. You're also one-shot with this modifier on, so try not to get hit by anything at all cost!"
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Pursuit",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Pursuit spawns a deadly Pursuer that tries to kill all players remaining before they reach the goal."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "PvP",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "PvP makes it so that you can attack other players. You can knock them off the map and even kill them!"
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Deathcoin",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Deathcoin makes it so that if you touch a coin, you die! Use this with Instakill for the best possible experience."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Winboost",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Winboost makes the flood speed increase by 0.25 when you reach the flagpole. Please note that the flood speed will always be 1 with this modifier on."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Speed",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Speed makes the player's speed go 2x faster than before!"
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "B Button Challenge",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "B Button Challenge bans the B button from your controller, which means that you can no longer perform actions like Diving, Kicking, etc."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Z Button Challenge",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Z Button Challenge bans the Z trigger from your controller, which means that you can no longer perform actions like Long Jumping, Ground Pounding, etc."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Coin Rush",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Coin Rush makes it so that the more coins you get, the faster you are."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Tripping",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Tripping makes it so that you can slip and fall while you run on foot. Happens more commonly if you don't jump much."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Low Gravity",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Low Gravity decreases the gravity in every level! Put more of an emphasis on taking shortcuts than going fast to win for this modifier."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "High Gravity",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "High Gravity INCREASES the gravity in every level. Make sure to not assume you can do all the hard jumps you'll try normally in Mario 64."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Flash Flood",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Flash Flood makes it so that the speed of the flood can randomly increase from minimal to nearly 2 times faster. Make sure to stay on your toes for this modifier."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "BLJ",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "BLJ allows you to perform a Backwards Long Jump anywhere at any time."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Capless",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Capless makes it so that you never have your cap on, but you can still use cap powers like the Wing, Vanish or Metal Cap. Oh, and don't even try retrieving your cap from Klepto."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Fly",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Fly grants you power to the Wing Cap at all time."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Slippery Floors",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Slippery Floors is pretty self-explanatory. It makes the floor slippery, which makes the level harder to traverse."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Hard Floors",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Hard Floors removes slipperiness from all types of floors, making it easier to navigate through levels."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Fog",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Fog makes the level harder to see, which can trip you up at times if you're not careful."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Inverted Controls",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Inverts your left stick, making it harder to control the player."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Tornadoes",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Spawns random tornadoes that try to block your way during the round."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Firsties",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Attempting to perform Wallkicks will now require even more skill and 1 frame precision."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Special Triple Jump",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Allows you to use the hidden Special Triple Jump that Yoshi grants you at the top of the Castle."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Earthquake",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Provokes shaking on the camera."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = modifierManualEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Back",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = manualEntries
        selection = 1
    end,
    separator = ""}
}

commandEntries = {
    {name = "/flood",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Opens the Flood + Menu."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = commandEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,
    separator = "Commands"},
    {name = "/start",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Starts a round in a random or specific level, you can also leave it empty for normal progression."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = commandEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end},
    {name = "/modifiers",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Enables or Disables a Modifier. You can look at the modifier manual page or the README file to find available modifiers."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = commandEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end},
    {name = "/speed",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Sets the speed multiplier of the Flood."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = commandEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end},
    {name = "/difficulty",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Sets the speed the Flood kills you at."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = commandEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "/round-cooldown",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Sets the round cooldown for when a match ends."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = commandEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end},
    {name = "/ttc-speed",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Changes the speed of the moving objects in Tick Tock Clock. You can either pick fast, slow, random, or stopped."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = commandEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "/coincount",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "You can toggle the amount of coins needed to spawn a Power-Up for the Power-Ups modifier."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = commandEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "/info",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = {
            {
                text = "Gets the information about the version, romhack count, total levels, mapmode, and the level you're playing."
            },
            {
                name = "Back",
                permission = PERMISSION_NONE,
                input = INPUT_A,
                func = function ()
                    entries = commandEntries
                    selection = 1
                end
            }
        }
        selection = 1
    end,},
    {name = "Back",
    permission = PERMISSION_NONE,
    input = INPUT_A,
    func = function ()
        entries = manualEntries
        selection = 1
    end,
    separator = ""}
}

local function reset_credit_entries()
    local AUTHOR = 1
    local LEAD_DEV = 2
    local FLOOD_AUTHOR = 3
    local FE_AUTHOR = 4
    local DEV = 5
    local FLOOD_PORTER = 6
    local COMPOSER = 7
    local TESTER = 8
    local CONTRIBUTOR = 9
    local SPECIAL_THANKS = 10
    local categories = {
        [AUTHOR] = "Author",
        [LEAD_DEV] = "Lead Developers",
        [FLOOD_AUTHOR] = "Original Flood Author",
        [FE_AUTHOR] = "Flood Expanded Author",
        [DEV] = "Developers",
        [FLOOD_PORTER] = "Flood Porters",
        [TESTER] = "Testers",
        [COMPOSER] = "Composers",
        [CONTRIBUTOR] = "Contributors",
        [SPECIAL_THANKS] = "Special Thanks"
    }
    local players = {
        {
            name = "Jzzay",
            categories = { AUTHOR, LEAD_DEV, FLOOD_PORTER },
            discordHandle = "jzz4y",
            modsiteUsername = "Jzzay",
            githubHandle = "jzz4y"
        },
        {
            name = "Agent X",
            categories = { FLOOD_AUTHOR, TESTER },
            discordHandle = "AgentXLP",
            modsiteUsername = "AgentX",
            githubHandle = "AgentXLP"
        },
        {
            name = "Bear64DX",
            categories = { LEAD_DEV, FLOOD_PORTER, COMPOSER},
            discordHandle = "Bear64DX",
            modsiteUsername = "Bear",
            githubHandle = "Bear64DX"
        },
        {
            name = "EmeraldLockdown",
            categories = { DEV },
            discordHandle = nil,
            modsiteUsername = "EmeraldLockdown",
            githubHandle = "EmeraldLoc"
        },
        {
            name = "birdekek",
            categories = { FE_AUTHOR, DEV },
            discordHandle = "birdekek",
            modsiteUsername = "birdekek",
            githubHandle = "breadekek"
        },
        {
            name = "Blocky",
            categories = { DEV, CONTRIBUTOR },
            discordHandle = "Blocky.cmd",
            modsiteUsername = "Blocky",
            githubHandle = "Blockyyy"
        },
        {
            name = "EmilyEmmi",
            categories = { CONTRIBUTOR },
            discordHandle = "emilyemmi",
            modsiteUsername = "EmilyEmmi",
            githubHandle = "EmilyEmmi"
        },
        {
            name = "MarcoGamer0J",
            categories = { FLOOD_PORTER },
            discordHandle = "marcoundertroll",
            modsiteUsername = "MarcoGamerOJ",
            githubHandle = "MarcoGamerOJ"
        },
        {
            name = "TikalSM64",
            categories = { FLOOD_PORTER },
            discordHandle = "sallygamerbaldi",
            modsiteUsername = nil,
            githubHandle = nil
        },
        {
            name = "SausRelics",
            categories = { FLOOD_PORTER, CONTRIBUTOR, TESTER },
            discordHandle = "sausrelics",
            modsiteUsername = "SausRelics",
            githubHandle = "SausRelicsSSJ2"
        },
        {
            name = "Stew",
            categories = { FLOOD_PORTER, CONTRIBUTOR},
            discordHandle = "ssbstew",
            modsiteUsername = nil,
            githubHandle = nil,
        },
        {
            name = "TheMan",
            categories = { SPECIAL_THANKS, TESTER },
            discordHandle = "coolestfellow",
            modsiteUsername = "TheMan",
            githubHandle = "TheMan6900"
        },
        {
            name = "Viande",
            categories = { SPECIAL_THANKS, TESTER },
            discordHandle = "viandegras",
            modsiteUsername = "[Viande Scolopendragon]",
            githubHandle = nil
        },
        {
            name = "Cooliokid",
            categories = { SPECIAL_THANKS, CONTRIBUTOR },
            discordHandle = "cooliokid956",
            modsiteUsername = "Cooliokid 956",
            githubHandle = "Cooliokid956",
        },
        {
            name = "Sunk",
            categories = { SPECIAL_THANKS, CONTRIBUTOR },
            discordHandle = "sunkly",
            modsiteUsername = nil,
            githubHandle = "Sunketchupm"
        },
        {
            name = "Error",
            categories = { SPECIAL_THANKS },
            discordHandle = "errorsm64",
            modsiteUsername = nil,
            githubHandle = nil
        },
        {
            name = "Phenomenal Sire",
            categories = { TESTER },
            discordHandle = "phenomenalsire",
            modsiteUsername = nil,
            githubHandle = nil
        },
        {
            name = "Caec",
            categories = { CONTRIBUTOR },
            discordHandle = "defecating",
            modsiteUsername = nil,
            githubHandle = nil
        },
        {
            name = "CosmicNyan",
            categories = { CONTRIBUTOR },
            discordHandle = "cosmicnyan",
            modsiteUsername = "CosmicNyan",
            githubHandle = "CosmicMan08"
        },
        {
            name = "Gaming32",
            categories = { CONTRIBUTOR },
            discordHandle = "gaming32",
            modsiteUsername = nil,
            githubHandle = nil
        },
        {
            name = "N64",
            categories = { TESTER },
            discordHandle = "n64yt",
            modsiteUsername = nil,
            githubHandle = nil
        },
        {
            name = "Max_MARIO",
            categories = { TESTER },
            discordHandle = "maxmario",
            modsiteUsername = nil,
            githubHandle = nil
        },
        {
            name = "mrvidyas",
            categories = { TESTER },
            discordHandle = nil,
            modsiteUsername = nil,
            githubHandle = nil
        },
        {
            name = "~!TONO!~",
            categories = { DEV, FLOOD_PORTER, TESTER },
            discordHandle = "tonto0542",
            modsiteUsername = "TONO",
            githubHandle = "TONO-0542"
        },
        {
            name = "SuperRodrigo0",
            categories = { DEV, FLOOD_PORTER, TESTER },
            discordHandle = "superrodrigo",
            modsiteUsername = nil,
            githubHandle = "SuperRodrigo0"
        },
        {
            name = "LocaMash",
            categories = { TESTER },
            discordHandle = "locamash",
            modsiteUsername = nil,
            githubHandle = nil
        },
        {
            name = "benjamin11544",
            categories = { TESTER },
            discordHandle = "benjamin11544",
            modsiteUsername = nil,
            githubHandle = "benjamin11544"
        },
        {
            name = "bloop",
            categories = { TESTER },
            discordHandle = "bloopmvl",
            modsiteUsername = nil,
            githubHandle = nil
        },
        {
            name = "Bomboclath",
            categories = { DEV, FLOOD_PORTER },
            discordHandle = "whatuwantfrman",
            modsiteUsername = "Bomboclath048",
            githubHandle = "Erik-Bomboclath"
        },
        {
            name = "DT Ryan",
            categories = { CONTRIBUTOR },
            discordHandle = nil,
            modsiteUsername = nil,
            githubHandle = nil
        },
        {
            name = "kermeow",
            categories = { CONTRIBUTOR },
            discordHandle = "kermeet",
            modsiteUsername = "kermeow",
            githubHandle = "kermeow"
        }
    }

    creditEntries = {}

    for categoryIndex, categoryName in ipairs(categories) do
        local separatorAddedForCategory = false
        for _, player in ipairs(players) do
            if table.contains(player.categories, categoryIndex) then
                local separator = nil
                if not separatorAddedForCategory then
                    separatorAddedForCategory = true
                    separator = categoryName
                end
                table.insert(creditEntries, {
                    name = player.name,
                    permission = PERMISSION_NONE,
                    input = INPUT_A,
                    func = function ()
                        entries = {
                            {
                                name = "Name",
                                valueText = player.name
                            },
                            {
                                name = "Discord Handle",
                                valueText = player.discordHandle and player.discordHandle or "None"
                            },
                            {
                                name = "Modsite Username",
                                valueText = player.modsiteUsername and player.modsiteUsername or "None"
                            },
                            {
                                name = "Github Handle",
                                valueText = player.githubHandle and player.githubHandle or "None"
                            },
                            {
                                name = "Back",
                                permission = PERMISSION_NONE,
                                input = INPUT_A,
                                func = function ()
                                    entries = creditEntries
                                    selection = 1
                                end
                            }
                        }
                        selection = 1
                    end,
                    separator = separator
                })
            end
        end
    end

    table.insert(creditEntries, {
        name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = mainEntries
            selection = 1
        end,
        separator = ""
    })
end

local function reset_music_entries()
    local songs = {
        {
            level = "Bob-Omb Battlefield",
            name = "Hammer Bros. Battle - Super Mario Bros. 3",
            composer = "Koji Kondo",
            author = "Bear64DX"
        },
        {
            level = "Whomp's Fortress",
            name = "Puzzle Plank Galaxy - Super Mario Galaxy 2",
            composer = "Koji Kondo",
            author = "[TBD]"
        },
        {
            level = "Jolly Roger Bay",
            name = "Underwater Theme - Super Mario World",
            composer = "Koji Kondo",
            author = "[TBD]"
        },
        {
            level = "The Sunken Ship",
            name = "Underwater Theme - Super Mario Bros. 3",
            composer = "Koji Kondo",
            author = "Bear64DX"
        },
        {
            level = "Cool, Cool Mountain",
            name = "Snow (Super Mario Bros.) - Super Mario Maker 2",
            composer = "Koji Kondo",
            author = "Bear64DX"
        },
        {
            level = "Frosty Slide",
            name = "Chai Kingdom - Super Mario Land",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Bowser In The Dark World",
            name = "Sector X - Star Fox 64",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Big Boo's Haunt",
            name = "Ghost House (Super Mario Bros.) - Super Mario Maker",
            composer = "Koji Kondo",
            author = "[TBD]"
        },
        {
            level = "Deep Underground Cave",
            name = "Freeze! - Paper Mario",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Cavern Of The Metal Cap",
            name = "Masked Dedede - Kirby Triple Deluxe",
            composer = "Hirokazu Ando",
            author = "LocaMash"
        },
        {
            level = "Lethal Lava Land",
            name = "Sammer's Kingdom - Super Paper Mario",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Flame-Boiling Volcano",
            name = "Chomp Attack - Paper Mario",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Shifting Sand Land",
            name = "Ruins - Super Mario Land",
            composer = "Hirokazu Tanaka",
            author = "Bear64DX"
        },
        {
            level = "The Ancient Pyramid",
            name = "Sky Sands - Kirby Air Ride",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Dire, Dire Docks",
            name = "Egg Rocket Zone 1 - Sonic Advance",
            composer = "Sega",
            author = "[TBD]"
        },
        {
            level = "Bowser In The Fire Sea",
            name = "Bowser Castle - Super Mario 3D World",
            composer = "Koji Kondo",
            author = "[TBD]"
        },
        {
            level = "Vanish Cap Under The Moat",
            name = "Slope - Super Mario RPG",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Snowman's Land",
            name = "White Glacier - Bomberman 64",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Wet-Dry World",
            name = "Mafland - maf464",
            composer = "maf464",
            author = "[TBD]"
        },
        {
            level = "Wet-Dry Town",
            name = "Magic Charm Lesson - Magician's Quest - Mysterious Times",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Tall, Tall Mountain",
            name = "Bridge Zone - Sonic the Hedgehog (8-bit)",
            composer = "Yuzo Koshiro",
            author = "Bear64DX"
        },
        {
            level = "Mysterious Mountain Slide",
            name = "Mine Cart Riding - Kirby Super Star",
            composer = "Jun Ishikawa & Hirokazu Ando",
            author = "Bear64DX"
        },
        {
            level = "The Tiny Island",
            name = "Overworld Theme - Super Mario Bros. 2",
            composer = "Koji Kondo",
            author = "[TBD]"
        },
        {
            level = "The Huge Island",
            name = "Stage 1 - Kirby's Block Ball",
            composer = "Sukezo Ouyama & Ryoue Takagi",
            author = "Bear64DX"
        },
        {
            level = "Tick Tock Clock",
            name = "Butter Building - Kirby's Adventure",
            composer = "Hirokazu Ando",
            author = "Bear64DX"
        },
        {
            level = "Rainbow Ride",
            name = "Rainbow Route - Kirby & The Amazing Mirror",
            composer = "Nintendo",
            author = "Bear64DX"
        },
        {
            level = "Wing Mario Over The Rainbow",
            name = "Clouds - Super Mario Bros. 3",
            composer = "Koji Kondo",
            author = "Bear64DX"
        },
        {
            level = "Bowser In The Sky",
            name = "It's Showtime! - Mario & Luigi: Bowser's Inside Story",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "The Princess' Secret Slide",
            name = "Bonus Theme - Super Mario World",
            composer = "Koji Kondo",
            author = "Bear64DX"
        },
        {
            level = "Castle Grounds",
            name = "Warp - Star Fox 64",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Castle Upstairs",
            name = "Temple (Palace) - The Legend of Zelda 2: Adventure Of Link",
            composer = "Nintendo",
            author = "mosky2000"
        },
        {
            level = "Caged Fortress Tricks",
            name = "Castle Lololo - Kirby's Dream Land",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Cap'n Ocean Cave",
            name = "Mt. Blaze - Pokemon Mystery Dungeon: Red/Blue Rescue Team",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Icey Wallkick Challenge",
            name = "Frosty Forest - Pokemon Mystery Dungeon",
            composer = "Nintendo",
            author = "VanessaWolfe2015"
        },
        {
            level = "Boo's Haunted Basement",
            name = "Haunted Chase - Donkey Kong Country 2",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Cloudy Haze Maze",
            name = "ChuckleHuck Woods - Mario & Luigi: Superstar Saga",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Work Elevator",
            name = "The Great Cave Offensive - Kirby Super Star",
            composer = "Jun Ishikawa & Dan Miyakawa",
            author = "Bear64DX"
        },
        {
            level = "Red-Hot Log Rolling",
            name = "[TBD]",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Koopa's Island Race",
            name = "Forest Area - Kirby's Adventure",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Swingin' In The Breeze",
            name = "Never Let Up! - Mario & Luigi: Dream Team",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Tricky Triangles",
            name = "[TBD]",
            composer = "Nintendo",
            author = "[TBD]"
        },
        {
            level = "Nighttime Cloud Hopping",
            name = "Spirit Mountain - Yoshi's Safari",
            composer = "Nintendo",
            author = "[TBD]"
        }
    }
    musicEntries = {}

    for _, song in ipairs(songs) do
        table.insert(musicEntries, {
            name = song.level,
            permission = PERMISSION_NONE,
            input = INPUT_A,
            func = function ()
                entries = {
                    {
                        name = "Level",
                        valueText = song.level
                    },
                    {
                        name = "Song",
                        valueText = song.name
                    },
                    {
                        name = "Composer",
                        valueText = song.composer and song.composer or "None"
                    },
                    {
                        name = ".m64 Author",
                        valueText = song.author and song.author or "None"
                    },
                    {
                        name = "Back",
                        permission = PERMISSION_NONE,
                        input = INPUT_A,
                        func = function ()
                            entries = musicEntries
                            selection = 1
                        end
                    }
                }
                selection = 1
            end,
        })
    end
    table.insert(musicEntries, {
        name = "Back",
        permission = PERMISSION_NONE,
        input = INPUT_A,
        func = function ()
            entries = manualEntries
            selection = 1
        end,
        separator = ""
    })
end

-- hud stuff
local function is_entry_visible(entryIndex)
    local entryHeight = 90
    for i in pairs(entries) do
        entryHeight = entryHeight + 60
        if entries[i].separator ~= nil then
            entryHeight = entryHeight + 30
        end

        if i == entryIndex then break end
    end

    if entryHeight - scrollOffset < 30 then return false end
    if entryHeight - scrollOffset > 810 then return false end

    return true
end

local function background()
    local theme = get_selected_theme()
    local x = (djui_hud_get_screen_width() / 2) - (bgWidth / 2)
    local y = djui_hud_get_screen_height() - bgHeight
    djui_hud_set_color(theme.background.r, theme.background.g, theme.background.b, 250)
    djui_hud_render_rect_rounded_outlined(x, y / 2, bgWidth, bgHeight, theme.backgroundOutline.r, theme.backgroundOutline.g, theme.backgroundOutline.b, 10)
end

local function settings_text()
    local text = "\\#2BC3FF\\Flood \\#00ff00\\+"
    local theme = get_selected_theme()
    local x = (djui_hud_get_screen_width() / 2) - (bgWidth / 2)
    local y = (djui_hud_get_screen_height() - bgHeight) / 2
    if y - scrollOffset < -20 then return end
    djui_hud_print_colored_text(text, x + ((bgWidth / 2) - djui_hud_measure_text(string_without_hex(text))), y + 50 - scrollOffset, 2, 255)
    text = version
    djui_hud_set_color(theme.text.r, theme.text.g, theme.text.b, 255)
    djui_hud_print_colored_text(text, x + (bgWidth / 2) - (djui_hud_measure_text(string_without_hex(text)) / 1), y + 105 - scrollOffset, 1, 255)
end

local function hud_render()
    if not showSettings then
        entries = mainEntries
        selection = 1
        scrollOffset = 0
        return
    end

    djui_hud_set_font(FONT_NORMAL)
    djui_hud_set_resolution(RESOLUTION_DJUI)

    scrollOffset = 0

    -- get entry to start scrolling at
    scrollEntry = 12
    for i in pairs(entries) do
        if  entries[i].separator ~= nil
        and i < scrollEntry - 1 then
            scrollEntry = scrollEntry - (2/3)
        end
    end

    scrollEntry = math.floor(scrollEntry)

    if selection > scrollEntry then
        for i = scrollEntry + 1, selection do
            scrollOffset = scrollOffset + 60

            if entries[i].separator ~= nil then
                scrollOffset = scrollOffset + 30
            end
        end
    end

    background()
    settings_text()

    local theme = get_selected_theme()
    local height = 90
    local x = (djui_hud_get_screen_width() / 2) - (bgWidth / 2)
    local y = (djui_hud_get_screen_height() - bgHeight) / 2

    for i in pairs(entries) do
        if entries[i].separator ~= nil then
            if not is_entry_visible(i) then
                height = height + 90
                goto continue
            end
            height = height + 45

            djui_hud_set_color(theme.text.r, theme.text.g, theme.text.b, 255)
            djui_hud_print_colored_text(entries[i].separator, x + 30, y + height + 4 - scrollOffset, 1)

            height = height + 45
        else
            height = height + 60
        end

        if not is_entry_visible(i) then goto continue end

        if entries[i].text ~= nil then

            -- if there's a name, print that first
            if entries[i].name ~= nil then
                if selection == i then
                    djui_hud_set_color(theme.selectedText.r, theme.selectedText.g, theme.selectedText.b, 255)
                else
                    djui_hud_set_color(theme.text.r, theme.text.g, theme.text.b, 255)
                end

                djui_hud_print_text(entries[i].name, x + 20, y + height - scrollOffset, 1)

                height = height + 30
            end

            -- appreciate the free labor chatgpt (ok I did a little bit of cleanup)
            local textAmount = 64
            if SM64COOPDX_VERSION ~= nil then textAmount = 55 end
            local wrappedTextLines = wrap_text(entries[i].text, textAmount)

            for j, line in ipairs(wrappedTextLines) do
                if selection == i then
                    djui_hud_set_color(theme.selectedText.r, theme.selectedText.g, theme.selectedText.b, 255)
                else
                    djui_hud_set_color(theme.text.r, theme.text.g, theme.text.b, 255)
                end

                djui_hud_print_text(line, x + 20, y + height - scrollOffset + (j - 1) * 28, 1)
            end

            for _ in pairs(wrappedTextLines) do
                height = height + 25
            end

            goto continue
        end

        local outlineColor = nil

        if selection == i then
            djui_hud_set_color(theme.hoverRect.r, theme.hoverRect.g, theme.hoverRect.b, 230)
            outlineColor = theme.hoverRectOutline
        else
            djui_hud_set_color(theme.rect.r, theme.rect.g, theme.rect.b, 200)
            outlineColor = theme.rectOutline
        end

        djui_hud_render_rect_outlined(x + 20, y + height - scrollOffset, bgWidth - 40, 40, outlineColor.r, outlineColor.g, outlineColor.b, 3)

        if not has_permission(entries[i].permission)
        or entries[i].disabled then
            djui_hud_set_color(theme.disabledText.r, theme.disabledText.g, theme.disabledText.b, 255)
        else
            djui_hud_set_color(theme.text.r, theme.text.g, theme.text.b, 255)
        end

        if entries[i].name ~= nil then
            djui_hud_print_colored_text(tostring(entries[i].name), x + 30, y + height + 4 - scrollOffset, 1)
        end

        if entries[i].valueText ~= nil then
            djui_hud_set_color(theme.text.r, theme.text.g, theme.text.b, 255)
            djui_hud_print_colored_text(tostring(entries[i].valueText), x + (bgWidth - 30) - djui_hud_measure_text(tostring(entries[i].valueText)), y + height + 4 - scrollOffset, 1)
        end

        ::continue::
    end
end

---@param m MarioState
local function mario_update(m)

    if lockedRunAnimation then
        if customRunAnimation == 1 then
            m.marioBodyState.torsoAngle.x = -3000
        elseif customRunAnimation == 2 then
            m.marioBodyState.torsoAngle.x = 0
            m.marioBodyState.torsoAngle.z = 0
        elseif customRunAnimation == 3 then
            m.marioBodyState.torsoAngle.y = 33000
            m.marioBodyState.torsoAngle.z = 0
        elseif customRunAnimation == 4 then
            m.marioBodyState.torsoAngle.x = 4690
        elseif customRunAnimation == 5 then
            m.marioBodyState.torsoAngle.x = 0
        elseif customRunAnimation == 6 then
            m.marioBodyState.torsoAngle.z = 3000
        elseif customRunAnimation == 7 then
            m.marioBodyState.torsoAngle.z = -3000
        elseif customRunAnimation == 8 then
            m.marioBodyState.torsoAngle.z = 33000
        end
    end

    if lockedEyeState and customEyeState ~= MARIO_EYES_DEFAULT then
        m.marioBodyState.eyeState = customEyeState
    end

    if lockedTrailParticle then
        set_mario_particle_flags(gMarioStates[0], customTrailParticle, 0)
    end

    if m.playerIndex ~= 0 then return end
    if not showSettings then return end

    m.freeze = 1

    -- if our stick is at 0, then set joystickCooldown to 0
    if m.controller.stickX == 0
    and m.controller.stickY == 0
    and m.controller.buttonDown & U_JPAD == 0
    and m.controller.buttonDown & D_JPAD == 0 then joystickCooldown = 0 end

    if (m.controller.buttonDown & U_JPAD ~= 0
    or m.controller.stickY > 0.5) and joystickCooldown <= 0 then
        selection = selection - 1
        if selection < 1 then selection = clamp(#entries, 1,  #entries + 1) end
        play_sound(SOUND_MENU_MESSAGE_DISAPPEAR, gGlobalSoundSource)
        joystickCooldown = 0.2 * 30
    elseif (m.controller.buttonDown & D_JPAD ~= 0
    or m.controller.stickY < -0.5) and joystickCooldown <= 0 then
        selection = selection + 1
        if selection > #entries then selection = 1 end
        play_sound(SOUND_MENU_MESSAGE_DISAPPEAR, gGlobalSoundSource)
        joystickCooldown = 0.2 * 30
    end

    if (m.controller.buttonPressed & R_JPAD ~= 0 or (m.controller.stickX > 0.5
    and joystickCooldown <= 0))
    and entries[selection].input == INPUT_JOYSTICK then
        if has_permission(entries[selection].permission)
        and not entries[selection].disabled then
            if entries[selection].func ~= nil then
                entries[selection].func()
                play_sound(SOUND_MENU_MESSAGE_DISAPPEAR, gGlobalSoundSource)
            end
        else
            play_sound(SOUND_MENU_CAMERA_BUZZ, gGlobalSoundSource)
        end

        joystickCooldown = 0.2 * 30
    elseif (m.controller.buttonPressed & L_JPAD ~= 0 or (m.controller.stickX < -0.5
    and joystickCooldown <= 0))
    and entries[selection].input == INPUT_JOYSTICK then
        if has_permission(entries[selection].permission)
        and not entries[selection].disabled then
            if entries[selection].func ~= nil then
                entries[selection].func()
                play_sound(SOUND_MENU_MESSAGE_DISAPPEAR, gGlobalSoundSource)
            end
        else
            play_sound(SOUND_MENU_CAMERA_BUZZ, gGlobalSoundSource)
        end

        joystickCooldown = 0.2 * 30
    end

    if joystickCooldown > 0 then joystickCooldown = joystickCooldown - 1 end

    if  m.controller.buttonPressed & A_BUTTON ~= 0
    and entries[selection].input == INPUT_A then
        if has_permission(entries[selection].permission)
        and not entries[selection].disabled then
            if entries[selection].func ~= nil then
                entries[selection].func()
                play_sound(SOUND_MENU_CLICK_FILE_SELECT, gGlobalSoundSource)
            end
        else
            play_sound(SOUND_MENU_CAMERA_BUZZ, gGlobalSoundSource)
        end
    end

    reset_main_entries()
    reset_start_entries()
    reset_gamemode_entries()
    reset_modifier_entries()
    reset_setting_selections()
    reset_game_selections()
    reset_general_selections()
    reset_hud_selections()
    reset_extra_selections()
    reset_graphic_selections()
    reset_server_selections()
    reset_enemy_selections()
    reset_theme_selections()
    reset_theme_manager_entries()
    reset_theme_builder_entries()
    reset_rgb_slider_entries()
    reset_romhack_entries()
    reset_manual_entries()
    reset_credit_entries()
    reset_music_entries()
end

hook_event(HOOK_MARIO_UPDATE, mario_update)
hook_event(HOOK_ON_HUD_RENDER, hud_render)
