-- Big thanks to Cooliokid956 for both the exclamation box function and for_each_object_with_behavior function/hook
local function custom_exclamation_box(o)
    if o.oAction == 5 then
        obj_mark_for_deletion(o)
    end
end

local function desync_exclamation_box()
    spawn_non_sync_object(id_bhvExclamationBox, E_MODEL_EXCLAMATION_BOX, nil, nil, nil, nil)
end

-- Fixes Bowser from standing still and doing absolutely nothing
local function custom_bowser(o)
    if o.oAction == 5 then
        o.oAction = 14
    end
end

-- Fixes the DDD sub from despawning when the star counter is high enough (Thank you EmilyEmmi!)
---@param o Object
local function custom_ddd_sub_init(o)
    o.oFlags = o.oFlags | (OBJ_FLAG_ACTIVE_FROM_AFAR | OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE)
    o.oCollisionDistance = 20000
    o.collisionData = smlua_collision_util_get('ddd_seg7_collision_submarine')
end

---@param o Object
local function custom_ddd_door_init(o)
    o.oFlags = o.oFlags | (OBJ_FLAG_ACTIVE_FROM_AFAR | OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE)
    o.oCollisionDistance = 20000
    o.collisionData = smlua_collision_util_get('ddd_seg7_collision_bowser_sub_door')
end

---@param o Object
local function custom_ddd_loop(o)
    load_object_collision_model()
end

-- All Cannon stuff (Credits to EmeraldLockdown)

---@param o Object
local function cannon_lid_init(o)
    o.oFlags = OBJ_FLAG_PERSISTENT_RESPAWN | OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.collisionData = gGlobalObjectCollisionData.cannon_lid_seg8_collision_08004950
    cur_obj_set_home_once()
end

---@param o Object
local function cannon_lid_loop(o)
    obj_set_model_extended(o, E_MODEL_DL_CANNON_LID)
    load_object_collision_model()
end

---@param o Object
local function hidden_120_init(o)
    o.oFlags = OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE
    o.collisionData = gGlobalObjectCollisionData.castle_grounds_seg7_collision_cannon_grill
    o.oCollisionDistance = 4000
end

---@param o Object
local function hidden_120_loop(o)
    obj_set_model_extended(o, E_MODEL_CASTLE_GROUNDS_CANNON_GRILL)
    load_object_collision_model()
end

local function allow_interact(m, o, intee)
    if intee == INTERACT_CANNON_BASE then
        return false
    end
end

function for_each_object_with_behavior(behavior, func)
    local obj = obj_get_first_with_behavior_id(behavior)
    while obj do
        func(obj)
        obj = obj_get_next_with_same_behavior_id(obj)
    end
end

-- hooks used for objects
hook_event(HOOK_UPDATE, function () for_each_object_with_behavior(id_bhvExclamationBox, custom_exclamation_box) for_each_object_with_behavior(id_bhvBowser, custom_bowser) end)
hook_behavior(id_bhvBowsersSub, OBJ_LIST_SURFACE, true, custom_ddd_sub_init, custom_ddd_loop)
hook_behavior(id_bhvBowserSubDoor, OBJ_LIST_SURFACE, true, custom_ddd_door_init, custom_ddd_loop)
id_bhvCannonLid = hook_behavior(id_bhvCannonLid, OBJ_LIST_SURFACE, false, cannon_lid_init, cannon_lid_loop, "cannonLid")
hook_behavior(id_bhvCannonClosed, OBJ_LIST_SURFACE, false, function (o)
    spawn_non_sync_object(id_bhvCannonLid, E_MODEL_DL_CANNON_LID, o.oPosX, o.oPosY - 5, o.oPosZ, function (obj)
        obj.oFaceAnglePitch = o.oFaceAnglePitch
        obj.oFaceAngleYaw = o.oFaceAngleYaw
        obj.oFaceAngleRoll = o.oFaceAngleRoll
    end)
    o.activeFlags = ACTIVE_FLAG_DEACTIVATED
end, nil, "cannonClosed")
hook_behavior(id_bhvHiddenAt120Stars, OBJ_LIST_SURFACE, true, hidden_120_init, hidden_120_loop)
hook_event(HOOK_ALLOW_INTERACT, allow_interact)
