unsupported = false

FLOOD_WATER     = 0
FLOOD_LAVA      = 1
FLOOD_SAND      = 2
FLOOD_MUD       = 3
FLOOD_SNOW      = 4
FLOOD_WASTE     = 5
FLOOD_DESERT    = 6
FLOOD_ACID      = 7
FLOOD_POISON    = 8
FLOOD_SUNSET    = 9
FLOOD_FROSTBITE = 10
FLOOD_CLOUDS    = 11
FLOOD_RAINBOW   = 12
FLOOD_DARKNESS  = 13
FLOOD_MAGMA     = 14
FLOOD_SULFUR    = 15
FLOOD_COTTON    = 16
FLOOD_MOLTEN    = 17
FLOOD_OIL       = 18
FLOOD_MATRIX    = 19
FLOOD_BUP       = 20
FLOOD_TIDE      = 21
FLOOD_DARKTIDE  = 22
FLOOD_VOLCANO   = 23
FLOOD_REDTIDE   = 24
FLOOD_OPTIC     = 25

FLOOD_BONUS_LEVELS = 0
FLOOD_LEVEL_COUNT = 0

SKYBOX_NIGHT = 0

-- use fixed collision
gLevelValues.fixCollisionBugs = 1

-- handles some objects
--- @param o Object
function obj_hide(o)
    o.header.gfx.node.flags = o.header.gfx.node.flags | GRAPH_RENDER_INVISIBLE
end

--- @param o Object
function obj_mark_for_deletion_on_sync(o)
    if gNetworkPlayers[0].currAreaSyncValid then obj_mark_for_deletion(o) end
end

----------------------------------------------------------
GAME_VANILLA                              = 0

-- Romhacks --
GAME_STAR_ROAD                            = 1
GAME_SUPER_MARIO_74                       = 2
GAME_SM64_THE_GREEN_STARS                 = 3
GAME_LUIGIS_MANSION_64                    = 4
GAME_STAR_REVENGE_1                       = 5
GAME_STAR_REVENGE_1_3                     = 6
GAME_STAR_REVENGE_3                       = 7
GAME_STAR_REVENGE_6                       = 8
GAME_STAR_REVENGE_4                       = 9
GAME_SCROOGE_64                           = 10
GAME_MARVEL_ADVENTURE                     = 11
GAME_THE_GALACTIC_JOURNEY                 = 12
GAME_SUPER_MARIO_PARALLEL_STARS           = 13
GAME_SM64_SAPPHIRE                        = 14
GAME_THE_MUSHROOM_CUP                     = 15
GAME_SOME_KIND_OF_A_CRASH_GAME            = 16
GAME_KATZE_STUCK_IN_THE_TOILET            = 17
GAME_LUGS_DELIGHTFUL_DIORAMAS             = 18
GAME_SUPER_LUIGI_64_THE_FLOWER_CUP        = 19
GAME_MOONSHINE                            = 20
GAME_BEAT_BLOCK_BEATDOWN                  = 21
GAME_DREAMSCAPE                           = 22
GAME_EUREKA                               = 23
GAME_COLORFUL_LANDS                       = 24
GAME_CURSED_CASTLES                       = 25
GAME_MARIOS_NIGHTMARE_64                  = 26
GAME_STAR_REVENGE_1_5                     = 27
GAME_STAR_REVENGE_5                       = 28
GAME_SUPER_MARIO_64_EXTRA                 = 29
GAME_SUPER_MARIO_ODYSSEY_64               = 30
GAME_MARIOS_TREASURE_DOME                 = 31
GAME_SERVUS_64                            = 32
GAME_SUPER_MARIO_RAINBOW_ROAD             = 33
GAME_LUIGI_THE_VIOLET_STARS               = 34
GAME_SHINING_STARS                        = 35
GAME_FALLEN_STARS                         = 36
GAME_SUPER_MARIO_64_INTO_BOWSERS_CASTLE   = 37
GAME_SM64_TWISTED_ADVENTURES              = 38
GAME_SUPER_MARIO_BROS_64                  = 39
GAME_BLOSSOMING_BLUDS                     = 40
GAME_THE_STOLEN_STARS                     = 41
GAME_LUIGI_AND_THE_FOREST_RUINS           = 42
GAME_DREAM64                              = 43
GAME_TYD64                                = 44
GAME_NICE_MARIO_75                        = 45
GAME_TROUBLE_TOWN                         = 46
GAME_STAR_REVENGE_2_5                     = 47
GAME_KING_BOOS_REVENGE_2                  = 48
GAME_WINTERBOTTOMS_PIE_TRIALS             = 49
GAME_ZTAR_ATTACK_2                        = 50
GAME_GRAND_STAR                           = 51
GAME_STAR_REVENGE_6_9                     = 52
GAME_STAR_REVENGE_4_5                     = 53
GAME_STAR_REVENGE_2                       = 54
GAME_LAST_IMPACT                          = 55
GAME_BRUTAL_MARIO_64                      = 56
GAME_MASTERS_CHALLENGE                    = 57
GAME_TRUMP_64                             = 58
GAME_LAND94                               = 59
GAME_DESPAIR_MARIOS_GAMBIT                = 60
GAME_TREASURE_WORLD                       = 61
GAME_TREASURE_WORLD_DREAM_EDITION         = 62
GAME_SONIC_ADVENTURE_64_DX                = 63
GAME_MUHLY_64                             = 64
GAME_STAR_REVENGE_0_5                     = 65
GAME_WAIFU_CAULDRON                       = 66
GAME_GAMER_MARIOS_DESTINY                 = 67
GAME_CLASSIC_SKYLANDS                     = 68
GAME_PARADISE_ISLAND                      = 69
GAME_LAVABOUNCE_CHALLENGE                 = 70
GAME_SLOPE_CHALLENGE                      = 71
GAME_WALLKICK_CHALLENGE_2                 = 72
GAME_CREEPY_CANYON                        = 73
GAME_SUPER_BELL_THRILL                    = 74
GAME_MOMENTUM_TESTING                     = 75
GAME_TOMATOBIRD8_SINGLE_STAR_SPEEDRUNS    = 76
GAME_LAVA_LAVA_LAVA_LAVA                  = 77
GAME_SUPER_MARIO_8MB                      = 78
GAME_BOWSERS_BEACH                        = 79
GAME_CURSED_WINTER_FOREST                 = 80
GAME_DEADLY_GAS_MINES                     = 81
GAME_CONVENIENT_CONCEIT_COFFIN            = 82
GAME_DIORAMA_OF_EXTREME_SHENANIGANS_64    = 83
GAME_THE_GATE_OF_THE_GOOD                 = 84
GAME_REFINED_BUFFED_PARADOX               = 85
GAME_SMART_SPHERES_0                      = 86
GAME_SENSELESS_DELIRIUM                   = 87
GAME_SUPER_MARIO_74_TEN_YEARS_AFTER       = 88
GAME_SM74EEEEEE                           = 89
GAME_PROJECT_REIMAGINED                   = 90
GAME_KAIZO_MARIO_64                       = 91
GAME_B3313                                = 92
GAME_STAR_REVENGE_7                       = 93
GAME_LUIGIS_MANSION_64_5_SUPER_MODE       = 94
GAME_STAR_REVENGE_7_5                     = 95
GAME_STAR_REVENGE_4_9                     = 96
GAME_SM64_THE_DARK_STARS                  = 97
GAME_ETERNAL_REALM                        = 98
GAME_THROUGH_THE_AGES                     = 99
GAME_YOSHIS_ADVENTURE_64                  = 100
GAME_SLEEPY_TIME_64                       = 101
GAME_SHINING_STARS_2                      = 102
GAME_KAIZO_MARIO_64_2                     = 103
GAME_SM74EEEE                             = 104
GAME_SM74EEEEEE_2                         = 105
GAME_COMPACT_CHALLENGES                   = 106
GAME_JAMMIN_JOURNEY                       = 107
GAME_SUPER_MARIO_64_LENTILEVELS           = 108
GAME_ROCKY_MOUNTAIN_REVISITED             = 109
GAME_SM64_TWISTED_ADVENTURES_2            = 110
GAME_THE_POWER_STAR_JOURNEY               = 111
GAME_BOWSERS_DANK_RAVE_1                  = 112
GAME_BOWSERS_DANK_RAVE_2                  = 113
GAME_BOWSERS_DANK_RAVE_3                  = 114
GAME_SUPER_MARIO_STAR                     = 115
GAME_WW_MOSTRECENT                        = 116
GAME_SM64_MADNESS                         = 117
GAME_YEAR_OF_THE_PLUMBER                  = 118
GAME_SM64_ITS_A_CRASH                     = 119
GAME_RETURN_TO_RETROLAND                  = 120
GAME_LETTERFUL_WOOD_BLOCKS                = 121
GAME_ROYAL_LEGACY                         = 122
GAME_MARIO_HEROES_64                      = 123
GAME_UNKNOWN_ROMHACK_1                    = 124
GAME_URANIUM_MARIO_64                     = 125
GAME_SM64_LAND                            = 126
GAME_FRACTURED_MULTIVERSE                 = 127
GAME_SM74EEE                              = 128
GAME_SM64_THE_BLACK_VIRUS                 = 129
GAME_INVASION_OF_CHUCKYA                  = 130
GAME_TRANSCEDING_THE_RAINBOW              = 131
GAME_PEACHS_FURY                          = 132
GAME_ROBLOX_64                            = 133
GAME_ASTRAL_DIMENSION                     = 134
GAME_MARIO_MAZE_ADVENTURE                 = 135
GAME_OMEGA_MARIO_64                       = 136
GAME_TOWER_OF_DELIGHT                     = 137
GAME_SUPER_MOMOI_64                       = 138

----------------------------------------------------------

game = GAME_VANILLA

--- @class FloodLevel
--- @field public level integer
--- @field public name string
--- @field public flagPos Vec3f
--- @field public flagBase boolean
--- @field public author string
--- @field public speed number
--- @field public area integer
--- @field public type integer
--- @field public time integer
--- @field public startPos Vec3f
--- @field public floodScale number
--- @field public unwantedBhvs table
--- @field public overrideName string
--- @field public overrideWater boolean
--- @field public floodHeight integer
--- @field public pipes table
--- @field public launchpads table
--- @field public capTimer integer
--- @field public act integer
--- @field public overrideSlide boolean
--- @field public powerUp string
--- @field public music table
--- @field public skybox integer
--- @field public separator string
--- @field public bonus boolean

--- @type FloodLevel[]
gLevels = {}
-- localize functions to improve performance
local djui_popup_create = djui_popup_create

-- Vanilla, reimagined by Jzzay
local function flood_load_vanilla_levels()
    game = GAME_VANILLA
    romhackLogo = get_texture_info("logo_sm64")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -1328, y = 260, z = 4663, yaw = 0x8000},
            unwantedBhvs = { id_bhvYoshi },
            pipes = {
                {
                    { x = 2384, y = 70, z = 1961 },
                    { x = 1566, y = 3174, z = -5669, yaw = -16317 }
                }
            },
        },
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x8000}
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -1022, y = -50, z = 745, yaw = 0x8000}
        },
        [4] = {
            level = LEVEL_CASTLE,
            area = 2,
            spawn = {x = 665, y = 1203, z = 2303, yaw = 0x8000}
        },
        [5] = {
            level = LEVEL_CASTLE,
            area = 3,
            spawn = {x = -1123, y = -1074, z = 1336, yaw = 0x0000}
        },
        [6] = {
            level = LEVEL_SL,
            area = 2,
            spawn = {x = 2, y = 0, z = 2091, yaw = 0x8000}
        },
        [7] = {
            level = LEVEL_THI,
            area = 3,
            spawn = {x = 1252, y = 1024, z = -611, yaw = -15123},
            pipes = {
                {
                    { x = -1802, y = 1024, z = 283, yaw = 16387 },
                    { x = 0, y = 2560, z = 0, yaw = 0 }
                }
            },
        },
        [8] = {
            level = LEVEL_TOTWC,
            area = 1,
            spawn = {x = -10, y = -2047, z = 584, yaw = 32729}
        },
        [9] = {
            level = LEVEL_SSL,
            area = 3,
            spawn = {x = 0, y = -1534, z = -2059, yaw = 0x8000}
        },
        [10] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = 0, y = 307, z = 0, yaw = 0x8000}
        },
        [11] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = 0, y = 1229, z = 0, yaw = 0x8000},
            deathHeight = -435
        },
        [12] = {
            level = LEVEL_BOWSER_3,
            area = 1,
            spawn = {x = 0, y = 307, z = 0, yaw = 0x8000}
        },
        [13] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = 0, y = -4402, z = 0, yaw = 0x0000},
            unwantedBhvs = { id_bhvFish },
            overrideWater = true
        },
        [14] = {
            level = LEVEL_CASTLE,
            area = 2,
            spawn = {x = -213, y = 2253, z = 5891, yaw = 0x0000}
        },
        [15] = {
            level = LEVEL_CASTLE,
            area = 3,
            spawn = {x = -1448, y = -1279, z = -3023, yaw = 0x8000}
        },
        [16] = {
            level = LEVEL_PSS,
            area = 1,
            spawn = {x = -6407, y = -2027, z = 4946, yaw = 0x8000},
            unwantedBhvs = { id_bhvExclamationBox },
            pipes = {
                {
                    { x = -6374, y = -4484, z = 5707, yaw = 0x8000 },
                    { x = 5448, y = 6144, z = -5664, yaw = -0x4000 }
                }
            },
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 2985, y = 4293, z = -4815, yaw = 0x8000 },
            flagBase = true,
            speed = 4.3,
            author = "Nintendo",
            type = FLOOD_WATER,
            floodHeight = -1528,
            launchpads = {
                { x = 5377, y = 1532, z = 4609, yaw = -32768, vel = 130, forwardVel = 0 }
            },
            music = { id = 35, name = "Hammer Bros. Battle - Super Mario Bros. 3" }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 414, y = 5325, z = -20, yaw =  -0x2000 },
            speed = 4.5,
            author = "Nintendo",
            type = FLOOD_CLOUDS,
            unwantedBhvs = { id_bhvExclamationBox },
            music = { id = 36, name = "Puzzle Plank Galaxy - Super Mario Galaxy 2" }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x =  4863,  y = 1889,  z = 703, yaw =  -0x1000 },
            speed = 1.85,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = -6268,  y = 1126, z = -151, yaw = 3699 },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideWater = true,
            music = { id = 37, name = "Underwater - Super Mario World" }
        },
        {
            name = "jrb-ship",
            level = LEVEL_JRB,
            area = 2,
            flagPos = { x =  -91,  y = 1475,  z = 3372, yaw =  0x6000 },
            speed = 5.5,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = 517,  y = -351, z = -2261, yaw =  0x10000, spin = false },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "The Sunken Ship",
            overrideWater = true,
            music = { id = 38, name = "Underwater - Super Mario Bros. 3" }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -478, y = 3471, z = -964, yaw = -0x7000 },
            speed = 6.85,
            author = "Nintendo",
            type = FLOOD_SNOW,
            startPos = { x = 3336, y = -4738.15, z = 0, yaw = 0x0000 },
            unwantedBhvs = { id_bhvFadingWarp },
            floodHeight = -6340,
            music = { id = 39, name = "Snow - Super Mario Bros." }
        },
        {
            name = "ccm-slide",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = -5836,  y = 6656, z = -6143, yaw = 0x4000 },
            flagBase = true,
            speed = 7.6,
            author = "Nintendo",
            type = FLOOD_SNOW,
            startPos = { x = -6018, y = -5836, z = -6930, yaw = -0x4000, spin = false },
            floodScale = 2,
            overrideName = "Frosty Slide",
            floodHeight = -9565,
            overrideSlide = true,
            music = { id = 40, name = "Chai Kingdom - Super Mario Land" }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 6772, y = 2867, z = 0, yaw = -0x4000 },
            flagBase = true,
            speed = 5.75,
            author = "Nintendo",
            type = FLOOD_DARKNESS,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },
            floodHeight = -5105,
            music = { id = 41, name = "Sector X - Star Fox 64" }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 655, y = 3277, z = 244, yaw = 0x0000 },
            speed = 4.5,
            author = "Nintendo",
            type = FLOOD_DARKNESS,
            music = { id = 42, name = "Ghost House - Super Mario Bros." }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -7445, y = 2161, z = 7424, yaw = 0x6800 },
            flagBase = true,
            speed = 4.7,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = 6098, y = -3897, z = 2330, yaw = -0x4000, airborne = false },
            unwantedBhvs = { id_bhvExclamationBox, id_bhvDorrie },
            overrideName = "Deep Underground Cave",
            overrideWater = true,
            floodHeight = -7375,
            music = { id = 43, name = "Freeze! - Paper Mario" }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -13, y = 374, z = -6136, yaw = 0x0000 },
            speed = 4.0,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = -4185, y = 546, z = -47, yaw = 0x4000, airborne = false, spin = false },
            unwantedBhvs = { id_bhvExclamationBox },
            music = { id = 44, name = "Masked Dedede - Kirby Triple Deluxe" }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x =  -21,  y = 768,  z = -6709, yaw = 0x0000 },
            flagBase = true,
            speed = 2.1,
            author = "Nintendo",
            type = FLOOD_LAVA,
            startPos = { x = -5881, y = 154, z = 6654, yaw = 28472 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvFadingWarp },
            music = { id = 45, name = "Sammer's Kingdom - Super Paper Mario" }
        },
        {
            name = "lll-volcano",
            level = LEVEL_LLL,
            area = 2,
            flagPos = { x = 2523, y = 3591, z = -898, yaw = -0x7000 },
            speed = 3.5,
            author = "Nintendo",
            type = FLOOD_LAVA,
            overrideName = "Flame-Boiling Volcano",
            music = { id = 46, name = "Chomp Attack - Paper Mario" }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -5890, y = 1024, z = -2555, yaw = 0x1000 },
            speed = 2.3,
            author = "Nintendo",
            type = FLOOD_SAND,
            startPos = { x = 7239, y = 0, z = 7231, yaw = -23215 },
            floodScale = 2,
            unwantedBhvs = { id_bhvKlepto },
            music = { id = 47, name = "Ruins - Super Mario Land" }
        },
        {
            name = "ssl-pyramid",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x = 512, y = 4687, z = -551, yaw = -0x6000 },
            speed = 3.0,
            author = "Nintendo",
            type = FLOOD_DESERT,
            startPos = { x = 0, y = 764, z = 6451, yaw = 0x8000, airborne = false, spin = false },
            overrideName = "The Ancient Pyramid",
            music = { id = 48, name = "Sky Sands - Kirby Air Ride" }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 4088, y = -511, z = 6, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = -4199, y = -5119, z = -1368, yaw = 8124 },
            overrideWater = true,
            music = { id = 49, name = "Egg Rocket Zone 1 - Sonic Advance" }
        },
        {
            name = "ddd-sub",
            level = LEVEL_DDD,
            area = 2,
            flagPos = { x = 1956, y = 843.5, z = -1590, yaw = -0x1000 },
            speed = 4.5,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = 2864, y = -4087, z = -3319, yaw = 5787 },
            overrideName = "Bowser's Submarine Hideout",
            overrideWater = true,
            pipes = {
                {
                    { x = 4882, y = -4087, z = 4434, yaw = -29371 },
                    { x = 1956, y = 110, z = 4657, yaw = 8022 }
                }
            },
            music = { name = "[TBD]" }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 1225, y = 5478, z = 64, yaw = 0x4000 },
            flagBase = true,
            speed = 4.55,
            author = "Nintendo",
            type = FLOOD_LAVA,
            startPos = { x = -7577, y = -2764, z = 0, yaw = 0x4000, spin = false },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvActivatedBackAndForthPlatform },
            floodHeight = -5372,
            music = { id = 51, name = "Bowser Castle - Super Mario 3D World" }
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 4704, y = 0, z = -4391, yaw = 0x8000 },
            speed = 4.35,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = -5442, y = -3276, z =  1222, yaw =  0x4000, spin = false },
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -4744,
            music = { id = 52, name = "Slope - Super Mario RPG" }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x =  246,   y =  4864, z =  -50, yaw =  0x0000 },
            speed = 3.0,
            author = "Nintendo",
            type = FLOOD_FROSTBITE,
            floodScale = 1.5,
            music = { id = 53, name = "White Glacier - Bomberman 64" }
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x =  1467,  y = 4096,  z =  93, yaw = -0x5000 },
            flagBase = true,
            speed = 4.0,
            author = "Nintendo",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideWater = true,
            music = { id = 54, name = "Mafland - maf464" }
        },
        {
            name = "wdw-town",
            level = LEVEL_WDW,
            area = 2,
            flagPos = { x =  -770,  y = -300,  z = 770, yaw = 0x0000 },
            speed = 4.5,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = -3362, y = -2559, z = -1058, yaw = 0x0000 },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Wet-Dry Town",
            overrideWater = true,
            music = { id = 55, name = "Magic Charm Lesson - Magician's Quest - Mysterious Times" }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x =  1053,  y = 2309,  z =  305, yaw =  0x3000 },
            flagBase = true,
            speed = 3.0,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = 103, y = -4332, z = 5735, yaw = 18432 },
            floodScale = 1.25,
            music = { id = 56, name = "Bridge Zone - Sonic the Hedgehog (8-bit)" }
        },
        {
            name = "ttm-slide",
            level = LEVEL_TTM,
            area = 3,
            flagPos = { x = 6014, y = 6437, z = 5781, yaw = -24715 },
            speed = 6.0,
            author = "Nintendo",
            type = FLOOD_DARKNESS,
            startPos = { x = 6844, y = -7473, z = -405, yaw = -16384, airborne = false, spin = false },
            floodScale = 2,
            overrideName = "Mysterious Mountain Slide",
            launchpads = {
                { x = -1308, y = -5322, z = 2310, yaw = 32701, vel = 100, forwardVel = 0 },
            },
            overrideSlide = true,
            music = { id = 57, name = "Mine Cart Riding - Kirby Super Star" }
        },
        {
            name = "thi-small",
            level = LEVEL_THI,
            area = 2,
            flagPos = { x =  774,  y = 968,  z = -697, yaw =  -0x3000 },
            speed = 10.0,
            author = "Nintendo",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "The Tiny Island",
            overrideWater = true,
            music = { id = 58, name = "Overworld Theme - Super Mario Bros. 2" }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -12, y = 3891, z = -1556, yaw = 0x2000 },
            flagBase = false,
            speed = 4.0,
            author = "Nintendo",
            type = FLOOD_WATER,
            floodScale = 2.6,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "The Huge Island",
            act = 1,
            music = { id = 59, name = "Stage 1 (Cappy) - Kirby's Block Ball" }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 2208, y = 6900, z =  2217, yaw =  -0x6000 },
            speed = 5.0,
            author = "Nintendo",
            type = FLOOD_WATER,
            music = { id = 60, name = "Butter Building - Kirby's Adventure" }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -4203, y = 6451, z = -5824, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "Nintendo",
            type = FLOOD_CLOUDS,
            floodScale = 3,
            unwantedBhvs = { id_bhvGoomba },
            launchpads = {
                { x = 3743, y = 4276, z = -2125, yaw = -16472, vel = 120, forwardVel = 47, capTimer = 180 },
                { x = -7569, y = 4352, z = -4300, yaw = 23469, vel = 145, forwardVel = 0 }
            },
            music = { id = 61, name = "Rainbow Route - Kirby & The Amazing Mirror" }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -3116, y = 4557, z = -4264, yaw = 7356},
            speed = 5.9,
            author = "Nintendo",
            type = FLOOD_CLOUDS,
            startPos = { x = 4173, y = -2738, z = 5747, yaw = -18379, spin = false },
            floodScale = 3,
            unwantedBhvs = { id_bhvRedCoin, id_bhvExclamationBox },
            launchpads = {
                { x = 3081, y = -2738, z = 5541, yaw = -18963, vel = 65, forwardVel = 76 },
                { x = -463, y = -1367, z = 4692, yaw = 24520, vel = 50, forwardVel = 90 },
                { x = 47, y = 1732, z = -22, yaw = -25873, vel = 60, forwardVel = 130 }
            },
            pipes = {
                {
                    { x = 4411, y = 174, z = -18, yaw = -10696 },
                    { x = -4450, y = 822, z = 189, yaw = 16437 }
                }
            },
            music = { id = 62, name = "Clouds - Super Mario Bros. 3" }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x =  347,   y = 6652,  z = -6015, yaw =  0x0000 },
            flagBase = true,
            speed = 5.0,
            author = "Nintendo",
            type = FLOOD_POISON,
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { id = 63, name = "It's Showtime! - Mario & Luigi: Bowser's Inside Story" }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 5632, y = 6144, z = -5631, yaw = -0x4000 },
            flagBase = true,
            speed = 5.1,
            author = "Nintendo",
            type = FLOOD_DARKNESS,
            startPos = { x = -6387, y = -4484, z =  5723, yaw = 0x8000, spin = false },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "The Princess' Secret Slide",
            overrideSlide = true,
            music = { id = 64, name = "Bonus Theme - Super Mario World" }
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 0, y = 7600, z = -4025, yaw = 0x0000 },
            speed = 3.8,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = -4325, y = -19, z = -4862, yaw =  0x0000, airborne = false },
            unwantedBhvs = { id_bhvExclamationBox, id_bhvYoshi },
            overrideWater = true,
            floodHeight = -2391,
            launchpads = {
                { x = 12, y = 3174, z = -5655, yaw = 0x0000, vel = 120, forwardVel = 0 }
            },
            music = { id = 65, name = "Warp - Star Fox 64" }
        },
        {
            name = "cu",
            level = LEVEL_CASTLE,
            area = 2,
            flagPos = { x =  -233,    y =  5008, z = -3350, yaw =  0x0000 },
            speed = 3.5,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = -4782, y = 1306, z = -2573, yaw = 0x0000 },
            overrideName = "Castle Upstairs",
            music = { id = 66, name = "Temple (Palace) - The Legend of Zelda II: Adventure Of Link" }
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x =  2864,   y = 4096,  z = 196, yaw =  -0x4000 },
            speed = 4.0,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = -3127, y = 384, z = -1348, yaw = 0x0000 },
            overrideName = "Caged Fortress Tricks",
            music = { id = 67, name = "Castle Lololo - Kirby's Dream Land" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x =  -1829,  y = -2812,  z = -1620, yaw =  0x7000 },
            speed = 6.05,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = 5173, y = -5119, z = 3823, yaw = 0x8000 },
            unwantedBhvs = { id_bhvUnagi },
            overrideName = "Cap'n Ocean Cave",
            overrideWater = true,
            launchpads = {
                { x = 5185, y = -4906, z = 255, yaw = 32412, vel = 200, forwardVel = 85 },
            },
            music = { id = 68, name = "Mt. Blaze - Pokémon Mystery Dungeon: Red/Blue Rescue Team" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -1972, y = -2518,  z = -2930, yaw = 0x4200 },
            speed = 2.3,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = -4210, y = -4607, z =  4528, yaw = 0x8500 },
            floodScale = 2.8,
            overrideName = "Icey Wallkick Challenge",
            music = { id = 69, name = "Frosty Forest - Pokémon Mystery Dungeon" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x =  668,   y = 0,  z =  2472, yaw =  -0x1000 },
            flagBase = true,
            speed = 3.0,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = 2918, y = -2969, z =  1884, yaw = -0x6000 },
            overrideName = "Boo's Haunted Basement",
            overrideWater = true,
            music = { id = 70, name = "Haunted Chase - Donkey Kong Country 2" }
        },
        {
            name = "hmc2",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -2368,  y = 1843,  z = -7644, yaw =  0x2000 },
            speed = 3.0,
            author = "Nintendo",
            type = FLOOD_WASTE,
            startPos = { x = 1998, y = -1023, z = 52, yaw = 0x8000 },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Cloudy Haze Maze",
            music = { id = 71, name = "ChuckleHuck Woods - Mario & Luigi: Superstar Saga" }
        },
        {
            name = "hmc3",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -7445,  y = 2161,  z = 7424, yaw =  0x4000 },
            flagBase = true,
            speed = 3.07,
            author = "Nintendo",
            type = FLOOD_WASTE,
            startPos = { x = 7036, y = 0, z = 4201, yaw = -8242 },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Work Elevator",
            music = { id = 72, name = "Kirby Super Star - The Great Cave Offensive" }
        },
        {
            name = "lll2",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 6318,  y = 639,  z = -6579, yaw =  -0x2000 },
            speed = 1.6,
            author = "Nintendo",
            type = FLOOD_LAVA,
            startPos = { x = 3060, y = 256, z = 8096, yaw = 0x8000 },
            unwantedBhvs = { id_bhv1Up },
            overrideName = "Red-Hot Log Rolling",
            music = { name = "[TBD]" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "thi2",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -5361, y = 780, z = -5957, yaw = 0x2000 },
            speed = 4.0,
            author = "Nintendo",
            type = FLOOD_WATER,
            startPos = { x = 6656, y = -2832, z = 6756, yaw = 0x8000 },
            floodScale = 2.3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Koopa's Island Race",
            floodHeight = -4496,
            act = 1,
            music = { id = 74, name = "Forest Area - Kirby's Adventure" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -5854, y = -1116, z = 4902, yaw = 0x2000 },
            flagBase = true,
            speed = 3.07,
            author = "Nintendo",
            type = FLOOD_CLOUDS,
            startPos = { x = -5725, y = -4598, z = 6599, yaw = 0x4000 },
            floodScale = 2,
            overrideName = "Swingin' In The Breeze",
            music = { id = 75, name = "Never Let Up! - Mario & Luigi: Dream Team" },
            skybox = SKYBOX_NIGHT,
            blocks = {
                { x = 614, y = -1120, z = 3671, yaw = 0x0000 }
            },
        },
        {
            name = "rr3",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 3704, y = -732, z = 6576, yaw = 0x4000 },
            flagBase = true,
            speed = 1.85,
            author = "Nintendo",
            type = FLOOD_CLOUDS,
            startPos = { x = -5216, y = -1935, z = 6558, yaw = 0x4000 },
            floodScale = 2,
            overrideName = "Tricky Triangles",
            music = { name = "[TBD]" }
        }
    }
end

-- Star Road, ported to Flood by Agent X, tweaked by MarcoGamerOJ
local function flood_load_star_road_levels()
    game = GAME_STAR_ROAD
    romhackInfo = "Super Mario Star Road"
    romhackLogo = get_texture_info("logo_smsr")
    LEVEL_ZERO_LIFE = level_register('level_zerolife_entry', COURSE_NONE, 'ZERO LIFE', 'zl', 28000, 0x28, 0x28, 0x28)
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -6797, y = 1831, z = 2710, yaw = 0x6000},
            pipes = {
                {
                    { x = 1414, y = -614, z = -1515, yaw = -0x4000 },
                    { x = 3703, y = 6385, z = -1498, yaw = -0x4000 },
                }
            },
            music = { name = "Starship Mario 1 - Super Mario Galaxy 2" },			
        },
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -989, y = 711, z = -3405, yaw = 0x0000},
            pipes = {
                {
                    { x = -989, y = 1512, z = 600, yaw = 0x8000 },
                    { x = -989, y = 3711, z = 600, yaw = 0x8000 },
                },

                {		
                    { x =  2295, y = -3284, z =  6302, yaw = 0x8000 },
                    { x = -4280, y =  1613, z = -1243, yaw = 0x4000 },
                },
            },
            music = { name = "Rosalina in the Observatory - Super Mario Galaxy" },			
        },
        [3] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 2295, y = -3284, z = 6302, yaw = 0x8000},
            unwantedBhvs = { id_bhvWarpPipe },
            pipes = {
                {		
                    { x = 7073, y = -3200, z = 3904, yaw = -0x4000 },
                    { x = 4490, y = -3179, z = 1915, yaw =  0x8000 },					
                },
            },
            music = { name = "Rosalina in the Observatory - Super Mario Galaxy" },			
        },
        [4] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 4324, y = 66, z = -1895, yaw = -24576},
            unwantedBhvs = { id_bhvExclamationBox },
            pipes = {
                {
                    { x = 2260, y = -31, z = -280, yaw = -0x6000 },
                    { x = 6540, y = -836, z = 5613, yaw = 0x0000 }
                }
            },	
            music = { name = "Gateway Galaxy (To the Gateway) - Super Mario Galaxy" },		
        },
        [5] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = -899, y = -926, z = -1088, yaw = 0x0000},
            music = { name = "Vs. Parasite Queen - Metroid Prime" },
        },
        [6] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = -48, y = 1004, z = -3192, yaw = 0x0000},
            music = { name = "Come On, Again! - Mario & Luigi: Superstar Saga" },
        },
        [7] = {
            level = LEVEL_BOWSER_3,
            area = 1,
            spawn = {x = 0, y = 235, z = 0, yaw = 0x0000},
            music = { name = "Dark Castle - Kirby's Dream Land 2" },
        },
        [8] = {
            level = LEVEL_ZERO_LIFE,
            area = 1,
            spawn = {x = -4728, y = -3649, z = 0, yaw = 0x2000},
            music = { name = "Sadness and Happiness - Paper Mario: The Thousand-Year Door" },
        },
        [9] = {
            level = LEVEL_ENDING,
            area = 1,
            spawn = {x = -7165, y = 1831, z = 2710, yaw = 0x6000},	
            pipes = {
                {
                    { x = -2190, y = -721, z = -1390, yaw = -0x4000 },
                    { x = -1675, y = -721, z = -1390, yaw =  0x4000 }
                },
                {
                    { x = 1195, y = -721, z = -1390 },
                    { x = 3450, y = 6278, z = -1390, yaw = -0x4000 }				
                }
            },
            music = { name = "The Star Festival - Super Mario Galaxy" },					
        },
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 5396, y = 1875, z = 2257, yaw = -0x3000 },
            flagBase = false,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 2,
            music = { name = "Green Garden - Bomberman 64" },
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -552,  y = 2448,  z = -1683, yaw = 21146 },
            flagBase = true,
            speed = 5.0,
            author = "Skelux",
            type = FLOOD_CLOUDS,
            floodScale = 2,
            music = { name = "Let's Do the Fluff-Fluff! - Super Mario RPG" },
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x =  4242, y = 3185, z = 4343, yaw = 0x0000 },
            flagBase = false,
            speed = 5.0,
            author = "Skelux",
            type = FLOOD_CLOUDS,
            floodScale = 2,
            startPos = { x =  4242, y = 112, z =  777,  yaw = 0x0000},
            overrideName = "Climb The Windmill",
            floodHeight = -1980,
            music = { id = 14, name = "Let's Go Lightly - Mario Party" },
        },
        {
            name = "wf3",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x =  7474, y = 1876, z = -1745, yaw = -0x4000 },
            flagBase = true,
            speed = 4.0,
            author = "Skelux",
            type = FLOOD_CLOUDS,
            floodScale = 2,
            startPos = { x =  2315, y = -2166, z =  3185,  yaw = -0x4000},
            overrideName = "Finding The Switch",
            music = { id = 14, name = "Let's Go Lightly - Mario Party" },
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -4672, y = 3541,  z = -3619, yaw = -0x4000 },
            flagBase = false,
            speed = 3.5,
            author = "Skelux",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Beware the Forest's Mushrooms - Super Mario RPG" },
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x =  5578, y = 540,  z = -6500, yaw = -0x2000 },
            flagBase = false,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_WATER,
            startPos = { x = -5333, y = -341,  z =  6939, yaw =  0x6000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "The Flooded Piranha Plant Pond",
            music = { id = 11, name = "Ground Theme (Lullaby Mix) - Super Mario Bros." },
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x =  3775, y = 3501,  z = -3865, yaw = 0x0000 },
            flagBase = false,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 2,
            music = { name = "In a Snow-Bound Land - Donkey Kong Country 2: Diddy's Kong Quest" },
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x =  3333, y = 1897,  z =  6363, yaw = 0x8000 },
            flagBase = false,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 2,
            startPos = { x =  3578, y = -5266, z =  3285,  yaw = 0x0000},
            overrideName = "The Underwater Maze",
            overrideWater = true,
            launchpads = {
                { x = 3940, y = -3828, z =  3620, yaw = 32412, vel = 202, forwardVel = 0 },
            },
            music = { id = 13, name = "Where Am I Going? - Super Mario RPG" },
        },
        {
            name = "ccm3",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -5925, y = 537,  z =  2465, yaw = 0x0000 },
            flagBase = false,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 2,
            act = 1,
            unwantedBhvs = { id_bhvExclamationBox },
            startPos = { x =  3939, y = -3678, z =  4835,  yaw = 0x8000},
            overrideName = "Into The Flooded Cage",
            overrideWater = true,
            launchpads = {
                { x =  1700, y = -3849, z =  3012, yaw = 32412, vel = 140, forwardVel = 0 },
                { x = -4500, y = -1666, z =  2929, yaw = 32412, vel = 111, forwardVel = 0 },
            },
            music = { id = 13, name = "Where Am I Going? - Super Mario RPG" },
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x =  2033, y = 10225, z =  4960, yaw = -0x4000 },
            flagBase = false,
            speed = 3.5,
            author = "Skelux",
            type = FLOOD_LAVA,
            startPos = { x =  4478, y =  5324, z = -313, yaw = -0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            capTimer = 1,
            music = { name = "Koopaseum - Mario & Luigi: Partners in Time" },
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x =  4376, y = 2632,  z = -4542, yaw =  0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "Skelux",
            type = FLOOD_DARKNESS,
            floodScale = 2,
            act = 1,
            music = { name = "Waltz of the Boos - Super Mario Galaxy" },
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -5185, y = 1020,  z = -5578, yaw =  0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "Skelux",
            type = FLOOD_DARKNESS,
            floodScale = 2,
            act = 1,
            startPos = { x =  888, y = -761, z =  3000,  yaw = 0x8000},
            overrideName = "Top Of The Risky Walkway",
            music = { id = 15, name = "Meta Crystal - Super Smash Bros." },
        },
        {
            name = "bbh3",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x =  5678, y = 675,  z =  5833, yaw = -0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "Skelux",
            type = FLOOD_DARKNESS,
            floodScale = 2,
            act = 4,
            overrideName = "The Lone Three",
            music = { id = 15, name = "Meta Crystal - Super Smash Bros." },
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x =  6355, y = 874,   z =  866, yaw = -0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_WATER,
            startPos = { x = -4766, y =  30,   z = -443, yaw =  0x4000 },
            music = { name = "The Engine Room - Space Station Silicon Valley" },
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -3415, y = 4573,  z =  2678, yaw =  -0x5000 },
            flagBase = false,
            speed = 2.5,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 2,
            unwantedBhvs = { id_bhvKoopa },
            overrideWater = true,
            music = { name = "Outset Island - The Legend of Zelda: The Wind Waker" },
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x =  455,  y = 2324,  z =  0, yaw =  0x8000 },
            flagBase = false,
            speed = 1.5,
            author = "Skelux",
            type = FLOOD_WASTE,
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Bayou Boogie - Donkey Kong Country 2" },
        },
        {
            name = "b1",
            level = LEVEL_BOWSER_1,
            area = 1,
            flagPos = { x =  1780, y = 990,  z = 4200, yaw = -0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "Skelux",
            type = FLOOD_WASTE,
            floodScale = 2,
            overrideName = "Piranhas' Swampy Hideout",
            music = { name = "Vs. Parasite Queen - Metroid Prime" },
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x =  2454, y = 4160,  z = -5055, yaw =  0x4000 },
            flagBase = false,
            speed = 0.95,
            author = "Skelux",
            type = FLOOD_WATER,
            startPos = { x =  6337, y =  3662, z =  4337, yaw =  0x0000 },
            floodScale = 2,
            overrideWater = true,
            music = { name = "Rainbow Resort - Kirby's Adventure" },
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x =  4348, y = 4638,  z =  3877, yaw = -0x4000 },
            flagBase = false,
            speed = 5.5,
            author = "Skelux",
            type = FLOOD_DESERT,
            floodScale = 2,
            music = { name = "Dry-Dry Desert Trek - Paper Mario" },
        },
        {
            name = "lll2",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -1141, y = 2284,  z = -6767, yaw =  0x0000 },
            flagBase = false,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_DESERT,
            floodScale = 2,
            floodHeight = -3500,
            act = 5,
            startPos = { x = 3178, y = -756, z = 2285, yaw = 0x8000},
            overrideName = "Inside The Pyramid",
            music = { id = 30, name = "Desert Hills - Mario Kart DS" },
        },
        {
            name = "lll3",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -3878, y = 1860, z = 4305, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_DESERT,
            floodScale = 2,
            floodHeight = -5000,
            startPos = { x = -1919, y = -1387, z = 5000, yaw = -0x4000},
            overrideName = "Sinky Spiral Cave",
            music = { id = 30, name = "Desert Hills - Mario Kart DS" },
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -33, y = 3609,  z =  1779, yaw =  0x4000 },
            flagBase = false,
            speed = 4.0,
            floodHeight = -2000,
            author = "Skelux",
            type = FLOOD_WATER,
            act = 6,
            music = { name = "Overworld Theme - Super Mario World 2: Yoshi's Island" },
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x =  4115,  y = 1735,  z = -5478, yaw =  0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_CLOUDS,
            startPos = { x = -1304, y = -2296, z =  4486, yaw =  0x0000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Harmony - Rayman" },
        },
        {
            name = "ddd2",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -2549,  y = 1891,  z = -6195, yaw =  0x0000 },
            flagBase = false,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_CLOUDS,
            startPos = { x = -5533, y = -218, z = -1080, yaw =  0x8000 },
            floodScale = 2,
            floodHeight = -2500,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Crazy Note Climb",
            music = { id = 14, name = "Let's Go Lightly - Mario Party" },
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x =  3762, y =  3532,  z =  2252, yaw = -0x4000 },
            flagBase = false,
            speed = 5.5,
            author = "Skelux",
            type = FLOOD_DESERT,
            startPos = { x = 5668, y = -6010, z = -5719, yaw = 0x0000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Desert Hills - Mario Kart DS" },
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x =  3260, y =  584,   z =  4472, yaw = -0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "Skelux",
            type = FLOOD_MOLTEN,
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -2500,
            music = { name = "Castle Theme - Super Mario World" },
        },
        {
            name = "bitfs2",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x =  256,  y =  584,   z = -2256, yaw =  0x0000 },
            flagBase = false,
            speed = 2.5,
            author = "Skelux",
            type = FLOOD_MOLTEN,
            unwantedBhvs = { id_bhvExclamationBox },
            startPos = { x = -5757, y = -215, z = -525,   yaw = 0x0000},
            overrideName = "Another Way?",
            music = { id = 34, name = "Come On, Again! - Mario & Luigi: Superstar Saga" },
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -3591, y = 2603,  z =  868, yaw =  0x4000 },
            flagBase = false,
            speed = 3.5,
            author = "Skelux",
            type = FLOOD_CLOUDS,
            floodScale = 2,
            act = 1,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Chameleon Twist 2 - Toy Land" },
        },
        {
            name = "wdw2",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x =  3802, y =  653,  z = -2799, yaw =  0x8000 },
            flagBase = false,
            speed = 3.5,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 2,
            startPos = { x = -4002, y = -4521, z =  1929, yaw =  0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Tuxie's Slide",
            music = { id = 9, name = "Circuit Theme - Mario Kart: Double Dash!!" },
        },
        {
            name = "wdw3",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x =  1278, y = 4253,  z = -915, yaw =  0x8000 },
            flagBase = false,
            speed = 3.5,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 2,
            startPos = { x =  1053, y = -1296, z = -4600, yaw =  0x0000 },
            overrideName = "Pole-Jumping",
            music = { id = 22, name = "Boss Battle - Super Mario Sunshine" },
        },
        {
            name = "wdw4",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x =  4765, y =  5154,  z =  4321, yaw =  0x8000 },
            flagBase = false,
            speed = 3.5,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -1000,
            startPos = { x =  2059, y =  1949, z =  1836, yaw =  0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Climb The Toy Tower",
            music = { id = 22, name = "Boss Battle - Super Mario Sunshine" },
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x =  4543, y = 3709,  z =  3311, yaw =  0x8000 },
            flagBase = false,
            speed = 2.5,
            author = "Skelux",
            type = FLOOD_FROSTBITE,
            floodScale = 2,
            floodHeight = -2000,
            music = { name = "Ice Mountain Zone Act 1 - Sonic Advance" },
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x =  1033, y = 4813,  z = -6320, yaw =  0x0000 },
            flagBase = false,
            speed = 2.0,
            author = "Skelux",
            type = FLOOD_CLOUDS,
            floodScale = 3,
            music = { name = "Honeyhop Galaxy - Super Mario Galaxy 2" },
        },
        {
            name = "ttm2",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x =  5858, y = 4714,  z =  5757, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_CLOUDS,
            floodScale = 3,
            act = 3,
            startPos = { x = -2478, y = -923, z =  3838, yaw =  0x0000 },
            overrideName = "Fluffy Castle Climb",
            music = { id = 14, name = "Let's Go Lightly - Mario Party" },
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -4221, y = 4635,  z =  1941, yaw =  0x0000 },
            flagBase = false,
            speed = 4.0,
            author = "Skelux",
            type = FLOOD_WATER,
            startPos = { x =  3113, y = -1839, z =  4678, yaw =  -0x4000 },
            floodScale = 2.5,
            overrideWater = true,
            music = { name = "Windy Hill ...for Windy Valley - Sonic Adventure" },
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x =  1796, y = 2879,  z =  5015, yaw =  0x8000 },
            flagBase = false,
            speed = 2.5,
            author = "Skelux",
            type = FLOOD_LAVA,
            floodScale = 2,
            floodHeight = -2000,
            music = { name = "Magma Mountain - Mario Party" },
        },
        {
            name = "thi2",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x =  1500, y = 2323,  z = -4185, yaw =  0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "Skelux",
            type = FLOOD_LAVA,
            floodScale = 2,
            floodHeight = -3500,
            act = 2,
            startPos = { x = -6615, y = -1505, z = -3115, yaw =  0x4000, airborne = false, spin = false },
            overrideName = "Into The Volcano",
            music = { id = 15, name = "Meta Crystal - Super Smash Bros." },
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x =  1405, y = 3425,  z = -3463, yaw =  -0x4000 },
            flagBase = false,
            speed = 4.0,
            author = "Skelux",
            type = FLOOD_ACID,
            floodScale = 2,
            music = { name = "Battlerock Galaxy - Super Mario Galaxy" },
        },
        {
            name = "ttc2",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x =  1655, y = 3425,  z =  1987, yaw =  -0x4000 },
            flagBase = false,
            speed = 4.0,
            author = "Skelux",
            type = FLOOD_ACID,
            floodScale = 2,
            startPos = { x =  1655, y = 425,  z = -333,  yaw =  0x0000 },
            overrideName = "Wallkick Up The Tower",
            music = { id = 22, name = "Boss Battle - Super Mario Sunshine" },
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x =  5052, y = 11056, z =  413, yaw = -0x4000 },
            flagBase = false,
            speed = 4.0,
            author = "Skelux",
            type = FLOOD_ACID,
            startPos = { x =  3923, y = -3283, z = -1323, yaw =  0x8000, airborne = false },
            floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideSlide = true,
            music = { name = "Buoy Base Galaxy - Super Mario Galaxy" },
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x =  1864, y = 4192,  z =  137, yaw =  0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_RAINBOW,
            floodScale = 2,
            music = { name = "X-Naut Fortress - Paper Mario: The Thousand-Year Door" },
        },
        {
            name = "bits2",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -1664, y =  1872,  z =  6585, yaw =  0x8000 },
            flagBase = false,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_RAINBOW,
            floodScale = 2,
            floodHeight = -3500,
            startPos = { x =  3848, y = -415,  z =  2535, yaw = -0x4000 },
            overrideName = "Climb To The Moon",
            music = { id = 13, name = "Where Am I Going? - Super Mario RPG" },
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x =  4990, y = 3989,  z = 720, yaw =  -0x4000 },
            flagBase = false,
            speed = 2.0,
            author = "Skelux",
            type = FLOOD_CLOUDS,
            floodScale = 2.5,
            music = { name = "Overthere Stair - Super Paper Mario" },
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x =  3475, y =  6385,  z = -1498, yaw = -0x4000 },
            flagBase = false,
            speed = 4.0,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 3,
            floodHeight = -2000,
            startPos = { x = -6797, y = 1831, z = 2710, yaw = 0x6000, airborne = false },
            overrideName = "Castle Grounds",
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            launchpads = {
                { x = 7513, y =  1050, z = -1515, yaw = 32412, vel = 130, forwardVel = 0 },
                { x = 1983, y =  2595, z = -1515, yaw = 32412, vel = 180, forwardVel = 0 },
            },
            music = { id = 13, name = "Where Am I Going? - Super Mario RPG" },
        },
        {
            name = "ending",
            level = LEVEL_ENDING,
            area = 1,
            flagPos = { x = -8955, y = 2746,  z = 2465, yaw =  0x4000 },
            speed = 20.0,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 3,
            startPos = { x = -2050, y = -614,  z = -1400, yaw = -0x4000 },
            overrideName = "Run Challenge",
            floodHeight = -4010,
            music = { id = 9, name = "Circuit Theme - Mario Kart: Double Dash!!" },
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = -989, y =  2953,  z = -1353, yaw =  0x4000 },
            flagBase = false,
            speed = 4.0,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 2, 
            startPos = { x = -989, y = 711, z = -3405, yaw = 0x0000},
            overrideName = "Castle Candelabrum",
            music = { name = "Rosalina in the Observatory - Super Mario Galaxy" },
        },
        {
            name = "cc2",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x =  7777, y = -2530,  z =  2828, yaw = -0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "Skelux",
            type = FLOOD_WATER,
            floodScale = 2, 
            startPos = { x = 2295, y = -3284, z = 6291, yaw = 0x8000 },
            overrideName = "Castle Flowpipe Sewer",
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            music = { name = "Rosalina in the Observatory - Super Mario Galaxy" },
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x =  -7759, y = 571,  z = -6670, yaw =  0x3000 },
            flagBase = false,
            speed = 1.0,
            author = "Skelux",
            type = FLOOD_CLOUDS,
            floodScale = 2.5,
            overrideName = "The Star Road",
            music = { name = "Gateway Galaxy - Super Mario Galaxy" },
        },
        {
            name = "zl",
            level = LEVEL_ZERO_LIFE,
            area = 1,
            flagPos = { x =  2600, y = -2600,  z = 2850, yaw =  -0x5000 },
            flagBase = false,
            speed = 4.0,
            author = "Skelux",
            type = FLOOD_DARKNESS,
            music = { name = "Sadness and Happiness - Paper Mario: The Thousand-Year Door" },
        },
    }
end

-- Super Mario 74, ported to Flood by MarcoGamerOJ, tweaked by ★~¡TOÑO!~★
-- Super Mario 74: Extreme Edition, ported to Flood by ★~¡TOÑO!~★
local function flood_load_super_mario_74_levels()
    game = GAME_SUPER_MARIO_74
    romhackInfo = "Super Mario 74 & Extreme Edition"
    romhackLogo = get_texture_info("logo_sm74")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -3469, y = -861, z = 5002, yaw = 0x8000},
            pipes = {
                {
                    { x = -445, y = -714, z = -2325 },
                    { x = 3835, y = 1147, z = -5515, yaw = -0x4000 }
                }
            },
            music = { name = "Flipside - Super Paper Mario" }
        },
        [2] = {
            level = LEVEL_WMOTR,
            area = 1,
            spawn = {x = -612, y = -1578, z = 3727, yaw = 0x8000},
            music = { name = "Flipside - Super Paper Mario" }
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 147, y = -1411, z = -3948, yaw = 0x0000},
            music = { name = "Flipside - Super Paper Mario" }
        },
        [4] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = 0, y = -4385, z = 1020, yaw = 0x8000},
            music = { name = "Eternal Star - Mario Party" }
        },
        [5] = {
            level = LEVEL_TOTWC,
            area = 1,
            spawn = {x = 550, y = -1545, z = -225, yaw = 0x4000},
            launchpads = {
                { x = 535, y = -1521, z = -890, yaw = 0x8000, vel = 50, forwardVel = 0.1 },
            },
            music = { name = "Lethal Lava Land - Super Mario 64" }
        },
        [6] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 2,
            spawn = {x = 5480, y = -920, z = 6320, yaw = 0x8000},
            pipes = {
                {
                    { x = 750, y = -765, z = -1480 },
                    { x = -3710, y = 1229, z = -5380, yaw = 0x4000 }
                }
            },
        },
        [7] = {
            level = LEVEL_WMOTR,
            area = 2,
            spawn = {x = 1100, y = -787, z = -3790, yaw = 0x0000},
            music = { name = "Flipside - Super Paper Mario" }
        },
        [8] = {
            level = LEVEL_CASTLE,
            area = 2,
            spawn = {x = -260, y = -1365, z = -4350, yaw = 0x0000},
            music = { name = "None" }
        },
        [9] = {
            level = LEVEL_SA,
            area = 2,
            spawn = {x = 6020, y = -85, z = -5565, yaw = -0x4000},
            music = { name = "Intro - Yoshi's Adventure" }
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x =  3175, y = 1667, z =  2245, yaw =  0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -3332, y = -1014,  z = -4443, yaw = 0x0000, airborne = true },
            overrideName = "Dice-Fortress",
            music = { name = "Bob-Omb Battlefield (Peach's Message Mix) - Super Mario 64" }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -5151, y = 3487, z =  1265, yaw =  0x4000 },
            speed = 4.0,
            author = "Lugmillord",
            type = FLOOD_CLOUDS,
            startPos = { x = -2457, y = -3174, z = -1530, yaw = 0x6000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Skyward Slopes",
            music = { name = "Title Theme - Super Mario 64" }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -3797, y = 4323, z = 576, yaw =  0x4500 },
            speed = 3.5,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -4206, y =  2885, z = -5035, yaw = 0x0000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Azure-Abyss",
            music = { name = "Dire, Dire Docks - Super Mario 64" }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -3100, y = 1100, z = -2378, yaw =  0x4000 },
            speed = 3.5,
            author = "Lugmillord",
            type = FLOOD_WASTE,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Toxic-Switch Of Danger",
            floodHeight = -1415,
            capTimer = 1,
            music = { name = "Cave Dungeon - Super Mario 64" }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 2910, y = 4090, z = 1800, yaw = -0x4000 },
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = 3620, y = -963,  z = -5305, yaw = -0x2000, airborne = true },
            overrideName = "Bowser's Badlands-Battlefield",
            unwantedBhvs = { id_bhvWarpPipe },
            floodHeight = -2100,
            music = { name = "Koopa's Road - Super Mario 64" }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -4890, y = 1060,  z = 40, yaw = 0x8000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = 2520, y = -1000,  z = -5350, yaw = -0x4000, airborne = true },
            overrideName = "System Of A Town",
            floodHeight = -1600,
            music = { name = "Bob-Omb Battlefield (Peach's Message Mix) - Super Mario 64" }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x =  55,   y = 3605, z = -4215, yaw =  0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_POISON,
            startPos = { x = -74,   y = -2446, z = -5059, yaw = 0x0000, airborne = true },
            overrideName = "Haunted Factory",
            music = { name = "Frantic Factory - Donkey Kong 64" }
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -1410, y = 3615, z = -1135, yaw = 0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_DARKNESS,
            startPos = { x = -6187, y = -1372, z = -880, yaw = 0x4000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Dust-Switch Of Identity",
            capTimer = 1,
            music = { name = "Windmill Hut - The Legend Of Zelda: Ocarina Of Time" }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -3290, y = 4670, z = 1380, yaw = 0x8000 },
            speed = 4.75,
            author = "Lugmillord",
            type = FLOOD_FROSTBITE,
            startPos = { x =  152,  y = -7482, z =  2093, yaw = 0x4000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Frozen Slide",
            launchpads = {
                { x = 2810, y = -3830, z = -2510, yaw = 32701, vel = 90, forwardVel = 0 },
                { x = 2820, y = -3830, z = -3265, yaw = 32701, vel = 90, forwardVel = 0 }
            },	
            overrideSlide = true,
            music = { name = "Slider - Super Mario 64" }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -4939, y = 2106, z =  4515, yaw =  0x8000 },
            flagBase = true,
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x =  6620, y =  453,  z =  3016, yaw = 0x2000, airborne = true },
            overrideName = "Stalagmite Cave",
            music = { name = "Cave Dungeon - Super Mario 64" }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x =  1083,  y = 11934, z = 556, yaw = -0x4000 },
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_SNOW,
            startPos = { x =  1105, y = -2314, z = -2325, yaw =  0x0000, airborne = false },
            overrideName = "Ice Crystal-Tower",
            music = { name = "Snow Mountain - Super Mario 64" }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -4680, y = 4630, z = 5460, yaw =  0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_DESERT,
            startPos = { x =  4160, y = -1298,  z = -4435, yaw = 0x0000, airborne = true },
            overrideName = "Overheating Oasis",
            music = { name = "Lethal Lava Land - Super Mario 64" }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -3965, y = 1908, z = -4315, yaw =  0x0000 },
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -3155, y = -3635, z = -5022, yaw = 0x0000, airborne = true },
            overrideName = "Flowery Gardens",
            music = { name = "Bob-Omb Battlefield (Peach's Message Mix) - Super Mario 64" }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -3290, y = 1310, z = 6025, yaw =  0x7000 },
            flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = 1068, y = -468, z = -3178, yaw = 0x0000, airborne = true, spin = false },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Bowser's Aquatic Castle",
            music = { name = "Koopa's Road - Super Mario 64" }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 4405, y =  2648, z =  4878, yaw = -0x4000 },
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -4088, y = -1512, z = -6492, yaw = 0x3000, airborne = true },
            unwantedBhvs = { id_bhvKoopa },
            overrideName = "Swampy Spring",
            blocks = {
                { x = 4405, y = 2341, z = 4878, yaw = 0x0000 },
            },
            music = { name = "Dire, Dire Docks - Super Mario 64" }
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -263,  y = 3189, z = -4996, yaw =  0x4000 },
            speed = 3.5,
            author = "Lugmillord",
            type = FLOOD_WATER,
            overrideName = "Sunny Beach",
            floodHeight = -1500,
            music = { name = "Bob-Omb Battlefield (Peach's Message Mix) - Super Mario 64" }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x =  134,  y = 2840, z = -653, yaw =  0x0000 },
            flagBase = true,
            speed = 1.8,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x =  110,  y = -2197, z = -2908, yaw = 0x0000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Cliff Of Wrath",
            music = { name = "Bob-Omb Battlefield (Peach's Message Mix) - Super Mario 64" }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x =  112,  y = 1778, z = -1998, yaw =  0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = 1,  y = -1740, z = -2284, yaw = 0x0000, airborne = true },
            overrideName = "Champion's Challenge",
            music = { name = "Eternal Star - Mario Party" }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x =  -3418, y = 3186, z = 4618, yaw =  0x8000 },
            speed = 5.0,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x =  -550,    y =  -497,    z =  -362, yaw = 0x3000, airborne = true},
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Molten Treasure Chest",
            music = { name = "Lethal Lava Land - Super Mario 64" }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -3950, y = 1990, z = -4565, yaw =  0x0000 },
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_CLOUDS,
            floodScale = 1.5,
            overrideName = "Luminium-Sphere",
            floodHeight = -4460,
            music = { name = "Stone Tower Temple - The Legend Of Zelda: Majora's Mask" }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 3660, y = 3240, z = -5925, yaw = 0x0000 },
            speed = 4.0,
            author = "Lugmillord",
            type = FLOOD_DARKNESS,
            startPos = { x = -3050,  y = -3238, z = 7225, yaw = 0x4000, airborne = true },
            floodScale = 1.5,
            overrideName = "Ombru-Sphere",	
            music = { name = "Stone Tower Temple (Inverted) - The Legend Of Zelda: Majora's Mask" }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x =  1749, y = 857,  z = -1189, yaw = -0x4000 },
            speed = 1.0,
            author = "Lugmillord",
            type = FLOOD_DARKNESS,
            startPos = { x = -13,  y = -1741, z = -7806, yaw = -0x2000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Bowser's Crystal Palace",
            launchpads = {
                { x = -3600, y = -1590, z = 1155, yaw = 0x0000, vel = 50, forwardVel = 0 },
            },
            music = { name = "Hideout Helm - Donkey Kong 64" }
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = -3370,  y = 1665, z = 6155, yaw =  -0x4000 },
            flagBase = false,
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = 5630,  y = -882, z = -5195, yaw = -0x4000, airborne = true },
            overrideName = "Valley Of The Toads",
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Flipside - Super Paper Mario" }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 5880,  y = 4763, z = 3997, yaw =  -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -612, y = -1578, z = 3727, yaw = 0x8000, airborne = true },
            overrideName = "Tower Of The East",
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Flipside - Super Paper Mario" }
        },
        {
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 5915,  y = 1750, z = 6965, yaw = -0x6000 },
            flagBase = true,
            speed = 4.0,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x = 147,  y = -1411, z =  -3943, yaw = 0x0000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Magma Temple",
            music = { name = "Flipside - Super Paper Mario" }
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 2740, y = 2280, z = -3305, yaw = -0x2000 },
            flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -3115, y = -1400,  z = 3510, yaw = 0x8000, airborne = true },
            overrideName = "Secrets Of The Sky",
            floodHeight = -2100,
            music = { name = "Bob-Omb Battlefield (Peach's Message Mix) - Super Mario 64" },
            skybox = SKYBOX_NIGHT,
            separator = "Extras"
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 3920, y = 2805, z = -825, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_CLOUDS,
            startPos = { x = 5080, y = -2315,  z = -4820, yaw = 0x0000, airborne = true },
            unwantedBhvs = { id_bhvFloorSwitchHiddenObjects },
            overrideName = "To The Top Of The Tower",
            music = { id = 11, name = "Stone Tower Temple - The Legend Of Zelda: Majora's Mask" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 760, y = 3880, z = 4520, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = 4745, y = 2700, z = -1485, yaw = 0x8000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Timed Boxes Switch",
            overrideWater = true,
            floodHeight = -100,
            pipes = {
                {
                    { x = 3315, y = 3487, z = -3650 },
                    { x = -6200, y = 3194, z = 6300, yaw = 0x6000 }
                }
            },
            music = { name = "Dire, Dire Docks - Super Mario 64" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "cotmc2",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -2505, y = 1170, z = 870, yaw = 0x0000 },
            speed = 4.0,
            author = "Lugmillord",
            type = FLOOD_WASTE,
            startPos = { x = 725, y = -470,  z = -2185, yaw = 28625, airborne = false },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Wallkick Challenge",
            capTimer = 1,
            music = { name = "Cave Dungeon - Super Mario 64" }
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -1550, y = 1805, z = -5220, yaw = -0x4000 },
            speed = 3.5,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x =  590, y = -2295,  z = -1565, yaw = -9755, airborne = true },
            overrideName = "The Mansion Roof",
            overrideWater = true,
            floodHeight = -3000,
            blocks = {
                { x = -4585, y = 870, z = -5215, yaw = 0x0000 },
            },
            music = { name = "Bob-Omb Battlefield (Peach's Message Mix) - Super Mario 64" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "ccm3",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 5385,  y = 1370,  z = 6095,   yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = 2825, y = -2295,  z = 2055, yaw = -0x3000, airborne = true },
            overrideName = "Into The Sewer System",
            overrideWater = true,
            floodHeight = -2500,
            music = { name = "Bob-Omb Battlefield (Peach's Message Mix) - Super Mario 64" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "ccm4",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 4150, y = 1650, z = -2230, yaw = -0x4000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -3565, y = -550, z = -685, yaw = 0x4000, airborne = false },
            overrideName = "The Secondary House",
            overrideWater = true,
            music = { name = "Bob-Omb Battlefield (Peach's Message Mix) - Super Mario 64" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 6135, y = 380, z = 2055, yaw = -0x4000 },
            flagBase = true,
            speed = 1.75,
            author = "Lugmillord",
            type = FLOOD_POISON,
            startPos = { x = -5270, y = -1090,  z = 1655, yaw = -0x4000, airborne = false },
            overrideName = "Blocks Of Doom",
            music = { name = "Frantic Factory - Donkey Kong 64" }
        },
        {
            name = "vcutm2",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 1500, y = -20, z = 4740, yaw = -0x4000 },
            flagBase = true,
            speed = 1.0,
            author = "Lugmillord",
            type = FLOOD_DARKNESS,
            startPos = { x = 1850, y = -1530,  z = -7280, yaw = -0x0000, airborne = true, spin = false },
            overrideName = "Timed Boxes Through Webs",
            capTimer = 1,
            music = { name = "Windmill Hut - The Legend Of Zelda: Ocarina Of Time" }
        },
        {
            name = "hmc2",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 6430, y = 2290, z = -840, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x = -970, y = -280, z = -5235, yaw = -0x4000, airborne = true },
            overrideName = "Chuckya's Challenge",
            music = { name = "Cave Dungeon - Super Mario 64" }
        },
        {
            name = "hmc3",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -7535,  y = -3445, z = 135, yaw = 0x4000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -2395, y = -5275, z = 1450, yaw = 0x8000, airborne = true },
            overrideName = "Deep Within The Cave",
            overrideWater = true,
            music = { name = "Cave Dungeon - Super Mario 64" }
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -2540, y = 2500, z = 1655, yaw = 0x8000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_DESERT,
            startPos = { x = 5335, y = -1070, z = 5730, yaw = -0x4000, airborne = false },
            unwantedBhvs = { id_bhvFloorSwitchHiddenObjects },
            overrideName = "Under Construction",
            music = { name = "Lethal Lava Land - Super Mario 64" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "ddd2",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 3450, y = 3715, z = -3340, yaw =  0x0000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = 0, y = -430, z = 6210, yaw = -0x4000, airborne = false },
            overrideName = "The Windmill Of The Garden",
            music = { name = "Bob-Omb Battlefield (Peach's Message Mix) - Super Mario 64" },
            skybox = SKYBOX_NIGHT,
        },
        {
            name = "ddd3",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -4105, y = 1810, z = 2395, yaw =  0x4000 },
            flagBase = true,
            speed = 1.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -3970, y = 1005, z = -3810, yaw = 0x0000, airborne = true },
            overrideName = "Lumberjack Jumping",
            floodHeight = -855,
            blockScale = 2,
            blocks = {
                { x = -4320, y =  1700, z = 1775, yaw = 0x0000 },
            },
            music = { name = "Bob-Omb Battlefield (Peach's Message Mix) - Super Mario 64" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "bitfs2",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 1510, y = 1399, z =  2065, yaw =  0x7000 },
            flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_WATER,	
            startPos = { x = -1970, y = 1240, z = -7090, yaw = -0x2000, airborne = false },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "On Top Of The Mountain",
            floodHeight = -2455,
            blockScale = 2.25,
            blocks = {
                { x = 625, y =  -468, z = -6985, yaw = 0x0000 },
            },
            music = { name = "Koopa's Road - Super Mario 64" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "sl2",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 1050, y = 2300, z = 930, yaw =  0x8000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = 1135, y = -150, z = 4050, yaw = 0x8000, airborne = true },
            overrideName = "The Tower Of Power",
            music = { name = "Dire, Dire Docks - Super Mario 64" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "ttc2",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 5775, y = 3650, z = 4870, yaw = 0x4000 },
            speed = 3.5,
            author = "Lugmillord",
            type = FLOOD_CLOUDS,
            startPos = { x = -5430, y = 725, z = -2320, yaw = 0x0000, airborne = true },
            floodScale = 1.5,
            overrideName = "Tower Of The West",
            floodHeight = -2250,
            music = { name = "Stone Tower Temple - The Legend Of Zelda: Majora's Mask" }
        },
        {
            name = "ttc3",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -6250, y =  4158, z =  6560, yaw = 0x6000 },
            flagBase = true,
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_CLOUDS,
            startPos = { x = 620, y = -2150, z = 7205, yaw = 0x0000, airborne = true },
            floodScale = 1.5,
            overrideName = "Jumping Maestro",
            music = { name = "Stone Tower Temple - The Legend Of Zelda: Majora's Mask" }
        },
        {
            name = "ttc4",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 3435, y = 1678, z = -7085, yaw = 0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_CLOUDS,
            startPos = { x = 6435, y = 318, z = 595, yaw = 0x8000, airborne = true },
            floodScale = 1.5,
            overrideName = "Bottomless Fortress",
            music = { name = "Stone Tower Temple - The Legend Of Zelda: Majora's Mask" }
        },
        {
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 2615, y = 3241, z = -6765, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_DARKNESS,
            startPos = { x = -5595, y = -1850, z = -3500, yaw = 0x0000, airborne = true },
            floodScale = 1.5,
            overrideName = "Intense Challenge",	
            music = { name = "Stone Tower Temple (Inverted) - The Legend Of Zelda: Majora's Mask" }
        },
        {
            name = "bits2",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -600, y = 1195, z = 3150, yaw = 0x0000 },
            speed = 2.25,
            author = "Lugmillord",
            type = FLOOD_DARKNESS,
            startPos = { x = -4985, y = 462, z = 4480, yaw = 0x0000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvFloorSwitchHiddenObjects },
            overrideName = "Secret Of The Tree Room",
            blocks = {
                { x = -4580, y = 462, z = 5530, yaw = 0x0000 },
                { x = -600, y = 888, z = 3150, yaw = 0x0000 },
            },
            music = { name = "Hideout Helm - Donkey Kong 64" }
        },
        {
            name = "bits3",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 745, y = 3230, z = -2180, yaw = 0x0000 },
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_DARKNESS,
            startPos = { x = 5095, y = -1700, z = -1225, yaw = 0x0000, airborne = false },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Opening The Cannon",
            music = { name = "Hideout Helm - Donkey Kong 64" }
        },
        {
            name = "bits4",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 605, y = 8435, z = 1110, yaw = 0x0000 },
            speed = 8.0,
            author = "Lugmillord",
            type = FLOOD_DARKNESS,
            startPos = { x = 5065, y = -2200, z = 5930, yaw = 0x8000, airborne = false },
            unwantedBhvs = { id_bhvWarpPipe, id_bhv1Up },
            overrideName = "Top Of The Crystal Palace",
            launchpads = {
                { x = 1510, y = 2150, z = 6545, yaw = 0x8000, vel = 175, forwardVel = 0 },
                { x = 590, y = 5990, z = 2240, yaw = 0x8000, vel = 150, forwardVel = 0 }
            },
            music = { name = "Hideout Helm - Donkey Kong 64" }
        },
        {
            name = "wmotr2",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -365, y = 1115, z = -2480, yaw = 0x6000 },
            flagBase = true,
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = 4860, y = -1578, z = 155, yaw = -0x4000, airborne = false, pipe = true },
            overrideName = "Entrance To The Lava-Switch",
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Flipside - Super Paper Mario" },
            skybox = SKYBOX_NIGHT
        },
        {
            -- Super Mario 74: Extreme Edition

            name = "bob-ee",
            level = LEVEL_BOB,
            area = 2,
            flagPos = { x = 650, y = 2255, z = -2035, yaw = 0x0000 },
            flagBase = true,
            speed = 2.25,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x = 3334, y =  -962, z = -5228, yaw =  0x0000, airborne = true },
            overrideName = "Devil's Dice",
            separator = "Super Mario 74: Extreme Edition",
            music = { name = "Bob-Omb Battlefield (File Select Mix) - Super Mario 64" }
        },
        {
            name = "wf-ee",
            level = LEVEL_WF,
            area = 2,
            flagPos = { x = -2177, y = 5569, z = -716, yaw = 0x4000 },
            speed = 4.5,
            author = "Lugmillord",
            type = FLOOD_CLOUDS,
            startPos = { x = 3802, y = -2848, z = -749, yaw = 0x0000, airborne = true },
            overrideName = "Virusvine Veranda",
            music = { name = "Stone Tower Temple - The Legend Of Zelda: Majora's Mask" }
        },
        {
            name = "jrb-ee",
            level = LEVEL_JRB,
            area = 2,
            flagPos = { x = 2277, y = 2996, z = -3056, yaw = -0x2000 },
            flagBase = true,
            speed = 2.25,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x = -80, y = -4820, z = 350, yaw = -0x6000, airborne = true, spin = false },
            overrideName = "Deepred Depths",
            music = { name = "Dire, Dire Docks - Super Mario 64" }
        },
        {
            name = "cotmc-ee",
            level = LEVEL_COTMC,
            area = 2,
            flagPos = { x = 3308, y = 7522, z = -381, yaw = -0x1000 },
            flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_ACID,
            overrideName = "Toxic Terrace",	
            music = { name = "Floro Sapien Caverns - Super Paper Mario" }
        },
        {
            name = "bitdw-ee",
            level = LEVEL_BITDW,
            area = 2,
            flagPos = { x = -2552, y =  4095, z =  2189, yaw =  0x8000 },
            flagBase = true,
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_WATER,	
            startPos = { x = -3622, y = -835, z = -5287, yaw =  0x0000, airborne = true },
            overrideName = "Bowser's Beautiful Backyard",
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Sunken Ship - Super Mario RPG: Legend of the Seven Stars" }
        },
        {
            name = "ccm-ee",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = 4755, y = 1337, z = -15, yaw =  0x8000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_POISON,
            startPos = { x = -2240, y = -319, z = -5098, yaw =  0x4000, airborne = true },
            overrideName = "System Of A Downtown",
            music = { name = "Haunted House - Super Mario 64" }
        },
        {
            name = "bbh-ee",
            level = LEVEL_BBH,
            area = 2,
            flagPos = { x = -894, y =  6045, z =  2527, yaw = -0x4000 },
            flagBase = true,
            speed = 3.5,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -108, y = -4712, z =  5790, yaw =  0x8000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Drowned Factory",
            overrideWater = true,
            music = { name = "Gloomy Galleon - Donkey Kong 64" }
        },
        {
            name = "vcutm-ee",
            level = LEVEL_VCUTM,
            area = 2,
            flagPos = { x = 1438, y =  3573, z = -1425, yaw =  0x0000 },
            flagBase = true,
            speed = 1.75,
            author = "Lugmillord",
            type = FLOOD_FROSTBITE,
            startPos = { x = 6311, y = -1414, z = -1226, yaw =  0x0000, airborne = true },
            overrideName = "Dust Destination",
            capTimer = 1,
            music = { name = "Floro Sapien Caverns - Super Paper Mario" }
        },
        {
            name = "totwc-ee",
            level = LEVEL_TOTWC,
            area = 2,
            flagPos = { x = 715, y =  4600, z =  -200, yaw = -0x4000 },
            speed = 1.75,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            floodHeight = -2740,
            startPos = { x = 4430, y = 223, z =   -50, yaw = -0x4000, airborne = true },
            overrideName = "Devil's Pit",
            blocks = {
                { x = 715, y = 4293, z = -200, yaw = 0x0000 },
            },
            music = { name = "Bubblegloop Swamp - Banjo-Kazooie" }
        },
        {
            name = "pss-ee",
            level = LEVEL_PSS,
            area = 2,
            flagPos = { x = 3615, y =  4020, z =  3570, yaw =  0x8000 },
            flagBase = true,
            speed = 3.5,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x = 1424, y = -7332, z =  2110, yaw = -0x4000, airborne = true },
            overrideName = "Old Supply Slide",
            launchpads = {
                { x = -2345, y = -3430, z = -3085, yaw = 32701, vel = 90, forwardVel = 0 },
                { x = -2345, y = -3430, z = -2360, yaw = 32701, vel = 90, forwardVel = 0 }
            },
            overrideSlide = true,
            music = { name = "Slider (Ending Mix) - Super Mario 64" }
        },
        {
            name = "hmc-ee",
            level = LEVEL_HMC,
            area = 2,
            flagPos = { x = 5000, y = 2347, z = 4160, yaw =  0x8000 },
            flagBase = true,
            speed = 1.0,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x = -5745, y = 563, z = 2310, yaw = -0x2000, airborne = true },
            overrideName = "Infernopit Cave",
            music = { name = "Floro Sapien Caverns - Super Paper Mario" }
        },
        {
            name = "lll-ee",
            level = LEVEL_LLL,
            area = 2,
            flagPos = { x = -1060, y = 11805, z = 510, yaw =  0x4000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_SNOW,
            startPos = { x = -1875, y = -2910, z = -2703, yaw = 0x0000, airborne = true },
            overrideName = "Melting Icecrystal-Tower",
            music = { name = "Snow Mountain (Credits Mix) - Super Mario 64" }
        },
        {
            name = "ssl-ee",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x = 4925, y = 4565, z =  4600, yaw =  0x8000 },
            flagBase = true,
            speed = 1.5,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -2188, y =  -604, z = -5767, yaw =  0x0000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Overgrown Oasis",
            music = { name = "Bubblegloop Swamp - Banjo-Kazooie" }
        },
        {
            name = "ddd-ee",
            level = LEVEL_DDD,
            area = 2,
            flagPos = { x = 3710, y = 2255, z = -4730, yaw =  0x0000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_SUNSET,
            startPos = { x = 2917, y = -3287, z = -5590, yaw =  0x0000, airborne = true },
            overrideName = "Fireflower Fields",
            music = { name = "Bob-Omb Battlefield (File Select Mix) - Super Mario 64" }
        },
        {
            name = "bitfs-ee",
            level = LEVEL_BITFS,
            area = 2,
            flagPos = { x = -4878, y =  6639, z = -6502, yaw = 0x0000 },
            flagBase = true,
            speed = 1.5,
            author = "Lugmillord",
            type = FLOOD_SUNSET,				
            startPos = { x = -530, y =  3840, z = -1967, yaw =  0x0000, airborne = true },
            overrideName = "Bowser's Quicksand Pit",
            music = { name = "Sunken Ship - Super Mario RPG: Legend of the Seven Stars" }				
        },
        {
            name = "sl-ee",
            level = LEVEL_SL,
            area = 2,
            flagPos = { x = -2261, y =  4320, z =  3279, yaw =  0x4000 },
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_SNOW,
            startPos = { x = 2239, y =  -309, z = -3367, yaw =  0x0000, airborne = true },
            overrideName = "Breezing Beach",
            music = { name = "Snow Mountain (Credits Mix) - Super Mario 64" }
        },
        {
            name = "wdw-ee",
            level = LEVEL_WDW,
            area = 2,
            flagPos = { x = 3461, y =  3884, z = -5332, yaw = -0x4000 },
            speed = 1.75,
            author = "Lugmillord",
            type = FLOOD_SAND,
            unwantedBhvs = { id_bhvKoopa },
            overrideName = "Dried-Out Dead Desert",
            floodHeight = -3100,
            music = { name = "Haunted House - Super Mario 64" }
        },
        {
            name = "ttm-ee",
            level = LEVEL_TTM,
            area = 2,
            flagPos = { x = 3195, y = 4630, z = -4325, yaw = 0x2000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_POISON,
            overrideName = "Cliff Of Pain",
            floodHeight = -6300,
            music = { name = "Gloomy Galleon - Donkey Kong 64" }
        },
        {
            name = "thi-ee",
            level = LEVEL_THI,
            area = 2,
            flagPos = { x = 6300, y =  4826, z = -800, yaw = -0x4000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_DESERT,
            startPos = { x = 0, y = -455, z = 0, yaw =  0x0000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe, id_bhvBobombBuddyOpensCannon },
            overrideName = "Acid Peaks",
            music = { name = "Bubblegloop Swamp - Banjo-Kazooie" }
        },
        {
            name = "ttc-ee",
            level = LEVEL_TTC,
            area = 2,
            flagPos = { x = -2320, y = 11814, z = 663, yaw =  0x4000 },
            speed = 1.75,
            author = "Lugmillord",
            type = FLOOD_ACID,
            floodScale = 1.5,
            overrideName = "Veneno Sphere",
            floodHeight = -8137,
            blockScale = 0.60,
            blocks = {
                { x = -2320, y = 11630, z = 663, yaw = 0x0000 },
            },
            music = { name = "Riddle Tower - Paper Mario: The Thousand-Year Door" }
        },
        {
            name = "rr-ee",
            level = LEVEL_RR,
            area = 2,
            flagPos = { x = 90, y = 10815, z = -4320, yaw =  0x8000 },
            flagBase = true,
            speed = 1.0,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            floodScale = 1.5,
            floodHeight = -5861,
            overrideName = "Crudelo Sphere",
            music = { name = "Ultimate Koopa - Super Mario 64" }
        },
        {
            name = "bits-ee",
            level = LEVEL_BITS,
            area = 2,
            flagPos = { x = -695, y = 7690, z = 2095, yaw = 0x0000 },
            speed = 2.75,
            author = "Lugmillord",
            type = FLOOD_DARKNESS,
            startPos = { x = -5140, y = -2980, z = 6760, yaw = 0x8000, airborne = false },
            overrideName = "Ztar Zanctuary",
            unwantedBhvs = { id_bhvWarpPipe },
            launchpads = {
                { x = -1600, y = 1345, z = 7520, yaw = 32701, vel = 175, forwardVel = 0 },
            },
            music = { name = "Black City - Bomberman 64" }
        },
        {
            name = "bits2-ee",
            level = LEVEL_BITFS,
            area = 2,
            flagPos = { x = 4250, y = -1710, z = 5090, yaw = -0x4000 },
            speed = 0.75,
            author = "Lugmillord",
            type = FLOOD_POISON,
            startPos = { x = -840, y = -3960, z = -3960, yaw = 0x0000, airborne = false },
            overrideName = "Inside The Ztar Zanctuary",
            music = { id = 46, name = "Black City - Bomberman 64" }
        },
        {
            name = "sa-ee",
            level = LEVEL_SA,
            area = 2,
            flagPos = { x = 400, y =  1939, z =  2610, yaw =  0x0000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            overrideName = "Triarc-Bridge",
            music = { name = "Intro - Yoshi's Adventure" }
        },
        {
            name = "cc-ee",
            level = LEVEL_CASTLE_COURTYARD,
            area = 2,
            flagPos = { x = 3980, y =  1710, z =  7110, yaw =  0x4000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x = -5515, y = -945, z = -4995, yaw =  0x4000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Valley Of The Evil Toads",
            music = { name = "Flipside - Super Paper Mario" }
        },
        {
            name = "wmotr-ee",
            level = LEVEL_WMOTR,
            area = 2,
            flagPos = { x = -1800, y =  3430, z = -5485, yaw = -0x4000 },
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = 1085, y = -878, z = 2170, yaw = 0x8000, airborne = true }, 
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Lake Of The Lords",	
            music = { name = "Flipside - Super Paper Mario" }
        },
        {
            name = "c-ee",
            level = LEVEL_CASTLE,
            area = 2,
            flagPos = { x = -180, y =  2135, z =  3640, yaw =  0x8000 },
            flagBase = true,
            speed = 6.75,
            author = "Lugmillord",
            type = FLOOD_POISON,
            startPos = { x = -260, y = -1365, z = -4343, yaw =  0x0000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Plasma Temple",
            music = { name = "None" }
        },
        {
            name = "bob2-ee",
            level = LEVEL_BOB,
            area = 2,
            flagPos = { x = -4410, y = 2165, z = 2450, yaw = 0x8000 },
            flagBase = true,
            speed = 1.5,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x = 3020, y = -485, z = 3910, yaw = 0x8000, airborne = false },
            overrideName = "Little Warp-Up",
            music = { name = "Bob-Omb Battlefield (File Select Mix) - Super Mario 64" },
            skybox = SKYBOX_NIGHT,
            separator = "Extras"
        },
        {
            name = "wf2-ee",
            level = LEVEL_WF,
            area = 2,
            flagPos = { x = 6795, y = 4720, z = 935, yaw = -0x4000 },
            speed = 4.5,
            author = "Lugmillord",
            type = FLOOD_CLOUDS,
            startPos = { x = -3545, y = -1990, z = -4725, yaw = 0x0000, airborne = true },
            unwantedBhvs = { id_bhvFlamethrower, id_bhvFloorSwitchHiddenObjects },
            overrideName = "On Top Of That Wall!",
            music = { name = "Stone Tower Temple - The Legend Of Zelda: Majora's Mask" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "jrb2-ee",
            level = LEVEL_JRB,
            area = 2,
            flagPos = { x = -670, y = 4290, z = 4975, yaw = 0x6000 },
            flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            overrideName = "The Upper End Of The Crater",
            music = { id = 43, name = "Floro Sapien Caverns - Super Paper Mario" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "cotmc2-ee",
            level = LEVEL_COTMC,
            area = 2,
            flagPos = { x = 5905, y = 3285, z = -3380, yaw = -0x2000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_ACID,
            startPos = { x = -4160, y = -720, z = 6795, yaw = 20525, airborne = true },
            overrideName = "Bouncy Stairs",
            capTimer = 900,
            music = { name = "Floro Sapien Caverns - Super Paper Mario" }
        },
        {
            name = "ccm2-ee",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = -2665, y = 760, z = -1735, yaw = -0x4000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_POISON,
            startPos = { x = -3470, y = -1900, z = -1560, yaw =  0x4000, airborne = false },
            overrideName = "Expanded Secret Room",
            music = { name = "Haunted House - Super Mario 64" }
        },
        {
            name = "ccm3-ee",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = -1630, y = 2180, z = 2100, yaw =  0x0000 },
            speed = 1.5,
            author = "Lugmillord",
            type = FLOOD_POISON,
            startPos = { x = -2490, y = -1110, z = 1835, yaw =  0x2000, airborne = false },	
            overrideName = "Sewers Of The Village",
            music = { name = "Haunted House - Super Mario 64" }
        },
        {
            name = "hmc2-ee",
            level = LEVEL_HMC,
            area = 2,
            flagPos = { x = -6275, y = 2530, z = -1140, yaw = 0x0000 },
            flagBase = true,
            speed = 2.25,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x = 1055, y = -40, z = -5355, yaw = 0x4000, airborne = true },
            overrideName = "Dance With The Heave-Hos",
            music = { name = "Floro Sapien Caverns - Super Paper Mario" }
        },
        {
            name = "hmc3-ee",
            level = LEVEL_HMC,
            area = 2,
            flagPos = { x = 6365, y = -5165, z = 235, yaw = -0x4000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_LAVA,
            startPos = { x = 2585, y = -5040, z = 1870, yaw = 0x8000, airborne = true },
            overrideName = "Side Caldron Shenanigans",
            floodHeight = -7800,
            music = { name = "Floro Sapien Caverns - Super Paper Mario" }
        },
        {
            name = "ssl2-ee",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x = 3585, y = 5500, z = 685, yaw = 0x8000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_WATER,
            startPos = { x = -5000, y = -1000, z = 4935, yaw = 0x4000, airborne = false },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Still Under Construction",
            overrideWater = true,
            music = { name = "Bubblegloop Swamp - Banjo-Kazooie" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "ddd2-ee",
            level = LEVEL_DDD,
            area = 2,
            flagPos = { x = -3850, y = 4060, z = -3905, yaw =  0x0000 },
            speed = 1.75,
            author = "Lugmillord",
            type = FLOOD_SUNSET,
            startPos = { x = -4565, y = 290, z = 5160, yaw = 0x8000, airborne = true },
            unwantedBhvs = { id_bhvKingBobomb },
            overrideName = "Windy Mill Of The Fields",	
            music = { name = "Bob-Omb Battlefield (File Select Mix) - Super Mario 64" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "ddd3-ee",
            level = LEVEL_DDD,
            area = 2,
            flagPos = { x = 4945, y = -3000, z = 4290, yaw = -0x4000 },
            speed = 0.75,
            author = "Lugmillord",
            type = FLOOD_SUNSET,
            startPos = { x = 2230, y = -2622, z = 830, yaw = -0x2000, airborne = true },
            overrideName = "Not So Secret Cavern",
            music = { name = "Bob-Omb Battlefield (File Select Mix) - Super Mario 64" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "bitfs2-ee",
            level = LEVEL_BITFS,
            area = 2,
            flagPos = { x = -1875, y = 6945, z = -1125, yaw = 0x4000 },
            speed = 1.0,
            author = "Lugmillord",
            type = FLOOD_SUNSET,
            startPos = { x = 305, y = 4100, z = -6140, yaw = 0x4000, airborne = false },
            overrideName = "More Jumping On Boxes",
            blockScale = 2.25,
            blocks = {
                { x = -170, y = 3840, z = -6140, yaw = 0x0000 },
            },
            music = { name = "Sunken Ship - Super Mario RPG: Legend of the Seven Stars" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "bitf3s-ee",
            level = LEVEL_BITFS,
            area = 2,
            flagPos = { x = -1035, y = 5710, z = 2725, yaw = 0x0000 },
            speed = 1.25,
            author = "Lugmillord",
            type = FLOOD_SUNSET,
            startPos = { x = 555, y = 2372, z = 4365, yaw = 3130, airborne = false, spin = false },
            overrideName = "Shell Ride Onto The Mountain",
            music = { name = "Sunken Ship - Super Mario RPG: Legend of the Seven Stars" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "wdw2-ee",
            level = LEVEL_WDW,
            area = 2,
            flagPos = { x = -2285, y = 3280, z = -1165, yaw = 0x4000 },
            speed = 1.25,
            author = "Lugmillord",
            type = FLOOD_SAND,
            startPos = { x = 1195, y = -275, z = -4800, yaw = 0x0000, airborne = true },
            overrideName = "The Sand Plateau's Torture",
            music = { name = "Haunted House - Super Mario 64" }
        },
        {
            name = "wdw3-ee",
            level = LEVEL_WDW,
            area = 2,
            flagPos = { x = 7450, y = 770, z = 6190, yaw = -21940 },
            speed = 0.75,
            author = "Lugmillord",
            type = FLOOD_SAND,
            startPos = { x = 3530, y = 830, z = 4115, yaw = 0x0000, airborne = true },
            overrideName = "The Old Hideout",
            music = { name = "Haunted House - Super Mario 64" }
        },
        {
            name = "ttm2-ee",
            level = LEVEL_TTM,
            area = 2,
            flagPos = { x = 6035, y = 2720, z = 2930, yaw = 0x2000 },
            flagBase = true,
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_POISON,
            startPos = { x = 3110, y = -2445, z = 265, yaw = 0x0000, airborne = true },
            unwantedBhvs = { id_bhvChuckya },
            overrideName = "Brazenly Placed",
            music = { name = "Gloomy Galleon - Donkey Kong 64" }
        },
        {
            name = "thi2-ee",
            level = LEVEL_THI,
            area = 2,
            flagPos = { x = -3870, y = 1485, z = -4585, yaw = 0x4000 },
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_DESERT,
            startPos = { x = -5210, y = -640, z = -4595, yaw = 28075, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },
            overrideName = "Another Climbing Challenge",
            music = { name = "Bubblegloop Swamp - Banjo-Kazooie" },
            skybox = SKYBOX_NIGHT
        },
        {
            name = "ttc2-ee",
            level = LEVEL_TTC,
            area = 2,
            flagPos = { x = 2375, y = 5975, z = -90, yaw = -0x4000 },
            speed = 1.75,
            author = "Lugmillord",
            type = FLOOD_ACID,
            startPos = { x = 335, y = 175, z = 7385, yaw = 0x8000, airborne = true },
            overrideName = "Through The Heart Of The World",
            music = { name = "Riddle Tower - Paper Mario: The Thousand-Year Door" }
        }
    }
end

-- SM64: The Green Stars, ported to Flood by MarcoGamerOJ & Bear64DX
local function flood_load_green_stars_levels()
    game = GAME_SM64_THE_GREEN_STARS
    romhackInfo = "Super Mario 64: The Green Stars"
	romhackLogo = get_texture_info("logo_sm64tgs")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -1500, y = -509, z= 2102, yaw = 0x5000}
        },
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 3741, y = 310, z = 2194, yaw = 0x8000}
        },
        [3] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -1264, y = -4373, z = 2210, yaw = 0x8000}
        },
        [4] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -5300, y = 1261, z = 27, yaw = 0x4000}
        },
        [5] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 600, y = -1846, z = 20, yaw = 0x8000}
        },
        [6] = {
            level = LEVEL_LLL,
            area = 1,
            spawn = {x = -2600, y = -2277, z = -1133, yaw = 0x8000}
        },
        [7] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = -6200, y = -363, z = 203, yaw = 0x4000}
        },
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -4302, y =  1875, z = -2536, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -1500,
            music = { name = "Athletic - Super Mario World" }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -2222, y = 3039, z = -777, yaw =  0x8000 },
            flagBase = true,
            speed = 4.0,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -2500,
            unwantedBhvs = { id_bhvRedCoin },
            launchpads = {
                { x = -2222, y = 1011, z = -1865, yaw =  0x0000, vel = 130, forwardVel = 0 },
            },
            music = { name = "Fungi Forest - Donkey Kong 64" }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -4500, y =  4793, z = -414, yaw = 0x0000 },
            flagBase = false,
            speed = 3.5,
            author = "Kampel125",
            type = FLOOD_WATER,
            overrideWater = true,
            floodScale = 2,
            floodHeight = -0,
            music = { name = "Yoshi's Tropical Island - Mario Party" }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 4527, y = 5028, z = -1183, yaw = -0x4000 },
            flagBase = true,
            speed = 5.0,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 2,
            music = { name = "Frappe Snowland - Mario Kart 64" }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -2832, y = 1890, z = 3223, yaw = 0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 2,
            floodHeight = -4000,
            unwantedBhvs = { id_bhvExclamationBox },
            music = { name = "Weapons Factory - Super Mario RPG" }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -8096, y = 2729, z = 7590, yaw = 0x8000 },
            flagBase = false,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 3,
            capTimer = 500,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvRedCoin },
            music = { name = "Dark Cave - Pokemon Gold/Silver" }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -884,  y = 5026, z = -993, yaw = 0x8000 },
            flagBase = false,
            speed = 4.5,
            author = "Kampel125",
            type = FLOOD_ACID,
            floodScale = 3,
            music = { name = "Castle/Fortress - Yoshi's Island" }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -4642, y = 4777, z = 547, yaw =  0x4000 },
            flagBase = false,
            speed = 5.0,
            author = "Kampel125",
            type = FLOOD_CLOUDS,
            floodScale = 2,
            floodHeight = -4500,
            music = { name = "Map Theme - Pikmin" }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 1755, y = 6824, z = -585, yaw = 32581 },
            flagBase = true,
            speed = 3.5,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -6500,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },
            pipes = {
                {
                    { x = 4100, y = -4179, z = -680, yaw = -0x4000 },
                    { x = 1466, y = -679, z = -703, yaw = -0x4000 }
                }
            },
            launchpads = {
                { x = 1719, y =  5095, z = -2426, yaw = 0x0000, vel = 130, forwardVel = 0 },
            },
            music = { name = "Holli Jolli Village - Mario & Luigi: Partners in Time" },
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -4841, y = 2005,  z = -246, yaw = 0x6000 },
            flagBase = false,
            speed = 2.5,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -1500,
            music = { name = "Maple Treeway - Mario Kart Wii" }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 4700, y = 3180, z = -4560, yaw = 0x0000 },
            flagBase = false,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_DESERT,
            floodScale = 2,
            floodHeight = -1000,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Gritzy Desert - Mario & Luigi: Partners in Time" }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -10553, y = 2147, z = 5295, yaw = 0x4000 },
            flagBase = false,
            speed = 4.0,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 2,
            music = { name = "Beach Bowl Galaxy - Super Mario Galaxy" }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 255, y = 3891, z = 95, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 3,
            floodHeight = -5000,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Castle/Fortress - Yoshi's Island" }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 4334, y = -720, z = -5145, yaw = -0x2000 },
            flagBase = false,
            speed = 2.5,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 2,
            floodHeight = -3500,
            music = { name = "Melty Molten Galaxy - Super Mario Galaxy " }
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -3015, y = 6442, z = -2222, yaw = 0x2000 },
            flagBase = true,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -5555,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },
            launchpads = {
                { x = -81,   y = -1006, z = 2304, yaw = 0x0000, vel = 100, forwardVel = 0  },
                { x = -1395, y =  2269, z = 3243, yaw = 0x6000, vel = 55,  forwardVel = 55 },
                { x = -215,  y =  3523, z = 1015, yaw = 0x0000, vel = 170, forwardVel = 0  },
            },
            music = { name = "Yoshi's Tropical Island - Mario Party" }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -4444, y = 5009,  z = 3900, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_SAND,
            floodScale = 2.5,
            floodHeight = -2000,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Thwomp Volcano - Mario & Luigi: Partners in Time" }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 4610, y = 2741, z = 2207, yaw = 0x6000 },
            flagBase = false,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 3,
            floodHeight = -5555,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },
            music = { name = "Mining Melancholy - Donkey Kong Country 2" }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 3310, y = 5631, z = 2645, yaw = -0x4000 },
            flagBase = false,
            speed = 3.5,
            author = "Kampel125",
            type = FLOOD_CLOUDS,
            floodScale = 3,
            floodHeight = -3500,
            unwantedBhvs = { id_bhvKoopa },
            music = { name = "Petal Meadows - Paper Mario: The Thousand-Year Door" }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 12665, y = 8833, z = 6363, yaw = 0x8000 },
            flagBase = true,
            speed = 5.0,
            author = "Kampel125",
            type = FLOOD_RAINBOW,
            floodScale = 3,
            floodHeight = -5555,
            music = { name = "Good Egg Galaxy - Super Mario Galaxy" }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -1210, y = 1199, z = 13669, yaw = 0x8000 },
            flagBase = false,
            speed = 3.5,
            author = "Kampel125",
            type = FLOOD_ACID,
            floodScale = 3,
            floodHeight = -5555,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Bowser\'s Castle - Mario Kart 64" }
        },
        {
            name = "bits2",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -7411, y = 4151, z = -12095, yaw = 0x0000 },
            flagBase = false, 
            speed = 4.5,
            author = "Kampel125",
            type = FLOOD_ACID,
            floodScale = 3,
            floodHeight = -3500,
            startPos = { x = -8050, y = -969, z = -2617, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvRedCoin },
            overrideName = "Bowser's Battle Gears",
            music = { name = "Bowser\'s Castle - Mario Kart 64" }
        },
        {
            name = "bits3",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 8726, y = 3438, z = -2340, yaw = 0x8000 },
            flagBase = true,
            speed = 3.5,
            author = "Kampel125",
            type = FLOOD_ACID,
            floodScale = 3,
            floodHeight = -3500,
            startPos = { x = 1535, y = -2181, z = -11900, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvRedCoin },
            overrideName = "Bowser's Battle Cranes",
            music = { name = "Bowser\'s Castle - Mario Kart 64" }
        },
        {
            name = "bits4",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -7900, y = 7233, z = 610, yaw = 0x4000 },
            flagBase = true,
            speed = 5.0,
            author = "Kampel125",
            type = FLOOD_ACID,
            floodScale = 3,
            floodHeight = -5000,
            startPos = { x = 5252, y = -2097, z = -3974, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvRedCoin },
            overrideName = "Bowser's Battle Boxes",
            launchpads = {
                { x = 115, y = 2851, z = 1178, yaw = 0x0000, vel = 200, forwardVel = 0 },
            },
            music = { name = "Bowser\'s Castle - Mario Kart 64" }
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 4732, y = 1592, z = 5781, yaw = 0x8000 },
            flagBase = true,
            speed = 5.0,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 3,
            launchpads = {
                { x = 880, y = 1578, z = -285, yaw = 0x2000, vel = 130, forwardVel = 78 },
            },
            music = { name = "Starship Mario - Super Mario Galaxy 2" }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -8939, y = 6304, z = 12562, yaw = 0x4000 },
            flagBase = true,
            speed = 4.5,
            author = "Kampel125",
            type = FLOOD_WATER,
            overrideSlide = true,
            floodScale = 3,
            startPos = { x = 4545, y = -4545, z = 7885, yaw = -0x4000 },
            launchpads = {
                { x = -4032, y = -1265, z = -2602,  yaw = 0x0000, vel = 80, forwardVel = 0 },
                { x =  0,    y = -615,  z = -6767,  yaw = 0x0000, vel = 85, forwardVel = 0 },
                { x =  9012, y =  2284, z =  12499, yaw = 0x0000, vel = 80, forwardVel = 0 },
                { x =  4848, y =  3030, z =  12499, yaw = 0x0000, vel = 80, forwardVel = 0 },
            },
            music = { name = "Overworld Theme - Super Mario Bros 2" }
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 630, y = 1808, z = -2390, yaw = 0x4000 },
            flagBase = false,
            speed = 5.0,
            author = "Kampel125",
            type = FLOOD_FROSTBITE,
            overrideSlide = false,
            floodScale = 3,
            startPos = { x = 3047, y = -2147, z = 1057, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvMessagePanel },
            overrideName = "Snowy Slide",
            music = { name = "Frappe Snowland - Mario Kart 64" }
        },
        {
            name = "thi2",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 2315, y = 5023, z = -286, yaw = 0x4000 },
            flagBase = true,
            speed = 7.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            overrideSlide = false,
            floodScale = 3,
            startPos = { x = 6677, y = -3631, z = -1885, yaw = 0x8000, airborne = false },
            unwantedBhvs = { id_bhvExclamationBox, id_bhvMessagePanel },
            overrideName = "Misty Slide",
            music = { name = "Mining Melancholy - Donkey Kong Country 2" }
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = -2913, y = 1458, z = -200, yaw = 0x4000 },
            flagBase = true,
            speed = 5.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 2,
            startPos = { x = -2340, y = -2321, z = -2340, yaw = 0x8000, airborne = false },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvMessagePanel },
            music = { name = "Starship Mario - Super Mario Galaxy 2" }
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 3012, y = 1350, z = -2727, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -1500,
            startPos = { x = -4385, y = -749, z = 555, yaw = 0x4000 },
            overrideName = "Climb To The Switch",
            music = { name = "Athletic - Super Mario World" }
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -2602, y = 3587, z = 6343, yaw =  0x8000 },
            flagBase = true,
            speed = 4.0,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -4500,
            startPos = { x = 6524, y = -2491, z = -2996, yaw = 0x0000, airborne = false },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Upon The Not-so Waterfall",
            launchpads = {
                { x = 3137, y = -3071, z =  6013, yaw =  0x0000, vel = 130, forwardVel = 0  },
                { x = 2445, y =  2038, z = -550,  yaw = -0x2000, vel = 130, forwardVel = 50 },
            },
            music = { name = "Fungi Forest - Donkey Kong 64" }
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -355, y = 1822, z = 255, yaw = 0x0000 },
            flagBase = false,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 2,
            floodHeight = -4000,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Climb The Factory",
            music = { name = "Weapons Factory - Super Mario RPG" }
        },
        {
            name = "hmc2",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -4698, y = 4934, z = 4022, yaw = 0x8000 },
            flagBase = true,
            speed = 6.0,
            author = "Kampel125",
            type = FLOOD_SULFUR,
            floodScale = 2,
            startPos = { x = -5680, y = 2764, z = -4572, yaw = 0x0000 },
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe, id_bhvRedCoin },
            overrideName = "Mr. I's Trembling Parkour",
            music = { name = "Holli Jolli Village - Mario & Luigi: Partners in Time" },
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -2178, y = -2083, z = 400, yaw = 0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "Kampel125",
            type = FLOOD_DESERT,
            floodScale = 2,
            floodHeight = -6666,
            startPos = { x = -5877, y = -4393, z = 400, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Inside The Temple",
            music = { name = "Gritzy Desert - Mario & Luigi: Partners in Time" }
        },
        {
            name = "sl2",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 5757, y = -159, z = 5566, yaw = -0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 2,
            floodHeight = -3500,
            startPos = { x = 5200, y = -2266, z = -666, yaw = -0x2000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Red-Hot Hidden Boxes",
            music = { name = "Melty Molten Galaxy - Super Mario Galaxy " }
        },
        {
            name = "thi3",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -800, y = -169, z = 6178, yaw = 0x8000 },
            flagBase = false,
            speed = 5.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 3,
            startPos = { x = -1333, y = -4363, z = 3815, yaw = -0x4000 },
            overrideName = "Climbin' The Rails",
            music = { name = "Mining Melancholy - Donkey Kong Country 2" }
        },
        {
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 2585, y = 3489, z = -9292, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_RAINBOW,
            floodScale = 3,
            floodHeight = -5000,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "From The Towertop To The Stars",
            launchpads = {
                { x = -4565, y = 3492, z = -9295, yaw = 0x4000, vel = 78, forwardVel = 78 },
            },
            music = { name = "Good Egg Galaxy - Super Mario Galaxy" }
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 600, y = 316, z = 2050, yaw = 0x8000 },
            flagBase = false,
            speed = 5.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 2,
            floodHeight = -3333,
            startPos = { x = -1829, y = -1846, z = 20, yaw = 0x4000, airborne = false },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvToadMessage },
            music = { name = "Bowser's Castle - Mario Kart Double Dash" }
        },
        {
            name = "bob3",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -3232, y = 2627, z = 2555, yaw = 0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -1500,
            starAirborne = true,
            overrideName = "Climb The Windmill",
            music = { name = "Athletic - Super Mario World" }
        },
        {
            name = "bbh3",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -485, y = 513, z = -2378, yaw = 0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 2,
            floodHeight = -4000,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Cogs & Conveyor Belts",
            music = { name = "Weapons Factory - Super Mario RPG" }
        },
        {
            name = "cotmc2",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 5135, y = 2624, z = -8191, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 3,
            music = { name = "Dark Cave - Pokemon Gold/Silver" }
        },
        {
            name = "sl3",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 1685, y = 6536, z = -2685, yaw = -0x2000 },
            flagBase = true,
            speed = 4.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            act = 4,
            floodScale = 2,
            floodHeight = -3333,
            overrideName = "Metal Bouncing On Lava Planets",
            music = { name = "Melty Molten Galaxy - Super Mario Galaxy " }
        },
        {
            name = "ttm2",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 6363, y = 1751,  z = 5815, yaw = -0x6000 },
            flagBase = false,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_SAND,
            floodScale = 2.5,
            floodHeight = -2500,
            overrideName = "The Corner Of The Cliffs",
            music = { name = "Thwomp Volcano - Mario & Luigi: Partners in Time" }
        },
        {
            name = "thi4",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -2882, y = 5739, z = 1919, yaw = 0x6000 },
            flagBase = false,
            speed = 7.0,
            author = "Kampel125",
            type = FLOOD_LAVA,
            floodScale = 3,
            floodHeight = -6789,
            overrideName = "Warp To The Switch Of Goal",
            music = { name = "Mining Melancholy - Donkey Kong Country 2" }
        },
        {
            name = "rr3",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -2085, y = 5900, z = 12000, yaw = 0x8000 },
            flagBase = false,
            speed = 3.5,
            author = "Kampel125",
            type = FLOOD_RAINBOW,
            floodScale = 3,
            floodHeight = -5000,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Mario's Blocky Problem",
            music = { name = "Good Egg Galaxy - Super Mario Galaxy" }
        },
        {
            name = "cg2",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = -3078, y = -479, z = -3966, yaw = 0x0000 },
            flagBase = true,
            speed = 7.0,
            author = "Kampel125",
            type = FLOOD_WATER,
            floodScale = 3,
            startPos = { x = 3766, y = -969, z = -401, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Run Challenge",
            music = { name = "Starship Mario - Super Mario Galaxy 2" }
        },
    }
end

-- Luigi's Mansion 64, ported to Flood by Jzzay
local function flood_load_luigis_mansion_64_levels()
    game = GAME_LUIGIS_MANSION_64
    romhackInfo = "Luigi's Mansion 64"
	romhackLogo = get_texture_info("logo_lm64")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -1328, y = 260, z = 4663, yaw = 0x8000}
        },
        [2] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -1014, y = 0, z = 1504, yaw = 0x8000}
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 2,
            spawn = {x = -974, y = 1203, z = 673, yaw = 0x8000}
        },
        [4] = {
            level = LEVEL_CASTLE,
            area = 3,
            spawn = {x = -1123, y = -1074, z = 1336, yaw = 0x0000}
        },
    }
	gLevelValues.metalCapDurationCotmc  = 1

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x =  3597,  y = 3072,  z = -91, yaw =  0x8000 },
            speed = 2.65,
            author = "LinCrash",
            type = FLOOD_WASTE,
            startPos = { x = -6500, y = 0, z = 6561, yaw = 0x5000 },
            floodScale = 2
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -2572, y =  5040, z = -258, yaw =  0x4000 },
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_LAVA
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x =  -1829,  y = -2812,  z = -1620, yaw =  0x7000 },
            speed = 6.0,
            author = "LinCrash",
            type = FLOOD_WATER,
            startPos = { x = 5152, y = -4914, z = 404, yaw = 0x8000 }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -502,   y = 3471,  z = -954, yaw =  0x8000 },
            speed = 5.0,
            author = "LinCrash",
            type = FLOOD_SNOW,
            startPos = { x = 5570, y = -4607, z =  -2964, yaw = 0x0000 },
            floodScale = 2
        },
        {
            name = "ccm-slide",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = -5620, y =  6656, z = -6145, yaw =  0x4000 },
            flagBase = true,
            speed = 6.5,
            author = "LinCrash",
            type = FLOOD_SNOW,
            startPos = { x = -6100, y = -4812, z = -7482, yaw =  0x0000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Lost Slide",
            overrideSlide = true
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x =  6845, y =  2867, z =  -2, yaw = -0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "LinCrash",
            type = FLOOD_DARKNESS,
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x =  -1532,   y = 3277,  z =  249, yaw =  0x0000 },
            flagBase = false,
            speed = 2.65,
            author = "LinCrash",
            type = FLOOD_POISON,
            startPos = { x = -1045, y = 1523, z =  -1277, yaw = 0x4000, airborne = false },
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -3347,  y = -405,  z = -2750, yaw =  0x4000 },
            flagBase = false,
            speed = 0.60,
            author = "LinCrash",
            type = FLOOD_SNOW,
            startPos = { x = 5923, y = 0, z = 3164, yaw = -0x6000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvFloorSwitchGrills, id_bhvExclamationBox }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x =  4,    y =  369,  z = -6138, yaw =  0x0000 },
            flagBase = false,
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideWater = true
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x =  6315,    y =  639,  z = -6581, yaw = 0x0000 },
            flagBase = false,
            speed = 1.8,
            author = "LinCrash",
            type = FLOOD_LAVA,
            floodScale = 2,
            unwantedBhvs = { id_bhvRedCoin }
        },
        {
            name = "lll-volcano",
            level = LEVEL_LLL,
            area = 2,
            flagPos = { x =  1786,  y = 3232,  z = 1453, yaw = -0x7000 },
            flagBase = false,
            speed = 3.5,
            author = "LinCrash",
            type = FLOOD_LAVA,
            startPos = { x = -1446, y = 87, z =  586, yaw =  0x5000 },
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Hot, Hot Volcano",
            overrideWater = true
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -2038, y =  1103, z = -300, yaw =  0x0000 },
            flagBase = false,
            speed = 3.0,
            author = "LinCrash",
            type = FLOOD_DESERT,
            startPos = { x = 4587,  y = 0, z = 7240, yaw =  0x9000 },
            floodScale = 2
        },
        {
            name = "ssl-pyramid",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x =  261,  y =  4429, z = -951, yaw =  0x0000 },
            flagBase = false,
            speed = 3.0,
            author = "LinCrash",
            type = FLOOD_SAND,
            overrideName = "Dusty Pyramid"
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x =  3978, y = -511,  z = -17, yaw = -0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "LinCrash",
            type = FLOOD_WATER
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 5756, y = 4403, z = 110, yaw = -0x4000 },
            flagBase = false,
            speed = 1.5,
            author = "LinCrash",
            type = FLOOD_LAVA,
            floodScale = 2
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x =  4596, y = -1, z = -4514, yaw = -0x6000 },
            flagBase = false,
            speed = 0.5,
            author = "LinCrash",
            type = FLOOD_WATER,
            startPos = { x = -2093, y = -3276, z = 1338, yaw = 0x8000 },
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x =  -6618, y =  3067, z = -7825, yaw =  0x0000 },
            flagBase = false,
            speed = 5.1,
            author = "LinCrash",
            type = FLOOD_FROSTBITE,
            startPos = { x = -4573, y = 1024, z = 5820, yaw = 0x8000 },
            floodScale = 2
        },
        {
            name = "sl-igloo",
            level = LEVEL_SL,
            area = 2,
            flagPos = { x =  -456, y = -0, z = -1997, yaw = 0x0000 },
            flagBase = false,
            speed = 0.64,
            author = "LinCrash",
            type = FLOOD_SNOW,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Shiverside Igloo"
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x =  4720, y =  4112, z = 4400, yaw = -0x6000 },
            flagBase = false,
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_WATER,
            startPos = { x = 3345, y = 154, z =  2926, yaw =  0x8000 },
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x =  1754,  y = 1081,  z =  999, yaw =  0x0000 },
            flagBase = false,
            speed = 4.5,
            author = "LinCrash",
            type = FLOOD_POISON,
            startPos = { x = 5062, y = -4607, z = 2107, yaw = 0x0000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -12, y = 3891, z = -1556, yaw = 0x0000 },
            flagBase = false,
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_WATER,
            startPos = { x = -512, y = -2559, z = 6671, yaw = 0x7000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Big Piranha Forest"
        },
        {
            name = "thi-small",
            level = LEVEL_THI,
            area = 2,
            flagPos = { x = -37,    y = -767,  z = -4498, yaw =  0x0000 },
            flagBase = false,
            speed = 2.5,
            author = "LinCrash",
            type = FLOOD_WATER,
            startPos = { x = 1996,  y = -849, z = 2058, yaw =  0x8000 },
            floodScale = nil,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Small Piranha Forest"
        },
        {
            name = "thi-cave",
            level = LEVEL_THI,
            area = 3,
            flagPos = { x = -1997,    y = 1434,  z = 1998, yaw =  0x4000 },
            flagBase = false,
            speed = 7.0,
            author = "LinCrash",
            type = FLOOD_WASTE,
            startPos = { x = 1518,  y = 910, z = 322, yaw =  0x1000 },
            overrideName = "Piranha Cave",
            floodHeight = -1114
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x =  1921, y =  6191, z =  1911, yaw =  -0x6000 },
            flagBase = false,
            speed = 3.0,
            author = "LinCrash",
            type = FLOOD_WASTE,
            startPos = { x = -593,  y = -19, z = -748, yaw =  0x8000 }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x =  -3439,    y =  6451, z = -5098, yaw =  -0x4000 },
            flagBase = false,
            speed = 1.5,
            author = "LinCrash",
            type = FLOOD_RAINBOW,
            startPos = { x = -3271, y = 3072, z = -6249, yaw = 0x10000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvChuckya }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x =  369,  y =  6552, z = -6000, yaw =  0x0000 },
            flagBase = false,
            speed = 1.0,
            author = "LinCrash",
            type = FLOOD_POISON,
            startPos = { x = 3025, y = -1474, z =  -1859, yaw = -0x4000 }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 3127, y = 7035, z = -5650, yaw = 0x4000 },
            speed = 5.0,
            author = "LinCrash",
            type = FLOOD_LAVA,
            startPos = { x = -6356, y = -4484, z =  5763, yaw =  0x8000 },
            overrideSlide = true
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x =  3,    y =  3174, z = -5454, yaw =  -0x4000 },
            flagBase = false,
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_WATER,
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cmf",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x =  -5813,    y =  717, z = -4635, yaw =  0x1000 },
            flagBase = false,
            speed = 5.0,
            author = "LinCrash",
            type = FLOOD_WATER,
            startPos = { x = -1018, y = 305, z = -4672, yaw = 0x0000, airborne = false },
            overrideName = "Mansion Main Floor"
        },
        {
            name = "cb",
            level = LEVEL_CASTLE,
            area = 3,
            flagPos = { x =  -3841,    y =  -1381, z = -1434, yaw =  -0x1000 },
            flagBase = false,
            speed = 3.05,
            author = "LinCrash",
            type = FLOOD_WATER,
            startPos = { x = 7034, y = -1586, z = -510, yaw = -0x4000 },
            overrideName = "Mansion Basement"
        },
    }
end

-- Star Revenge 1: Star Takeover, ported to Flood by ★~¡TOÑO!~★
local function flood_load_star_revenge_1_levels()
    game = GAME_STAR_REVENGE_1
    romhackInfo = "Star Revenge 1: Star Takeover"
	romhackLogo = get_texture_info("logo_sr1")	
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -5910, y = 1640, z = -1675, yaw = 0x0000}
	},	
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 4040, y = -730, z = 3820, yaw = 0x8000},
            overrideWater = true
        },	
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 2675, y = -2640, z = 105, yaw = -0x4000},
            pipes = {
                {
                    { x = -1170, y = -1742, z = -1138, },				
                    { x = 2648, y = -455, z = 141, yaw = -0x4000 }
                },
                {	
                    { x = -1167, y = -33, z = -1133, },				
                    { x = -298, y = 1335, z = 190, yaw = 0x4000 }			
                },
            }				
        },	
        [4] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = 85, y = 3145, z = -540, yaw = 0x0000}	
        },	
        [5] = {
            level = LEVEL_VCUTM,
            area = 1,
            spawn = {x = -4265, y = -715, z = 20, yaw = 0x0000}	
        },	
        [6] = {
            level = LEVEL_RR,
            area = 1,
            spawn = {x = -3000, y = -868, z = -735, yaw = 0x0000}							
        }
    }


    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -1150, y =  8405, z =  5150, yaw =  0x0000 },
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_WATER,
            floodHeight = -1750,
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 2220, y =  4220, z =  3560, yaw =  0x4000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x =  -895, y = -2200, z =  4460, yaw = 0x8000, airborne = true },
            floodScale = 1.5,			
            launchpads = {
                { x = -3550, y = 660, z = 5630, yaw = 0x4000, vel = 100, forwardVel = 50 },
            },			
            act = 1
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -1950, y =  4905, z =  1505, yaw = -0x3000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_CLOUDS,
            startPos = { x =  210, y = -4510, z = -3960, yaw =  0x0000, airborne = true },			
            launchpads = {
                { x = 2900, y = -2320, z = 2000, yaw = -0x2000, vel = 100, forwardVel = 100 },
            },			
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -23390,  y = 3430,  z = 16095, yaw =  0x6000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -14220, y = 1910, z = 7130, yaw = 0x8000, airborne = false, pipe = true},
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x =  11567,  y = 3638,  z = 2575, yaw =  0x0000 },
            speed = 5.5,
            author = "BroDute",
            type = FLOOD_SNOW,
            startPos = { x = 2085, y = -10370, z = -9930, yaw = 0x4000, airborne = true },
            floodScale = 1.5
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -350, y =  4505, z =   100, yaw =  0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_CLOUDS,			
            startPos = { x = -4660, y = -5370, z = -2155, yaw =  0x0000, airborne = true },		
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe },				
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -5290, y =  2965, z = -5450, yaw =  0x4000 },
            flagBase = true,
            speed = 1.75,
            author = "BroDute",
            type = FLOOD_MAGMA,
            floodScale = 1.5
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 4075, y =  2670, z = -4790, yaw =  0x8000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_MAGMA,			
            floodHeight = -3500,
            unwantedBhvs = { id_bhvWarpPipe },				
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -4875, y =  4180, z = -7510, yaw =  0x0000 },
            flagBase = true,
            speed = 2.75,
            author = "BroDute",
            type = FLOOD_ACID,
            overrideWater = true,
            capTimer = 1,
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 11745, y =  7175, z =  5630, yaw = -0x4000 },
            flagBase = true,
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_SNOW,	
            startPos = { x = 2300, y = -5950, z = 130, yaw = -0x6000, airborne = true },	
            floodScale = 1.75,
            launchpads = {
                { x = -2925, y = -3125, z = -3030, yaw = 0x0000, vel = 130, forwardVel = 0 },
            },			
            overrideSlide = true,			
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 9335, y =  2490, z =  -890, yaw = -0x4000 },
            speed = 1.75,
            author = "BroDute",
            type = FLOOD_WATER,	
            startPos = { x = -820, y = -1170, z =   900, yaw = 0x6000, airborne = true },	
            floodScale = 1.5,			
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -4040, y = 2525, z = 420, yaw = 0x4000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_DESERT,	
            startPos = { x = 6485, y = -205, z = -3045, yaw = -0x2000, airborne = true },		
            floodScale = 1.5,	
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 4920, y = -2190, z =  5920, yaw =  0x8000 },
            flagBase = true,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_DESERT,	
            startPos = { x = -2555, y = -3310, z =   300, yaw = 0x4000, airborne = true },		
            floodScale = 1.5,		
            overrideName = "Dry, Dry Pyramid", 			
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 30, y =  2555, z =   150, yaw =  0x6000 },
            flagBase = true,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_MAGMA,	
            floodScale = 2,
            floodHeight = -3600,
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 5220, y =  4660, z =  2570, yaw =  0x8000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_WATER,		
            startPos = { x = 290, y = -1305, z = -5640, yaw =  0x0000, airborne = true },	
            floodScale = 1.5,
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 3470, y = 3000, z =  2355, yaw =  0x8000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_FROSTBITE,			
            floodScale = 2.75,			
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 1010, y =  5100, z = -3800, yaw = -0x4000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_WATER,			
            startPos = { x = -1160, y = -1390, z =  3955, yaw = -0x8000, airborne = true },		
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -2030, y =  6260, z =  4055, yaw =  0x4000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_RAINBOW,			
            startPos = { x = -5530, y = -3938, z =   440, yaw = 0x4000, airborne = true },		
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 740, y =  1265, z =  7940, yaw =  0x8000 },
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_WATER,			
            startPos = { x = -1720, y = -205, z =  5135, yaw =  0x0000, airborne = false, pipe = true },		
            unwantedBhvs = { id_bhvWarpPipe },		
            overrideName = "Big Ztar Galaxy: Flower Land",
        },
        {
            name = "bits2",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -10480, y =  1895, z =  2015, yaw =  0x8000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_LAVA,			
            startPos = { x = -9495, y = -205, z = -2890, yaw =  0x2000, airborne = false, pipe = true },		
            unwantedBhvs = { id_bhvWarpPipe },		
            overrideName = "Big Ztar Galaxy: Magma Land",			
        },
        {
            name = "bits3",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -1355, y =  1325, z = -5615, yaw =  0x8000 },
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_SNOW,			
            startPos = { x = -1840, y = -355, z = -3455, yaw =  0x4000, airborne = false, pipe = true },		
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "Big Ztar Galaxy: Snow Land"			
        },
        {
            name = "bits4",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 8210, y =   500, z =   690, yaw = -0x4000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SAND,			
            startPos = { x = 4055, y = 185, z =  1080, yaw =  0x4000, airborne = false, pipe = true },	
            unwantedBhvs = { id_bhvWarpPipe },	
            overrideName = "Big Ztar Galaxy: Sand Land"			
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 10130, y =  -590, z =   165, yaw =  0x0000 },
            speed = 1.75,
            author = "BroDute",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe },		
            floodScale = 2.5,			
            floodHeight = -2600
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 860, y =  5465, z =  8455, yaw =  0x8000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_WATER,		
            startPos = { x = 8200, y = -1990, z = -9450, yaw =  0x0000, airborne = true },
            floodScale = 2.5,			
            unwantedBhvs = { id_bhvWarpPipe },				
            overrideName = "Old Meteor Courtyard",			
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = -6990, y =  3330, z =  -620, yaw = -0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_WATER,		
            overrideName = "Meteor Grounds",
            unwantedBhvs = { id_bhvWarpPipe },			
            floodHeight = -1500,		
            pipes = {
                {
                    { x = -5841, y = 1347, z = -653 },
                    { x = -2795, y = -434, z = 169, yaw = 0x0000 }
                },
            }		
        },
        {
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 1575, y = 1595, z = 140, yaw = -0x4000 },
            speed = 4.5,
            author = "BroDute",
            type = FLOOD_MAGMA,		
            unwantedBhvs = { id_bhvWarpPipe },			
            floodHeight = -3500,
            overrideName = "Star's Castle",			
            pipes = {
                {
                    { x = -1170, y = -1742, z = -1138, },				
                    { x = 2648, y = -455, z = 141, yaw = -0x4000 }
                },
                {	
                    { x = -1167, y = -33, z = -1133, },				
                    { x = -298, y = 1335, z = 190, yaw = 0x4000 }			
                },
            }						
        }
    }
end

-- Star Revenge 1.3: Redone, ported to Flood by ★~¡TOÑO!~★
local function flood_load_star_revenge_1_3_redone_levels()
    game = GAME_STAR_REVENGE_1_3
    romhackInfo = "Star Revenge 1.3 - Redone"	
    romhackLogo = get_texture_info("logo_sr1.3r")	
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 6420, y = -995, z = 4710, yaw = -0x4000},
            overrideWater = true
        },
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -5180, y = -1605, z = -4100, yaw = 0x0000},		
            overrideWater = true
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 3190, y = -2315, z = 45, yaw = -0x4000},
            deathHeight = -3800,
            pipes = {
                {
                    { x = -1561, y = -1362, z = -1850 },				
                    { x = 3000, y = 552, z = 84, yaw = -0x4000 }
                },
                {	
                    { x = -1561, y = 884, z = -1850 },				
                    { x = -940, y = 2686, z = 44, yaw = 0x4000 }				
                },
            }			
        },
        [4] = {
            level = LEVEL_RR,
            area = 1,
            spawn = {x = -130, y = -3327, z = -3260, yaw = 0x0000},
            unwantedBhvs = { id_bhvFadingWarp, id_bhvExclamationBox }		
        },
        [5] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = 2525, y = 200, z = -85, yaw = 0x0000}				
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -960, y =  3985, z =   6040, yaw =  0x0000 },
            speed = 3.25,
            author = "BroDute",
            type = FLOOD_WATER,
            floodHeight = -4400,
            music = { name = "Overworld - Super Mario Bros. 2" }			
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x =  3105, y =  4770, z =   3920, yaw =  0x4000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -545, y = -2686, z = 4935, yaw =  0x8000, airborne = true },		
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe },
            launchpads = {
                { x = -3565, y = 630, z = 6380, yaw = 0x4000, vel = 100, forwardVel = 45 },
            },			
            music = { name = "Atletic - Super Mario World" }					
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -2530, y =  7065, z =  -1700, yaw = -0x6000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_CLOUDS,		
            floodScale = 1.5,
            floodHeight = -5000,
            launchpads = {
                { x = 3245, y = -1770, z = -2160, yaw = 0x6000, vel = 100, forwardVel = 120 },
            },					
            music = { name = "Sky & Sea - Super Mario Sunshine" }				
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -21515, y =  1650, z = -22890, yaw =  0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_WATER,		
            startPos = { x = -13165, y = -62, z = -12835, yaw =  0x0000, airborne = false, pipe = true },	
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Orange Ocean - Kirby's Adventure" }					
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 12095, y = 4310, z = 2575, yaw =  0x0000 },
            flagBase = true,
            speed = 4.4,
            author = "BroDute",
            type = FLOOD_SNOW,
            startPos = { x = 8751, y = -6060, z = -5063, yaw = -0x3000, airborne = true },
            floodScale = 2,
            music = { name = "Sherbet Land / Frappe Snowland - Mario Kart 64" }					
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -1350, y =  7484, z = -735, yaw =  0x8000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_CLOUDS,
            floodScale = 2,
            floodHeight = -5800,		
            music = { name = "Sky Tower - Pokémon Mystery Dungeon: Red/Blue Rescue Team" }					
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 4900, y =  6055, z = -1300, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_FROSTBITE,
            startPos = { x = -11680, y = -4340, z =  6960, yaw =  0x8000, airborne = true },	
            unwantedBhvs = { id_bhvWarpPipe },				
            floodScale = 2.75,
            music = { name = "Bowser's Theme (Snow Mountain Mix) - Super Mario 64" }					
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -6445, y = -125, z = 215, yaw = 0x4000 },
            flagBase = true,
            speed = 2.25,
            author = "BroDute",
            type = FLOOD_WATER,			
            overrideName = "Fly To The 2nd Overworld",		
            floodHeight = -1370,		
            powerUp = "wing",			
            music = { name = "Overworld Theme - Super Mario All-Stars (Super Mario Bros.)" }					
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 5880, y = 5058, z = -6485, yaw = -0x4000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_MAGMA,		
            unwantedBhvs = { id_bhvWarpPipe },			
            music = { name = "Lower Brine Cave - Pokémon Mystery Dungeon: Explorers Of Time/Darkness/Sky" }					
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -7630, y = 5890, z =  -4090, yaw =  0x0000 },
            flagBase = true,
            speed = 2.8,
            author = "BroDute",
            type = FLOOD_ACID,				
            floodScale = 2,
            overrideWater = true,
            music = { name = "Grunty Industries - Banjo-Tooie" }	
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -9164, y = 5909, z = -6666, yaw =  0x4000 },
            flagBase = true,
            speed = 5.0,
            author = "BroDute",
            type = FLOOD_SNOW,
            startPos = { x = 290, y = -7215, z = -1175, yaw = 0x2000, airborne = true },
            floodScale = 1.5,
            launchpads = {
                { x = 5380, y = -4550, z = 2205, yaw = 32701, vel = 145, forwardVel = 0 },
            },			
            overrideSlide = true,		
            music = { name = "Sherbet Land / Frappe Snowland - Mario Kart 64" }					
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 7635,  y = 2143, z = -700, yaw = -0x4000 },
            flagBase = true,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -1145, y =  -995, z =  932, yaw = 0x6000, airborne = true },
            music = { name = "Forest Area - Kirby's Adventure" }			
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -4867, y = 3148, z = 1088, yaw = 0x4000 },
            flagBase = true,
            speed = 1.9,
            author = "BroDute",
            type = FLOOD_DESERT,
            startPos = { x = 8745, y = -383, z = -3335, yaw = -0x2000, airborne = true },
            overrideName = "Sandy Canyon",
            floodScale = 1.5,
            music = { name = "Gobi's Valley - Banjo-Tooie" }			
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 6660, y = -2940, z = 8175, yaw =  0x8000 },
            flagBase = true,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_DESERT,
            startPos = { x = -2930, y = -3970, z = 910, yaw = 0x4000, airborne = true },
            overrideName = "Sandy Pyramid",	 
            floodScale = 1.5,	
            music = { name = "Gobi's Valley - Banjo-Tooie" }			
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -9350,  y = 1890, z = 5640, yaw = 0x8000 },
            flagBase = true,
            speed = 4.5,
            author = "BroDute",
            type = FLOOD_WATER,
            floodScale = 1.5,	
            unwantedBhvs = { id_bhvWarpPipe },				
            music = { name = "Sky & Sea - Super Mario Sunshine" }			
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 30, y = 2870, z = 230, yaw =  0x6000, airborne = true },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_MAGMA,		
            floodHeight = -4250,			
            floodScale = 2.5,			
            music = { name = "Relic Castle - Pokémon Black/White" }			
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x =  6415, y = 5470, z = 3045, yaw =  0x8000 },
            flagBase = true,
            speed = 3.5,
            author = "BroDute",
            type = FLOOD_SNOW,
            floodScale = 2,
            floodHeight = -4250,
            music = { name = "Skyloft - The Legend Of Zelda: Skyward Sword" }			
        },
        {		
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -5650, y =  3555, z =  -6530, yaw =  0x4000 },
            flagBase = true,
            speed = 1.75,
            author = "BroDute",
            type = FLOOD_MAGMA,
            floodScale = 2.5,
            music = { name = "Castle Theme (Remix) - Super Mario Bros." }			
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 1212, y = 6597, z = -4954, yaw = -0x4000 },
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -1474, y = -1190, z = 5139, yaw = 0x8000, airborne = true },
            floodScale = 1.75,
            music = { name = "Forest Of Hope - Pikmin" }			
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 730, y =  6320, z =   7290, yaw =  0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_RAINBOW,
            startPos = { x = -5870, y = -3474, z = 508, yaw = 0x4000, airborne = true },	
            music = { name = "Rainbow Road (Remix) - Super Mario Kart" }			
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 740, y =  1265, z =   7940, yaw =  0x8000 },
            speed = 3.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -1110, y = -202, z =  4690, yaw =  0x0000, airborne = false, pipe = true },	
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "The Final Trial: Flower Land",	
            music = { name = "King Bowser - Super Mario Galaxy" }			
        },
        {		
            name = "bits2",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -10480, y =  1895, z = 2015, yaw =  0x8000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = -8620, y = -202, z = -2150, yaw =  0x6000, airborne = false, pipe = true },	
            floodScale = 1.5,			
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "The Final Trial: Magma Land",		
            music = { name = "King Bowser - Super Mario Galaxy" }				
        },
        {
            name = "bits3",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -1355, y =  1325, z =  -5615, yaw =  0x8000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SNOW,
            startPos = { x = -1840, y =  -352, z = -3455, yaw =  0x4000, airborne = false, pipe = true },
            floodScale = 1.5,			
            unwantedBhvs = { id_bhvWarpPipe },	
            overrideName = "The Final Trial: Snow Land",	
            music = { name = "King Bowser - Super Mario Galaxy" }				
        },
        {
            name = "bits4",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 8060, y = 500, z = 560, yaw = -0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SAND,
            startPos = { x = 4205, y = 187, z =  1090, yaw =  0x4000, airborne = false, pipe = true },	
            floodScale = 1.5,			
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "The Final Trial: Sand Land",	
            music = { name = "King Bowser - Super Mario Galaxy" }				
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -9470, y =  1770, z = 4380, yaw =  0x0000, airborne = true },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_WATER,		
            startPos = { x = -5480, y = -1130, z = -2580, yaw = -0x2000, airborne = false, pipe = true },		
            unwantedBhvs = { id_bhvWarpPipe },			
            floodScale = 2,			
            music = { name = "Goron City - The Legend Of Zelda: Ocarina Of Time" }			
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 4920, y =  4500, z =   4880, yaw =  0x8000 },
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = 7485, y = -439, z = 578, yaw = 24940, airborne = false, fading = true },		
            unwantedBhvs = { id_bhvFadingWarp },				
            floodScale = 1.75,		
            overrideName = "Hexagon I - Metal Bounces In Red",	
            music = { name = "Hyrule Field (Night) - The Legend Of Zelda: Twilight Princess" }			
        },
        {
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -9480, y =  1422, z = 4710, yaw =  -0x4000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_SAND,
            startPos = { x = -7287, y = -477, z = 1602, yaw = 0x2000, airborne = false, fading = true },	
            unwantedBhvs = { id_bhvFadingWarp },			
            floodScale = 1.75,		
            overrideName = "Hexagon II - Yellow Quicksand Spam Oh God",			
            music = { name = "Hyrule Field (Night) - The Legend Of Zelda: Twilight Princess" }				
        },
        {
            name = "rr3",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 10990, y =  4290, z = -13725, yaw = -0x4000 },
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_WASTE,
            startPos = { x = 8824, y = 1973, z = -8670, yaw = 0x8000, airborne = false, fading = true },	
            unwantedBhvs = { id_bhvFadingWarp },				
            floodScale = 1.5,
            overrideName = "Hexagon III - Ride On Green Toxic Waste",		
            music = { name = "Hyrule Field (Night) - The Legend Of Zelda: Twilight Princess" }		
        },
        {
            name = "rr4",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -3020, y = -590, z = -7880, yaw = -0x4000 },
            flagBase = true,
            speed = 7.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -8265, y = -2150, z = -9640, yaw = 0x4000, airborne = false, fading = true },	
            unwantedBhvs = { id_bhvFadingWarp },				
            floodScale = 1.5,
            overrideName = "Hexagon IV - Blue Hexa-Pool",		
            overrideWater = true,
            music = { name = "Hyrule Field (Night) - The Legend Of Zelda: Twilight Princess" }					
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 12465, y =  -735, z =    200, yaw = -0x4000 },
            flagBase = true,
            speed = 1.75,
            author = "BroDute",
            type = FLOOD_WATER,	
            floodScale = 2.5,
            overrideName = "Super Mario Bros. 1-1",
            floodHeight = -3200,
            music = { name = "Overworld Theme - Super Mario All-Stars (Super Mario Bros.)" }					
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = -8275, y =  3465, z =   8940, yaw = 0x6000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_WATER,		
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "Meteor Courtyard",
            music = { name = "Overworld 3 Theme (Remix) - Super Mario Bros 3." }					
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 7950, y =  3240, z =   1305, yaw =  0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_WATER,	
            floodScale = 1.5,
            floodHeight = -2290,	
            overrideName = "Meteor Grounds",	
            unwantedBhvs = { id_bhvWarpPipe },				
            pipes = {
                {
                    { x = 6626, y = 872, z = 1301 },				
                    { x = 3107, y = -1255, z = 526, yaw = 0x0000 }			
                },
            },			
            music = { name = "Overworld 3 Theme (Remix) - Super Mario Bros 3." }				
        },
        {
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 1590, y = 3030, z =  60, yaw = -0x4000 },
			flagBase = true,
            speed = 4.5,
            author = "BroDute",
            type = FLOOD_MAGMA,	
            floodHeight = -3300,
            overrideName = "Star's Castle",		
            unwantedBhvs = { id_bhvWarpPipe },				
            pipes = {
                {
                    { x = -1561, y = -1362, z = -1850 },				
                    { x = 3000, y = 552, z = 84, yaw = -0x4000 }
                },
                {	
                    { x = -1561, y = 884, z = -1850 },				
                    { x = -940, y = 2686, z = 44, yaw = 0x4000 }				
                },
            },
            music = { name = "Castle & Fortress - Super Mario World 2: Yoshi's Island" }				
        },
    }
end

-- Star Revenge 3: Mario on an Saoire, ported to Flood by Jzzay
local function flood_load_star_revenge_3_levels()
    game = GAME_STAR_REVENGE_3
    romhackInfo = "Star Revenge 3: Mario on An Saoire"
	romhackLogo = get_texture_info("logo_sr3")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 9721, y = -1120, z = -4485, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -1937, y = 1902, z = -10477, yaw =  0x5000 },
            flagBase = false,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_SAND,
            startPos = { x = 3295,  y = -2254, z = 9206, yaw = -0x4000 },
            floodScale = 2,
            overrideWater = true
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -22009, y = -110, z = 11219, yaw =  0x4000 },
            flagBase = false,
            speed = 2.4,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 7976,  y = -1835, z = 550, yaw = -0x4000, airborne = false },
            floodScale = 5,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 6451, y = 4885, z = 4701, yaw =  0x6500 },
            flagBase = false,
            speed = 1.8,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 8407,  y = -4215, z = -8455, yaw = 0x0000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvFadingWarp, id_bhvWarpPipe }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -521, y = 2306, z = 521, yaw =  0x0000 },
            flagBase = false,
            speed = 3.6,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -6832,  y = -1415, z = -6432, yaw = -0x1000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 2121, y = 3664, z = 249, yaw =  -0x2000 },
            flagBase = false,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_FROSTBITE,
            startPos = { x = -9563,  y = 90, z = -511, yaw = 0x5000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -8876, y = 2064, z = 2557, yaw =  0x2000 },
            flagBase = false,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_ACID,
            startPos = { x = 1973,  y = -288, z = -2501, yaw = -0x4000, airborne = false },
            floodScale = 2
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -5215, y = -75, z = 5845, yaw =  0x8000 },
            flagBase = false,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DESERT,
            startPos = { x = -2162,  y = -6075, z = 15025, yaw = 0x8000 },
            floodScale = 2
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 5070, y = 2925, z = 6985, yaw =  0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_LAVA,
            startPos = { x = -8943,  y = -5324, z = -5141, yaw = 0x3000 },
            floodScale = 2
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -1086, y = 5190, z = -4447, yaw =  0x6500 },
            flagBase = false,
            speed = 2.95,
            author = "BroDute",
            type = FLOOD_TIDE,
            startPos = { x = 6402,  y = -311, z = 8239, yaw = -0x6000 },
            floodScale = 2
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 13207, y = -779, z = 4291, yaw =  0x9000 },
            flagBase = false,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = -4937,  y = -1360, z = 319, yaw = 0x5000 },
            floodScale = 2
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -10987, y = 6160, z = -8547, yaw =  0x0000 },
            flagBase = false,
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_TIDE,
            startPos = { x = -10303,  y = -5915, z = 1854, yaw = 0x0500 },
            floodScale = 3,
            overrideSlide = true
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 904, y = -1430, z = 1650, yaw =  0x0000 },
            flagBase = false,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_TIDE,
            startPos = { x = 5696,  y = -3542, z = 5388, yaw = -0x9000 },
            floodScale = 2
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 19191, y = -199, z = -8200, yaw =  -0x2000 },
            flagBase = false,
            speed = 2.4,
            author = "BroDute",
            type = FLOOD_WASTE,
            startPos = { x = 11987,  y = -1000, z = 10203, yaw = 0x8000 },
            floodScale = 2,
            overrideName = "Castle Sewers",
            overrideWater = true
        },
    }
end

-- Star Revenge 6: Luigi's Adventure, ported to Flood by Jzzay
local function flood_load_star_revenge_6_levels()
    game = GAME_STAR_REVENGE_6
    romhackInfo = "Star Revenge 6: Luigi's Adventure"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -6260, y = 1579, z = 3766, yaw = 0x8000}
        },
        [2] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -57, y = -1124, z = -2579, yaw = 0x8000}
        },
        [3] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -85, y = -1259, z = -2814, yaw = 0x8000}
        },
        [4] = {
            level = LEVEL_PSS,
            area = 1,
            spawn = {x = -1123, y = -1074, z = 1336, yaw = 0x0000}
        },
        [5] = {
            level = LEVEL_PSS,
            area = 1,
            spawn = {x = 6366, y = -5041, z = -7768, yaw = 0x4100}
        },
        [6] = {
            level = LEVEL_PSS,
            area = 1,
            spawn = {x = -10852, y = -4900, z = -5103, yaw = 0x4000}
        },
        [7] = {
            level = LEVEL_PSS,
            area = 1,
            spawn = {x = 8225, y = -3948, z = 9320, yaw = -0x4000}
        },
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -3927, y = 1412, z = -11949, yaw = -0x2000 },
            flagBase = true,
            speed = 3.75,
            author = "BroDute",
            type = FLOOD_TIDE,
            startPos = { x = 3491, y = -2337, z = 8174, yaw = 0x9000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideWater = true,
            floodHeight = -4745
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 11979, y = 847, z = 2159, yaw = -0x3500 },
            speed = 2.8,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = 9985, y = -1956, z = 3355, yaw = -0x3500 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvFloorSwitchHiddenObjects },
            floodHeight = -3490
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -6130, y = 4265, z = 10032, yaw = -0x3000 },
            speed = 4.15,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 2458, y = -594, z = 10476, yaw = 0x8000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvBoo },
            floodHeight = -3665
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 4048, y = 1815, z = 10513, yaw = 0x5000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_MOLTEN,
            startPos = { x = 8720, y = -2685, z = -11509, yaw = -0x2600 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -875, y = 764, z = -4523, yaw = -0x1000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_MOLTEN,
            startPos = { x = 175, y = -1185, z = 959, yaw = 0x7000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvBlueCoinSwitch, id_bhvFloorSwitchHiddenObjects, id_bhvRedCoin, id_bhvGoomba, id_bhvFlamethrower, id_bhvCirclingAmp },
            overrideName = "Volcano of Karox"
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -32, y = 3500, z = 2960, yaw = 0x7400 },
            speed = 3.6,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -6708, y = -3099, z = -1790, yaw = 0x5500 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            floodHeight = -7099
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 10, y = 3524, z = -8681, yaw = 0x0050 },
            speed = 2.8,
            author = "BroDute",
            type = FLOOD_FROSTBITE,
            startPos = { x = 1067, y = -2535, z = 13401, yaw = 0x8000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideWater = true
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -8705, y = 2947, z = -7021, yaw = 0x4000 },
            speed = 2.9,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 7161, y = -2753, z = 8768, yaw = 0x9000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvFloorSwitchHiddenObjects },
            floodHeight = -4500,
            overrideName = "Old Bully Harbour",
            overrideWater = true
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 5020, y = 5655, z = -16916, yaw = 0x0000 },
            speed = 10.7,
            author = "BroDute",
            type = FLOOD_SUNSET,
            startPos = { x = -11044, y = -5683, z = 8665, yaw = 0x6000 },
            floodScale = 2.5,
            floodHeight = -8220
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 3852, y = 2522, z = 1788, yaw = 0x8000 },
            speed = 3.25,
            author = "BroDute",
            type = FLOOD_MOLTEN,
            startPos = { x = -429, y = -5055, z = -465, yaw = -0x4000 },
            floodScale = 2.5,
            floodHeight = -7295
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -6995, y = 8699, z = 1698, yaw = 0x8500 },
            speed = 2.75,
            author = "BroDute",
            type = FLOOD_REDTIDE,
            startPos = { x = 9107, y = -3099, z = 792, yaw = -0x1000 },
            floodScale = 2.5,
            floodHeight = -6245
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -5185, y = -507, z = 1501, yaw = 0x3500 },
            speed = 3.1,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 2840, y = -2457, z = 3757, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
            floodHeight = -5180
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -692, y = 7699, z = 6897, yaw = -0x4000 },
            speed = 6.0,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = -628, y = 899, z = -8685, yaw = 0x3500 },
            floodScale = 2.5,
            floodHeight = -5310
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 7765, y = -225, z = -10579, yaw = -0x2800 },
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -1958, y = -5174, z = -2572, yaw = 0x4000 },
            floodScale = 2.5
        },
        {
            name = "wdw2",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -3492, y = -285, z = -9766, yaw = -0x1000 },
            speed = 3.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 3142, y = -4125, z = 10344, yaw = 0x4000 },
            floodScale = 2.5,
            overrideName = "The Cliffs of Star Powder",
            floodHeight = -7200
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -9830, y = 3680, z = 1589, yaw = 0x1500 },
            speed = 3.85,
            author = "BroDute",
            type = FLOOD_SULFUR,
            startPos = { x = -2297, y = -2775, z = -9252, yaw = 0x7500 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 8068, y = 1653, z = -15387, yaw = 0x9300 },
            speed = 3.95,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -3644, y = -5591, z = 22213, yaw = 0x8800 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            floodHeight = -7830
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -2101, y = 1543, z = -11136, yaw = 0x4500 },
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = 4007, y = -3140, z = 11002, yaw = -0x4000 },
            floodScale = 3,
            overrideName = "Burning Harbour"
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -4574, y = 7052, z = -6136, yaw = 0x3000 },
            speed = 3.1,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -1670, y = -4810, z = 5531, yaw = -0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            floodHeight = -7080
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 13474, y = 612, z = 12777, yaw = -0x4000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_CLOUDS,
            floodScale = 3,
            overrideName = "Yoshi's Island",
            floodHeight = -2570
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 225, y = 2175, z = -3181, yaw = 0x4000 },
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = 4301, y = -1425, z = 4285, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvScuttlebug, id_bhvFloorSwitchHiddenObjects, id_bhvWarpPipe }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 13506, y = 9450, z = -444, yaw = -0x4000 },
            speed = 5.0,
            author = "BroDute",
            type = FLOOD_TIDE,
            startPos = { x = -12597, y = -9357, z = -3001, yaw = 0x2000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideSlide = true
        },
    }
end

-- Star Revenge 4: The Kedama Takeover 64, ported to Flood by MarcoGamerOJ
local function flood_load_kedama_takeover_levels()
    game = GAME_STAR_REVENGE_4
    romhackInfo = "Star Revenge 4: The Kedama Takeover 64"
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -6171, y = 1579, z = 3906, yaw = 0x6000},
            music = { name = "File Select - Mario & Luigi: Superstar Saga" }
        },
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -537, y = 899, z = 9495, yaw = 0x8000},
            music = { name = "File Select - Mario & Luigi: Superstar Saga" }
        },
        [3] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 899, z = -6565, yaw = 0x8000},
            music = { name = "File Select - Mario & Luigi: Superstar Saga" }
        },
        [4] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 0, y = -1644, z = -3085, yaw = 0x0000},
            music = { name = "Forever Forest - Paper Mario" }
        },
        [5] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -9285, y = 7062, z = -6385, yaw = 0x4000},
            music = { name = "Banana Fairy Isle - Donkey Kong 64" }
        },
        [6] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = 0, y = 6069, z = 0, yaw = 0x8000},
            music = { name = "Character Select - Jet Force Gemini" }
        },
        [7] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = 0, y = -1295, z = 0, yaw = 0x0000},
            music = { name = "Character Select - Jet Force Gemini" }
        },
        [8] = {
            level = LEVEL_BOWSER_3,
            area = 1,
            spawn = {x = 0, y = 307, z = 0, yaw = 0x8000},
            music = { name = "Ultimate Koopa (Bowser Battle Mix) - Super Mario 64" }
        },
        [9] = {
            level = LEVEL_VCUTM,
            area = 1,
            spawn = {x = 0, y = 150, z = 0, yaw = 0x0000},
            music = { name = "Dogsong - Undertale" }
        },
        [10] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = 0, y = 124, z = 0, yaw = 0x8000},
            music = { name = "King Dodongo/Volvagia Battle - The Legend of Zelda: Ocarina of Time" }
        },
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -1639, y = -1076, z = 8624, yaw = 0x8000 },
            flagBase = false,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -4000,
            music = { name = "DK Isle - Donkey Kong 64" },
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 5000, y = -2620, z = 888, yaw = 0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 4585, y = -3160, z = -6356, yaw = 0x0000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "The Old Sewers",
            music = { name = "DK Isle - Donkey Kong 64" },
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -4256, y = 2009, z = -6347, yaw = 0x0000 },
            flagBase = true,
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -5555,
            music = { name = "Neo Green Hill Zone (Act 1) - Sonic Advance" },
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 1636, y = -289, z = 4585, yaw = 0x8000 },
            flagBase = true,
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 5986, y = -4389, z = -7158, yaw = 0x0000 },
            floodScale = 2,
            overrideName = "Blue Town Complex",
            floodHeight = -5555,
            music = { name = "Neo Green Hill Zone (Act 1) - Sonic Advance" },
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -15541, y = 1750, z = 4220, yaw = 0x8000 },
            flagBase = true,
            speed = 3.5,
            author = "BroDute",
            type = FLOOD_FROSTBITE,
            floodScale = 3,
            floodHeight = -3500,
            music = { name = "Another Winter - Seiken Densetsu 3 [Trials of Mana]" },
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -6464, y = 2815, z = -5858, yaw = 0x0000 },
            flagBase = true,
            speed = 3.5,
            author = "BroDute",
            type = FLOOD_FROSTBITE,
            startPos = { x = 5757, y = -1604, z = 9999, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "The Broken Lift",
            music = { name = "Another Winter - Seiken Densetsu 3 [Trials of Mana]" },
            pipes = {
                 {
                       { x = -6262, y = 3010, z = -2121, yaw = 0x4000 },
                       { x = -5785, y = 2978, z = -6178, yaw = 0x4000 },
                 }
            },
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -12052, y = 2680, z = 8056, yaw = 0x2000 },
            flagBase = false,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SUNSET,
            floodScale = 3,
            floodHeight = -3000,
            music = { name = "Muda Kingdom - Super Mario Land" },
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 4900, y = 4656, z = -14715, yaw = 0x0000 },
            flagBase = false,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SUNSET,
            startPos = { x = -4108, y = -1133, z = -1554, yaw = 0x6000 },
            floodScale = 3,
            overrideName = "There Is Wood To Climb",
            floodHeight = -4000,
            music = { name = "Muda Kingdom - Super Mario Land" },
        },
        {
            name = "ccm3",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 6363, y = 2958, z = 7575, yaw = 0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SUNSET,
            startPos = { x = -6363, y = 291, z = 18000, yaw = 0x6000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvRedCoin },
            overrideName = "Over The Tunnel",
            floodHeight = -5000,
            music = { name = "Muda Kingdom - Super Mario Land" },
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -888, y = 703, z = -4578, yaw = 0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_LAVA,
            floodScale = 2,
            floodHeight = -3500,
            music = { name = "Underground - Super Mario World 2: Yoshi's Island" },
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 12555, y = -71, z = -7474, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_LAVA,
            startPos = { x = 14025, y = -2716, z = -5622, yaw = -0x5000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "From Cold To Warm",
            music = { name = "Underground - Super Mario World 2: Yoshi's Island" },
        },
        {
            name = "bbh3",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -6512, y = 1868, z = -2390, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_LAVA,
            startPos = { x = 8164, y = -2716, z = -2766, yaw = -0x2000 },
            floodScale = 2,
            overrideName = "The Old Tempel",
            music = { name = "Underground - Super Mario World 2: Yoshi's Island" },
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 12181, y = 5861, z = 1331, yaw = 0x8000 },
            flagBase = true,
            speed = 5.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },
            music = { name = "Hyrule Castle Tower - The Legend of Zelda: Twilight Princess" },
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 2112, y = 2744, z = 3896, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_CLOUDS,
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvSign },
            music = { name = "Stage 5 - Mr.Shine and Mr. Bright - Kirby's Block Ball" },
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 7660, y = -523, z = 9036, yaw = 0x8000 },
            flagBase = true,
            speed = 3.5,
            author = "BroDute",
            type = FLOOD_POISON,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -5000,
            music = { name = "Fortress - Super Mario Bros. 3" },
        },
        {
            name = "hmc2",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -1313, y = 83, z = -8686, yaw = 0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_POISON,
            startPos = { x = 4467, y = -1942, z = -5577, yaw = 0x0000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "AMP",
            music = { name = "Fortress - Super Mario Bros. 3" },
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -4237, y = 1452, z = -394, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_POISON,
            floodScale = 3,
            floodHeight = -7000,
            music = { name = "Forever Forest - Paper Mario" },
        },
        {
            name = "lll2",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -2345, y = 1277, z = 16600, yaw = 0x0000 },
            flagBase = true,
            speed = 3.5,
            author = "BroDute",
            type = FLOOD_POISON,
            startPos = { x = -9054, y = -2922, z = 19360, yaw = 0x4000 },
            floodScale = 3,
            overrideName = "A Mountain Climb",
            floodHeight = -7000,
            music = { name = "Forever Forest - Paper Mario" },
        },
        {
            name = "lll3",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -3838, y = -2063, z = -17800, yaw = 0x8000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_POISON,
            startPos = { x = 8765, y = -3972, z = -14825, yaw = -0x4000 },
            floodScale = 3,
            overrideName = "Wood 'n' Water",
            floodHeight = -7000,
            music = { name = "Forever Forest - Paper Mario" },
        },
        {
            name = "lll4",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -3115, y = 1452, z = 7171, yaw = 0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_POISON,
            startPos = { x = 2929, y = -5257, z = 9865, yaw = -0x4000 },
            floodScale = 3,
            overrideName = "Building Of No Purpose",
            floodHeight = -7000,
            music = { name = "Forever Forest - Paper Mario" },
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -7855, y = 3599, z = 2727, yaw = -0x6000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_FROSTBITE,
            startPos = { x = 3341, y = -2500, z = -777, yaw = 0x8000 },
            floodScale = 2,
            floodHeight = -4444,
            music = { name = "Freezeflame Galaxy - Super Mario Galaxy" },
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 1756, y = 2999, z = 388, yaw = 0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_FROSTBITE,
            startPos = { x = -9391, y = -2500, z = -1552, yaw = 0x4000 },
            floodScale = 2,
            overrideName = "The Shrinking Paths",
            floodHeight = -4000,
            music = { name = "Freezeflame Galaxy - Super Mario Galaxy" },
        },
        {
            name = "ssl3",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -4848, y = 799, z = 8844, yaw = 0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_FROSTBITE,
            floodScale = 2,
            overrideName = "The Other Path",
            floodHeight = -5555,
            music = { name = "Freezeflame Galaxy - Super Mario Galaxy" },
            pipes = {
                 {
                       { x = 8181, y = 2599, z = 4040, yaw = 0x8000 },
                       { x = 7474, y = 379,  z = 4747, yaw = 0x8000 },
                 }
            },
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 6578, y = -773, z = 5744, yaw = -0x4000 },
            flagBase = true,
            speed = 3.5,
            author = "BroDute",
            type = FLOOD_MAGMA,
            music = { name = "Mansion (Exterior) - Luigi's Mansion" },
        },
        {
            name = "tofwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -12345, y = 1828, z = 666, yaw = 0x0000 },
            flagBase = true,
            speed = 5.0,
            author = "BroDute",
            type = FLOOD_CLOUDS,
            floodScale = 2,
            unwantedBhvs = { id_bhvRedCoin },
            music = { name = "Vermilion City - Pokémon HeartGold/SoulSilver" },
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -9044, y = 4525, z = 5987, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DESERT,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -5000,
            music = { name = "Kalamari Desert - Mario Kart 64" },
        },
        {
            name = "sl2",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -685, y = 2320, z = 1717, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DESERT,
            startPos = { x = -7185, y = 1585, z = 5965, yaw = 0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Insepct The Desert",
            floodHeight = -2500,
            music = { name = "Kalamari Desert - Mario Kart 64" },
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -2224, y = -850, z = -11449, yaw = 0x4000 },
            flagBase = true,
            speed = 3.5,
            author = "BroDute",
            type = FLOOD_WATER,
            floodScale = 2,
            overrideWater = false,
            music = { name = "Purple Comet - Super Mario Galaxy" },
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -1855, y = 503, z = 3131, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_POISON,
            floodScale = 2,
            unwantedBhvs = { id_bhvRedCoin },
            floodHeight = -6000,
            music = { name = "Frantic Factory - Donkey Kong 64" },
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -1150, y = 2610, z = 8080, yaw = -0x6000 },
            flagBase = false,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_MAGMA,
            floodScale = 2,
            floodHeight = -6000,
            music = { name = "Pinna Park Beach - Super Mario Sunshine" },
            pipes = {
                 {
                       { x =  3815, y = 720,  z = -444,  yaw =  0x0000 },
                       { x = -1500, y = 1439, z =  5200, yaw = -0x4000 },
                 }
            },
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -515, y = -1414, z = 7535, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvSign },
            floodHeight = -8500,
            music = { name = "The Lower Earth Empire - Blue's Journey" },
        },
        {
            name = "ttm2",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 12465, y = 1929, z = 515, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = -515, y = 0, z = 7535, yaw = -0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvSign },
            overrideName = "Shining Needle Castle's",
            floodHeight = -4500,
            music = { name = "The Lower Earth Empire - Blue's Journey" },
        },
        {
            name = "ttm3",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 578, y = 5711, z = 7744, yaw = -0x6000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = 10900, y = 821, z = -1133, yaw = -0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvSign },
            overrideName = "The Beat Of The Sky",
            floodHeight = -1500,
            music = { name = "The Lower Earth Empire - Blue's Journey" },
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -3232, y = 6210, z = 578, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_SULFUR,
            floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -5000,
            music = { name = "Hot-Head Bop - Donkey Kong Country 2: Diddy's Kong Quest" },
        },
        {
            name = "thi2",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 9090, y = 6725, z = 5820, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_SULFUR,
            startPos = { x = 3255, y = -340, z = -5737, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Climb To The Highest Point",
            floodHeight = -2500,
            music = { name = "Hot-Head Bop - Donkey Kong Country 2: Diddy's Kong Quest" },
        },
        {
            name = "thi3",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -11666, y = 3155, z = -3515, yaw = 0x6000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_SULFUR,
            startPos = { x = 8715, y = 0, z = -4000, yaw = -0x6000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "The Floating Island",
            floodHeight = -2500,
            music = { name = "Hot-Head Bop - Donkey Kong Country 2: Diddy's Kong Quest" },
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -572, y = 3354, z = 14579, yaw = 0x6000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_RAINBOW,
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvSign },
            floodHeight = -7000,
            music = { name = "Exclaim - Phantasy Star II" },
        },
        {
            name = "ttc2",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -7111, y = 3812, z = -17844, yaw = 0x2000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_RAINBOW,
            startPos = { x = 5685, y = -3812, z = -543, yaw = -0x6000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvSign },
            overrideName = "Big Dreamy Fall",
            music = { name = "Exclaim - Phantasy Star II" },
        },
        {
            name = "ttc3",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 16185, y = 2592, z = 13737, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_RAINBOW,
            startPos = { x = 6633, y = 762, z = 5962, yaw = 0x0000, airborne = false },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvSign },
            overrideName = "A Castle Exploration",
            music = { name = "Exclaim - Phantasy Star II" },
        },
        {
            name = "ttc4",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -12345, y = 3812, z = 3678, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_RAINBOW,
            startPos = { x = 4915, y = -1220, z = 1385, yaw = 0x0000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvSign },
            overrideName = "The Castle's Garden?",
            music = { name = "Exclaim - Phantasy Star II" },
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -10200, y = 7820, z = 2442, yaw = 0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            floodScale = 3,
            floodHeight = -9000,
            music = { name = "Pain - Phantasy Star IV: The End of the Millennium" },
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 6699, y = 624, z = 2535, yaw = 0x0000 },
            flagBase = false,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvSign },
            music = { name = "Rainbow Road - Mario Kart 64" },
        },
        {
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -3114, y = 4975, z = -8077, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = 3141, y = -4536, z = 3178, yaw = -0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvSign },
            launchpads = {
                { x = -3114, y = 4037, z = -14457, yaw = 0x0000, vel = 111, forwardVel = 0 }
            },
            music = { name = "Rainbow Road - Mario Kart 64" },
        },
        {
            name = "rr3",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -13360, y = 11261, z = -8077, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = -3114, y = 4975, z = -9077, yaw = 0x0000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvSign },
            floodHeight = -0,
            music = { name = "Rainbow Road - Mario Kart 64" },
        },
        {
            name = "castle_grounds",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = -6634, y = 2316, z = -7767, yaw = 0x2000 },
            flagBase = false,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_TIDE,
            floodScale = 2,
            floodHeight = -1000,
            launchpads = {
                { x = 2599, y = 899, z = 2178, yaw = 0x0000, vel = 165, forwardVel = 0 }
            },
            music = { name = "File Select - Mario & Luigi: Superstar Saga" },
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 13925, y = -1125, z = 219, yaw = -0x4000 },
            flagBase = false,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_RAINBOW,
            floodScale = 4,
            unwantedBhvs = { id_bhvKoopa },
            floodHeight = -5555,
            music = { name = "Hyrule Castle Tower - The Legend of Zelda: Twilight Princess" },
        },
    }
end

-- Scrooge 64, ported to Flood by Jzzay
local function flood_load_scrooge_64_levels()
    game = GAME_SCROOGE_64
    romhackInfo = "Scrooge 64"
	romhackLogo = get_texture_info("logo_scrooge64")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -750, y = -1120, z = 1845, yaw = 0x8000}
        },
        [2] = {
            level = LEVEL_BOB,
            area = 1,
            spawn = {x = 19, y = -1450, z = -4509, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 1790,  y = -2772, z =  4091, yaw = 0x8000 },
            speed = 2.5,
            author = "Kinopio",
            type = FLOOD_WATER,
            startPos = { x = 6476, y = -7972, z = 7317, yaw = -0x4000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Super Mario Bros. Classic"
        },
        {
            name = "bitdw2",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -3285,  y = -776, z =  -5422, yaw = 0x0000 },
            speed = 5.75,
            author = "Kinopio",
            type = FLOOD_DARKNESS,
            startPos = { x = -4132, y = -4834, z = -4084, yaw = 0x6000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Donkey Kong 3D"
        },
        {
            name = "bitdw3",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -807,  y = 8129, z =  5093, yaw = 0x7500 },
            speed = 3.5,
            author = "Kinopio",
            type = FLOOD_CLOUDS,
            startPos = { x = -1539, y = -1336, z = 4800, yaw = -0x4000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Super Mario Bros. Athletic"
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x =  10701, y =  4879, z = -1947, yaw = -0x4000 },
            flagBase = true,
            speed = 1.75,
            author = "Kinopio",
            type = FLOOD_MOLTEN,
            startPos = { x = 5785, y = -5654, z = 2929, yaw = -0x4000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Bowser's Galactic Fortress"
        },
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -3686,  y = -86,  z =  5294, yaw = 0x8000 },
            speed = 5.5,
            author = "Kinopio",
            type = FLOOD_SNOW,
            startPos = { x = 19, y = -1450, z = -4546, yaw = 0x0000 },
            floodScale = 2
        },
    }
end

-- Marvel Adventure, ported to Flood by SausRelics and ~!TONO!~
local function flood_load_marvel_adventure_levels()
    game = GAME_MARVEL_ADVENTURE
    romhackInfo = "Super Mario and the Marvel Adventure"
	romhackLogo = get_texture_info("logo_smatma")	
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = -4354, z = 141, yaw = 0}
        },
        [2] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = -4828, y = 1355, z = -1025, yaw = 0x4000}
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -4630, y = -1309, z = 1000, yaw =  0x6000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 6235, y = 2163, z = -1068, yaw = 0x8000 },
            speed = 3.1,
            author = "Kampel125",
            type = FLOOD_WATER,
            startPos = { x = 2420, y = -3801, z = -517, yaw = 0x8000 },
            floodScale = 2
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 8430, y = 1832, z = -725, yaw = -0x4000 },
            flagBase = true,
            speed = 3.1,
            author = "Kampel125",
            type = FLOOD_DESERT,
            startPos = { x = -2742, y = -1382, z = 8854, yaw = 0x8000, airborne = false },
            floodScale = 2
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 15565, y = 3397, z = 7780, yaw = 0x0000 },
            flagBase = false,
            speed = 3.7,
            author = "Kampel125",
            type = FLOOD_SNOW,
            startPos = { x = 4329, y = -3006, z = 3205, yaw = -0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Frost Cavern",
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -6431, y = 1872, z = 13105, yaw = -0x4000 },
            flagBase = false,
            speed = 3.9,
            author = "Kampel125",
            type = FLOOD_MOLTEN,
            startPos = { x = -10503, y = -2787, z = 3510, yaw = 0x1000 },
            floodScale = 2,
            overrideName = "Burn Cavern"
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -87, y = 2393, z = 7974, yaw = 0x4000 },
            flagBase = true,
            speed = 3.8,
            author = "Kampel125",
            type = FLOOD_DARKNESS,
            startPos = { x = 628, y = -1505, z = -1872, yaw = 0x2000 },
            floodScale = 2
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -4129, y = 3325, z = 8068, yaw = 0x4000 },
            speed = 2.7,
            author = "Kampel125",
            type = FLOOD_ACID,
            startPos = { x = -7087, y = -4332, z = 11706, yaw = 0x8000 },
            floodScale = 2
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -11939, y = -244, z = -1551, yaw = 0x0000 },
            flagBase = true,
            speed = 2.4,
            author = "Kampel125",
            type = FLOOD_ACID,
            startPos = { x = -52, y = -4332, z = 9566, yaw = -0x4000 },
            floodScale = 2,
            overrideName = "Rugged Bar Platforming"
        },
        {
            name = "bbh3",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 9233, y = 4010, z = -2462, yaw = -0x6000 },
            flagBase = false,
            speed = 3.8,
            author = "Kampel125",
            type = FLOOD_DARKNESS,
            startPos = { x = -1930, y = -4332, z = 9889, yaw = 31826 },
            floodScale = 2,
            overrideName = "Rugged Cardboard Box Co."
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 4678, y = 769, z = 686, yaw = 0x8000 },
            flagBase = false,
            speed = 4.0,
            author = "Kampel125",
            type = FLOOD_MOLTEN,
            startPos = { x = -5485, y = -2100, z = 5394, yaw = -32768 },
            floodHeight = -6544
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -3598, y = 3030, z = 2113, yaw = 0x4000 },
            flagBase = true,
            speed = 3.9,
            author = "Kampel125",
            type = FLOOD_CLOUDS,
            startPos = { x = 3533, y = -3388, z = 4322, yaw = -27306 },
            floodScale = 2
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -1359, y = 2675, z = -9539, yaw = 0x4000 },
            flagBase = true,
            speed = 5.0,
            author = "Kampel125",
            type = FLOOD_CLOUDS,
            startPos = { x = -6480, y = -2585, z = 7088, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvRedCoin },
            floodHeight = -6203
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 4053, y = 290, z = -5081, yaw = -0x4000 },
            flagBase = false,
            speed = 1.4,
            author = "Kampel125",
            type = FLOOD_DARKNESS,
            startPos = { x = -1470, y = -1319, z = 296, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wmotr2",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -5370, y = -1284, z = -4339, yaw = 0x0000 },
            flagBase = true,
            speed = 1.5,
            author = "Kampel125",
            type = FLOOD_DARKNESS,
            startPos = { x = -5370, y = -1284, z = 4660, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Shaped Rows Puzzle"
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 8466, y = 1125, z = -9536, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_MATRIX,
            startPos = { x = 9140, y = -1894, z = -9479, yaw = -0x4000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Green Cyberspace"
        },
        {
            name = "bitdw2",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 7210, y = -860, z = 7630, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_MATRIX,
            startPos = { x = 9715, y = -4102, z = 11300, yaw = -0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Blue Cyberspace"
        },
        {
            name = "bitdw3",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -13060, y = -410, z = -965, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Kampel125",
            type = FLOOD_MATRIX,
            startPos = { x = -9890, y = -3039, z = 545, yaw = -0x4000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Red Cyberspace"
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 2642, y = 6929, z = 5709, yaw = -0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "Kampel125",
            type = FLOOD_MOLTEN,
            startPos = { x = -12273, y = -3500, z = 1809, yaw = 0x4000 }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -5818, y = -3703, z = 1735, yaw = -0x4000 },
            flagBase = false,
            speed = 2.3,
            author = "Kampel125",
            type = FLOOD_MOLTEN,
            startPos = { x = -8436, y = -6650, z = 4591, yaw = -0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 11030, y = 440, z = 1960, yaw = -0x4000 },
            flagBase = true,
            speed = 5.0,
            author = "Kampel125",
            type = FLOOD_WATER,
            startPos = { x = -4630, y = -1309, z = 1000, yaw = 0x6000 },
            floodScale = 3,
            overrideName = "Marvelous Fields"
        },
    }
end

-- Super Mario The Galactic Journey, ported to Flood by Bear64DX and ~!TONO!~
local function flood_load_the_galactic_journey_levels()
    game = GAME_THE_GALACTIC_JOURNEY
	romhackInfo = "Super Mario The Galactic Journey"
	romhackLogo = get_texture_info("the_galactic_journey_logo")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -343, y = 944, z = 1154, yaw = 0x8000}
        },
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 8727, y = -3208, z = -3700, yaw = 0}
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 573, y = -744, z = -6684, yaw = 0}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 2100, y = 830, z = -12935, yaw = -0x4000 },
            flagBase = true,
            speed = 1.0,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = -8043, y = -2707, z = 16874, yaw = 32417 }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -13180, y = 3782, z = -4343, yaw = 0x4000 },
            flagBase = false,
            speed = 3.2,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = 11925, y = -4654, z = 3604, yaw = -0x5000 }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -19670, y = 3300, z = -3575, yaw = 0x0000 },
            flagBase = false,
            speed = 3.5,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = 5243, y = -6909, z = -24191, yaw = -9668 }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 19810, y =  6940, z =  9610, yaw =  0x0000 },
            flagBase = false,
            speed = 4.3,
            author = "Fares242",
            type = FLOOD_LAVA,
            startPos = { x = -5719, y = -5667, z = 7400, yaw = 14319 }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 20335, y = 341, z = 12515, yaw = -0x4000 },
            flagBase = false,
            speed = 2.0,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = 4370, y = -4154, z = -14112, yaw = 0x0000 }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -3285, y = -3015, z = 8180, yaw = 0x8000 },
            flagBase = true,
            speed = 3.5,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = 12215, y = -4825, z = -12799, yaw = -10795 }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 9, y = 4872, z = -882, yaw = 0x0000 },
            speed = 3.0,
            author = "Fares242",
            type = FLOOD_MOLTEN,
            startPos = { x = 5, y = -6469, z = -10545, yaw = 0 }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -16051, y = 383, z = -16216, yaw = 0 },
            flagBase = true,
            speed = 4.5,
            author = "Fares242",
            type = FLOOD_CLOUDS,
            startPos = { x = -521, y = -7516, z = -14735, yaw = 0 }
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -5753, y = 5993, z = 8067, yaw = 0x8000 },
            flagBase = false,
            speed = 3.5,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = -1615, y = -6773, z = -9213, yaw = 0x0000 }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 8522, y = 4206, z = 5498, yaw = -29595 },
            flagBase = false,
            speed = 3.2,
            author = "Fares242",
            type = FLOOD_DESERT,
            startPos = { x = 1181, y = -1546, z = -14543, yaw = -406 }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 7684, y = 2309, z = -812, yaw = -0x4000 },
            flagBase = false,
            speed = 2.0,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = -4948, y = -5774, z = -2144, yaw = 0x0000 }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -2446, y = 10197, z = 4606, yaw = 0x0000 },
            flagBase = false,
            speed = 3.0,
            author = "Fares242",
            type = FLOOD_LAVA,
            startPos = { x = -2231, y = 2990, z = -83, yaw = 0x3000 }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 5971, y = -275, z = 13962, yaw = 0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = 12924, y = -3048, z = -10345, yaw = 0x0000 }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -15818, y = 3243, z = 14576, yaw = -12470 },
            flagBase = false,
            speed = 4.5,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = 13773, y = 473, z = -12097, yaw = -16394 }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -17000, y = 6805, z = 1560, yaw = 0x0000 },
            flagBase = false,
            speed = 2.0,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = -3918, y = 1260, z = -20154, yaw = 0 },
            overrideWater = true
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 24080, y = 1615, z = -11990, yaw = 0x0000 },
            flagBase = false,
            speed = 1.0,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = -11342, y = -429, z = -8459, yaw = 17374 }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 9849, y = 3154, z = 6950, yaw = 0 },
            flagBase = true,
            speed = 2.7,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = 2081, y = -4597, z = -12831, yaw = 0 }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 5600, y = -455, z = -20425, yaw = 15675 },
            flagBase = false,
            speed = 4.0,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = 9944, y = -7902, z = -5221, yaw = -249 }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 12435, y = 6142, z = -8148, yaw = -0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "Fares242",
            type = FLOOD_LAVA,
            startPos = { x = -190, y = -6519, z = 11757, yaw = 0x8000 }
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 4750, y = 920, z = 4335, yaw = 0x0000 },
            flagBase = false,
            speed = 4.5,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = 1044, y = -340, z = -8344, yaw = -1 },
            overrideName = "Planet Stardust"
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 1785, y = -22, z = -4310, yaw = -16520 },
            flagBase = true,
            speed = 1.75,
            author = "Fares242",
            type = FLOOD_WATER,
            startPos = { x = 12597, y = -3208, z = 4027, yaw = -23459 },
            overrideName = "Infested Star Crater"
        },
    }
end

-- Super Mario Parallel Stars, ported to Flood by ★~¡TOÑO!~★ and Jzzay
local function flood_load_super_mario_parallel_stars_levels()
    game = GAME_SUPER_MARIO_PARALLEL_STARS
    romhackInfo = "Super Mario Parallel Stars"
    romhackLogo = get_texture_info("logo_smps")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 1075, z = 0, yaw = 0x6000}
        },
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 0, y = 0, z = -8036, yaw = 0}
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 0, y = -10, z = 3650, yaw = 0x8000}
        },
        [4] = {
            level = LEVEL_CCM,
            area = 3,
            spawn = {x = 0, y = 0, z = -6100, yaw = 0x0000}		
        },
        [5] = {
            level = LEVEL_RR,
            area = 1,
            spawn = {x = 0, y = 180, z = 0, yaw = 0x8000},
            unwantedBhvs = { id_bhvFadingWarp },
            deathHeight = 178			
        },
        [6] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}		
        },
        [7] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = 10, y = 512, z = 5600, yaw = 0x8000}		
        },
        [8] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = 0, y = 307, z = -40, yaw = 0x0000}		
        },
        [9] = {
            level = LEVEL_BOWSER_3,
            area = 1,
            spawn = {x = -1330, y = 1000, z = 0, yaw = 0x4000}	
        },
        [10] = {
            level = LEVEL_TOTWC,
            area = 1,
            spawn = {x = 0, y = 2480, z = 0, yaw = 0x0000}				
        }
    }
	
    gLevels = {
        {	
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 2260, y = 1955, z = -2230, yaw = -0x2000 },
            flagBase = true,
            speed = 2.75,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,			
            startPos = { x = 7967, y = -928, z = 7967, yaw = -0x6000, airborne = true },					
            floodScale = 1.5,
            music = { name = "Normal Mode - Puyo Puyo SUN (Saturn)" }			
        },
        {						
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 890, y = 7912, z = 1345, yaw =  0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = -4220, y = 539, z = 5760, yaw = 0x6000, airborne = true },	
            floodScale = 1.75,
            music = { name = "Ruins Stage - Treasure Hunter - Puyo Puyo 4" }			
        },
        {						
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 6695, y = 460, z = -2349, yaw = -0x4000 },
            flagBase = true,
            speed = 3.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,
            startPos = { x = -1601, y = -5000, z = 554, yaw = 0x7000, airborne = true },	
            floodScale = 1.5,
            overrideWater = true,
            music = { name = "Battle 2 - Super Bomberman 2" }			
        },
        {						
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -533,  y = 7900, z = 962, yaw =  0x4000 },
            speed = 4.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_SNOW,
            startPos = { x = -6588, y = 0, z = -11408, yaw = 0x1000, airborne = true },	
            floodScale = 2,
            music = { name = "Dreamy Iceland (Level 3) - Commet Summoner" }			
        },
        {						
            name = "ccm2",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = -43, y = 10000, z = 95, yaw = -0x2000 },
            flagBase = true,
            speed = 5.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_FROSTBITE,
            startPos = { x = -9390, y = -7402, z = -15570, yaw =  0x2000, airborne = true },	
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideSlide = true,
            overrideName = "Frozen Mountain Slide",
            music = { name = "Faster Than All - Mario Party" }			
        },
        {						
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -3531, y =  2820, z = -1278, yaw = -0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 2200, y = 0, z = 2150, yaw = -0x6000, airborne = true },	
            music = { name = "Cinnabar Mansion - Pokémon Red/Blue/Green/Yellow" }			
        },
        {						
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -8693, y = 2700, z = -9211, yaw =  0x2000 },
            speed = 2.75,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_CLOUDS,	
            floodScale = 2,
            floodHeight = -500,
            music = { name = "Result - Puyo Puyo SUN" }			
        },
        {						
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 550, y =  5082, z = 20773, yaw =  0x8000 },
            flagBase = true,
            speed = 1.25,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,			
            startPos = { x = 4150, y = -1530, z = 7875, yaw = 0x0000, airborne = true },	
            floodScale = 2.5,
            music = { name = "Healing Vision - Dance Dance Revolution 5th Mix" }			
        },
        {	
            name = "b1",
            level = LEVEL_BOWSER_1,
            area = 1,
            flagPos = { x = 0, y = 510, z = -5590, yaw = 0x0000 },
            flagBase = true,
            speed = 1.75,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_DARKNESS,
            floodHeight = -65,
            overrideName = "Bowser's Boo Showdown",
            music = { name = "POSSESION [FAKE] - Dance Dance Revolution X2" }					
        },
        {		
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -1811, y = 225, z = 9336, yaw = 0x8000 },
            flagBase = true,
            speed = 1.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,			
            startPos = { x = -4, y = 790, z = -9727, yaw = 0x0000, airborne = true },
            floodScale = 2.5,			
            floodHeight = -1250,
            music = { name = "Arisa's Theme - Shadowverse" }			
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -55, y = -1075, z = -100, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,		
            startPos = { x = 95, y = -3125, z = 0, yaw = 0x4000, airborne = true },	
            capTimer = 600,
            music = { name = "我、敵機動部隊ト交戦ス - Kantai Collection" }			
        },
        {						
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 1105, y = 3010, z = -635, yaw = -11230 },
            speed = 2.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_LAVA,			
            floodScale = 1.5,
            music = { name = "Battle Solo - Super Bomberman 4" }			
        },
        {						
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 0, y = 3890, z = -7735, yaw =  0x0000 },
            speed = 2.75,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_LAVA,			
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = 1000,
            capTimer = 1,			
            music = { name = "i hate you - Puyo Puyo DAI featuring ELLENA System" }			
        },
        {						
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 1448, y =  9728, z = -4743, yaw = 0x4000 },
            flagBase = true,
            speed = 3.25,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_DESERT,		
            startPos = { x = -1525, y = 1730, z = -2264, yaw = 0x8000, airborne = true },	
            floodScale = 2,
            floodHeight = 0,
            music = { name = "Cotton Island - Plok!" }			
        },
        {						
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -1275, y =  6553, z = -110, yaw = -0x4000 },
            flagBase = true,
            speed = 2.75,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,		
            floodScale = 1.5,
            music = { name = "夢について TYPE B - GuitarFreaks & DrumMania XG2" }			
        },
        {						
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -2135, y = 6621, z = -420, yaw = 5740 },
            speed = 2.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_FROSTBITE,			
            startPos = { x = -8290, y = 1665, z = 415, yaw = 0x0000, airborne = true },	
            floodScale = 1.75,	
            music = { name = "Frozen Hillside - Kirby Air Ride" }			
        },
        {						
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 2992, y = 6040, z = -9017, yaw = 0x4000 },
            flagBase = true,
            speed = 1.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_MOLTEN,		
            floodScale = 2,
            floodHeight = -3500,
            unwantedBhvs = { id_bhvWarpPipe },		
            music = { name = "MAX300 - DDRMAX - Dance Dance Revolution 6th MIX" }
        },
        {						
            name = "b2",
            level = LEVEL_BOWSER_2,
            area = 1,
            flagPos = { x = 0, y = 310, z = 5115, yaw = 0x8000 },
            flagBase = true,
            speed = 2.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_ACID,			
            startPos = { x = 0, y = 700, z = -5115, yaw = 0x0000, airborne = true },	
            overrideName = "Bowser's Boo n' Amp Challenge",
            music = { name = "Fighting Girl - コメットサマナー / Comet Summoner" }			
        },
        {						
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -11225, y = 5275, z = -5015, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,		
            startPos = { x = 1390, y = -50, z = -6380, yaw = 0x0000, airborne = true },				
            floodScale = 1.75,
            launchpads = {
                { x = -3110, y = 1690, z = 10865, yaw = 32701, vel = 95, forwardVel = 0 },
            },			
            music = { name = "雨-05 海上輸送作戦 - Kantai Collection (Events)" }			
        },
        {						
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 0, y = 6080, z = -12000, yaw = 0x0000 },
            flagBase = true,
            speed = 3.23,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_CLOUDS,	
            floodScale = 2.5,	
            floodHeight = -1000,
            launchpads = {
                { x = 0, y = 5395, z = -1415, yaw = 32701, vel = 300, forwardVel = 80 },
            },		
            music = { name = "20.NOVEMBER (D.D.R Version) - Dance Dance Revolution 2nd Mix" }			
        },
        {						
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -7480, y =  2200, z = 0, yaw =  0x4000 },
            speed = 6.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,		
            startPos = { x = -2250, y = 450, z = -20, yaw = -0x4000, airborne = true },		
            overrideName = "Mese's Cannonless Trick",		
            unwantedBhvs = { id_bhvDoorWarp },
            music = { name = "ファミポップ - Music Atelier Amacha" }			
        },
        {						
            name = "sa2",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 1185, y =  2355, z = -5640, yaw = -0x6000 },
            speed = 2.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,		
            startPos = { x = 20, y =  450, z = -2270, yaw = 0x8000, airborne = true },	
            overrideName = "Mese's Chuckya Trick",	
            unwantedBhvs = { id_bhvDoorWarp },
            music = { name = "ファミポップ - Music Atelier Amacha" }				
        },
        {						
            name = "sa3",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 8665, y = 1895, z = 35, yaw = -0x4000 },
            speed = 1.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,		
            startPos = { x = 2270, y = 450, z = 20, yaw =  0x4000, airborne = true },	
            overrideName = "Mese's Underwater Switch Trick",
            unwantedBhvs = { id_bhvDoorWarp },
            music = { name = "ファミポップ - Music Atelier Amacha" }				
        },
        {						
            name = "sa4",
            level = LEVEL_SA,
            area = 2,
            flagPos = { x = 2045, y = 3430, z = 5425, yaw = 0x6000 },
            speed = 3.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_LAVA,		
            startPos = { x = 3495, y = 0, z = 1910, yaw =  0x0000, airborne = true },			
            overrideName = "Mese's Lava Boost Trick",	
            unwantedBhvs = { id_bhvDoorWarp },
            music = { name = "ファミポップ - Music Atelier Amacha" }		
        },
        {						
            name = "sa5",
            level = LEVEL_SA,
            area = 2,
            flagPos = { x = 6060, y =  6020, z = -4805, yaw =  0x0000 },
            speed = 1.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,		
            overrideName = "Mese's BLJ Tricks",
            unwantedBhvs = { id_bhvDoorWarp },
            music = { name = "ファミポップ - Music Atelier Amacha" }			
        },
        {						
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 3790, y = 4920, z = 2300, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,		
            startPos = { x = 1290, y = 0, z = -4280, yaw = 0x0000, airborne = true },		
            music = { name = "Lockstep - Rhythm Heaven (US Release)" }			
        },
        {						
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 3245, y =  4500, z = -6077, yaw = -0x4000 },
            flagBase = true,
            speed = 3.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_CLOUDS,		
            startPos = { x = 0, y = 1510, z = -5, yaw =  0x8000, airborne = true },	
            overrideName = "Imitative Luminium Sphere",
            music = { name = "6th Floor - Puyo Puyo 2" }			
        },
        {						
            name = "ttc2",
            level = LEVEL_TTC,
            area = 2,
            flagPos = { x = 1490, y =  5700, z =  -450, yaw =  0x0000 },
            flagBase = true,
            speed = 3.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_ACID,
            overrideName = "Imitative Veneno Sphere",		
            floodHeight = -2325,
            music = { name = "6th Floor - Puyo Puyo 2" }				
        },
        {						
            name = "ttc3",
            level = LEVEL_TTC,
            area = 3,
            flagPos = { x = -2230, y =  5950, z = -810, yaw = 0x4000 },
            flagBase = true,
            speed = 1.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,
            overrideName = "Imitative Levora Sphere",
            music = { name = "6th Floor - Puyo Puyo 2" }				
        },
        {						
            name = "ttc4",
            level = LEVEL_TTC,
            area = 4,
            flagPos = { x = 3040, y = 6195, z = 6375, yaw = 0x8000 },
            speed = 1.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_MUD,
            overrideName = "Imitative Baratrok Sphere",
            music = { name = "6th Floor - Puyo Puyo 2" }				
        },
        {						
            name = "ttc5",
            level = LEVEL_TTC,
            area = 5,
            flagPos = { x = -5280, y = 3685, z = -6050, yaw = 0x4000 },
            speed = 2.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_LAVA,
            overrideName = "Imitative Crudelo Sphere",
            music = { name = "6th Floor - Puyo Puyo 2" }				
        },
        {						
            name = "ttc6",
            level = LEVEL_TTC,
            area = 6,
            flagPos = { x = 0, y = 1950, z = 4030, yaw =  0x8000 },
            speed = 4.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 3500, y = -4900, z = 6075, yaw = -0x4000, airborne = false },			
            overrideName = "Imitative Ombru Sphere",
            music = { name = "6th Floor - Puyo Puyo 2" }				
        },
        {						
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -11075, y =  2750, z = -3598, yaw = -20120 },
            flagBase = true,
            speed = 2.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_LAVA,	
            startPos = { x = -7297, y = 370, z = -2377, yaw = -19661, airborne = false, fading = true },	
            floodScale = 1.75,
            unwantedBhvs = { id_bhvFadingWarp },	
            overrideName = "Parallel Portal: Burning Garden",			
            launchpads = {
                { x = -14260, y = 1850, z = -4600, yaw = 13070, vel = 80, forwardVel = 0 },
            },
            music = { name = "MEGALOMANIA - LIVE A LIVE" }				
        },
        {						
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 9714, y =  3000, z = -3120, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_ACID,	
            startPos = { x = 7291, y = 25, z = -2369, yaw = 19660, airborne = false, fading = true },			
            floodScale = 1.75,			
            unwantedBhvs = { id_bhvFadingWarp },		
            overrideName = "Parallel Portal: Windy Ruin",		
            music = { name = "MEGALOMANIA - LIVE A LIVE" }				
        },
        {						
            name = "rr3",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 5136, y = 25, z = 11475, yaw = 0x0000 },
            flagBase = true,
            speed = 1.25,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_DARKNESS,	
            startPos = { x = 4863, y = 150, z = 6697, yaw = 6553, airborne = false, fading = true },		
            floodScale = 1.75,			
            unwantedBhvs = { id_bhvFadingWarp },	
            overrideName = "Parallel Portal: Cursed Forest",
            music = { name = "MEGALOMANIA - LIVE A LIVE" }				
        },
        {						
            name = "rr4",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -7602, y =  3250, z =  7035, yaw = -0x4000 },
            speed = 2.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_FROSTBITE,	
            startPos = { x = -4807, y = 125, z = 6613, yaw = -6554, airborne = false, fading = true },		
            floodScale = 1.75,	
            unwantedBhvs = { id_bhvFadingWarp },			
            overrideName = "Parallel Portal: Frozen Coast",
            music = { name = "MEGALOMANIA - LIVE A LIVE" }				
        },
        {						
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -10, y =  9730, z = 10, yaw = 0x8000 },
            flagBase = true,
            speed = 1.75,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_RAINBOW,	
            startPos = { x = 680, y = 120, z = -12780, yaw = -0x4000, airborne = true },	
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },			
            floodScale = 2,
            launchpads = {
                { x = -4995, y = 8910, z = -9830, yaw = 0x1000, vel = 100, forwardVel = 80 },
            },			
            music = { name = "FREEDOM DiVE - BMS (MAXBEAT)" }			
        },
        {						
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 6595, y = 8350, z = -5240, yaw = -0x4000 },
            flagBase = true,
            speed = 3.25,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_RAINBOW,	
            startPos = { x = -1405, y = -3210, z = 3790, yaw =  0x0000, airborne = true },	
            floodScale = 1.5,
            music = { name = "gentle stress (SENSUAL MIX) - Dance Dance Revolution 3rd Mix" }	
        },
        {		
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 15150, y = 7680, z = 0, yaw = 0x0000 },
            speed = 4.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,
            startPos = { x = 0, y = 1075, z = 5, yaw =  0x0000, airborne = true },				
            overrideName = "Park Of The Parallel World",
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Easy Mode	- Puyo Puyo SUN (Nintendo 64)" }				
        },
        {	
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 0, y = 5500, z = 11345, yaw = 0x8000 },
            speed = 1.5,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_WATER,	
            startPos = { x = -11720, y = 410, z = 270, yaw = 0x6000, airborne = true },
            overrideName = "City Of The Parallel World",
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            floodHeight = -2500,
            music = { name = "Dreamy Land (Level 1) - コメットサマナー / Comet Summoner)" }				
        },
        {
            name = "ending",
            level = LEVEL_ENDING,
            area = 6,
            flagPos = { x = 16430, y = 3061, z = 778, yaw = -0x4000 },
            flagBase = true,
            speed = 1.0,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_RAINBOW,	
            startPos = { x = 954, y = -4593, z = -8370, yaw = -0x4000, airborne = true },
            overrideName = "...HELL (Nerfed)", 
            floodHeight = -8100,
            floodScale = 2.5,		
            launchpads = {
                { x = -13870, y = -5292, z = -8387, yaw = -0x4000, vel = 100, forwardVel = 150 },
                { x = -26678, y = -5738, z = -11281, yaw = 0x0000, vel = 125, forwardVel = 0 },
                { x = -24552, y = -6099, z = -1421, yaw = 0x0000, vel = 300, forwardVel = 0 },
                { x = -22947, y = -2648, z = -1271, yaw = 0x0000, vel = 100, forwardVel = 0 },
                { x = -20559, y = -2641, z = -659, yaw = 0x0000, vel = 130, forwardVel = 0 },
                { x = -26579, y = -5553, z = -3484, yaw = 0x0000, vel = 75, forwardVel = 0 },
            },				
            music = { name = "無断転載" },					
            bonus = true
        },
        {
            name = "ending",
            level = LEVEL_ENDING,
            area = 6,
            flagPos = { x = 16430, y = 3061, z = 778, yaw = -0x4000 },
            flagBase = true,
            speed = 0.75,
            author = "Mese_Insanity & Rambi_Rampage",
            type = FLOOD_RAINBOW,
            startPos = { x = 750, y = -5075, z = -752, yaw = 0x8000, airborne = true },			
            floodHeight = -8100,
            floodScale = 2.5,
            overrideName = "...HELL", 			
            music = { name = "無断転載" },					
            bonus = true			
        }
    }
end

-- SM64 Sapphire, ported to Flood by Jzzay
local function flood_load_super_mario_64_sapphire_levels()
    game = GAME_SM64_SAPPHIRE
    romhackInfo = "Super Mario 64 Sapphire"
	romhackLogo = get_texture_info("logo_sm64sapphire")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 0, y = 0, z = 650, yaw = 0x6000}
        },
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -3644, y = 2726, z = -8620, yaw =  0x0000 },
            flagBase = false,
            speed = 2.8,
            author = "Nebula",
            type = FLOOD_WATER,
            startPos = { x = 5981,  y = 518, z = -6352, yaw = -0x4000 },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvFloorSwitchGrills }
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -3384, y = 201, z = -12561, yaw =  0x0000 },
            flagBase = false,
            speed = 3.5,
            author = "Nebula",
            type = FLOOD_MUD,
            startPos = { x = -3443,  y = -4007, z = -12243, yaw = -0x0500 },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvFloorSwitchGrills, id_bhvChainChomp, id_bhvPiranhaPlant, id_bhvFirePiranhaPlant, id_bhvRedCoin, id_bhvExclamationBox },
            overrideName = "Maple Cave"
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -12101, y = 3790, z = 9712, yaw =  0x6000 },
            flagBase = false,
            speed = 3.0,
            author = "Nebula",
            type = FLOOD_SNOW,
            startPos = { x = 605,  y = 1011, z = 3785, yaw = -0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvPenguinBaby }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -4265, y = 2850, z = -5652, yaw =  0x8000 },
            flagBase = false,
            speed = 3.0,
            author = "Nebula",
            type = FLOOD_WATER,
            startPos = { x = 54,  y = -233, z = -16913, yaw = -0x1000 },
            floodScale = 3
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 7290, y = 2301, z = -13768, yaw =  0x2500 },
            flagBase = false,
            speed = 2.0,
            author = "Nebula",
            type = FLOOD_LAVA,
            startPos = { x = 13608,  y = 259, z = -192, yaw = 0x8000 },
            floodScale = 3
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -131, y = 5874, z = 639, yaw =  0x7000 },
            flagBase = false,
            speed = 4.2,
            author = "Nebula",
            type = FLOOD_WATER,
            startPos = { x = -24429, y = -3026, z = -7322, yaw = 0x0000 },
            floodScale = 4
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 6356,  y = 7301, z = -4675, yaw =  0x8000 },
            flagBase = false,
            speed = 5.7,
            author = "Nebula",
            type = FLOOD_WATER,
            floodScale = 2,
            overrideWater = true
        },
    }
end

-- SM64 The Mushroom Cup, ported to Flood by Jzzay
local function flood_load_the_mushroom_cup_levels()
    game = GAME_THE_MUSHROOM_CUP
    romhackInfo = "Super Mario 64: The Mushroom Cup"
	romhackLogo = get_texture_info("logo_tmc")	
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 8, y = 28, z = -68, yaw = 0x6000}
        },
        [2] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 878, y = 4891, z = 886, yaw = 0x8200}
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 14074, y = 7823, z = -5880, yaw = 0x4000}
        },
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -6550, y = 699, z = -5113, yaw = 0x3000 },
            flagBase = false,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -10581, y = -3156, z = 10493, yaw = 0x5500 },
            floodScale = 1.5,
            overrideName = "Piranha Plant Marsh",
            overrideWater = true
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -4396, y = 4136, z = 749, yaw = 0x4000 },
            flagBase = false,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 8048, y = -477, z = 1525, yaw = -0x4000 },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 7448, y = 6463, z = -4953, yaw = -0x4000 },
            flagBase = false,
            speed = 1.4,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -11125, y = 783, z = 1848, yaw = 0x4000 },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 4469, y = 7788, z = -5233, yaw = 0x6000 },
            flagBase = false,
            speed = 3.8,
            author = "Usernamesarespiders",
            type = FLOOD_LAVA,
            startPos = { x = 543, y = -3563, z = 10885, yaw = 0x8000 },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvStar },
            overrideSlide = true
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -1795, y = 752, z = -12461, yaw = 0x8000 },
            flagBase = false,
            speed = 1.2,
            author = "Usernamesarespiders",
            type = FLOOD_POISON,
            startPos = { x = -6987, y = -1813, z = -6486, yaw = 0x8000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 7448, y = 5580, z = -6370, yaw = 0x7000 },
            flagBase = false,
            speed = 2.9,
            author = "Usernamesarespiders",
            type = FLOOD_SUNSET,
            startPos = { x = -11748, y = -2441, z = 6347, yaw = 0x6000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -1655, y = 4234, z = -10287, yaw = 0x2000 },
            flagBase = false,
            speed = 2.25,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -6222, y = -2172, z = 6578, yaw = 0x6000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 5419, y = 7248, z = 13687, yaw = 0x9999 },
            flagBase = false,
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_CLOUDS,
            startPos = { x = -928, y = -496, z = -1182, yaw = 0x1850 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 5297, y = 6808, z = 11299, yaw = -0x5500 },
            flagBase = false,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_SUNSET,
            startPos = { x = -1611, y = -1344, z = -10913, yaw = 0x0000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 474, y = 12686, z = -2174, yaw = 0x0000 },
            flagBase = false,
            speed = 3.5,
            author = "Usernamesarespiders",
            type = FLOOD_LAVA,
            startPos = { x = -1496, y = 61, z = -1953, yaw = 0x2000 },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cotmc2",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 104, y = -1380, z = -7, yaw = 0x0000 },
            flagBase = false,
            speed = 3.1,
            author = "Usernamesarespiders",
            type = FLOOD_WASTE,
            startPos = { x = 1330, y = -4873, z = 476, yaw = -0x2000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Sewer Depths"
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -16337, y = 3175, z = 1479, yaw = 0x4000 },
            flagBase = false,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_LAVA,
            startPos = { x = -552, y = -756, z = -2270, yaw = 0x0000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 3807, y = 3981, z = -2606, yaw = 0x0000 },
            flagBase = false,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_FROSTBITE,
            startPos = { x = -2673, y = -2427, z = -1536, yaw = 0x0000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -700, y = 5253, z = -1640, yaw = -0x1500 },
            flagBase = false,
            speed = 4.1,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -1630, y = -6868, z = -5066, yaw = -0x9000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 6171, y = 2556, z = -1833, yaw = -0x4000 },
            flagBase = false,
            speed = 1.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -6418, y = 540, z = -1584, yaw = 0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitfs2",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -5738, y = 5596, z = -11791, yaw = -0x2000 },
            flagBase = false,
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -5269, y = 1186, z = -13071, yaw = -0x1000 },
            floodScale = 2,
            unwantedBhvs = nil,
            overrideName = "Cloudy Construction Tower"
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -2817, y = -5321, z = -460, yaw = 0x2500 },
            flagBase = false,
            speed = 1.15,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 2502, y = -6404, z = 108, yaw = -0x4000 },
            floodScale = nil,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -6245, y = 4304, z = 3380, yaw = 0x4000 },
            flagBase = false,
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_CLOUDS,
            startPos = { x = -16526, y = -1978, z = -18283, yaw = 0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 6645, y = 8714, z = 2610, yaw = 0x2000 },
            flagBase = false,
            speed = 1.4,
            author = "Usernamesarespiders",
            type = FLOOD_MOLTEN,
            startPos = { x = -10041, y = -452, z = 2544, yaw = 0x5000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -4834, y = 5763, z = -4475, yaw = 0x4500 },
            flagBase = false,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_POISON,
            startPos = { x = -5899, y = -1895, z = -480, yaw = 0x0400 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 2991, y = 6358, z = -1320, yaw = 0x8000 },
            flagBase = false,
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_FROSTBITE,
            startPos = { x = -1144, y = -6086, z = 8923, yaw = 0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -1386, y = 3671, z = -458, yaw = -0x3000 },
            flagBase = false,
            speed = 3.5,
            author = "Usernamesarespiders",
            type = FLOOD_RAINBOW,
            startPos = { x = -1821, y = -8077, z = -80, yaw = 0x2500 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -4316, y = 4621, z = -7482, yaw = -0x2000 },
            flagBase = false,
            speed = 3.05,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -9104, y = -1746, z = 2202, yaw = 0x1000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 3521, y = 3833, z = -1622, yaw = 0x8000 },
            flagBase = false,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 2323, y = 596, z = 4688, yaw = 0x8400 },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 1962, y = 16635, z = -3077, yaw = 0x8000 },
            flagBase = false,
            speed = 2.3,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 24, y = 436, z = 162, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 2607, y = 1587, z = -8461, yaw = 0x0000 },
            flagBase = false,
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 13046, y = -1901, z = 6460, yaw = -0x5900 },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox }
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 912, y = 1830, z = 5076, yaw = 0x8000 },
            flagBase = false,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_SNOW,
            startPos = { x = -3971, y = 323, z = -4966, yaw = -0x6900, airborne = false },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Snowy Fate"
        },
    }
end

-- Some Kind of a Crash Game, ported to Flood by Bear64DX, Jzzay & ★~¡TOÑO!~★
local function flood_load_some_kind_of_a_crash_game_levels()
    game = GAME_SOME_KIND_OF_A_CRASH_GAME
    romhackLogo = get_texture_info("logo_skoacg")
    romhackInfo = "Some Kind of a Crash Game"	
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 0, y = -12, z = 0, yaw = 0x6000},
            music = { name = "Warp Room - Crash Bandicoot 3: Warped" }
        },
        [2] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = 49, y = -390, z = 1375, yaw = 0x8000},
            deathHeight = -980,
            music = { name = "Koopa Kid Battle - Super Mario World" }
        },
        [3] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = -940, y = 35, z = 0, yaw = -0x4000},
            deathHeight = -2000,
            music = { name = "The Evil King Bowser - Super Mario World" }					
        },
        [4] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = 6157, y = 7506, z = -2132, yaw = 0x8000},
            music = { name = "Mayahem Temple - Banjo-Tooie" }
        },
        [5] = {
            level = LEVEL_LLL,
            area = 1,
            spawn = {x = 0, y = 7429, z = -1926, yaw = 0x8000},
            deathHeight = 7040,
            music = { name = "Mad Monster Mansion - Banjo-Kazooie" }		
        },
        [6] = {
            level = LEVEL_SL,
            area = 1,
            spawn = {x = -1815, y = -2996, z = -3475, yaw = 0x8000},
            music = { name = "Dry Dry Ruins Quest - Paper Mario" },
            pipes = {
                {
                    { x = -1825, y = -4604, z = -4040, yaw = 0x8000 },				
                    { x = -1825, y = -2996, z = -3235, yaw = 0x8000 }							
                },
            },			
        },
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x =  3263,  y = 3906,  z = -11455, yaw =  0x0000},
            flagBase = true,
            speed = 3.4,
            author = "LinCrash",
            type = FLOOD_TIDE,
            floodScale = 3.0,
            floodHeight = -1123,
            act = 4,
            music = { name = "Ghost - Mario Clash" }
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -1315, y =  2205, z = 11080, yaw = 0x4000 },
            flagBase = true,
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_TIDE,
            startPos = { x = 895, y = 0, z = -701, yaw = 0x0000 },			
            floodScale = 3.0,
            unwantedBhvs = { id_bhvExclamationBox },			
            overrideName = "Across The Cliffside",
            floodHeight = -1728,
            music = { name = "Ghost - Mario Clash" }
        },
        {
            name = "bob3",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -560, y =  5690, z = -17100, yaw = -0x4000 },
            flagBase = true,
            speed = 3.75,
            author = "LinCrash",
            type = FLOOD_TIDE,
            startPos = { x = -790, y = 3153, z = -15045, yaw = -0x2000 },			
            floodScale = 3.0, 
            overrideName = "Climb The Pillars",
            floodHeight = 2032,
            music = { name = "Ghost - Mario Clash" }			
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x =  7635,  y = 4118,  z = -4232, yaw =  0x4000 },
            flagBase = true,
            speed = 2.6,
            author = "LinCrash",
            type = FLOOD_WATER,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },			
            floodHeight = -1216,
            music = { name = "Koopa Village - Paper Mario" }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x =  -4802,  y = 10925,  z = -82, yaw =  0x0000 },
            flagBase = true,
            speed = 9.0,
            author = "LinCrash",
            type = FLOOD_CLOUDS,
            startPos = { x = -4784, y = -5333, z = 3799, yaw = 0x8000, airborne = false, spin = false },
            floodScale = 2.5,
            floodHeight = -8375,
            overrideSlide = true,
            music = { name = "Grand Canyon - Mickey\'s Speedway USA" }			
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -8559, y = 2316, z = -292, yaw = 0x4000 },
            speed = 3.0,
            author = "LinCrash",
            type = FLOOD_WATER,
            startPos = { x = -7127, y = 517, z = 7726, yaw = 0x7000 },
            floodScale = 3,
            overrideWater = true,
            music = { name = "Oho Ocean - Mario & Luigi: Superstar Saga" }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -1165, y = 6118, z = 0, yaw = -0x4000 },
            speed = 4.5,
            author = "LinCrash",
            type = FLOOD_CLOUDS,
            floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvMessagePanel, id_bhvDoorWarp },
            floodHeight = -9435,
            launchpads = {
                { x = 0, y = 2108, z = 0, yaw = -0x4000, vel = 100, forwardVel = 50 },
                { x = -9110, y = 1914, z = 0, yaw = 0x4000, vel = 100, forwardVel = 130 },				
            },			
            pipes = {
                {
                    { x = 805, y = -2954, z = 1385 },
                    { x = -1200, y = -2954, z = -2090, yaw = 5520 }
                },
                {		
                    { x = -780, y = -2954, z = -1360 },
                    { x = -780, y = -134, z = 1375, yaw = -5705 },
                },
            },			
            music = { name = "Cloudy Climb - Paper Mario" }					
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 1728, y = 6509, z = 11730, yaw = 0x9999 },
            speed = 2.4,
            author = "LinCrash",
            type = FLOOD_ACID,
            startPos = { x = -3027, y = 4249, z = -1574, yaw = 0x6000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },			
            floodHeight = 1940,
            music = { name = "Mad Monster Mansion - Banjo-Kazooie" }
        },
        {
            name = "lll2",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 1065, y = -3053, z = -1100, yaw = -0x4000 },
            speed = 1.85,
            author = "LinCrash",
            type = FLOOD_DARKNESS,
            startPos = { x = -71, y = -7807, z = 5941, yaw = 0x8000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvPushableMetalBox },					
            overrideName = "Manor Of Boonsteria",
            launchpads = {
                { x = -60, y = -5320, z = 2400, yaw = 0x8000, vel = 70, forwardVel = 0 },
            },
            music = { name = "Mad Monster Mansion - Banjo-Kazooie" }			
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -3040, y = 7225, z = -5140, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "LinCrash",
            type = FLOOD_DARKNESS,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvChuckya },
            floodHeight = -4901,
            music = { name = "Fortress - Super Mario Bros. 3" }
        },
        {
            name = "vcutm2",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x =  -8920,  y = 4360,  z = -7856, yaw =  0x4000 },
            flagBase = true,
            speed = 1.65,
            author = "LinCrash",
            type = FLOOD_DARKNESS,
            startPos = { x = 9732, y = 3472, z = 4299, yaw = 0x0000, spin = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvFloorSwitchHiddenObjects, id_bhvFlamethrower },
            overrideName = "Tower Basement Entrance",
            floodHeight = 1401,
            music = { name = "Fortress - Super Mario Bros. 3" }			
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -40, y = 11200, z =   6565, yaw =  0x6000 },
            flagBase = true,
            speed = 2.8,
            author = "LinCrash",
            type = FLOOD_FROSTBITE,
            startPos = { x = -693, y = 4231, z = -4337, yaw = 0x5500 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            music = { name = "Ice Mountain Zone Act 1 - Sonic Advance" }
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -655, y = 1471, z = 7535, yaw = 0x8000 },
            flagBase = true,
            speed = 6.0,
            author = "LinCrash",
            type = FLOOD_FROSTBITE,
            startPos = { x = -5432, y = -5775, z = -6047, yaw = 0x0000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },			
            overrideName = "Super Snow Slider",
            launchpads = {
                { x = -2360, y = -3185, z = 1080, yaw = -0x4000, vel = 100, forwardVel = 0 },
                { x = -5970, y = -720, z = 4380, yaw = 0x4000, vel = 100, forwardVel = 0 },				
            },			
            overrideSlide = true,
            music = { name = "Ice Mountain Zone Act 1 - Sonic Advance" }		
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 6891, y = 5767, z = -7386, yaw = -0x0500 },
            speed = 2.25,
            author = "LinCrash",
            type = FLOOD_SAND,
            startPos = { x = 2551, y = 5300, z = -1331, yaw = 0x8000, spin = false },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvPushableMetalBox },
            floodHeight = 2750,
            music = { name = "Mayahem Temple - Banjo-Tooie" }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 5000, y = 3390, z = -5740, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "LinCrash",
            type = FLOOD_MOLTEN,
            floodScale = 2.5,
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = 1500,
            music = { name = "Dry Dry Ruins Quest - Paper Mario" }			
        },
        {
            name = "sl2",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 4944, y = 314, z = -775, yaw = 0x0000 },
            speed = 2.5,
            author = "LinCrash",
            type = FLOOD_MOLTEN,
            startPos = { x = 6933, y = -4284, z = -475, yaw = -0x4000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Lavakoopa Risky Construction",
            music = { name = "Dry Dry Ruins Quest - Paper Mario" }
        },
        {
            name = "sl3",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 6053, y = -2128, z = -7937, yaw = -0x2000 },
            speed = 1.2,
            author = "LinCrash",
            type = FLOOD_MOLTEN,
            startPos = { x = 2366, y = -2626, z = -4519, yaw = 0x6000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Lavakoopa Pole Perfomance",
            music = { name = "Dry Dry Ruins Quest - Paper Mario" }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x =  -16,  y = -76,  z = 4390, yaw =  0x8000 },
            flagBase = true,
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_LAVA,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -6168,
        },
        {
            name = "cotmc2",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 1550,  y = 1461, z = 15115, yaw = -0x4000 },
            flagBase = true,
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_LAVA,
            startPos = { x = -870, y = -3987, z = 7060, yaw = 0x4000, spin = false},
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvRedCoin },
            overrideName = "Iron'hellish Climb",
            music = { name = "Barrel Volcano - Super Mario RPG" }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -1466, y = 7300, z = -912, yaw = -0x4000 },
            speed = 3.3,
            author = "LinCrash",
            type = FLOOD_MUD,
            floodScale = 2.5,
            floodHeight = -136,
            music = { name = "Chrome Gadget - Sonic the Hedgehog 3" }
        },
        {

            name = "ttm2",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 4439, y = -879, z = 5076, yaw = -0x6000 },
            flagBase = true,
            speed = 3.6,
            author = "LinCrash",
            type = FLOOD_MUD,
            startPos = { x = -1390, y = -3619, z = -961, yaw = 0x0000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Inverted Fortress",
            floodHeight = -5268,
            music = { name = "Chrome Gadget - Sonic the Hedgehog 3" }	
        },
        {
            name = "b2",
            level = LEVEL_BOWSER_2,
            area = 1,
            flagPos = { x =  -2198,  y = 35,  z = 1, yaw =  0x4000 }, 
            flagBase = true,
            speed = 5.5,
            author = "LinCrash",
            type = FLOOD_MAGMA,
            floodScale = 2.0,
            overrideName = "Crash Showdown",
            floodHeight = -2429,
            music = { name = "The Evil King Bowser - Super Mario World" }
        },
    }
end

-- Katze Stuck in the Toilet 64, ported to Flood by ★~¡TOÑO!~★
local function flood_load_katze_stuck_in_the_toilet_levels()
    game = GAME_KATZE_STUCK_IN_THE_TOILET
    romhackInfo = "Katze Stuck in the Toilet 64"
    romhackLogo = get_texture_info("logo_ksitt64")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -150, y = 675, z = -7400, yaw = 0x1000},
            music = { name = "Sand Canyon 1 - Kirby's Dream Land 3" }			
        },
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -315, y = 0, z = 55, yaw = -0x4000},
            music = { name = "Inside the Castle - Mario Party 3" },			
         },
         [3] = {
            level = LEVEL_WF,
            area = 1,
            spawn = {x = 45, y = -872, z = 0, yaw = 0x4000},
            music = { name = "Drenched Bluff - Pokemon Mystery Dungeon: Explorers of Time/Darkness/Sky" }			
         },
         [4] = {
            level = LEVEL_WF,
            area = 2,
            spawn = {x = -5, y = -3024, z = 2425, yaw = 0x8000},
            music = { name = "Inside the Castle - Mario Party 3" },			
            pipes = {
                {
                    { x = -960, y = -3024, z = -190, yaw = 0x4000 },
                    { x = -7930, y = 0, z = -2015, yaw = 0x0000 }
                },
                {
                    { x = -960, y = -3024, z = -1160, yaw = 0x4000 },
                    { x = 5760, y = 0, z = -1960, yaw = 0x0000 }
                },
                {
                    { x = 960, y = -3024, z = -190, yaw = -0x4000 },
                    { x = 5760, y = 8021, z = -1960, yaw = 0x0000 }
                },
                {
                    { x = 960, y = -3024, z = -1160, yaw = -0x4000 },
                    { x = -7930, y = 8021, z = -5230, yaw = 0x0000 }
                }
            }
        },
        [5] = {
            level = LEVEL_BITFS,
            area = 1,
            spawn = {x = 3250, y = 2148, z = -870, yaw = 0x2000},
            deathHeight = 1950,
            music = { name = "Showtime! - Mario & Luigi: Bowser's Inside Story" }			
        },
        [6] = {
            level = LEVEL_CCM,
            area = 3,
            spawn = {x = 0, y = 0, z = 205, yaw = 0x0000},
            music = { name = "Drenched Bluff - Pokemon Mystery Dungeon: Explorers of Time/Darkness/Sky" }			
        }
    }
	
    gLevels = {
        {					
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -755, y = 4695,  z = 4630, yaw = -0x4000 },
            speed = 3.0,
            author = "Tomatobird8",
            type = FLOOD_WATER,
            floodScale = 1.5,
            unwantedBhvs = { id_bhvExclamationBox },			
            overrideName = "McDonald's World War",
            music = { name = "Butter Building - Kirby: Nightmare in Dream Land" }			
        },
        {						
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 5, y = 6255, z = -5, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Tomatobird8",
            type = FLOOD_SAND,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -1000,
            launchpads = {
                { x = -2000, y = 2519, z = 8275, yaw = 0x8000, vel = 200, forwardVel = 120 },
                { x = -5515, y = 2336, z = -7660, yaw = 0x2000, vel = 150, forwardVel = 120 }
            },
            capTimer = 0,
            music = { name = "Desert Overworld - New Super Mario Bros." }
        },
        {						
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -2465, y = 7405,  z = 5720, yaw = 0x8000 },
            flagBase = true,
            speed = 4.75,
            author = "Tomatobird8",
            type = FLOOD_WATER,			
            startPos = { x = 2565, y = 6892, z = 5720, yaw = 0x8000, airborne = true },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvKoopa },			
            floodHeight = 865,
            capTimer = 1,
            launchpads = {
                { x = -2465, y = 6949, z = 2900, yaw = 32701, vel = 80, forwardVel = 0 },
                { x = -2465, y = 6045, z = -4555, yaw = 32701, vel = 100, forwardVel = 0 },
                { x = -2465, y = 5770, z = -8380, yaw = 32701, vel = 75, forwardVel = 0 },		
            },
            music = { name = "Yogurt Yard - Kirby's Adventure" }
        },
        {						
            name = "wf",
            level = LEVEL_WF,
            area = 2,
            flagPos = { x = 11611, y = -196,  z = -1523, yaw = -0x4000 },
            speed = 2.0,
            author = "Tomatobird8",
            type = FLOOD_BUP,
            startPos = { x = 6700, y = 0, z = -1534, yaw = 0x4000, airborne = true },
            floodScale = 1.5,
            music = { name = "Inside the Castle - Mario Party 3" },
            blocks = {
                { x = 6200, y = 0, z = -1520, yaw = 0x0000 },
                { x = 6200, y = 307, z = -1520, yaw = 0x0000 }					
            },			
        },
        {						
            name = "wf2",
            level = LEVEL_WF,
            area = 3,
            flagPos = { x = 912, y = 3735, z = -1566, yaw = -5090 },
            flagBase = true,
            speed = 4.0,
            author = "Tomatobird8",
            type = FLOOD_MUD,		
            overrideName = "Treasure Of The World",
            music = { name = "THE SAFARI - Beatmania IIDX - 3rd Style" }			
        },
        {						
            name = "wf3",
            level = LEVEL_WF,
            area = 5,
            flagPos = { x = 2180,   y = 2230,  z = 420, yaw =  0x8000 },
            flagBase = true,
            speed = 5.5,
            author = "Tomatobird8",
            type = FLOOD_WATER,		
            overrideName = "Burger Revenge 5: Neo Blue Adventure",
            music = { name = "Forest Overworld - New Super Mario Bros. Wii" }			
        },
        {						
            name = "wf4",
            level = LEVEL_WF,
            area = 4,
            flagPos = { x = -5303, y = 3237, z = 4430, yaw = 0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Tomatobird8",
            type = FLOOD_WATER,		
            overrideName = "Break Into The Quarantine",
            floodHeight = -2750,
            music = { name = "Bob-Omb Battlefield (File Select Mix) - Super Mario 64" }
        },
        {						
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -3648, y = 5830, z = 4987, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Tomatobird8",
            type = FLOOD_WATER,		
            floodHeight = -950,
            act = 1,
            blockScale = 3,
            blocks = {
                { x = -350, y = 3685, z = 2520, yaw = 0x0000 },
                { x = -350, y = 4606, z = 2520, yaw = 0x0000 },
                { x = 575, y = 3685, z = 2520, yaw = 0x0000 },
                { x = 575, y = 4606, z = 2520, yaw = 0x0000 },
                { x = 1500, y = 3685, z = 2520, yaw = 0x0000 },
                { x = 1500, y = 4606, z = 2520, yaw = 0x0000 }			
            },
            music = { name = "Grass Land - Yoshi's Safari" }			
        },
        {						
            name = "jrb2",
            level = LEVEL_JRB,
            area = 2,
            flagPos = { x = -1090, y = 3760, z = 2590, yaw = 0x8000 },
            speed = 4.0,
            author = "Tomatobird8",
            type = FLOOD_WATER,
            overrideName = "A Flight In The Tool Shed",			
            unwantedBhvs = { id_bhvExclamationBox },	
            powerUp	= "wing",
            music = { name = "Warp Pipe Room - Super Mario Galaxy 2" }			
        },
        {						
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -458, y = 2215, z = 531, yaw = -0x4000 },
            speed = 3.0,
            author = "Tomatobird8",
            type = FLOOD_WATER,		
            startPos = { x = 2500, y = -1133, z = 2550, yaw = 0x0000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Oil Ocean Zone - Sonic The Hedgehog 2" }
        },
        {						
            name = "ccm2",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = 10, y = 2370, z = -1250, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "Tomatobird8",
            type = FLOOD_WATER,
            startPos = { x = 1260, y = 160, z = 4295, yaw = -0x6000, airborne = false, pipe = true },			
            unwantedBhvs = { id_bhvWarpPipe },	
            overrideName = "Pickle Source",
            music = { name = "Beware the Forest's Mushrooms - Super Mario RPG: Legend of the Seven Stars" }			
        },
        {						
            name = "ccm3",
            level = LEVEL_CCM,
            area = 3,
            flagPos = { x = 3620, y = 830, z = 6620, yaw = -0x6000 },
            flagBase = true,
            speed = 5.5,
            author = "Tomatobird8",
            type = FLOOD_WATER,	
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Go Take A Walk Outside",
            music = { name = "Drenched Bluff - Pokemon Mystery Dungeon: Explorers of Time/Darkness/Sky" }
        },
        {						
            name = "ccm4",
            level = LEVEL_CCM,
            area = 4,
            flagPos = { x = -1565, y = 2245, z = -2890, yaw = 0x0000 },
            flagBase = true,
            speed = 3.5,
            author = "Tomatobird8",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Control Room Flight",
            capTimer = 900,
            powerUp = "wing",
            music = { name = "Oil Ocean Zone - Sonic The Hedgehog 2" }		
        },
        {						
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 1870, y = 2850,  z = -2357, yaw = 0x0000 },
            speed = 2.5,
            author = "Tomatobird8",
            type = FLOOD_WATER,
            floodScale = 1.5,
            music = { name = "Lon Lon Ranch - The Legend of Zelda: Ocarina of Time" }
        },
        {						
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 1503,  y = 3241,  z = -6446, yaw = -0x4000 },
            speed = 3.0,
            author = "Tomatobird8",
            type = FLOOD_WATER,			
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Gruntilda's Room - Banjo-Kazooie" }			
        },
        {						
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 4556,  y = 2114,  z = -43, yaw = -0x4000 },	
            speed = 2.5,
            author = "Tomatobird8",
            type = FLOOD_MOLTEN,
            unwantedBhvs = { id_bhvWhompKingBoss },	
            floodHeight = -1850,
            music = { name = "Showtime! - Mario & Luigi: Bowser's Inside Story" }
        },
        {						
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -4165, y = 4039, z = 5469, yaw = 0x8000 },
            flagBase = true,
            speed = 5.75,
            author = "Tomatobird8",
            type = FLOOD_WATER,
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Real World",
            music = { name = "Sand Canyon 1 - Kirby's Dream Land 3" }
         }
    }
end

-- Lug's Delightful Dioramas, ported to Flood by ~TONO~!
local function flood_load_lugs_delightful_dioramas_levels()
    game = GAME_LUGS_DELIGHTFUL_DIORAMAS
    romhackInfo = "Lug's Delightful Dioramas"
	romhackLogo = get_texture_info("logo_ldd")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -200, y = 65, z = -990, yaw = 0x0000}
		},
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 90, y = 120, z = -1575, yaw = 0x0000}	
		},
        [3] = {
            level = LEVEL_CASTLE,
            area = 2,
            spawn = {x = 425, y = 0, z = -1050, yaw = 0x0000}	
		},
        [4] = {
            level = LEVEL_BITS,
            area = 1,
            spawn = {x = 0, y = 0, z = -1295, yaw = 0x0000}				
        }
    }
	
    gLevels = {
        {	
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -870,  y = 3845, z = 1050,  yaw = 0x2000 },
            speed = 4.0,
            author = "Lugmillord",
            type = FLOOD_SNOW,		
        },
        {						
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 530,  y = 5100, z = 0,  yaw =  0x4000 },
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_SAND,		
            startPos = { x = -1980, y = -2000,  z = 160, yaw = -0x4000, airborne = true },						
        },
        {						
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -80,  y = 5480,  z =  2380,  yaw =  -0x4000 },
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_RAINBOW,	
        },
        {						
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -450,  y = 4405,  z = -670,  yaw = 0x8000 },
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_WATER,		
            startPos = { x = -2565, y = -490,  z = -1060, yaw = -0x4000, airborne = false },		
            capTimer = 1,				
        },
        {						
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -575,  y = 4270,  z = 2880,  yaw = 0x4000 },
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_WATER,		
			floodHeight = 1800,
			act = 5,
            unwantedBhvs = { id_bhvWarpPipe },		
        },
        {						
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -40,  y = 2550,  z = -5,  yaw = -0x4000 },
			flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_WATER,		
            startPos = { x = -4150, y = -815,  z = -790, yaw = -0x4000, airborne = true },				
        },
        {						
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -1800,  y = 3625,  z = 450, yaw = 0x4000 },
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_WATER,				
			
        },
        {						
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -885,  y = 5375,  z = 1010,  yaw =  0x8000 },
			flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_WATER,		
            startPos = { x = 0, y = 2415,  z = 35, yaw = -0x4000, airborne = true },	
            unwantedBhvs = { id_bhvWarpPipe },							
        },
        {						
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 1045,  y = 2705,  z = -165,   yaw = 0x0000 },
			flagBase = true,
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_WATER,		
        },
        {						
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -845,  y = 4720, z = 180, yaw =  0x8000 },
			flagBase = true,
            speed = 2.0,
            author = "Lugmillord",
            type = FLOOD_SAND,		
            startPos = { x = 2745, y = -1100, z = -1645, yaw = 0x4000, airborne = true },		
            unwantedBhvs = { id_bhvWarpPipe },
            launchpads = {
                { x = 3740, y = 1560, z = -1640, yaw = 32701, vel = 100, forwardVel = 0 },
            },			
        },
        {						
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 3525,  y = 1670,  z = 3625,  yaw =  0x8000 },
			flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_LAVA,		
            startPos = { x = -155, y = 300,  z = -2500, yaw = 0x0000, airborne = true },	
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {						
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 245, y = 4600, z = -2495,  yaw =  0x0000 },
			flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_POISON,		
            startPos = { x = -1060, y = -4300,  z = 1390, yaw = 0x4000, airborne = true },	
            unwantedBhvs = { id_bhvWarpPipe },				
        },
        {						
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -3380,  y = 5530, z = -3345, yaw =  0x2000 },
            speed = 4.5,
            author = "Lugmillord",
            type = FLOOD_POISON,	
        },
        {						
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -4940,   y = 17025,  z = 400,  yaw =  0x0000 },
			flagBase = true,
            speed = 2.5,
            author = "Lugmillord",
            type = FLOOD_WATER,		
            startPos = { x = -1595, y = 6505,  z = -1285, yaw = 0x0000 , airborne = true },			
        },
        {						
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -1290,  y = 1270, z = 870, yaw = 0x4000 },
            speed = 9.0,
            author = "Lugmillord",
            type = FLOOD_WATER,		
            unwantedBhvs = { id_bhvWarpPipe },			
			overrideName = "HUB 1",
        },
        {						
            name = "c",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 1500,  y = 2640, z = 2295,  yaw =  -0x4000 },
			flagBase = true,
            speed = 4.5,
            author = "Lugmillord",
            type = FLOOD_WATER,				
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },		
			overrideName = "HUB 2",			
        },
        {						
            name = "c2",
            level = LEVEL_CASTLE,
            area = 2,
            flagPos = { x = 1370, y = 1420, z = 1340, yaw = -0x4000 },
			flagBase = true,
            speed = 3.0,
            author = "Lugmillord",
            type = FLOOD_LAVA,		
            unwantedBhvs = { id_bhvWarpPipe },	
			overrideName = "HUB 3",			
        }
    }
end	

-- Super Luigi 64: The Flower Cup, ported to Flood by MarcoGamerOJ
local function flood_load_super_luigi_64_the_flower_cup_levels()
    game = GAME_SUPER_LUIGI_64_THE_FLOWER_CUP
    romhackInfo = "Super Luigi 64: The Flower Cup"
	romhackLogo = get_texture_info("logo_tfc")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 5010, y = 198, z = 10657, yaw = 0x8000},
            music = { name = "Toad Town - Paper Mario" },
        },
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 2,
            spawn = {x = 15, y = 0, z = 1620, yaw = 0x8000},
            music = { name = "Inside the Castle - Mario Party 3" },
        },
        [3] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 3,
            spawn = {x = 5010, y = 198, z = 10657, yaw = 0x8000},
            music = { name = "Lower Norfair - Super Metroid" },	 
        },
        [4] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 4,
            spawn = {x = 0, y = 110, z = 4015, yaw = 0x8000},
            music = { name = "??? - ???" },				
        },
        [5] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 4697, y = 302, z = 4436, yaw = -0x6000},
            music = { name = "In The Nightmare - Pokémon Mystery Dungeon: Explorers of Time / Darkness / Sky" },
        },
        [6] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -420, y = 2302, z = 312, yaw = 0x0000},
            music = { name = "Resonance - HOME" },
        },
        [7] = {
            level = LEVEL_CASTLE,
            area = 2,
            spawn = {x = 9, y = 0, z = 317, yaw = 0x0000},
            music = { name = "Resonance - HOME" },
        },
        [8] = {
            level = LEVEL_CASTLE,
            area = 3,
            spawn = {x = 0, y = 0, z = 301, yaw = 0x0000},
            music = { name = "Resonance - HOME" },
        },
        [9] = {
            level = LEVEL_CASTLE,
            area = 4,
            spawn = {x = 0, y = 0, z = 310, yaw = 0x0000},
            music = { name = "Resonance - HOME" },	
        },
        [10] = {
            level = LEVEL_BOWSER_3,
            area = 1,
            spawn = {x = 20, y = 0, z = 1650, yaw = 0x8000},
            music = { name = "Triage at Dawn - Half-Life 2" },					
        },
        [11] = {
            level = LEVEL_BOWSER_3,
            area = 2,
            spawn = {x = -15, y = 930, z = 5970, yaw = 0x8000},
            music = { name = "Triage at Dawn - Half-Life 2" },		
        },
        [12] = {
            level = LEVEL_BOWSER_3,
            area = 3,
            spawn = {x = -870, y = 1710, z = 335, yaw = 0x0000},
            music = { name = "Triage at Dawn - Half-Life 2" },			
        },
        [13] = {
            level = LEVEL_BOWSER_3,
            area = 4,
            spawn = {x = -410, y = 2715, z = 1400, yaw = 0x8000},
            music = { name = "Triage at Dawn - Half-Life 2" },	
        },
        [14] = {
            level = LEVEL_BOWSER_3,
            area = 5,
            spawn = {x = 0, y = 60, z = -6140, yaw = 0x0000},
            music = { name = "Triage at Dawn - Half-Life 2" },				
        },
        [15] = {
            level = LEVEL_BOWSER_3,
            area = 6,
            spawn = {x = 5010, y = 198, z = 10657, yaw = 0x8000},
            overrideWater = true,	
            music = { name = "Triage at Dawn - Half-Life 2" },		
        },
        [16] = {
            level = LEVEL_BOB,
            area = 2,
            spawn = {x = 914, y = 5674, z = -27, yaw = -0x4000},
            music = { name = "Northern Desert - PokémonMystery Dungeon: Explorers of Time / Darkness / Sky" },			
        },
        [17] = {
            level = LEVEL_BITDW,
            area = 3,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000},
            music = { name = "Through the Sea of Time - Pokemon Mystery Dungeon: Explorers of Time/Darkness/Sky" },			
        },
        [18] = {
            level = LEVEL_BITFS,
            area = 2,
            spawn = {x = 0, y = 0, z = 248, yaw = 0x0000},
            music = { name = "Fortress - New Super Mario Bros. Wii" },			
        },
        [19] = {
            level = LEVEL_HMC,
            area = 2,
            spawn = {x = 2765, y = 1752, z = 0, yaw = -0x4000},	
            music = { name = "??? - ???" },		
        },
        [20] = {
            level = LEVEL_THI,
            area = 3,
            spawn = {x = 4890, y = 1980, z = 5, yaw = -0x4000},	
            music = { name = "Flowing Lava - New Super Mario Bros." },		
        },
        [21] = {
            level = LEVEL_RR,
            area = 2,
            spawn = {x = 0, y = 4271, z = 0, yaw = 0x0000},
            music = { name = "De Mysteriis Dom Sathanas - Mayhem" },			
        },
        [22] = {
            level = LEVEL_SA,
            area = 3,
            spawn = {x = 171, y = 3039, z = 769, yaw = 0x0000},	
            music = { name = "??? - ???" },		
        },
    }

    gLevels = {
        {	
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -5635, y = 11111, z = -3333, yaw = 0x0000 },
	    flagBase = false,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,				
	    floodScale = 2,
            floodHeight = -1000,
            music = { name = "Overworld - Super Mario World 2: Yoshi's Island" },
        },
        {	
            name = "bob2",
            level = LEVEL_BOB,
            area = 3,
            flagPos = { x = -1818, y = 1099, z = -3600, yaw = 0x0000 },
	    flagBase = false,
            speed = 1.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,				
	    floodScale = 2,
	    overrideName = "Toxic Cave",
            floodHeight = -1000,
            music = { name = "Crystal Caves - Donkey Kong 64" },
        },
        {	
            name = "bob3",
            level = LEVEL_BOB,
            area = 4,
            flagPos = { x = -626, y = 6156, z = 178, yaw = 0x0000 },
	    flagBase = false,
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
            startPos = { x = 1500, y = 381, z = 0, yaw = -0x2000 },			
	    floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
	    overrideName = "Winter Cavern",
            music = { name = "The Sanctuary of Water and Ice - Rayman 2: The Great Escape" },
        },
        {						
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -9245, y = 7634, z = 1645, yaw = 0x0000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,		
	    floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -1000,
            pipes = {
                 {
                       { x = -3877, y = 1061, z = 1468, yaw = 0x4000 },
                       { x = -7866, y = 3471, z = 412,  yaw = 0x0000 },
                 }
            },	
            music = { name = "Haunted Woods - Diddy Kong Racing" },		
        },
        {						
            name = "wf2",
            level = LEVEL_WF,
            area = 4,
            flagPos = { x = 1946, y = 5398, z = 1357, yaw = 0x4000 },
	    flagBase = true,
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_MUD,
            unwantedBhvs = { id_bhvWarpPipe },
	    floodHeight = -3500,
	    overrideName = "Underground Cavern",
            music = { name = "Life in the Mines - Donkey Kong Country" },			
        },
        {						
            name = "wf3",
            level = LEVEL_WF,
            area = 2,
            flagPos = { x = -3367, y = 17380, z = 737, yaw = 0x8000 },
	    flagBase = true,
            speed = 7.0,
            author = "Usernamesarespiders",
            type = FLOOD_DARKNESS,	
            startPos = { x = -2525, y = -7462, z = 9878, yaw = 0x8000 },	
	    floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
	    overrideSlide = true,
	    overrideName = "Pyramid Slider",
            launchpads = {
                { x = 3415, y = 6885, z = -15815, yaw = 0x0000, vel = 130, forwardVel = 0 },
            },	
            music = { name = "Angry Aztec - Donkey Kong 64" },		
        },
        {						
            name = "wf4",
            level = LEVEL_WF,
            area = 3,
            flagPos = { x = 0, y = 3155, z = 255, yaw = 0x0000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
	    floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
	    overrideName = "Ruined Mansion",
            music = { name = "Hooktail's Castle - Paper Mario: The Thousand-Year Door" },
        },
        {						
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -3478, y = 6869, z = -9055, yaw = 0x8000 },
	    flagBase = true,
            speed = 4.0,
            author = "Usernamesarespiders",
            type = FLOOD_POISON,			
            startPos = { x =  6909, y = 1033, z = 10565, yaw = 0x8000 },	
	    floodScale = 2,	 
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            music = { name = "Underground - Super Mario World 2: Yoshi's Island" },			
        },
        {						
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -888, y = 2254, z = 11606, yaw = -0x4000 },
	    flagBase = true,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,		
	    floodScale = 3,
	    floodHeight = -1500,
            music = { name = "Bianco Hills - Super Mario Sunshine" },
        },
        {						
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 1365, y = 2027, z = -13265, yaw = 0x0000 },
	    flagBase = true,
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 4121, y = 869, z = -1555, yaw = 0x6000 },	
	    floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },
	    overrideName = "Valley Of The Rapids",
            music = { name = "Bianco Hills - Super Mario Sunshine" },
        },
        {						
            name = "ccm3",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 1955, y = 3683, z = -8115, yaw = 0x6000 },
	    flagBase = true,
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -1616, y = 614, z = -2525, yaw = 0x6000 },	
	    floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },
	    overrideName = "Large Tower In The Distance",
            music = { name = "Bianco Hills - Super Mario Sunshine" },
        },
        {						
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -6789, y = 11639, z = -3595, yaw = 0x6000 },
	    flagBase = true,
            speed = 4.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,					
            unwantedBhvs = { id_bhvWarpPipe },	
	    floodHeight = 5000,
            music = { name = "Horror Land - Mario Party 2" },				
        },
        {						
            name = "pss2",
            level = LEVEL_PSS,
            area = 3,
            flagPos = { x = -1125, y =  5830, z = -10270, yaw =  0x0000 },
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_DARKNESS,			
            startPos = { x = -8900, y = 3600, z = 7220, yaw = 0x6000 },				
	    floodScale = 2,
            overrideName = "Boo's Playplace",
            music = { name = "Woodfall Temple - The Legend of Zelda: Majora's Mask" },
        },
        {						
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 7220, y = 2865, z = -5195, yaw = 0x0000 },
	    flagBase = true,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_CLOUDS,
            startPos = { x = -12878, y = -556, z = -11785, yaw = 0x4000 },				
	    floodScale = 3,
	    floodHeight = -3500,
            music = { name = "Toad Highlands - Mario Golf 64" },
        },
        {						
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 9350, y = 12810, z = 12055, yaw = 0x8000 },
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_FROSTBITE,			
            floodScale = 3,			
            unwantedBhvs = { id_bhvWarpPipe },	
            music = { name = "Ice Forest - Super Ghouls 'N' Ghosts" },		
        },
        {						
            name = "bitdw2",
            level = LEVEL_BITDW,
            area = 2,
            flagPos = { x = 0, y = 3145, z = -16650, yaw = 0x4000 },
	    flagBase = true,
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_SNOW,
	    floodScale = 3,
	    overrideName = "Frozen 2D Forest",
            unwantedBhvs = { id_bhvWarpPipe },	
            music = { name = "A Snow Light - Tales of Symphonia" },		
        },
        {						
            name = "b1",
            level = LEVEL_BOWSER_1,
            area = 1,
            flagPos = { x = 5, y =  3295, z = 40, yaw =  0x4000  },
	    flagBase = true,
            speed = 3.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
	    floodScale = 2,
            unwantedBhvs = { id_bhvBowserKey },	
	    overrideName = "Frozen Quicksand Trap",
	    capTimer = 777,
	    powerUp = "metal",
            music = { name = "??? - ???" },
        },
        {						
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 2865, y = 7934, z = -969, yaw = 0x8000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,		
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },	
            act = 2,		
            music = { name = "Noki Bay - Super Mario Sunshine" },			
        },
        {						
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -4195, y = 9010, z = 3100, yaw = 0x8000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,		
            startPos = { x = -7385, y = 142, z = 0, yaw = 0x0000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
	    overrideName = "Climb The Mossy Coral",
            act = 1,	
            music = { name = "Noki Bay - Super Mario Sunshine" },					
        },
        {						
            name = "bbh3",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -6355, y = 11098, z = -6685, yaw = 0x4000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,		
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
	    overrideName = "The Marble Zone",	
            act = 3,
            music = { name = "Noki Bay - Super Mario Sunshine" },					
        },
        {						
            name = "bbh4",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 1919, y = 12039, z = -9933, yaw = 0x0000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,		
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
	    overrideName = "The Blue Bricked Cavern",
            act = 4,
            music = { name = "Noki Bay - Super Mario Sunshine" },						
        },
        {						
            name = "bbh5",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -500, y = 16775, z = -6868, yaw = -0x6000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,		
            startPos = { x = 666, y = 1116, z = -1065, yaw = 0x1000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
	    overrideName = "The Tippity Top",
            music = { name = "Noki Bay - Super Mario Sunshine" },					
        },
        {						
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -4395, y = 8570, z = 720, yaw = 0x8000 },
	    flagBase = true,
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_MUD,		
            floodHeight = 1500,			
            unwantedBhvs = { id_bhvExclamationBox },
	    capTimer = 1500,
	    powerUp = "vanish",	
            music = { name = "Greenhorn Forest - Wario World" },		
        },
        {						
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 4185, y = 8489, z = -8855, yaw =  0x0000 },
	    flagBase = false,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_MAGMA,	
	    floodScale = 3,
            floodHeight = -2500,	
            launchpads = {
                { x = -7532, y = -316, z = -8059, yaw = 0x0000, vel = 150, forwardVel = 0 },
            },	
            music = { name = "Titania & Macbeth - Star Fox 64" },
        },
        {						
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 3793, y = 2147, z = -1165, yaw = 0x4000 },
	    flagBase = false,
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_MOLTEN,	
            floodScale = 2,			
            unwantedBhvs = { id_bhvExclamationBox },
            music = { name = "Domus Isle - Dragon Quest Monsters Joker" },		
        },
        {						
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 0, y = 13755, z = -915, yaw = 0x0000 },
	    flagBase = false,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
            floodScale = 2,
            floodHeight = 6666,	
            music = { name = "Gloomy Galleon - Donkey Kong 64" },		
        },
        {						
            name = "sa2",
            level = LEVEL_SA,
            area = 2,
            flagPos = { x = 2655, y = 10210, z = 150, yaw = -0x4000 },
	    flagBase = true,
            speed = 5.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,		
            floodScale = 2,
	    overrideName = "Murky Tower",
            floodHeight = -2200,
            music = { name = "Fortress - New Super Mario Bros. Wii" },	
        },
        {						
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 313, y = 2954, z = 3223, yaw = 0x0000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
	    floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            music = { name = "Banana Fairy Island - Donkey Kong 64" },
        },
        {						
            name = "lll2",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -1331, y = 4691, z = 1000, yaw = 0x4000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
            startPos = { x = -1111, y = -324, z = 555, yaw = -0x4000 },
	    floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
	    overrideName = "The Pointy Arches",
            music = { name = "Banana Fairy Island - Donkey Kong 64" },
        },
        {						
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 5325, y = 17710, z = 840, yaw = -0x6000 },
	    flagBase = true,
            speed = 3.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
	    floodScale = 2,		
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -555,			
            launchpads = {
                { x = 2300, y = 16435, z = -235, yaw = 0x0000, vel = 100, forwardVel = 0 },
            },			
            music = { name = "Beach Overworld - New Super Mario Bros." },
        },
        {						
            name = "ssl2",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -4355, y = 11594, z = -7474, yaw = 0x6000 },
	    flagBase = true,
            speed = 3.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
            startPos = { x = 2785, y = 7188, z = 2155, yaw = -0x6000 },
	    floodScale = 2,		
            unwantedBhvs = { id_bhvExclamationBox },
	    overrideName = "The Vine-Log Journey",
            floodHeight = 3333,			
            launchpads = {
                { x = 2300, y = 16435, z = -235, yaw = 0x0000, vel = 100, forwardVel = 0 },
            },			
            music = { name = "Beach Overworld - New Super Mario Bros." },
        },
        {						
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 2145, y = 5365, z = -7065, yaw = 0x0000 },
	    flagBase = false,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
	    floodScale = 2,	
            music = { name = "The Road is Full of Dangers - Super Mario RPG: Legend of the Seven Stars" },
        },
        {						
            name = "ddd2",
            level = LEVEL_DDD,
            area = 2,
            flagPos = { x = 0, y = 4445, z = 0, yaw = 0x0000 },
	    flagBase = false,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
	    floodScale = 2,	
	    overrideName = "Tick! Tock!",
	    floodHeight = -3000,
            music = { name = "Tick Tock Clock - Mario Kart DS" },
        },
        {						
            name = "ddd3",
            level = LEVEL_DDD,
            area = 3,
            flagPos = { x = 7785, y = 4585, z = 3150, yaw = 0x0000 },
	    flagBase = false,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
	    floodScale = 2,	
	    overrideName = "Fireflower Mud Hopping",	
            music = { name = "The Road is Full of Dangers - Super Mario RPG: Legend of the Seven Stars" },		
        },
        {						
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -555, y = 5830, z = -5585, yaw = 0x0000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,				
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },
            floodHeight = 0,
            launchpads = {
                { x = -1578, y = 1900, z = 737, yaw = 0x0000, vel = 100, forwardVel = 0 },
            },		
            music = { name = "Pinna Park Beach - Super Mario Sunshine" },				
        },
        {						
            name = "bitfs2",
            level = LEVEL_BITFS,
            area = 3,
            flagPos = { x = 666, y = 4532, z = 0, yaw = -0x4000 },
	    flagBase = false,
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,				
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },
            floodHeight = -555,	
            music = { name = "Tick Tock Clock - Mario Kart DS" },				
        },
        {						
            name = "b2",
            level = LEVEL_BOWSER_2,
            area = 2,
            flagPos = { x = 21770, y = -355, z = -7095, yaw = -0x4000 },
	    flagBase = true,
            speed = 1.0,
            author = "Usernamesarespiders",
            type = FLOOD_FROSTBITE,
	    floodScale = 3,					
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBowserKey },	
	    overrideName = "Windpump Frozen Ride",		
            floodHeight = -2000,			
            music = { name = "Athletic - New Super Mario Bros." },
        },
        {						
            name = "b2-2",
            level = LEVEL_BOWSER_2,
            area = 1,
            flagPos = { x = 14880, y = 50, z =  11345, yaw = -0x4000 },
	    flagBase = true,
            speed = 1.0,
            author = "Usernamesarespiders",
            type = FLOOD_SUNSET,		
            floodScale = 4,	
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBowserKey },
	    overrideName = "Windpump Desert Ride",		
            floodHeight = -4000,					
            launchpads = {
                { x = -18000, y =  52,  z = -7432, yaw = 0x4000, vel = 100, forwardVel = 50 },
                { x =  18000, y = -431, z = -7132, yaw = 0x4000, vel = 100, forwardVel = 50 },
            },	
            pipes = {
                 {
                       { x =  22000, y = -156, z = -7132,  yaw = -0x4000 },
                       { x = -21345, y =  52,  z =  11490, yaw =  0x4000 },
                 }
            },	
            music = { name = "Athletic - New Super Mario Bros." },							
        },
        {						
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 4955, y = 4935, z = 6085, yaw = -0x5000 },
	    flagBase = false,
            speed = 3.5,
            author = "Usernamesarespiders",
            type = FLOOD_RAINBOW,			
            floodScale = 2,	
            floodHeight = -5555,
            music = { name = "Rainbow Road - Mario Kart DS" },		
        },
        {						
            name = "wdw2",
            level = LEVEL_WDW,
            area = 2,
            flagPos = { x = -6203, y = 6483, z = -371, yaw = 0x8000 },
	    flagBase = true,
            speed = 7.0,
            author = "Usernamesarespiders",
            type = FLOOD_RAINBOW,		
            startPos = { x = 7080, y = -1815, z =  210, yaw = -0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
	    overrideName = "Rainbow Magma Slide",		
            overrideSlide = true,	
            music = { name = "Rainbow Road - Mario Kart 8" },		
        },
        {						
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -8855, y = 6705, z = 3035, yaw = 0x0000 },
	    flagBase = false,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_MAGMA,		
	    floodScale = 2,
            floodHeight = -0,
            launchpads = {
                { x = -8175, y = 5540, z = 5130, yaw = -29590, vel = 500, forwardVel = 100 },
            },	
            music = { name = "Melty Molten Galaxy - Super Mario Galaxy" },		
        },
        {						
            name = "sl2",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -2078, y = 4905, z = -10835, yaw = -0x2000 },
	    flagBase = false,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_MAGMA,	
            startPos = { x = -6500, y = 1765, z = -878, yaw = 0x6000 },	
	    floodScale = 3,
	    overrideName = "Snowman More Like Cold... Yeah",
            floodHeight = -0,
            launchpads = {
                { x = 3169, y = 2432, z = 827, yaw = -0x6000, vel = 500, forwardVel = 0 },
            },	
            music = { name = "Melty Molten Galaxy - Super Mario Galaxy" },		
        },
        {						
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 0, y = 9135, z = 13150, yaw = 0x3000 },
	    flagBase = false,
            speed = 3.5,
            author = "Usernamesarespiders",
            type = FLOOD_CLOUDS,		
	    floodScale = 3,
            music = { name = "Sky Garden - Mario Kart: Super Circuit" },
        },
        {						
            name = "ttm2",
            level = LEVEL_TTM,
            area = 2,
            flagPos = { x = 900, y = 8695, z = -165, yaw = 0x0000 },
	    flagBase = false,
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_SAND,	
	    floodScale = 1,
	    overrideName = "Floating Cilo Climb",
            music = { name = "Fortress - New Super Mario Bros. Wii" },
        },
        {						
            name = "ttm3",
            level = LEVEL_TTM,
            area = 3,
            flagPos = { x = 2200, y = 2500, z = 0, yaw = -0x4000 },
	    flagBase = true,
            speed = 7.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,		
            startPos = { x = -4765, y = -110, z = -360, yaw = 0x4000 },
	    floodScale = 2,		
	    overrideName = "Floating Castle Of Condensation",
            overrideWater = true,
            music = { name = "??? - ???" },
        },
        {						
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 3215, y = 3524, z = 11515, yaw = -0x2000 },
            flagBase = true,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_MOLTEN,		
	    floodScale = 3,
            music = { name = "Flowing Lava - New Super Mario Bros." },
        },
        {						
            name = "thi2",
            level = LEVEL_THI,
            area = 2,
            flagPos = { x = -3070, y = 1830, z = -1580, yaw = 0x4000 },
            flagBase = false,
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_LAVA,
	    floodScale = 2,	
            unwantedBhvs = { id_bhvExclamationBox },
	    overrideName = "Molten Magma Fall",
            music = { name = "Flowing Lava - New Super Mario Bros." },
        },
        {						
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -2900, y = 3363, z = -4900, yaw = -0x4000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_FROSTBITE,				
	    floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -1500,
            music = { name = "Cosmic Cove Galaxy - Super Mario Galaxy 2" },
        },
        {						
            name = "ttc2",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 5000, y = 4533, z = -1578, yaw = 0x2000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_FROSTBITE,		
            startPos = { x = 6378, y = 383, z = -2433, yaw = -0x6000 },		
	    floodScale = 2,
	    overrideName = "Brittle Wood",
            floodHeight = -1500,
            music = { name = "Cosmic Cove Galaxy - Super Mario Galaxy 2" },
        },
        {						
            name = "ttc3",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 4950, y = 5290, z = 3600, yaw =  0x4000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_FROSTBITE,		
            startPos = { x = 4015, y = 383, z = -110, yaw = -0x6000 },		
	    floodScale = 2,
	    overrideName = "Climb Around The Bend",
            floodHeight = -1000,
            music = { name = "Cosmic Cove Galaxy - Super Mario Galaxy 2" },
        },
        {						
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -90, y = 3560, z = -20, yaw = 0x0000 },
	    flagBase = false,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_SAND,
	    floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -1500,
            music = { name = "Temple Ruins - Crash Bandicoot" },				
        },
        {						
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -5710, y = 4025, z = -1585, yaw = -0x4000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_DARKNESS,		
            startPos = { x = -1970, y = -130, z = 110, yaw = -0x4000 },		
	    floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
	    overrideName = "Flower Cup: Monoliths",
            music = { name = "Demon Seed - Castlevania III: Dracula's Curse" },	
        },
        {						
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 8360, y = 2305, z = 6845, yaw = -0x4000 },
	    flagBase = true,
            speed = 1.0,
            author = "Usernamesarespiders",
            type = FLOOD_DARKNESS,		
            startPos = { x = -30, y = -135, z = 1995, yaw = 0x0000 },				
	    floodScale = 2,			
            unwantedBhvs = { id_bhvExclamationBox },
	    overrideName = "Flower Cup: Twisted Polygons",
            music = { name = "Demon Seed - Castlevania III: Dracula's Curse" },			
        },
        {						
            name = "rr3",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 16935, y = -180, z = -385, yaw = -0x4000 },
	    flagBase = false,
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_DARKTIDE,		
            startPos = { x = 4800, y = -20, z = 1120, yaw = 0x4000 },					
	    floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvFlamethrower },
            overrideName = "Flower Cup: Fiery Challenge",
            floodHeight = -1500,
            music = { name = "Demon Seed - Castlevania III: Dracula's Curse" },						
        },
        {						
            name = "rr4",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 120, y = 5660, z = -9455, yaw = 0x0000 },
	    flagBase = false,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_DARKNESS,		
            startPos = { x = -30, y = -135, z = -1995, yaw = 0x8000 },				
	    floodScale = 2,	
            unwantedBhvs = { id_bhvExclamationBox },		
	    overrideName = "Flower Cup: Banshee Boardwalk",
            music = { name = "Demon Seed - Castlevania III: Dracula's Curse" },					
        },
        {						
            name = "rr5",
            level = LEVEL_RR,
            area = 3,
            flagPos = { x = -6520, y = 3390, z = 7060, yaw = 0x0000 },
	    flagBase = false,
            speed = 1.0,
            author = "Usernamesarespiders",
            type = FLOOD_DARKNESS,		
            floodScale = 2,
            overrideName = "One Last Challenge...",	
            music = { name = "Majora's Wrath - The Legend of Zelda: Majora's Mask" },			
        },
        {						
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 735, y = 14145, z = -735, yaw = 0x0000 },
	    flagBase = true,
            speed = 4.5,
            author = "Usernamesarespiders",
            type = FLOOD_DARKNESS,
            floodScale = 2,	
            unwantedBhvs = { id_bhvWarpPipe },
            pipes = {
                 {
                       { x = -2068, y = 374,  z = -3546, yaw = 0x4000 },
                       { x = -2035, y = 2685, z = -1278, yaw = 0x0000 },
                 }
            },	
            music = { name = "Castle - New Super Mario Bros." },							
        },
        {						
            name = "ending",
            level = LEVEL_ENDING,
            area = 3,
            flagPos = { x = 2560, y = 8430, z = -9650, yaw = 0x0000 },
	    flagBase = true,
            speed = 4.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,		
	    floodScale = 3,
	    overrideName = "The Clockwork Dimension",
            music = { name = "Tick Tock Clock - Mario Kart DS" },
        },
        {						
            name = "castle_grounds",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 2325, y = 3580, z = -7145, yaw = 0x8000 },
	    flagBase = true,
            speed = 3.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,		
	    floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
	    overrideName = "Prologue",	
            music = { name = "Toad Town - Paper Mario" },	
        },
        {						
            name = "cg2",
            level = LEVEL_CASTLE_GROUNDS,
            area = 3,
            flagPos = { x =  915,  y = 198,  z = 12008, yaw =  0x4000 },
	    flagBase = true,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_SUNSET,
	    floodScale = 2,		
            overrideName = "Disaster",	
            music = { name = "Lower Norfair - Super Metroid" },	
        },
        {						
            name = "castle_courtyard",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = -7705, y = 1995, z = -8460, yaw = 0x2000 },
	    flagBase = true,
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_DARKNESS,	
	    floodScale = 2,
            overrideName = "The Unknown",
            music = { name = "In The Nightmare - Pokémon Mystery Dungeon: Explorers of Time / Darkness / Sky" },			
        },
        {						
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -401,  y = 2715,  z = 1590, yaw =  0x8000 },
	    flagBase = true,
            speed = 4.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,	
            startPos = { x = 1994, y = 170, z = -906, yaw = -0x3000 },
	    floodScale = 2,		
            overrideName = "Solitude Fortress",
            music = { name = "Resonance - HOME" },			
        },
    }
end

-- Moonshine, ported to Flood by MarcoGamerOJ
local function flood_load_moonshine_levels()
    game = GAME_MOONSHINE
    romhackInfo = "Super Mario 64 Moonshine"
	romhackLogo = get_texture_info("logo_sm64moonshine")	
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -11, y = -2794, z = 1978, yaw = 0x8000}
        },
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 345, y = -5, z = 5260, yaw = 0x8000}
        }
    }

    gLevels = {
        {	
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 6800, y = 1674,  z =  -3226, yaw = -0x1000 },
	    flagBase = true,
            speed = 3.0,
            author = "TurnFlashed",
            type = FLOOD_WATER,		
            startPos = { x = 52, y = 600,  z = -5, yaw =  0x4000, airborne = true },
             
            floodScale = 3,
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -2680, y = -1190,  z = -5540, yaw = 0x4000 },
            speed = 2.0,
            author = "TurnFlashed",
            type = FLOOD_WATER,		
            startPos = { x = 4405, y = -1840, z = -7430, yaw = -0x4000, airborne = true },
            floodScale = 3,
            overrideName = "Archipelago's Cave",
        },
        {						
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -69,  y = 7260,  z = -6866, yaw =  0x8000 },
            speed = 2.5,
            author = "TurnFlashed",
            type = FLOOD_WATER,	
            startPos = { x = 0, y = 450,  z = 7267, yaw =  -0x8000, airborne = true },
            floodScale = 2,
        },
        {						
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 6385, y = 5520,  z = -4390, yaw = 0x4000 },
	    flagBase = true,
            speed = 3.0,
            author = "TurnFlashed",
            type = FLOOD_SNOW,	
            floodHeight = -1000,
	    floodScale = 4,
        },
        {						
            name = "ccm2",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = -1525, y = -155,  z = -3050, yaw = 0x4000 },
	    flagBase = true,
            speed = 2.0,
            author = "TurnFlashed",
            type = FLOOD_MOLTEN,	
            startPos = { x = 7120, y = -3640, z = -7120, yaw = -0x2000, airborne = true },			
	    overrideName = "Melted Lava",
            unwantedBhvs = { id_bhvWarpPipe },			
	    floodScale = 4,			
        },
        {						
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 832, y =  4940, z =  -706, yaw = -0x4000 },
	    flagBase = true,
            speed = 3.0,
            author = "TurnFlashed",
            type = FLOOD_WATER,
	     
	    floodHeight = -2500,
	    floodScale = 2,
        },
        {						
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 4510, y =  5485, z = -4490, yaw = -0x4000 },
	    flagBase = true,
            speed = 1.75,
            author = "TurnFlashed",
            type = FLOOD_SUNSET,
	    floodHeight = -3000,
	    floodScale = 4,
        },
        {						
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 2294, y = 2, z = -7029, yaw = 0x0000 },
	    flagBase = true,
            speed = 2.0,
            author = "TurnFlashed",
            type = FLOOD_WATER,
	    floodHeight = -3000,
	    floodScale = 2,
	     
        },
        {						
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -250, y = -2160, z =  4260, yaw =  0x0000 },
	    flagBase = true,
            speed = 1.0,
            author = "TurnFlashed",
            type = FLOOD_WATER,
            startPos = { x = 6380, y = -3300, z = 5600, yaw = -0x4000, airborne = true },
	    overrideName = "Green Cavern",
	    floodScale = 2,					
        },
        {						
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -2671, y = 10141, z =  1133, yaw = -0x4000 },
	    flagBase = true,
            speed = 2.75,
            author = "TurnFlashed",
            type = FLOOD_CLOUDS,
            startPos = { x = 690, y = 360, z = 3885, yaw = 0x4000, airborne = true },
	     
	    floodScale = 2,
        },
        {						
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 2997, y = -3576, z =  -207, yaw =  0x4000 },
	    flagBase = true,
            speed = 3.5,
            author = "TurnFlashed",
            type = FLOOD_WATER,
	    floodScale = 4,
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {						
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 6914, y =  1750, z =  2599, yaw =  0x8000 },
	    flagBase = true,
            speed = 2.0,
            author = "TurnFlashed",
            type = FLOOD_POISON,
            unwantedBhvs = { id_bhvWarpPipe },				
            floodScale = 4,
        },
        {						
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -1492, y =  2442, z =  -572, yaw =  0x0000 },
	    flagBase = true,
            speed = 1.5,
            author = "TurnFlashed",
            type = FLOOD_WATER,
            startPos = { x = 6707, y = -1049, z = 6853, yaw =  0x8000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe },			
	    floodScale = 2,
        },
        {						
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 1820, y = -1150, z = 7880, yaw =  0x8000 },
	    flagBase = true,
            speed = 3.75,
            author = "TurnFlashed",
            type = FLOOD_WATER,
            startPos = { x = -11, y = -2794, z = 1978, yaw = 0x8000, airborne = true },
	    overrideName = "Peach's Castle",
            unwantedBhvs = { id_bhvWarpPipe },					
        }
    }
end			

-- Beat Block Beatdown, ported to Flood by SausRelics
local function flood_load_beat_block_beatdown_levels()
    game = GAME_BEAT_BLOCK_BEATDOWN
    romhackInfo = "Beat Block Beatdown"
	romhackLogo = get_texture_info("logo_bbb")	
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 5, yaw = 0x0000}
        },
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 2,
            spawn = {x = -1963, y = -982, z = -1964, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -35, y = 3831, z = -4904, yaw = -0x4000},
            flagBase = false,
            speed = 1.2,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -127, y = 594, z = 20, yaw = 0x4000},
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sa2",
            level = LEVEL_SA,
            area = 2,
            flagPos = { x = 505, y = 5200, z = 7616, yaw = -0x4000},
            flagBase = false,
            speed = 1.2,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 172, y = 910, z = 1, yaw = 0x4000, airborne = false },
            floodScale = 2,
            unwantedBhvs = {id_bhvWarpPipe},
            overrideName = "Pyramid Platform Passing"
        },
        {
            name = "sa3",
            level = LEVEL_SA,
            area = 3,
            flagPos = { x = -11, y = 10268, z = 8557, yaw = 0x0000},
            flagBase = false,
            speed = 1.3,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 15, y = 1589, z = -63, yaw = 0x0000, airborne = false },
            floodScale = 2,
            unwantedBhvs = {id_bhvWarpPipe},
            overrideName = "Wacky Wallkick Working"
        },
        {
            name = "sa4",
            level = LEVEL_SA,
            area = 4,
            flagPos = { x = -4883, y = 594, z = -4901, yaw = 0x7000},
            flagBase = false,
            speed = 0.7,
            author = "Usernamesarespiders",
            type = FLOOD_MOLTEN,
            startPos = { x = -4522, y = 910, z = 4631, yaw = 0x2000, airborne = false },
            floodScale = 2,
            unwantedBhvs = {id_bhvWarpPipe},
            overrideName = "Lava Land Lunging"
        },
        {
            name = "sa5",
            level = LEVEL_SA,
            area = 5,
            flagPos = { x = -2436, y = 2862, z = -6216, yaw = 0x4000},
            flagBase = false,
            speed = 0.7,
            author = "Usernamesarespiders",
            type = FLOOD_MOLTEN,
            startPos = { x = 44, y = 910, z = 28, yaw = -0x6000, airborne = false },
            floodScale = 2,
            unwantedBhvs = {id_bhvWarpPipe},
            overrideName = "Fiery Fast Finale"
        },
    }
end

-- Mario in the Dreamscape, ported to Flood by Jzzay
local function flood_load_mario_in_the_dreamscape_levels()
    game = GAME_DREAMSCAPE
    romhackInfo = "Mario in the Dreamscape"
    romhackLogo = get_texture_info("dreamscape_logo")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 5609, y = -674, z = -1371, yaw = 0x0000}
        },
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -3504, y = -1759, z = 1678, yaw = 0x4000}
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 705, y = -793, z = 5532, yaw = 0x8000}
        },
        [4] = {
            level = LEVEL_TTM,
            area = 2,
            spawn = {x = -175, y = -1565, z = -259, yaw = 9486 },
            unwantedBhvs = { id_bhvFireSpitter, id_bhvCirclingAmp, id_bhvScuttlebug }			
        },
        [5] = {
            level = LEVEL_PSS,
            area = 1,
            spawn = {x = 5609, y = -673, z = -1404, yaw = 0x0000 }	
        },
        [6] = {
            level = LEVEL_PSS,
            area = 2,
            spawn = {x = -3407, y = -2212, z = 1654, yaw = 0x4000 }		
        },
        [7] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = -635, y = -203, z = -2052, yaw = 3094 },
            unwantedBhvs = { id_bhvFireSpitter }
        },
        [8] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = 200, y = -920, z = -2725, yaw = 0x0000 }	
        },
        [9] = {
            level = LEVEL_BOWSER_3,
            area = 1,
            spawn = {x = -3575, y = 0, z = -10, yaw = 0x4000 }		
        },
        [10] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 2,
            spawn = {x = 2020, y = -1237, z = -4850, yaw = 0x0000 },
            pipes = {
                {
                    { x = -300, y = -1621, z = 394, yaw = 0x4000 },
                    { x = -2195, y = 3373, z = -1315, yaw = 0x0000 }									
                },
            },		
        },
        [11] = {
            level = LEVEL_JRB,
            area = 2,
            spawn = {x = 2945, y = -2627, z = 0, yaw = -0x4000 }
        },
        [12] = {
            level = LEVEL_BITS,
            area = 2,
            spawn = {x = -560, y = -1376, z = -423, yaw = 0x0000 }			
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 6102, y = 4803, z = -4185, yaw = 0x5000 },
            flagBase = true,
            speed = 4.5,
            author = "Angry",
            type = FLOOD_TIDE,
            floodScale = 3,
            floodHeight = -4692,
            music = { name = "Redial - Bomberman Hero" }			
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 2,
            flagPos = { x = -7575, y = 2050, z = -3060, yaw = -0x4000 },
            flagBase = true,
            speed = 3.45,
            author = "Angry",
            type = FLOOD_DARKTIDE,
            startPos = { x = -6274, y = -897, z = 4015, yaw = 0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvMessagePanel },
            overrideName = "Zkyscape Canyon",
            floodHeight = -2817,
            music = { name = "Hidden Highland - Pokémon Mystery Dungeon: Explorers of Sky" }			
        },
        {
            name = "bob3",
            level = LEVEL_BOB,
            area = 3,
            flagPos = { x = 100, y = 2380, z = 920, yaw = 0x8000 },
            speed = 8.0,
            author = "Angry",
            type = FLOOD_TIDE,
            startPos = { x = 109, y = -2313, z = -917, yaw = 0x0000, spin = false },
            floodScale = 2,
            overrideName = "Tower Of Time",
            floodHeight = -4692,
            music = { name = "Cloudy Climb - Paper Mario" }			
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 6286, y = 3149, z = 4656, yaw = 0x1000 },
            flagBase = false,
            speed = 3.25,
            author = "Angry",
            type = FLOOD_WATER,
            startPos = { x = -6564, y = -590, z = -7477, yaw = 0x2000 },
            floodScale = 3.5,
            music = { name = "Corridors of Time - Chrono Trigger" }			
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 2,
            flagPos = { x = 2705, y = 5915, z = -695, yaw = 0x8000 },
            flagBase = true,
            speed = 4.0,
            author = "Angry",
            type = FLOOD_TIDE,
            startPos = { x = 557, y = 3512, z = -488, yaw = 0x9500 },
            overrideName = "Rocky-Eye Cove",
            music = { name = "Corridors Of Time - Chrono Trigger" }			
        },
        {
            name = "wf3",
            level = LEVEL_WF,
            area = 3,
            flagPos = { x = -3005, y = 3240, z = -835, yaw = 0x4000 },
            flagBase = true,
            speed = 2.25,
            author = "Angry",
            type = FLOOD_SAND,
            startPos = { x = 5965, y = -632, z = 1430, yaw = -0x4000 },
            floodScale = 2,
            overrideName = "Unidentified Desert Structures",
            music = { id = 38, name = "Corridors Of Time - Chrono Trigger" }		
        },
        {
            name = "wf4",
            level = LEVEL_WF,
            area = 4,
            flagPos = { x = -7920, y = 3060, z = -4645, yaw = -0x4000 },
            speed = 2.25,
            author = "Angry",
            type = FLOOD_SAND,
            startPos = { x = 9195, y = -366, z = 2340, yaw = -0x4000 },
            floodScale = 2,
            overrideName = "Deserted Oasis",
            music = { id = 38, name = "Corridors Of Time - Chrono Trigger" }		
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 1357, y = 3059, z = -3798, yaw = 0x8000 },
            speed = 2.7,
            author = "Angry",
            type = FLOOD_WATER,
            startPos = { x = 5418, y = -1762, z = -2770, yaw = -0x7750 },
            floodScale = 2,
            music = { name = "Metallic Madness [Present] - Sonic CD (US)" }			
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 3,
            flagPos = { x = -996, y = 558, z = -4777, yaw = -0x6500 },
            speed = 3.25,
            author = "Angry",
            type = FLOOD_FROSTBITE,
            startPos = { x = -2969, y = -886, z = -624, yaw = 0x7750, spin = false },
            floodScale = 2,
            overrideName = "Blue-Ice Skating",
            music = { name = "The Crystal Caves - Medievil" }			
        },
        {
            name = "jrb3",
            level = LEVEL_JRB,
            area = 3,
            flagPos = { x = -950, y = 4730, z = 1520, yaw = 0x4000 },
            flagBase = true,
            speed = 8.0,
            author = "Angry",
            type = FLOOD_WATER,
            startPos = { x = 10115, y = -25, z = 9032, yaw = -0x3000, spin = false },
            floodScale = 2,
            overrideName = "Construction Moist Ravine",
            overrideSlide = true,
            music = { name = "The Crystal Caves - Medievil" }				
        },
        {
            name = "jrb4",
            level = LEVEL_JRB,
            area = 4,
            flagPos = { x = -435, y = 3190, z = 2745, yaw = 0x6000 },
            flagBase = true,
            speed = 5.5,
            author = "Angry",
            type = FLOOD_TIDE,
            startPos = { x = -10645, y = -3320, z = 2060, yaw = 20620, spin = false },
            floodScale = 2,
            overrideName = "Cavernous Shrine Trial",
            floodHeight = -4963,
            launchpads = {
                { x = -3539, y = -2614, z = 477, yaw = 16645, vel = 130, forwardVel = 0 },
            },
            music = { id = 22, name = "The Grand Finale - Mario and Luigi Bowser's Inside Story" }	
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -1762, y = 2174, z = -5415, yaw = -0x1000 },
            speed = 2.5,
            author = "Angry",
            type = FLOOD_FROSTBITE,
            startPos = { x = -1428, y = -1505, z = 9575, yaw = 0x8000 },
            floodScale = 1.25,
            unwantedBhvs = { id_bhvBlueCoinSwitch },
            music = { name = "In a Snow-Bound Land - Donkey Kong Country 2: Diddy's Kong Quest" }		
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 12430, y = -276, z = 5600, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "Angry",
            type = FLOOD_FROSTBITE,
            startPos = { x = 12430, y = -990, z = -5445, yaw = 0x0000 },
            floodScale = 1.25,
            overrideName = "Tuxie Rescue Cavern",			
            music = { name = "In a Snow-Bound Land - Donkey Kong Country 2: Diddy's Kong Quest" }						
        },
        {
            name = "ccm3",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = 105, y = 1180, z = 3015, yaw = 0x8000 },
            flagBase = true,
            speed = 4.0,
            author = "Angry",
            type = FLOOD_FROSTBITE,
            startPos = { x = 91, y = 254, z = -1686, yaw = 0x0000, spin = false },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },			
            overrideName = "Icicle Top Cavern",
            capTimer = 300,
            powerUp = "metal",
            music = { name = "In a Snow-Bound Land - Donkey Kong Country 2: Diddy's Kong Quest" }			
        },
        {
            name = "ccm4",
            level = LEVEL_CCM,
            area = 3,
            flagPos = { x = -14655, y = 5625, z = 3120, yaw = 0x2000 },
            flagBase = true,
            speed = 4.0,
            author = "Angry",
            type = FLOOD_SNOW,
            startPos = { x = 9562, y = -1106, z = 6188, yaw = -0x4000, spin = false },
            floodScale = 3,
            overrideName = "Mt. Breezie Climb",
            music = { name = "In a Snow-Bound Land - Donkey Kong Country 2: Diddy's Kong Quest" }			
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -5600, y = 2329, z = 9294, yaw = 0x8900 },
            flagBase = false,
            speed = 1.2,
            author = "Angry",
            type = FLOOD_FROSTBITE,
            startPos = { x = -1015, y = 305, z = -4643, yaw = -0x0500 },
            floodScale = 1.5,
            overrideName = "Icy Undergrounds",
            music = { name = "Sacred Gove - The Legend Of Zelda: Twilight Princess" }	
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 12709, y = 2786, z = -679, yaw = 0x4000 },
            flagBase = true,
            speed = 1.5,
            author = "Angry",
            type = FLOOD_POISON,
            startPos = { x = -7836, y = -1587, z = 7783, yaw = 0x7950 },
            floodScale = 3,
            unwantedBhvs = { id_bhvBlueCoinSwitch, id_bhvWarpPipe },
            music = { name = "Treeshroud Forest - Pokémon Mystery Dungeon: Explorers Of Time/Darkness/Sky" }			
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 2,
            flagPos = { x = 11482, y = -230, z = -2396, yaw = -0x6000 },
            speed = 3.0,
            author = "Angry",
            type = FLOOD_ACID,
            startPos = { x = 1363, y = -1171, z = 4583, yaw = 0x6000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },			
            overrideName = "Inverted Forest",
            music = { name = "Miracle Sea (Slowed) - Pokémon Mystery Dungeon: Explorers Of Time/Darkness/Sky" }			
        },
        {
            name = "bbh3",
            level = LEVEL_BBH,
            area = 3,
            flagPos = { x = 3612, y = 697, z = -3298, yaw = -0x1000 },
            speed = 3.0,
            author = "Angry",
            type = FLOOD_POISON,
            startPos = { x = -113, y = -623, z = 3100, yaw = 0x8000, spin = false },
            floodScale = 2,
            overrideName = "Fortress Trees",
            music = { name = "Dusk Forest - Pokémon Mystery Dungeon: Explorers Of Time/Darkness/Sky" }				
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -5858, y = 3681, z = 445, yaw = 0x0000 },
            flagBase = false,
            speed = 2.0,
            author = "Angry",
            type = FLOOD_SAND,
            music = { name = "Museum - Sonic Jam" }			
        },
        {
            name = "hmc2",
            level = LEVEL_HMC,
            area = 2,
            flagPos = { x = -980, y = 3582, z = -480, yaw = 0x6000 },
            flagBase = true,
            speed = 4.6,
            author = "Angry",
            type = FLOOD_WATER,
            startPos = { x = 3002, y = 719, z = 1937, yaw = -0x4000, spin = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Cavern Of The Lake", 
            floodHeight = -3441,
            music = { name = "Boss Defeated - The Legend Of Zelda: Twilight Princess" }			
        },
        {
            name = "hmc3",
            level = LEVEL_HMC,
            area = 3,
            flagPos = { x = 2995, y = 2535, z = 4630, yaw = 0x8000 },
            speed = 5.0,
            author = "Angry",
            type = FLOOD_WATER,
            startPos = { x = -93, y = -2327, z = -3743, yaw = 0x0000 },
            floodScale = 2,
            overrideName = "Bubble Town Trip",
            floodHeight = -4759,
            music = { name = "Museum - Sonic Jam" }				
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -5655, y = 3626, z = -9663, yaw = 0x4000 },
            flagBase = true,
            speed = 5.25,
            author = "Angry",
            type = FLOOD_DARKNESS,
            startPos = { x = -1062, y = 91, z = 9014, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvFadingWarp },
            overrideName = "Neon Narcolepsy",
            floodHeight = -6309,
            pipes = {
                {
                    { x = 2767, y = 743, z = -1179 },
                    { x = 6945, y = 4873, z = 1755, yaw = -0x6000 }								
                },
            },		
            music = { name = "Dark Man Stage - Megaman 5" }			
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 4946, y = 2585, z = -6693, yaw = -0x2500 },
            flagBase = true,
            speed = 2.0,
            author = "Angry",
            type = FLOOD_VOLCANO,
            startPos = { x = 14, y = -1631, z = -942, yaw = 0x6500 },
            floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },
            music = { name = "Volcano Valley Zone (Act 2) - Sonic 3D Blast (Genesis)" }			
        },
        {
            name = "lll2",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -8558, y = -3879, z = 3319, yaw = 0x4000 },
            flagBase = true,
            speed = 1.5,
            author = "Angry",
            type = FLOOD_VOLCANO,
            startPos = { x = -8734, y = -6468, z = 4742, yaw = 0x8500 },
            floodScale = 3,
            overrideName = "Gaps of Floral Outskirts",			
            music = { name = "Volcano Valley Zone (Act 2) - Sonic 3D Blast (Genesis)" }	
        },
        {
            name = "lll3",
            level = LEVEL_LLL,
            area = 2,
            flagPos = { x = -3460, y = 3440, z = -590, yaw = 0x2000 },
            speed = 3.85,
            author = "Angry",
            type = FLOOD_VOLCANO,
            startPos = { x = 3560, y = -10, z = -1046, yaw = -0x4000, spin = false },
            overrideName = "Floral Flaming Volcano",
            music = { name = "Volcano Valley Zone (Act 2) - Sonic 3D Blast (Genesis)" }		
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 4671, y = 8012, z = 5187, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Angry",
            type = FLOOD_TIDE,
            startPos = { x = 1103, y = -3294, z = -888, yaw = -0x2800 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true,
            music = { name = "A New Trial is in Session - Apollo Justice: Ace Attorney" }			
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x = -6311, y = 3671, z = 6739, yaw = 0x8000 },
            speed = 8.25,
            author = "Angry",
            type = FLOOD_ACID,
            startPos = { x = 8755, y = -1880, z = -13730, yaw = 0x1500 },
            floodScale = 2.6,
            overrideName = "Back to Earth",            
            floodHeight = -7000,
            launchpads = {
                { x = 9336, y = -1370, z = -12702, yaw = 6688, vel = 1, forwardVel = 85 },
                { x = 13839, y = -2339, z = -6636, yaw = -4609, vel = 1, forwardVel = 85 },
                { x = 11464, y = -1418, z = -1763, yaw = -13407, vel = 1, forwardVel = 85 },
                { x = 5354, y = -796, z = 91, yaw = -23431, vel = 1, forwardVel = 85 },
                { x = 1016, y = 229, z = -3210, yaw = -7383, vel = 1, forwardVel = 105 },
                { x = -5860, y = 757, z = 5496, yaw = -628, vel = 140, forwardVel = 0 },
            },
            music = { name = "A New Trial is in Session - Apollo Justice: Ace Attorney" }			
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -94, y = -224, z = -14084, yaw = 0x3500 },
            flagBase = true,
            speed = 1.4,
            author = "Angry",
            type = FLOOD_COTTON,
            startPos = { x = -16641, y = -3735, z = -6989, yaw = 0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Cotton Castle Clouds",
            music = { name = "Northern Desert - Pokémon Mystery Dungeon: Explorers Of Time/Darkness/Sky" }			
        },
        {
            name = "totwc2",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 273, y = 5069, z = 17261, yaw = 0x7000 },
            flagBase = true,
            speed = 1.7,
            author = "Angry",
            type = FLOOD_COTTON,
            startPos = { x = 3368, y = 1137, z = 9739, yaw = 0x0000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Clouds On Fire",
            music = { name = "Northern Desert - Pokémon Mystery Dungeon: Explorers Of Time/Darkness/Sky" }			
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -4482, y = 1090, z = -1389, yaw = -4016 },
            flagBase = true,
            speed = 1.5,
            author = "Angry",
            type = FLOOD_POISON,
            startPos = { x = 5924, y = -740, z = -5767, yaw = -0x2000 },
            floodScale = 4,
            music = { name = "Aqua Star - Kirby 64: The Crystal Shards" }			
        },
        {
            name = "bitdw2",
            level = LEVEL_BITDW,
            area = 2,
            flagPos = { x = -2367, y = 1772, z = 174, yaw = 0x4000 },
            flagBase = true,
            speed = 4.0,
            author = "Angry",
            type = FLOOD_OPTIC,
            startPos = { x = -1543, y = -1460, z = -1725, yaw = 0x2500 },
            floodScale = 2,
            overrideName = "Starfield Coast",
            music = { id = 39, name = "Cloudy Climb - Paper Mario" }								
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -5370, y = 1799, z = 11494, yaw = 0x4000 },
            speed = 1.75,
            author = "Angry",
            type = FLOOD_TIDE,
            startPos = { x = -677, y = -1716, z = -10842, yaw = 0x1000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvFadingWarp, id_bhvExclamationBox, id_bhvKoopa },
            overrideWater = true,
            music = { name = "Butter Building (Slowed) - Kirby: Nightmare in Dream Land" }			
        },
        {
            name = "ddd2",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -29050, y = 3810, z = 5350, yaw = 0x5000 },
            flagBase = true,
            speed = 1.75,
            author = "Angry",
            type = FLOOD_LAVA,
            startPos = { x = -12892, y = -74, z = 4809, yaw = -0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvFadingWarp, id_bhvChuckya, id_bhvBobomb, id_bhvGoomba, id_bhvBlueCoinSwitch, id_bhvBobombBuddy },
            overrideName = "Devils' Domain",
            music = { name = "Butter Building (Slowed) - Kirby: Nightmare in Dream Land" }				
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 8430, y = 2620, z = -7436, yaw = 12082 },
            flagBase = true,
            speed = 2.2,
            author = "Angry",
            type = FLOOD_WATER,
            startPos = { x = -8894, y = -1462, z = 2751, yaw = 0x8000 },
            floodScale = 3,
            music = { name = "Cappy (Stage 1) - Kirby's Block Ball" }			
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 7442, y = 3510, z = 1086, yaw = 0x4500 },
            flagBase = false,
            speed = 2.25,
            author = "Angry",
            type = FLOOD_DARKNESS,
            startPos = { x = -831, y = -411, z = 3437, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvRecoveryHeart },		
            music = { name = "Lavender Town (TheNail Edit) - Pokémon Red/Blue/Yellow" }			
        },
        {
            name = "sl2",
            level = LEVEL_SL,
            area = 2,
            flagPos = { x = 4520, y = 6275, z = 1760, yaw = 0x0000 },
            speed = 6.85,
            author = "Angry",
            type = FLOOD_WATER,
            startPos = { x = 8223, y = -960, z = 4635, yaw = 0x8000, spin = false },
            floodScale = 1.5,
            overrideName = "Hall Of The Mirrors",
            floodHeight = -3940,
            music = { name = "Jiggywiggy's Temple - Banjo-Tooie" }			
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 400, y = 247, z = 7678, yaw = -0x1300 },
            flagBase = false,
            speed = 1.75,
            author = "Angry",
            type = FLOOD_POISON,
            floodScale = 3.5,
            overrideWater = true,
            music = { name = "Forest Of Tohno - Touhou 2: Story of Eastern Wonderland" }			
        },
        {
            name = "wdw2",
            level = LEVEL_WDW,
            area = 2,
            flagPos = { x = 9924, y = 7986, z = 7877, yaw = 0x8000 },
            speed = 6.9,
            author = "Angry",
            type = FLOOD_CLOUDS,
            startPos = { x = -9451, y = -2867, z = 2361, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvFadingWarp, id_bhvTweester },
            overrideName = "Familiar Athletic Blocks",
            floodHeight = -8727,
            launchpads = {
                { x = 9919, y = 4726, z = 831, yaw = -81, vel = 10, forwardVel = 85 },
            },
            pipes = {
                {
                    { x = -3939, y = -80, z = -1193 },
                    { x = 5740, y = 1980, z = 1570, yaw = 0x4000 }									
                },
                {
                    { x = -9395, y = -2357, z = -795 },
                    { x = -8720, y = -1940, z = -4050, yaw = 0x8000 }	
                },					
            },				
            music = { name = "Athletic - New Super Mario Bros." }					
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -7743, y = 606, z = -2620, yaw = -22190 },
            speed = 1.25,
            author = "Angry",
            type = FLOOD_WASTE,
            startPos = { x = 4870, y = -737, z = -2069, yaw = -0x5500 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            music = { name = "Twilight Town - Paper Mario: The Thousand-Year Door" }
        },
        {
            name = "bitfs2",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -643, y = 5509, z = -2327, yaw = -0x4000 },
            speed = 4.5,
            author = "Angry",
            type = FLOOD_WASTE,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Atop The Lighthouse",
            floodHeight = -4000,
            launchpads = {
                { x = -4805, y = 1377, z = -6165, yaw = 0x0000, vel = 100, forwardVel = 70, capTimer = 60 },
            },			
            music = { name = "Twilight Town - Paper Mario: The Thousand-Year Door" }	
        },
        {
            name = "bitfs3",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 12620, y = -1065, z = 3575, yaw = -0x4000 },
            speed = 3.0,
            author = "Angry",
            type = FLOOD_WASTE,
            startPos = { x = 7040, y = -5760, z = 3220, yaw = 0x4000 },			
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Sunken Vault",	
            overrideWater = true,
            music = { name = "Twilight Town - Paper Mario: The Thousand-Year Door" }				
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 8134, y = 6787, z = 9581, yaw = -0x5000 },
            flagBase = false,
            speed = 2.2,
            author = "Angry",
            type = FLOOD_MUD,
            floodScale = 3,
            music = { name = "Ravine (Slowed) - ESPGaluda" }			
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 1701, y = 5201, z = 8941, yaw = 0x9000 },
            flagBase = false,
            speed = 2.35,
            author = "Angry",
            type = FLOOD_WATER,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },             
            floodHeight = -4511,
            music = { name = "Kraid's Lair - Metroid (NES)" }			
        },
        {
            name = "thi2",
            level = LEVEL_THI,
            area = 2,
            flagPos = { x = 10034, y = 11765, z = -11098, yaw = 0x0000 },
            speed = 5.0,
            author = "Angry",
            type = FLOOD_MUD,
            startPos = { x = -669, y = -7344, z = 17732, yaw = -0x4250 },
            floodScale = 2.5,
            overrideName = "Slipping TNT Storage",
            launchpads = {
                { x = -3213, y = -6680, z = 18268, yaw = -32728, vel = 90, forwardVel = 0 },
                { x = -8220, y = -2089, z = 13616, yaw = -32728, vel = 120, forwardVel = 0 },
                { x = -8219, y = 294, z = 3810, yaw = -32533, vel = 110, forwardVel = 0 },
                { x = 100, y = 3256, z = -3886, yaw = 16293, vel = 100, forwardVel = 0 },
            },
            overrideSlide = true,
            music = { name = "Flash Man - Mega Man Battle Network 3" }			
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 2,
            flagPos = { x = 10, y = 5829, z = -7741, yaw = 0x0000 },
            flagBase = false,
            speed = 1.5,
            author = "Angry",
            type = FLOOD_LAVA,
            startPos = { x = 0, y = 243, z = 5228, yaw = 0x8000 },
            floodScale = 2,
            overrideName = "Upside Red Town",
            music = { name = "Ressurections - Celeste" }			
        },
        {
            name = "ttc2",
            level = LEVEL_TTC,
            area = 3,
            flagPos = { x = -205, y = 4220, z = -11190, yaw = 0x0000 },
            speed = 4.0,
            author = "Angry",
            type = FLOOD_SULFUR,
            startPos = { x = 10, y = -2460, z = -9240, yaw = 0x0000 },
            floodScale = 2,
            overrideName = "Downside Blue Town",
            music = { name = "Quiet and Falling - Celeste" }			
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 9498, y = 4279, z = -670, yaw = -0x4550 },
            flagBase = true,
            speed = 3.5,
            author = "Angry",
            type = FLOOD_MATRIX,
            startPos = { x = 2517, y = -2296, z = 1680, yaw = -0x4000 },
            floodScale = 4,
            music = { name = "None" }			
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -8957, y = -949, z = -7741, yaw = 0x0000 },
            flagBase = true,
            speed = 3.35,
            author = "Angry",
            type = FLOOD_OPTIC,
            startPos = { x = -8403, y = -4170, z = 7492, yaw = 0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Ocean Base (Act 1) - Sonic Advance 3" }
        },
        {
            name = "bits2",
            level = LEVEL_BITS,
            area = 3,
            flagPos = { x = 980, y = 529, z = 10, yaw = 0x0000 },
            speed = 4.0,
            author = "Angry",
            type = FLOOD_MATRIX,
            startPos = { x = -1550, y = -2445, z = 685, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "The Path Out Of View",			
            music = { id = 25, name = "The Grand Finale - Mario and Luigi Bowser's Inside Story" }				
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 5858, y = 7070, z = 8308, yaw = 0x8000 },
            flagBase = false,
            speed = 1.7,
            author = "Angry",
            type = FLOOD_POISON,
            floodScale = 2,
            music = { name = "Deaf to All But the Sound - Touhou 8: Imperishable Night" }		
        },
        {
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 20387, y = 7870, z = 8130, yaw = 0x8000 },
            flagBase = false,
            speed = 3.6,
            author = "Angry",
            type = FLOOD_POISON,
            startPos = { x = -5997, y = 3161, z = 8800, yaw = 0x4000 },
            floodScale = 2,
            overrideName = "Slumpy Pillar Panels",
            floodHeight = 73,
            music = { name = "Deaf to All But the Sound - Touhou 8: Imperishable Night" }			
        },
        {
            name = "rr3",
            level = LEVEL_RR,
            area = 2,
            flagPos = { x = 2680, y = 3525, z = -2775, yaw = -0x2000 },
            speed = 2.5,
            author = "Angry",
            type = FLOOD_VOLCANO,
            startPos = { x = 10, y = 0, z = 2420, yaw = 0x8000 },
            floodScale = 2,
            overrideName = "Cannon-Cap Tower",
            music = { name = "Cloudy Climb - Paper Mario" }				
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 3,
            flagPos = { x = -2570, y = 3690, z = -15210, yaw = 0x4000 },
            flagBase = true,
            speed = 5.5,
            author = "Angry",
            type = FLOOD_REDTIDE,
            startPos = { x = 3500, y = -3595, z = -3630, yaw = -0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Positive Red Ending",
            floodHeight = -6547,
            music = { name = "Resonance - HOME" }			
        },
        {
            name = "pss2",
            level = LEVEL_PSS,
            area = 3,
            flagPos = { x = -9250, y = -3695, z = 6020, yaw = 0x8000 },
            flagBase = true,			
            speed = 5.0,
            author = "Angry",
            type = FLOOD_ACID,
            startPos = { x = -6050, y = -5410, z = 2780, yaw = 0x0000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Positive Green Ending",
            music = { name = "Resonance - HOME" }			
        },
        {
            name = "pss3",
            level = LEVEL_PSS,
            area = 3,
            flagPos = { x = 7930, y = -1072, z = 5960, yaw = 0x4000 },
            flagBase = true,
            speed = 6.0,
            author = "Angry",
            type = FLOOD_WATER,
            startPos = { x = 7975, y = -3965, z = 770, yaw = 0x2000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Positive Blue Ending",
            music = { name = "Resonance - HOME" }			
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 2,
            flagPos = { x = -8420, y = 180, z = -2115, yaw = 0x3500 },
            flagBase = true,
            speed = 2.45,
            author = "Angry",
            type = FLOOD_RAINBOW,
            startPos = { x = 1985, y = -1963, z = -470, yaw = 0x0500, spin = false },
            floodScale = 2,
            overrideName = "Tower Of King Whomp",
            music = { name = "Resonance - HOME" }			
        },
        {
            name = "pss4",
            level = LEVEL_PSS,
            area = 2,
            flagPos = { x = 3310, y = 1510, z = 5750, yaw = -0x6000 },
            flagBase = true,
            speed = 5.3,
            author = "Angry",
            type = FLOOD_DARKNESS,
            floodScale = 2,
            overrideName = "Nightmare Ending",
            floodHeight = -4083,
            music = { name = "Morphogenetic Sorrow - 999: Nine Hours, Nine Persons, Nine Doors" }			
        },
        {
            name = "ccm4",
            level = LEVEL_CCM,
            area = 4,
            flagPos = { x = -6110, y = 7065, z = -10995, yaw = 0x8000 },
            flagBase = true,
            speed = 2.75,
            author = "Angry",
            type = FLOOD_FROSTBITE,
            startPos = { x = -13364, y = -2713, z = 9468, yaw = 0x8000, spin = false },
            floodScale = 3,
            overrideName = "Inside the Borealis Core",
            floodHeight = -6425,
            music = { name = "Here We Are - Undertale" }			
        },
        {
            name = "pss5",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -11207, y = 809, z = -1145, yaw = 0x3000 },
            flagBase = false,
            speed = 2.5,
            author = "Angry",
            type = FLOOD_FROSTBITE,
            startPos = { x = 8579, y = -731, z = -4736, yaw = -0x2000 },
            floodScale = 1.5,
            overrideName = "Ice Ending",
            music = { name = "Morphogenetic Sorrow - 999: Nine Hours, Nine Persons, Nine Doors" }			
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = -11189, y = 807, z = -1109, yaw = 0x2000 },
            speed = 3.0,
            author = "Angry",
            type = FLOOD_TIDE,
            startPos = { x = 5610, y = -674, z = -1357, yaw = -0x4000, spin = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Mushroom Kingdom",
            music = { name = "Meteor Shower - Animal Crossing" }			
        },
        {
            name = "cc2",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 5195, y = 4097, z = -3382, yaw = -0x3750 },
            flagBase = true,
            speed = 1.85,
            author = "Angry",
            type = FLOOD_COTTON,
            startPos = { x = -2934, y = -1759, z = 1680, yaw = 0x4000 },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBobombBuddy },
            overrideName = "The Dreamscape",
            music = { name = "Sky Peak (Snowfield) - Pokémon Mystery Dungeon: Explorers Of Time/Darkness/Sky" }			
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 452, y = 1164, z = -3782, yaw = 0x0000 },
            speed = 3.2,
            author = "Angry",
            type = FLOOD_WATER,
            startPos = { x = 752, y = -1469, z = -2860, yaw = 0x0000, spin = false },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Xertic Castle",
            music = { name = "Lost Woods - The Legend Of Zelda: A Link Between Worlds" }			
        },
    }
end

-- Eureka, ported to Flood by ★~¡TOÑO!~★
local function flood_load_eureka_levels()
    game = GAME_EUREKA
    romhackInfo = "Eureka"
    romhackLogo = get_texture_info("logo_eureka")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 57, y = -530, z = -2412, yaw = 0x0000},
            music = { name = "Palm Beach - Sonyc" }				
        },
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 2,
            spawn = {x = -140, y = 0, z = 1400, yaw = 0x8000},
            music = { name = "Cranky's Lab - Donkey Kong 64" }			
        },
        [3] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 3,
            spawn = {x = 35, y = -72, z = 1670, yaw = 0x8000},
            music = { name = "All-Star Rest Area - Super Smash Bros. Melee" }			
        },
        [4] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 550, y = -564, z = -7278, yaw = 0x0000},
            music = { name = "Yamato - Mystical Ninja: Starring Goemon | 2nd Music: Grande Finale - Yoshi's Story" }
        },
        [5] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 2,
            spawn = {x = 0, y = 0, z = 990, yaw = 0x8000},
            music = { name = "Mushroom Bank - Mario Party" },			
        },
        [6] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 3,
            spawn = {x = 176, y = 0, z = 1121, yaw = 0x8000},
            music = { name = "Watch Pause Theme - Goldeneye 64" }			
        },
        [7] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 4,
            spawn = {x = 37, y = -72, z = 1013, yaw = 0x8000},
            music = { name = "All-Star Rest Area - Super Smash Bros. Melee" }				
        },
        [8] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 349, y = 350, z = -4955, yaw = 0x8000},
            music = { name = "Airship - Super Mario Bros 3." }			
        },
        [9] = {
            level = LEVEL_CASTLE,
            area = 2,
            spawn = {x = 9, y = -1179, z = -353, yaw = 0x8000},
            music = { name = "Airship - Super Mario Bros 3." }			
        },
        [10] = {
            level = LEVEL_BOB,
            area = 2,
            spawn = {x = -1150, y = 0, z = -1600, yaw = 0x8000},
            music = { name = "Watch Pause Theme - Goldeneye 64" }
        },
        [11] = {
            level = LEVEL_BOB,
            area = 3,
            spawn = {x = -647, y = 182, z = 1737, yaw = 0x8000},
            music = { name = "Kaepora Gaebora (DK64 Boss Remix) - The Legend of Zelda: Ocarina of Time" }			
        },
        [12] = {
            level = LEVEL_WF,
            area = 4,
            spawn = {x = -37, y = -152, z = 980, yaw = 0x8000},
            music = { name = "Watch Pause Theme - Goldeneye 64" }
        },
        [13] = {
            level = LEVEL_JRB,
            area = 3,
            spawn = {x = -370, y = 0, z = 55, yaw = 0x4000},
            music = { name = "Watch Pause Theme - Goldeneye 64" }
        },
        [14] = {
            level = LEVEL_CCM,
            area = 3,
            spawn = {x = -40, y = -41, z = -680, yaw = 0x8000},
            music = { name = "Watch Pause Theme - Goldeneye 64" }			
        },
        [15] = {
            level = LEVEL_BBH,
            area = 2,
            spawn = {x = 130, y = 81, z = 365, yaw = 0x8000},
            music = { name = "Watch Pause Theme - Goldeneye 64" }			
        },
        [16] = {
            level = LEVEL_HMC,
            area = 2,
            spawn = {x = 5, y = 498, z = -5, yaw = 0x8000},
            music = { name = "Koume and Kotake - The Legend of Zelda: Ocarina of Time" }			
        },
        [17] = {
            level = LEVEL_HMC,
            area = 3,
            spawn = {x = -25, y = 0, z = -1305, yaw = 0x8000},
            music = { name = "Wicked Child - Castlevania (NES)" }			
        },
        [18] = {
            level = LEVEL_LLL,
            area = 2,
            spawn = {x = 130, y = 652, z = -445, yaw = 0x8000},
            music = { name = "Watch Pause Theme - Goldeneye 64" }			
        },
        [19] = {
            level = LEVEL_SSL,
            area = 2,
            spawn = {x = 5, y = 20, z = 510, yaw = 0x8000},
            music = { name = "Watch Pause Theme - Goldeneye 64" }			
        },
        [20] = {
            level = LEVEL_DDD,
            area = 2,
            spawn = {x = 110, y = 20, z = 150, yaw = 0x8000},
            music = { name = "Watch Pause Theme - Goldeneye 64" }			
        },
        [21] = {
            level = LEVEL_SL,
            area = 2,
            spawn = {x = 170, y = 20, z = 340, yaw = 0x8000},
            music = { name = "Watch Pause Theme - Goldeneye 64" }			
        },
        [22] = {
            level = LEVEL_SL,
            area = 3,
            spawn = {x = 50, y = 1975, z = -450, yaw = 0x4000},
            music = { name = "Fight - Mike Tyson's Punch-Out!" }			
        },
        [23] = {
            level = LEVEL_TTM,
            area = 2,
            spawn = {x = 0, y = 742, z = 0, yaw = 0x4000},
            music = { name = "Dreamer - Streets of Rage 2" }			
        },
        [24] = {
            level = LEVEL_SA,
            area = 6,
            spawn = {x = -10, y = 0, z = 1575, yaw = 0x8000},
            music = { name = "Animal Crossing Results - Mario Kart 8" }
        },
        [25] = {
            level = LEVEL_VCUTM,
            area = 2,
            spawn = {x = -10, y = 122, z = 1370, yaw = 0x8000},
            music = { name = "Back Alley Heist - Sly Copper and the Thievius Raccoonus" }			
        },
        [26] = {
            level = LEVEL_WMOTR,
            area = 1,
            spawn = {x = -15, y = 0, z = 45, yaw = 0x8000},
            music = { name = "Puzzle - Professor Layton and the Curious Village" },
            launchpads = {
                { x = 10, y = 0, z = -2700, yaw = 0x8000, vel = 50, forwardVel = 50 }
            }
        },
        [27] = {
            level = LEVEL_WMOTR,
            area = 2,
            spawn = {x = 0, y = 0, z = -1820, yaw = 0x8000},
            music = { name = "Puzzle - Professor Layton and the Curious Village" },
            launchpads = {
                { x = 0, y = 0, z = -2690, yaw = 0x8000, vel = 50, forwardVel = 50 }
            }			
        },
        [28] = {
            level = LEVEL_WMOTR,
            area = 3,
            spawn = {x = 0, y = 0, z = -1820, yaw = 0x8000},
            music = { name = "Puzzle - Professor Layton and the Curious Village" },
            launchpads = {
                { x = 0, y = 0, z = -2690, yaw = 0x8000, vel = 50, forwardVel = 50 }
            }
        },
        [29] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = 20, y = 83, z = 3900, yaw = 0x8000},
            music = { name = "Max Heat - Mega Man Zero 4" }			
        },
        [30] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = -5, y = 115, z = 2065, yaw = 0x8000},
            music = { name = "It's a Monster - The Legend of the Mystical Ninja" }			
        },
        [31] = {
            level = LEVEL_BOWSER_3,
            area = 1,
            spawn = {x = -5, y = 0, z = 1320, yaw = 0x8000},
            music = { name = "Burning My Soul (Edo Castle) - Mystical Ninja 2: Goemon's Great Adventure" }			
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -3460, y = 2880, z = -7050, yaw = 0x6000 },
            speed = 2.75,
            author = "GooseDaJuice",
            type = FLOOD_WATER,		
            floodScale = 2,	
            music = { name = "City Escape - Sonic Adventure 2" }			
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 6217, y =  539, z = -10902, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "GooseDaJuice",
            type = FLOOD_WATER,
            floodScale = 1.5,
            unwantedBhvs = { id_bhvExclamationBox },			
            music = { name = "12 PM - Animal Crossing: New Horizons" }
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 2,
            flagPos = { x = -1930, y = 790, z = -810, yaw = 0x4000 },
            speed = 2.0,
            author = "GooseDaJuice",
            type = FLOOD_WATER,
            floodHeight = -3500,
            overrideName = "Factory Warehouse",
            music = { name = "Factory Investigation - Kirby 64: The Crystal Shards" }			
        },
        {
            name = "wf3",
            level = LEVEL_WF,
            area = 3,
            flagPos = { x = 600, y = 1965, z = -8300, yaw = -0x4000 },
            speed = 1.25,
            author = "GooseDaJuice",
            type = FLOOD_DARKNESS,
            overrideName = "Bottomless Basement",
            music = { name = "Underground Sewer - Chrono Trigger" }			
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -1655, y = 3109, z =  -2200, yaw =  0x4000 },
            speed = 3.0,
            author = "GooseDaJuice",
            type = FLOOD_WATER,
            floodScale = 2.5,
            unwantedBhvs = { id_bhvMetalCap },			
            music = { name = "Orange Ocean - Kirby's Adventure" }
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 2,
            flagPos = { x = 80, y = 2100, z = -4030, yaw = 0x0000 },
            speed = 7.0,
            author = "GooseDaJuice",
            type = FLOOD_WATER,
            startPos = { x = 470, y = 1403, z = 2140, yaw = 0x8000, airborne = true },
            overrideName = "Treasure Cove",
            music = { name = "Cave Dungeon - Super Mario 64" }			
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -6680, y = 6945, z = -14270, yaw = -0x2000 },
            flagBase = true,
            speed = 2.5,
            author = "GooseDaJuice",
            type = FLOOD_SAND,
            floodScale = 2,
            music = { name = "Town - Wild Arms" }			
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = 490, y = -420, z = -17470, yaw = 0x0000 },
            flagBase = true,
            speed = 1.25,
            author = "GooseDaJuice",
            type = FLOOD_SAND,
            floodScale = 1.75,
            unwantedBhvs = { id_bhvKoopa },
            overrideName = "Guarded Entrance To The Palace",
            floodHeight = -1865,	
            music = { name = "Hyrule Temple - Super Smash Bros. Melee" }			
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -6365, y = 2450, z =  -5285, yaw =  0x2000 },
            flagBase = true,
            speed = 2.0,
            author = "GooseDaJuice",
            type = FLOOD_ACID,
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },			
            floodHeight = -1190,
            music = { name = "Secret Ways - Phantasy Star II" }
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 3,
            flagPos = { x = 425, y = 5479, z = 2090, yaw = -0x6000 },
            flagBase = true,
            speed = 5.5,
            author = "GooseDaJuice",
            type = FLOOD_ACID,
            overrideName = "Secret Of The Slime Pillar",
            overrideWater = true,
            floodHeight = -2750,
            music = { name = "Secret Ways - Phantasy Star II" }			
        },
        {						
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 1260, y = 1565, z = -19120, yaw = 0x0000 },
            flagBase = true,
            speed = 1.0,
            author = "GooseDaJuice",
            type = FLOOD_WATER,			
            startPos = { x = 10, y =  385, z =  4310, yaw =  0x8000, airborne = false },	
            floodScale = 2,		 
            unwantedBhvs = { id_bhvFadingWarp },
            music = { name = "Cave Dungeon - Super Mario 64" }
        },
        {						
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -30, y = 9095, z = 10, yaw = -0x6000 },
            flagBase = true,
            speed = 2.5,
            author = "GooseDaJuice",
            type = FLOOD_WATER,		
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = 2285,
            music = { name = "Atletic - Super Mario World" }			
        },
        {						
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -5367, y = 4613, z =  -9473, yaw =  0x4000 },
            flagBase = true,
            speed = 2.25,
            author = "GooseDaJuice",
            type = FLOOD_RAINBOW,		
            floodScale = 1.5,
            floodHeight = -1750,
            music = { name = "Dreamer - Streets of Rage 2" }
        },
        {						
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -8900, y = 4300, z = 3744, yaw = 0x4000 },
            flagBase = true,
            speed = 3.25,
            author = "GooseDaJuice",
            type = FLOOD_VOLCANO,
            floodScale = 2,
            music = { name = "Orc 2 - Warcraft II: Tides of Darkness/Beyond the Dark Portal" }			
        },
        {						
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 0, y = 9635, z = -3695, yaw =  0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "GooseDaJuice",
            type = FLOOD_CLOUDS,
            floodScale = 2.5,
            floodHeight = 4900,					
            capTimer = 150,
            music = { name = "Wood Field - Mega Man Soccer" }			
        },
        {						
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 10491, y = 2759, z =  -8326, yaw =  0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "GooseDaJuice",
            type = FLOOD_WASTE,			
            floodHeight = -1750,	
            floodScale = 2,
            music = { name = "Clocktowers Beneath the Sea - A Hat in Time" }			
        },
        {						
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 11512, y = 5123, z =    311, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "GooseDaJuice",
            type = FLOOD_SNOW,
            unwantedBhvs = { id_bhvExclamationBox },
            music = { name = "Walrus Cove - Diddy Kong Racing" }			
        },
        {						
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 5705, y = 3245, z = -9120, yaw = -4785 },
            speed = 1.75,
            author = "GooseDaJuice",
            type = FLOOD_VOLCANO,
            floodScale = 1.5,
            startPos = { x = 19140, y = -191, z = 6950, yaw =  0x8000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },
            music = { name = "Mt. Boom - Ty the Tasmanian Tiger 2: Bush Rescue" }			
        },
        {						
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 1777, y = 2142, z = -1436, yaw = 0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "GooseDaJuice",
            type = FLOOD_DARKNESS,
            floodScale = 1.5,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },
            floodHeight = -1500,			
            music = { name = "Horror Land - Mario Party 2" }
        },
        {						
            name = "ddd2",
            level = LEVEL_DDD,
            area = 3,
            flagPos = { x = -5115, y = -18, z = 1510, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "GooseDaJuice",
            type = FLOOD_DARKNESS,
            unwantedBhvs = { id_bhvKoopa },		
            floodHeight = -2500,
            overrideName = "Poker Table Quickster",
            music = { name = "Hyrule Temple - Super Smash Bros. Melee" }			
        },
        {						
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 1454, y = 2577, z =  -2577, yaw = -0x4000 },
            speed = 2.25,
            author = "GooseDaJuice",
            type = FLOOD_DARKNESS,
            music = { name = "Back Alley Heist - Sly Copper and the Thievius Raccoonus" }			
        },
        {						
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -6205, y = 1500, z = -4370, yaw = 0x0000 },
            speed = 2.0,
            author = "GooseDaJuice",
            type = FLOOD_MAGMA,
            floodScale = 1.5,
            floodHeight = -2050,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Map - Star Fox 64" }			
        },
        {						
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 429, y = 3034, z =   -691, yaw =  0x6000 },
            speed = 2.0,
            author = "GooseDaJuice",
            type = FLOOD_SAND,	
            floodHeight = -450,
            music = { name = "Quick Man - Mega Man II (NES)" }			
        },
        {						
            name = "ttc2",
            level = LEVEL_TTC,
            area = 2,
            flagPos = { x = 0, y = 1360, z = 5635, yaw = 0x8000 },
            flagBase = true,
            speed = 5.0,
            author = "GooseDaJuice",
            type = FLOOD_WATER,	
            startPos = { x = 0, y = 244, z = -2445, yaw =  0x0000, airborne = true },
            overrideName = "Secret King's Hideout"
        },
        {						
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -6610, y = -210, z = -28610, yaw =  0x0000 },
            speed = 0.75,
            author = "GooseDaJuice",
            type = FLOOD_SAND,		
            floodHeight = -3475,
            floodScale = 3,
            music = { name = "Main Theme - Halo" }			
        },
        {						
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 7618, y = 2917, z = -6959, yaw = 0x2000 },
            flagBase = true,
            speed = 1.0,
            author = "GooseDaJuice",
            type = FLOOD_POISON,	
            floodScale = 2.5,
            unwantedBhvs = { id_bhvExclamationBox },			
            floodHeight = -1500,
            music = { name = "Invasion of Evil Spirits - The Legend of the Mystical Ninja" }			
        },
        {						
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 4746, y = 3244, z =  -2750, yaw =  0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "GooseDaJuice",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvExclamationBox },			
            music = { name = "Winter Bliss - Castle Crashers" }			
        },
        {						
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 4690, y = 580, z = -25485, yaw = -19480 },
            speed = 1.0,
            author = "GooseDaJuice",
            type = FLOOD_MAGMA,
            floodScale = 2.5,
            floodHeight = -2500,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Rave Dance Tune (Bonus Stage) - Cool Spot" }
        },
        {						
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -3740, y = 2615, z = -9920, yaw = 0x8000 },
            speed = 6.0,
            author = "GooseDaJuice",
            type = FLOOD_WATER,
            startPos = { x = 2790, y = 99, z = -3660, yaw = 0x8000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideSlide = true,
            music = { name = "Race to Win - Sonic Rivals 2" }			
        },
        {						
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = -285, y = 1910, z = 8251, yaw = -0x6000 },
            flagBase = true,
            speed = 3.5,
            author = "GooseDaJuice",
            type = FLOOD_WATER,			
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBooWithCage, id_bhvBooCage },
            overrideName = "Deep Woods",
            music = { name = "Yamato - Mystical Ninja: Starring Goemon | 2nd Music: Grande Finale - Yoshi's Story" }			
        },
        {						
            name = "c",
            level = LEVEL_CASTLE,
            area = 3,
            flagPos = { x = -16850, y = 1090, z = -14680, yaw = 0x6000 },
            flagBase = true,
            speed = 1.75,
            author = "GooseDaJuice",
            type = FLOOD_DARKNESS,		
            startPos = { x = -42, y = 0, z = 2362, yaw = 0x8000, airborne = false, pipe = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Minigame Mayhem!",
            music = { name = "Airship - Super Mario Bros 3." }
        }
    }
end

-- Mario in the Colorful Lands, ported to Flood by SausRelics
local function flood_load_mario_in_the_colorful_lands_levels()
    game = GAME_COLORFUL_LANDS
    romhackInfo = "Mario in the Colorful Lands"
	romhackLogo = get_texture_info("logo_mitcl")	
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 5029, y = -1, z = -10717, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 2026, y = 2599, z = -15866, yaw = 0x0000 },
            speed = 1.3,
            author = "BlueToonYoshi",
            type = FLOOD_WATER,
            startPos = { x = 15626, y = -158, z = -4843, yaw = 0x0000 },
            floodScale = 2
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 9004, y = 4267, z = -3294, yaw = -0x4000 },
            speed = 3.0,
            author = "BlueToonYoshi",
            type = FLOOD_WATER,
            startPos = { x = 3692, y = 912, z = -1585, yaw = 0x0000 },
            floodScale = 2
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 13950, y = 7713, z = -2312, yaw = 0x8000 },
            speed = 3.0,
            author = "BlueToonYoshi",
            type = FLOOD_MOLTEN,
            startPos = { x = 18720, y = 2967, z = -12313, yaw = 0x0000 },
            floodScale = 3
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 2403, y = 5135, z = -13301, yaw = 0x6000 },
            speed = 2.9,
            author = "BlueToonYoshi",
            type = FLOOD_WATER,
            startPos = { x = 4305, y = 261, z = -328, yaw = 0x8000 },
            floodScale = 4,
            overrideName = "Waterfall Sky Isles"
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 2932, y = 12955, z = -8256, yaw = -0x4000 },
            speed = 5.0,
            author = "BlueToonYoshi",
            type = FLOOD_DARKNESS,
            startPos = { x = 4504, y = 873, z = -2322, yaw = 0x0000 }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 7449, y = 5370, z = -1810, yaw = 0x8000 },
            speed = 5.2,
            author = "BlueToonYoshi",
            type = FLOOD_SNOW,
            startPos = { x = 6834, y = 466, z = -9315, yaw = 0x0000 },
            floodScale = 2
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 10368, y = 10622, z = -10437, yaw = 0x8000 },
            speed = 3.0,
            author = "BlueToonYoshi",
            type = FLOOD_WATER,
            startPos = { x = 6952, y = 5920, z = -11485, yaw = 0x0000 },
            floodScale = 3,
            overrideName = "Wacky Woodland"
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 5508, y = 6132, z = -6779, yaw = 0x0000 },
            speed = 2.5,
            author = "BlueToonYoshi",
            type = FLOOD_COTTON,
            startPos = { x = 2335, y = 481, z = -888, yaw = 0x0000 },
            floodScale = 2
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 18834, y = 1392, z = 738, yaw = 0x8000 },
            speed = 2.0,
            author = "BlueToonYoshi",
            type = FLOOD_RAINBOW,
            startPos = { x = 2063, y = 407, z = -5482, yaw = 0x0000 },
            floodScale = 3
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 7004, y = 10456, z = -9121, yaw = 0x4000 },
            speed = 1.8,
            author = "BlueToonYoshi",
            type = FLOOD_SNOW,
            startPos = { x = 11153, y = 6191, z = -2385, yaw = 0x0000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
    }
end

-- Super Mario and the Cursed Castles, ported to Flood by Jzzay, Bear64DX & ★~¡TOÑO!~★
local function flood_load_cursed_castles_levels()
    game = GAME_CURSED_CASTLES
    romhackInfo = "Super Mario and the Cursed Castles"
	romhackLogo = get_texture_info("logo_cc")
    gLobbies = {
        [1] = {
            level = LEVEL_LLL,
            area = 1,
            spawn = {x = 8940, y = 0, z = -4601, yaw = 0x0000},
            music = { name = "City Jazz - by Richard Hill [Technomancer]" }			
        },
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 3,
            spawn = {x = 765, y = 0, z = 7755, yaw = 0x8000},
            music = { name = "Castle Walls (Major) - by Richard Hill [Technomancer]" },			
            pipes = {
                {
                    { x = -575, y = 0, z = -1435 },
                    { x = -575, y = 0, z = -5350, yaw = 0x8000 }
                }
            }			
        },
        [3] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 2,
            spawn = {x = 2156, y = 0, z = -210, yaw = 0x8000},
            music = { name = "Castle Walls (Minor) - by Richard Hill [Technomancer]" }
        },
        [4] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 3710, y = 0, z = -690, yaw = 0x8000},
            music = { name = "Castle Walls (Minor) - by Richard Hill [Technomancer]" }			
        },
        [5] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 2203, y = 0, z = -6781, yaw = 0x0000},
            music = { name = "Castle Walls (Minor) - by Richard Hill [Technomancer]" }			
        },
        [6] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = 1025, y = 0, z = -1620, yaw = 0x8000},
            music = { name = "Piranha Plant's Lullaby - Super Mario 64" }			
        },
        [7] = {
            level = LEVEL_RR,
            area = 2,
            spawn = {x = 1560, y = 0, z = -180, yaw = 0x8000},
            overrideWater = true,
            music = { name = "Space - by Richard Hill [Technomancer]" }			
        },
        [8] = {
            level = LEVEL_LLL,
            area = 2,
            spawn = {x = 5935, y = 2531, z = -2280, yaw = 0x8000},
            music = { name = "City Jazz - by Richard Hill [Technomancer]" }			
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -2718, y = 5789, z = -8326, yaw = 0x4000 },
            speed = 4.0,
            author = "Foxen",
            type = FLOOD_WATER,
            floodScale = 3,
            floodHeight = -3100,
            music = { name = "Tetris - by Richard Hill [Technomancer]" }
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 20980, y = 5134, z = -12904, yaw = -0x4000 },
            speed = 2.5,
            author = "Foxen",
            type = FLOOD_WATER,
            startPos = { x = 14565, y = -697, z = -2253, yaw = 0x4000 },
            floodScale = 3,
            overrideName = "Twisting Atop T-Spin Tower",
            music = { name = "Tetris - by Richard Hill [Technomancer]" }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 6622, y = 5347, z = 2679, yaw = 0x4000 },
            flagBase = true,
            speed = 3.6,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = 3570, y = 450, z = 2676, yaw = 0x4000 },
            floodScale = 2.5, 
            floodHeight = -2000,
            music = { name = "Blava (Blue Lava) - by Richard Hill [Technomancer]" }			
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 11383, y = 5267, z = -9204, yaw = -0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "Foxen",
            type = FLOOD_WATER,
            startPos = { x = -4631, y = 268, z = -9221, yaw = 0x4000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhv1Up }, 
            overrideName = "Port O'Bella",
            music = { name = "PortObello - by Richard Hill [Technomancer]" }			
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 4670, y = 4740, z = -155, yaw = -0x4000 },	
            speed = 2.5,
            author = "Foxen",
            type = FLOOD_WATER,
            startPos = { x = -5465, y = 269, z = -10474, yaw = 0x1000 },
            floodScale = 2.5,
            overrideName = "Inspect The Luminous Lighthouse",
            music = { name = "PortObello - by Richard Hill [Technomancer]" }			
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -4656, y = 5850, z = -1948, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "Foxen",
            type = FLOOD_LAVA,
            startPos = { x = 15, y = -528, z = 2530, yaw = 0x8000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvExclamationBox },
            music = { name = "Blava (Blue Lava) - by Richard Hill [Technomancer]" }			
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 4960, y = 4409, z = 781, yaw = -0x4000 },
            flagBase = true,			
            speed = 3.7,
            author = "Foxen",
            type = FLOOD_LAVA,
            startPos = { x = 1735, y = -528, z = -390, yaw = 0x2000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Hop To The Top",
            music = { name = "Blava (Blue Lava) - by Richard Hill [Technomancer]" }			
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -12265, y = 5391, z = 5884, yaw = 0x6000 },
            flagBase = true,
            speed = 2.0,
            author = "Foxen",
            type = FLOOD_SAND,
            startPos = { x = -14355, y = -28, z = -17840, yaw = 0x4000 },			
            floodScale = 3,
            floodHeight = -2250,
            music = { name = "Sand Castle - by Richard Hill [Technomancer]" }			
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -1200, y = 2605, z = -8545, yaw = 0x5000 },
            flagBase = true,
            speed = 3.5,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = 10681, y = 790, z = -15382, yaw = -10940 },
            floodScale = 2.5,
            overrideName = "King Boo's Blue Pathway",
            music = { name = "Boo Mansion - by Richard Hill [Technomancer]" }			
        },
        {
            name = "bitdw2",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 19815, y = 4837, z = -11335, yaw = -0x1500 },
            flagBase = true,
            speed = 4.6,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = 12551, y = 790, z = -15205, yaw = 11089 },
            floodScale = 2.5,
            overrideName = "King Boo's Green Pathway",
            music = { name = "Boo Mansion - by Richard Hill [Technomancer]" }			
        },
        {
            name = "bitdw3",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 4935, y = 4496, z = -21434, yaw = 0x4000 },
            flagBase = true,
            speed = 4.6,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = 11515, y = 790, z = -16997, yaw = 0x8000 },
            floodScale = 2.5,
            overrideName = "King Boo's Pink Pathway",
            music = { name = "Boo Mansion - by Richard Hill [Technomancer]" }			
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 14975, y = 6692, z = -5052, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Foxen",
            type = FLOOD_WATER,
            startPos = { x = 10813, y = 0, z = -4243, yaw = 0x4000 },
            floodScale = 3,
            music = { name = "Boo Mansion - by Richard Hill [Technomancer]" }			
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 15304, y = 7007, z = -8734, yaw = -0x4000 },
            speed = 3.0,
            author = "Foxen",
            type = FLOOD_SNOW,
            startPos = { x = 2025, y = 0, z = -11344, yaw = 0x4000 },
            floodScale = 2.5,
            music = { name = "City Jazz - by Richard Hill [Technomancer]" }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -260, y = 7673, z = 335, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "Foxen",
            type = FLOOD_CLOUDS,
            startPos = { x = 10305, y = 2600, z = 10650, yaw = 0x8000 },
            floodScale = 3,
            floodHeight = 300,
            music = { name = "Sky Temple - by Richard Hill [Technomancer]" }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 8476, y = 4319, z = 9742, yaw = 0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "Foxen",
            type = FLOOD_FROSTBITE,
            startPos = { x = -27, y = 744, z = -11112, yaw = 0x0000 },
            floodScale = 2.5,
            floodHeight = -2000,
            music = { name = "Sand Castle - by Richard Hill [Technomancer]" }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -316, y = 9532, z = 4621, yaw = 0x4000 },
            flagBase = true,			
            speed = 2.5,
            author = "Foxen",
            type = FLOOD_SAND,
            floodScale = 3,
            floodHeight = 330,
            music = { name = "Canyon - by Richard Hill [Technomancer]" }
        },
        {
            name = "sl2",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -6646, y = -631, z = -21495, yaw = 0x0000 },		
            speed = 3.25,
            author = "Foxen",
            type = FLOOD_WATER,
            startPos = { x = -7128, y = -5586, z = 5730, yaw = -0x8000 },
            floodScale = 3,
            overrideName = "Rumble In The Raging Ravine",
            floodHeight = -9880,
            music = { name = "Canyon - by Richard Hill [Technomancer]" }			
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 14580, y = 7587, z = -670, yaw = -0x6000 },
            speed = 3.5,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = 900, y = 0, z = -1325, yaw = 0x4000 },
            floodScale = 2.5,
            overrideName = "King Boo's Stairs",
            music = { name = "Boo Mansion - by Richard Hill [Technomancer]" }			
        },
        {
            name = "bitfs2",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -40, y = 5507, z = -8960, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = -40, y = 0, z = -1900, yaw = 0x8000 },
            floodScale = 2.5,
            overrideName = "King Boo's Flaming Traps",			
            music = { name = "Boo Mansion - by Richard Hill [Technomancer]" }			
        },
        {
            name = "bitfs3",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -19845, y = 5090, z = -1345, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = -900, y = 0, z = -1325, yaw = -0x4000 },
            floodScale = 2.5,
            overrideName = "King Boo's Throne ",			
            music = { name = "Boo Mansion - by Richard Hill [Technomancer]" }
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -510, y = 3540, z = -13545, yaw = 0x4000 },
            speed = 1.5,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = 14282, y = 201, z = -6766, yaw = 0x8000 },
            floodScale = 2.5,
            music = { name = "Boo Mansion - by Richard Hill [Technomancer]" }			
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 13548, y = 11508, z = -1607, yaw = 0x3000 },
            flagBase = true,			
            speed = 3.0,
            author = "Foxen",
            type = FLOOD_WASTE,
            startPos = { x = 2123, y = 5524, z = -1545, yaw = 0x4000 },			
            floodScale = 3,
            floodHeight = 2500,
            music = { name = "Treetops - by Richard Hill [Technomancer]" }			
        },
        {
            name = "ttm2",
            level = LEVEL_TTM,
            area = 2,
            flagPos = { x = 5280, y = 14602, z = 10115, yaw = 19925 },
            flagBase = true,			
            speed = 6.5,
            author = "Foxen",
            type = FLOOD_WASTE,
            startPos = { x = -5795, y = 1154, z = -685, yaw = 22855 },
            floodScale = 3,
            overrideName = "Wild Ride Up Sycamore Slide",
            floodHeight = -2250,
            launchpads = {
                { x = 8145, y = 4480, z = -10055, yaw = 0x4000, vel = 100, forwardVel = 0 },
            },			
            overrideSlide = true,		
            music = { name = "Treetops - by Richard Hill [Technomancer]" }			
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -8935, y = 7410, z = -10145, yaw = 0x2000 },
            flagBase = true,
            speed = 2.5,
            author = "Foxen",
            type = FLOOD_SULFUR,
            startPos = { x = 10604, y = 1512, z = 10019, yaw = 0x8000 },
            floodScale = 2.5,
            floodHeight = -1750,
            music = { name = "Blava (Blue Lava) - by Richard Hill [Technomancer]" }			
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 3272, y = 3893, z = 4331, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Foxen",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -1750,
            music = { name = "City Jazz - by Richard Hill [Technomancer]" }
        },
        {
            name = "ttc2",
            level = LEVEL_TTC,
            area = 2,
            flagPos = { x = 6575, y = 5210, z = -1035, yaw = 0x8000 },
            flagBase = true,
            speed = 2.0,
            author = "Foxen",
            type = FLOOD_MUD,
            startPos = { x = 3836, y = 3886, z = -1019, yaw = 0x0000 },
            floodScale = 2,
            overrideName = "Introduction To Myrmecology",
            music = { name = "City Jazz - by Richard Hill [Technomancer]" }			
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 7380, y = 11089, z = 2790, yaw = 0x0000 },
            flagBase = true,
            speed = 4.5,
            author = "Foxen",
            type = FLOOD_OPTIC,
            floodScale = 2.5,
            music = { name = "Space - by Richard Hill [Technomancer]" }					
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -14180, y = 6325, z = -6372, yaw = 0x8000 },
            speed = 3.0,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = -440, y = 2087, z = -755, yaw = -0x4000 },
            floodScale = 3,
            overrideName = "King Boo's Blue Castle",
            music = { name = "Boo Mansion - by Richard Hill [Technomancer]" }			
        },
        {
            name = "bits2",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 10480, y = 3599, z = -4805, yaw = 12660 },
            flagBase = true,
            speed = 2.75,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = 2405, y = 2087, z = -675, yaw = 0x4000 },
            floodScale = 3,
            overrideName = "King Boo's Green Castle",
            music = { name = "Boo Mansion - by Richard Hill [Technomancer]" }
        },
        {
            name = "bits3",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 1473, y = 4868, z = -8545, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = 1070, y = 2087, z = -1915, yaw = 0x8000, airborne = true },
            floodScale = 3,
            overrideName = "King Boo's Purple Castle",
            music = { name = "Boo Mansion - by Richard Hill [Technomancer]" }				
        },
        {
            name = "cg2",
            level = LEVEL_CASTLE_GROUNDS,
            area = 2,
            flagPos = { x = 2090, y = 2104, z = -585, yaw = 0x8000 },
            flagBase = true,
            speed = 3.25,
            author = "Foxen",
            type = FLOOD_WATER,
            startPos = { x = 2085, y = 0, z = -210, yaw = 0x8000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "Blue Cursed Castle",
            music = { name = "Castle Walls (Minor) - by Richard Hill [Technomancer]" }
        },
        {
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 11055, y =   1625, z =  -5490, yaw = -0x4000 },
            flagBase = true,
            speed = 7.0,
            author = "Foxen",
            type = FLOOD_WATER,
            startPos = { x = 10360, y = -756, z = -1940, yaw = -0x4000 },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "Green Cursed Castle",
            music = { name = "Castle Walls (Minor) - by Richard Hill [Technomancer]" }			
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 2190, y = 2100, z = -8240, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "Foxen",
            type = FLOOD_WATER,
            startPos = { x = 2195, y = 0, z = -8490, yaw = 0x0000 },	
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "Purple Cursed Castle",
            music = { name = "Castle Walls (Minor) - by Richard Hill [Technomancer]" }			
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 3,
            flagPos = { x = 4670, y = 5085, z = 13700, yaw = -0x4000 },
            flagBase = true,
            speed = 3.5,
            author = "Foxen",
            type = FLOOD_WATER,
            startPos = { x = -575, y = 0, z = -1435, yaw = 0x0000 }, 
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "Outside Purified Castles",
            music = { name = "Castle Walls (Major) - by Richard Hill [Technomancer]" }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 12060, y = 8324, z = 1760, yaw = 0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Foxen",
            type = FLOOD_DARKNESS,
            startPos = { x = 519, y = 920, z = -3623, yaw = 0x0000, airborne = true },
            floodScale = 2.5,			
            music = { name = "Space - by Richard Hill [Technomancer]" }			
        }
    }
end

-- Mario's Nightmare 64, ported to Flood by Bear64DX & Jzzay
local function flood_load_nightmare_64_levels()
    game = GAME_MARIOS_NIGHTMARE_64
    romhackInfo = "Mario's Nightmare 64"
	romhackLogo = get_texture_info("logo_mn64")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -664, y = -240, z = 3389, yaw = 0x4000}
        },
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -2781, y = -924, z = -3169, yaw = 0x4000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -3749, y = 4711, z = -5483, yaw = 0x0000 },
            flagBase = false,
            speed = 3.3,
            author = "Apioeus",
            type = FLOOD_WATER,
            startPos = { x = 5049, y = -3538, z = -2613, yaw = -0x14000 }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 2276, y = -3341, z = 472, yaw = -0x4000 },
            flagBase = false,
            speed = 9.5,
            author = "Apioeus",
            type = FLOOD_WATER,
            startPos = nil
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -3322, y = 4729, z = 836, yaw = 0x9000 },
            flagBase = false,
            speed = 2.2,
            author = "Apioeus",
            type = FLOOD_WATER,
            startPos = nil
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 5976, y = 4672, z = -5222, yaw = 0x8000 },
            flagBase = false,
            speed = 4.2,
            author = "Apioeus",
            type = FLOOD_WATER,
            startPos = nil
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 5892, y = -1264, z = 3665, yaw = -0x4000 },
            flagBase = false,
            speed = 3.5,
            author = "Apioeus",
            type = FLOOD_LAVA,
            startPos = { x = -1740, y = -3167, z = 2690, yaw = 0x3000 }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -4711, y = 5432, z = 5243, yaw = 0x8000 },
            flagBase = false,
            speed = 1.8,
            author = "Apioeus",
            type = FLOOD_SAND,
            startPos = { x = 6357, y = 3135, z = 6193, yaw = 0x8000 }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 3796, y = -417, z = -285, yaw = -0x4000 },
            flagBase = false,
            speed = 6.0,
            author = "Apioeus",
            type = FLOOD_LAVA,
            startPos = { x = 148, y = -3917, z = -2354, yaw = 0x0000 }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 4145, y = 3986, z = 2820, yaw = -0x14000 },
            flagBase = false,
            speed = 2.3,
            author = "Apioeus",
            type = FLOOD_FROSTBITE,
            startPos = { x = 4787, y = -1899, z = -2019, yaw = -0x1000 }
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 5510, y = 1427, z = 3221, yaw = -0x4000 },
            flagBase = false,
            speed = 4.5,
            author = "Apioeus",
            type = FLOOD_MAGMA,
            startPos = { x = 5741, y = -5883, z = 2030, yaw = -0x2000 }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -1393, y = 4881, z = 2318, yaw = 0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "Apioeus",
            type = FLOOD_WATER,
            startPos = { x = 139, y = -3136, z = -1994, yaw = -0x10000 }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 329, y = 3835, z = 1521, yaw = 0x9990 },
            flagBase = false,
            speed = 4.8,
            author = "Apioeus",
            type = FLOOD_MAGMA,
            startPos = nil
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -6171, y = 4884, z = -5833, yaw = 0x4000 },
            flagBase = false,
            speed = 1.5,
            author = "Apioeus",
            type = FLOOD_LAVA,
            startPos = { x = -2447, y = -1717, z = -2127, yaw = -0x6000 }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -6229, y = 2903, z = 5166, yaw = 0x4000 },
            flagBase = false,
            speed = 1.0,
            author = "Apioeus",
            type = FLOOD_DARKNESS,
            startPos = { x = -6643, y = -2661, z = 5365, yaw = 0x2000 }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -2735, y = 1871, z = 1781, yaw = 0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "Apioeus",
            type = FLOOD_ACID,
            startPos = nil
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -4425, y = 6782, z = 4317, yaw = 0x8500 },
            flagBase = false,
            speed = 4.5,
            author = "Apioeus",
            type = FLOOD_LAVA,
            startPos = { x = 644, y = -5080, z = -577, yaw = -0x4000 },
            overrideName = "Bowser's Castle IV"
        },
    }
end

-- Star Revenge 1.5: Star Takeover Redone, ported to Flood by Bear64DX & ★~¡TOÑO!~★
local function flood_load_star_revenge_1_5_levels()
    game = GAME_STAR_REVENGE_1_5
    romhackInfo = "Star Revenge 1.5: Star Takeover Redone"
    romhackLogo = get_texture_info("logo_sr1.5r")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -3780, y = -2540, z = -2730, yaw = 0x4000},
            music = { name = "Meteor Shower - Animal Crossing" }			
        },	
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 9850, y = 1810, z = 2580, yaw = -0x4000},
            music = { name = "Overworld - Super Mario World 2: Yoshi's Island" }			
        },	
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 5460, y = -740, z = -1000, yaw = 0x8000},
            music = { name = "Welcome to Booster Tower - Super Mario RPG: Legend of the Seven Stars" }
        },	
        [4] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 0, y = -740, z = 740, yaw = 0x0000},
            music = { name = "Welcome to Booster Tower - Super Mario RPG: Legend of the Seven Stars" }			
        },	
        [5] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -5460, y = -740, z = -980, yaw = 0x8000},
            music = { name = "Welcome to Booster Tower - Super Mario RPG: Legend of the Seven Stars" }			
        },	
        [6] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = -410, y = -1500, z = 11880, yaw = 0x8000},
            unwantedBhvs = { id_bhvKoopa },
            music = { name = "Squeegee Clean - The Urbz: Sims in the City" }			
        },	
        [7] = {
            level = LEVEL_BITS,
            area = 1,
            spawn = {x = 5, y = -450, z = 1000, yaw = 0x8000},
            unwantedBhvs = { id_bhvFadingWarp, id_bhv1Up },
            music = { name = "Temple - Zelda II: The Adventure of Link" }			
        },	
        [8] = {
            level = LEVEL_WMOTR,
            area = 1,
            spawn = {x = 635, y = 1890, z = 1550, yaw = 0x0000},
            music = { name = "Dark Hallways - Luigi's Mansion" }			
        },	
        [9] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = 175, y = -512, z = 1180, yaw = 0x8000},
            music = { name = "Bowser's Theme - Super Mario 64" }
        },	
        [10] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = 0, y = -1685, z = 200, yaw = 0x8000},
            music = { name = "Beloved Tomboyish Girl - Touhou 6: Embodiment of Scarlet Devil" }
        },	
        [11] = {
            level = LEVEL_BOWSER_3,
            area = 1,
            spawn = {x = 0, y = 302, z = 1195, yaw = 0x8000},
            music = { name = "In the Final - Mario and Luigi Bowser's Inside Story" }			
        },	
        [12] = {
            level = LEVEL_RR,
            area = 1,
            spawn = {x = 1635, y = 2829, z = 0, yaw = -0x4000},			
            deathHeight = 2590,
            music = { name = "Broodals Battle - Super Mario Odyssey" }		
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 600, y = 4555, z =  -3090, yaw =  0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_TIDE,
            unwantedBhvs = { id_bhvExclamationBox },			
            floodHeight = -4775,
            music = { name = "Wigglytuff's Guild - Pokémon Mystery Dungeon: Explorers of Time/Darkness/Sky" }			
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 5720, y = 4480, z =  -5830, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 530, y = -1850, z = -4950, yaw =  0x0000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvFadingWarp },
            launchpads = {
                { x = -2540, y = 1540, z = -6350, yaw = 0x4000, vel = 100, forwardVel = 50, capTimer = 165 },
            },
            music = { name = "Sky High Zone - Sonic the Hedgehog 2 (8 Bits)" }			
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 0, y = 4920, z = -3620, yaw = 0x0000 },
            flagBase = true,
            speed = 3.5,
            author = "BroDute",
            type = FLOOD_CLOUDS,
            startPos = { x = -10, y = -2835, z = -4410, yaw =  0x0000, airborne = true },	
            floodScale = 2.5,		
            unwantedBhvs = { id_bhvExclamationBox },			
            launchpads = {
                { x = 0, y = -330, z = 4400, yaw = 0x0000, vel = 100, forwardVel = 130 },
            },
            music = { name = "Temporal Tower - Pokémon Mystery Dungeon: Explorers of Time/Darkness/Sky" }			
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -7099, y = 142, z = 9096, yaw = 0x9500 },
            flagBase = true,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 7065, y = -1561, z = -2663, yaw = -0x5000, airborne = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Blooper Bay 1 - Mario Golf: Toadstool Tour" }			
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 11317, y = 4485, z = 1027, yaw = 0x0000 },
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_SNOW,
            startPos = { x = 7785, y = -6000, z = -6160, yaw = -0x3000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },
            music = { name = "Sherbet Land / Frappe Snowland - Mario Kart 64" }			
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -5140, y = 6554, z = 1900, yaw = 0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_CLOUDS,
            startPos = { x = -10670, y = -4480, z = -1075, yaw =  0x0000, airborne = true },
            floodScale = 2.5,
            music = { name = "Sky Tower - Pokemon Mystery Dungeon: Red/Blue Rescue Team" }			
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 2770, y = 3330, z = 5950, yaw =  0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_FROSTBITE,
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Bowser's Theme (Snow Mountain Mix) - Super Mario 64" }			
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 5164, y = 3450, z = -5380, yaw = 0x8000 },
            flagBase = true,
            speed = 1.75,
            author = "BroDute",
            type = FLOOD_LAVA,
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            music = { name = "The Bridge People No Longer Cross - Touhou 11: Subterranean Animism" }			
	    },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -7750, y =  435, z =  15395, yaw =  0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_MAGMA,	
            floodScale = 2,		
            overrideName = "Magmatic Sewers",
            music = { name = "Caverns - Metal Gear Solid" }			
	    },
        {
            name = "cotmc2",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 8635, y = -1490, z = 5095, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_ACID,	
            startPos = { x = 2165, y = -3965, z = 3705, yaw = 0x0000, airborne = true },		
            floodScale = 2,	
            unwantedBhvs = { id_bhvExclamationBox },			
            overrideName = "Toxic Sewers",
            overrideWater = true,
            music = { name = "Caverns - Metal Gear Solid" }			
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -4345, y = 6828, z = 9964, yaw = 0x4000 },
            flagBase = true,
            speed = 5.5,
            author = "BroDute",
            type = FLOOD_SNOW,
            startPos = { x = 12878, y = -4952, z = 5013, yaw = 0x8000, airborne = true },
            floodScale = 2,			
            overrideSlide = true,
            music = { name = "Super Sonic Racing - Sonic R" }			
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 5642, y = 1754, z = -8287, yaw = 0x0000 },
            speed = 1.75,
            author = "BroDute",
            type = FLOOD_POISON,
            startPos = { x = -2628, y = -1573, z = 3888, yaw = 0x8000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },			
            music = { name = "Grasslands, All the Way - Mario & Luigi: Bowser's Inside Story" }			
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -6749, y = 3871, z = -3430, yaw = 0x4000 },
            flagBase = true,
            speed = 5.0,
            author = "BroDute",
            type = FLOOD_SUNSET,
            floodScale = 3,
            unwantedBhvs = { id_bhvKoopa, id_bhvExclamationBox },
            music = { name = "Gritzy Desert - Mario & Luigi: Partners in Time" }			
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -8100, y = 3300, z =  -6530, yaw =  0x2000 },
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_SAND,	
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },			
            floodHeight = -4350,
            music = { name = "Goron Mines - The Legend Of Zelda: Twilight Princess" }			
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 10971, y = 1572, z = -8422, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_MOLTEN,            	
            floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },			
            music = { name = "Sammer's Kingdom - Super Paper Mario" }			
        },
        {
            name = "ddd2",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 6520, y = 4870, z =   9890, yaw = 0x8000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_MOLTEN,            
            startPos = { x = 2740, y = -1820, z = 1310, yaw = 0x2000, airborne = true },
            floodScale = 3,			
            overrideName = "Oriental Mt. Kasai",
            floodHeight = -4700,
            unwantedBhvs = { id_bhvExclamationBox },			
            music = { name = "Sammer's Kingdom - Super Paper Mario" }			
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -3320, y = 3690, z = 1807, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 0, y = 1590, z = -1527, yaw = 0x0000, airborne = true },	
            floodScale = 2,
            music = { name = "Up on the Rooftop - Wario Land II" }			
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -6900, y = 3888, z = -3100, yaw = 0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SULFUR,
            floodHeight = -6500,
            unwantedBhvs = { id_bhvWarpPipe },			
            music = { name = "Ghost Attack - The Legend Of Zelda: Majora's Mask" }			
        },
        {
            name = "ending",
            level = LEVEL_ENDING,
            area = 1,
            flagPos = { x = -7070, y = 1499, z = 8350, yaw = 0x6000 },
            flagBase = true,
            speed = 5.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -65, y = -2250, z = 923, yaw = -29127 },
            floodScale = 1.5,			
            overrideName = "Peaceful Plains",
            music = { name = "Sky & Sea - Super Mario Sunshine" }			
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -6710, y = 251, z = -9588, yaw = 0x4000 },
            flagBase = true,
            speed = 1.25,
            author = "BroDute",
            type = FLOOD_MOLTEN,
            startPos = { x = 6623, y = -1778, z = -1267, yaw = -0x2000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Last Remote - Touhou 11: Subterranean Animism" }			
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 7770, y = 4040, z = -9365, yaw = 0x2000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 2771, y = -3326, z = 8261, yaw = 0x8000, airborne = true },
            floodScale = 2,
            music = { name = "The Forest of Hope - Pikmin" }			
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 590, y = 6635, z = 9180, yaw =  0x0000 },
            flagBase = true,
            speed = 2.75,
            author = "BroDute",
            type = FLOOD_RAINBOW,
            floodScale = 2,	
            floodHeight = -8000,
            pipes = {
                {
                    { x = -7545, y = 958, z = -5845 },
                    { x = -1640, y = 289, z = -4360, yaw = 0x8000 }
                },
                {		
                    { x = -8775, y = 2502, z = 6290 },
                    { x = -1640, y = 289, z = -4360, yaw = 0x8000 }
                },
            },
            music = { name = "Rainbow Road - Mario Kart 64" }			
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -6450, y = 1155, z = -11105, yaw =  0x0000},
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_MAGMA,	
            startPos = { x = -6030, y = -305, z = -2785, yaw = 0x8000, airborne = false, fading = true },	
            floodScale = 2,			
            overrideName = "Colorful Hexagon I - Lava",
            unwantedBhvs = { id_bhvFadingWarp, id_bhvWarpPipe, id_bhvExclamationBox },	
            music = { name = "Temple - Zelda II: The Adventure of Link" }
        },
        {
            name = "bits2",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 7300, y = 1480, z =  -6185, yaw =  0x2000},
            speed = 1.25,
            author = "BroDute",
            type = FLOOD_SAND,	
            startPos = { x = 5160, y = -305, z = -2435, yaw = 0x8000, airborne = false, fading = true },	
            floodScale = 2,					
            overrideName = "Colorful Hexagon II - Quicksand",		
            unwantedBhvs = { id_bhvFadingWarp, id_bhvWarpPipe },
            music = { name = "Temple - Zelda II: The Adventure of Link" }			
        },
        {
            name = "bits3",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -6420, y = 3100, z = 7930, yaw = -0x3000},
            speed = 1.25,
            author = "BroDute",
            type = FLOOD_WASTE,	
            startPos = { x = -4925, y = -305, z = 2270, yaw =  0x0000, airborne = false, fading = true },			
            floodScale = 2,					
            overrideName = "Colorful Hexagon III - Mud",		
            unwantedBhvs = { id_bhvFadingWarp, id_bhvWarpPipe },
            music = { name = "Temple - Zelda II: The Adventure of Link" }			
        },
        {
            name = "bits4",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 6040, y =  -30, z =   9585, yaw =  0x8000},
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_WATER,	
            startPos = { x = 6030, y = -305, z = 2800, yaw = 0x0000, airborne = false, fading = true },
            floodScale = 2,					
            overrideName = "Colorful Hexagon IV - Water",
            unwantedBhvs = { id_bhvFadingWarp, id_bhvWarpPipe },
            music = { name = "Temple - Zelda II: The Adventure of Link" }			
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 2210, y = 2970, z = -11150, yaw =  0x0000},
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_WATER,	
            startPos = { x = 600, y = 1030, z = -6345, yaw = 0x8000, airborne = false, pipe = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Secret Star Hide: Flower Land",
            music = { name = "Broodals Battle - Super Mario Odyssey" }
        },
        {
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 12160, y = 1950, z = 490, yaw =  0x4000},
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SAND,	
            startPos = { x = 6770, y = 1530, z = -10, yaw =  0x4000, airborne = false, pipe = true },	
            floodScale = 2,	
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Secret Star Hide: Sand Land",
            music = { name = "Broodals Battle - Super Mario Odyssey" }			
        },
        {
            name = "rr3",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 4115, y = 3230, z = 7520, yaw = -0x4000},
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SNOW,	
            startPos = { x = -1390, y = 910, z = 13640, yaw =  0x8000, airborne = false, pipe = true },		
            floodScale = 2,					
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "Secret Star Hide: Ice Land",
            music = { name = "Broodals Battle - Super Mario Odyssey" }
        },
        {
            name = "rr4",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -13280, y = 2990, z = 3305, yaw =  0x8000},
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_LAVA,	
            startPos = { x = -11810, y = 1010, z = 3600, yaw =  0x2000, airborne = false, pipe = true},			
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "Secret Star Hide: Lava Land",
            music = { name = "Broodals Battle - Super Mario Odyssey" }			
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 0, y = 0, z = -17185, yaw =  0x4000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_TIDE,
            floodScale = 2.5,
            overrideName = "Super Mario Bros 1-1",
            floodHeight = -2600,
            music = { name = "Overworld Theme - Super Mario All-Stars (Super Mario Bros.)" }			
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 14365, y = 2970, z =  -8350, yaw =  00000 },
            flagBase = true,
            speed = 1.75,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -3782, y = -2537, z = -2726, yaw = 0x4000, airborne = true },			
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "Meteor Courtyard",
            music = { name = "Meteor Shower - Animal Crossing" }			
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 6250, y = 3760, z = -9040, yaw =  0x0000 },
            flagBase = true,
            speed = 2.75,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 9810, y =  2000, z =  2510, yaw = -0x4000, airborne = true },				
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "Meteor Grounds",
            music = { name = "Overworld - Super Mario World 2: Yoshi's Island" }			
        }
    }
end

-- Star Revenge 5: Neo Blue Realm, ported to Flood by Bear64DX
local function flood_load_star_revenge_5_levels()
    game = GAME_STAR_REVENGE_5
    romhackInfo = "Star Revenge 5: Neo Blue Realm"
	romhackLogo = get_texture_info("logo_sr5")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 0, y = 0, z = 1015, yaw = 0x0000}
        },
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 7, y = 600, z = -1155, yaw = 0x8000}
        }
    }
    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 415, y = 2105, z = 7690, yaw = 0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -35, y = 0, z = -5, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 4647, y = 6022, z = 3149, yaw = 0x8000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_SUNSET,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox },
            overrideWater = true
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -6396, y = 5944, z = -22870, yaw = 0x4000 },
            flagBase = false,
            speed = 6.0,
            author = "BroDute",
            type = FLOOD_FROSTBITE,
            startPos = { x = 176, y = 1094, z = -9714, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox }
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 3,
            flagPos = { x = 416, y = 11493, z = 147, yaw = 0x8000 },
            flagBase = false,
            speed = 6.0,
            author = "BroDute",
            type = FLOOD_SNOW,
            startPos = { x = -6844, y = 674, z = -20281, yaw = 0x4000, airborne = false },
            floodScale = 3.5,
            overrideName = "Chilly Underground Slide",
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox },
            overrideSlide = true
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -4252, y = 600, z = -7847, yaw = 0x8000 },
            flagBase = false,
            speed = 3.2,
            author = "BroDute",
            type = FLOOD_LAVA,
            startPos = nil,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 663, y = 4500, z = -8660, yaw = -0x4000 },
            flagBase = false,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 1405, y = 0, z = 0, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -524, y = 9558, z = 5681, yaw = 0x8000 },
            flagBase = false,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 153, y = 150, z = -320, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 7421, y = 3781, z = 8374, yaw = -0x4000 },
            flagBase = false,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_DESERT,
            startPos = { x = -25, y = 450, z = -117, yaw = 0x12000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 7695, y = 2026, z = 8177, yaw = 0x0000 },
            flagBase = false,
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = nil,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 7996, y = 3749, z = -5106, yaw = 0x0000 },
            flagBase = false,
            speed = 1.3,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 21, y = 1500, z = 81, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -8068, y = -100, z = 9060, yaw = 0x4000 },
            flagBase = false,
            speed = 0.8,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -12489, y = -97, z = 3339, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox },
            overrideName = "BroDute Race"
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 234, y = 3518, z = 8470, yaw = 0x8000 },
            flagBase = false,
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -886, y = -3940, z = -4696, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox }
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -12304, y = 750, z = 2851, yaw = 0x4000 },
            flagBase = false,
            speed = 0.65,
            author = "BroDute",
            type = FLOOD_LAVA,
            startPos = { x = 4, y = 382, z = -743, yaw = 0x8000, airborne = false },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -168, y = -57, z = 2089, yaw = -0x4000 },
            flagBase = false,
            speed = 1.8,
            author = "BroDute",
            type = FLOOD_LAVA,
            startPos = { x = -7557, y = -2555, z = -1460, yaw = 0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBreakableBox }
        },
    }
end

-- Super Mario 64 Extra, ported to Flood by Jzzay
local function flood_load_super_mario_64_extra_levels()
    game = GAME_SUPER_MARIO_64_EXTRA
    romhackInfo = "Super Mario 64 Extra"
	romhackLogo = get_texture_info("logo_sm64extra")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -11576, y = 689, z = 10706, yaw = 0x8000}
        },
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 12825, y = 11637, z = -5031, yaw = 0x9000 },
            speed = 2.5,
            author = "Tomatobird8",
            type = FLOOD_WATER,
            startPos = { x = 12778, y = 583, z = 7532, yaw = 0x8700 },
            floodScale = 4,
            unwantedBhvs = { id_bhvFadingWarp },
             
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 5579, y = 1505, z = -5727, yaw = 0x0000 },
            speed = 1.0,
            author = "Tomatobird8",
            type = FLOOD_LAVA,
            startPos = { x = -11297, y = -2147, z = 10720, yaw = 0x8000 },
            floodScale = 3.5,
            unwantedBhvs = { id_bhvFadingWarp },
             
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 4644, y = 922, z = 922, yaw = 0x4000 },
            speed = 2.5,
            author = "Tomatobird8",
            type = FLOOD_LAVA,
            startPos = { x = 2692, y = -3512, z = -197, yaw = 0x0000 },
        },
        {
            name = "wf3",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -8571, y = 3629, z = -7940, yaw = 0x4000 },
            speed = 1.3,
            author = "Tomatobird8",
            type = FLOOD_LAVA,
            startPos = { x = -9535, y = -1060, z = -377, yaw = -0x6000 },
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 3493, y = 4815, z = 10627, yaw = 0x0000 },
            speed = 1.0,
            author = "Tomatobird8",
            type = FLOOD_CLOUDS,
            startPos = { x = 5914, y = 634, z = 17351, yaw = 0x8000 },
            floodScale = 3.5,
            unwantedBhvs = { id_bhvFadingWarp },
             
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -20117, y = -171, z = 20088, yaw = 0x0000 },
            speed = 1.0,
            author = "Tomatobird8",
            type = FLOOD_CLOUDS,
            startPos = { x = -15853, y = -5159, z = 19166, yaw = 0x8000 },
            floodScale = 3.5,
            unwantedBhvs = { id_bhvFadingWarp },
            overrideName = "Above the Tower",
             
        },
        {
            name = "jrb3",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 13587, y = 6634, z = -2950, yaw = 0x0000 },
            speed = 1.0,
            author = "Tomatobird8",
            type = FLOOD_CLOUDS,
            startPos = { x = 8108, y = -784, z = -14263, yaw = 0x8000 },
            floodScale = 3.5,
            unwantedBhvs = { id_bhvFadingWarp },
            overrideName = "Above the Mount",
             
        },
        {
            name = "jrb4",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 2054, y = 3563, z = -12092, yaw = 0x0000 },
            speed = 1.0,
            author = "Tomatobird8",
            type = FLOOD_CLOUDS,
            startPos = { x = 5973, y = -720, z = -14147, yaw = 0x8000 },
            floodScale = 3.5,
            unwantedBhvs = { id_bhvFadingWarp },
            overrideName = "Above the Pillars",
             
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 10187, y = 3501, z = -794, yaw = 0x8000 },
            speed = 1.0,
            author = "Tomatobird8",
            type = FLOOD_WATER,
            floodScale = 3.5,
            unwantedBhvs = { id_bhvFadingWarp },
            overrideName = "Frostbite Road",
             
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 5472, y = 17693, z = 4517, yaw = 0x0000 },
            speed = 1.0,
            author = "Tomatobird8",
            type = FLOOD_WATER,
            startPos = { x = -6307, y = -1944, z = -18006, yaw = 0x8000 },
            floodScale = 3.5,
            unwantedBhvs = { id_bhvFadingWarp },
             
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 1000, y = 1000, z = 1000, yaw = 0x0000 },
            speed = 1.0,
            author = "Tomatobird8",
            type = FLOOD_WATER,
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 1000, y = 1000, z = 1000, yaw = 0x0000 },
            speed = 1.0,
            author = "Tomatobird8",
            type = FLOOD_WATER,
        },
        {
            name = "pss2",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -9364, y = 5328, z = 89, yaw = 0x4000 },
            speed = 1.6,
            author = "Tomatobird8",
            type = FLOOD_MUD,
            startPos = { x = -3036, y = 1371, z = 17, yaw = -0x4000 },
        },
        {
            name = "pss3",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 1110, y = 6303, z = -9437, yaw = 0x4000 },
            speed = 1.7,
            author = "Tomatobird8",
            type = FLOOD_MUD,
            startPos = { x = -40, y = 2304, z = -3920, yaw = 0x8000 },
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 151, y = 0, z = -5685, yaw = 0x4000 },
            speed = 1.8,
            author = "Tomatobird8",
            type = FLOOD_WATER,
            startPos = { x = -11576, y = 689, z = 10706, yaw = 0x8000 },
        },
    }
end

-- Super Mario Odyssey 64, ported to Flood by Jzzay
local function flood_load_super_mario_odyssey_64_levels()
    game = GAME_SUPER_MARIO_ODYSSEY_64
    romhackInfo = "Super Mario Odyssey 64"
	romhackLogo = get_texture_info("logo_smo64")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -495, y = 941, z = -979, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -7688, y = 4540, z = 4363, yaw = 0x8000 },
            speed = 1.0,
            author = "Biobak and Kaze",
            type = FLOOD_CLOUDS,
            startPos = { x = -4296, y = 1036, z = -6913, yaw = 0x4000 },
            floodScale = 3,
             
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 2964, y = 9234, z = 5852, yaw = 0x9000 },
            speed = 2.0,
            author = "Biobak and Kaze",
            type = FLOOD_WATER,
            startPos = { x = -3978, y = 326, z = -16974, yaw = 0x3500 },
            floodScale = 4,
             
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -10875, y = -5848, z = -16831, yaw = 0x1500 },
            speed = 1.9,
            author = "Biobak and Kaze",
            type = FLOOD_WATER,
            startPos = { x = 7329, y = -9245, z = 19301, yaw = 0x8200 },
            floodScale = 3.5,
            unwantedBhvs = { id_bhvFadingWarp },
             
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -16154, y = -1749, z = -16007, yaw = 0x0000 },
            speed = 3.4,
            author = "Biobak and Kaze",
            type = FLOOD_SUNSET,
            floodScale = 3.5,
             
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 4749, y = 7000, z = -1002, yaw = -0x4000 },
            speed = 2.05,
            author = "Biobak and Kaze",
            type = FLOOD_WATER,
            startPos = { x = -1, y = 1000, z = 4550, yaw = 0x8000 },
            floodScale = 3.5,
             
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -2627, y = 4659, z = 6799, yaw = -0x4000 },
            speed = 2.1,
            author = "Biobak and Kaze",
            type = FLOOD_LAVA,
            floodScale = 3.5,
            unwantedBhvs = { id_bhvWarpPipe },
             
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 31185, y = -7531, z = 1228, yaw = -0x4000 },
            speed = 2.0,
            author = "Biobak and Kaze",
            type = FLOOD_POISON,
            floodScale = 3.5,
             
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 7497, y = 6000, z = -1001, yaw = 0x8000 },
            speed = 2.0,
            author = "Biobak and Kaze",
            type = FLOOD_LAVA,
            startPos = { x = -5468, y = 3000, z = 3750, yaw = 0x4000 },
            floodScale = 3.5,
             
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 13001, y = 1024, z = -30, yaw = -0x4000 },
            speed = 3.0,
            author = "Biobak and Kaze",
            type = FLOOD_FROSTBITE,
            startPos = { x = -121, y = 567, z = 3, yaw = 0x4000 },
            floodScale = 2,
             
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 4, y = -305, z = -4947, yaw = 0x0000 },
            speed = 5.75,
            author = "Biobak and Kaze",
            type = FLOOD_WATER,
            startPos = { x = 0, y = -665, z = 2604, yaw = 0x8000 }
        },
    }
end

-- Mario's Treasure Dome, ported to Flood by Bear64DX
local function flood_load_treasure_dome_levels()
    game = GAME_MARIOS_TREASURE_DOME
    romhackInfo = "Mario's Treasure Dome"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 7405, y = 928, z = -3650, yaw = 0x0000 },
            speed = 1.4,
            author = "Cryogeon",
            type = FLOOD_WATER,
            startPos = { x = 6794, y = -1144, z = 5173, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -1260, y = -920, z = -3205, yaw = -0x4000 },
            speed = 3.0,
            author = "Cryogeon",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 2461, y = -290, z = -785, yaw = 0x8000 },
            speed = 3.3,
            author = "Cryogeon",
            type = FLOOD_POISON,
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 1174, y = 2776, z = 1631, yaw = 0x8000 },
            speed = 3.5,
            author = "Cryogeon",
            type = FLOOD_LAVA,
            startPos = { x = 9110, y = -2209, z = -3305, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -6071, y = 2703, z = 8118, yaw = 0x8000 },
            speed = 3.0,
            author = "Cryogeon",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 1297, y = 4780, z = 4426, yaw = 0x8000 },
            speed = 1.7,
            author = "Cryogeon",
            type = FLOOD_LAVA,
            startPos = { x = 5071, y = -510, z = 3419, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -571, y = -3531, z = -11449, yaw = 0x0000 },
            speed = 2.3,
            author = "Cryogeon",
            type = FLOOD_WATER,
            startPos = { x = 3074, y = -7933, z = 3520, yaw = 0x9000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -3726, y = 2869, z = 5651, yaw = -0x4000 },
            speed = 2.0,
            author = "Cryogeon",
            type = FLOOD_DESERT,
            startPos = { x = 1595, y = -280, z = -2642, yaw = -0x2000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 4371, y = 3899, z = -1555, yaw = 0x0000 },
            speed = 4.0,
            author = "Cryogeon",
            type = FLOOD_WATER,
            startPos = { x = -5776, y = -3300, z = -501, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 305, y = 2828, z = -6367, yaw = 0x8000 },
            speed = 2.3,
            author = "Cryogeon",
            type = FLOOD_LAVA,
            startPos = { x = -1518, y = -18, z = 3420, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -2727, y = 1169, z = -3438, yaw = 0x4000 },
            speed = 2.3,
            author = "Cryogeon",
            type = FLOOD_LAVA,
            startPos = { x = -333, y = -570, z = 2761, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "pss2",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 2225, y = 675, z = 6310, yaw = -0x4000 },
            speed = 3.0,
            author = "Cryogeon",
            type = FLOOD_WATER,
            startPos = { x = -160, y = -2020, z = 1740, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -597, y = 1454, z = 4367, yaw = 0x8000 },
            speed = 2.6,
            author = "Cryogeon",
            type = FLOOD_WATER,
            startPos = { x = -3424, y = -169, z = -269, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
    }
end

-- Servus 64, ported to Flood by Jzzay
local function flood_load_servus_64_levels()
    game = GAME_SERVUS_64
    romhackInfo = "Servus 64"
	romhackLogo = get_texture_info("logo_servus64")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 7779, y = 2838, z = -4920, yaw = -0x4000 },
            speed = 1.5,
            author = "NBKevin98",
            type = FLOOD_WATER,
            startPos = { x = -933, y = 830, z = 719, yaw = 0x5000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -2804, y = 2692, z = -7280, yaw = 0x4000 },
            speed = 2.1,
            author = "NBKevin98",
            type = FLOOD_CLOUDS,
            startPos = { x = 99, y = 1033, z = -681, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 10044, y = 371, z = 1641, yaw = -0x4000 },
            speed = 2.7,
            author = "NBKevin98",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -3976, y = 6063, z = -3992, yaw = 0x0000 },
            speed = 2.5,
            author = "NBKevin98",
            type = FLOOD_FROSTBITE,
            startPos = { x = 2496, y = 2049, z = 4052, yaw = -0x6000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 14818, y = 2690, z = -14037, yaw = 0x0000 },
            speed = 0.7,
            author = "NBKevin98",
            type = FLOOD_POISON,
            startPos = { x = 7, y = 3024, z = 18, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -1677, y = 4567, z = -536, yaw = 0x5000 },
            speed = 2.5,
            author = "NBKevin98",
            type = FLOOD_LAVA,
            startPos = { x = 9903, y = 3381, z = 1475, yaw = -0x3000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cotmc2",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 12737, y = 3086, z = -21147, yaw = 0x4000 },
            speed = 0.7,
            author = "NBKevin98",
            type = FLOOD_LAVA,
            startPos = { x = 11895, y = 392, z = -8998, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 1275, y = 594, z = -698, yaw = -0x4000 },
            speed = 3.0,
            author = "NBKevin98",
            type = FLOOD_DARKNESS,
            startPos = { x = 2150, y = -3836, z = 38, yaw = 0x3000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "hmc2",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -14081, y = 13982, z = 6533, yaw = -0x4000 },
            speed = 2.4,
            author = "NBKevin98",
            type = FLOOD_SAND,
            startPos = { x = -14809, y = 11983, z = 5667, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -4139, y = 2367, z = -2445, yaw = 0x4000 },
            speed = 2.0,
            author = "NBKevin98",
            type = FLOOD_CLOUDS,
            startPos = { x = 2564, y = 482, z = 1266, yaw = -0x5000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 6161, y = 7405, z = 3015, yaw = 0x4000 },
            speed = 1.0,
            author = "NBKevin98",
            type = FLOOD_LAVA,
            startPos = { x = -3376, y = 488, z = -5475, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 14495, y = 4475, z = 3460, yaw = 0x8000 },
            speed = 0.5,
            author = "NBKevin98",
            type = FLOOD_LAVA,
            startPos = { x = -7495, y = 4626, z = 3374, yaw = 0x5000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -7168, y = 6567, z = 1419, yaw = 0x4000 },
            speed = 1.5,
            author = "NBKevin98",
            type = FLOOD_SAND,
            startPos = { x = -9770, y = 498, z = 5829, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 8101, y = 5534, z = -733, yaw = -0x1000 },
            speed = 0.75,
            author = "NBKevin98",
            type = FLOOD_LAVA,
            startPos = { x = -837, y = 3690, z = 9237, yaw = 0x6000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 25988, y = 8525, z = -4117, yaw = -0x4000 },
            speed = 0.5,
            author = "NBKevin98",
            type = FLOOD_SAND,
            startPos = { x = 4557, y = 3162, z = 1607, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -10323, y = 9952, z = -14549, yaw = 0x8000 },
            speed = 3.0,
            author = "NBKevin98",
            type = FLOOD_DARKNESS,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -1220, y = 3036, z = 7049, yaw = 0x9000 },
            speed = 2.0,
            author = "NBKevin98",
            type = FLOOD_ACID,
            startPos = { x = 2355, y = 912, z = 109, yaw = -0x5000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 720, y = 6453, z = 6704, yaw = 0x8000 },
            speed = 1.0,
            author = "NBKevin98",
            type = FLOOD_FROSTBITE,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 12703, y = 14048, z = 8178, yaw = 0x8000 },
            speed = 3.5,
            author = "NBKevin98",
            type = FLOOD_DARKNESS,
            startPos = { x = 1819, y = 1638, z = 7347, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 22, y = 7467, z = -10968, yaw = 0x0000 },
            speed = 3.5,
            author = "NBKevin98",
            type = FLOOD_CLOUDS,
            startPos = { x = -11, y = 7670, z = 698, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -22, y = 12305, z = 6269, yaw = 0x0000 },
            speed = 1.0,
            author = "NBKevin98",
            type = FLOOD_DESERT,
            startPos = { x = -953, y = 12753, z = -5555, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 778, y = 3146, z = 20658, yaw = -0x4000 },
            speed = 15.0,
            author = "NBKevin98",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 493, y = 9347, z = -1666, yaw = 0x4000 },
            speed = 4.0,
            author = "NBKevin98",
            type = FLOOD_ACID,
            startPos = { x = 6638, y = 4300, z = 506, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 3959, y = 16761, z = 1309, yaw = 0x8000 },
            speed = 2.0,
            author = "NBKevin98",
            type = FLOOD_LAVA,
            startPos = { x = -3579, y = 6692, z = 3394, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 4226, y = 6018, z = -1944, yaw = -0x4000 },
            speed = 1.0,
            author = "NBKevin98",
            type = FLOOD_DESERT,
            startPos = { x = 7700, y = 2479, z = 4734, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 4940, y = 938, z = 8416, yaw = 0x8000 },
            speed = 2.57,
            author = "NBKevin98",
            type = FLOOD_LAVA,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 2318, y = 1949, z = -18991, yaw = 0x4000 },
            speed = 1.0,
            author = "NBKevin98",
            type = FLOOD_LAVA,
            startPos = { x = 464, y = -593, z = 17089, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
    }
end

-- Super Mario Rainbow Road, ported to Flood by Bear64DX
local function flood_load_rainbow_road_levels()
    game = GAME_SUPER_MARIO_RAINBOW_ROAD
    romhackInfo = "Super Mario Rainbow Road"
	romhackLogo = get_texture_info("logo_smrr")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 4272, y = -342, z = -93, yaw = 0x0000 },
            speed = 3.0,
            author = "Skillux",
            type = FLOOD_WATER,
            startPos = { x = -1239, y = -3302, z = -1911, yaw = 0x2000 }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -3239, y = 4307, z = 5283, yaw = 0x4000 },
            speed = 2.0,
            author = "Skillux",
            type = FLOOD_WATER,
            startPos = { x = 3120, y = -1452, z = -4759, yaw = 0x0000 }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 4584, y = 1464, z = 1597, yaw = 0x7000 },
            speed = 2.0,
            author = "Skillux",
            type = FLOOD_WATER,
            startPos = { x = -3984, y = -1415, z = -799, yaw = 0x4000 }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -4793, y = 1015, z = 7586, yaw = 0x8000 },
            speed = 2.3,
            author = "Skillux",
            type = FLOOD_LAVA
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -3471, y = 501, z = 4866, yaw = 0x8000 },
            speed = 2.7,
            author = "Skillux",
            type = FLOOD_WASTE,
            startPos = { x = 4020, y = -938, z = -2891, yaw = 0x0000 }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 2179, y = 5760, z = 1577, yaw = 0x4000 },
            speed = 2.6,
            author = "Skillux",
            type = FLOOD_WATER,
            startPos = { x = -3157, y = -2043, z = -3461, yaw = 0x3000 }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 2412, y = 707, z = 2341, yaw = 0x8000 },
            speed = 7.0,
            author = "Skillux",
            type = FLOOD_LAVA,
            startPos = { x = -2023, y = -472, z = 2928, yaw = 0x2000 }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 6048, y = 3212, z = -4519, yaw = -0x4000 },
            speed = 1.5,
            author = "Skillux",
            type = FLOOD_WATER,
            startPos = { x = -3430, y = -237, z = 2480, yaw = 0x8000 }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 5779, y = 1216, z = -958, yaw = 0x8000 },
            speed = 4.0,
            author = "Skillux",
            type = FLOOD_WATER,
            startPos = { x = -6359, y = -1103, z = -6643, yaw = 0x4000 }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -2240, y = 4028, z = -226, yaw = -0x4000 },
            speed = 2.0,
            author = "Skillux",
            type = FLOOD_LAVA,
            startPos = { x = 6398, y = -3810, z = 5487, yaw = -0x4000 }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 3250, y = 3903, z = -892, yaw = -0x4000 },
            speed = 1.5,
            author = "Skillux",
            type = FLOOD_LAVA,
            startPos = { x = 2534, y = -2596, z = -3390, yaw = 0x0000 }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 600, y = 1290, z = -1445, yaw = 0x0000 },
            speed = 2.75,
            author = "Skillux",
            type = FLOOD_LAVA,
            startPos = { x = 65, y = -295, z = -2435, yaw = 0x0000 }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 5, y = 650, z = -4175, yaw = 0x0000 },
            speed = 7.0,
            author = "Skillux",
            type = FLOOD_WATER,
            startPos = { x = 25, y = -250, z = 4515, yaw = 0x8000 }
        },
    }
end

-- Luigi & The Violet Stars, ported to Flood by Bear64DX
local function flood_load_luigi_the_violet_stars_levels()
    game = GAME_LUIGI_THE_VIOLET_STARS
    romhackInfo = "Luigi and the Violet Stars"
	romhackLogo = get_texture_info("logo_latvs")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 1836, y = 3111, z = -6093, yaw =  0x0000 },
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -4538, y = -508, z = 6632, yaw = 0x8500 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 3650, y = 2424, z = -9571, yaw =  0x4000 },
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_MUD,
            startPos = { x = 659, y = -1298, z = -2274, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 3502, y = 8021, z = 16229, yaw =  0x4000 },
            speed = 4.5,
            author = "Usernamesarespiders",
            type = FLOOD_MUD,
            startPos = { x = -2983, y = -1205, z = 1415, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -19400, y = 3188, z = 902, yaw = 0x4000 },
            speed = 6.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 2441, y = -5929, z = -6683, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -9099, y = 8326, z = 6691, yaw =  0x4000 },
            speed = 4.3,
            author = "Usernamesarespiders",
            type = FLOOD_MUD,
            startPos = { x = -7382, y = -494, z = 210, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -1529, y = 6909, z = -4922, yaw =  0x4000 },
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -992, y = 2155, z = 2361, yaw = 0x5000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 498, y = -2260, z = -1795, yaw = -0x4000 },
            speed = 3.7,
            author = "Usernamesarespiders",
            type = FLOOD_LAVA,
            startPos = { x = 10008, y = -5267, z = -2012, yaw = -0x2000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -11701, y = 1899, z = 6761, yaw = 0x8000 },
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_MUD,
            startPos = { x = -8813, y = -1325, z = 180, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 8179, y = 3117, z = 1508, yaw =  0x4000 },
            speed = 7.2,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -3695, y = -917, z = 3271, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 14319, y = -2577, z = -1510, yaw =  0x4000 },
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_SAND,
            startPos = { x = 2544, y = -4962, z = 4263, yaw = 0x5000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -9914, y = 1574, z = 4499, yaw = 0x4000 },
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 4980, y = -1616, z = 4029, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 1923, y = -128, z = 1201, yaw = 0x4000 },
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_CLOUDS,
            startPos = { x = -2140, y = -4695, z = -5686, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -161, y = 1397, z = 3052, yaw = 0x8000 },
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_WASTE,
            startPos = { x = 2148, y = 854, z = -1765, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -4155, y = -364, z = -9440, yaw = -0x2000 },
            speed = 5.0,
            author = "Usernamesarespiders",
            type = FLOOD_FROSTBITE,
            startPos = nil,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -2285, y = 1, z = 6716, yaw =  0x4000 },
            speed = 2.5,
            author = "Usernamesarespiders",
            type = FLOOD_LAVA,
            startPos = { x = 4874, y = -3596, z = -6258, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 3666, y = 2378, z = 2453, yaw = 0x8000 },
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_DESERT,
            startPos = { x = 2230, y = -5431, z = -3455, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 6502, y = 1254, z = -4781, yaw = 0x9300 },
            speed = 3.0,
            author = "Usernamesarespiders",
            type = FLOOD_MIST,
            startPos = { x = -1047, y = -3840, z = 3916, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 171, y = 1201, z = -546, yaw = -0x4000 },
            speed = 3.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -1071, y = -1066, z = -838, yaw = 0x5000 }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 2192, y = -803, z = -12922, yaw = -0x1000 },
            speed = 3.4,
            author = "Usernamesarespiders",
            type = FLOOD_LAVA,
            startPos = { x = 1654, y = -905, z = 7160, yaw = -0x6500 }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 9565, y = 336, z = 5080, yaw = 0x8000 },
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_FROSTBITE,
            startPos = { x = -883, y = -2343, z = 4526, yaw = 0x7500 }
        },
        {
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 9591, y = 336, z = 5055, yaw = 0x4000 },
            speed = 1.7,
            author = "Usernamesarespiders",
            type = FLOOD_LAVA,
            startPos = { x = 9494, y = -2803, z = 3268, yaw = -0x4000 }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -11582, y = -860, z = -9686, yaw = 0x0000 },
            speed = 1.7,
            author = "Usernamesarespiders",
            type = FLOOD_LAVA,
            startPos = { x = -11146, y = -1128, z = 12237, yaw = 0x6000 }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -997, y = -136, z = 561, yaw = 0x8000 },
            speed = 2.4,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -156, y = -2846, z = 5630, yaw = 0x8000 }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -9891, y = 978, z = 5513, yaw = 0x4000 },
            speed = 1.1,
            author = "Usernamesarespiders",
            type = FLOOD_LAVA,
            startPos = nil
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 4834, y = 946, z = 6993, yaw = 0x4000 },
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_MUD,
            startPos = { x = -361, y = -1308, z = 4712, yaw = 0x8000 }
        },
    }
end

-- Super Mario 64 Shining Stars, ported to Flood by SausRelics & ★~¡TOÑO!~★
local function flood_load_shining_stars_levels()
    game = GAME_SHINING_STARS
    romhackInfo = "Super Mario 64 Shining Stars"
    romhackLogo = get_texture_info("logo_sm64ss")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -720, y = -1775, z = 7390, yaw = 0x8000},
            music = { name = "Rogueport Sewers - Paper Mario: The Thousand-Year Door" },
            pipes = {
                {
                    { x = -6420, y = 3117, z = 585 },
                    { x = -675, y = -1776, z = -3620, yaw = 0x0000 }
                }
            }				
        },
        [2] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -3540, y = -5575, z = 2820, yaw = 0x8000},
            music = { name = "Rogueport Sewers - Paper Mario: The Thousand-Year Door" }			
        },
        [3] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -20, y = -2670, z = 3705, yaw = 0x8000},
            music = { name = "Flipside - Super Paper Mario" },
            pipes = {
                {
                    { x = -535, y = -2669, z = -776 },
                    { x = 197, y = -2669, z = -1666, yaw = 0x8000 }
                }
            }
        },
        [4] = {
            level = LEVEL_BBH,
            area = 1,
            spawn = {x = 850, y = -6791, z = 1240, yaw = 0x8000},
            music = { name = "Escape from Mt.Lavalava - Paper Mario" },
            pipes = {
                {
                    { x = 355, y = -9809, z = -5105 },
                    { x = -2447, y = -6804, z = 2499, yaw = 0x8000 }					
                }
            }			
        }
    }

    gLevels = {
        {	
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -418,  y = 8018, z = -2187, yaw =  0x8000 },
            speed = 3.5,
            author = "sm64pie",
            type = FLOOD_WATER,
            startPos = { x = -2080, y = 915, z = -7379, yaw = 0x2000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },			
            music = { name = "Run, Kirby, Run! - Kirby Super Star" }			
        },
        {						
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -2759, y = 2478, z = 7554, yaw =  0x8000 },
            speed = 2.5,
            author = "sm64pie",
            type = FLOOD_CLOUDS,
            unwantedBhvs = { id_bhvExclamationBox },			
            floodHeight = -4000,
            music = { name = "Atletic - Super Mario Land 2: 6 Golden Coins" }			
        },
        {						
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 4430, y =  3045, z = -2105, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "sm64pie",
            type = FLOOD_DARKNESS,		
            startPos = { x = -1900, y = -2881, z = -5046, yaw = 0x4000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            music = { name = "Light - Kirby Air Ride" }			
        },
        {						
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 2010, y =  4290, z =   -315, yaw =  0x8000 },
            speed = 2.0,
            author = "sm64pie",
            type = FLOOD_FROSTBITE,		
            startPos = { x = -4155, y = -2800, z =   3540, yaw = 0x4000, airborne = true },
            music = { name = "Floro Sapien Caverns - Super Paper Mario" }
        },
        {						
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 7670, y =  4440, z = -10330, yaw = 0x0000 },
            flagBase = true,
            speed = 1.75,
            author = "sm64pie",
            type = FLOOD_MOLTEN,		
            startPos = { x = -6385, y = -3180, z =  -1970, yaw = 0x4000, airborne = true },		
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },			
            music = { name = "Freezeflame Galaxy (Fire) - Super Mario Galaxy" }			
        },
        {						
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 170, y = 6465, z = -1680, yaw =  0x0000 },
            flagBase = true,			
            speed = 3.5,
            author = "sm64pie",
            type = FLOOD_MOLTEN,		
            startPos = { x = -5820, y = -2030, z = -3610, yaw = 0x0000, airborne = true },	
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },			
            capTimer = 300,		
            music = { name = "Floro Sapien Caverns - Super Paper Mario" }			
        },
        {						
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -490, y =  4320, z =   1660, yaw =  0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "sm64pie",
            type = FLOOD_MOLTEN,		
            floodScale = 1.5,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },
            music = { name = "Macho Grubba - Paper Mario: The Thousand-Year Door" }			
        },
        {						
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 1615, y =  4855, z =   -670, yaw =  0x4000 },
            speed = 2.0,
            author = "sm64pie",
            type = FLOOD_DESERT,	
            startPos = { x = 3960, y = 1666, z = 4162, yaw = -0x4000, airborne = true },	
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "The Glitz Pit - Paper Mario: The Thousand-Year Door" }			
        },
        {						
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 2055, y =  6910, z = -13365, yaw =  0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "sm64pie",
            type = FLOOD_WATER,	
            startPos = { x = 5460, y =  5220, z = -12480, yaw = 0x0000, airborne = true },	
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },			
            music = { name = "Bubblegloop Swamp - Banjo-Kazooie" }			
        },
        {						
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -13906, y = -1970, z = 3198, yaw = 0x4000 },
            speed = 2.0,
            author = "sm64pie",
            type = FLOOD_SNOW,	
            startPos = { x = -1524, y = -4655, z = -1848, yaw = -0x2000, airborne = true },		
            floodScale = 2.5,
            music = { name = "Crystal Palace Crawl - Paper Mario" }
        },
        {						
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -6980, y =  1760, z =  11870, yaw =  0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "sm64pie",
            type = FLOOD_MOLTEN,	
            startPos = { x = 4360, y = -2830, z =   2520, yaw = 0x0000, airborne = true },		
            floodScale = 1.5,
            music = { name = "Big Boss - Super Mario World 2: Yoshi's Island" }			
        },
        {						
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 4170, y = 6810, z = -3110, yaw = -0x2000 },
            flagBase = true,
            speed = 4.0,
            author = "sm64pie",
            type = FLOOD_CLOUDS,		
            floodHeight = -5780,
            launchpads = {
                { x = -5200, y = 1190, z = -250, yaw = 0x4000, vel = 200, forwardVel = 120 },
                { x = 0, y = 4960, z = 0, yaw = 0x6000, vel = 100, forwardVel = 100 }
            },
            music = { name = "Sky Waltz - Kirby's Return to Dream Land" }			
        },
        {						
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 10240, y = 1708, z = 462, yaw =  0x8000 },
            speed = 2.5,
            author = "sm64pie",
            type = FLOOD_DESERT,			
            startPos = { x = 520, y = 120, z = -5864, yaw = 0x8000, airborne = true },	
            floodHeight = -1410,
            unwantedBhvs = { id_bhvScuttlebug },
            music = { name = "Haunted House - Super Mario 64" }			
        },
        {						
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 2150, y = 1870, z = 6650, yaw = 0x8000 },	
            speed = 2.75,
            author = "sm64pie",
            type = FLOOD_CLOUDS,			
            startPos = { x = -4284, y = -2038, z = 2354, yaw = 0x0000, airborne = true },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvFadingWarp },			
            music = { name = "Sky Tower - Pokémon Mystery Dungeon: Red/Blue Rescue Team" }			
        },
        {						
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -110, y =  2680, z = 530, yaw = 10880 },
			flagBase = true,
            speed = 4.75,
            author = "sm64pie",
            type = FLOOD_MOLTEN,			
            startPos = { x = -6665, y = -5960, z = -670, yaw = 0x8000, airborne = true },	
            overrideSlide = true,
            music = { name = "Barrel Volcano - Super Mario RPG: Legend of the Seven Stars" }			
        },
        {						
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 178, y = 2060, z = -5878, yaw =  0x2000 },
            flagBase = true,			
            speed = 3.5,
            author = "sm64pie",
            type = FLOOD_MOLTEN,	
            startPos = { x = 4438, y = -2099, z = 4581, yaw = 0x8000, airborne = true },	
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            music = { name = "Black City - Bomberman 64" }			
        },
        {						
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 4453, y = 9280, z = -5546, yaw = -0x4000 },
            flagBase = true,			
            speed = 1.5,
            author = "sm64pie",
            type = FLOOD_DARKNESS,	
            startPos = { x = -4445, y = 5959, z = -3195, yaw = 0x0000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvFloorSwitchHiddenObjects },			
            music = { name = "Riddle Tower - Paper Mario: The Thousand-Year Door" }			
        },
        {						
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -1305, y = 9250, z = -1345, yaw = 0x4000 },
            speed = 2.5,
            author = "sm64pie",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvChuckya, id_bhvPushableMetalBox },				
            floodHeight = 3000,
            music = { name = "Floro Sapien Caverns - Super Paper Mario" }
        },
        {						
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 2060, y =  3150, z =  -1460, yaw =  0x0000 },
            speed = 3.75,
            author = "sm64pie",
            type = FLOOD_CLOUDS,			
            startPos = { x = -845, y = -4440, z =  -1555, yaw = 0x4000, airborne = true },
            music = { name = "Ball Rolling 1 - Super Mario Galaxy" }			
        },
        {						
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 9925, y =  2510, z = 4270, yaw = -0x4000 },
            speed = 3.5,
            author = "sm64pie",
            type = FLOOD_DARKNESS,	
            startPos = { x = 6260, y = -2850, z = -2610, yaw = 0x8000, airborne = true },		
            floodScale = 2,		
            music = { name = "Final Shadow Queen - Paper Mario: The Thousand-Year Door" }			
        },
        {						
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 495, y =  8430, z =   1200, yaw = -0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "sm64pie",
            type = FLOOD_MOLTEN,		
            startPos = { x = -3980, y = -4455, z =   -310, yaw = 0x4000, airborne = true },
            floodScale = 1.5,
            music = { name = "Final Shadow Queen - Paper Mario: The Thousand-Year Door" }	
        },
        {						
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -5615, y = 326, z = 18863, yaw = -0x4000 },
            flagBase = true,
            speed = 1.75,
            author = "sm64pie",
            type = FLOOD_MOLTEN,		
            startPos = { x = 685, y = -2192, z = 17050, yaw = 0x8000, airborne = true },	
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Boss - Kirby 64: The Crystal Shards" }
        },
        {						
            name = "bits2",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 6440, y =  3495, z =   8425, yaw =  0x4000 },
            flagBase = true,
            speed = 1.0,
            author = "sm64pie",
            type = FLOOD_MOLTEN,		
            startPos = { x = -3145, y = -55, z = 2375, yaw = 0x4000, airborne = true },	
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },	
            overrideName = "Bowser's Solar Shell Riding",			
            floodHeight = -2430,
            music = { name = "Boss - Kirby 64: The Crystal Shards" }			
        },
        {						
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 5335, y =  2870, z = -45, yaw = -0x4000 },
            speed = 2.0,
            author = "sm64pie",
            type = FLOOD_CLOUDS,		
            startPos = { x = -6455, y = -3480, z =  -630, yaw = 0x4000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },			
            music = { name = "The Tile Pool - Super Paper Mario" }			
        },
        {						
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 5380, y =  -380, z =   5065, yaw =  0x8000 },
            speed = 5.0,
            author = "sm64pie",
            type = FLOOD_WATER,		
            startPos = { x = -3540, y = -5400, z =   2850, yaw = 0x8000, airborne = true },		
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Shine City 2",
            music = { name = "Rogueport Sewers - Paper Mario: The Thousand-Year Door" }
        }
    }
end

-- Super Mario Fallen Stars, ported to Flood by Jzzay
local function flood_load_fallen_stars_levels()
    game = GAME_FALLEN_STARS
    romhackInfo = "Super Mario Fallen Stars"
	romhackLogo = get_texture_info("logo_smfs")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -1156, y = 5256, z = -6995, yaw = 0x0000 },
            speed = 4.5,
            author = "Skillux",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -10853, y = 4180, z = -4083, yaw = 0x4000 },
            speed = 6.0,
            author = "Skillux",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 2648, y = 1648, z = -1665, yaw = 0x7000 },
            speed = 9.0,
            author = "Skillux",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -1065, y = 6553, z = 1501, yaw = 0x6000 },
            speed = 2.0,
            author = "Skillux",
            type = FLOOD_LAVA,
            unwantedBhvs = { id_bhvWarpPipe }
        }
    }
end

-- Super Mario 64: Into Bowser's Castle, ported to Flood by SausRelics
local function flood_load_into_bowsers_castle_levels()
    game = GAME_SUPER_MARIO_64_INTO_BOWSERS_CASTLE
    romhackInfo = "Super Mario 64: Into Bowser's Castle"
	romhackLogo = get_texture_info("logo_sm64ibc")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -4203, y = 715, z = 3083, yaw = 0x4000 },
            speed = 5.0,
            author = "Deinol",
            type = FLOOD_WATER,
            startPos = { x = -566, y = -4942, z = -781, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -1576, y = 2048, z = -3218, yaw = 0x8000 },
            speed = 2.4,
            author = "Deinol",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -14806, y = 3599, z = 2203, yaw = 0x4000 },
            speed = 2.7,
            author = "Deinol",
            type = FLOOD_WATER,
            startPos = { x = 12341, y = -1111, z = 2188, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -6155, y = -2250, z = -13934, yaw = 0x0000 },
            speed = 2.2,
            author = "Deinol",
            type = FLOOD_WATER,
            startPos = { x = -6262, y = -2250, z = 14449, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 2467, y = -216, z = -3989, yaw = 0x8000 },
            speed = 3.3,
            author = "Deinol",
            type = FLOOD_WATER,
            startPos = { x = -4143, y = -1766, z = -1430, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -3756, y = 4000, z = -6244, yaw = 0x0000 },
            speed = 4.0,
            author = "Deinol",
            type = FLOOD_WATER,
            startPos = { x = -6442, y = 820, z = -3666, yaw = 0x7500 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 146, y = 11124, z = 3374, yaw = -0x8000 },
            speed = 3.8,
            author = "Deinol",
            type = FLOOD_WATER,
            startPos = { x = 406, y = 1000, z = 8914, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 932, y = 4400, z = -10044, yaw = -0x10000 },
            speed = 4.5,
            author = "Deinol",
            type = FLOOD_WATER,
            startPos = { x = -315, y = -3244, z = 662, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 382, y = 5725, z = 8936, yaw = 0x4000 },
            speed = 2.3,
            author = "Deinol",
            type = FLOOD_WATER,
            startPos = { x = 2311, y = 2120, z = 4561, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 50, y = -2362, z = -21732, yaw = 0x0000 },
            speed = 5.0,
            author = "Deinol",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 1906, y = 2780, z = -4379, yaw = 0x0000 },
            speed = 6.1,
            author = "Deinol",
            type = FLOOD_LAVA,
            startPos = { x = -3422, y = -2650, z = 12970, yaw = 0x7000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 367, y = 872, z = 7471, yaw = 0x8000 },
            speed = 2.0,
            author = "Deinol",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 2682, y = 6239, z = 8317, yaw = 0x8000 },
            speed = 4.6,
            author = "Deinol",
            type = FLOOD_WATER,
            startPos = { x = -10487, y = -1979, z = 9737, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 6885, y = 2000, z = -14967, yaw = 0x0000 },
            speed = 4.0,
            author = "Deinol",
            type = FLOOD_WASTE,
            startPos = { x = 1898, y = 640, z = -2477, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 21998, y = 500, z = -3433, yaw = -0x4000 },
            speed = 1.6,
            author = "Deinol",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 9820, y = 4000, z = 5804, yaw = -0x4000 },
            speed = 3.0,
            author = "Deinol",
            type = FLOOD_WASTE,
            startPos = { x = 9852, y = 175, z = 6003, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttc2",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 347, y = 4450, z = 4126, yaw = -0x4000 },
            speed = 4.0,
            author = "Deinol",
            type = FLOOD_WATER,
            startPos = { x = 2200, y = 355, z = 4000, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttc3",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 5611, y = 4415, z = 5631, yaw = -0x4000 },
            speed = 2.8,
            author = "Deinol",
            type = FLOOD_LAVA,
            startPos = { x = 5940, y = 355, z = 5100, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttc4",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 1395, y = 4500, z = 331, yaw = -0x4000 },
            speed = 2.8,
            author = "Deinol",
            type = FLOOD_MUD,
            startPos = { x = 2132, y = 355, z = 251, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttc5",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 9744, y = 4500, z = 208, yaw = -0x4000 },
            speed = 2.8,
            author = "Deinol",
            type = FLOOD_MUD,
            startPos = { x = 9748, y = 175, z = 2246, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 8194, y = 2287, z = 5047, yaw = 0x0000 },
            speed = 3.0,
            author = "Deinol",
            type = FLOOD_LAVA,
            startPos = { x = 6838, y = -254, z = 10843, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 6696, y = 4943, z = 5384, yaw = 0x2000 },
            speed = 4.2,
            author = "Deinol",
            type = FLOOD_LAVA,
            startPos = { x = 477, y = 701, z = 1402, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = -50, y = 4450, z = 10220, yaw = -0x4000 },
            speed = 1.5,
            author = "Deinol",
            type = FLOOD_LAVA,
            startPos = { x = -70, y = 2200, z = 11550, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -1000, y = 4600, z = 2805, yaw = 0x8000 },
            speed = 4.0,
            author = "Deinol",
            type = FLOOD_WATER,
            startPos = { x = 0, y = -2770, z = 0, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        }
    }
end

-- Super Mario 64 - Twisted Adventures, ported to Flood by SuperRodrigo0
local function flood_load_sm64_twisted_adventures_levels()
        game = GAME_SM64_TWISTED_ADVENTURES
        romhackInfo = "Super Mario 64 - Twisted Adventures"
	romhackLogo = get_texture_info("logo_sm64ta")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 2210, y = -1215, z = -660, yaw = 0x0000}
	},
        [2] = {
            level = LEVEL_WMOTR,
            area = 1,
            spawn = {x = -4200, y = -830, z = 6050, yaw = 0x4000}				
	},
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 6225, y = -810, z = -4205, yaw = 0x0000}		
	},
        [4] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = -5740, y = -2075, z = 6365, yaw = 0x4000}				
        }
    }

    gLevels = {
        {	
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 5165, y = 1990, z = 1620, yaw = 0x6000 },
            flagBase = true,
            speed = 4.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_WATER,
            startPos = { x = -1042, y = -735, z = -3071,  yaw = 0x0000, airborne = false },		
            unwantedBhvs = { id_bhvFadingWarp, id_bhvExclamationBox },			
	    floodScale = 1.5,
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
	    flagPos = { x = 3130, y = 8520, z = -7205, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "SomeRussianMarioDude",
            type = FLOOD_WATER,
            startPos = { x = -5845, y = 7970, z = -5045,  yaw = 0x2000, airborne = true },		
            unwantedBhvs = { id_bhvFadingWarp, id_bhvExclamationBox },			
	    floodHeight = 4820,
	    floodScale = 1.5,		
	    overrideName = "Champion's Challenge Of The Mountains"
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -6280, y = 5015, z = 1080, yaw = 0x8000 }, 
            flagBase = true,
            speed = 1.5,
            author = "SomeRussianMarioDude",
            type = FLOOD_LAVA,
            startPos = { x = 5233, y = -1765, z = 4829,  yaw = -0x6000, airborne = true },				
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 1345, y = 5620, z = -3925, yaw = 0x0000 },
            flagBase = true,
            speed = 2.75,
            author = "SomeRussianMarioDude",
            type = FLOOD_SAND,
            startPos = { x = 1345, y = -1510, z = -3925, yaw = 0x0000, airborne = true },					
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -1067, y = 3027, z = 5266, yaw = -0x6000 },
            flagBase = true,
            speed = 1.5,
            author = "SomeRussianMarioDude",
            type = FLOOD_SNOW,
            floodHeight = -1325,
            launchpads = {
                { x = -5735, y = 425, z = 4105, yaw = 0x4000, vel = 90, forwardVel = 0 },
                { x = -2570, y = 1010, z = 3355, yaw = -0x2000, vel = 120, forwardVel = 0 },				
            },				
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -5128, y = 4305, z = 3054, yaw =  0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_ACID,
            startPos = { x = 1768, y = -686, z = -2009,  yaw = 0x4000, airborne = true },	
            unwantedBhvs = { id_bhvExclamationBox },			
	    capTimer = 1
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -2051, y = 2747, z = -1085, yaw = -0x4000 }, 
            speed = 1.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_DARKNESS,
            floodHeight = -5840		
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 4465, y = 3985, z = 2200, yaw = 0x8000 },
            speed = 2.5,
            author = "SomeRussianMarioDude",
            type = FLOOD_DARKNESS,
            startPos = { x = 4605, y = -25, z = -160,  yaw = 0x0000, airborne = false },
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -5695, y = 7770, z = -40, yaw = 0x2000 },
   	    flagBase = true,
            speed = 2.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_WATER,
            startPos = { x = -6112, y = -4522, z = 5985,  yaw = 0x4000, airborne = true },	
	    floodScale = 2,
            launchpads = {
                { x = 1205, y = 4515, z = 6390, yaw = 0x0000, vel = 125, forwardVel = 0 },
                { x = 265, y = 6280, z = 4985, yaw = 0x0000, vel = 120, forwardVel = 0 },		
                { x = -2545, y = 7770, z = 3950, yaw = 0x0000, vel = 85, forwardVel = 0 },					
            },			
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -4750, y = 5580, z = -5240, yaw = 0x4000 }, 
            flagBase = true,
            speed = 2.5,
            author = "SomeRussianMarioDude",
            type = FLOOD_DARKNESS,
            startPos = { x = -2081, y = -777, z = 2494,  yaw = 0x4000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },			
            capTimer = 1			
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -1455, y = 4313, z = -3205, yaw = 0x0000 },
            speed = 1.75,
            author = "SomeRussianMarioDude",
            type = FLOOD_LAVA,
            startPos = { x = 2796, y = -954, z = 337,  yaw = -0x6000, airborne = true },	
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 5100, y = 2430, z = 5330, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_SAND,
            startPos = { x = 5361, y = -3879, z = 5510, yaw = 0x8000, airborne = true },		
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 5596, y = 346, z = -4257, yaw = -0x4000 },
            speed = 1.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_SAND,
            startPos = { x = 4200, y = -646, z = -1385,  yaw = 0x8000, airborne = true },	
            unwantedBhvs = { id_bhvExclamationBox },			
	    overrideName = "Tricky Pillars"
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -1703, y = 1072, z = -1414, yaw = 0x6000 },
            flagBase = true,
            speed = 2.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_WATER,	
	    floodHeight = -2440,
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 6385, y = 2150, z = 4550, yaw = -0x4000 }, 
            speed = 2.5,
            author = "SomeRussianMarioDude",
            type = FLOOD_WATER,
            startPos = { x = -6320, y = -1770, z = -5600,  yaw = 0x4000, airborne = true },			
            overrideSlide = true			
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 531, y = 1332, z = 1881, yaw =  0x4000 }, 
            flagBase = true,
            speed = 1.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_ACID,
            startPos = { x = -4688, y = -929, z = 5644,  yaw = 0x6000, airborne = true },	
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 4549, y = 6643, z = -5793, yaw = 0x0000 }, 
            flagBase = true,
            speed = 4.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_WATER,
            startPos = { x = -679, y = -1079, z = -2916,  yaw = -0x4000, airborne = true },		
            overrideWater = true			
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 4714, y = 704, z = 6992, yaw =  -0x4000 }, 
            flagBase = true,
            speed = 1.5,
            author = "SomeRussianMarioDude",
            type = FLOOD_CLOUDS,	
	    floodHeight = -4050,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },		
            launchpads = {
                { x = 615, y = 705, z = 5705, yaw = 0x4000, vel = 100, forwardVel = 30 },
            },			
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -834, y = -535, z = 2520, yaw =  0x2000 }, 
            flagBase = true,
            speed = 2.5,
            author = "SomeRussianMarioDude",
            type = FLOOD_WATER,
	     
            floodHeight = -3875	
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -4583, y = -587, z = 4529, yaw =  0x4000 }, 
            flagBase = true,
            speed = 3.5,
            author = "SomeRussianMarioDude",
            type = FLOOD_FROSTBITE,
            unwantedBhvs = { id_bhvWarpPipe },	
            floodHeight = -8500			
        },
        {
            name = "thi2",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -1665, y = 14025, z = 4420, yaw = 0x8000 }, 
            flagBase = true,
            speed = 2.5,
            author = "SomeRussianMarioDude",
            type = FLOOD_FROSTBITE,
            startPos = { x = 5760, y = 9590, z = 6200, yaw = -0x6000, airborne = true },		
            unwantedBhvs = { id_bhvWarpPipe, id_bhvMetalCap },		
            overrideName = "Snowy Mountain Climber"			
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 3468, y = 397, z = 5232, yaw =  0x8000 }, 
            flagBase = true,
            speed = 2.25,
            author = "SomeRussianMarioDude",
            type = FLOOD_WATER,
	    floodScale = 2,
            floodHeight = -5250,
	    overrideName = "Journey To Space II"
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 2250, y = 200, z = -6620, yaw = 0x4000 }, 
            speed = 2.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_ACID,	
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -930, y = 6390, z = 4610, yaw = 0x4000 }, 
            flagBase = true,
            speed = 1.5,
            author = "SomeRussianMarioDude",
            type = FLOOD_DARKNESS,
            startPos = { x = -1510, y = -15, z = 7200,  yaw = 0x4000, airborne = true },	           
	    floodScale = 2,
            floodHeight = -3000		
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 206, y = 587, z = -2592, yaw =  -0x2000 }, 
            flagBase = true,
            speed = 2.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe },			
	    overrideName = "First Overworld"
	    },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 5930, y = 1705, z = -3040, yaw = 0x4000 }, 
            speed = 2.25,
            author = "SomeRussianMarioDude",
            type = FLOOD_WATER,			
            startPos = { x = -4200, y = -830, z = 6050, yaw = 0x4000, airborne = false },							
            unwantedBhvs = { id_bhvWarpPipe },	
            overrideWater = true	
	    },
        {
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -4185, y = 2215, z = -2450, yaw = 0x8000 }, 
            flagBase = true,
            speed = 2.25,
            author = "SomeRussianMarioDude",
            type = FLOOD_LAVA,			
            unwantedBhvs = { id_bhvWarpPipe },			
            startPos = { x = 6365, y = -810, z = 4820,  yaw = 0x8000, airborne = true },	
            unwantedBhvs = { id_bhvWarpPipe },				
            overrideName = "Third Overworld"			
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 1890, y = -235, z = 535, yaw = -0x2000 }, 
            speed = 3.0,
            author = "SomeRussianMarioDude",
            type = FLOOD_LAVA,			
            startPos = { x = -5740, y = -2075, z = 6365, yaw = 0x4000, airborne = false },			
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },			
        }
    }
end

-- Super Mario Bros. 64, ported to Flood by Jzzay
local function flood_load_super_mario_bros_64_levels()
    game = GAME_SUPER_MARIO_BROS_64
    romhackInfo = "Super Mario Bros. 64"
	romhackLogo = get_texture_info("logo_smb64")	
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -182, y = 285, z = 7490, yaw = 0x8000 },
            flagBase = false,
            speed = 1.0,
            author = "Tamkis",
            type = FLOOD_WATER,
            overrideName = "World Overworld"
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 53, y = 1022, z = -1984, yaw = 0x8000 },
            flagBase = false,
            speed = 2.0,
            author = "Tamkis",
            type = FLOOD_WATER,
            overrideName = "World Underground"
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 6701, y = 616, z = 200, yaw = 0x8000 },
            flagBase = false,
            speed = 1.0,
            author = "Tamkis",
            type = FLOOD_CLOUDS,
            startPos = { x = -8953, y = 114, z = -245, yaw = 0x4000 },
            overrideName = "World Athletic"
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -119, y = 208, z = 18885, yaw = 0x8000 },
            flagBase = false,
            speed = 1.0,
            author = "Tamkis",
            type = FLOOD_WATER,
            overrideName = "World Overworld 2"
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -11, y = -121, z = 7793, yaw = 0x8000 },
            flagBase = false,
            speed = 1.2,
            author = "Tamkis",
            type = FLOOD_LAVA,
            startPos = { x = -9, y = 430, z = -7092, yaw = 0x0000 },
            overrideName = "World Castle"
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 101, y = 272, z = 7252, yaw = 0x8000 },
            flagBase = false,
            speed = 2.0,
            author = "Tamkis",
            type = FLOOD_WATER,
            overrideName = "World Underwater"
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 1050, y = 650, z = -992, yaw = 0x0000 },
            flagBase = false,
            speed = 1.4,
            author = "Tamkis",
            type = FLOOD_CLOUDS,
            startPos = { x = -1430, y = 83, z = -2541, yaw = 0x0000 },
            overrideName = "World Athletic 2"
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 11, y = -340, z = 6426, yaw = 0x8000 },
            flagBase = false,
            speed = 1.2,
            author = "Tamkis",
            type = FLOOD_LAVA,
            startPos = { x = 3, y = 455, z = -10164, yaw = 0x0000 },
            act = 2,
            overrideName = "World Castle 2"
        }
    }
end

-- Blossoming Bluds, ported to Flood by Jzzay
local function flood_load_blossoming_bluds_levels()
    game = GAME_BLOSSOMING_BLUDS
    romhackInfo = "Blossoming Buds"
	romhackLogo = get_texture_info("logo_bb")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 116, z = 0, yaw = 0x8000}
        },
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -5625, y = 3215, z = -6167, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = -5978, y = -345, z = 2151, yaw = 0x7000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -3422, y = 4875, z = -6701, yaw = 0x2000 },
            speed = 1.2,
            author = "Usernamesarespiders",
            type = FLOOD_POISON,
            startPos = { x = 1823, y = -205, z = 9435, yaw = 0x6000, airborne = false },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -6873, y = 1643, z = 1118, yaw = 0x1000 },
            flagBase = true,
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 4265, y = 536, z = -1605, yaw = 0x0000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 4567, y = 1493, z = 7099, yaw = -0x4000 },
            speed = 2.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 4797, y = -2600, z = 8243, yaw = -0x4000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -6468, y = 2258, z = -2781, yaw = 0x1000 },
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_MOLTEN,
            startPos = { x = 7760, y = -4744, z = 9503, yaw = -0x4000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -2344, y = 5787, z = -2536, yaw = 0x8000 },
            flagBase = true,
            speed = 1.5,
            author = "Usernamesarespiders",
            type = FLOOD_MAGMA,
            startPos = { x = -8049, y = 551, z = 6229, yaw = 0x5000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 3097, y = 2820, z = -825, yaw = -0x4000 },
            speed = 4.0,
            author = "Usernamesarespiders",
            type = FLOOD_WATER,
            startPos = { x = 2394, y = 1132, z = -2251, yaw = -0x5000 },
            floodScale = 2,
            overrideName = "Flowery Bridges",
            overrideWater = true
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 3697, y = 854, z = -887, yaw = -0x2000 },
            speed = 5.0,
            author = "Usernamesarespiders",
            type = FLOOD_MOLTEN,
            startPos = { x = -1350, y = 0, z = 185, yaw = 0x4000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Mushroom Dead End",
            overrideWater = true
        },
    }
end

-- Super Mario: The Stolen Stars, ported to Flood by Jzzay
local function flood_load_the_stolen_stars_levels()
    game = GAME_THE_STOLEN_STARS
    romhackInfo = "Super Mario The Stolen Stars"
	romhackLogo = get_texture_info("logo_smtss")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 8979, y = 6254, z = -11247, yaw = 0x7000 },
            speed = 2.0,
            author = "JakeDower",
            type = FLOOD_WATER,
            startPos = { x = 9889, y = 1164, z = 9386, yaw = -0x7000 },
            floodScale = 1.5,
             
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 7444, y = 15691, z = 12047, yaw = 0x8000 },
            flagBase = true,
            speed = 1.85,
            author = "JakeDower",
            type = FLOOD_LAVA,
            startPos = { x = 14160, y = 5812, z = -6954, yaw = -0x6000 },
            floodScale = 1.5,
            overrideWater = true
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -7183, y = 7475, z = 12759, yaw = 0x4000 },
            flagBase = true,
            speed = 0.7,
            author = "JakeDower",
            type = FLOOD_DESERT,
            startPos = { x = 2404, y = 5812, z = -6362, yaw = 0x0000 },
            floodScale = 1.5,
            overrideWater = true
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 8104, y = 5345, z = -5656, yaw = 0x8000 },
            flagBase = true,
            speed = 1.25,
            author = "JakeDower",
            type = FLOOD_WATER,
            startPos = { x = -9745, y = 603, z = -3510, yaw = 0x4000 },
            floodScale = 1.5,
            overrideWater = true
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 415, y = 1544, z = -9380, yaw = 0x0000 },
            speed = 3.0,
            author = "JakeDower",
            type = FLOOD_WATER,
            startPos = { x = -961, y = 519, z = 701, yaw = 0x6000 },
            floodScale = 1.5,
            overrideWater = true
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -9255, y = 17876, z = 16791, yaw = 0x8000 },
            flagBase = true,
            speed = 5.0,
            author = "JakeDower",
            type = FLOOD_DESERT,
            startPos = { x = 14504, y = 5210, z = -6260, yaw = 0x0000 },
            floodScale = 1.5,
             
            overrideSlide = true
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 4,
            flagPos = { x = -14554, y = 4338, z = -711, yaw = 0x0000 },
            speed = 1.0,
            author = "JakeDower",
            type = FLOOD_WASTE,
            startPos = { x = 2835, y = -412, z = 3421, yaw = 0x8000 },
            floodScale = 1.5,
            overrideWater = true
        },
        {
            name = "b1",
            level = LEVEL_BOWSER_1,
            area = 1,
            flagPos = { x = -243, y = 5487, z = -1515, yaw = -0x4000 },
            speed = 7.0,
            author = "JakeDower",
            type = FLOOD_LAVA,
            startPos = { x = -281, y = 345, z = 1779, yaw = 0x0000 },
            floodScale = 1.5,
            overrideName = "Lunatic Mansion Rooftop",
            overrideWater = true
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = -802, y = 1646, z = 10188, yaw = 0x6000 },
            flagBase = true,
            speed = 1.0,
            author = "JakeDower",
            type = FLOOD_WATER,
            startPos = { x = -5074, y = 745, z = -9007, yaw = 0x8000 },
            floodScale = 1.5,
            overrideName = "Sandy Shores",
            overrideWater = true
        },
    }
end

-- Luigi and the Forest Ruins, ported to Flood by SuperRodrigo0
local function flood_load_luigi_and_the_forest_ruins_levels()
    game = GAME_LUIGI_AND_THE_FOREST_RUINS
    romhackInfo = "Luigi and the Forest Ruins"
	romhackLogo = get_texture_info("logo_latfr")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -6646, y = 2769, z = -2526, yaw = 0x6000 },
            flagBase = false,
            speed = 3.0,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -5934, y = -3708, z = 1651, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -4974, y = 13645, z = -4997, yaw = -0x2000 },
            flagBase = false,
            speed = 1.2,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -3545, y = 11039, z = -12909, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -6113, y = 2718, z = -8059, yaw = -0x0000 },
            flagBase = false,
            speed = 3.3,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = 7423, y = 240, z = -120, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -5629, y = -521, z = -12373, yaw = 0x6000 },
            flagBase = false,
            speed = 2.5,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -6174, y = -1065, z = -7701, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -13361, y = 621, z = -2437, yaw = 0x8000 },
            flagBase = false,
            speed = 2.0,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -16440, y = -1985, z = 5201, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -20862, y = 2277, z = -6380, yaw = 0x8000 },
            flagBase = false,
            speed = 5.0,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -22743, y = -379, z = -4724, yaw = -0x0500 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 2304, y = 725, z = -1871, yaw = 0x2000 },
            flagBase = false,
            speed = 5.0,
            author = "LinCrash & TheGael95",
            type = FLOOD_LAVA,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -1095, y = 2619, z = -9347, yaw = -0x4000 },
            flagBase = false,
            speed = 3.2,
            author = "LinCrash & TheGael95",
            type = FLOOD_LAVA,
            startPos = { x = 3691, y = -1044, z = 5197, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -3153, y = 7743, z = 4489, yaw = -0x4000 },
            flagBase = false,
            speed = 2.3,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = 496, y = 2044, z = -3690, yaw = 0x9999 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 3699, y = 3656, z = -4303, yaw = 0x6000 },
            flagBase = false,
            speed = 2.5,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -524, y = 744, z = -2077, yaw = 0x5000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -9395, y = 3430, z = -5685, yaw = 0x0000 },
            flagBase = false,
            speed = 5.75,
            author = "LinCrash & TheGael95",
            type = FLOOD_SAND,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "b1",
            level = LEVEL_BOWSER_1,
            area = 1,
            flagPos = { x = 5727, y = -777, z = 44, yaw = -0x5000 },
            flagBase = false,
            speed = 2.0,
            author = "LinCrash & TheGael95",
            type = FLOOD_LAVA,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -9620, y = 298, z = 5248, yaw = 0x8000 },
            flagBase = false,
            speed = 4.1,
            author = "LinCrash & TheGael95",
            type = FLOOD_LAVA,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "b2",
            level = LEVEL_BOWSER_2,
            area = 1,
            flagPos = { x = 2910, y = -192, z = 156, yaw = -0x4000 },
            flagBase = false,
            speed = 4.0,
            author = "LinCrash & TheGael95",
            type = FLOOD_LAVA,
            startPos = { x = -1643, y = 0, z = -13, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -380, y = -2850, z = 2707, yaw = 0x8000 },
            flagBase = false,
            speed = 3.0,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -25, y = -2852, z = -2403, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 6644, y = 2659, z = -447, yaw = -0x2000 },
            flagBase = false,
            speed = 3.0,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -3872, y = -385, z = 6028, yaw = 0x7000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -2695, y = 8001, z = -3033, yaw = 0x8000 },
            flagBase = false,
            speed = 4.5,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -10793, y = 1966, z = 308, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bits2",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 22557, y = 3777, z = -18617, yaw = -0x4000 },
            flagBase = false,
            speed = 1.7,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = 4406, y = 2966, z = -10913, yaw = 0x6000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "b3",
            level = LEVEL_BOWSER_3,
            area = 1,
            flagPos = { x = -5377, y = -470, z = -117, yaw = 0x5000 },
            flagBase = false,
            speed = 12.0,
            author = "LinCrash & TheGael95",
            type = FLOOD_LAVA,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 432, y = 2834, z = -3771, yaw = 0x6000 },
            flagBase = false,
            speed = 2.0,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -4565, y = 740, z = 6996, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 1756, y = 2799, z = 1392, yaw = 0x0000 },
            flagBase = false,
            speed = 1.5,
            author = "LinCrash & TheGael95",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        }
    }
end

-- Dream64, ported to Flood by Bear64DX & Jzzay
local function flood_load_dream64_levels()
    game = GAME_DREAM64
    romhackInfo = "Dream 64"
	romhackLogo = get_texture_info("logo_dream64")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -6674, y = 5279, z = 5177, yaw = 0x6000 },
            flagBase = true,
            speed = 3.0,
            author = "SonicandMarioGames1985",
            type = FLOOD_WATER,
            startPos = { x = 1776, y = 0, z = 2913, yaw = -0x6000 },
            overrideWater = true
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 16, y = 0, z = -2517, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "SonicandMarioGames1985",
            type = FLOOD_WATER,
            startPos = { x = -6, y = -2881, z = 12521, yaw = 0x8000 },
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 6878, y = -121, z = -6755, yaw = -0x2000 },
            speed = 2.0,
            author = "SonicandMarioGames1985",
            type = FLOOD_LAVA,
            startPos = { x = -4781, y = -92, z = 3875, yaw = 0x8000 },
            unwantedBhvs = { id_bhvFadingWarp },
            overrideName = "Shifting Volcanic Land",
            overrideWater = true
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 2,
            flagPos = { x = 5956, y = 517, z = 3407, yaw = 0x9000 },
            speed = 2.8,
            author = "SonicandMarioGames1985",
            type = FLOOD_FROSTBITE,
            startPos = { x = -4301, y = -92, z = -4770, yaw = 0x4000 },
            unwantedBhvs = { id_bhvFadingWarp },
            overrideName = "Shifting Snowy Land",
            overrideWater = true
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -998, y = 1642, z = 603, yaw = -0x4000 },
            speed = 3.0,
            author = "SonicandMarioGames1985",
            type = FLOOD_POISON,
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -4554, y = 30, z = -3660, yaw = -0x4000 },
            speed = 1.75,
            author = "SonicandMarioGames1985",
            type = FLOOD_POISON,
            startPos = { x = -5, y = -3159, z = 8219, yaw = 0x8000 },
            overrideName = "Big Boo's Basement"
        },
        {
            name = "ccm3",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = 0, y = 12128, z = 0, yaw = 0x0000 },
            speed = 3.0,
            author = "SonicandMarioGames1985",
            type = FLOOD_POISON,
            startPos = { x = 11802, y = 633, z = 258, yaw = 0x0000 },
            overrideName = "Big Boo's Slide"
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 2,
            flagPos = { x = -2218, y = 3403, z = 3186, yaw = 0x2000 },
            speed = 6.0,
            author = "SonicandMarioGames1985",
            type = FLOOD_WATER,
            startPos = { x = 0, y = 0, z = 0, yaw = 0x0000 }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -5956, y = 6828, z = -5327, yaw = 0x2000 },
            flagBase = true,
            speed = 2.5,
            author = "SonicandMarioGames1985",
            type = FLOOD_WATER,
            startPos = { x = 5710, y = -177, z = 6402, yaw = -0x6000 },
            floodScale = 2,
            overrideWater = true
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 10, y = 1769, z = 996, yaw = 0x0000 },
            speed = 4.5,
            author = "SonicandMarioGames1985",
            type = FLOOD_WATER,
            overrideWater = true
        },
        {
            name = "sa2",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 2818, y = 1900, z = 2815, yaw = 0x8000 },
            speed = 2.3,
            author = "SonicandMarioGames1985",
            type = FLOOD_WASTE,
            startPos = { x = -4215, y = -2710, z = -2154, yaw = 0x4000, airborne = false },
            overrideName = "Wet-Dry Sewers"
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 2,
            flagPos = { x = -25, y = 2013, z = -1753, yaw = 0x8000 },
            speed = 5.0,
            author = "SonicandMarioGames1985",
            type = FLOOD_WATER,
            startPos = { x = 941, y = -1204, z = -2195, yaw = -0x4000 },
            overrideName = "Castle Climb",
            overrideWater = true
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 9915, y = 1799, z = -4791, yaw = -0x4000 },
            speed = 4.5,
            author = "SonicandMarioGames1985",
            type = FLOOD_WATER,
            startPos = { x = -2211, y = -1606, z = -1589, yaw = 0x0000 },
            overrideName = "Castle Hallways"
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -142, y = 1653, z = -4448, yaw = -0x4000 },
            flagBase = true,
            speed = 3.5,
            author = "SonicandMarioGames1985",
            type = FLOOD_WATER,
            startPos = { x = -9780, y = -4527, z = -15397, yaw = -0x5000 },
            floodScale = 2,
            overrideName = "Castle Surroundings",
            overrideWater = true
        },
        {
            name = "b1",
            level = LEVEL_BOWSER_1,
            area = 1,
            flagPos = { x = -61, y = 1791, z = 2646, yaw = 0x8000 },
            flagBase = true,
            speed = 6.0,
            author = "SonicandMarioGames1985",
            type = FLOOD_LAVA,
            overrideName = "Bowser's Finale",
        },
    }
end

-- Thousand Year Door 64, ported to Flood by Jzzay
local function flood_load_tyd64_levels()
    game = GAME_TYD64
    romhackInfo = "Thousand-Year Door 64"
	romhackLogo = get_texture_info("logo_tyd64")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -6260, y = 1579, z = 3766, yaw = 0x8000}
        },
        [2] = {
            level = LEVEL_VCUTM,
            area = 1,
            spawn = {x = -57, y = -1124, z = -2579, yaw = 0x8000}
        },
    }
	gLevelValues.vanishCapDurationVcutm  = 1

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 2906, y = -248, z = -2065, yaw = -0x4000 },
            speed = 3.2,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = 260, y = -4840, z = -718, yaw = -0x4500 },
            floodScale = 4,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox, id_bhvFadingWarp },
            overrideWater = true
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -14913, y = 757, z = -5290, yaw = 0x3000 },
            speed = 1.35,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = -17223, y = -260, z = 6617, yaw = 0x4000 },
            floodScale = 4,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvFadingWarp },
            overrideWater = true
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 2,
            flagPos = { x = -944, y = -1497, z = -12099, yaw = 0x1000 },
            speed = 3.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = 516, y = -8306, z = 12146, yaw = 0x8000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -114, y = 2023, z = -126, yaw = 0x4000 },
            speed = 4.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_DARKNESS,
            startPos = { x = 5090, y = -5600, z = 5732, yaw = -0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 18079, y = 2157, z = -5669, yaw = -0x4000 },
            speed = 1.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_DARKNESS,
            startPos = { x = -7457, y = 397, z = 13053, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = 328, y = 1726, z = -8, yaw = 0x2000 },
            speed = 3.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = 1427, y = -1680, z = -1923, yaw = 0x0000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Boggly Residence",
            overrideWater = true
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 3236, y = 5745, z = 677, yaw = 0x0000 },
            speed = 2.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_LAVA,
            startPos = { x = -9215, y = -4494, z = 1216, yaw = 0x4500 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -7932, y = 6330, z = -5800, yaw = 0x0000 },
            speed = 2.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_CLOUDS,
            startPos = { x = 5159, y = 750, z = 6561, yaw = 0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 1076, y = -3926, z = -2579, yaw = 0x0000 },
            speed = 2.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_DARKNESS,
            startPos = { x = 972, y = -5726, z = -4027, yaw = 0x0000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 2,
            flagPos = { x = 0, y = 1284, z = -524, yaw = 0x0000 },
            speed = 2.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = -53, y = -2760, z = 4693, yaw = 0x5000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "hmc2",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -3987, y = 480, z = 1741, yaw = 0x8000 },
            speed = 2.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = 4846, y = -1304, z = 128, yaw = -0x4000, airborne = false },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Glitz Pit",
            overrideWater = true
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 13170, y = 4500, z = -7156, yaw = -0x2000 },
            speed = 2.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = -5258, y = 60, z = -11172, yaw = 0x2000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -8243, y = 2112, z = 12399, yaw = 0x7000 },
            speed = 1.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_SUNSET,
            startPos = { x = 10202, y = -672, z = -6250, yaw = 0x9999 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "lll2",
            level = LEVEL_LLL,
            area = 2,
            flagPos = { x = 6002, y = 10740, z = -6003, yaw = 0x4000 },
            speed = 2.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = 10038, y = 1260, z = 105, yaw = 0x9999 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Twilight Slide",
            overrideWater = true
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -12410, y = 720, z = -5647, yaw = 0x0000 },
            speed = 2.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = -11038, y = 0, z = 12838, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x = 161, y = 5100, z = -999, yaw = -0x5000 },
            speed = 1.5,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = 2599, y = 0, z = -226, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Creepy Cathedral",
            overrideWater = true
        },
        {
            name = "ssl3",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -12402, y = 720, z = -5626, yaw = 0x1000 },
            speed = 1.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = -11044, y = 0, z = 12834, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Creepy Underground",
            overrideWater = true
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 9055, y = -270, z = -32123, yaw = 0x0000 },
            speed = 1.4,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = 10854, y = -5310, z = 21899, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "ddd2",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 1493, y = 4650, z = 8285, yaw = 0x0000 },
            speed = 4.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = -3429, y = -5790, z = 30770, yaw = 0x5650 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Keelhaul Cliffside",
            overrideWater = true
        },
        {
            name = "ddd3",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 476, y = 3930, z = -3047, yaw = 0x0000 },
            speed = 2.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_LAVA,
            startPos = { x = 4613, y = -4470, z = -12731, yaw = -0x2000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Keelhaul Ravine",
            overrideWater = true
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -2328, y = 480, z = 12881, yaw = 0x1500 },
            speed = 1.5,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = -1685, y = -3960, z = 8876, yaw = 0x0000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true
        },
        {
            name = "sl2",
            level = LEVEL_SL,
            area = 3,
            flagPos = { x = 250, y = 1487, z = -13614, yaw = 0x0000 },
            speed = 1.5,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = 215, y = 203, z = -535, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Pirate Cave",
            overrideWater = true
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -3435, y = 3540, z = -13111, yaw = 0x4000 },
            speed = 1.5,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_LAVA,
            startPos = { x = -2631, y = -1200, z = -11233, yaw = 0x0000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Inside the Red Blender",
            overrideWater = true
        },
        {
            name = "pss2",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -1, y = 7200, z = 143, yaw = 0x0000 },
            speed = 1.0,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = 966, y = 4800, z = 17483, yaw = 0x7400 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Inside the Blue-Pink Blender",
            overrideWater = true
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -3051, y = 90, z = 6543, yaw = 0x5900 },
            speed = 2.5,
            author = "ToasterKetchup & aglab2",
            type = FLOOD_WATER,
            startPos = { x = 5680, y = -371, z = -5010, yaw = -0x5899 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "DK's Jungle",
            overrideWater = true
        },
    }
end

-- Nice Mario 75, ported to Flood by SuperRodrigo0
local function flood_load_nice_mario_75_levels()
    game = GAME_NICE_MARIO_75
    romhackInfo = "Nice Mario 75"
	romhackLogo = get_texture_info("logo_nm75")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 6475, y = 13141, z = -10189, yaw =  0x0000 },
            flagBase = false,
            speed = 2.6,
            author = "AirMate",
            type = FLOOD_WATER,
            startPos = { x = 2207, y = 8818, z = -11455, yaw = 0x4000 }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -7368, y = 1478, z = -3408, yaw =  0x0000 },
            flagBase = false,
            speed = 2.0,
            author = "AirMate",
            type = FLOOD_WATER,
            startPos = { x = -1487, y = -369, z = 4468, yaw = 0x8000 }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -2884, y = 1834, z = 1296, yaw = 0x4000 },
            flagBase = false,
            speed = 3.5,
            author = "AirMate",
            type = FLOOD_WATER,
            startPos = { x = 2985, y = -728, z = 847, yaw = 0x8000 }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -1890, y = 1516, z = 5195, yaw = 0x0000 },
            flagBase = false,
            speed = 2.7,
            author = "AirMate",
            type = FLOOD_WATER,
            startPos = { x = 1496, y = -571, z = -1419, yaw = -0x2000 }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 3218, y = -187, z = 4789, yaw = 0x8000 },
            flagBase = false,
            speed = 3.0,
            author = "AirMate",
            type = FLOOD_WATER,
            startPos = { x = 265, y = -187, z = -1492, yaw = 0x0000 }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 3935, y = 686, z = 2075, yaw = 0x0000 },
            flagBase = false,
            speed = 1.0,
            author = "AirMate",
            type = FLOOD_WATER,
            startPos = { x = -1298, y = 420, z = -3062, yaw = 0x0000 }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -2925, y = 1742, z = 256, yaw = -0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "AirMate",
            type = FLOOD_LAVA,
            startPos = { x = -385, y = -1722, z = -1329, yaw = 0x4000 }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 2156, y = 7443, z = -3740, yaw = 0x0000 },
            flagBase = false,
            speed = 6.0,
            author = "AirMate",
            type = FLOOD_WATER,
            startPos = { x = -3548, y = -4909, z = 1675, yaw = 0x8000 }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -1917, y = 2576, z = 2548, yaw = 0x8000 },
            flagBase = false,
            speed = 3.0,
            author = "AirMate",
            type = FLOOD_WATER,
            startPos = { x = 5173, y = -1475, z = -5738, yaw = 0x0000 }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 5005, y = 2710, z = 2935, yaw = 0x8000 },
            flagBase = false,
            speed = 4.0,
            author = "AirMate",
            type = FLOOD_WATER,
            startPos = { x = -6611, y = -2368, z = 3147, yaw = 0x8000 }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 3774, y = 836, z = 3268, yaw = 0x8000 },
            flagBase = false,
            speed = 2.0,
            author = "AirMate",
            type = FLOOD_LAVA,
            startPos = { x = -1060, y = -218, z = 2729, yaw = 0x6000 }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -394, y = 1999, z = 1704, yaw = 0x4000 },
            flagBase = false,
            speed = 2.3,
            author = "AirMate",
            type = FLOOD_LAVA,
            startPos = { x = 3155, y = -664, z = -1497, yaw = -0x4000 }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -1519, y = 322, z = 1504, yaw = 0x8000 },
            flagBase = false,
            speed = 3.0,
            author = "AirMate",
            type = FLOOD_LAVA,
            startPos = { x = 230, y = -1055, z = -2435, yaw = -0x2000 }
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -7205, y = 1554, z = -5637, yaw = 0x0000 },
            flagBase = false,
            speed = 4.0,
            author = "AirMate",
            type = FLOOD_WATER,
            startPos = { x = 334, y = -4326, z = 6311, yaw = 0x8000 }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -4831, y = 2181, z = 2515, yaw = 0x8000 },
            flagBase = false,
            speed = 1.8,
            author = "AirMate",
            type = FLOOD_SAND,
            startPos = { x = -4723, y = -204, z = 9620, yaw = 0x4000 }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 63, y = 1895, z = 6396, yaw = -0x4000 },
            flagBase = false,
            speed = 1.5,
            author = "AirMate",
            type = FLOOD_MUD,
            startPos = { x = -6082, y = -1491, z = -9244, yaw = 0x0000 }
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = -281, y = 240, z = 1571, yaw = 0x8000 },
            flagBase = false,
            speed = 6.0,
            author = "AirMate",
            type = FLOOD_WATER,
            startPos = { x = -836, y = -561, z = -2593, yaw = 0x0000 }
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 705, y = 1440, z = 1910, yaw = 0x8000 },
            flagBase = false,
            speed = 4.3,
            author = "AirMate",
            type = FLOOD_WATER
        }
    }
end

-- SM64 Trouble Town, ported to Flood by Bear64DX
local function flood_load_trouble_town_levels()
    game = GAME_TROUBLE_TOWN
    romhackInfo = "Super Mario 64: Trouble Town"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 3060, y = -87, z = 5129, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 2500, y = 3668, z = 797, yaw =  0x6000 },
            flagBase = true,
            speed = 2.6,
            author = "Nobbie",
            type = FLOOD_WATER,
            startPos = { x = -2244,  y = 4, z = -1545, yaw = 0x0000 },
            floodScale = 2.5
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -6767, y = 3867, z = -1797, yaw =  0x4000 },
            speed = 2.0,
            author = "Nobbie",
            type = FLOOD_MUD,
            startPos = { x = -270,  y = 0, z = 1047, yaw = 0x4000 },
            floodScale = 2.5
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -7730, y = 3646, z = -4244, yaw = 0x4000 },
            speed = 2.3,
            author = "Nobbie",
            type = FLOOD_WATER,
            startPos = { x = 1135,  y = 0, z = 5136, yaw = -0x8000 },
            floodScale = 2.5
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 87, y = 5986, z = -2409, yaw =  0x0000 },
            speed = 2.0,
            author = "Nobbie",
            type = FLOOD_LAVA,
            startPos = { x = 22, y = 0, z = 10009, yaw = 0x8000 },
            floodScale = 2.5
        },
    }
end

-- Star Revenge 2.5: Remnant of Doom, ported to Flood by SausRelics & ★~¡TOÑO!~★
local function flood_load_star_revenge_2_5_levels()
    game = GAME_STAR_REVENGE_2_5
    romhackInfo = "Star Revenge 2.5: Remnant of Doom"
    romhackLogo = get_texture_info("logo_sr2.5")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 10, y = -1910, z = 1610, yaw = -0x6000},
            music = { name = "Castle Theme - New Super Mario Bros." }
        },
        [2] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -10, y = -1875, z = 1605, yaw = 0x8000},
            music = { name = "Compatibility Tester - Tomodachi Life" }
        },
        [3] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 725, z = 1150, yaw = 0x8000},
            music = { name = "Blanco Hills - Super Mario Sunshine" }
        },
        [4] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = 1785, y = 1360, z = 15, yaw = -0x4000},
            music = { name = "Evil Glade - Cartoon Network Racing DS" }
        },
        [5] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = -10, y = 370, z = -10, yaw = -0x4000},
            unwantedBhvs = { id_bhvFireSpitter },
            music = { name = "Faint Dream Inanimate Dream - Touhou 4 Lotus Land Story" }
        },
        [6] = {
            level = LEVEL_BOWSER_3,
            area = 1,
            spawn = {x = -10, y = 300, z = 1160, yaw = 0x8000},
            music = { name = "Ultimate Koopa - Super Mario 64" }
        },
        [7] = {
            level = LEVEL_BITFS,
            area = 1,
            spawn = {x = 0, y = -2385, z = 935, yaw = 0x8000},
            unwantedBhvs = { id_bhvFadingWarp, id_bhvRedCoin, id_bhv1Up },
            music = { name = "Temple - Zelda II: The Adventure of Link" }
        },
        [8] = {
            level = LEVEL_WMOTR,
            area = 1,
            spawn = {x = -2630, y = -2110, z = -4590, yaw = 0x8000},
            music = { name = "Kobito of the Shining Needle ~ Little Princess (Mario Choir Mix) - Touhou 14: Double Dealing Character" }
        },
        [9] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = 0, y = -300, z = 3595, yaw = 0x8000},
            music = { name = "Ghost Valley - Super Mario Kart" }
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -2235, y = 4180, z = -1265, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_SULFUR,
            floodHeight = -6000,
            music = { name = "Spirit Mountain - Yoshi's Safari" }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 736, y = 2857, z = -2926, yaw = -0x4000 },
            flagBase = true,
            speed = 3.5,
            author = "BroDute",
            type = FLOOD_SNOW,
            startPos = { x = 379, y = -298, z = -7169, yaw = 0x9500, airborne = true },
            floodScale = 2.5,
            music = { name = "Frappe Snowland / Sherbet Land - Mario Kart 64" }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -5270, y = 3270, z = 12190, yaw =  0x6000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_WASTE,
            floodScale = 2.5,
            floodHeight = -5450,
            music = { name = "Creppy Castle - Donkey Kong 64" }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -9730, y =   3225, z =  -1850, yaw =  0x0000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 6235, y = -3705, z = 5290, yaw = -0x4000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideWater = true,
            launchpads = {
                { x = 3970, y = -15, z = 9410, yaw = 0x6000, vel = 300, forwardVel = 100, capTimer = 90 },
            },
            music = { name = "Dire, Dire Docks (Remix) - Super Mario 64" }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -6735, y = 950, z = -2410, yaw = 0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SUNSET,
            floodScale = 2.5,
            unwantedBhvs = { id_bhvBlueCoinSwitch, id_bhvWarpPipe },
            music = { name = "Gobi's Valley - Banjo-Kazooie" }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -1280, y = 5640, z = -9295, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_RAINBOW,
            floodScale = 2,
            floodHeight = -7000,
            act = 1,
            blockScale = 3,
            blocks = {
                { x = 1440, y = -2230, z = -9695, yaw = 0x0000 },
                { x = 1440, y = -1309, z = -9695, yaw = 0x0000 },
            },
            music = { name = "Rainbow Road - Mario Kart 64" }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -180, y = 1305, z = 8645, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_MOLTEN,
            startPos = { x = -25, y = -2240, z =  1185, yaw = 0x0000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Lost Gray Forest Temple Part",
            music = { name = "Bowser's Lava Lake Keep - Super Mario 3D World" }
        },
        {
            name = "bitdw2",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 8355, y = 1325, z = -805, yaw = 0x1000 },
            flagBase = true,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_SULFUR,
            startPos = { x = 1185, y = -2240, z = 0, yaw =  0x4000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Lost Blue Nightmare Sky Part",
            music = { name = "Bowser's Lava Lake Keep - Super Mario 3D World" }
        },
        {
            name = "bitdw3",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -655, y = 3770, z = -9685, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = 25, y = -2240, z = -1185, yaw = 0x8000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Lost Dat Letters Part",
            floodHeight = -5000,
            music = { name = "Bowser's Lava Lake Keep - Super Mario 3D World" }
        },
        {
            name = "bitdw4",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -5440, y = 3410, z = -2920, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_ACID,
            startPos = { x = -6230, y = -2685, z = 0, yaw = -0x4000, airborne = false },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Lost Toxic Tower Helix Climb Part",
            floodHeight = -4750,
            music = { name = "Bowser's Lava Lake Keep - Super Mario 3D World" }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 0, y = -300, z = 3595, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_SULFUR,
            startPos = { x = 0, y = 300, z = -3600, yaw = 0x0000, airborne = false, pipe = true },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Warp Zone",
            floodHeight = -2000,
            music = { name = "Ghost Valley - Super Mario Kart" }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -8140, y = 2200, z = -1355, yaw = 0x0000 },
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Toad Town Ruins - Mario & Luigi: Partners in Time" }
        },
        {
            name = "thi2",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 12970, y = 330, z = -12150, yaw = -0x6000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = 11995, y = -5070, z = -7830, yaw = 0x6000, airborne = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Block Park In The Back",
            music = { name = "Toad Town Ruins - Mario & Luigi: Partners in Time" }
        },
        {
            name = "thi3",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -3040, y = 3570, z =  11060, yaw =  0x8000 },
            flagBase = true,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = 475, y =  1920, z = -6600, yaw =  0x0000, airborne = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Small Path Of Floating Things",
            music = { name = "Toad Town Ruins - Mario & Luigi: Partners in Time" }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -6745, y =   3050, z =  -3640, yaw = -0x2000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SAND,
            floodHeight = -6700,
            music = { name = "A Soul as Red as a Ground Cherry" }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -10025, y = 3490, z = 8200, yaw = 0x5000 },
            speed = 3.75,
            author = "BroDute",
            type = FLOOD_POISON,
            startPos = { x = -2752, y = -2726, z = 346, yaw = 0x0000, airborne = true },
            floodScale = 2.5,
            floodHeight = -3880,
            music = { name = "In a Snow-Bound Land - Donkey Kong Country 2: Diddy's Kong Quest" }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 5370, y = 3475, z = 8600, yaw =  0x0000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_LAVA,
            startPos = { x = 1128, y = -2558, z = -6039, yaw = 0x8000, airborne = true },
            floodScale = 2.5,
            music = { name = "Never Gonna Give You Up - by Rick Astley" }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -1295, y = 3525, z = 1400, yaw = 0x4000 },
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = -3535, y = -4184, z = 4206, yaw = 0x2000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvSmallBully },
            launchpads = {
                { x = -3970, y = -15, z = 9410, yaw = -0x6000, vel = 300, forwardVel = 100, capTimer = 90 },
            },
            music = { name = "Thwomp Caverns - Mario & Luigi: Partners in Time" }
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 13330, y = 3190, z = 1320, yaw = 0x0000 },
            speed = 2.75,
            author = "BroDute",
            type = FLOOD_SULFUR,
            startPos = { x = -5585, y = -252, z = 11400, yaw = 0x2000, airborne = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            floodHeight = -4100,
            music = { name = "Pyramid Park - Mario Party 7" }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 450, y = 4750, z = 3880, yaw = -0x4000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = 5810, y = -3530, z = 1960, yaw = 0x0000, airborne = true },
            overrideName = "Forgotten Lands II",
            floodHeight = -6000,
            launchpads = {
                { x = -3170, y = 4105, z = 3875, yaw = 0x4000, vel = 100, forwardVel = 5 },
            },
            music = { name = "Lavender Town - Pokémon Red/Blue/Yellow" }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -5155, y = 747, z = 2515, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_SULFUR,
            startPos = { x = -5043, y = -1802, z = 2227, yaw = 0x8000, airborne = false, pipe = true },			
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Hidden Switch Palace - Blue Side",
            floodHeight = -4630,
            music = { name = "Mafland - Maf" }
        },
        {
            name = "pss2",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 10410, y = -150, z = 140, yaw = 0x8000 },
            flagBase = true,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_DESERT,
            startPos = { x = 10295, y = -597, z = 2540, yaw = -0x4000, airborne = false, pipe = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Hidden Switch Palace - Yellow Side",
            floodHeight = -4630,
            music = { name = "Mafland - Maf" }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 9105, y = 5325, z = 3570, yaw = 0x8000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_RAINBOW,
            floodScale = 2,
            floodHeight = -8000,
            launchpads = {
                { x = 1420, y = 1920, z = 3530, yaw = 9900, vel = 120, forwardVel = 0 },
                { x = 6040, y = -315, z = -2260, yaw = 29450, vel = 30, forwardVel = 0 }
            },
            blockScale = 2,
            blocks = {
                { x = -4385, y = -1966, z = -2565, yaw = -30375 },
                { x = -4385, y = -1352, z = -2565, yaw = -30375 }
            },
            music = { name = "Rainbow Road - Mario Kart 64" }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 0, y = 300, z = -3620, yaw = 0x0000 },
            flagBase = true,
            speed = 2.75,
            author = "BroDute",
            type = FLOOD_SULFUR,
            startPos = { x = 0, y = -300, z = 3690, yaw = 0x8000, airborne = false, pipe = true },			
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Back To The Warp Zone",
            music = { name = "Ghost Valley - Super Mario Kart" }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -3660, y = 4905, z = -11510, yaw = -0x2000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = -6494, y = -473, z = -6836, yaw = -5461, airborne = false, fading = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvFadingWarp, id_bhvWarpPipe },
            overrideName = "Magma Hexagon Spacebase I",
            floodHeight = -2250,
            music = { name = "Temple - Zelda II: The Adventure of Link" }
        },
        {
            name = "bitfs2",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 8360, y = 1395, z = -10045, yaw =  0x4000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_SAND,
            startPos = { x = 5919, y = -515, z = -6620, yaw = -24029, airborne = false, fading = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvFadingWarp, id_bhvWarpPipe },
            overrideName = "Sandy Hexagon Spacebase II",
            music = { name = "Temple - Zelda II: The Adventure of Link" }
        },
        {
            name = "bitfs3",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -10795, y = 4690, z = 12800, yaw = 0x4000 },
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_WASTE,
            startPos = { x = -8190, y = 1900, z =  6769, yaw =  0x0000, airborne = false, fading = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvFadingWarp, id_bhvWarpPipe },
            overrideName = "Mud Hexagon Spacebase III",
            floodHeight = -575,
            music = { name = "Temple - Zelda II: The Adventure of Link" }
        },
        {
            name = "bitfs4",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 5065, y = -640, z = 7410, yaw = 0x4000 },
            flagBase = true,
            speed = 5.75,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 10980, y = -2580, z =  9905, yaw = -0x4000, airborne = false, fading = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvFadingWarp, id_bhvWarpPipe },
            overrideName = "Water Hexagon Spacebase IV",
            music = { name = "Temple - Zelda II: The Adventure of Link" }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 8977, y = 2431, z = -5000, yaw = 0x0000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            floodScale = 2.5,
            overrideName = "Forgotten Lands III",
            floodHeight = -6790,
            music = { name = "Undersea Palace - Chrono Trigger" }
        },
        {
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -1415, y = 6930, z = -5260, yaw = 0x0000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = -5065, y = -1820, z = 780, yaw = -0x4000, airborne = true },
            floodScale = 2.5,
            overrideName = "Roof Of The Big Castle",
            launchpads = {
                { x = -8910, y = 920, z = 2085, yaw = 0x2000, vel = 100, forwardVel = 80, capTimer = 150 },
                { x = 2770, y = 1000, z = 6360, yaw = 0x8000, vel = 300, forwardVel = 90, capTimer = 120 },
            },
            music = { name = "Undersea Palace - Chrono Trigger" }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -5885, y =  9670, z = 2095, yaw = 0x0000 },
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = 3548, y = -7582, z = 9092, yaw = 0x0000, airborne = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Koopa's Road (Dark Remix) - Super Mario 64" }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 2180, y =    525, z =   1990, yaw =  0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            unwantedBhvs = { id_bhvFadingWarp },
            overrideName = "Forbidden Zone",
            floodHeight = -4280,
            music = { name = "Kobito of the Shining Needle ~ Little Princess (Mario Choir Mix) - Touhou 14: Double Dealing Character" }
        }
    }
end
     
-- King Boo's Revenge 2, ported to Flood by Jzzay, Bear64DX and ★~¡TOÑO!~★
local function flood_load_king_boos_revenge_2_levels()
    game = GAME_KING_BOOS_REVENGE_2
    romhackInfo = "King Boo's Revenge 2"
	romhackLogo = get_texture_info("logo_kbr2")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 7710, y = 1575, z = 6682, yaw = 24576 },
            music = { name = "Another Medium - Undertale" }			
        },
        [2] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 7313, y = -3909, z = -5692, yaw = 0x0000 },
            music = { name = "Another Medium - Undertale" }					
		},	
        [3] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -6587, y = 190, z = -21210, yaw = 0x0000 },
            music = { name = "An Empty Tome - Castlevania: Order of Ecclesia" }				
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 19670, y = -465, z = 7675, yaw = -0x4000 },
            flagBase = true,
            speed = 1.5,
            author = "thebloody7",
            type = FLOOD_WASTE,
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },			
            floodHeight = -5380,
            music = { name = "Santalune Foresst - Pokémon X/Y" }			
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 3065, y = 8040, z = -4560, yaw = -0x4000 },
            speed = 5.5,
            author = "thebloody7",
            type = FLOOD_DARKNESS,
            floodScale = 2.5,
            music = { name = "Sky Peak Snowfield - Pokémon Mystery Dungeon: Explorers Of Sky" }			
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 7535, y = 17060, z = -14615, yaw = 0x4000 },
            speed = 3.0,
            author = "thebloody7",
            type = FLOOD_WATER,
            floodScale = 3.5,
            floodHeight = 1010,
            music = { name = "Sunyshore City (Day) - Pokémon Diamond/Pearl/Platinum" }			
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 15160, y = 17420, z = -1855, yaw = 0x0000 },
            flagBase = true,
            speed = 3.75,
            author = "thebloody7",
            type = FLOOD_SAND,
            floodScale = 2.5,	
            floodHeight = -1500,
            music = { name = "The Subcom Caves - A Hat In Time" }			
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -2297, y = 5468, z = -940, yaw = 0x0000 },
            flagBase = true,
            speed = 1.5,
            author = "sizzlingmario4",
            type = FLOOD_MOLTEN,
            startPos = { x = -13618, y = 1315, z = -2160, yaw = 0x4000, airborne = true },			
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },					
            floodHeight = -2000,
            music = { name = "Cave of Flames - The Legend Of Zelda: The Minish Cap" }			
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 3275, y = 4565, z = -22300, yaw = 0x4000 },
            speed = 2.5,
            author = "thebloody7",
            type = FLOOD_WATER,
            startPos = { x = 17, y = -4473, z = 39, yaw = 0x8000, airborne = true },
            floodScale = 2.75,
            music = { name = "The Subcon Caves - A Hat In Time" }			
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -6735, y = 18700, z = 14085, yaw = 0x8000 },
            speed = 2.5,
            author = "sizzlingmario4",
            type = FLOOD_MAGMA,
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            floodHeight = -4250,
            music = { name = "Lava Rock Lair - Super Mario 3D World" }			
        },
        {
            name = "b1",
            level = LEVEL_BOWSER_1,
            area = 1,
            flagPos = { x = 2120, y = 15005, z = 2330, yaw = 0x8000 },
            flagBase = true,
            speed = 2.0,
            author = "sizzlingmario4",
            type = FLOOD_POISON,
            startPos = { x = -3386, y = -1548, z = -5923, yaw = 0x0000, airborne = true },
            floodScale = 1.5,
            overrideName = "King Boo's Hungry Plants",
            music = { name = "10 Hours Of Absolute Silence - by Trollmann" }			
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -6735, y = 8755, z = 530, yaw = 0x4000 },
            speed = 2.0,
            author = "sizzlingmario4",
            type = FLOOD_DARKNESS,
            startPos = { x = 1985, y = -2396, z = 2072, yaw = -0x4000, airborne = true },
            floodScale = 2.5,
            music = { name = "Through the Sea of Time - Pokémon Mystery Dungeon: Explorers Of Time/Darkness/Sky" }			
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 10360, y = 11525, z = -10180, yaw = 0x4000 },
            speed = 3.0,
            author = "thebloody7",
            type = FLOOD_MAGMA,
            floodScale = 2.5,
            music = { name = "Alpine Skyline Time Rift - A Hat In Time" }			
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -5050, y = 9512, z = -3915, yaw = -0x4000 },
            speed = 1.6,
            author = "sizzlingmario4",
            type = FLOOD_SNOW,
            startPos = { x = -6875, y = 1994, z = -2005, yaw = 0x4000, airborne = true },
            floodScale = 2.5,
            music = { name = "Examination ~ Moderate 2002 - Phoenix Wright: Ace Attorney - Justice For All (DS)" }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -1095, y = 9006, z = -8668, yaw = -0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "sizzlingmario4",
            type = FLOOD_POISON,
            floodScale = 2.75,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Forsaken Fortress - The Legend Of Zelda: The Wind Water" }			
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 18675, y = 11255, z = -13250, yaw = 0x4000 },
            flagBase = true,
            speed = 1.75,
            author = "thebloody7",
            type = FLOOD_POISON,
            startPos = { x = 18160, y = -1050, z = -14560, yaw = 20985, airborne = false },
            floodScale = 3,
            music = { name = "Original Composition - by ToasterKetchup" }			
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 6720, y = 11475, z = 4185, yaw = 0x0000 },
            flagBase = true,
            speed = 2.75,
            author = "thebloody7",
            type = FLOOD_SULFUR,
            startPos = { x = -3740, y = -4660, z = 2910, yaw = -0x4000, airborne = false },			
            floodScale = 2.5,
            unwantedBhvs = { id_bhvGoomba },
            pipes = {
                {
                    { x = 5530, y = 6220, z = 12040 },
                    { x = 3445, y = 7104, z = 18465, yaw = -0x6000 }									
                },
            },
            music = { name = "Bonneton - Super Mario Odyssey" }			
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -5760, y = 10720, z = -6455, yaw = 0x0000 },
            speed = 3.0,
            author = "thebloody7",
            type = FLOOD_DARKNESS,
            floodScale = 3,
            music = { name = "Original Composition - by Deven Latulippe" }			
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -8175, y = 7345, z = 9500, yaw = 0x0000 },
            speed = 3.5,
            author = "sm64pie",
            type = FLOOD_TIDE,
            floodScale = 3,
            floodHeight = -5950,
            music = { name = "Crisis City - Sonic The Hedgehog (2006)" }			
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 7775, y = 16680, z = -4100, yaw = 0x0000 },
            speed = 1.5,
            author = "sizzlingmario4",
            type = FLOOD_MUD,
            startPos = { x = -730, y = 466, z = 12875, yaw = -11015, airborne = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Lower Brine Cave - Pokémon Mystery Dungeon: Explorers Of Time/Darkness/Sky" }			
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 15990, y = 3250, z = -6650, yaw = 0x0000 },
            flagBase = false,
            speed = 1.8,
            author = "sizzlingmario4",
            type = FLOOD_WATER,
			floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Haunted Chase - Donkey Kong Country 2: Diddy's Kong Quest" }			
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -9060, y = 10507, z = -7920, yaw = 0x8000 },
            speed = 1.5,
            author = "thebloody7",
            type = FLOOD_DARKNESS,
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            floodHeight = -4860,	
            music = { name = "Dark Crater - Pokémon Mystery Dungeon: Explorers Of Time/Darkness/Sky" }			
        },
        {
            name = "b2",
            level = LEVEL_BOWSER_2,
            area = 1,
            flagPos = { x = -1340, y = 17968, z = -225, yaw = 0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "thebloody7",
            type = FLOOD_DARKNESS,
            startPos = { x = -5170, y = 927, z = -11165, yaw = 0x4000, airborne = true },			
            floodScale = 2,
            overrideName = "King Boo's Spectral Fortress",
            floodHeight = 0,
            music = { name = "Original Composition - by Deven Latulippe" }			
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -6580, y = 6880, z = -8495, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "sizzlingmario4",
            type = FLOOD_POISON,
            floodScale = 2.5,
            floodHeight = 0,
            music = { name = "Hidden Highland - Pokémon Mystery Dungeon: Explorers Of Time/Darkness/Sky" }			
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -13785, y = 15110, z = 12810, yaw = -0x4000 },
            speed = 3.5,
            author = "thebloody7",
            type = FLOOD_POISON,
            startPos = { x = -1080, y = -5160, z = -9070, yaw = 0x8000, airborne = true },
            floodScale = 3,
            music = { name = "Satori Maiden ~ 3rd Eye - Touhou 11: Subterranean Animism" }			
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 10230, y = 5775, z = 4445, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "thebloody7",
            type = FLOOD_FROSTBITE,
            startPos = { x = 15830, y = -6740, z = 2420, yaw = 0x0000, airborne = true },
            floodScale = 2.5,
            music = { name = "Ragged Mountain - Pokémon Mystery Dungeon: Gates to Infinity" }			
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 21535, y = 11594, z = -9967, yaw = 0x8000 },
            speed = 2.0,
            author = "thebloody7",
            type = FLOOD_DARKNESS,
            startPos = { x = 9719, y = -5415, z = 12459, yaw = 0x2000, airborne = true },
            floodScale = 3,
            music = { name = "Subcon Village - A Hat In Time" }			
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -4430, y = 9154, z = 11690, yaw = 0x0000 },
            flagBase = true,
            speed = 2.0,
            author = "sizzlingmario4",
            type = FLOOD_MAGMA,
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            floodHeight = -5250,
            music = { name = "Tenth Zone East - F-Zero: Maximun Velocity" }			
        },
        {
            name = "ending",
            level = LEVEL_ENDING,
            area = 1,
            flagPos = { x = 13500, y = 16100, z = 2000, yaw = 0x8000 },
            speed = 1.75,
            author = "thebloody7",
            type = FLOOD_POISON,
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            floodHeight = -5300,
            music = { name = "A Popular Location - Touhou 3.5: Hopeless Masquerade" }			
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -4340, y = 2680, z = -19895, yaw = 0x8000 },
            speed = 1.25,
            author = "thebloody7 & sizzlingmario4",
            type = FLOOD_WATER,
            floodScale = 4,
            floodHeight = -8040,
            music = { name = "Dungeon Cave - Skies Of Arcadia" }			
        },
        {
            name = "b3",
            level = LEVEL_BOWSER_3,
            area = 1,
            flagPos = { x = -5268, y = -665, z = 7059, yaw = -0x4000 },
            flagBase = true,
            speed = 0.75,
            author = "thebloody7 & sizzlingmario4",
            type = FLOOD_DARKNESS,
            floodScale = 3.5,
            overrideName = "King Boo's Final Showdown",
            floodHeight = -8100,
            music = { name = "Factory Inspection - Kirby 64: The Crystal Shards" }			
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = -3920, y = 5740, z = 1100, yaw = 0x8000 },
            flagBase = true,
            speed = 3.5,
            author = "thebloody7 & sizzlingmario4",
            type = FLOOD_WASTE,
            startPos = { x = 7710, y = 1575, z = 6682, yaw = 24576, airborne = true },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "King Boo's Grounds",
            floodHeight = -1000,
            music = { name = "Another Medium - Undertale" }			
        },
        {
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -3290, y = 6000, z = -1175, yaw = 0x0000 },
            speed = 2.5,
            author = "thebloody7 & sizzlingmario4",
            type = FLOOD_POISON,
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "King Boo's Realm",
            floodHeight = -8895,
            music = { name = "Another Medium - Undertale" }			
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 8900, y = 2690, z = -10250, yaw = 0x0000 },
            flagBase = true,
            speed = 1.75,
            author = "thebloody7 & sizzlingmario4",
            type = FLOOD_WATER,
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "King Boo's Abyss",			
            floodHeight = -3000,		
            music = { name = "An Empty Tome - Castlevania: Order of Ecclesia" }			
        }
    }
end

-- Winterbottom's Pie Trials, ported to Flood by Bear64DX
local function flood_load_winterbottoms_pie_trials_levels()
    game = GAME_WINTERBOTTOMS_PIE_TRIALS
    romhackInfo = "Winterbottom's Pie Trials"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 3346, z = 8156, yaw = 0x8000}
        }
    }

    gLevels = {
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = -5335, y = 6095, z = -2823, yaw = 0x4000 },
            flagBase = false,
            speed = 2.2,
            author = "Captain T",
            type = FLOOD_WATER,
            startPos = { x = -9, y = 3346, z = 8669, yaw = 0x8000 },
            floodScale = 2.5,
            overrideName = "The Pie Trials"
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 12575, y = -3889, z = 4641, yaw = -0x4000 },
            flagBase = true,
            speed = 1.6,
            author = "Captain T",
            type = FLOOD_ACID,
            startPos = { x = -7010, y = -6137, z = 2164, yaw = 0x0000},
            floodScale = 2.5
        },
    }
end

-- Ztar Attack 2, ported to Flood by Bear64DX
local function flood_load_ztar_attack_2_levels()
    game = GAME_ZTAR_ATTACK_2
    romhackInfo = "Ztar Attack 2 - A Blast to the Past"
    romhackLogo = get_texture_info("logo_za2")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -15830, y = 1842, z = -23787, yaw = -0x1000 },
            speed = 1.5,
            author = "TheGael95",
            type = FLOOD_WATER,
            startPos = { x = 15269, y = -3389, z = 20247, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -6215, y = -561, z = 6221, yaw = 0x3000 },
            speed = 2.6,
            author = "TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -2622, y = -4059, z = 5660, yaw = 0x6000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -5432, y = 430, z = 9215, yaw = 0x0000 },
            speed = 1.8,
            author = "TheGael95",
            type = FLOOD_WATER,
            startPos = { x = 4797, y = -6114, z = 7999, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -5531, y = 6743, z = -4288, yaw = 0x4000 },
            speed = 1.85,
            author = "TheGael95",
            type = FLOOD_WATER,
            startPos = { x = 10216, y = -3166, z = 7288, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 16296, y = 186, z = -11672, yaw = -0x2000 },
            speed = 1.7,
            author = "TheGael95",
            type = FLOOD_DESERT,
            startPos = { x = -5693, y = -1926, z = -3680, yaw = 0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 27609, y = -669, z = -13417, yaw = 0x8000 },
            speed = 2.2,
            author = "TheGael95",
            type = FLOOD_DESERT,
            startPos = { x = -19953, y = -4396, z = -13052, yaw = -0x6000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -6841, y = 14, z = 5606, yaw = -0x4000 },
            speed = 2.6,
            author = "TheGael95",
            type = FLOOD_WASTE,
            startPos = { x = -11812, y = -8076, z = 12343, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 4258, y = -273, z = 677, yaw = -0x4000 },
            speed = 2.8,
            author = "TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -14514, y = -4994, z = 9017, yaw = 0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 3276, y = 1793, z = -8931, yaw = 0x4000 },
            speed = 2.9,
            author = "TheGael95",
            type = FLOOD_WASTE,
            startPos = { x = 14743, y = -1178, z = 2272, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 12458, y = 121, z = 13564, yaw = -0x4000 },
            speed = 3.1,
            author = "TheGael95",
            type = FLOOD_WASTE,
            startPos = { x = 22298, y = -8622, z = 2135, yaw = -0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 5897, y = 1332, z = 9064, yaw = -0x4000 },
            speed = 1.2,
            author = "TheGael95",
            type = FLOOD_WATER,
            startPos = { x = 17401, y = -1834, z = -4598, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 9841, y = 5141, z = -7024, yaw = 0x0000 },
            speed = 3.5,
            author = "TheGael95",
            type = FLOOD_LAVA,
            startPos = { x = -11066, y = -4980, z = 20912, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -11333, y = 8628, z = 3308, yaw = 0x4000 },
            speed = 0.2,
            author = "TheGael95",
            type = FLOOD_LAVA,
            startPos = { x = 13828, y = 1735, z = 758, yaw = -0x5000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -15729, y = 2200, z = 1098, yaw = 0x8000 },
            speed = 1.5,
            author = "TheGael95",
            type = FLOOD_LAVA,
            startPos = { x = 10287, y = -2389, z = 17274, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -15559, y = 1649, z = 4903, yaw = 0x8000 },
            speed = 2.1,
            author = "TheGael95",
            type = FLOOD_LAVA,
            startPos = { x = 6593, y = -3766, z = 12598, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -4409, y = 12169, z = 1722, yaw = 0x6000 },
            speed = 15,
            author = "TheGael95",
            type = FLOOD_LAVA,
            startPos = { x = -654, y = 337, z = 15222, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 6009, y = 8953, z = -6641, yaw = -0x2000 },
            speed = 3.0,
            author = "TheGael95",
            type = FLOOD_WATER,
            startPos = { x = -3861, y = -5835, z = 13371, yaw = 0x7000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
    }
end

-- Super Mario and the Grand Star, ported to Flood by Bear64DX
local function flood_load_grand_star_levels()
    game = GAME_GRAND_STAR
    romhackInfo = "Super Mario and the Grand Star"
	romhackLogo = get_texture_info("logo_smatgs")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = { x = 414, y = 0, z = -428, yaw = 0x8000 }
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 7627, y = 1981, z = -12558, yaw = 0x0000 },
            flagBase = true,
            speed = 3.4,
            author = "Grand Star",
            type = FLOOD_WATER,
            startPos = { x = 4139, y = 0, z = -2128, yaw = 0x7000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 10985, y = 10582, z = -15294, yaw = 0x4000 },
            flagBase = true,
            speed = 3,
            author = "Grand Star",
            type = FLOOD_LAVA,
            startPos = { x = 8268, y = 3810, z = -15272, yaw = 0x2000 },
            floodScale = 4,
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -150, y = 6096, z = -21463, yaw = 0x0000 },
            speed = 2,
            author = "Grand Star",
            type = FLOOD_WATER,
            startPos = { x = 53, y = 2286, z = 3, yaw = 0x8000 },
            floodScale = 3
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 7648, y = 2134, z = -10891, yaw = 0x4000 },
            speed = 3.0,
            author = "Grand Star",
            type = FLOOD_WASTE,
            startPos = { x = 7635, y = 0, z = -2763, yaw = 0x8000 },
            floodScale = 2.5
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 380, y = 5334, z = -9822, yaw = 0x0000 },
            flagBase = true,
            speed = 3.4,
            author = "Grand Star",
            type = FLOOD_WATER,
            startPos = { x = 389, y = 305, z = -341, yaw = 0x8000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 11554, y = 3658, z = -18313, yaw = 0x4000 },
            speed = 3,
            author = "Grand Star",
            type = FLOOD_ACID,
            startPos = { x = 11439, y = 762, z = -9850, yaw = 0x8000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 14987, y = 6668, z = -22394, yaw = -0x4000 },
            speed = 2.2,
            author = "Grand Star",
            type = FLOOD_WATER,
            startPos = { x = 9081, y = 0, z = -1939, yaw = 0x8000 },
            floodScale = 2.7
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 19387, y = 3048, z = -23184, yaw = 0x0000 },
            flagBase = true,
            speed = 1.5,
            author = "Grand Star",
            type = FLOOD_LAVA,
            startPos = { x = 9562, y = 1524, z = -4296, yaw = 0x4000 },
            floodScale = 3.1,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 7059, y = 2134, z = -20385, yaw = 0x1000 },
            flagBase = true,
            speed = 3.5,
            author = "Grand Star",
            type = FLOOD_DESERT,
            startPos = { x = 11476, y = 0, z = -7395, yaw = 0x8000 },
            floodScale = 3
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 3817, y = 3429, z = 11095, yaw = 0x8000 },
            speed = 1.5,
            author = "Grand Star",
            type = FLOOD_WATER,
            startPos = { x = 3803, y = 1143, z = -11320, yaw = 0x0000 },
            floodScale = 2.5
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -20, y = 5851, z = -8979, yaw = 0x6000 },
            speed = 2.0,
            author = "Grand Star",
            type = FLOOD_POISON,
            startPos = { x = -30, y = 1143, z = 147, yaw = 0x8000 },
            floodScale = 2.5
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -2258, y = 4953, z = -14666, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "Grand Star",
            type = FLOOD_CLOUDS,
            startPos = { x = 1905, y = 1905, z = -717, yaw = 0x8000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvMessagePanel, id_bhvKoopa }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 7444, y = 5607, z = -26021, yaw = -0x4000 },
            flagBase = true,
            speed = 2.7,
            author = "Grand Star",
            type = FLOOD_LAVA,
            startPos = { x = 49, y = 0, z = -42, yaw = 0x8000 },
            floodScale = 3.5
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 763, y = 15240, z = -332, yaw = 0x8000 },
            flagBase = true,
            speed = 8,
            author = "Grand Star",
            type = FLOOD_WATER,
            startPos = { x = 13858, y = 3048, z = -4596, yaw = -0x4000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 14852, y = 1676, z = -5081, yaw = 0x0000 },
            speed = 2.2,
            author = "Grand Star",
            type = FLOOD_LAVA,
            startPos = { x = 414, y = 0, z = -433, yaw = 0x8000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 6881, y = 2286, z = -1587, yaw = -0x4000 },
            flagBase = true,
            speed = 2.8,
            author = "Grand Star",
            type = FLOOD_LAVA,
            startPos = { x = 2708, y = 0, z = -9276, yaw = -0x1000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 7760, y = 2667, z = -15011, yaw = 0x0000 },
            speed = 2.8,
            author = "Grand Star",
            type = FLOOD_LAVA,
            startPos = { x = 5011, y = 0, z = -416, yaw = 0x8000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe }
        },
    }
end

-- Star Revenge 6.9: Luigi Lost in Time, ported to Flood by Bear64DX
local function flood_load_star_revenge_6_9_levels()
    game = GAME_STAR_REVENGE_6_9
    romhackInfo = "Star Revenge 6.9: Luigi Lost In Time"
	romhackLogo = get_texture_info("logo_sr6.9")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -68, y = 5718, z = -11269, yaw = 0x0000 },
            flagBase = false,
            speed = 3.3,
            author = "BroDute",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 285, y = 3499, z = -1560, yaw = 0x0000 },
            flagBase = false,
            speed = 4.3,
            author = "BroDute",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -1085, y = 888, z = -1009, yaw = 0x9000 },
            flagBase = false,
            speed = 3.3,
            author = "BroDute",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -11957, y = -269, z = 15361, yaw = 0x8000 },
            flagBase = false,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -9239, y = -375, z = 4944, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 4502, y = 269, z = -6090, yaw = 0x0000 },
            flagBase = false,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            floodScale = 2,
            overrideName = "Void of Darkness",
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -995, y = 1285, z = -5495, yaw = -0x2000 },
            flagBase = false,
            speed = 2.3,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -700, y = -1016, z = -84, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
    }
end

-- Star Revenge 4.5: The Kedama Takeover Rewritten, ported to Flood by SausRelics
local function flood_load_star_revenge_4_5_levels()
    game = GAME_STAR_REVENGE_4_5
    romhackInfo = "Star Revenge 4.5: The Kedama Takeover Redone"
	romhackLogo = get_texture_info("logo_sr4.5")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

gLevels = {
    {
        name = "bob",
        level = LEVEL_BOB,
        area = 1,
        flagPos = { x = -7334, y = 2845, z = 2039, yaw = 0x6000 },
        flagBase = false,
        speed = 3.9,
        author = "BroDute",
        type = FLOOD_WATER,
        startPos = { x = 2794, y = -2048, z = 8618, yaw = -0x4000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "wf",
        level = LEVEL_WF,
        area = 1,
        flagPos = { x = -2637, y = 1554, z = -9872, yaw = -0x2000 },
        flagBase = false,
        speed = 3.2,
        author = "BroDute",
        type = FLOOD_WATER,
        startPos = { x = -11983, y = -2285, z = -5906, yaw = 0x0000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "ccm",
        level = LEVEL_CCM,
        area = 1,
        flagPos = { x = 17581, y = 1935, z = -7011, yaw = -0x4000 },
        flagBase = false,
        speed = 3.3,
        author = "BroDute",
        type = FLOOD_LAVA,
        startPos = { x = 2062, y = -1274, z = 722, yaw = 0x8000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "jrb",
        level = LEVEL_JRB,
        area = 1,
        flagPos = { x = 9804, y = 1723, z = 3265, yaw = 0x8000 },
        flagBase = false,
        speed = 1.8,
        author = "BroDute",
        type = FLOOD_WATER,
        startPos = { x = 12119, y = -1223, z = 7410, yaw = -0x4000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "bitdw",
        level = LEVEL_BITDW,
        area = 1,
        flagPos = { x = 6252, y = 3600, z = 5976, yaw = 0x4000 },
        flagBase = false,
        speed = 2.0,
        author = "BroDute",
        type = FLOOD_LAVA,
        startPos = { x = 694, y = -1415, z = 6229, yaw = 0x0000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "bbh",
        level = LEVEL_BBH,
        area = 1,
        flagPos = { x = 11104, y = 671, z = 4403, yaw = 0x8000 },
        flagBase = false,
        speed = 2.3,
        author = "BroDute",
        type = FLOOD_LAVA,
        startPos = { x = -1370, y = -497, z = -11979, yaw = 0x4000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "vcutm",
        level = LEVEL_VCUTM,
        area = 1,
        flagPos = { x = 3285, y = 517, z = -2237, yaw = -0x4000 },
        flagBase = false,
        speed = 4.0,
        author = "BroDute",
        type = FLOOD_WATER,
        startPos = { x = 698, y = -4466, z = -2307, yaw = 0x4000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "hmc",
        level = LEVEL_HMC,
        area = 1,
        flagPos = { x = -8426, y = -770, z = -3383, yaw = 0x8000 },
        flagBase = false,
        speed = 3.2,
        author = "BroDute",
        type = FLOOD_POISON,
        startPos = { x = -3236, y = -3830, z = 1118, yaw = 0x4000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "lll",
        level = LEVEL_LLL,
        area = 1,
        flagPos = { x = 2719, y = 3134, z = 8212, yaw = -0x4000 },
        flagBase = false,
        speed = 2.4,
        author = "BroDute",
        type = FLOOD_POISON,
        startPos = { x = 4323, y = -106, z = 4127, yaw = -0x3000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "ssl",
        level = LEVEL_SSL,
        area = 1,
        flagPos = { x = 3313, y = 1947, z = -6650, yaw = -0x8000 },
        flagBase = false,
        speed = 3.0,
        author = "BroDute",
        type = FLOOD_WATER,
        startPos = { x = -7866, y = -196, z = -11686, yaw = 0x0000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "ddd",
        level = LEVEL_DDD,
        area = 1,
        flagPos = { x = 638, y = 1635, z = -3294, yaw = 0x0000 },
        flagBase = false,
        speed = 3.0,
        author = "BroDute",
        type = FLOOD_LAVA,
        startPos = { x = 1612, y = -1947, z = -1612, yaw = 0x4000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "bitfs",
        level = LEVEL_BITFS,
        area = 1,
        flagPos = { x = 797, y = -763, z = 3700, yaw = 0x2000 },
        flagBase = false,
        speed = 3.5,
        author = "BroDute",
        type = FLOOD_POISON,
        startPos = { x = 3293, y = -3057, z = 9766, yaw = 0x8000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "wdw",
        level = LEVEL_WDW,
        area = 1,
        flagPos = { x = -3253, y = 1291, z = -495, yaw = 0x4000 },
        flagBase = false,
        speed = 3.4,
        author = "BroDute",
        type = FLOOD_WATER,
        startPos = { x = 1514, y = -3540, z = -2853, yaw = 0x0000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "ttm",
        level = LEVEL_TTM,
        area = 1,
        flagPos = { x = -4769, y = 3440, z = 12686, yaw = -0x4000 },
        flagBase = false,
        speed = 2.9,
        author = "BroDute",
        type = FLOOD_WATER,
        startPos = { x = -6713, y = -3768, z = 23, yaw = 0x0000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "thi",
        level = LEVEL_THI,
        area = 1,
        flagPos = { x = -12597, y = 2624, z = -5743, yaw = 0x4000 },
        flagBase = false,
        speed = 3.0,
        author = "BroDute",
        type = FLOOD_LAVA,
        startPos = { x = -1253, y = -1855, z = 2747, yaw = -0x8000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "ttc",
        level = LEVEL_TTC,
        area = 1,
        flagPos = { x = 5823, y = 5654, z = 490, yaw = 0x4000 },
        flagBase = false,
        speed = 4.5,
        author = "BroDute",
        type = FLOOD_WATER,
        startPos = { x = 0, y = 480, z = -1281, yaw = 0x0000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "sl",
        level = LEVEL_SL,
        area = 1,
        flagPos = { x = -5068, y = 2562, z = -3882, yaw = 0x8000 },
        flagBase = false,
        speed = 4.3,
        author = "BroDute",
        type = FLOOD_DESERT,
        startPos = { x = -8217, y = -3416, z = 4495, yaw = 0x4000 },
        unwantedBhvs = { id_bhvWarpPipe }
    },
    {
        name = "rr",
        level = LEVEL_RR,
        area = 1,
        flagPos = { x = 6167, y = 4542, z = 1639, yaw = 0x0000 },
        flagBase = false,
        speed = 3.0,
        author = "BroDute",
        type = FLOOD_WATER,
        startPos = { x = -504, y = -4510, z = 592, yaw = 0x4000 },
        unwantedBhvs = { id_bhvWarpPipe }
        },
    }
end

-- Star Revenge 2 Act 2: Night of Doom, ported to Flood by Bear64DX & SuperRodrigo0
local function flood_load_star_revenge_2_levels()
    game = GAME_STAR_REVENGE_2
    romhackInfo = "Star Revenge 2 Act 2: Night of Doom"
    romhackLogo = get_texture_info("logo_sr2a2")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 5940, y = -935, z = 3990, yaw = -0x4000},
            music = { name = "Gruntilda's Lair (Main) - Banjo-Kazooie" }
        },
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -4700, y = -1680, z = -4230, yaw = 0x0000},
            music = { name = "Gruntilda's Lair (Main) - Banjo-Kazooie" }
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -3185, y = -2590, z = -115, yaw = 0x4000},
            deathHeight = -3800,
            pipes = {
                {
                    { x = 1682, y = -1665, z = 1627, yaw = 0x8000 },
                    { x = -2901, y = 198, z = -117, yaw = 0x4000 }
                },
                {
                    { x = 1682, y = 521, z = 1627, yaw = 0x8000 },
                    { x = -214, y = 2274, z = 732, yaw = 0x8000 }
                }
            },
            music = { name = "The Dungeon is Full of Monsters - Super Mario RPG: Legend of the Seven Stars" }
        },
        [4] = {
            level = LEVEL_TOTWC,
            area = 1,
            spawn = {x = -7155, y = 1625, z = -2875, yaw = 0x0000},
            unwantedBhvs = { id_bhvSnufit, id_bhvFlyGuy },
            music = { name = "Space Junk Galaxy - Super Mario Galaxy" }
        },
        [5] = {
            level = LEVEL_SL,
            area = 1,
            spawn = {x = -945, y = -7775, z = 590, yaw = 0x0000},
            unwantedBhvs = { id_bhvBobombBuddy },
            music = { name = "Library Piano - Luigi's Mansion: Dark Moon" }
        },
        [6] = {
            level = LEVEL_BOWSER_3,
            area = 1,
            spawn = {x = -5, y = 307, z = -50, yaw = 0x0000},
            music = { name = "Ultimate Koopa - Super Mario 64" }
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -290, y = 3620, z = -655, yaw = -0x2000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_SAND,
            floodHeight = -5600,
            music = { name = "Gerudo Desert - The Legend of Zelda: Twilight Princess" }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 2307, y = 3637, z = 2592, yaw = 0x8000 },
            flagBase = true,
            speed = 2.75,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = -1245, y = -4850, z = 8622, yaw = 0x8000, airborne = true },
            music = { name = "In A Snow-Bound Land - Donkey Kong Country 2: Diddy's Kong Quest" }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -2120, y = 3799, z = 9220,  yaw = 0x6000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_WASTE,
            startPos = { x = -4400, y = -1630, z = -8945, yaw = 0x4000, airborne = true },
            floodScale = 2.5,
            floodHeight = -3750,
            music = { name = "Creepy Castle - Donkey Kong 64" }
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -8291, y = 1690, z = 963, yaw = 0x3000 },
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_WASTE,
            floodScale = 2.5,
            overrideName = "Way To The Lonely House",
            floodHeight = -1500,
            music = { name = "Creepy Castle - Donkey Kong 64" }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 8510, y = 5280, z = -6145, yaw = -0x4000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_SULFUR,
            startPos = { x = -3135, y = -905, z = 3765, yaw = 0x4000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe },
            launchpads = {
                { x = 1515, y = 2170, z = 635, yaw = 0x8000, vel = 80, forwardVel = 0 },
            },
            capTimer = 1,
            music = { name = "Red Mountain - Bomberman 64" }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 14483, y = 4835, z = 2627, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_SNOW,
            startPos = { x = 10400, y = -6870, z = -5835, yaw = -11335, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "The 2nd Snow Level",
            overrideWater = true,
            music = { name = "A Snow Light - Tales of Symphonia" }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -1284, y = 6662, z = -741,  yaw = 0x8000 },
            flagBase = true,
            speed = 0.75,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            floodScale = 2.5,
            music = { name = "Twilight - The Legend of Zelda: Twilight Princess" }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -7661, y = 6467, z = -4869, yaw = 0x0000 },
            flagBase = true,
            speed = 1.75,
            author = "BroDute",
            type = FLOOD_ACID,
            floodScale = 1.75,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvPushableMetalBox },
            overrideWater = true,
            music = { name = "Bunker 2 - GoldenEye 007" }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -3670, y = 9250, z = 8530, yaw = 0x8000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = 93, y = -3875, z = 2372, yaw = 0x0000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvPushableMetalBox },
            music = { name = "Stone Tower Temple - The Legend of Zelda: Majora's Mask" }
        },
        {
            name = "b1",
            level = LEVEL_BOWSER_1,
            area = 1,
            flagPos = { x = -336, y = 155,  z = -1277, yaw = 0x6000 },
            flagBase = true,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_WASTE,
            startPos = { x = -6250, y = 205, z = 2710, yaw = 0x8000, airborne = true },
            floodScale = 1.5,
            overrideName = "Bause's Old Domain",
            music = { name = "Creepy Castle - Donkey Kong 64" }
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -11780, y = 6315, z = -8495, yaw = 0x4000 },
            flagBase = true,
            speed = 3.25,
            author = "BroDute",
            type = FLOOD_SAND,
            floodScale = 2,
            startPos = { x = 700, y = -10560, z = -1175, yaw = 0x2000, airborne = true },
            launchpads = {
                { x = 7265, y = -6865, z = 2580, yaw = -0x2000, vel = 150, forwardVel = 0 },
                { x = 5770, y = -4000, z = 4495, yaw = -0x2000, vel = 80, forwardVel = 0 },
                { x = -165, y = -2570, z = 3600, yaw =  0x8000, vel = 110, forwardVel = 0 },
                { x = -5170, y = 360, z = -1315, yaw =  0x8000, vel = 100, forwardVel = 0 },
                { x = -5530, y = 3350, z = -7185, yaw =  0x8000, vel = 60, forwardVel = 0 },
            },
            overrideSlide = true,
            music = { name = "Medley of Main Themes - Castlevania: Legacy of Darkness" }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -3279, y = 858, z = 1916, yaw = 0x8000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_SAND,
            startPos = { x = 905, y = -364, z = 2056, yaw = -15291, airborne = false, pipe = true },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            floodHeight = -2250,
            music = { name = "Purple Comet - Super Mario Galaxy" }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 2935, y = 5488, z = 10020, yaw = 0x6000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = 11310, y = -2790, z = -10732, yaw = 0x0000, airborne = true },	
            floodScale = 2,
            capTimer = 900,
            music = { name = "Space Junk Galaxy - Super Mario Galaxy" }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -7154, y = 3474, z = -2167, yaw = 0x0000 },
            flagBase = true,
            speed = 1.25,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = 5678, y = -1875, z = -3589, yaw = -0x4000, airborne = true },	
            floodScale = 1.5,
            overrideWater = true,
            launchpads = {
                { x = 3775, y = 750, z = -7020, yaw = 0x2000, vel = 150, forwardVel = 90, capTimer = 90 },
            },
            music = { name = "Thwomp Caverns - Mario & Luigi: Partners in Time" }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 10506, y = 4465,  z = 3351, yaw = -0x4000 },
            flagBase = true,
            speed = 0.75,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = -3660, y = -65, z = -5236, yaw = 0x2000, airborne = true },
            floodScale = 2,
            floodHeight = -3500,
            music = { name = "Forever Forest - Paper Mario" }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -4375, y = 2570, z = 3430, yaw = 0x4000 },
            flagBase = true,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_SULFUR,
            floodScale = 2.5,
            floodHeight = -4500,
            music = { name = "Underground - Super Mario World 2: Yoshi's Island" }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -3317, y = 5524, z = 4273, yaw = -0x2000 },
            flagBase = true,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = -1858, y = 154, z = 5303, yaw = 0x8000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Mountain Village - The Legend of Zelda: Majora's Mask" }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 5952,  y = -1870, z = 4777,  yaw = 0x2000 },
            flagBase = true,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_MAGMA,	
            startPos = { x = 4436, y = -8414, z = 3704, yaw = 0x0000, airborne = false, pipe = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Red Tower's Fiery Colums",
            act = 1,
            music = { name = "Library Piano - Luigi's Mansion: Dark Moon" }
        },
        {
            name = "sl2",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -12150,  y = 1825, z = 3790, yaw = 0x0000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_ACID,	
            startPos = { x = -9212, y = -6126, z = 6710, yaw = -22574, airborne = false, pipe = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Toxic Tower Helix Climb",
            overrideWater = true,
            launchpads = {
                { x = -11525, y = -1100, z = 9020, yaw = 0x8000, vel = 200, forwardVel = 60, capTimer = 210 },
            },
            music = { name = "Library Piano - Luigi's Mansion: Dark Moon" }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 8380, y = 4622,  z = -9457, yaw = 0x0000 },
            flagBase = true,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_MAGMA,
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Is This A SM74 Copy?",
            music = { name = "Stone Tower Temple - The Legend of Zelda: Majora's Mask" }
        },
        {
            name = "b2",
            level = LEVEL_BOWSER_2,
            area = 1,
            flagPos = { x = -1852, y = -193, z = -3882, yaw = 0x3000 },
            speed = 1.25,
            author = "BroDute",
            type = FLOOD_MAGMA,
            startPos = { x = -1070, y = -1625, z = 8450, yaw = 0x4000, airborne = true },
            overrideName = "Bause's Plant Army",
            floodHeight = -4000,
            music = { name = "Medley of Main Themes - Castlevania: Legacy of Darkness" }
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 72, y = 2301, z = 5031, yaw = 0x3000 },
            speed = 1.25,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = 120, y = -8255, z = -7920, yaw = 0x0000, airborne = true },
            floodScale = 2,
            music = { name = "Eternal Star - Mario Party" }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 3358, y = -2171, z = 3592, yaw = -0x4000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_RAINBOW,
            startPos = { x = 1082, y = -4993, z = 7053, yaw = 0x6500, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvFadingWarp },
            music = { name = "Rainbow Road - Mario Kart 64" }
        },
        {
            name = "ttm2",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x =  5886,  y = 3847, z = -7471,  yaw =  0x0000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_RAINBOW,
            startPos = { x = 1850, y = 1360, z = -7340, yaw = -0x4000, airborne = false, fading = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvFadingWarp, id_bhvSmallBully },
            overrideName = "The Galaxy's Top",
            music = { name = "Rainbow Road - Mario Kart 64" }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -7490, y = 1238, z = 2262, yaw = 0x8000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_SAND,
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "TTM But With Quicksand",
            music = { name = "Gerudo Desert - The Legend of Zelda: Twilight Princess" }
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -7037, y = 4496, z = 6878, yaw =  0x6000 },
            flagBase = true,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_SULFUR,
            startPos = { x = 6734, y = 1310, z = 1879, yaw = 0x0000, airborne = true },
            floodScale = 2,
            overrideName = "TTM But Lava This Time",
            floodHeight = -1750,
            music = { name = "Hot Head Bop - Donkey Kong Country 2: Diddy's Kong Quest" }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 8655, y = 6407, z = 5869, yaw = 0x4000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = 12122, y = -4272, z = -15531, yaw = 0x0000, airborne = true },
            floodScale = 2.5,
            music = { name = "Crocodile Cacophonoy - Donkey Kong Country 2: Diddy's Kong Quest" }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -3622, y = 3040, z = 8739, yaw = 0x2000 },
            flagBase = true,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            startPos = { x = -6986, y = -7463, z = -8793, yaw = 0x0000, airborne = true },
            floodScale = 2,
            unwantedBhvs = { id_bhvKoopa },
            overrideName = "Original Level DO NOT STEAL",
            floodHeight = -9646,
            music = { name = "Hyrule Castle Tower (Third Section) - The Legend of Zelda: Twilight Princess" }
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = -7145, y = 3080, z = 7620, yaw = 0x8000 },
            flagBase = true,
            speed = 1.75,
            author = "BroDute",
            type = FLOOD_MAGMA,	
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Doomed Courtyard",
            music = { name = "Gruntilda's Lair (Main) - Banjo-Kazooie" }
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 8050, y = 3030, z = 1040, yaw = 0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_POISON,	
            startPos = { x = -5493, y = -3050, z = 6208, yaw = 0x8000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Doomed Grounds",
            pipes = {
                {
                    { x = 9550, y = -386, z = -5485, },
                    { x = 6775, y = 729, z = 988, yaw = -0x4000 }
                }
            },
            music = { name = "Gruntilda's Lair (Main) - Banjo-Kazooie" }
        },
        {
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -225, y = 2815, z = 1240, yaw = 0x8000 },
            speed = 6.0,
            author = "BroDute",
            type = FLOOD_MAGMA,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Castle Of Doom",
            floodHeight = -4000,
            pipes = {
                {
                    { x = 1682, y = -1665, z = 1627, yaw = 0x8000 },
                    { x = -2901, y = 198, z = -117, yaw = 0x4000 }
                },
                {
                    { x = 1682, y = 521, z = 1627, yaw = 0x8000 },
                    { x = -214, y = 2274, z = 732, yaw = 0x8000 }
                }
            },
            music = { name = "The Dungeon is Full of Monsters - Super Mario RPG: Legend of the Seven Stars" }
        }
    }
end

-- SM64: Last Impact, ported to Flood by SuperRodrigo0, ~¡TONO!~ and Bear64DX
local function flood_load_last_impact_levels()
    game = GAME_LAST_IMPACT
    romhackInfo = "Super Mario 64 Last Impact"
	romhackLogo = get_texture_info("logo_sm64li")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 3174, y = -511, z = 460, yaw = 0x4000}
        },
        [2] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 31, y = 244, z = -3277, yaw = -0x2000},
            music = { name = "Holli Jolli Village - Mario & Luigi: Partners in Time" },
            deathHeight = -3775,
        },
        [3] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 2,
            spawn = {x = -8091, y = 21, z = -613, yaw = 0x4000},
            music = { id = 17, name = "Koopa's Road (Remix) - Super Mario 64" },
        },
        [4] = {
            level = LEVEL_BBH,
            area = 1,
            spawn = {x = 16231, y = 882, z = -13611, yaw = -0x3000},
            music = { name = "Space Trip Steps (Meteor Herd) - Sonic Adventure 2" },
        },
        [5] = {
            level = LEVEL_BITFS,
            area = 1,
            spawn = {x = 12425, y = -2204, z = -5228, yaw = 0x4000},
            music = { name = "Factory Inspection - Kirby 64: The Crystal Shards" },
        },
        [6] = {
            level = LEVEL_BITS,
            area = 2,
            spawn = {x = 0, y = 270, z = -1, yaw = 0x0000},
            music = { name = "Tricky Maze (Lost World) - Sonic Adventure" },
        },
        [7] = {
            level = LEVEL_BOB,
            area = 2,
            spawn = {x = -1089, y = -172, z = 1030, yaw = 0x6000},
            music = { name = "Temple of Sun and Moon - Dark Cloud" },
        },
        [8] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -1449, y = -108, z = 285, yaw = 0x4000},
            music = { name = "Tension - Super Mario Galaxy" },
        },
        [9] = {
            level = LEVEL_CCM,
            area = 1,
            spawn = {x = 9073, y = -743, z = 15684, yaw = 0x0000},
            overrideWater = true,
            music = { name = "Temple of The Ancients - Final Fantasy VII" },
        },
        [9] = {
            level = LEVEL_CCM,
            area = 2,
            spawn = {x = 1151, y = 0, z = -258, yaw = -0x4000},
            music = { name = "Water Temple - The Legend of Zelda: Ocarina of Time" },
        },
        [10] = {
            level = LEVEL_COTMC,
            area = 1,
            spawn = {x = -2000, y = 662, z = -2974, yaw = 0x0000},
            music = { name = "Starlight Zone - Sonic The Hedgehog 1" },
        },
        [11] = {
            level = LEVEL_DDD,
            area = 3,
            spawn = {x = -105, y = 244, z = -690, yaw = -0x2000},
            music = { name = "Harried Honey Hive - DotStarMoney" },
            deathHeight = -1476,
        },
        [12] = {
            level = LEVEL_LLL,
            area = 1,
            spawn = {x = -7114, y = -480, z = 861, yaw = 0x0000},
            music = { name = "Dusky Doomed Dale - DotStarMoney" },
            pipes = {
                {
                    { x = -5918, y = -480, z = 1042 },
                    { x = 4074, y = 1672, z = 379, yaw = -50000 }
                }
            },
        },
        [13] = {
            level = LEVEL_LLL,
            area = 3,
            spawn = {x = 19119, y = 1332, z = 571, yaw = 0x0000},
            music = { name = "Inside The Castle (Remix) - Super Mario 64" },
        },
        [13] = {
            level = LEVEL_RR,
            area = 2,
            spawn = {x = 1, y = -834, z = 4, yaw = 0x0000},
            music = { name = "World 8: Bowser - Super Mario 3D World" },
        },
        [14] = {
            level = LEVEL_SL,
            area = 3,
            spawn = {x = 638, y = 426, z = 7818, yaw = 0x8000},
            music = { name = "Skyhigh Islands - Jesse" },
            deathHeight = -2070,
        },
        [15] = {
            level = LEVEL_TTC,
            area = 2,
            spawn = {x = 2645, y = 975, z = 747, yaw = -0x4000},
            music = { name = "Livid Surreal Dream - DotStarMoney" },
        },
        [16] = {
            level = LEVEL_TTM,
            area = 1,
            spawn = {x = -4067, y = -147, z = -1140, yaw = 0x3000},
            music = { name = "World 8: Bowser - Super Mario 3D World" },
            deathHeight = -732,
        },
        [17] = {
            level = LEVEL_VCUTM,
            area = 1,
            spawn = {x = -110, y = -1963, z = -110, yaw = 0x0000},
            overrideWater = true,
        },
        [18] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 3174, y = -511, z = 460, yaw = 0x4000},
            music = { name = "None" },
        },
        [19] = {
            level = LEVEL_LLL,
            area = 3,
            spawn = {x = 22756, y = 0, z = 22698, yaw = 0x4000},
            music = { name = "Inside The Castle (Remix) - Super Mario 64" },
        },
        [19] = {
            level = LEVEL_LLL,
            area = 3,
            spawn = {x = -655, y = 0, z = 440, yaw = 0x4000},
            music = { name = "Inside The Castle (Remix) - Super Mario 64" },
            pipes = {
                {
                    { x = 2638, y = 0, z = -43 },
                    { x = 20066, y = 1332, z = -1047, yaw = -20000 }
                }
            },
        },
        [20] = {
            level = LEVEL_TTM,
            area = 3,
            spawn = {x = -188, y = 100, z = -3282, yaw = 0x6000},
            music = { name = "World 8: Bowser - Super Mario 3D World" },
            pipes = {
                {
                    { x = -101, y = 0, z = -5292 },
                    { x = 3050, y = 4769, z = 8489, yaw = 20000 }
                }
            },
        },
        [21] = {
            level = LEVEL_WDW,
            area = 1,
            spawn = {x = -1611, y = -51, z = -11204, yaw = 0x0000},
            music = { name = "Deep Castle DX - Mario and Luigi Bowsers Inside Story + Bowser Jr.'s Journey" },
        },
        [22] = {
            level = LEVEL_WDW,
            area = 2,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x8000},
            music = { id = 58, name = "None" },
        },
        [23] = {
            level = LEVEL_SA,
            area = 2,
            spawn = {x = 160, y = 0, z = 225, yaw = 0x8000},
            music = { id = 56, name = "Giant Desk - DotStarMoney" },
            deathHeight = -520,
        },
        [24] = {
            level = LEVEL_WF,
            area = 1,
            spawn = {x = -5238, y = -3361, z = 1714, yaw = 0x6000},
            music = { name = "Temple of The Ancients - Final Fantasy VII" },
            pipes = {
                {
                    { x = -6227, y = -3315, z = 708 },
                    { x = 2366, y = -624, z = -11360, yaw = -70000 }
                }
            },
        },
        [25] = {
            level = LEVEL_JRB,
            area = 3,
            spawn = {x = -320, y = -412, z = 101, yaw = 0x0000},
            overrideWater = true,
            music = { id = 63, name = "Sky & Sea - Super Mario Sunshine" },
        },
        [26] = {
            level = LEVEL_CASTLE,
            area = 2,
            spawn = {x = 7120, y = 357, z = -5510, yaw = -0x2000},
            music = { name = "Dry Dry Desert Trek - Paper Mario" },
            pipes = {
                {
                    { x = 6596, y = 332, z = -3558 },
                    { x = -2705, y = 5507, z = 1698, yaw = -16317 }
                }
            },
        },
        [27] = {
            level = LEVEL_CCM,
            area = 1,
            spawn = {x = 13566, y = 29, z = -5891, yaw = -0x6000},
            overrideWater = true,
            music = { name = "Temple of The Ancients - Final Fantasy VII" },
        },
        [28] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = -1837, y = 122, z = 2848, yaw = 0x4000},
            music = { name = "Giant Desk - DotStarMoney" },
        },
        [29] = {
            level = LEVEL_SA,
            area = 3,
            spawn = {x = 11844, y = 2900, z = 3431, yaw = 0x8000},
            music = { name = "Boo Dance - Slowfreq" },
            deathHeight = -494,
        },
        [30] = {
            level = LEVEL_LLL,
            area = 2,
            spawn = {x = -1460, y = -9, z = -981, yaw = 0x1000},
            music = { name = "Inside The Castle (Remix) - Super Mario 64" },
        },
        [31] = {
            level = LEVEL_THI,
            area = 1,
            spawn = {x = -381, y = -349, z = -15325, yaw = 0x4000},
            music = { name = "Colossal Circuits - DotStarMoney" },
            deathHeight = -1501,
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -7076, y = 1132, z = 18710, yaw = 0x6000 },
            flagBase = true,
            speed = 2.8,
            author = "Kaze Emanuar",
            type = FLOOD_MUD,
            startPos = { x = -5651, y = -1793, z = 2208, yaw = 0x0000 },
            floodScale = 2.3,
            music = { name = "Piranha Creeper Creek - Super Mario 3D World" },
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 6668, y = 221, z = -12139, yaw = -0x4000 },
            flagBase = true,
            speed = 2.1,
            author = "Kaze Emanuar",
            type = FLOOD_MUD,
            startPos = { x = -2821, y = -3018, z = 7193, yaw = 0x7000 },
            floodScale = 2.3,
            overrideName = "Float  Through The Sky",
            music = { name = "Piranha Creeper Creek - Super Mario 3D World" },
        },
        {
            name = "bob3",
            level = LEVEL_BOB,
            area = 2,
            flagPos = { x = 21, y = 3067, z = -692, yaw = -0x1000 },
            flagBase = true,
            speed = 3.4,
            author = "Kaze Emanuar",
            type = FLOOD_MUD,
            startPos = { x = -1291, y = -190, z = 1346, yaw = 0x6000, airborne = false },
            overrideName = "Go Up the Giant Tree",
            music = { name = "Temple of Sun and Moon - Dark Cloud" },
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 3740, y = -95, z = -14350, yaw = 0x0000 },
            flagBase = true,
            speed = 4.0,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            startPos = { x = 5082, y = -3418, z = 7222, yaw = 0x9000 },
            floodScale = 2.3,
            floodHeight = -5200,
            music = { name = "Temple of The Ancients - Final Fantasy VII" },
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -5760, y = 3035, z = 7639, yaw = -0x4000 },
            flagBase = true,
            speed = 2.1,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            startPos = { x = -1064, y = 1625, z = -14823, yaw = 0x0000 },
            floodScale = 2.6,
            floodHeight = -800,
            overrideWater = true,
            launchpads = {
                { x = -4013, y = 6010, z = -7839, yaw = 0x0000, vel = 100, forwardVel = 50 },
            },	
            music = { name = "Sunset Islet - Jesse" },
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 2,
            flagPos = { x = 570, y = 2420, z = 830, yaw = 0x8000 },
            flagBase = false,
            speed = 2.8,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            startPos = { x = 1019, y = 23, z = 1, yaw = -0x4000 },
            overrideName = "Labor in the Lighthouse",
            music = { id = 46, name = "Slide (Remix) - Super Mario 64" },
        },
        {
            name = "jrb3",
            level = LEVEL_JRB,
            area = 3,
            flagPos = { x = 127, y = -650, z = 1502, yaw = 0x4000 },
            flagBase = false,
            speed = 1.5,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            overrideName = "Explore the Shell",
            music = { id = 63, name = "Sky & Sea - Super Mario Sunshine" },
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -9823, y = 115, z = 25695, yaw = -0x4000 },
            flagBase = true,
            speed = 1.0,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            startPos = { x = -2900, y = -800, z = 7739, yaw = -0x4000, airborne = false },
            floodScale = 3.2,
            overrideWater = true,
            music = { name = "Temple of The Ancients - Final Fantasy VII" },
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 4675, y = 1810, z = 15831, yaw = 0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            startPos = { x = 8383, y = -2115, z = -7118, yaw = -0x3000 },
            overrideName = "Crystal Caves (Spiders)",
            floodScale = 3.0,
            overrideWater = true,
            launchpads = {
                { x = 5368, y = -2054, z = -5855, yaw = 0x2000, vel = 130, forwardVel = 0 },
            },
            music = { name = "Temple of The Ancients - Final Fantasy VII" },
        },
        {
            name = "ccm3",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = 895, y = 123, z = -4787, yaw = 0x0000 },
            flagBase = false,
            speed = 4.0,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            startPos = { x = -3005, y = -821, z = -2734, yaw = 0x0000 },
            overrideName = "The Water Temple",
            overrideWater = true,
            unwantedBhvs = {id_bhvWarpPipe},
            music = { name = "Water Temple - The Legend of Zelda: Ocarina of Time" },
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -40, y = 7065, z = -6915, yaw = 0x0000 },
            flagBase = true,
            speed = 4.0,
            author = "Kaze Emanuar",
            type = FLOOD_DARKNESS,
            startPos = { x = -9066, y = -321, z = 14722, yaw = 0x7500 },
            floodScale = 3.5,
            floodHeight = -3000,
            music = { name = "Space Trip Steps (Meteor Herd) - Sonic Adventure 2" },
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 9192, y = 8273, z = 17676, yaw = 0x8000 },
            flagBase = true,
            speed = 2.95,
            author = "Kaze Emanuar",
            type = FLOOD_MOLTEN,
            floodScale = 2.4,
            music = { name = "Koopa's Road (Remix) - Super Mario 64" },
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 120, y = 940, z = 9235, yaw = 0x8000 },
            flagBase = true,
            speed = 3.1,
            author = "Kaze Emanuar",
            type = FLOOD_LAVA,
            startPos = { x = 3690, y = -2165, z = -6690, yaw = -0x6000 },
            music = { name = "Melty Molten Mountains - DotStarMoney" },
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -2225, y = 3405, z = -16585, yaw = -0x5000 },
            flagBase = false,
            speed = 1.8,
            author = "Kaze Emanuar",
            type = FLOOD_COTTON,
            startPos = { x = 5050, y = -1528, z = 8135, yaw = -0x3000 },
            floodScale = 3.0,
            music = { name = "Neo Star - Kirby 64: The Crystal Shards" },
        },
        {
            name = "hmc2",
            level = LEVEL_HMC,
            area = 2,
            flagPos = { x = 5279, y = 4486, z = 7847, yaw = -0x4000 },
            flagBase = true,
            speed = 3.905,
            author = "Kaze Emanuar",
            type = FLOOD_SULFUR,
            startPos = { x = 586, y = -27, z = 4755, yaw = 0x0000, airborne = false },
            overrideName = "Factory Inspection",
            floodScale = 1.4,
            floodHeight = -2700,
            music = { name = "Factory Inspection - Kirby 64: The Crystal Shards" },
        },
        {
            name = "hmc3",
            level = LEVEL_HMC,
            area = 2,
            flagPos = { x = 2369, y = 8, z = -15773, yaw = 0x0000 },
            flagBase = true,
            speed = 5.73,
            author = "Kaze Emanuar",
            type = FLOOD_SULFUR,
            startPos = { x = 2332, y = -65, z = 805, yaw = 0x8000 },
            overrideName = "Sneak in With the Conveyor",
            floodScale = 2.0,
            music = { name = "Factory Inspection - Kirby 64: The Crystal Shards" },
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -595, y = 8886, z = 7946, yaw = 0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "Kaze Emanuar",
            type = FLOOD_CLOUDS,
            startPos = { x = 452, y = 4770, z = 573, yaw = 0x0000, airborne = false },
            floodScale = 3.0,
            music = { name = "Above the clouds - Slowfreq" },
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 3295, y = 2470, z = -4517, yaw = 0x0000 },
            flagBase = false,
            speed = 2.5,
            author = "Kaze Emanuar",
            type = FLOOD_LAVA,
            startPos = { x = -1927, y = 119, z = 2850, yaw = 0x6000 },
            overrideName = "Giant Desk",
            floodScale = 2.2,
            music = { name = "Giant Desk - DotStarMoney" },
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 3,
            flagPos = { x = 8073, y = 4650, z = 2288, yaw = 0x0000 },
            flagBase = true,
            speed = 4.0,
            author = "Kaze Emanuar",
            type = FLOOD_DARKNESS,
            startPos = { x = -1010, y = -76, z = 720, yaw = 0x4000 },
            floodScale = 2.5,
            music = { name = "Boo Dance - Slowfreq" },
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -3075, y =  3095, z = 5985, yaw = 0x4000 },
            flagBase = false,
            speed = 2.0,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            floodScale = 3.0,
            music = { name = "Dusky Doomed Dale - DotStarMoney" },
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 3,
            flagPos = { x = 24938, y = 2782, z = 4341, yaw = 0x8000 },
            flagBase = false,
            speed = 2.9,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            overrideName = "The Haunted Crurch",
            floodScale = 3.0,
            music = { name = "Inside The Castle (Remix) - Super Mario 64" },
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 6306, y = 4122, z = 3937, yaw = 0x6000 },
            flagBase = true,
            speed = 2.8,
            author = "Kaze Emanuar",
            type = FLOOD_MAGMA,
            overrideName = "Clamber up the Volcano",
            floodScale = 2.5,
            music = { name = "Melty Molten Mountains (Fire Side) - DotStarMoney" },
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -7110, y = 1910, z = 10800, yaw = 0x0000 },
            flagBase = true,
            speed = 2.8,
            author = "Kaze Emanuar",
            type = FLOOD_SNOW,
            startPos = { x = 2127, y = -407, z = 18311, yaw = 0x8000 },
            floodScale = 2.5,
            music = { name = "Melty Molten Mountains (Ice Side) - DotStarMoney" },
        },
        {
            name = "ssl3",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x = 36, y = 3306, z = 3510, yaw = 0x8000 },
            flagBase = false,
            speed = 5.9,
            author = "Kaze Emanuar",
            type = FLOOD_FROSTBITE,
            startPos = { x = 14770, y = -5446, z = 966, yaw = 0x8000 },
            floodScale = 2,
            overrideName = "Frosty Veers",
            music = { name = "Slider (Remix) - Super Mario 64" },
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 3760, y = 2280, z = 75, yaw = -0x4000 },
            flagBase = true,
            speed = 2.255,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            startPos = { x = -2702, y = -148, z = -1935, yaw = 0x6000, airborne = false },
            floodScale = 2,
            music = { name = "Harried Honey Hive - DotStarMoney" },
        },
        {
            name = "ddd2",
            level = LEVEL_DDD,
            area = 2,
            flagPos = { x = -15139, y = 8495, z = 19753, yaw = 0x4000 },
            flagBase = true,
            speed = 3.8,
            author = "Kaze Emanuar",
            type = FLOOD_CLOUDS,
            startPos = { x = 15052, y = 474, z = -17605, yaw = -0x4000 },
            floodScale = 3.5,
            overrideName = "Bee Skyrace",
            floodHeight = -5600,
            music = { name = "Above the clouds - Slowfreq" },
        },
        {
            name = "ddd3",
            level = LEVEL_DDD,
            area = 3,
            flagPos = { x = -6034, y = 1336, z = 5502, yaw = 0x8000 },
            flagBase = true,
            speed = 3.9,
            author = "Kaze Emanuar",
            type = FLOOD_DARKNESS,
            startPos = { x = -1016, y = 373, z = -2873, yaw = 0x0000, airborne = false },
            floodScale = 2.0,
            overrideName = "Harried Honey Hive (Spiders)",
            music = { name = "Temple of Sun and Moon - Dark Cloud" },
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 11020, y = 10361, z = -12355, yaw = 0x8000 },
            flagBase = false,
            speed = 5.0,
            author = "Kaze Emanuar",
            type = FLOOD_CLOUDS,
            floodScale = 4.0,
            startPos = { x = 283, y = -1902, z = 968, yaw = 0x2000},
            floodHeight = -9390,
            music = { name = "Skyhigh Islands - Jesse" },
        },
        {
            name = "sl2",
            level = LEVEL_SL,
            area = 2,
            flagPos = { x = 1611, y = 1560, z = -374, yaw = -0x6000 },
            flagBase = false,
            speed = 2.93,
            author = "Kaze Emanuar",
            type = FLOOD_ACID,
            startPos = { x = 3040, y = 131, z = -4957, yaw = -0x1000 },
            overrideName = "Acid Cave",
            music = { name = "Temple of Sun and Moon - Dark Cloud" },
        },
        {
            name = "totwc2",
            level = LEVEL_TOTWC,
            area = 2,
            flagPos = { x = 2048, y = 2742, z = -1960, yaw = 0x8000 },
            flagBase = true,
            speed = 1.0,
            author = "Kaze Emanuar",
            type = FLOOD_CLOUDS,
            startPos = { x = 5156, y = 380, z = -1735, yaw = 0x8000 },
            floodScale = 2.0,
            capTimer = 2,
            overrideName = "Above The Clouds 2",
            music = { id = 9, name = "Above the clouds - Slowfreq" },
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 2,
            flagPos = { x = -4046, y = 5633, z = -1217, yaw = -0x0000 },
            flagBase = true,
            speed = 3.4,
            author = "Kaze Emanuar",
            type = FLOOD_DESERT,
            floodScale = 2,
            overrideName = "Drybone Desert",
            floodHeight = -2300,
            unwantedBhvs = {id_bhvWarpPipe},
            launchpads = {
                { x = -4940, y = 1116, z = 5417, yaw = 0x1995, vel = 150, forwardVel = 70 },
                { x = 1473, y = 1944, z = 6059, yaw = 0x5000, vel = 230, forwardVel = 0 },
            },	
            music = { name = "Dry Dry Desert Trek - Paper Mario" },
        },
        {
            name = "totwc3",
            level = LEVEL_TOTWC,
            area = 3,
            flagPos = { x = -137, y = 1504, z = -1674, yaw = 0x0000 },
            flagBase = false,
            speed = 1.0,
            author = "Kaze Emanuar",
            type = FLOOD_CLOUDS,
            startPos = { x = 527, y = 140, z = 7214, yaw = 0x5000 },
            floodScale = 2.0,
            overrideName = "Above The Clouds 3",
            music = { id = 9, name = "Above the clouds - Slowfreq" },
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 19078, y = -2129, z = -5300, yaw = -0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "Kaze Emanuar",
            type = FLOOD_OIL,
            startPos = { x = -295, y = -7545, z = 70, yaw = 0x8000, airborne = false },
            floodScale = 2.0,
            music = { name = "Factory Inspection - Kirby 64: The Crystal Shards" },
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -2, y = 4985, z = -10, yaw = -0x2000 },
            flagBase = false,
            speed = 2.1,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            startPos = { x = -5369, y = 91, z = -1490, yaw = 0x3000, airborne = false },
            music = { name = "World 8: Bowser - Super Mario 3D World" },
        },
        {
            name = "ttm2",
            level = LEVEL_TTM,
            area = 2,
            flagPos = { x = 2918, y = 1000, z = 5760, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            unwantedBhvs = {id_bhvWarpPipe},
            overrideName = "Gamble Game Gallery (Sewage)",
            music = { name = "Underground (Remix) - Super Mario Bros. 1" },
        },
        {
            name = "ttm3",
            level = LEVEL_TTM,
            area = 3,
            flagPos = { x = -6576, y = 4284, z = 11085, yaw = 0x8000 },
            speed = 8.0,
            author = "Kaze Emanuar",
            type = FLOOD_DARKNESS,
            startPos = { x = -6516, y = 164,  z = 1956, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe },
            floodScale = 2.5,
            overrideName = "Gamble Game Gallery (Pinball)",
            music = { name = "World 8: Bowser - Super Mario 3D World" },
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -6800, y = 8950, z = 4625, yaw = 0x8000 },
            flagBase = true,
            speed = 4.1,
            author = "Kaze Emanuar",
            type = FLOOD_MATRIX,
            startPos = { x = -834, y = -26, z = 6388, yaw = -0x2000 },
            floodScale = 2.5,
            music = { name = "Colossal Circuits - DotStarMoney" },
        },
        {
            name = "thi2",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 11117, y = 4118, z = -1871, yaw = 0x8000 },
            speed = 2.5,
            author = "Kaze Emanuar",
            type = FLOOD_MATRIX,
            startPos = { x = 13735, y = 1667,  z = -8297, yaw = -0x4000 },
            floodScale = 2.5,
            overrideName = "Spring Mushroom Challenger",
            floodHeight = -2000,
            music = { name = "Colossal Circuits - DotStarMoney" },
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -12793, y = 9898, z = -4526, yaw = 0x4000 },
            flagBase = true,
            speed = 2.88,
            author = "Kaze Emanuar",
            type = FLOOD_POISON,
            startPos = { x = -2172, y = 4730,  z = 8445, yaw = 0x8000 },
            floodScale = 2.5,
            music = { name = "Livid Surreal Dream - DotStarMoney" },
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 8395, y = 3355, z = -8930, yaw = -0x3000 },
            flagBase = true,
            speed = 3.5,
            author = "Kaze Emanuar",
            type = FLOOD_RAINBOW,
            startPos = { x = 3227, y = 602, z = -1128, yaw = 0x4000 },
            floodScale = 2.5,
            floodHeight = -2350,
            music = { name = "Rainbow Road - Mario Kart 64" },
        },
        {
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -4357, y = 2414, z = -4179, yaw = 0x2600 },
            flagBase = true,
            speed = 3.14,
            author = "Kaze Emanuar",
            type = FLOOD_RAINBOW,
            startPos = { x = 2852, y = -85, z = -3795, yaw = -0x5000 },
            floodScale = 2.5,
            overrideName = "Rainbow Noteblock Tour",
            music = { name = "Rainbow Road - Mario Kart 64" },
        },
        {
            name = "rr3",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 1978, y = 6679, z = -1233, yaw = 0x0000 },
            flagBase = true,
            speed = 5.3,
            author = "Kaze Emanuar",
            type = FLOOD_RAINBOW,
            startPos = { x = -4011, y = 769, z = 630, yaw = 0x1000 },
            floodScale = 2.5,
            overrideName = "Flying Through the Rainbows",
            music = { name = "Rainbow Road - Mario Kart 64" },
        },
        {
            name = "rr4",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 906, y = 911, z = 7182, yaw = 0x8000 },
            flagBase = false,
            speed = 1.6,
            author = "Kaze Emanuar",
            type = FLOOD_RAINBOW,
            startPos = { x = 3295, y = 254, z = 2439, yaw = 0x4000 },
            floodScale = 2.5,
            overrideName = "Rainbow Cart",
            music = { name = "Rainbow Road - Mario Kart 64" },
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -1967, y = 7820, z = -3325, yaw = 0x0000 },
            flagBase = false,
            speed = 4.0,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            startPos = { x = 1981, y = -759, z = 3848, yaw = -0x6000 },
            floodScale = 2.0,
            floodHeight = -1900,
            music = { name = "Starlight Zone - Sonic The Hedgehog 1" },
        },
        {
            name = "bits1",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 6470, y = 4130, z = 1605, yaw = 0x0000 },
            flagBase = false,
            speed = 3.45,
            author = "Kaze Emanuar",
            type = FLOOD_SNOW,
            startPos = { x = 4835, y = 44, z = 1805, yaw = 0x0000 },
            floodScale = 2.5,
            overrideName = "Rashay's Moon Cellar (Blue)",
            music = { name = "Tricky Maze (Lost World) - Sonic Adventure" },
        },
        {
            name = "bits2",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 2420, y = 4370, z = -6855, yaw = 0x4000 },
            flagBase = false,
            speed = 3.6,
            author = "Kaze Emanuar",
            type = FLOOD_DARKNESS,
            startPos = { x = 2250, y = 79, z = -4675, yaw = 0x4000 },
            floodScale = 2.5,
            overrideName = "Rashay's Moon Cellar (Yellow)",
            music = { name = "Tricky Maze (Lost World) - Sonic Adventure" },
        },
        {
            name = "bits3",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -6435, y = 3815, z = -2115, yaw = -0x4000 },
            flagBase = false,
            speed = 2.2,
            author = "Kaze Emanuar",
            type = FLOOD_CLOUDS,
            startPos = { x = -6265, y = 913, z = -472, yaw = 0x8000 },
            floodScale = 2.5,
            overrideName = "Rashay's Moon Cellar (White)",
            music = { name = "Tricky Maze (Lost World) - Sonic Adventure" },
        },
        {
            name = "bits4",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -1575, y = 3950, z = 6600, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "Kaze Emanuar",
            type = FLOOD_LAVA,
            startPos = { x = -1930, y = 189, z = 4600, yaw = -0x4000 },
            floodScale = 2.5,
            overrideName = "Rashay's Moon Cellar (Red)",
            music = { name = "Tricky Maze (Lost World) - Sonic Adventure" },
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 2,
            flagPos = { x = 5422, y = -12, z = -352, yaw = -0x4000 },
            flagBase = true,
            speed = 3.6,
            author = "Kaze Emanuar",
            type = FLOOD_LAVA,
            overrideName = "Bowser's Tunnel",
            music = { id = 17, name = "Koopa's Road (Remix) - Super Mario 64" },
        },
        {
            name = "castle2",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -6991, y = 1758, z = 2094, yaw = 0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "Kaze Emanuar",
            type = FLOOD_WATER,
            startPos = { x = 40, y = 400, z = -3285, yaw = -0x1000 },
            overrideName = "Abandoned Village",
            music = { name = "Holli Jolli Village - Mario & Luigi: Partners in Time" },
            unwantedBhvs = { id_bhvWarpPipe },
        },
    }
end

-- Brutal Mario 64, ported to Flood by Jzzay
local function flood_load_brutal_mario_64_levels()
    game = GAME_BRUTAL_MARIO_64
    romhackInfo = "Brutal Mario 64"
    romhackLogo = get_texture_info("brutal_mario_64_logo")		
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 6232, y = -519, z = -2182, yaw = -0x2000}
        }
    }

    gLevels = {
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 3686, y = 6713, z = -6406, yaw = -0x4000 },
            speed = 3.0,
            author = "LinCrash",
            type = FLOOD_POISON,
            startPos = { x = -8964, y = -840,  z = 8263, yaw = 0x4000 },
            floodScale = 2.5,
            floodHeight = -5600
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -1078, y = 8172,  z = -920, yaw = 0x6000 },
            speed = 3.25,
            author = "LinCrash",
            type = FLOOD_MUD,
            startPos = { x = 1736, y = 1151,  z = 4285, yaw = 0x4000 },
            floodScale = 2.5,
            floodHeight = -1665
        },
        {
            name = "b2",
            level = LEVEL_BOWSER_2,
            area = 1,
            flagPos = { x = -2199,  y = 1180,  z = -4, yaw = -0x4000 },
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_ACID,
            floodScale = 2.5,
            overrideName = "Bowser's Acid Domain",
            floodHeight = -8155,
            overrideWater = true
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = -6051,  y = 3143,  z = 7709, yaw = 0x2500 },
            flagBase = true,
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_WATER,
            startPos = { x = 6232, y = -519, z = -2182, yaw = -0x2000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "National Park of Brutality"
        },
    }
end

-- SM64 Masters Challenge, ported to Flood by Bear64DX and SuperRodrigo0
local function flood_load_masters_challenge_levels()
    game = GAME_MASTERS_CHALLENGE
    romhackInfo = "Super Mario 64 Master's Challenge"
	romhackLogo = get_texture_info("logo_sm64mc")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = { x = -1328, y = 260, z = 4664, yaw = -32768 }
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 5245, y = 1410, z = 1553, yaw = -0x6000 },
            speed = 2.0,
            author = "TheGael95 & WWMResident",
            type = FLOOD_DESERT,
            startPos = { x = -7788, y = -2377, z = 7107, yaw = 0x6000 },
            floodScale = 2
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 1098, y = 1670, z = -1643, yaw = 0x8000 },
            speed = 3.61,
            author = "TheGael95 & WWMResident",
            type = FLOOD_DARKNESS,
            unwantedBhvs = { id_bhvWarpPipe },
            floodScale = 2
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -4384, y = 2494, z = -5768, yaw = -0x3500 },
            speed = 3.14,
            author = "TheGael95 & WWMResident",
            type = FLOOD_LAVA,
            startPos = { x = -5587, y = -4759, z = -2609, yaw = 0x9000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 4955, y = -2160, z = -2595, yaw = 0x0000 },
            speed = 1.0,
            author = "TheGael95 & WWMResident",
            type = FLOOD_POISON,
            startPos = { x = -767, y = -7690, z = -7094, yaw = -0x1000 },
            floodScale = 2
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -3616, y = 3478, z = -4524, yaw = -0x4000 },
            speed = 1.7,
            author = "TheGael95 & WWMResident",
            type = FLOOD_POISON,
            startPos = { x = -1351, y = -1936, z = -7795, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Dangerous Purple Hike"
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -4164, y = -4319, z = 6260, yaw = 0x4000 },
            speed = 0.7,
            author = "TheGael95 & WWMResident",
            type = FLOOD_DARKNESS,
            startPos = { x = -3821, y = -4319, z = -4104, yaw = -7963 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -40, y = 2909, z = 1978, yaw = 0x8000 },
            speed = 0.7,
            author = "TheGael95 & WWMResident",
            type = FLOOD_DARKNESS,
            startPos = { x = -6704, y = -600, z = 6112, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Glowing Dark Heights"
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -4256, y = 5457, z = 370, yaw = 0x8000 },
            speed = 3.0,
            author = "TheGael95 & WWMResident",
            type = FLOOD_DARKNESS,
            startPos = { x = -7823, y = -3153, z = 3929, yaw = 0x4000 },
            floodScale = 2
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -2512, y = 6961, z = 11140, yaw = 0x4000 },
            speed = 2.1,
            author = "TheGael95 & WWMResident",
            type = FLOOD_DARKNESS,
            startPos = { x = -23569, y = -1107, z = -1948, yaw = 0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvMessagePanel },
            floodHeight = -2539
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 1773, y = 1416, z = 4042, yaw = -0x6000 },
            speed = 3.2,
            author = "TheGael95 & WWMResident",
            type = FLOOD_WATER,
            floodScale = 2,
            overrideWater = true
        },
        {
            name = "hmc2",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 8459, y = 4017, z = 6869, yaw = -0x4000 },
            speed = 1.4,
            author = "TheGael95 & WWMResident",
            type = FLOOD_WATER,
            startPos = { x = 4816, y = 52, z = -7548, yaw = -0x4000 },
            overrideName = "Glacial Depths"
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -4065, y = -1068, z = -221, yaw = 0x4000 },
            speed = 3.4,
            author = "TheGael95 & WWMResident",
            type = FLOOD_LAVA,
            startPos = { x = -2925, y = -3008, z = -3130, yaw = -0x16000 },
            floodScale = 1.5,
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -6100, y = -659, z = 10024, yaw = 0x8000 },
            speed = 1.0,
            author = "TheGael95 & WWMResident",
            type = FLOOD_ACID,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },
            floodHeight = -2909
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -2148, y = 6808, z = -6239, yaw = 0x8000 },
            speed = 1.4,
            author = "TheGael95 & WWMResident",
            type = FLOOD_WASTE,
            startPos = { x = -1755, y = -2090, z = -3608, yaw = 0x6000 },
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -1157, y = 2129, z = 300, yaw = -0x4000 },
            speed = 2.0,
            author = "TheGael95 & WWMResident",
            type = FLOOD_DESERT,
            startPos = { x = -7872, y = -3239, z = 288, yaw = 0x4000 },
            floodScale = 2
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -870, y = 12692, z = 288, yaw = 0x4000 },
            speed = 2.4,
            author = "TheGael95 & WWMResident",
            type = FLOOD_FROSTBITE,
            startPos = { x = 4345, y = -1279, z = 303, yaw = -0x4000 },
            floodScale = 1.5
        },
        {
            name = "b2",
            level = LEVEL_BOWSER_2,
            area = 1,
            flagPos = { x = 364, y = 1154, z = 184, yaw = -0x0000 },
            speed = 2.0,
            author = "TheGael95 & WWMResident",
            type = FLOOD_SNOW,
            overrideName = "Icicle Ruins",
            floodHeight = -3952
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -6480, y = 60, z = -6268, yaw = 0x0000 },
            speed = 2.5,
            author = "TheGael95 & WWMResident",
            type = FLOOD_POISON,
            floodScale = 2
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -11091, y = 1173, z = -15262, yaw = -0x1000 },
            speed = 2.2,
            author = "TheGael95 & WWMResident",
            type = FLOOD_WATER,
            startPos = { x = -11637, y = -1024, z = -2610, yaw = 26895 },
            floodScale = 3
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 735, y = 6128, z = 4299, yaw = 0x0000 },
            speed = 0.25,
            author = "TheGael95 & WWMResident",
            type = FLOOD_LAVA
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -6064, y = -771, z = -9432, yaw = 0x0000 },
            speed = 1.6,
            author = "TheGael95 & WWMResident",
            type = FLOOD_LAVA,
            startPos = { x = -5662, y = -569, z = -2369, yaw = 0x4000, airborne = false },
            floodScale = 2
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -3127, y = 3866, z = -6609, yaw = -0x2000 },
            speed = 9.0,
            author = "TheGael95 & WWMResident",
            type = FLOOD_DARKNESS,
            startPos = { x = -13738, y = 1677, z = 10845, yaw = 0x6000, airborne = false },
            floodScale = 2.5
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 2085, y = -244, z = 3211, yaw = 0x4000 },
            speed = 2.0,
            author = "TheGael95 & WWMResident",
            type = FLOOD_DESERT,
            startPos = { x = -6907, y = -4193, z = -7130, yaw = 0x4000 },
            floodScale = 2.5,
            overrideSlide = true
        },
        {
            name = "pss2",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 6933, y = 9282, z = 7653, yaw = 0x8000 },
            speed = 3.4,
            author = "TheGael95 & WWMResident",
            type = FLOOD_SAND,
            startPos = { x = -2841, y = 2375, z = 3994, yaw = 0x8000 },
            overrideName = "New Secret Slide",
            overrideSlide = true
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = -5, y = 7588, z = -4015, yaw = 0x0000 },
            speed = 3.1,
            author = "TheGael95 & WWMResident",
            type = FLOOD_WATER,
            startPos = { x = -1328, y = 260, z = 4664, yaw = -32768 },
            overrideName = "Masters' Hell"
        }
    }
end

-- Super Trump 64, ported to Flood by Jzzay
local function flood_load_trump_64_levels()
    game = GAME_TRUMP_64
    romhackInfo = "Super Trump 64"
    LEVEL_BORDER = level_register('level_border_entry', COURSE_NONE, 'The Border', 'border', 28000, 0x28, 0x28, 0x28)
	gLobbies = {
        [1] = {
            level = LEVEL_BORDER,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "border",
            level = LEVEL_BORDER,
            area = 1,
            flagPos = { x = -2955, y = 9876, z = -10465, yaw = 0x0000 },
            speed = 3.0,
            author = "Kaze Emanuar",
            type = FLOOD_OIL,
            startPos = { x = 12080, y = 4, z = -28, yaw = -0x5000 },
            floodScale = 2.5,
        }
    }
end

-- Land94, ported to Flood by Bear64DX
local function flood_load_land94_levels()
    game = GAME_LAND94
    romhackInfo = "Land94"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 2978, y = 5181, z = -1707, yaw = -0x5000 },
            flagBase = false,
            speed = 2.8,
            author = "Beta Penguin 64",
            type = FLOOD_WATER,
            startPos = { x = -3807, y = -2729, z = -4460, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 5342, y = 7200, z = -5308, yaw = -0x4000 },
            flagBase = false,
            speed = 3.14,
            author = "Beta Penguin 64",
            type = FLOOD_WATER,
            startPos = { x = -1677, y = 1292, z = 4800, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = -8634, y = 301, z = -5744, yaw = 0x0000 },
            flagBase = false,
            speed = 1.23,
            author = "Beta Penguin 64",
            type = FLOOD_WATER,
            startPos = { x = 5717, y = 654, z = -539, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 7546, y = 2015, z = -6854, yaw = -0x3000 },
            flagBase = false,
            speed = 2.5,
            author = "Beta Penguin 64",
            type = FLOOD_LAVA,
            startPos = { x = -1588, y = 382, z = 6175, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
            act = 3,
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 1709, y = 7596, z = -78, yaw = -0x1000 },
            flagBase = false,
            speed = 2.0,
            author = "Beta Penguin 64",
            type = FLOOD_SNOW,
            startPos = { x = -3839, y = 4476, z = 1941, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 2,
            flagPos = { x = -5094, y = 4354, z = 1091, yaw = -0x5000 },
            flagBase = false,
            speed = 3.0,
            author = "Beta Penguin 64",
            type = FLOOD_SNOW,
            overrideName = "Snow Summit",
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 8431, y = 2596, z = -1946, yaw = -0x4000 },
            flagBase = false,
            speed = 2.9,
            author = "Beta Penguin 64",
            type = FLOOD_LAVA,
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -13808, y = 12700, z = 3063, yaw = 0x6000 },
            flagBase = false,
            speed = 1.2,
            author = "Beta Penguin 64",
            type = FLOOD_WATER,
            startPos = { x = -926, y = 1010, z = -2645, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -2583, y = 3222, z = -3718, yaw = 0x2500 },
            flagBase = false,
            speed = 2.5,
            author = "Beta Penguin 64",
            type = FLOOD_WATER,
            startPos = { x = -1640, y = 615, z = -120, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "ttm2",
            level = LEVEL_TTM,
            area = 2,
            flagPos = { x = 7327, y = 5255, z = -10401, yaw = 0x0000 },
            flagBase = false,
            speed = 3.6,
            author = "Beta Penguin 64",
            type = FLOOD_WATER,
            startPos = { x = -8046, y = -5127, z = 18309, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Alternative Lands (Slide)",
        }
    }
end

-- Despair Mario's Gambit 64, ported to Flood by Bear64DX & Jzzay
local function flood_load_despair_marios_gambit_levels()
    game = GAME_DESPAIR_MARIOS_GAMBIT
    romhackInfo = "Despair Mario's Gambit 64"
	romhackLogo = get_texture_info("logo_dmg64")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 745, y = 3659, z = -2515, yaw =  0x6000 },
            speed = 2.7,
            author = "GmdDoesDMG",
            type = FLOOD_LAVA,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 650, y = 6453, z = 3684, yaw =  0x8000 },
            speed = 4.3,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -3163, y = 5539, z = 1852, yaw = 0x4000 },
            speed = 3.5,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -1416, y = 6430, z = -13836, yaw = -0x6000 },
            speed = 3.0,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            startPos = { x = -1177, y = 3000, z = -17604, yaw = 0x3000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sa2",
            level = LEVEL_SA,
            area = 2,
            flagPos = { x = -658, y = 4748, z = -2614, yaw = 0x1000 },
            speed = 5.6,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            startPos = { x = 2770, y = 1482, z = -2307, yaw = -0x2000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 5, y = 4780, z = -12017, yaw =  0x0000 },
            speed = 3.5,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            startPos = { x = 22, y = -1359, z = 7469, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -883, y = 5882, z = -14918, yaw = 0x4000 },
            speed = 0.68,
            author = "GmdDoesDMG",
            type = FLOOD_LAVA,
            startPos = { x = 2550, y = 1877, z = -2106, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "b1",
            level = LEVEL_BOWSER_1,
            area = 1,
            flagPos = { x =  -3565, y = -385, z = 0, yaw =  0x4000 },
            speed = 5.0,
            author = "GmdDoesDMG",
            type = FLOOD_LAVA,
            startPos = { x =  3470, y =  -440, z = 15, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x =  15926, y = 11373, z = 690, yaw =  0x8000 },
            speed = 2.0,
            author = "GmdDoesDMG",
            type = FLOOD_CLOUDS,
            startPos = { x = -3862, y = 3479, z = 28, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x =  -6498, y = 10666, z = -11648, yaw =  0x0000 },
            speed = 1.7,
            author = "GmdDoesDMG",
            type = FLOOD_SUNSET,
            startPos = { x = 117, y = 2682, z = -5655, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 2,
            flagPos = { x =  -2063, y = 10884, z = 391, yaw =  0x6000 },
            speed = 2.5,
            author = "GmdDoesDMG",
            type = FLOOD_SUNSET,
            startPos = { x = -504, y = 1134, z = -203, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x =  7563, y = 11627, z = -7381, yaw =  0x8000 },
            speed = 2.5,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            startPos = { x = 1346, y = 6814, z = -11599, yaw = 0x3000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x =  -696, y = 10406, z = 4427, yaw =  0x8000 },
            speed = 2.5,
            author = "GmdDoesDMG",
            type = FLOOD_SNOW,
            startPos = { x = 985, y = 2108, z = -1952, yaw = 0x1000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -8442, y = 4486, z = 1757, yaw =  0x5000 },
            speed = 2.5,
            author = "GmdDoesDMG",
            type = FLOOD_SNOW,
            startPos = { x = 5137, y = -1320, z = 7661, yaw = -0x6950 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 13836, y = 4207, z = 443, yaw =  -0x4000 },
            speed = 2.0,
            author = "GmdDoesDMG",
            type = FLOOD_CLOUDS,
            startPos = { x = 4121, y = -367, z = -886, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x = -6248, y = 9736, z = -3191, yaw =  0x0000 },
            speed = 2.0,
            author = "GmdDoesDMG",
            type = FLOOD_LAVA,
            startPos = { x = -6982, y = 3261, z = -647, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x =  8026, y = 6669, z = -3482, yaw =  0x6500 },
            speed = 2.0,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            startPos = { x = 6501, y = 2419, z = 2858, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ddd2",
            level = LEVEL_DDD,
            area = 2,
            flagPos = { x =  4146, y = 6327, z = -8619, yaw =  0x4000 },
            speed = 2.0,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            startPos = { x = -460, y = 373, z = 5407, yaw = 0x1000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x =  3056, y = 10387, z = -7108, yaw =  0x0000 },
            speed = 2.4,
            author = "GmdDoesDMG",
            type = FLOOD_POISON,
            startPos = { x = 8759, y = -1190, z = -256, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "b2",
            level = LEVEL_BOWSER_2,
            area = 1,
            flagPos = { x =  1457, y = 14208, z = -2505, yaw =  -0x4000 },
            speed = 3.5,
            author = "GmdDoesDMG",
            type = FLOOD_POISON,
            startPos = { x = -6097, y = 4652, z = -1598, yaw = 0x6000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x =  -113, y = 1946, z = 4528, yaw =  0x7000 },
            speed = 2.0,
            author = "GmdDoesDMG",
            type = FLOOD_SAND,
            startPos = { x = 996, y = 563, z = 2460, yaw = 0x6000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x =  4023, y = 2000, z = 1155, yaw =  -0x2000 },
            speed = 4.5,
            author = "GmdDoesDMG",
            type = FLOOD_LAVA,
            startPos = { x = -2860, y = -709, z = -1171, yaw = 0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "sl2",
            level = LEVEL_SL,
            area = 2,
            flagPos = { x = 320, y = 5920, z = -330, yaw = -0x4000 },
            speed = 2.0,
            author = "GmdDoesDMG",
            type = FLOOD_SAND,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x =  3560, y = 5277, z = 136, yaw =  0x0000 },
            speed = 2.0,
            author = "GmdDoesDMG",
            type = FLOOD_LAVA,
            startPos = { x = 3012, y = 1170, z = -3194, yaw = 0x5000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x =  -4659, y = 3765, z = -1742, yaw =  0x1500 },
            speed = 1.0,
            author = "GmdDoesDMG",
            type = FLOOD_SAND,
            startPos = { x = 6960, y = 1384, z = 6230, yaw = -0x5500 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x =  27547, y = 5923, z = 261, yaw =  -0x4000 },
            speed = 1.6,
            author = "GmdDoesDMG",
            type = FLOOD_DARKNESS,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x =  860, y = 4710, z = -9090, yaw =  0x0000 },
            speed = 2.0,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x =  4935, y = 5537, z = 78, yaw =  -0x5500 },
            speed = 3.0,
            author = "GmdDoesDMG",
            type = FLOOD_SUNSET,
            startPos = { x = 444, y = 1266, z = -1335, yaw = 0x6000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x =  7028, y = 2374, z = -3305, yaw =  -0x3000 },
            speed = 5.2,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            startPos = { x = 6233, y = -1275, z = 230, yaw = 0x6000 },
            unwantedBhvs = { id_bhvWarpPipe }
        }
    }
end

-- Super Mario Treasure World, ported to Flood by SuperRodrigo0
local function flood_load_treasure_world_levels()
    game = GAME_TREASURE_WORLD
    romhackInfo = "Super Mario Treasure World"
	romhackLogo = get_texture_info("treasure_world_logo")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -2826, y = -2695, z = -8313, yaw = 0x8000},
            deathHeight = -3725,
            music = { name = "The Safari - Lion Musashi" },
        },
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -7704, y = -2893, z = -1536, yaw = 0x8000},
            deathHeight = -3725,
            music = { name = "Arsenal - Kantai Collection" },
        },
        [3] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -5665, y = 5, z = 5006, yaw = 0x8000},
            deathHeight = -3725,
            music = { name = "Arsenal - Kantai Collection" },
        },
        [4] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -589, y = -2066, z = 5510, yaw = 0x8000},
            deathHeight = -4690,
            music = { name = "Septette for the Dead Princess - Touhou Puppet Play 1.8 Enhanced" },
        },
        [5] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -1556, y = -3407, z = 8874, yaw = 0x8000},
            deathHeight = -4887,
            music = { name = "Route 26/27 - Pokemon Gold/Silver" },
        },
        [6] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 6820, y = 850, z = -4082, yaw = 0x8000},
            deathHeight = -4887,
            music = { name = "Route 26/27 - Pokemon Gold/Silver" },
        },
        [7] = {
            level = LEVEL_VCUTM,
            area = 1,
            spawn = {x = -8584, y = 4572, z = 7465, yaw = 0x8000},
            music = { name = "Futari no Kimochi no Honto no Himitsu - Kill Me Baby" },
        },
        [8] = {
            level = LEVEL_THI,
            area = 1,
            spawn = {x = -9069, y = 2668, z = -10648, yaw = 0x8000},
            deathHeight = -6525,
            music = { name = "Bramble Blast - Super Smash Bros. Brawl" },
        },
        [9] = {
            level = LEVEL_BBH,
            area = 1,
            spawn = {x = 5735, y = 570, z = -4100, yaw = 0x0000},
            music = { name = "Romantic Children - Touhou 5: Mystic Square" },
        },
        [10] = {
            level = LEVEL_BITDW,
            area = 1,
            spawn = {x = -4702, y = 2592, z = -9012, yaw = 0x8000},
            deathHeight = -3552,
            music = { name = "Paranoia - 180" },
        },
        [11] = {
            level = LEVEL_COTMC,
            area = 1,
            spawn = {x = -2345, y = -7329, z = -9626, yaw = 0x8000},
            music = { name = "Tragedy Flame - Raiden II" },
        },
        [12] = {
            level = LEVEL_LLL,
            area = 1,
            spawn = {x = 4747, y = 6862, z = 1512, yaw = 0x8000},
            deathHeight = 5534,
            music = { name = "Bubbly Washing Machine - Super Monkey Ball 2" },
        },
        [13] = {
            level = LEVEL_DDD,
            area = 1,
            spawn = {x = -8468, y = 1571, z = 8847, yaw = 0x2000},
            deathHeight = -8478,
            music = { name = "Treetop Rock - Donkey Kong Country" },
        },
        [14] = {
            level = LEVEL_SL,
            area = 1,
            spawn = {x = -5209, y = 5246, z = -5292, yaw = -0x6000},
            deathHeight = -407,
            music = { name = "Subterranean Hatred - Touhou 11: Phantasm Stage" },
        },
        [15] = {
            level = LEVEL_WDW,
            area = 1,
            spawn = {x = 2148, y = 4520, z = -3767, yaw = -0x4000},
            deathHeight = 936,
            music = { name = "Kuru Kuru Kururin - Star Land" },
        },
        [16] = {
            level = LEVEL_TTM,
            area = 1,
            spawn = {x = 7349, y = 5425, z = 3211, yaw = 0x8000},
            deathHeight = 2737,
            music = { name = "Medieval Mayhem - Ape Escape" },
        },
        [17] = {
            level = LEVEL_TTC,
            area = 1,
            spawn = {x = 12057, y = 1658, z = -7988, yaw = -0x4000},
            deathHeight = -6086,
            music = { name = "Peach Dome Court Exhibition Match - Mario Power Tennis" },
        },
        [18] = {
            level = LEVEL_ENDING,
            area = 1,
            spawn = {x = -5652, y = -2790, z = 4162, yaw = 0x6000},
            music = { name = "20, november (single mix) - Beatmania" },
        },
        [19] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 4794, y = 5148, z = 359, yaw = 0x2000},
            deathHeight = -3725,
            music = { name = "Arsenal - Kantai Collection" },
        },
        [20] = {
            level = LEVEL_RR,
            area = 1,
            spawn = {x = 2815, y = 2320, z = -11880, yaw = 0x4000},
            deathHeight = -432,
            music = { name = "Necrofantasia - Touhou Puppet Play 1.8 Enhanced" },
        },
        [21] = {
            level = LEVEL_BOB,
            area = 1,
            spawn = {x = 4968, y = -3343, z = -2474, yaw = -0x5000},
            music = { name = "The Safari - Lion Musashi" },
        }
    }

    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

    gLevels = {
        {
            name = "BOB",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 2330, y = 2210, z = -2495, yaw = -0x4000 },
            flagBase = true,
            speed = 3.6,
            author = "Rambi_Rampage",
            type = FLOOD_WATER,
            startPos = { x = -2419, y = -3563, z = -549, yaw = 0x7000 },
            overrideName = "Glass Land Park (1)",
            launchpads = {
                { x = -736, y = 383, z = 4508, yaw = 0x8000, vel = 55, forwardVel = 50, capTimer = 130 },
            },	
            music = { name = "The Safari - Lion Musashi" },
        },
        {
            name = "BOB2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -3940, y = 2063, z = 1525, yaw = -0x4000 },
            flagBase = false,
            speed = 2.75,
            author = "Rambi_Rampage",
            type = FLOOD_WATER,
            startPos = { x = -5229, y = -2599, z = 5972, yaw = 0x8000 },
            overrideName = "Glass Land Park (2)",
            music = { name = "The Safari - Lion Musashi" },
        },
        {
            name = "WF",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -2521, y = 2434, z = 10264, yaw = 0x8000 },
            flagBase = false,
            speed = 3.4,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = -4034, y = -2346, z = 5439, yaw = -0x4000 },
            floodScale = 3.44,
            overrideName = "Sky High Castle (1)",
            floodHeight = -4300,
            music = { name = "Remix 4 - Rhythm Heaven" },
        },
        {
            name = "WF2",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -8926, y = 5207, z = -5350, yaw = 0x8000 },
            flagBase = false,
            speed = 2.9,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = -1588, y = -45, z = -7571, yaw = 0x8000 },
            floodScale = 3.44,
            overrideName = "Sky High Castle (2)",
            music = { name = "Remix 4 - Rhythm Heaven" },
        },
        {
            name = "WF3",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 9251, y = 6176, z = -10081, yaw = 0x4000 },
            flagBase = true,
            speed = 3.0,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = 4351, y = -3248, z = -1679, yaw = 0x8000 },
            floodScale = 3.45,
            overrideName = "Sky High Castle (3)",
            music = { name = "Remix 4 - Rhythm Heaven" },
        },
        {
            name = "WF4",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -7470, y = 5058, z = 1449, yaw = 0x8000 },
            flagBase = true,
            speed = 1.7,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = -2181, y = 35, z = -4605, yaw = -0x4000 },
            floodScale = 3.8,
            overrideName = "Sky High Castle (4)",
            music = { name = "Remix 4 - Rhythm Heaven" },
        },
        {
            name = "WF5",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 10608, y = 6200, z = 8197, yaw = 0x8000 },
            flagBase = false,
            speed = 2.5,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = 2560, y = -1044, z = 7386, yaw = -0x4000 },
            floodScale = 3.44,
            overrideName = "Sky High Castle (5)",
            music = { name = "Remix 4 - Rhythm Heaven" },
        },
        {
            name = "TOTWC",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 1204, y = 5354, z = 10588, yaw = 0x4000 },
            flagBase = true,
            speed = 3.8,
            author = "Rambi_Rampage",
            type = FLOOD_MUD,
            floodScale = 2.0,
            overrideName = "Autumn Memories (1)",
            music = { name = "Mountain of Faith - Touhou 10" },
        },
        {
            name = "TOTWC2",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 1883, y = 4511, z = -2605, yaw = 0x4000 },
            flagBase = true,
            speed = 3.75,
            speed = 3.0,
            author = "Rambi_Rampage",
            type = FLOOD_MUD,
            startPos = { x = 8255, y = 1183, z = -4929, yaw = 0x0000 },
            floodScale = 2.0,
            overrideName = "Autumn Memories (2)",
            music = { name = "Mountain of Faith - Touhou 10" },
        },
        {
            name = "TOTWC3",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 4526, y = 4124, z = 8844, yaw = 0x4000 },
            flagBase = false,
            speed = 2.9,
            author = "Rambi_Rampage",
            type = FLOOD_MUD,
            startPos = { x = 10537, y = 3040, z = -3117, yaw = 0x0000 },
            floodScale = 2.0,
            overrideName = "Autumn Memories (3)",
            capTimer = 1,
            music = { name = "Mountain of Faith - Touhou 10" },
        },
        {
            name = "CCM",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -10286, y = 4677, z = 732, yaw = 0x0000 },
            flagBase = false,
            speed = 3.55,
            author = "Rambi_Rampage",
            type = FLOOD_SNOW,
            floodScale = 2.5,
            overrideName = "After The Snow (1)",
            music = { name = "Perfect Cherry Blossom - Touhou 7" },
        },
        {
            name = "CCM2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 5740, y = 3477, z = -11847, yaw = 0x0000 },
            flagBase = false,
            speed = 2.9,
            author = "Rambi_Rampage",
            type = FLOOD_SNOW,
            startPos = { x = -4414, y = -936, z = -12234, yaw = 0x4000 },
            unwantedBhvs = {id_bhvExclamationBox},
            floodScale = 2.5,
            floodHeight = -3816,
            overrideName = "After The Snow (2)",
            music = { name = "Perfect Cherry Blossom - Touhou 7" },
        },
        {
            name = "CCM3",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 2556, y = 3491, z = 10949, yaw = 0x0000 },
            flagBase = true,
            speed = 1.7,
            author = "Rambi_Rampage",
            type = FLOOD_SNOW,
            startPos = { x = 4623, y = 1318, z = 11012, yaw = -0x4000 },
            floodScale = 2.5,
            overrideName = "After The Snow (3)",
            music = { name = "Perfect Cherry Blossom - Touhou 7" },
        },
        {
            name = "CCM4",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 12068, y = 5180, z = 12073, yaw = 0x8000 },
            flagBase = true,
            speed = 3.15,
            author = "Rambi_Rampage",
            type = FLOOD_SNOW,
            startPos = { x = 3772, y = 1096, z = -2308, yaw = 0x6000 },
            floodScale = 2.5,
            overrideName = "After The Snow (4)",
            floodHeight = -1200,
            music = { name = "Perfect Cherry Blossom - Touhou 7" },
        },
        {
            name = "BBH",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 11381, y = 3005, z = -3900, yaw = 0x8000 },
            flagBase = true,
            speed = 3.43,
            author = "Rambi_Rampage",
            type = FLOOD_ACID,
            startPos = { x = 295, y = -4447, z = 11116, yaw = 0x6000 },
            floodScale = 2.5,
            overrideName = "Sleepless Night (1)",
            music = { name = "Romantic Children - Touhou 5: Mystic Square" },
        },
        {
            name = "BBH2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 9046, y = 3971, z = 9425, yaw = 0x4000 },
            flagBase = false,
            speed = 2.6,
            author = "Rambi_Rampage",
            type = FLOOD_ACID,
            startPos = { x = 5976, y = -3044, z = 6237, yaw = 0x2000 },
            floodScale = 2.5,
            overrideName = "Sleepless Night (2)",
            music = { name = "Romantic Children - Touhou 5: Mystic Square" },
        },
        {
            name = "BBH3",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -11900, y = 1415, z = -6328, yaw = 0x0000 },
            flagBase = true,
            speed = 1.9,
            author = "Rambi_Rampage",
            type = FLOOD_ACID,
            startPos = { x = 2136, y = -2944, z = 8721, yaw = -0x4000 },
            floodScale = 2.5,
            overrideName = "Sleepless Night (3)",
            music = { name = "Romantic Children - Touhou 5: Mystic Square" },
        },
        {
            name = "BBH4",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -265, y = 3936, z = 1089, yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "Rambi_Rampage",
            type = FLOOD_ACID,
            startPos = { x = 469, y = -3462, z = 1610, yaw = 0x8000 },
            floodScale = 2.5,
            overrideName = "Sleepless Night (4)",
            music = { name = "Romantic Children - Touhou 5: Mystic Square" },
        },
        {
            name = "SA",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 6690, y = 4861, z = -9207, yaw = -0x4000 },
            flagBase = false,
            speed = 3.7,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 4853, y = -2338, z = 2713, yaw = 0x8000 },
            floodScale = 3.0,
            floodHeight = -4922,
            overrideName = "Lumps Jumps (1)",
            music = { name = "Katamari Nah-Nah - Katamari Damacy" },
        },
        {
            name = "SA2",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -8834, y = -1682, z = 4142, yaw = 0x0000 },
            flagBase = true,
            speed = 2.7,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 3531, y = -3335, z = 7005, yaw = -0x3000 },
            floodScale = 3.0,
            overrideName = "Lumps Jumps (2)",
            floodHeight = -4922,
            music = { name = "Katamari Nah-Nah - Katamari Damacy" },
        },
        {
            name = "SA3",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 8849, y = -424, z = -7494, yaw = 0x0000 },
            flagBase = false,
            speed = 3.6,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 7151, y = -3189, z = 4696, yaw = 0x6000 },
            floodScale = 3.0,
            overrideName = "Lumps Jumps (3)",
            floodHeight = -4922,
            music = { name = "Katamari Nah-Nah - Katamari Damacy" },
        },
        {
            name = "BITDW",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 9320, y = 6328, z = 5878, yaw = -0x4000 },
            flagBase = false,
            speed = 2.186,
            author = "Rambi_Rampage",
            type = FLOOD_POISON,
            startPos = { x = -7772, y = -5730, z = 3596, yaw = -0x2000 },
            floodScale = 3.0,
            overrideName = "Bowser's Eccentric Promenade (1)",
            floodHeight = -7650,
            music = { name = "Paranoia - 180" },
        },
        {
            name = "BITDW2",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -9905, y = 1000, z = 8727, yaw = 0x4000 },
            flagBase = false,
            speed = 2.55,
            author = "Rambi_Rampage",
            type = FLOOD_POISON,
            startPos = { x = 10536, y = -2782, z = 7228, yaw = -0x2000 },
            floodScale = 3.0,
            overrideName = "Bowser's Eccentric Promenade (2)",
            floodHeight = -7500,
            launchpads = {
                { x = 3906, y = -2957, z = 4496, yaw = 0x1995, vel = 90, forwardVel = 0 },
            },	
            music = { name = "Paranoia - 180" },
        },
        {
            name = "BITDW3",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -2909, y = 4671, z = 9222, yaw = 0x4000 },
            flagBase = true,
            speed = 2.19,
            author = "Rambi_Rampage",
            type = FLOOD_POISON,
            startPos = { x = 6381, y = 1342, z = -3121, yaw = 0x4000 },
            overrideName = "Bowser's Eccentric Promenade (3)",
            floodScale = 3.0,
            music = { name = "Paranoia - 180" },
        },
        {
            name = "COTMC",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 11530, y = 5340, z = -11592, yaw = 0x0000 },
            flagBase = true,
            speed = 3.2,
            author = "Rambi_Rampage",
            type = FLOOD_LAVA,
            startPos = { x = -3710, y = -7836, z = 7465, yaw = 0x6500 },
            floodScale = 2.0,
            overrideName = "Neo Memories (1)",
            floodHeight = -9692,
            music = { name = "Tragedy Flame - Raiden II" },
        },
        {
            name = "COTMC2",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 9933, y = 2699, z = 2009, yaw = 0x8000 },
            flagBase = false,
            speed = 3.45,
            author = "Rambi_Rampage",
            type = FLOOD_LAVA,
            startPos = { x = -429, y = -7005, z = 8292, yaw = 0x1500 },
            floodScale = 2.0,
            overrideName = "Neo Memories (2)",
            music = { name = "Tragedy Flame - Raiden II" },
        },
        {
            name = "COTMC3",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -7005, y = -1965, z = -9707, yaw = 0x0000 },
            flagBase = false,
            speed = 2.9,
            author = "Rambi_Rampage",
            type = FLOOD_LAVA,
            startPos = { x = -7811, y = -7176, z = 11886, yaw = 0x8000 },
            floodScale = 2.0,
            overrideName = "Neo Memories (3)",
            music = { name = "Tragedy Flame - Raiden II" },
        },
        {
            name = "COTMC4",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 9052, y = 6127, z = 11483, yaw = 0x4000 },
            flagBase = false,
            speed = 7.5,
            author = "Rambi_Rampage",
            type = FLOOD_LAVA,
            startPos = { x = 11060, y = -2690, z = 4749, yaw = 0x2000 },
            floodScale = 2.0,
            overrideName = "Neo Memories (4)",
            music = { name = "Tragedy Flame - Raiden II" },
        },
        {
            name = "HMC",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 7706, y = -1600, z = 7767, yaw = 0x0000 },
            flagBase = false,
            speed = 2.78,
            author = "Rambi_Rampage",
            type = FLOOD_MOLTEN,
            floodScale = 1.5,
            overrideName = "Stopped Clock (1)",
            music = { name = "Will We Fight? - Pawapoke 10" },
        },
        {
            name = "HMC2",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 8012, y = 7533, z = -8096, yaw = 0x0000 },
            flagBase = true,
            speed = 4.2,
            author = "Rambi_Rampage",
            type = FLOOD_MOLTEN,
            startPos = { x = 5085, y = -3501, z = -2240, yaw = -0x8900 },
            floodScale = 1.5,
            overrideName = "Stopped Clock (2)",
            floodHeight = -6601,
            music = { name = "Will We Fight? - Pawapoke 10" },
        },
        {
            name = "HMC3",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -7491, y = 5113, z = 7911, yaw = 0x4000 },
            flagBase = true,
            speed = 3.9,
            author = "Rambi_Rampage",
            type = FLOOD_MOLTEN,
            startPos = { x = -3283, y = -4177, z = 2953, yaw = -0x4000 },
            unwantedBhvs = {id_bhvExclamationBox},
            floodScale = 1.5,
            overrideName = "Stopped Clock (3)",
            music = { name = "Will We Fight? - Pawapoke 10" },
        },
        {
            name = "LLL",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -9309, y = 3902, z = -8599, yaw = 0x4000 },
            flagBase = true,
            speed = 2.85,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = 8317, y = -4834, z = 9705, yaw = 0x8000 },
            floodScale = 3.0,
            overrideName = "Bubbly Bubbly Laundry (1)",
            floodHeight = -7300,
            launchpads = {
                { x = -1811, y = 2861, z = -7462, yaw = -0x4000, vel = 150, forwardVel = 100 },
            },	
            music = { name = "Bubbly Washing Machine - Super Monkey Ball 2" },
        },
        {
            name = "LLL2",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 8240, y = 7738, z = -11837, yaw = 0x0000 },
            flagBase = true,
            speed = 1.8,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = 2758, y = 6862, z = 811, yaw = 0x4000 },
            floodScale = 3.0,
            overrideName = "Bubbly Bubbly Laundry (2)",
            unwantedBhvs = { id_bhvFadingWarp },
            floodHeight = 4786,
            music = { name = "Bubbly Washing Machine - Super Monkey Ball 2" },
        },
        {
            name = "SSL",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 3695, y = -1449, z = 5497, yaw = 0x4000 },
            flagBase = false,
            speed = 1.65,
            author = "Rambi_Rampage",
            type = FLOOD_SULFUR,
            startPos = { x = -1570, y = -6491, z = -3647, yaw = 0x8000 },
            floodScale = 3.0,
            overrideName = "Toasted Coast (1)",
            floodHeight = -9059,
            music = { name = "Cotton Island - Plok" },
        },
        {
            name = "SSL2",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -14084, y = 394, z = -3577, yaw = 0x4000 },
            flagBase = true,
            speed = 1.8,
            author = "Rambi_Rampage",
            type = FLOOD_SULFUR,
            startPos = { x = 4061, y = -3213, z = 5925, yaw = 0x8000 },
            floodScale = 3.0,
            overrideName = "Toasted Coast (2)",
            floodHeight = -5645,
            music = { name = "Cotton Island - Plok" },
        },
        {
            name = "SSL3",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -12557, y = -1467, z = -10869, yaw = 0x2000 },
            flagBase = true,
            speed = 3.87,
            author = "Rambi_Rampage",
            type = FLOOD_SULFUR,
            startPos = { x = -5197, y = -6680, z = -5353, yaw = -0x5000 },
            floodScale = 3.0,
            overrideName = "Toasted Coast (3)",
            floodHeight = -9059,
            music = { name = "Cotton Island - Plok" },
        },
        {
            name = "VCUTM",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -6141, y = 444, z = -5186, yaw = 0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "Rambi_Rampage",
            type = FLOOD_DESERT,
            startPos = { x = -184, y = -6433, z = 12184, yaw = 0x8000 },
            floodScale = 3.0,
            overrideName = "Beginner's Memories (1)",
            floodHeight = -11033,
            music = { name = "Futari no Kimochi no Honto no Himitsu - Kill Me Baby" },
        },
        {
            name = "VCUTM2",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -3239, y = 1814, z = -4483, yaw = 0x8000 },
            flagBase = true,
            speed = 2.6,
            author = "Rambi_Rampage",
            type = FLOOD_DESERT,
            startPos = { x = -10142, y = -2802, z = -2896, yaw = 0x8000 },
            floodScale = 3.0,
            overrideName = "Beginner's Memories (2)",
            music = { name = "Futari no Kimochi no Honto no Himitsu - Kill Me Baby" },
        },
        {
            name = "VCUTM3",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 8220, y = -718, z = 12621, yaw = 0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Rambi_Rampage",
            type = FLOOD_DESERT,
            startPos = { x = 3004, y = -6366, z = 10882, yaw = 0x4000 },
            floodScale = 3.0,
            overrideName = "Beginner's Memories (3)",
            floodHeight = -9200,
            music = { name = "Futari no Kimochi no Honto no Himitsu - Kill Me Baby" },
        },
        {
            name = "VCUTM4",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 1415, y = 5065, z = -11390, yaw = 0x0000 },
            flagBase = false,
            speed = 4.0,
            author = "Rambi_Rampage",
            type = FLOOD_DESERT,
            startPos = { x = 13012, y = -6414, z = -10339, yaw = 0x0000 },
            floodScale = 3.0,
            overrideName = "Beginner's Memories (4)",
            floodHeight = -9200,
            music = { name = "Futari no Kimochi no Honto no Himitsu - Kill Me Baby" },
        },
        {
            name = "VCUTM5",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -8437, y = -1268, z = 12019, yaw = 0x8000 },
            flagBase = false,
            speed = 2.4,
            author = "Rambi_Rampage",
            type = FLOOD_DESERT,
            startPos = { x = -4811, y = -6490, z = 723, yaw = -0x4000 },
            floodScale = 3.0,
            overrideName = "Beginner's Memories (5)",
            floodHeight = -9000,
            music = { name = "Futari no Kimochi no Honto no Himitsu - Kill Me Baby" },
        },
        {
            name = "VCUTM6",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 6639, y = 2669, z = -7756, yaw = -0x4000 },
            flagBase = true,
            speed = 1.95,
            author = "Rambi_Rampage",
            type = FLOOD_DESERT,
            startPos = { x = 7543, y = -3890, z = -6410, yaw = 0x0000 },
            floodScale = 3.0,
            overrideName = "Beginner's Memories (6)",
            floodHeight = -7000,
            music = { name = "Futari no Kimochi no Honto no Himitsu - Kill Me Baby" },
        },
        {
            name = "VCUTM7",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 5861, y = -1701, z = -7277, yaw = 0x4000 },
            flagBase = false,
            speed = 2.0,
            author = "Rambi_Rampage",
            type = FLOOD_DESERT,
            startPos = { x = 13570, y = -3363, z = -5804, yaw = -0x4000 },
            floodScale = 3.0,
            overrideName = "Beginner's Memories (7)",
            music = { name = "Futari no Kimochi no Honto no Himitsu - Kill Me Baby" },
        },
        {
            name = "DDD",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 363, y = -1310, z = -2296, yaw = -0x4000 },
            flagBase = false,
            speed = 2.85,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            floodScale = 3.0,
            overrideName = "Spruce Stem (1)",
            music = { name = "Treetop Rock - Donkey Kong Country" },
        },
        {
            name = "DDD2",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -6489, y = 5297, z = 5795, yaw = 0x2000 },
            flagBase = true,
            speed = 2.6,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 5580, y = -4079, z = -6956, yaw = 0x7000 },
            floodScale = 3.0,
            overrideName = "Spruce Stem (2)",
            music = { name = "Treetop Rock - Donkey Kong Country" },
        },
        {
            name = "DDD3",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 14196, y = 5558, z = 11844, yaw = -0x7000 },
            flagBase = false,
            speed = 2.3,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 5031, y = 794, z = 7138, yaw = 0x4000 },
            floodScale = 3.0,
            overrideName = "Spruce Stem (3)",
            music = { name = "Treetop Rock - Donkey Kong Country" },
        },
        {
            name = "DDD4",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -8062, y = 1927, z = -3576, yaw = 0x4000 },
            flagBase = false,
            speed = 1.95,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 9851, y = 1879, z = 1216, yaw = 0x8000 },
            floodScale = 3.0,
            overrideName = "Spruce Stem (4)",
            floodHeight = -2000,
            music = { name = "Treetop Rock - Donkey Kong Country" },
        },
        {
            name = "SL",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 2041, y = 4356, z = 1974, yaw = 0x8000 },
            flagBase = false,
            speed = 3.25,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = -6053, y = -6086, z = 11932, yaw = 0x8000 },
            floodScale = 3.0,
            overrideName = "Bustling Darkness (1)",
            music = { name = "Subterranean Hatred - Touhou 11: Phantasm Stage" },
        },
        {
            name = "SL2",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -5514, y = 5246, z = -5416, yaw = 0x8000 },
            flagBase = true,
            speed = 1.5,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 467, y = -554, z = 449, yaw = -0x5000 },
            floodScale = 3.0,
            overrideName = "Bustling Darkness (2)",
            music = { name = "Subterranean Hatred - Touhou 11: Phantasm Stage" },
        },
        {
            name = "SL3",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 5366, y = 6618, z = -5618, yaw = 0x0000 },
            flagBase = true,
            speed = 2.2,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = -2250, y = 1368, z = -11489, yaw = 0x4000 },
            floodScale = 3.0,
            overrideName = "Bustling Darkness (3)",
            music = { name = "Subterranean Hatred - Touhou 11: Phantasm Stage" },
        },
        {
            name = "BITFS",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 4279, y = -1805, z = -3728, yaw = -0x4000 },
            flagBase = false,
            speed = 2.7,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = -11629, y = -9380, z = -4519, yaw = 0x0000 },
            floodScale = 3.0,
            overrideName = "Bowser's Youthdays Promenade (1)",
            floodHeight = -14000,
            music = { name = "Golem Fight - Powapoke 5" },
        },
        {
            name = "BITFS2",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 3798, y = 8239, z = -12659, yaw = 0x4000 },
            flagBase = false,
            speed = 1.9,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = 4272, y = -1805, z = -3462, yaw = 0x8000 },
            floodScale = 3.0,
            overrideName = "Bowser's Youthdays Promenade (2)",
            floodHeight = -5621,
            music = { name = "Golem Fight - Powapoke 5" },
        },
        {
            name = "BITFS3",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 512, y = 2621, z = 10459, yaw = -0x4000 },
            flagBase = false,
            speed = 2.4,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = -6072, y = -1032, z = -9766, yaw = 0x8000 },
            floodScale = 3.0,
            overrideName = "Bowser's Youthdays Promenade (3)",
            floodHeight = -3528,
            music = { name = "Golem Fight - Powapoke 5" },
        },
        {
            name = "BITFS4",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 12582, y = -2714, z = 12289, yaw = 0x8000 },
            flagBase = true,
            speed = 2.6,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = 7353, y = -5907, z = 10345, yaw = 0x6000 },
            floodScale = 3.0,
            overrideName = "Bowser's Youthdays Promenade (4)",
            floodHeight = -9075,
            music = { name = "Golem Fight - Powapoke 5" },
        },
        {
            name = "WDW",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 12123, y = 2473, z = -12086, yaw = -0x2000 },
            flagBase = false,
            speed = 2.9,
            author = "Rambi_Rampage",
            type = FLOOD_RAINBOW,
            startPos = { x = -12123, y = -5320, z = 12173, yaw = 0x8000 },
            floodScale = 3.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvFadingWarp},
            overrideName = "Crumb Climb (1)",
            floodHeight = -8301,
            music = { name = "Kuru Kuru Kururin - Star Land" },
        },
        {
            name = "WDW2",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 2120, y = 4520,  z = -3796, yaw = 0x8000 },
            flagBase = false,
            speed = 1.6,
            author = "Rambi_Rampage",
            type = FLOOD_RAINBOW,
            startPos = { x = 7161, y = 1220, z = 5686, yaw = 0x6000 },
            floodScale = 3.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvFadingWarp},
            overrideName = "Crumb Climb (2)",
            music = { name = "Kuru Kuru Kururin - Star Land" },
        },
        {
            name = "PSS",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 5383, y = 1071, z = -4373, yaw = -0x4000 },
            flagBase = false,
            speed = 3.6,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 9513, y = -9011, z = -542, yaw = -0x3000 },
            floodScale = 3.0,
            overrideName = "Wall Wall Mountain (1)",
            music = { name = "Relations - Idolmaster 2" },
        },
        {
            name = "PSS2",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -9827, y = 8930, z = -7507, yaw = 0x8000 },
            flagBase = false,
            speed = 2.4,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 656, y = 846, z = -4753, yaw = -0x6000 },
            floodScale = 3.0,
            overrideName = "Wall Wall Mountain (2)",
            floodHeight = -3742,
            music = { name = "Relations - Idolmaster 2" },
        },
        {
            name = "PSS3",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 2896, y = 4819, z = -6110, yaw = 0x4000 },
            flagBase = false,
            speed = 3.7,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 7615, y = -2235, z = -8302, yaw = -0x2000 },
            floodScale = 3.0,
            overrideName = "Wall Wall Mountain (3)",
            floodHeight = -5739,
            music = { name = "Relations - Idolmaster 2" },
        },
        {
            name = "PSS4",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -3264, y = 4388, z = 452, yaw = 0x0000 },
            flagBase = false,
            speed = 2.3,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = -7277, y = 1960, z = -6901, yaw = -0x2000 },
            floodScale = 3.0,
            overrideName = "Wall Wall Mountain (4)",
            floodHeight = -2700,
            music = { name = "Relations - Idolmaster 2" },
        },
        {
            name = "PSS5",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 3982, y = 2987, z = 6078, yaw = 0x8000 },
            flagBase = false,
            speed = 4.2,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 6023, y = -3141, z = 12445, yaw = 0x3000 },
            floodScale = 3.0,
            overrideName = "Wall Wall Mountain (5)",
            floodHeight = -6700,
            music = { name = "Relations - Idolmaster 2" },
        },
        {
            name = "PSS6",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -5318, y = 9595, z = 1892, yaw = 0x8000 },
            flagBase = false,
            speed = 2.3,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            overrideName = "Wall Wall Mountain (6)",
            startPos = { x = -4715, y = 4747, z = 4534, yaw = -0x4000 },
            floodScale = 3.0,
            music = { name = "Relations - Idolmaster 2" },
        },
        {
            name = "TTM",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -376, y = -4329, z = -3704, yaw = 0x4000 },
            flagBase = false,
            speed = 2.64,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            floodScale = 3.0,
            overrideName = "Bridge Trudge (1)",
            music = { name = "Medieval Mayhem - Ape Escape" },
        },
        {
            name = "TTM2",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -6599, y = 5438, z = -1960, yaw = 0x8000 },
            flagBase = false,
            speed = 2.43,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = 3492, y = -4464, z = -5320, yaw = -0x3000 },
            floodScale = 3.0,
            overrideName = "Bridge Trudge (2)",
            music = { name = "Medieval Mayhem - Ape Escape" },
        },
        {
            name = "TTM3",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 2342, y = 542, z = -2426, yaw = 0x4000 },
            flagBase = false,
            speed = 1.2,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = -1807, y = -2920, z = -6545, yaw = 0x7000 },
            floodScale = 3.0,
            overrideName = "Bridge Trudge (3)",
            music = { name = "Medieval Mayhem - Ape Escape" },
        },
        {
            name = "TTM4",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 3030, y = 5893, z = -12343, yaw = 0x0000 },
            flagBase = false,
            speed = 2.7,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = -1593, y = 566, z = 5380, yaw = -0x1000 },
            floodScale = 3.0,
            overrideName = "Bridge Trudge (4)",
            floodHeight = -3186,
            launchpads = {
                { x = -10305, y = 2535, z = 9464, yaw = 0x4000, vel = 136, forwardVel = 0 },
                { x = -746, y = 4367, z = 9543, yaw = 0x8000, vel = 40, forwardVel = 50 },
                { x = 631, y = 6257, z = 3591, yaw = 0x4000, vel = 40, forwardVel = 50 },
            },	
            music = { name = "Medieval Mayhem - Ape Escape" },
        },
        {
            name = "THI",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 8227, y = 676,  z = 11554, yaw = 0x0000 },
            flagBase = false,
            speed = 2.26,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            floodScale = 3.0,
            overrideName = "Bramble Castle (1)",
            music = { name = "Bramble Blast - Super Smash Bros. Brawl" },
        },
        {
            name = "THI2",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 9618, y = 2907, z = -11476, yaw = 0x6000 },
            flagBase = true,
            speed = 2.60,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = 8792, y = -641, z = 11875, yaw = -0x4000 },
            floodScale = 3.0,
            overrideName = "Bramble Castle (2)",
            floodHeight = -7000,
            music = { name = "Bramble Blast - Super Smash Bros. Brawl" },
        },
        {
            name = "THI3",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -8482, y = 5762, z = -8635, yaw = -0x4000 },
            flagBase = true,
            speed = 4.3,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = -6342, y = -953, z = -12776, yaw = -0x4000 },
            floodScale = 3.0,
            overrideName = "Bramble Castle (3)",
            floodHeight = -5147,
            music = { name = "Bramble Blast - Super Smash Bros. Brawl" },
        },
        {
            name = "THI4",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -2008, y = 8657, z = 698, yaw = -0x2000 },
            flagBase = true,
            speed = 1.9,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = -2870, y = 2592, z = 494, yaw = -0x2000 },
            floodScale = 3.0,
            overrideName = "Bramble Castle (4)",
            floodHeight = -2287,
            music = { name = "Bramble Blast - Super Smash Bros. Brawl" },
        },
        {
            name = "TTC",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -10189, y = 4024, z = -11637, yaw = 0x0000 },
            flagBase = false,
            speed = 1.95,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            floodScale = 3.0,
            overrideName = "Permanent Firmament (1)",
            music = { name = "Peach Dome Court Exhibition Match - Mario Power Tennis" },
        },
        {
            name = "TTC2",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 12527, y = 1592, z = -5626, yaw = -0x4000 },
            flagBase = false,
            speed = 3.12,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = 7791, y = -4224, z = 11748, yaw = -0x3000 },
            floodScale = 3.0,
            overrideName = "Permanent Firmament (2)",
            floodHeight = -7016,
            music = { name = "Peach Dome Court Exhibition Match - Mario Power Tennis" },
        },
        {
            name = "TTC3",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 4156, y = 5687, z = 12665, yaw = -0x4000 },
            flagBase = true,
            speed = 3.1,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = -11692, y = 1318, z = 4834, yaw = 0x0000 },
            floodScale = 3.0,
            overrideName = "Permanent Firmament (3)",
            floodHeight = -2184,
            music = { name = "Peach Dome Court Exhibition Match - Mario Power Tennis" },
        },
        {
            name = "TTC4",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 7010, y = -1881, z = -8355, yaw = 0x4000 },
            flagBase = false,
            speed = 1.68,
            author = "Rambi_Rampage",
            type = FLOOD_CLOUDS,
            startPos = { x = 13110, y = -3463, z = 3164, yaw = 0x8000 },
            floodScale = 3.0,
            overrideName = "Permanent Firmament (4)",
            floodHeight = -7000,
            music = { name = "Peach Dome Court Exhibition Match - Mario Power Tennis" },
        },
        {
            name = "RR",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 2774, y = -1529, z = -2640, yaw = 0x4000 },
            flagBase = false,
            speed = 2.6,
            author = "Rambi_Rampage",
            type = FLOOD_SULFUR,
            floodScale = 3.5,
            overrideName = "Bowser's Land Of Fantasy (1)",
            music = { name = "Necrofantasia - Touhou Puppet Play 1.8 Enhanced" },
        },
        {
            name = "RR2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 13274, y = -864, z = -14632, yaw = -0x4000 },
            flagBase = true,
            speed = 2.6,
            author = "Rambi_Rampage",
            type = FLOOD_SULFUR,
            startPos = { x = 2508, y = -4122, z = -5944, yaw = 0x4000 },
            floodScale = 3.5,
            overrideName = "Bowser's Land Of Fantasy (2)",
            floodHeight = -12000,
            music = { name = "Necrofantasia - Touhou Puppet Play 1.8 Enhanced" },
        },
        {
            name = "RR3",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -1715, y = -3052, z = 5604, yaw = 0x8000 },
            flagBase = false,
            speed = 2.65,
            author = "Rambi_Rampage",
            type = FLOOD_SULFUR,
            startPos = { x = 13799, y = -7583, z = -4037, yaw = 0x4000 },
            floodScale = 3.5,
            overrideName = "Bowser's Land Of Fantasy (3)",
            floodHeight = -12000,
            music = { name = "Necrofantasia - Touhou Puppet Play 1.8 Enhanced" },
        },
        {
            name = "RR4",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 2815, y = 2320, z = -11880, yaw = -0x4000 },
            flagBase = false,
            speed = 2.7,
            author = "Rambi_Rampage",
            type = FLOOD_SULFUR,
            startPos = { x = -4141, y = -9227, z = 14371, yaw = -0x4000 },
            floodScale = 3.5,
            overrideName = "Bowser's Land Of Fantasy (4)",
            floodHeight = -12000,
            music = { name = "Necrofantasia - Touhou Puppet Play 1.8 Enhanced" },
        },
        {
            name = "RR5",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 12364, y = 9308, z = -13663, yaw = -0x4000 },
            flagBase = true,
            speed = 5.0,
            author = "Rambi_Rampage",
            type = FLOOD_SULFUR,
            startPos = { x = 418, y = 628, z = -11944, yaw = 0x4000 },
            floodScale = 3.5,
            overrideName = "Bowser's Land Of Fantasy (5)",
            music = { name = "Necrofantasia - Touhou Puppet Play 1.8 Enhanced" },
        },
        {
            name = "WMOTR",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 1108, y = 570,  z = 5000, yaw = 0x8000 },
            flagBase = false,
            speed = 1.95,
            author = "Rambi_Rampage",
            type = FLOOD_COTTON,
            floodScale = 2.0,
            overrideName = "Tsucnent's Dream (1)",
            music = { name = "Neo Land - Kururin Paradise" },
        },
        {
            name = "WMOTR2",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -14486, y = 1395,  z = -6872, yaw = -0x4000 },
            flagBase = false,
            speed = 1.6,
            author = "Rambi_Rampage",
            type = FLOOD_COTTON,
            startPos = { x = -1660, y = -838, z = 8, yaw = -0x4000 },
            floodScale = 2.0,
            overrideName = "Tsucnent's Dream (2)",
            floodHeight = -4472,
            music = { name = "Neo Land - Kururin Paradise" },
        },
        {
            name = "WMOTR3",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x =  -8058, y = 2513, z = -14968, yaw = -0x4000 },
            flagBase = false,
            speed = 1.7,
            author = "Rambi_Rampage",
            type = FLOOD_COTTON,
            startPos = { x = -15217, y = 161, z = -3838, yaw = 0x8000 },
            floodScale = 2.0,
            overrideName = "Tsucnent's Dream (3)",
            music = { name = "Neo Land - Kururin Paradise" },
        },
        {
            name = "WMOTR4",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -4193, y = 4204, z = -1343, yaw = 0x8000 },
            flagBase = false,
            speed = 0.4,
            author = "Rambi_Rampage",
            type = FLOOD_COTTON,
            startPos = { x = -8058, y = 2513, z = -14968, yaw = 0x4000 },
            floodScale = 2.0,
            overrideName = "Tsucnent's Dream (4)",
            music = { name = "Neo Land - Kururin Paradise" },
        },
        {
            name = "WMOTR5",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 15255, y = 364, z = 1849, yaw = 0x8000 },
            flagBase = false,
            speed = 0.6,
            author = "Rambi_Rampage",
            type = FLOOD_COTTON,
            startPos = { x = 1594, y = -1051, z = 7, yaw = 0x5000 },
            floodScale = 2.0,
            overrideName = "Tsucnent's Dream (5)",
            music = { name = "Neo Land - Kururin Paradise" },
        },
        {
            name = "WMOTR6",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 6516, y = 3256, z = -3967, yaw = 0x8000 },
            flagBase = false,
            speed = 0.8,
            author = "Rambi_Rampage",
            type = FLOOD_COTTON,
            startPos = { x = 15504, y = 27, z = -644, yaw = 0x8000 },
            floodScale = 2.0,
            overrideName = "Tsucnent's Dream (6)",
            music = { name = "Neo Land - Kururin Paradise" },
        },
        {
            name = "WMOTR7",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -9115, y = 7092, z = 2452, yaw = 0x8000 },
            flagBase = true,
            speed = 0.8,
            author = "Rambi_Rampage",
            type = FLOOD_COTTON,
            startPos = { x = -4125, y = 4204, z = -1450, yaw = -0x2000 },
            floodScale = 2.0,
            overrideName = "Tsucnent's Dream (7)",
            music = { name = "Neo Land - Kururin Paradise" },
        },
        {
            name = "WMOTR9",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 2692, y = 5374, z = 16140, yaw = 0x8000 },
            flagBase = false,
            speed = 0.8,
            author = "Rambi_Rampage",
            type = FLOOD_COTTON,
            startPos = { x = -7800, y = 2640, z = 5060, yaw = -0x2000 },
            floodScale = 2.0,
            overrideName = "Tsucnent's Dream (8)",
            music = { name = "Neo Land - Kururin Paradise" },
        },
        {
            name = "WMOTR9",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -15646, y = 8103, z = 9124, yaw = 0x8000 },
            flagBase = false,
            speed = 0.8,
            author = "Rambi_Rampage",
            type = FLOOD_COTTON,
            startPos = { x = -13564, y = 6737, z = 10588, yaw = 0x6000 },
            floodScale = 2.0,
            overrideName = "Tsucnent's Dream (9)",
            music = { name = "Neo Land - Kururin Paradise" },
        },
        {
            name = "BITS",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -5383, y = -212,  z = -4196, yaw = 0x8000 },
            flagBase = false,
            speed = 1.6,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            floodScale = 3.5,
            overrideName = "Bowser's Final Promenade (1)",
            music = { name = "Welcome - Ape Escape" },
        },
        {
            name = "BITS2",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -2631, y = 3149, z = -13766, yaw = -0x1000 },
            flagBase = true,
            speed = 0.5,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = -8794, y = -1059, z = -3843, yaw = -0x4000 },
            floodScale = 3.5,
            overrideName = "Bowser's Final Promenade (2)",
            music = { name = "Welcome - Ape Escape" }
        },
        {
            name = "BITS3",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -5855, y = 6010, z = -3161, yaw = 0x8000 },
            flagBase = false,
            speed = 0.3,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 8332, y = 3760, z = -9616, yaw = -0x2000 },
            floodScale = 3.5,
            overrideName = "Bowser's Final Promenade (3)",
            music = { name = "Welcome - Ape Escape" }
        },
        {
            name = "BITS4",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -6084, y = 8692, z = 11968, yaw = 0x8000 },
            flagBase = true,
            speed = 0.8,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = -6642, y = 4775, z = -1813, yaw = 0x8000 },
            floodScale = 3.5,
            overrideName = "Bowser's Final Promenade (4)",
            music = { name = "Welcome - Ape Escape" }
        },
        {
            name = "BITS5",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 12486, y = 1839, z = -351, yaw = -0x4000 },
            flagBase = false,
            speed = 0.8,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = -6143, y = -2023, z = -819, yaw = 0x4000 },
            floodScale = 3.5,
            overrideName = "Bowser's Final Promenade (5)",
            music = { name = "Welcome - Ape Escape" }
        },
        {
            name = "BITS6",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -9182, y = 4497, z = 12818, yaw = 0x8000 },
            flagBase = false,
            speed = 1.0,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = -11627, y = 4497, z = 2371, yaw = 0x2000 },
            floodScale = 3.5,
            overrideName = "Bowser's Final Promenade (6)",
            music = { name = "Welcome - Ape Escape" }
        },
        {
            name = "BITS7",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = 6562, y = 9457, z = 13248, yaw = 0x4000 },
            flagBase = false,
            speed = 1.0,
            author = "Rambi_Rampage",
            type = FLOOD_DARKNESS,
            startPos = { x = 7720, y = 6286, z = -2468, yaw = 0x2000 },
            floodScale = 3.5,
            overrideName = "Bowser's Final Promenade (7)",
            music = { name = "Welcome - Ape Escape" }
        },
        {
            name = "ENDING",
            level = LEVEL_ENDING,
            area = 1,
            flagPos = { x = -4941, y = 1756, z = -1739, yaw = -0x6000 },
            flagBase = false,
            speed = 1.8,
            author = "Rambi_Rampage",
            type = FLOOD_WATER,
            startPos = { x = -5688, y = -2790, z = 4199, yaw = 0x6000 },
            floodScale = 2.0,
            overrideName = "The Finale",
            music = { name = "20, november (single mix) - Beatmania" },
        },
        {
            name = "CG",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 4174, y = 2509, z = 5375, yaw = 0x4000 },
            flagBase = false,
            speed = 3.1,
            author = "Rambi_Rampage",
            type = FLOOD_WATER,
            floodScale = 2.0,
            overrideName = "First Overworld (1)",
            music = { name = "Arsenal - Kantai Collection" },
        },
        {
            name = "CG2",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 8773, y = 5345, z = -1368, yaw = 0x0000 },
            flagBase = false,
            speed = 4.0,
            author = "Rambi_Rampage",
            type = FLOOD_WATER,
            startPos = { x = -5680, y = 5, z = 4969, yaw = 0x2000 },
            floodScale = 2.0,
            overrideName = "First Overworld (2)",
            music = { name = "Arsenal - Kantai Collection" },
        },
        {
            name = "CC",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 5739, y = 2590, z = -4089, yaw = 0x8000 },
            flagBase = true,
            speed = 3.5,
            author = "Rambi_Rampage",
            type = FLOOD_LAVA,
            startPos = { x = -662, y = -2066, z = 5258, yaw = 0x8000 },
            floodScale = 2.0,
            overrideName = "Second Overworld",
            music = { name = "Septette for the Dead Princess - Touhou Puppet Play 1.8 Enhanced" },
        },
        {
            name = "CASTLE",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 309, y = 5084, z = -9311, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "Rambi_Rampage",
            type = FLOOD_WATER,
            startPos = { x = -1556, y = -3151, z = 8851, yaw = 0x8000 },
            floodScale = 2.0,
            overrideName = "Third Overworld",
            music = { name = "Route 26/27 - Pokemon Gold/Silver" },
        }
    }
end

-- Treasure World Dream Edition, ported to Flood by SuperRodrigo0
local function flood_load_treasure_world_dream_edition_levels()
    game = GAME_TREASURE_WORLD_DREAM_EDITION
    romhackInfo = "Super Mario Treasure World: Dream Edition"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = -5543, z = 3, yaw = 0x0000}
        },
        [2] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 7689, y = -4514, z = 2647, yaw = 0x0000}
        },
        [3] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 7300, y = -5106, z = 8865, yaw = 0x0000}
        },
        [3] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -2444, y = -6162, z = 10477, yaw = 0x8000}
        }
    }

    hook_behavior(id_bhvWarpPipe, OBJ_LIST_UNIMPORTANT, true, obj_hide, obj_mark_for_deletion_on_sync)

    gLevels = {
        {
            name = "BOB",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -9419, y = 685, z = -13811, yaw = 0x4000 },
            flagBase = false,
            speed = 3.0,
            author = "Rambi_Rampage",
            type = FLOOD_WATER,
        },
        {
            name = "BOB2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -8306, y = 6876, z = 1643, yaw = 0x4000 },
            flagBase = false,
            speed = 2.05,
            author = "Rambi_Rampage",
            type = FLOOD_WATER,
            startPos = { x = -9592, y = 887, z = -13094, yaw = -0x4000 },
        },
        {
            name = "BOB3",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 13556, y = 3688, z = -5087, yaw = 0x0000 },
            flagBase = false,
            speed = 1.7,
            author = "Rambi_Rampage",
            type = FLOOD_WATER,
            startPos = { x = 10788, y = -715, z = 5525, yaw = 0x4000 },
        },
        {
            name = "WF",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -12597, y = 8382, z = -14415, yaw = 0x4000 },
            flagBase = false,
            speed = 2.4,
            author = "Rambi_Rampage",
            type = FLOOD_WATER,
        },
        {
            name = "TOTWC",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 10472, y = 2466, z = -3946, yaw = -0x4000 },
            flagBase = false,
            speed = 3.75,
            author = "Rambi_Rampage",
            type = FLOOD_LAVA,
        }
    }
end

-- Sonic Adventure 64 DX, ported to Flood by Jzzay
local function flood_load_sonic_adventure_64_dx_levels()
    game = GAME_SONIC_ADVENTURE_64_DX
    romhackInfo = "Sonic Adventure 64"
	romhackLogo = get_texture_info("logo_sa64")
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -20140, y = 675, z = -25901, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x =  922,  y = 2450,  z = 9865, yaw =  0x8000 },
            speed = 0.9,
            author = "PablosCorner",
            type = FLOOD_WATER,
            startPos = { x = 9413, y = -538,  z = -8671, yaw = 0x9000 },
            overrideWater = true
        }
    }
end

-- Muhly64, ported to Flood by Jzzay
local function flood_load_muhly_64_levels()
    game = GAME_MUHLY_64
    romhackInfo = "Muhly 64"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -10, y = -74, z = 0, yaw = -32768}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 6266, y = 2005, z = -19317, yaw = 0x0000 },
            speed = 1.6,
            author = "just eh cupcake",
            type = FLOOD_POISON,
            startPos = { x = 437, y = 835, z = 785, yaw = 0x9000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 2,
            flagPos = { x = 1504, y = 4750, z = -9000, yaw = -0x4000 },
            speed = 1.85,
            author = "just eh cupcake",
            type = FLOOD_WATER,
            startPos = { x = -337, y = 1500, z = 3885, yaw = -0x8500 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 21396, y = 2889, z = -2252, yaw = -0x4000 },
            speed = 1.5,
            author = "just eh cupcake",
            type = FLOOD_DARKNESS,
            startPos = { x = 44, y = 329, z = 16955, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -18535, y = 2952, z = -12426, yaw = 0x1000 },
            speed = 1.75,
            author = "just eh cupcake",
            type = FLOOD_DARKNESS,
            startPos = { x = -7351, y = 864, z = 2641, yaw = 0x9000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -3985, y = 500, z = -11024, yaw = -0x2000 },
            speed = 2.85,
            author = "just eh cupcake",
            type = FLOOD_WATER,
            startPos = { x = 3, y = -500, z = 7189, yaw = 0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = -5508, y = 1500, z = 2452, yaw = 0x2000 },
            speed = 6.0,
            author = "just eh cupcake",
            type = FLOOD_LAVA,
            startPos = { x = 4, y = -500, z = 7254, yaw = 0x9000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        }
    }
end

-- Star Revenge 0.5: The Unused Levels, ported to Flood by SausRelics
local function flood_load_star_revenge_0_5_levels()
    game = GAME_STAR_REVENGE_0_5
    romhackInfo = "Star Revenge 0.5: Unused Levels"
	romhackLogo = get_texture_info("logo_sr0.5")	
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -14382, y = 1123, z = 1607, yaw = 0x3000 },
            flagBase = false,
            speed = 3.3,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = 2676, y = -2685, z = 5342, yaw = -0x6000 }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 3980, y = 3105, z = -196, yaw = 0x5000 },
            flagBase = false,
            speed = 3.9,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -246, y = -534, z = -680, yaw = 0x8000 }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -6695, y = 5870, z = -17077, yaw = 0x4000 },
            flagBase = false,
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_SNOW,
            startPos = { x = 4495, y = 461, z = -14657, yaw = -0x7500 }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -5380, y = 6640, z = 3222, yaw = 0x7000 },
            flagBase = false,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_LAVA,
            startPos = { x = 3680, y = 3465, z = -3524, yaw = 0x4000 }
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 7201, y = 876, z = -12551, yaw = 0x8000 },
            flagBase = false,
            speed = 4.4,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -3388, y = -5229, z = -7397, yaw = 0x8000 }
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -5222, y = 3473, z = 6134, yaw = 0x8000 },
            flagBase = false,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_WATER,
            startPos = { x = -5318, y = 2309, z = -3923, yaw = 0x0000 }
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -4310, y = 843, z = 1240, yaw = 0x8000 },
            flagBase = false,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_DESERT,
            startPos = { x = -9033, y = -72, z = -9823, yaw = 0x4000 }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 9435, y = 4793, z = -239, yaw = 0x8000 },
            flagBase = false,
            speed = 3.3,
            author = "BroDute",
            type = FLOOD_CLOUDS,
            startPos = { x = -4384, y = -3460, z = -4703, yaw = 0x4000 }
        },
    }
end

-- Waifu Cauldron, ported to Flood by Jzzay
local function flood_load_waifu_cauldron_levels()
    game = GAME_WAIFU_CAULDRON
    romhackInfo = "Waifu Cauldron"
    romhackLogo = get_texture_info("logo_wc")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = -66, z = -1150, yaw = 0x0000 },
            music = { name = "None" }			
        },
        [2] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 0, y = -66, z = -1150, yaw = 0x0000 },
            music = { name = "None" }			
        },
        [3] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 276, y = -1655, z = -4225, yaw = 0x8000 },
            music = { name = "None" }			
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -5676, y = 6536, z = -2845, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Morningstorm SM64",
            type = FLOOD_MAGMA,
            startPos = { x = 3669, y = 1351, z = 3480, yaw = -0x6000, airborne = true },
            music = { name = "Lava Rock Lair - Super Mario 3D World" }			
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -9475, y = 7580, z = -6650, yaw = 0x4000 },
            flagBase = true,			
            speed = 2.0,
            author = "Morningstorm SM64",
            type = FLOOD_SNOW,
            floodScale = 2,
            music = { name = "Mercuri Lamp - SHIKI" }			
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 1698, y = 7211, z = -2040, yaw =  0x8000 },
            flagBase = true,			
            speed = 3.5,
            author = "Morningstorm SM64",
            type = FLOOD_WATER,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox },		
            floodHeight = -1600,			
            music = { name = "Dire, Dire Docks - Super Mario 64" }			
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 5131, y = 3570, z = -8480, yaw = -0x2000 },
            flagBase = true,			
            speed = 2.5,
            author = "Morningstorm SM64",
            type = FLOOD_MUD,
            startPos = { x = 891, y = -2744, z = 1774, yaw = 0x8000, airborne = true },
            music = { name = "Deep Within the Heart - Ninja Gaiden II: The Dark Sword of Chaos" }			
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -3685, y = 1868, z = -4491, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "Morningstorm SM64",
            type = FLOOD_POISON,
            startPos = { x = -61, y = -2194, z = -5674, yaw = -0x4000, airborne = true },
            unwantedBhvs = { id_bhvExclamationBox },
            music = { name = "Gloomy Galleon - Donkey Kong 64" }			
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 1210, y = 8900, z = -4640, yaw = 0x4000 },	
            flagBase = true,			
            speed = 2.0,
            author = "Morningstorm SM64",
            type = FLOOD_DARKNESS,
            startPos = { x = 1208, y = 1566, z = -12466, yaw = 0x0000, airborne = true },
            floodScale = 2,			
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Cave Dungeon - Super Mario 64" }						
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -8330, y = 10100, z = -2620, yaw = 0x0000 },
            flagBase = true,			
            speed = 3.0,
            author = "Morningstorm SM64",
            type = FLOOD_POISON,
            floodScale = 2.5,
            music = { name = "Forsaken Fortress - The Legend Of Zelda: Thw Wind Water" }			
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -2915, y = 6690, z = 2645, yaw = -0x4000 },
            flagBase = true,			
            speed = 1.0,
            author = "Morningstorm SM64",
            type = FLOOD_SNOW,
            startPos = { x = -6535, y = -85, z = 1080, yaw = -0x4000, airborne = true }, 
            floodScale = 1.5,
            music = { name = "ヤツメ穴 - ころんば４号" }			
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 9470, y = 2265, z = -8810, yaw = 0x0000 },
            flagBase = true,			
            speed = 2.0,
            author = "Morningstorm SM64",
            type = FLOOD_COTTON,
            startPos = { x = 8726, y = -665, z = 4120, yaw = 0x8000, airborne = true },
            floodScale = 2,
            floodHeight = -3750,
            music = { name = "Repeated Tragedy - Raiden II" }			
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -3777, y = 12432, z = -16684, yaw = 0x8000 },
            speed = 2.0,
            author = "Morningstorm SM64",
            type = FLOOD_WATER,
            floodScale = 3,
            music = { name = "Sunyshore City (Day) - Pokémon Diamond/Pearl" }		
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 20210, y = 5526, z = 5690, yaw = 0x8000 },
            flagBase = true,			
            speed = 1.5,
            author = "Morningstorm SM64",
            type = FLOOD_MAGMA,
            startPos = { x = -3268, y = -1633, z = 1916, yaw = 0x4000, airborne = true },
            floodScale = 2.5,
            floodHeight = -4185,
            music = { name = "All or Nothing (Stage 3) - Raiden II" }				
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 2197, y = 4859, z = -2855, yaw = 0x4000 },
            flagBase = true,			
            speed = 2.5,
            author = "Morningstorm SM64",
            type = FLOOD_DARKNESS,
            startPos = { x = 2260, y = -1000, z = -1830, yaw = 0x4000, airborne = false },			
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Periligion Loveless Corrupt Cauldron",
            floodHeight = -3000,
            music = { name = "Extend Ash ~ Hourai Victim - Touhou 8: Imperishable Night" }					
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -353, y = 1865, z = 360, yaw = -0x6000 },
            speed = 1.5,
            author = "Morningstorm SM64",
            type = FLOOD_WATER,
            startPos = { x = -7047, y = -934, z = 2991, yaw = 0x8000, airborne = true },
            floodScale = 2.5,
            music = { name = "We Are The Robots (Dr.Wily: Stage 1) - Mega Man 9" }			
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = -4198, y = 827, z = -4196, yaw = 0x2000 },
            speed = 1.5,
            author = "Morningstorm SM64",
            type = FLOOD_CLOUDS,
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "みくみくにしてあげる - Hatsune Miku" }		
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 8280, y = 11295, z = 8980, yaw = 0x8000 },
            speed = 3.0,
            author = "Morningstorm SM64",
            type = FLOOD_POISON,
            startPos = { x = 1305, y = 2162, z = 8675, yaw = 0x0000, airborne = true },
            floodScale = 3,
            unwantedBhvs = { id_bhvExclamationBox },
            music = { name = "Vanishing Dream ~ Lost Dream - Touhou 3: Phantasmagoria of Dim.Dream" }			
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -4912, y = 2402, z = -3050, yaw = 0x4000 },
            speed = 2.0,
            author = "Morningstorm SM64",
            type = FLOOD_WATER,
            startPos = { x = 2131, y = -34, z = -9372, yaw = -0x1000, airborne = true },
            floodScale = 3.5,
            music = { name = "Romantic Children - Touhou 5: Mystic Square" }			
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 16658, y = 19, z = -25159, yaw = 0x0000 },
            speed = 3.0,
            author = "Morningstorm SM64",
            type = FLOOD_SNOW,
            floodScale = 3.75,
            music = { name = "AIR (BMS Mix) - SHIKI" }			
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -8421, y = 273, z = -12605, yaw = 0x0000 },
            speed = 1.5,
            author = "Morningstorm SM64",
            type = FLOOD_WATER,
            startPos = { x = -4872, y = -1692, z = 3764, yaw = 0x9000, airborne = true },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Rumble Temple (Fanmade) - Touhou 13: Ten Desires" }			
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = -2475, y = 4040, z = 1075, yaw = 10490 },
            speed = 3.0,
            author = "Morningstorm SM64",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Waifu Cauldron",
            music = { name = "None" }			
        },
        {
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -4222, y = 3499, z = -698, yaw = 0x8000 },
            flagBase = true,
            speed = 1.5,
            author = "Morningstorm SM64",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Waifu Nighttime Cauldron",
            music = { name = "None" }			
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = 95, y = 2200, z = -10095, yaw = 0x0000 },
            speed = 4.5,
            author = "Morningstorm SM64",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Waifu Grass",			
            floodHeight = -2500,
            music = { name = "None" }			
        }
    }
end
-- Gamer Mario's Destiny 64, ported to Flood by Bear64DX
local function flood_load_gamer_marios_destiny_levels()
    game = GAME_GAMER_MARIOS_DESTINY
    romhackInfo = "Gamer Mario's Destiny 64"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 395, y = 120, z = 395, yaw = 24576}
        },
        [2] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 395, y = 120, z = 395, yaw = 24576}
        },
        [3] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = 8, y = 424, z = -871, yaw = 0}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x =  3046,  y = 7093,  z = -5646, yaw =  0x0000 },
            speed = 3.95,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            startPos = { x = 443, y = 0, z = -1760, yaw = 0x6500 },
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x =  3476,  y = 4524, z = -2829, yaw =  -0x3000 },
            speed = 2.85,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            startPos = { x = 6309, y = 421, z = -924, yaw = 0x0000},
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -6315,  y = 7669,  z = -467, yaw =  -23805 },
            flagBase = true,
            speed = 4.6,
            author = "GmdDoesDMG",
            type = FLOOD_WATER,
            startPos = { x = -2495, y = -1498, z = -6944, yaw = -0x4000, airborne = false },
            unwantedBhvs = { id_bhvWarpPipe },
        }
    }
end

-- Classic Skylands, ported to Flood by Jzzay
local function flood_load_classic_skylands_levels()
    game = GAME_CLASSIC_SKYLANDS
    romhackInfo = "Classic Skylands"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x =  -34,  y = 2544,  z = 12086, yaw =  -0x4500 },
            speed = 6.5,
            author = "Tomatobird8",
            type = FLOOD_CLOUDS,
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x =  8708,  y = 11883,  z = -10345, yaw =  0x4000 },
            speed = 1.5,
            author = "GmdDoesDMG",
            type = FLOOD_CLOUDS,
            startPos = { x = 5615, y = 1232, z = -2303, yaw = 0x9000, airborne = false },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Classic Mountain Climb"
        },
        {
            name = "bob3",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x =  -10598,  y = 6369,  z = 2671, yaw =  0x4000 },
            speed = 2.0,
            author = "Tomatobird8",
            type = FLOOD_CLOUDS,
            startPos = { x = 4185, y = 1512, z = 1697, yaw = -0x4000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Classic Block Journey"
        }
    }
end

-- SM64 Paradise Island, ported to Flood by Bear64DX
local function flood_load_paradise_island_levels()
    game = GAME_PARADISE_ISLAND
    romhackInfo = "Super Mario 64: Paradise Island"
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 3255, y = 190, z = -4806, yaw = -0x1000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -1867,  y = 2601,  z = -259, yaw =  0x6000 },
            speed = 1.7,
            author = "Leonitz",
            type = FLOOD_WATER,
            startPos = { x = 2767, y = 273, z = 3266, yaw = -0x6200 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x =  -673,  y = 5175,  z = 5767, yaw =  0x8000 },
            speed = 3.2,
            author = "Leonitz",
            type = FLOOD_WATER,
            startPos = { x = -634, y = 2400, z = -1359, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x =  2581,  y = 3435,  z = 7915, yaw =  0x8000 },
            speed = 3.0,
            author = "Leonitz",
            type = FLOOD_WATER,
            startPos = { x = 2496, y = 0, z = 903, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x =  6541,  y = 2995,  z = 9277, yaw =  0x8000 },
            speed = 3.0,
            author = "Leonitz",
            type = FLOOD_WATER,
            startPos = { x = 1991, y = 0, z = 4856, yaw = 0x2350 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x =  6900,  y = 4442,  z = 17180, yaw =  -0x4000 },
            speed = 1.8,
            author = "Leonitz",
            type = FLOOD_WATER,
            startPos = { x = -7, y = 0, z = 149, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x =  496,  y = 948,  z = 4812, yaw =  0x0000 },
            speed = 3.2,
            author = "Leonitz",
            type = FLOOD_LAVA,
            startPos = { x = 2429, y = -753, z = 7266, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x =  2991,  y = 2540,  z = 6085, yaw =  0x4000 },
            speed = 3.0,
            author = "Leonitz",
            type = FLOOD_DESERT,
            startPos = { x = 5478, y = -62, z = 6142, yaw = -0x4000 },
            unwantedBhvs = { id_bhvWarpPipe }
        }
    }
end

-- Lavabounce Challenge, ported to Flood by Jzzay
local function flood_load_lavabounce_challenge_levels()
    game = GAME_LAVABOUNCE_CHALLENGE
    romhackInfo = "Lavabounce Challenge"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -10,  y = 9313,  z = 4, yaw =  0x8000 },
            speed = 2.0,
            author = "Redmat527",
            type = FLOOD_WATER,
            startPos = { x = 1054, y = 480, z = -841, yaw = -0x6000 },
            unwantedBhvs = { id_bhvWarpPipe },
        }
    }
end

-- Slope Challenge, ported to Flood by Jzzay
local function flood_load_slope_challenge_levels()
    game = GAME_SLOPE_CHALLENGE
    romhackInfo = "Slope Challenge"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -1, y = 1500, z = -1005, yaw = 0x0000}
        }
    }

    gLevels = {
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -10,  y = 5313,  z = 4, yaw =  0x4000 },
            speed = 1.5,
            author = "Redmat527",
            type = FLOOD_CLOUDS,
            startPos = { x = 1054, y = 776, z = -841, yaw = -0x5500, airborne = false },
            unwantedBhvs = { id_bhvWarpPipe },
        }
    }
end

-- Wallkick Challenge 2, ported to Flood by Jzzay
local function flood_load_wallkick_challenge_2_levels()
    game = GAME_WALLKICK_CHALLENGE_2
    romhackInfo = "Wallkick Challenge 2"
	gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -4858, y = 1500, z = 9, yaw = 0x4000}
        }
    }

    gLevels = {
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -10,  y = 9313,  z = 4, yaw =  0x0000 },
            speed = 2.0,
            author = "Redmat527",
            type = FLOOD_CLOUDS,
            startPos = { x = 1054, y = 776, z = -841, yaw = -0x5500, airborne = false },
            unwantedBhvs = { id_bhvWarpPipe },
        }
    }
end

-- Creepy Canyon, ported to Flood by Jzzay
local function flood_load_creepy_canyon_levels()
    game = GAME_CREEPY_CANYON
    romhackInfo = "Creepy Canyon"
    gLobbies = {
        [1] = {
            level = LEVEL_BBH,
            area = 1,
            spawn = {x = -1739, y = 261, z = 1290, yaw = 0x4000}
        }
    }

    gLevels = {
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 2865,  y = 2033,  z = 9178, yaw =  0x6500 },
            speed = 2.65,
            author = "djoslin0",
            type = FLOOD_WATER,
            startPos = { x = 10394, y = 859, z = -739, yaw = 0x0000 },
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 8053,  y = 2772,  z = -3757, yaw =  -0x2000 },
            speed = 3.5,
            author = "djoslin0",
            type = FLOOD_WATER,
            startPos = { x = -8756, y = -980, z = 9478, yaw = 0x4000 },
            overrideName = "Creepy Catacombs",
        }
    }
end

-- Super Bell Thrill, ported to Flood by Jzzay
local function flood_load_super_bell_thrill_levels()
    game = GAME_SUPER_BELL_THRILL
    romhackInfo = "Super Bell Thrill"
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 7, y = 100, z = -154, yaw = 0x8000}
        },
        [2] = {
            level = LEVEL_BOB,
            area = 1,
            spawn = {x = -4051, y = 66, z = -10999, yaw = 0x1750}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 9820,  y = 13629,  z = 990, yaw =  -0x4000 },
            speed = 2.35,
            author = "Flipflop Bell",
            type = FLOOD_WATER,
            startPos = { x = 20488, y = 66, z = 4342, yaw = -0x5500 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -7791,  y = 5596,  z = 9336, yaw =  0x5350 },
            speed = 2.7,
            author = "Flipflop Bell",
            type = FLOOD_WATER,
            startPos = { x = 17762, y = 66, z = -11248, yaw = -0x2500 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Super Bell Run",
        }
    }
end

-- Momentum Testing, ported to Flood by Jzzay
local function flood_load_momentum_testing_levels()
    game = GAME_MOMENTUM_TESTING
    romhackInfo = "Momentum Testing"
    gLobbies = {
        [1] = {
            level = LEVEL_JRB,
            area = 1,
            spawn = {x = 2, y = 1082, z = 3080, yaw = 0x0000}
        },
        [2] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 8176, y = 1614, z = -148, yaw = -0x4000}
        }
    }

    gLevels = {
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -5,  y = 3300,  z = 5556, yaw =  0x0000 },
            speed = 2.0,
            author = "IwerSonsch & PhantoFantasma",
            type = FLOOD_WATER,
            startPos = { x = 0, y = 0, z = 0, yaw = 0x0000 },
            floodScale = 2.5,
            overrideName = "Momentum Test",
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 8625,  y = 3144,  z = -142, yaw =  0x4000 },
            speed = 2.0,
            author = "IwerSonsch & PhantoFantasma",
            type = FLOOD_LAVA,
            startPos = { x = 78, y = 0, z = -155, yaw = 0x4000 },
            floodScale = 2.5,
            overrideName = "Momentum Finale",
        }
    }
end

-- Tomatobird8's Single Star Speedruns, ported to Flood by Jzzay
local function flood_load_tomatobird8_single_star_speedruns_levels()
    game = GAME_TOMATOBIRD8_SINGLE_STAR_SPEEDRUNS
    romhackInfo = "Tomatobird8's Single Star Speedruns"
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 959, y = 0, z = 10, yaw = -0x4000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -2893,  y = 1257,  z = 4526, yaw =  0x4200 },
            speed = 3.6,
            author = "Tomatobird8",
            type = FLOOD_DESERT,
            startPos = { x = 5078, y = 819, z = 123, yaw = -0x3500 },
            floodScale = 1.25,
            unwantedBhvs = { id_bhvBreakableBox },
            overrideName = "Sand Climb Speedrun",
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -3124,  y = 1329,  z = -4533, yaw =  0x1750 },
            speed = 4.0,
            author = "Tomatobird8",
            type = FLOOD_SAND,
            startPos = { x = 3008, y = 696, z = 914, yaw = -0x5800 },
            floodScale = 1.25,  
            unwantedBhvs = { id_bhvExclamationBox },   
            overrideName = "Hill Hop Speedrun",         
        },
        {
            name = "bob3",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 7528,  y = 1464,  z = -4, yaw =  -0x4000 },
            speed = 3.85,
            author = "Tomatobird8",
            type = FLOOD_DESERT,
            startPos = { x = -3995, y = 555, z = 3132, yaw = 0x5001 },
            floodScale = 1.25,
            unwantedBhvs = { id_bhvExclamationBox },
            overrideName = "Mount Escalation Speedrun",
        }
    }
end

-- Lava Lava Lava Lava, ported to Flood by Jzzay
local function flood_load_lava_lava_lava_lava_levels()
    game = GAME_LAVA_LAVA_LAVA_LAVA
    romhackInfo = "Lava Lava Lava Lava"
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -633, y = -699, z = -1044, yaw = 0x8000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 0,  y = 2030,  z = 12437, yaw =  0x8000 },
            speed = 3.9,
            author = "Tomatobird8",
            type = FLOOD_MOLTEN,
            startPos = { x = 2, y = 235, z = -48, yaw = 0x0000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Bouncing Lava Letters",
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -10536,  y = 3335,  z = -2589, yaw =  -0x0500 },
            speed = 2.05,
            author = "Tomatobird8",
            type = FLOOD_MOLTEN,
            startPos = { x = 67, y = 235, z = -2, yaw = -0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Wallkicking Lava Ascend",
        },
        {
            name = "bob3",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 13750,  y = 7930,  z = 4628, yaw =  0x9100 },
            speed = 3.8,
            author = "Tomatobird8",
            type = FLOOD_POISON,
            startPos = { x = 8301, y = 2590, z = -264, yaw = 0x2000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Poisonous Slope Climb",
        },
        {
            name = "bob4",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -2741,  y = 6612,  z = -5442, yaw =  -0x5500 },
            speed = 1.7,
            author = "Tomatobird8",
            type = FLOOD_POISON,
            startPos = { x = -7188, y = 4475, z = -8572, yaw = -0x8000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },
            overrideName = "Floating Poisonous Structure",
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 3995,  y = 1143,  z = -497, yaw =  -0x4000 },
            speed = 1.85,
            author = "Tomatobird8",
            type = FLOOD_SAND,
            startPos = { x = -5346, y = -252, z = 5262, yaw = 0x5500 },
            floodScale = 2,
        }
    }
end

-- Super Mario 8MB, ported to Flood by Jzzay
local function flood_load_super_mario_8mb_levels()
    game = GAME_SUPER_MARIO_8MB
    romhackInfo = "Super Mario 8MB"
	romhackLogo = get_texture_info("logo_sm8mb")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 3423, y = 152, z = 5266, yaw = 0x8000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -5645,  y = 831,  z = -5003, yaw =  0x0000 },
            speed = 1.15,
            author = "PablosCorner",
            type = FLOOD_WATER,
            startPos = { x = 5979, y = 664, z = 5981, yaw = -0x6000 },
            floodScale = 3,
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 2,
            flagPos = { x = 414,  y = 5080,  z = -4335, yaw =  0x0000 },
            speed = 5.5,
            author = "PablosCorner",
            type = FLOOD_WATER,
            startPos = { x = -335, y = 0, z = -125, yaw = 0x0000 },
            floodScale = 3,
            overrideName = "Mansion's Clock Tower",
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 7038,  y = 13380,  z = 5326, yaw =  0x9650 },
            speed = 1.2,
            author = "PablosCorner",
            type = FLOOD_RAINBOW,
            startPos = { x = 1631, y = 13407, z = -10007, yaw = 0x0000 },
            floodScale = 3,
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 2866,  y = 15707,  z = 13111, yaw =  -0x4000 },
            speed = 1.7,
            author = "PablosCorner",
            type = FLOOD_SUNSET,
            startPos = { x = 3061, y = 3647, z = 9761, yaw = -0x3000 },
            floodScale = 3,
            unwantedBhvs = { id_bhv1Up },
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -202,  y = 1401,  z = -1970, yaw =  -0x4000 },
            speed = 2.85,
            author = "PablosCorner",
            type = FLOOD_WATER,
            floodScale = 3,
             
        }
    }
end

-- Bowser's Beach, ported to Flood by Jzzay
local function flood_load_bowsers_beach_levels()
    game = GAME_BOWSERS_BEACH
    romhackInfo = "Super Mario 64: Bowser's Beach"
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -15, y = 0, z = 1006, yaw = 0x8000}
        },
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 2,
            spawn = {x = 15, y = 0, z = -100, yaw = 0x8000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -1494,  y = 972,  z = -1558, yaw =  0x5000 },
            speed = 5.65,
            author = "Halo",
            type = FLOOD_SAND,
            startPos = { x = 5041, y = 98, z = -4991, yaw = -0x3000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "bob2",
            level = LEVEL_BOB,
            area = 2,
            flagPos = { x = -67,  y = 102,  z = -4829, yaw =  0x0000 },
            speed = 4.95,
            author = "Halo",
            type = FLOOD_WATER,
            startPos = { x = 129, y = 0, z = 1038, yaw = 0x8000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Down in the Depths",
        },
        {
            name = "bob3",
            level = LEVEL_BOB,
            area = 3,
            flagPos = { x = -8862,  y = 0,  z = 8760, yaw =  0x4000 },
            speed = 2.0,
            author = "Halo",
            type = FLOOD_CLOUDS,
            startPos = { x = 371, y = 0, z = -189, yaw = -6905 },
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Towers in the Sky",
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -6052,  y = 1671,  z = 361, yaw =  0x9650 },
            speed = 4.15,
            author = "Halo",
            type = FLOOD_SNOW,
            startPos = { x = 3519, y = -423, z = 19, yaw = -0x4000 },
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe },
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 2,
            flagPos = { x = 77,  y = 0,  z = -987, yaw =  0x8000 },
            speed = 4.8,
            author = "Halo",
            type = FLOOD_FROSTBITE,
            startPos = { x = 93, y = 0, z = -6349, yaw = 0x0000 },
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Inside the Mountain",
        },
        {
            name = "wf3",
            level = LEVEL_WF,
            area = 3,
            flagPos = { x = 6581,  y = 735,  z = -4236, yaw =  -0x4000 },
            speed = 4.15,
            author = "Halo",
            type = FLOOD_WATER,
            startPos = { x = 84, y = 0, z = 720, yaw = 0x8000 },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe },
            overrideName = "Blast to the Past",
        }
    }
end

-- Cursed Winter Forest, ported to Flood by Jzzay
local function flood_load_cursed_winter_forest_levels()
    game = GAME_CURSED_WINTER_FOREST
    romhackInfo = "Cursed Winter Forest"
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 13, y = 0, z = -924, yaw = -0x5250}
        }
    }

    gLevels = {
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -8202,  y = 578,  z = 14224, yaw =  0x2500 },
            speed = 2.05,
            author = "Morningstorm SM64",
            type = FLOOD_FROSTBITE,
            startPos = { x = -90, y = 7129, z = -2349, yaw = 0x0500, airborne = false },
            floodScale = 2.25,
            unwantedBhvs = { id_bhvFlame, id_bhvExclamationBox, id_bhvWarpPipe },
            overrideName = "Hotel Boo's Curse",
        },
        {
            name = "sa2",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 3102,  y = 4564,  z = -22325, yaw =  0x5500 },
            speed = 3.6,
            author = "Morningstorm SM64",
            type = FLOOD_FROSTBITE,
            startPos = { x = -90, y = 7129, z = -2349, yaw = 0x7000, airborne = false },
            floodScale = 2.25,
            unwantedBhvs = { id_bhvFlame, id_bhvExclamationBox, id_bhvWarpPipe },
            overrideName = "Cursed Rapid Climb",
        },
        {
            name = "sa3",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -14395,  y = 698,  z = -4264, yaw =  0x8000 },
            speed = 2.5,
            author = "Morningstorm SM64",
            type = FLOOD_FROSTBITE,
            startPos = { x = -90, y = 7129, z = -2349, yaw = -0x7500, airborne = false },
            floodScale = 2.25,
            unwantedBhvs = { id_bhvFlame, id_bhvExclamationBox, id_bhvWarpPipe },
            overrideName = "Giant Tree Trunk Curse",
        },
        {
            name = "sa4",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 14941,  y = 1397,  z = 557, yaw =  0x8000 },
            speed = 1.3,
            author = "Morningstorm SM64",
            type = FLOOD_FROSTBITE,
            startPos = { x = -90, y = 7129, z = -2349, yaw = 0x3000, airborne = false },
            floodScale = 2.25,
            unwantedBhvs = { id_bhvFlame, id_bhvExclamationBox, id_bhvWarpPipe },
            overrideName = "Winter Home's Curse",
        },
        {
            name = "sa5",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 11411,  y = 19546,  z = 8007, yaw =  0x8000 },
            speed = 1.3,
            author = "Morningstorm SM64",
            type = FLOOD_RAINBOW,
            startPos = { x = -90, y = 7129, z = -2349, yaw = 0x2000, airborne = false },
            floodScale = 2.25,
            unwantedBhvs = { id_bhvFlame, id_bhvExclamationBox, id_bhvWarpPipe },
        }
    }
end

-- Diorama Of Extreme Shenanigans 64, ported to Flood by ★~¡TOÑO!~★
local function flood_load_diorama_of_extreme_shenanigans_64_levels()
    game = GAME_DIORAMA_OF_EXTREME_SHENANIGANS_64
	romhackInfo = "Diorama Of Extreme Shenanigans 64"
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -249, y = 50, z = 1015, yaw = 0x8000}
        }
    }

    gLevels = {
        {	
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -8430, y = 2077, z = 12675, yaw = 0x4000 },
            speed = 1.5,
            author = "GmdDoesDMG",
            type = FLOOD_MUD,
            startPos = { x = 140, y = -969, z = 5710, yaw = 0x0000, airborne = true },		
	    overrideName = "Daredevils Of Empty Space",
            unwantedBhvs = { id_bhvExclamationBox },			
            floodScale = 2.5		
        },
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -2885, y = 2535, z = -9465, yaw = 0x0000 },
            flagBase = true,
            speed = 4.5,
            author = "GmdDoesDMG",
            type = FLOOD_MUD,
            startPos = { x = 180, y = -969, z = -2335, yaw = 0x8000, airborne = true },	
	    overrideName = "Devouring Ovals, Even Salary",			
            floodScale = 2.5			
        },
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 5355, y = 500, z = 6155, yaw = 0x4000 },
            speed = 2.25,
            author = "GmdDoesDMG",
            type = FLOOD_MUD,
            startPos = { x = 4225, y = -2525, z = 1650, yaw = 0x4000, airborne = true },	
	    overrideName = "Driving Over Equilateral Secrets",		
            unwantedBhvs = { id_bhvExclamationBox },					
            floodScale = 2.5			
        },
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -5745, y = 3705, z = 1640, yaw = 0x4000 },
            flagBase = true,
            speed = 5.0,
            author = "GmdDoesDMG",
            type = FLOOD_MUD,
            startPos = { x = -4265, y = -2987, z = 1640, yaw = 0x4000, airborne = true },
	    overrideName = "Despair Wallkick Challenge",	
            unwantedBhvs = { id_bhvExclamationBox },			
            floodScale = 2.5			
        },
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -15245, y = 40, z = 6990, yaw = 0x8000 },
            speed = 1.5,
            author = "GmdDoesDMG",
            type = FLOOD_MUD,
            startPos = { x = -7910, y = -870, z = 1630, yaw = -0x4000, airborne = true },	
	    overrideName = "Dumb Ol' Exasperating Slopes",	
            unwantedBhvs = { id_bhvExclamationBox },			
            floodScale = 2.5			
        }
    }
end

-- Senseless Delirium, ported to Flood by ★~¡TOÑO!~★
local function flood_load_senseless_delirium_levels()
    game = GAME_SENSELESS_DELIRIUM
    romhackInfo = "Super Mario Senseless Delirium"
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x8000}
        },
        [2] = {
            level = LEVEL_PSS,
            area = 1,
            spawn = {x = 1262, y = 0, z = -4490, yaw = 0x0000}
        },
        [3] = {
            level = LEVEL_WMOTR,
            area = 1,
            spawn = {x = 1360, y = 0, z = -4652, yaw = 0x0000}			
        }
    }

    gLevels = {
        {	
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 575, y = 11000, z = 6550, yaw = 0x8000 },
            speed = 2.0,
            author = "Redmat527",
            type = FLOOD_DARKNESS,
	    floodScale = 2,
	    floodHeight = 3000
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -4690, y = 6510, z = 6000, yaw = 0x4000 },
            speed = 2.0,
            author = "Redmat527",
            type = FLOOD_LAVA,				
            floodScale = 2,
            floodHeight = -1500			
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 4050, y = 9490, z = -3510, yaw = -0x2000 },
            flagBase = true,
            speed = 3.0,
            author = "Redmat527",
            type = FLOOD_CLOUDS,	
   	    floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },					
            capTimer = 0		
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 4,
            flagPos = { x = -3550, y = 5385, z = 3740, yaw = 0x8000 },
            flagBase = true,
            speed = 1.75,
            author = "Redmat527",
            type = FLOOD_CLOUDS,	
	    overrideName = "Slanted Slope Parkour",
            unwantedBhvs = { id_bhvWarpPipe },	
            floodHeight = 1500,			
            capTimer = 0				
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 5210, y = 5250, z = -1230, yaw = -0x4000 },
            speed = 2.0,
            author = "Redmat527",
            type = FLOOD_MOLTEN,
            unwantedBhvs = { id_bhvFadingWarp, id_bhvExclamationBox },		
            floodHeight = -1500,			
	    floodScale = 2.5
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -14410, y = 4750, z = 11095, yaw = 0x8000 },
            speed = 2.0,
            author = "Redmat527",
            type = FLOOD_MOLTEN,	
            startPos = { x = -12240, y = 225, z = 9785, yaw = 0x0000, airborne = true },
	    overrideName = "Victorious Metal Mario",
            unwantedBhvs = { id_bhvFadingWarp },			
            floodScale = 2.5	
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 205, y = 6500, z = 2200, yaw = -0x6000 },
            speed = 2.25,
            author = "Redmat527",
            type = FLOOD_CLOUDS,				
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 3190, y = 300, z = 3200, yaw = 0x8000 },
            speed = 1.25,
            author = "Redmat527",
            type = FLOOD_CLOUDS,		
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -8645, y = 11250, z = -4460, yaw = 5520 },
            speed = 2.0,
            author = "Redmat527",
            type = FLOOD_WATER,
            floodScale = 2,			
	    floodHeight = 2750,
            unwantedBhvs = { id_bhvBreakableBox }			
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -4760, y = 2930, z = 2025, yaw = 0x8000 },
            speed = 1.5,
            author = "Redmat527",
            type = FLOOD_SNOW,				
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -1720, y = 5945, z = -2875, yaw = -0x4000 },
            speed = 3.5,
            author = "Redmat527",
            type = FLOOD_WATER,		
	     
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe }				
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -1055, y = 4970, z = -5, yaw = -0x4000 },
            speed = 1.5,
            author = "Redmat527",
            type = FLOOD_WATER,			
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x = -30, y = 7440, z = -3855, yaw = 0x0000 },
            speed = 1.75,
            author = "Redmat527",
            type = FLOOD_WATER,		
	    overrideName = "Under Construction Station"	
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = 3020, y = 4820, z = 3560, yaw = -0x4000 },
            speed = 1.0,
            author = "Redmat527",
            type = FLOOD_SAND,		
            startPos = { x = -710, y = 2250, z = 3365, yaw = 0x0000, airborne = true },			
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 2,
            flagPos = { x = -2300, y = 1315, z = -3190, yaw = -0x4000 },
            speed = 2.0,
            author = "Redmat527",
            type = FLOOD_DARKNESS,	
	    floodScale = 2,
	    floodHeight = -2675,
            capTimer = 300,
            powerUp = "vanish"			
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 2350, y = 2180, z = 3715, yaw = -0x4000 },
            speed = 4.5,
            author = "Redmat527",
            type = FLOOD_DARKNESS,	
            startPos = { x = 0, y = 0, z = 0, yaw = 0x8000, airborne = false },	
            unwantedBhvs = { id_bhvWarpPipe },			
	    overrideName = "Senseless Overworld",
            floodScale = 2			
        }
    }
end

-- SM74 Ten Years After, ported to Flood by ~¡TONO!~
local function flood_load_super_mario_74_ten_years_after_levels()
    game = GAME_SUPER_MARIO_74_TEN_YEARS_AFTER
	romhackInfo = "Super Mario 74 - Ten Years After"
    romhackLogo = get_texture_info("logo_sm74tya")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = -5100, y = -157, z = 6235, yaw = 0x8000},
			 			
        },
        [2] = {
            level = LEVEL_WMOTR,
            area = 1,
            spawn = {x = 240, y = -805, z = 3970, yaw = 0x8000},
			 
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -130, y = -1410, z = -3950, yaw = 0x8000}
        }
    }

    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = -3065, y =  2680, z = -2660, yaw =  0x0000 },
			flagBase = true,
            speed = 3.5,
            author = "LinCrash",
            type = FLOOD_LAVA,
			 
		},
        {		
            name = "bob2",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 1240, y = 2755, z = 1145, yaw =  0x0000 },
			flagBase = true,
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_LAVA,
            startPos = { x = -1600, y = -186, z = 3760, yaw = -0x4000, airborne = false },		
            powerUp = "metal",
            capTimer = 300,			
			 	
			overrideName = "Dice Domain (Tower)"
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -4030, y =  5800, z =  1330, yaw =  0x4000 },
            speed = 4.0,
            author = "LinCrash",
            type = FLOOD_WATER,
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = -2995, y =  3690, z = -2405, yaw =  0x4000 },
			flagBase = true,
            speed = 3.0,
            author = "LinCrash",
            type = FLOOD_WATER,		
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 5040, y = 11135, z = -1000, yaw =  0x0000 },
			flagBase = true,
            speed = 3.0,
            author = "LinCrash",
            type = FLOOD_WATER,		
            startPos = { x = 2650, y =  -210, z =    320, yaw = -0x4000, airborne = false },			
            launchpads = {
                { x = -960, y =  3677, z = 4920, yaw = 32701, vel = 95, forwardVel = 0 },
                { x = -960, y =  3677, z = 5655, yaw = 32701, vel = 95, forwardVel = 0 },				
                { x = 3515, y = 10320, z = 1490, yaw = 32701, vel = 100, forwardVel = 0 },								
            },			
            overrideSlide = true,	
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = -3690, y =  3445, z = -2300, yaw =  0x0000 },
			flagBase = true,
            speed = 2.5,
            author = "LinCrash",
            type = FLOOD_CLOUDS,		
            unwantedBhvs = { id_bhvWarpPipe },		
        },
        {
            name = "bitdw2",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 7310, y = -1535, z = 7360, yaw = -0x6000 },
            speed = 5.0,
            author = "LinCrash",
            type = FLOOD_CLOUDS,		
            startPos = { x = 7310, y = -4285, z = 7300, yaw = -0x6000, airborne = false },				
            unwantedBhvs = { id_bhvWarpPipe },	
            overrideName = "Bowser's Park Party (Timed Boxes)",				
        },
        {
            name = "bowser-1",
            level = LEVEL_BOWSER_1,
            area = 1,
            flagPos = { x = 3690, y =  3445, z = -2300, yaw =  0x0000 },
			flagBase = true,
            speed = 1.5,
            author = "LinCrash",
            type = FLOOD_MOLTEN,	
            overrideName = "Bowser's Lava Party",	
            powerUp = "metal",
            capTimer = 900,			
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 4320, y = 320, z = -205, yaw = 0x0000 },
            speed = 2.75,
            author = "LinCrash",
            type = FLOOD_WASTE,			
            startPos = { x = -3150, y = -1375, z =   5170, yaw = 0x4000, airborne = false },	
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -3555, y = -295, z = 1590, yaw = -0x4000 },
            speed = 1.75,
            author = "LinCrash",
            type = FLOOD_MOLTEN,			
            startPos = { x = -3095, y = -3120, z =  1910, yaw = -0x4000, airborne = false },					
			overrideName = "Bogey Bayou (Furnace)",
        },
        {
            name = "ccm3",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -2460, y = 1200, z = -2465, yaw = 0x8000 },
            speed = 1.0,
            author = "LinCrash",
            type = FLOOD_WASTE,			
            startPos = { x = 5255, y = -2260, z = 2945, yaw = -0x3500, airborne = false },					
			overrideName = "Bogey Bayou (Sewers)",	
            floodHeight = -3750,			
            unwantedBhvs = { id_bhvExclamationBox },			
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -80, y =  5020, z =  6010, yaw =  0x8000 },
			flagBase = true,
            speed = 3.5,
            author = "LinCrash",
            type = FLOOD_LAVA,			
            startPos = { x = 25, y =  -950, z =   6210, yaw = 0x8000, airborne = false },	
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = -460, y =  6590, z = -1435, yaw =  0x0000 },
			flagBase = true,
            speed = 2.5,
            author = "LinCrash",
            type = FLOOD_DARKNESS,			
            startPos = { x = -5325, y =  1920, z =  -1240, yaw = 0x4000, airborne = false },	
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 4355, y =  8350, z =   395, yaw = -0x6000 },
            speed = 2.5,
            author = "LinCrash",
            type = FLOOD_SNOW,	
			floodHeight = -900,
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 1060, y = 12725, z =   570, yaw = -0x4000 },
            speed = 2.0,
            author = "LinCrash",
            type = FLOOD_WATER,				
            startPos = { x = 1800, y = -1800, z =  -2735, yaw = 0x8000, airborne = false },	
			floodScale = 2,
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 4480, y =  3810, z = -4500, yaw =  0x0000 },
            speed = 2.0,
            author = "LinCrash",
            type = FLOOD_SNOW,	
             	
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 3680, y =  5545, z =  4730, yaw =  0x8000 },
            speed = 2.5,
            author = "LinCrash",
            type = FLOOD_WATER,		
            startPos = { x = 2895, y =   895, z =   5555, yaw = 0x8000, airborne = false },		
        },
        {
            name = "ddd2",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -3930, y = 8860, z = 3105, yaw =  0x8000 },
            speed = 2.5,
            author = "LinCrash",
            type = FLOOD_WATER,		
            startPos = { x = -3470, y = 3135, z = 1740, yaw = 0x0000, airborne = false },			
            overrideName = "Nature Nocturne (Windmill)",
        },
        {
            name = "ddd3",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 4920, y = -86, z = -4625, yaw = -0x4000 },
            speed = 1.0,
            author = "LinCrash",
            type = FLOOD_DARKNESS,		
            startPos = { x = 2165, y = 800, z = -840, yaw = -0x5000, airborne = false },			
            overrideName = "Nature Nocturne (Underground)",			
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -4950, y =  1540, z = -4500, yaw =  0x3000 },
            speed = 1.5,
            author = "LinCrash",
            type = FLOOD_WATER,		
            startPos = { x = 2595, y =  1340, z =   2225, yaw = 0x4000, airborne = false },
			 
        },
        {
            name = "bowser-2",
            level = LEVEL_BOWSER_2,
            area = 1,
            flagPos = { x = 4430, y =  1780, z =  6280, yaw =  0x8000 },
			flagBase = true,
            speed = 1.5,
            author = "LinCrash",
            type = FLOOD_SAND,	
			overrideName = "Bowser's Quicksand Tidal",
            startPos = { x = 2895, y = 1580, z = -2550, yaw = 0x4000, airborne = false },			
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -260, y =  5135, z = -2440, yaw =  0x8000 },
            speed = 2.0,
            author = "LinCrash",
            type = FLOOD_SAND,	
			floodHeight = -2750,
            startPos = { x = -4690, y = -460, z = 220, yaw = 0x0000, airborne = false },				
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -5260, y =  3265, z =  6175, yaw =  0x4000 },
            speed = 2.5,
            author = "LinCrash",
            type = FLOOD_POISON,	
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 2,
            flagPos = { x = -70, y = 6295, z = 7765, yaw =  0x8000 },
            speed = 2.0,
            author = "LinCrash",
            type = FLOOD_POISON,				
            startPos = { x = -100, y =   450, z =   4405, yaw = 0x8000, airborne = false },	
			floodHeight = -2750,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvMrI },
            act = 1,			
        },
        {
            name = "ttm2",
            level = LEVEL_TTM,
            area = 3,
            flagPos = { x = 60, y = 8060, z = -4375, yaw =  0x0000 },
            speed = 2.0,
            author = "LinCrash",
            type = FLOOD_POISON,				
            unwantedBhvs = { id_bhvWarpPipe},
			overrideName = "Cliff Of Time (Collapsed)",		
            startPos = { x = 0, y = -35, z =  1380, yaw = 0x8000, airborne = false },				
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -6270, y =  4825, z =  -810, yaw =  0x4000 },
            speed = 1.5,
            author = "LinCrash",
            type = FLOOD_WATER,				
            startPos = { x = -5000, y =   520, z =  -2765, yaw = 0x0000, airborne = false },	
			floodScale = 2,
             		
            unwantedBhvs = { id_bhvSpindrift },			
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 1905, y =  9320, z =   615, yaw =  0x8000 },
			flagBase = true,
            speed = 2.5,
            author = "LinCrash",
            type = FLOOD_CLOUDS,
			floodScale = 2,
			floodHeight = -8500,
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -100, y = 9255, z = -5125, yaw =  0x0000},
			flagBase = true,
            speed = 2.0,
            author = "LinCrash",
            type = FLOOD_DARKNESS,	
			floodScale = 2,			
			floodHeight = -8000,			
            launchpads = {
                { x = -185, y = 7900, z = 2575, yaw = 32701, vel = 100, forwardVel = 0 },
            },				
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -5760, y =  5240, z =  4685, yaw =  0x4000 },
            speed = 1.25,
            author = "LinCrash",
            type = FLOOD_DARKNESS,	
            unwantedBhvs = { id_bhvWarpPipe },		
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x = -45, y = 10010, z = -1795, yaw = 0x8000 },
			flagBase = true,
            speed = 2.0,
            author = "LinCrash",
            type = FLOOD_RAINBOW,		
			floodScale = 2,
            startPos = { x = -3715, y = -2210, z = -6280, yaw = 0x0000, airborne = false },	
            unwantedBhvs = { id_bhvWarpPipe },		
            launchpads = {
                { x = -970, y = 3660, z = -7250, yaw = 32701, vel = 175, forwardVel = 0 },
                { x = -30, y = 7505, z = -3090, yaw = 32701, vel = 150, forwardVel = 0 },				
            },			
        },
        {
            name = "ending",
            level = LEVEL_ENDING,
            area = 1,
            flagPos = { x = -10, y =  6165, z =  1865, yaw =  0x4000 },
            speed = 2.5,
            author = "LinCrash",
            type = FLOOD_WATER,		
            startPos = { x = 105, y =  3340, z =   1965, yaw = 0x8000, airborne = false },	
            unwantedBhvs = { id_bhvWarpPipe },				
            overrideName = "Champion's Challenge",			
        },
        {
            name = "ending2",
            level = LEVEL_ENDING,
            area = 2,
            flagPos = { x = 8535, y = 1780, z = -3945, yaw = -0x7000 },
            speed = 1.5,
            author = "LinCrash",
            type = FLOOD_LAVA,		
            startPos = { x = -11370, y = -525, z = -5605, yaw = 0x4000, airborne = true },	
			floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },				
            launchpads = {
                { x = -6470, y = -800, z = -460, yaw = 0x4000, vel = 160, forwardVel = 0 },
            },			
        },
        {
            name = "ending3",
            level = LEVEL_ENDING,
            area = 3,
            flagPos = { x = 8835, y = 4120, z = -5450, yaw =  0x8000 },
            speed = 1.0,
            author = "LinCrash",
            type = FLOOD_CLOUDS,		
            startPos = { x =  6900, y =  1815, z =   6990, yaw = 0x0000, airborne = false },	
			floodScale = 2,
			floodHeight = 930,
            overrideName = "Grandmaster's Goal 2",			
            unwantedBhvs = { id_bhvWarpPipe },						
        },
        {
            name = "ending4",
            level = LEVEL_ENDING,
            area = 2,
            flagPos = { x = -4030, y =  7300, z =  7245, yaw =  0x4000 },
            speed = 1.25,
            author = "LinCrash",
            type = FLOOD_LAVA,		
            floodScale = 2,
            startPos = { x = -1345, y =  -330, z =   8330, yaw = 0x4000, airborne = false },	
            overrideName = "Grandmaster's Goal 3",				
            unwantedBhvs = { id_bhvWarpPipe },				
        },
        {
            name = "ending5",
            level = LEVEL_ENDING,
            area = 3,
            flagPos = { x = -6715, y = 13290, z = 13400, yaw =  0x0000 },
            speed = 1.5,
            author = "LinCrash",
            type = FLOOD_CLOUDS,		
			floodScale = 2,
            startPos = { x = -2585, y =  3365, z = -12030, yaw = 0x4000, airborne = false },
            overrideName = "Grandmaster's Goal 4",				
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {
            name = "ending6",
            level = LEVEL_ENDING,
            area = 6,
            flagPos = { x = -10, y =  2710, z =  2710, yaw =  0x0000 },
            speed = 2.0,
            author = "LinCrash",
            type = FLOOD_WATER,		
            startPos = { x = -5650, y =   780, z =  -5475, yaw = 0x4000, airborne = false },	
			overrideName = "Triarc-Bridge",
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = -3395, y =  2580, z =  7055, yaw =  0x8000 },
            speed = 2.0,
            author = "LinCrash",
            type = FLOOD_WATER,		
            startPos = { x = 6290, y = -50, z = -5065, yaw = -0x4000, airborne = false },	
            overrideName = "Old Valley",		
			 
            unwantedBhvs = { id_bhvWarpPipe },				
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 270, y = 3050, z = 2030, yaw = -0x4000 },
            speed = 3.0,
            author = "LinCrash",
            type = FLOOD_WATER,		
            startPos = { x = -2410, y = -645, z = 5825, yaw = -0x4000, airborne = false },				
			 
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {
            name = "wmotr2",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -6120, y = 3050, z = -6285, yaw = 0x0000 },
            speed = 1.5,
            author = "LinCrash",
            type = FLOOD_WATER,		
            startPos = { x = -6080, y = 750, z = -4845, yaw = 0x0000, airborne = false },				
			 
			overrideName = "Training Grounds 2",
            unwantedBhvs = { id_bhvWarpPipe },					
        },
        {
            name = "castle",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = -5630, y =  1750, z = -6905, yaw =  0x2000 },
            speed = 2.0,
            author = "LinCrash",
            type = FLOOD_LAVA,	
            overrideName = "Master Temple",	
            unwantedBhvs = { id_bhvWarpPipe },				
        }
    }
end

-- Project Reimagined, ported to Flood by ~!TONO!~
local function flood_load_project_reimagined_levels()
    game = GAME_PROJECT_REIMAGINED
    romhackInfo = "Project Reimagined"
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -4270, y = 0, z = 5460, yaw = -0x4000}
		},	
        [2] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 2,
            spawn = {x = -3665, y = -1520, z = 4980, yaw = 0x8000},		
            unwantedBhvs = { id_bhvWarpPipe },		
			 
		},	
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -1030, y = 0, z = 1830, yaw = 0x4000}		
		},	
        [4] = {
            level = LEVEL_CASTLE,
            area = 3,
            spawn = {x = -7440, y = 0, z = -6370, yaw = 0x8000}	
		},	
        [5] = {
            level = LEVEL_CASTLE,
            area = 4,
            spawn = {x = 20, y = 1595, z = -7140, yaw = 0x8000}		
		},	
        [6] = {
            level = LEVEL_CASTLE,
            area = 5,
            spawn = {x = 1730, y = -1945, z = -1675, yaw = 0x8000}					
        }
    }

    gLevels = {
        {	
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 10565, y = 3980, z = -10830, yaw = 0x8000 },
            speed = 3.0,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,
            startPos = { x = 2430, y =   700, z = -1970, yaw =  0x4000, airborne = true },	
            floodScale = 2,			
            unwantedBhvs = { id_bhvExclamationBox },			
        },
        {						
            name = "bob2",
            level = LEVEL_BOB,
            area = 2,
            flagPos = { x = 8415, y =  7015, z = -12130, yaw =  0x2000 },
			flagBase = true,
            speed = 3.0,
            author = "Mr.Needlemouse",
            type = FLOOD_MUD,		
			floodScale = 2,
			overrideName = "Bob-Omb Fortress",
        },
        {						
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -9195, y =  5305, z =  -4040, yaw =  0x0000 },
			flagBase = true,
            speed = 3.0,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,		
            startPos = { x = -10995, y =  2470, z =   -920, yaw =  0x0000, airborne = true },	
            floodScale = 1.5,			
        },
        {						
            name = "wf2",
            level = LEVEL_WF,
            area = 2,
            flagPos = { x = 850, y =  4515, z =   -850, yaw =  0x4000 },
			flagBase = true,
            speed = 2.5,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,		
            startPos = { x = 1160, y =    80, z =  -2770, yaw =  0x4000, airborne = true },		
			floodScale = 2,
			overrideName = "Whomps' Prison",
        },
        {						
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 400, y =  1495, z =    400, yaw = -0x6000 },
            speed = 3.5,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,		
            startPos = { x = 2670, y =   560, z =   2650, yaw = -0x6000, airborne = true },	
			overrideName = "Battle Fort",
        },
        {						
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 5930, y = 11210, z =  -8170, yaw = -0x4000 },
			flagBase = true,
            speed = 2.75,
            author = "Mr.Needlemouse",
            type = FLOOD_POISON,
			floodHeight = 3500,
			overrideName = "King's Whomps' Lair",
        },
        {						
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 3400, y =  1790, z =  -3140, yaw = -0x2000 },
			flagBase = true,
            speed = 5.5,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,	
            startPos = { x = 5700, y = -8230, z =  -2320, yaw =  0x0000, airborne = true },	
            floodScale = 2,			
        },
        {						
            name = "jrb2",
            level = LEVEL_JRB,
            area = 2,
            flagPos = { x = 7555, y =  -990, z =   1585, yaw =  0x8000 },
			flagBase = true,
            speed = 2.5,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,		
			floodHeight = -4080,
            overrideName = "Jolly Roger Castle",		
        },
        {						
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = 1530, y =  5460, z =   -835, yaw = -0x4000 },
			flagBase = true,
            speed = 3.5,
            author = "Mr.Needlemouse",
            type = FLOOD_FROSTBITE,	
            startPos = { x = -1200, y = -1020, z =  -6370, yaw =  0x0000, airborne = true },	
        },
        {						
            name = "ccm2",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = -5870, y =  4620, z =  -2335, yaw =  0x0000 },
			flagBase = true,
            speed = 3.5,
            author = "Mr.Needlemouse",
            type = FLOOD_SNOW,	
            overrideName = "Cold, Cold Crevasse",			
        },
        {						
            name = "pss2",
            level = LEVEL_PSS,
            area = 2,
            flagPos = { x = -4445, y = -2000, z =   9330, yaw = -0x6000 },
			flagBase = true,
            speed = 1.5,
            author = "Mr.Needlemouse",
            type = FLOOD_SNOW,				
			floodScale = 2.5,
			floodHeight = -6500,
			overrideName = "Chief Chilly's Frosty Lair",
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {						
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -2110, y =  7860, z =  -8585, yaw = -0x4000 },
			flagBase = true,
            speed = 3.0,
            author = "Mr.Needlemouse",
            type = FLOOD_CLOUDS,	
            floodScale = 2,		
            launchpads = {
                { x = 100, y = 1830, z = -2550, yaw = -0x6000, vel = 100, forwardVel = 110 },
            },	
        },
        {						
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -2280, y =  1640, z =    590, yaw = -0x4000 },
			flagBase = true,
            speed = 1.75,
            author = "Mr.Needlemouse",
            type = FLOOD_DARKNESS,			
            startPos = { x = 20, y = -2855, z =   8460, yaw =  0x8000, airborne = true },
			floodScale = 2,
			floodHeight = -6050,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvPushableMetalBox },			
        },
        {						
            name = "bbh2",
            level = LEVEL_BBH,
            area = 2,
            flagPos = { x = 0, y = 12130, z = 0, yaw =  0x0000 },
			flagBase = true,
            speed = 3.0,
            author = "Mr.Needlemouse",
            type = FLOOD_DARKNESS,			
            startPos = { x = 18670, y =  3900, z = -11265, yaw =  0x0000, airborne = true },	
			floodScale = 2.5,
			overrideSlide = true,
			overrideName = "Big Boo's Secret Slide",
        },
        {						
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 3330, y = 1210, z = -7035, yaw =  0x0000 },
            speed = 1.25,
            author = "Mr.Needlemouse",
            type = FLOOD_DARKNESS,		
            unwantedBhvs = { id_bhvDoorWarp },		
            overrideName = "Big Boo's Secret Domain",			
        },
        {						
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 6550, y = 10860, z = 0, yaw = -0x4000},
			flagBase = true,
            speed = 3.5,
            author = "Mr.Needlemouse",
            type = FLOOD_MOLTEN,		
			floodScale = 2.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },			
			floodHeight = -5500,
        },
        {						
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -7485, y = 2160, z = 7505, yaw = 0x5000 },
			flagBase = true,
            speed = 3.5,
            author = "Mr.Needlemouse",
            type = FLOOD_MUD,		
            startPos = { x = 6325, y = -4690, z = 2330, yaw = -0x4000, airborne = true },		
            unwantedBhvs = { id_bhvWarpPipe, id_bhvExclamationBox },		
			floodHeight = -6800,
            launchpads = {
                { x = -3540, y = -2560, z = -6970, yaw = 32701, vel = 200, forwardVel = 0 },
            },			
        },
        {						
            name = "hmc2",
            level = LEVEL_HMC,
            area = 3,
            flagPos = { x = 5500, y = 1300, z = -9520, yaw =  0x0000 },
            speed = 1.5,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,	
            unwantedBhvs = { id_bhvWarpPipe, id_bhvDoorWarp },	
            overrideName = "Crystal Caverns Entrance",	
            floodScale = 1.25,			
        },
        {						
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -15740, y =   840, z =  15195, yaw =  0x4000 },
			flagBase = true,
            speed = 1.5,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,	
			 
			floodHeight = -1500,
			floodScale = 2,
			capTimer = 1,
        },
        {						
            name = "cotmc2",
            level = LEVEL_COTMC,
            area = 4,
            flagPos = { x = 765, y = 70, z = 4660, yaw =  0x8000 },
			flagBase = true,
            speed = 0.75,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,	
            overrideName = "Lava Caverns",		
            unwantedBhvs = { id_bhvWarpPipe },				
            capTimer = 1,			
        },
        {						
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 775, y =  4205, z =  -2410, yaw = -0x4000 },
			flagBase = true,
            speed = 2.5,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,		
            startPos = { x = 315, y = 580, z = -2470, yaw = 0x4000, airborne = true },
            capTimer = 1,		
        },
        {						
            name = "wmotr2",
            level = LEVEL_WMOTR,
            area = 2,
            flagPos = { x = 0, y =  1630, z =  -7175, yaw =  0x0000 },
			flagBase = true,
            speed = 2.75,
            author = "Mr.Needlemouse",
            type = FLOOD_CLOUDS,		
            overrideName = "Platform Peril",				
        },
        {						
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -5450, y =  6240, z =  -9810, yaw =  0x4000 },
			flagBase = true,
            speed = 2.0,
            author = "Mr.Needlemouse",
            type = FLOOD_LAVA,		
            floodScale = 2.5,			
        },
        {						
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 4870, y = -3455, z =   -560, yaw = -0x4000 },
			flagBase = true,
            speed = 2.0,
            author = "Mr.Needlemouse",
            type = FLOOD_SAND,			
            startPos = { x = -6060, y = -7720, z = -6840, yaw = 0x0000, airborne = true },		
			floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvMoneybag, id_bhvMoneybagHidden },		
        },
        {						
            name = "ssl2",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x = 15670, y =  2935, z =   -680, yaw = -0x4000 },
			flagBase = true,
            speed = 2.25,
            author = "Mr.Needlemouse",
            type = FLOOD_SAND,		
            startPos = { x = 1230, y =   350, z =  -8340, yaw =  0x0000, airborne = true },			
			overrideName = "Grindel Temple",
			floodScale = 1.5,		
        },
        {						
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 0, y = 0, z = -2455, yaw = 0x0000 },
			flagBase = true,
            speed = 2.0,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,		
            startPos = { x = 0, y = -6380, z = 18145, yaw =  0x8000, airborne = true },		
            floodScale = 2.5,			
			floodHeight = -9270,
            launchpads = {
                { x = 0, y = -7100, z = 1550, yaw = 32701, vel = 120, forwardVel = 0 },
            },			
        },
        {						
            name = "ddd2",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 0, y = -2490, z = 27550, yaw = 0x8000 },
            speed = 1.5,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,		
            startPos = { x = -25, y = -4795, z = 18735, yaw = 0x0000, airborne = true },	
            overrideName = "Risky Cavern Climb",	
			 
            floodScale = 2.5,			
        },
        {						
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 30, y = 17455, z = 20, yaw =  0x0000 },
			flagBase = true,
            speed = 3.5,
            author = "Mr.Needlemouse",
            type = FLOOD_LAVA,			
            startPos = { x = 1390, y = 170, z =  -6055, yaw =  0x0000, airborne = true },	
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {						
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 2354, y =  2160, z =   4690, yaw =  0x8000 },
			flagBase = true,
            speed = 3.0,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,			
            startPos = { x = -4415, y = 100, z = 5400, yaw = -0x4000, airborne = true },		
            overrideName = "Castle Town",	
            floodScale = 1.5,			
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {						
            name = "cg2",
            level = LEVEL_CASTLE_GROUNDS,
            area = 2,
            flagPos = { x = -6800, y =  2375, z =   2990, yaw =  0x8000 },
			flagBase = true,
            speed = 3.0,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,			
            startPos = { x = -3655, y = -1405, z =   4645, yaw =  0x8000, airborne = true },
            unwantedBhvs = { id_bhvWarpPipe },
            launchpads = {
                { x = 2860, y = -1060, z = 2405, yaw = 0x8000, vel = 100, forwardVel = 110 },
            },	
        },
        {						
            name = "c",
            level = LEVEL_CASTLE,
            area = 3,
            flagPos = { x = 315, y = 2300, z = 8920, yaw =  0x8000 },
			flagBase = true,
            speed = 3.0,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,			
            startPos = { x = -1880, y = 0, z = -2120, yaw = 0x0000, airborne = true },
			overrideName = "Castle Courtyard",
			floodScale = 2,
			unwantedBhvs = { id_bhvWarpPipe },
            powerUp = "wing",			
        },
        {						
            name = "c2",
            level = LEVEL_CASTLE,
            area = 4,
            flagPos = { x = -4140, y = 4600, z = 2800, yaw = 0x4000 },
			flagBase = true,
            speed = 4.5,
            author = "Mr.Needlemouse",
            type = FLOOD_WATER,		
            startPos = { x = 0, y = 0, z = 0, yaw =  0x8000, airborne = true },
			floodScale = 1.75,
            unwantedBhvs = { id_bhvDoorWarp },			
        },
        {						
            name = "c3",
            level = LEVEL_CASTLE,
            area = 5,
            flagPos = { x = 805, y = 1615, z = -7080, yaw = 0x0000 },
            speed = 3.5,
            author = "Mr.Needlemouse",
            type = FLOOD_POISON,				
            startPos = { x = 30, y = -2625, z = -1110, yaw =  0x8000, airborne = false },		
            overrideName = "Purple Castle",	
            unwantedBhvs = { id_bhvDoorWarp },					
        }
    }	
end

-- Kaizo Mario 64, ported to Flood by ★~¡TOÑO!~★
local function flood_load_kaizo_mario_64_levels()
    game = GAME_KAIZO_MARIO_64
    romhackInfo = "Kaizo Mario 64"
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -1328, y = 260, z = 4663, yaw = 0x8000},
            overrideWater = true
        },
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x8000}
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -1022, y = -50, z = 745, yaw = 0x8000}
        },
        [4] = {
            level = LEVEL_CASTLE,
            area = 2,
            spawn = {x = 665, y = 1203, z = 2303, yaw = 0x8000}
        },
        [5] = {
            level = LEVEL_CASTLE,
            area = 3,
            spawn = {x = -1123, y = -1074, z = 1336, yaw = 0x0000}
        },
        [6] = {
            level = LEVEL_THI,
            area = 3,
            spawn = {x = 1252, y = 1024, z = -611, yaw = -15123}
        },
        [7] = {
            level = LEVEL_THI,
            area = 3,
            spawn = {x = 5, y = 1843, z = 3, yaw = 423}
        },
        [8] = {
            level = LEVEL_TOTWC,
            area = 1,
            spawn = {x = -10, y = -2047, z = 584, yaw = 32729}
        },
        [9] = {
            level = LEVEL_SSL,
            area = 3,
            spawn = {x = 0, y = -1534, z = -2059, yaw = 0x8000}
        },
        [10] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = 0, y = 307, z = 0, yaw = 0x8000}
        },
        [11] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = 0, y = 1229, z = 0, yaw = 0x8000}
        },
        [12] = {
            level = LEVEL_BOWSER_3,
            area = 1,
            spawn = {x = 0, y = 307, z = 0, yaw = 0x8000}
        },
        [13] = {
            level = LEVEL_SA,
            area = 1,
            spawn = {x = 0, y = -4402, z = 0, yaw = 0x0000},
        },
        [14] = {
            level = LEVEL_CASTLE,
            area = 2,
            spawn = {x = -213, y = 2253, z = 5891, yaw = 0x0000}
        },
        [15] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 1029, y = 3174, z = -5640, yaw = -0x4000}
        },
        [16] = {
            level = LEVEL_CASTLE,
            area = 3,
            spawn = {x = -1448, y = -1279, z = -3023, yaw = 0x8000}
        }
    }
		
    gLevels = {
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 2985, y = 4293, z = -4815, yaw = 0x8000 },
            flagBase = true,
            speed = 4.0,
            author = "OmegaEdge29",
            type = FLOOD_WATER
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = 810, y = 17500, z = 4690, yaw = 0x4000 },
			flagBase = true,
            speed = 4.0,
            author = "OmegaEdge29",
            type = FLOOD_CLOUDS,
			floodScale = 2,
            launchpads = {
                { x = -5490, y = 8090, z = -2405, yaw = 0x4000, vel = 100, forwardVel = 55 },
                { x = 4565, y = 7890, z = -2405, yaw = 0x0000, vel = 3000, forwardVel = 200, capTimer = 25 },				
            },			
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x =  4863,  y = 1889,  z = 703, yaw =  -0x1000 },
            speed = 5.0,
            author = "OmegaEdge29",
            type = FLOOD_WATER,
            startPos = { x = 5140,  y = -4910, z = -615, yaw =  0x0000, airborne = true },			
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -55, y = 5520, z = -150, yaw = 0x8000 },
            speed = 6.0,
            author = "OmegaEdge29",
            type = FLOOD_SNOW,
            startPos = { x = 3336, y = -4738.15, z = 0, yaw = 0x0000 },
        },
        {
            name = "ccm-slide",
            level = LEVEL_CCM,
            area = 2,
            flagPos = { x = -5836,  y = 6656, z = -6143, yaw = 0x4000 },
            flagBase = true,
            speed = 5.5,
            author = "OmegaEdge29",
            type = FLOOD_SNOW,
            startPos = { x = -6018, y = -5836, z = -6930, yaw = -0x4000, spin = false },
            floodScale = 2,
            overrideName = "Frosty Slide",
            overrideSlide = true
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = 5632, y = 6144, z = -5631, yaw = -0x4000 },
            flagBase = true,
            speed = 6.0,
            author = "OmegaEdge29",
            type = FLOOD_DARKNESS,
            startPos = { x = -6387, y = -4484, z =  5723, yaw = 0x8000, spin = false },
            overrideSlide = true,	
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = 0, y = 3105, z = 0, yaw = -0x4000 },
            speed = 3.0,
            author = "OmegaEdge29",
            type = FLOOD_CLOUDS,			
			floodScale = 2,
			floodHeight = 940
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 655, y = 3277, z = 244, yaw = 0x0000 },
            speed = 2.5,
            author = "OmegaEdge29",
            type = FLOOD_DARKNESS,
            startPos = { x = 2918, y = -2969, z =  1884, yaw = -0x6000 },			
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 1460, y = 4450, z = -2400, yaw = 0x4000 },
            speed = 3.75,
            author = "OmegaEdge29",
            type = FLOOD_DARKNESS,
            floodScale = 2,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe }
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 4315, y = -4195, z = 4020, yaw = 0x8000 },
            speed = 4.0,
            author = "OmegaEdge29",
            type = FLOOD_WATER,
            startPos = { x = 4300, y = -2990, z = -4570, yaw = 0x0000, airborne = true },
            floodHeight = -6320			
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x =  -21,  y = 768,  z = -6709, yaw = 0x0000 },
            flagBase = true,
            speed = 1.5,
            author = "OmegaEdge29",
            type = FLOOD_LAVA,
            floodScale = 2,
            unwantedBhvs = { id_bhvMetalCap, id_bhvWingCap, id_bhvVanishCap }			
        },
        {
            name = "lll-volcano",
            level = LEVEL_LLL,
            area = 2,
            flagPos = { x = 1790, y = 3230, z = 1460, yaw = 0x8000 },
            speed = 4.0,
            author = "OmegaEdge29",
            type = FLOOD_LAVA,
            overrideName = "Flame-Boiling Volcano",
             		
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -5890, y = 1024, z = -2555, yaw = 0x4000 },
            speed = 2.5,
            author = "OmegaEdge29",
            type = FLOOD_SAND,
            startPos = { x = 5000, y = 300, z = -4865, yaw = 0x4000, airborne = false, spin = false },			
            floodScale = 2,
            unwantedBhvs = { id_bhvKlepto, id_bhvMetalCap, id_bhvWingCap, id_bhvVanishCap }
        },
        {
            name = "ssl-pyramid",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x = 512, y = 4687, z = -551, yaw = -0x6000 },
            speed = 3.0,
            author = "OmegaEdge29",
            type = FLOOD_DESERT,
            overrideName = "The Ancient Pyramid",
            unwantedBhvs = { id_bhvExclamationBox }			
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 1225, y = 5478, z = 64, yaw = 0x0000 },
            flagBase = true,
            speed = 4.0,
            author = "OmegaEdge29",
            type = FLOOD_LAVA,
            floodScale = 2.5,
            floodHeight = -6600
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x =  1467,  y = 4096,  z =  93, yaw = -0x5000 },
            flagBase = true,
            speed = 3.0,
            author = "OmegaEdge29",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvExclamationBox },
			floodHeight = -2500
        },
        {
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 0, y = 3455, z = -20, yaw = 0x4000 },
            speed = 5.0,
            author = "OmegaEdge29",
            type = FLOOD_WATER,
            floodScale = 1.25,
            overrideWater = true
        },
        {
            name = "ttm-slide",
            level = LEVEL_TTM,
            area = 3,
            flagPos = { x = 6014, y = 6437, z = 5781, yaw = -24715 },
            speed = 8.0,
            author = "OmegaEdge29",
            type = FLOOD_DARKNESS,
            startPos = { x = 6844, y = -7537, z = -405, yaw = -16384, airborne = false, spin = false },
            floodScale = 2,
            overrideName = "Mysterious Mountain Slide",
            launchpads = {
                { x = -1308, y = -5322, z = 2310, yaw = 32701, vel = 100, forwardVel = 0 },
            },
            overrideSlide = true
        },
        {
            name = "thi-small",
            level = LEVEL_THI,
            area = 2,
            flagPos = { x = 625,  y = 5415,  z = -1540, yaw = 0x8000 },
            speed = 3.5,
            author = "OmegaEdge29",
            type = FLOOD_WATER,
            unwantedBhvs = { id_bhvWarpPipe },
            startPos = { x = 450, y = 4115, z = -4050, yaw = -0x0000, airborne = true },			
            overrideName = "The Tiny Island"
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = -12, y = 3891, z = -1556, yaw = 0x2000 },
            flagBase = false,
            speed = 4.0,
            author = "OmegaEdge29",
            type = FLOOD_WATER,
            floodScale = 2.6,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvBubba },
            overrideName = "The Huge Island"
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = 2208, y = 6900, z =  2217, yaw =  -0x6000 },
            speed = 2.75,
            author = "OmegaEdge29",
            type = FLOOD_WATER,
			floodHeight = -8190
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = -4203, y = 6451, z = -5824, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "OmegaEdge29",
            type = FLOOD_CLOUDS,
            startPos = { x = 1305, y = 10000, z = 2070, yaw = 0x4000, airborne = false, spin = true },			
            floodScale = 3,
			floodHeight = -4600,
            launchpads = {
                { x = 3743, y = 4276, z = -2125, yaw = -16472, vel = 120, forwardVel = 47, capTimer = 180 },
                { x = -7569, y = 4352, z = -4300, yaw = 23469, vel = 145, forwardVel = 0 }
            }
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -3116, y = 4557, z = -4264, yaw = 7356},
            speed = 5.9,
            author = "OmegaEdge29",
            type = FLOOD_CLOUDS,
            startPos = { x = 4173, y = -2738, z = 5747, yaw = -18379, spin = false },
            floodScale = 3,
            unwantedBhvs = { id_bhvRedCoin },
            launchpads = {
                { x = 3081, y = -2738, z = 5541, yaw = -18963, vel = 65, forwardVel = 70 },
                { x = -463, y = -1367, z = 4692, yaw = 24520, vel = 50, forwardVel = 90 },
                { x = 47, y = 1732, z = -22, yaw = -25873, vel = 60, forwardVel = 130 }
            }
        },
        {
            name = "bits",
            level = LEVEL_BITS,
            area = 1,
            flagPos = { x =  347,   y = 6652,  z = -6015, yaw =  0x0000 },
            flagBase = true,
            speed = 5.5,
            author = "OmegaEdge29",
            type = FLOOD_POISON,
            startPos = { x = -8000, y = 6600, z = 4, yaw = 0x4000, airborne = false, spin = false },				
            floodScale = 3,
            unwantedBhvs = { id_bhvWarpPipe }
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 0, y = 7600, z = -4025, yaw = 0x0000 },
            speed = 4.5,
            author = "OmegaEdge29",
            type = FLOOD_WATER,
            startPos = { x = -5490, y = 550, z = -3825, yaw =  0x8000, airborne = true },
        }
    }
end

-- B3313, ported to Flood by SuperMarty
local function flood_load_b3313_levels()
    game = GAME_B3313
    romhackInfo = "B3313"
	romhackLogo = get_texture_info("logo_b3313")
	gLobbies = {
        [1] = {
            level = LEVEL_THI,
            area = 1,
            spawn = {x = -1825, y = -880, z = 6515, yaw = 0x8000}
        },
        [2] = {
            level = LEVEL_CCM,
            area = 5,
            spawn = {x = 1500, y = 305, z = -4960, yaw = 0x8000}
        },
        [3] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 4,
            spawn = {x = 10, y = -330, z = 1885, yaw = 0x8000}
        },
        [4] = {
            level = LEVEL_SL,
            area = 2,
            spawn = {x = -1328, y = 260, z = 4663, yaw = 0x8000}
        },
        [5] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 5,
            spawn = {x = 50, y = 0, z = -11970, yaw = 0x8000}			
        },
        [6] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 7,
            spawn = {x = -4235, y = -1040, z = 5855, yaw = 0x8000}			
        },
        [7] = {
            level = LEVEL_BITFS,
            area = 5,
            spawn = {x = 80, y = -165, z = -1710, yaw = 0x0000}			
        },
        [8] = {
            level = LEVEL_TTC,
            area = 7,
            spawn = {x = -305, y = -1070, z = -10360, yaw = 0x0000}
        },
        [9] = {
            level = LEVEL_VCUTM,
            area = 2,
            spawn = {x = -12045, y = 1625, z = -18925, yaw = 0x0000}		
        },
        [10] = {
            level = LEVEL_TTC,
            area = 3,
            spawn = {x = -13190, y = -750, z = -1920, yaw = 0x0000}			
        },
        [11] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 4,
            spawn = {x = 1580, y = -1945, z = -1670, yaw = 0x8000}			
        },
        [12] = {
            level = LEVEL_SL,
            area = 2,
            spawn = {x = -1525, y = -880, z = 5915, yaw = 0x8000}
        },
        [13] = {
            level = LEVEL_BOB,
            area = 1,
            spawn = {x = -1980, y = 0, z = -3060, yaw = 0x2000}		
        },
        [14] = {
            level = LEVEL_BOB,
            area = 2,
            spawn = {x = -2010, y = 130, z = 6655, yaw = 0x8000}					
        },
        [15] = {
            level = LEVEL_BOB,
            area = 6,
            spawn = {x = -2180, y = 1410, z = -10930, yaw = 0x0000}		
        },
        [16] = {
            level = LEVEL_WF,
            area = 1,
            spawn = {x = 2520, y = 0, z = -9925, yaw = 0x4000}		
        },
        [17] = {
            level = LEVEL_WF,
            area = 3,
            spawn = {x = -5920, y = -280, z = -725, yaw = 0x8000}		
        },
        [18] = {
            level = LEVEL_WF,
            area = 4,
            spawn = {x = 330, y = 160, z = -40, yaw = 0x0000}		
        },
        [19] = {
            level = LEVEL_JRB,
            area = 5,
            spawn = {x = 10, y = -360, z = 1955, yaw = 0x8000}		
        },
        [20] = {
            level = LEVEL_CCM,
            area = 2,
            spawn = {x = 325, y = 0, z = -380, yaw = 0x4000}		
        },
        [21] = {
            level = LEVEL_CCM,
            area = 4,
            spawn = {x = 5035, y = 0, z = -5000, yaw = 0x0000}	
        },
        [22] = {
            level = LEVEL_BBH,
            area = 4,
            spawn = {x = 5775, y = 765, z = -6810, yaw = 0x0000}	
        },
        [23] = {
            level = LEVEL_DDD,
            area = 4,
            spawn = {x = 2100, y = 0, z = -760, yaw = 0x8000}	
        },
        [24] = {
            level = LEVEL_SL,
            area = 1,
            spawn = {x = -7500, y = 0, z = -6370, yaw = 0x4000}		
        },
        [25] = {
            level = LEVEL_SL,
            area = 4,
            spawn = {x = 2945, y = -2390, z = 5, yaw = -0x4000}	
        },
        [26] = {
            level = LEVEL_WDW,
            area = 5,
            spawn = {x = 500, y = 6480, z = 7580, yaw = 0x8000}		
        },
        [27] = {
            level = LEVEL_TTC,
            area = 6,
            spawn = {x = 7835, y = 225, z = -1420, yaw = 0x8000}		
        },
        [28] = {
            level = LEVEL_RR,
            area = 4,
            spawn = {x = 220, y = 0, z = 13810, yaw = 0x8000}		
        },
        [29] = {
            level = LEVEL_RR,
            area = 5,
            spawn = {x = 240, y = 0, z = -665, yaw = 0x4000}			
        },
        [30] = {
            level = LEVEL_BITFS,
            area = 2,
            spawn = {x = 16610, y = -685, z = -12065, yaw = -0x4000}		
        },
        [31] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 7,
            spawn = {x = 10, y = 1595, z = -7215, yaw = 0x8000}			
        },
        [32] = {
            level = LEVEL_PSS,
            area = 7,
            spawn = {x = 10, y = 1595, z = -7215, yaw = 0x8000}	
        },
        [33] = {
            level = LEVEL_SA,
            area = 7,
            spawn = {x = 12300, y = 2340, z = -14305, yaw = -0x2000}
        },
        [34] = {
            level = LEVEL_TOTWC,
            area = 5,
            spawn = {x = 490, y = 685, z = -980, yaw = 0x8000}	
        },
        [35] = {
            level = LEVEL_VCUTM,
            area = 1,
            spawn = {x = 1140, y = -470, z = 1205, yaw = 0x0000}		
        },
        [36] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = 3150, y = 110, z = -5885, yaw = 0x2000}	
        },
        [37] = {
            level = LEVEL_BOWSER_2,
            area = 2,
            spawn = {x = 10540, y = -4335, z = -14415, yaw = 0x8000}	
        },
        [38] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 6,
            spawn = {x = -2755, y = 0, z = -440, yaw = 0x8000}			
        },
        [39] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 2,
            spawn = {x = 5340, y = -170, z = 1585, yaw = -0x4000}	
        },
        [40] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 3,
            spawn = {x = 1720, y = 1765, z = -3550, yaw = -0x2000}			
        },
        [41] = {
            level = LEVEL_ENDING,
            area = 2,
            spawn = {x = -795, y = -2180, z = -11385, yaw = 0x0000}					
        }
    }
	
    gLevels = {
        {	
            name = "bits",
            level = LEVEL_BITS,
            area = 4,
            flagPos = { x = 4160, y = 4290, z = -6970, yaw = 0x0000 },
			flagBase = true,
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,
            overrideName = "Bob-Omb Battlefield (Beta)",
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {
            name = "bits2",
            level = LEVEL_BITS,
            area = 3,
            flagPos = { x = 1644, y = 2903, z = -537, yaw =  0x0000 },
			flagBase = true,
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_SNOW,
            startPos = { x = -7920, y = -1390, z = 11135, yaw = 0x6000, airborne = true },
            overrideName = "Ice-Cold Warzone",
            unwantedBhvs = { id_bhvWarpPipe },			
        },
        {
            name = "pss",
            level = LEVEL_PSS,
            area = 5,
            flagPos = { x = 11350, y = 7213, z = -11435, yaw = 0x0000},
			flagBase = true,
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,
            floodScale = 2,			
            overrideName = "Bob-Omb Village",			
        },
        {
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 10520, y = 3980, z = -10790, yaw = 0x0000},
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,
            startPos = { x = 2380, y = 77, z = -2011, yaw = 0x4000, airborne = true },			
            floodScale = 2,				
            overrideName = "Bob-Omb River",				
            unwantedBhvs = { id_bhvExclamationBox }				
        },
        {
            name = "jrb2",
            level = LEVEL_JRB,
            area = 2,
            flagPos = { x = 8470, y = 7024, z = -12180, yaw =  0x4000 },
			flagBase = true,
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_MUD,
            floodScale = 2.0,				
            overrideName = "Big Bob-Omb Fortress",			
        },
        {
            name = "jrb3",
            level = LEVEL_JRB,
            area = 3,
            flagPos = { x = 8801, y = 7682, z = 21907, yaw = 0x8000 },
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,
            floodScale = 2.5,				
            overrideName = "Piranha Plant Garden",	
        },
        {
            name = "thi",
            level = LEVEL_THI,
            area = 2,
            flagPos = { x = -440, y = 5805, z = 1740, yaw = 0x8000 },
			flagBase = true,
            speed = 3.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,
            floodScale = 2.5,				
            overrideName = "Bob-Omb Tower",				
        },
        {
            name = "vcutm",
            level = LEVEL_VCUTM,
            area = 5,
            flagPos = { x = 6655, y = 3015, z = -5715, yaw = 0x0000 },
			flagBase = true,
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,
            floodScale = 2,				
            overrideName = "Bob-Omb Test Site",		
            capTimer = 1			
        },
        {
            name = "sa",
            level = LEVEL_SA,
            area = 2,
            flagPos = { x = 10780, y = 1120, z = -475, yaw = -0x4000 },
			flagBase = true,
            speed = 4.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,
            startPos = { x = -6540, y = -2130, z = 6955, yaw = 0x4000, airborne = true },	
            floodScale = 2,				
            overrideName = "Wiggler's Forest Fortress",				
        },
        {
            name = "bob",
            level = LEVEL_BOB,
            area = 7,
            flagPos = { x = -3961, y = 3150, z = -17236, yaw = 0x0000 },
			flagBase = true,
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,		
            floodScale = 2,				
            overrideName = "Goomba Hills",		
        },
		{
            name = "thi2",
            level = LEVEL_THI,
            area = 4,
            flagPos = { x = -1930, y =   7497, z =  -8806, yaw = -0x4000 },
			flagBase = true,
            speed = 3.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,			
            floodScale = 2.5,				
            overrideName = "Grassy Islands",				
        },
        {
            name = "rr",
            level = LEVEL_RR,
            area = 2,
            flagPos = { x = 14028, y = 89, z = -321, yaw = -0x4000 },
			flagBase = true,
            speed = 4.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,						
            startPos = { x = -6540, y = -2130, z = 6955, yaw = 0x8000, airborne = true },	
            floodScale = 2,				
            overrideName = "Wiggler's Forest Old Fortress",			
        },
        {
            name = "hmc",
            level = LEVEL_HMC,
            area = 5,
            flagPos = { x = 13220, y = 710, z = -580, yaw = -0x4000 },
			flagBase = true,
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            floodScale = 1.5,				
            overrideName = "Unnamed Grass Level (???)",		
        },
        {
            name = "pss2",
            level = LEVEL_PSS,
            area = 3,
            flagPos = { x = 156, y = 4164, z = -13591, yaw = 0x0000 },
			flagBase = true,
            speed = 4.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,		
            floodScale = 2,				
            overrideName = "Cubic Greens",	
        },
        {
            name = "hmc2",
            level = LEVEL_HMC,
            area = 3,
            flagPos = { x = -2088, y = 4628, z = 11013, yaw = 0x4000 },
			flagBase = true,
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,		
            floodScale = 2.5,				
            overrideName = "Midnight Meadow",	
        },
        {
            name = "wf",
            level = LEVEL_WF,
            area = 6,
            flagPos = { x = -6430, y = 11100, z = -11110, yaw = 0x6000 },
			flagBase = true,
            speed = 4.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,						
            startPos = { x = -5931, y = 315, z = -6061, yaw = -0x4000, airborne = true },	
            floodScale = 2.5,				
            overrideName = "Grassy Grass Mountain",		
        },
        {
            name = "wf2",
            level = LEVEL_WF,
            area = 7,
            flagPos = { x = -6430, y = 11100, z = -11110, yaw = 0x6000 },
			flagBase = true,
            speed = 3.5,
            author = "ChrisRLillo",
            type = FLOOD_LAVA,						
            startPos = { x = -5931, y = 315, z = -6061, yaw = -0x4000, airborne = true },		
            floodScale = 2.5,				
            overrideName = "Lavish Lava Mountain",			
        },
        {
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 6,
            flagPos = { x = -2185, y = 7781, z = -10079, yaw = 0x0000 },
			flagBase = true,
            speed = 5.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,										
            overrideName = "Rocky Trek",	
            capTimer = 1			
        },
        {
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 3279, y = 3450, z = -2858, yaw = 0x0000 },
			flagBase = true,
            speed = 6.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            floodScale = 1.5,				
            overrideName = "Tiny-Huge Island (Beta)",
            unwantedBhvs = { id_bhvExclamationBox }				
        },
        {
            name = "cotmc2",
            level = LEVEL_COTMC,
            area = 4,
            flagPos = { x = -20, y = 2875, z = 60, yaw = 0x0000 },
            speed = 4.0,
            author = "ChrisRLillo",
            type = FLOOD_CLOUDS,						
            startPos = { x = -3150, y = -2100, z = -4840, yaw = -0x4000, airborne = true },				
            overrideName = "Whomp's Fortress (Beta)",	
		    capTimer = 1
        },
        {
            name = "cotmc3",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = 325, y = 5365, z = -25, yaw = 0x0000 },
            speed = 4.0,
            author = "ChrisRLillo",
            type = FLOOD_CLOUDS,						
            startPos = { x = 2675, y = 885, z = 5120, yaw = 0x4000, airborne = true },				
            overrideName = "Mountain (B-Roll)",			
            capTimer = 1			
        },
        {
            name = "cotmc4",
            level = LEVEL_COTMC,
            area = 5,
            flagPos = { x = 6620, y = 9710, z = -7280, yaw = -0x6000 },
			flagBase = true,
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_CLOUDS,						
            startPos = { x = 590, y = 1900, z = -4620, yaw = 0x0000, airborne = true },			
            floodScale = 2,				
            overrideName = "Whomp's Fortress (Beta 2)",
		    capTimer = 1			
        },
        {
            name = "bbh",
            level = LEVEL_BBH,
            area = 3,
            flagPos = { x = -1765, y = 3820, z = -1095, yaw = 0x0000 },
            speed = 5.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,						
            startPos = { x = 46, y = -1024, z = 3621, yaw =  0x8000, airborne = true },				
            overrideName = "Unnamed Fortress Level (???)",					
        },
        {
            name = "bbh2",
            level = LEVEL_BBH,
            area = 2,
            flagPos = { x = 800, y = 4515, z = -800, yaw = 0x4000 },	
            flagBase = true,			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            floodScale = 2,					
            overrideName = "Whomp's Prison",	
        },
        {
            name = "bbh3",
            level = LEVEL_BBH,
            area = 5,
            flagPos = { x = 10723, y = 6294, z = -19440, yaw = -0x4000 },			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,		
            floodScale = 3,					
            overrideName = "Flower Fields",	
			floodHeight = -550,
        },
        {
            name = "cotmc5",
            level = LEVEL_COTMC,
            area = 2,
            flagPos = { x = 6734, y = 8740, z = -7758, yaw = -0x4000 },	
            flagBase = true,					
            speed = 2.25,
            author = "ChrisRLillo",
            type = FLOOD_POISON,								
            startPos = { x = -2563, y = 5008, z = 5205, yaw = 0x8000, airborne = true },					
            overrideName = "Goomboss Battle",	
			floodHeight = 3000,
		    capTimer = 1	
        },
        {
            name = "cotmc6",
            level = LEVEL_COTMC,
            area = 2,
            flagPos = { x = 6835, y = 8505, z = 5835, yaw = -0x4000 },	
            flagBase = true,					
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_POISON,								
            startPos = { x = 255, y = 4725, z = -8960, yaw = 0x0000, airborne = true },					
            overrideName = "Goomboss Wallkick Training",	
		    capTimer = 1				
        },
        {
            name = "vcutm2",
            level = LEVEL_VCUTM,
            area = 1,
            flagPos = { x = 1235, y = 740, z = 1180, yaw = -0x6000 },							
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            startPos = { x = 3175, y = -110, z = 3115, yaw = -0x6000, airborne = true },				
            overrideName = "Battle Fort",		
		    capTimer = 1							
        },
        {
            name = "thi3",
            level = LEVEL_THI,
            area = 5,
            flagPos = { x = 4577, y = 2780, z = 886, yaw = 0x0000 },		
            flagBase = true,					
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_DARKNESS,			
            floodScale = 1.5,					
            overrideName = "Minion Base",		
			floodHeight = -3000,
        },
        {
            name = "ccm",
            level = LEVEL_CCM,
            area = 3,
            flagPos = { x = -10882, y = 11483, z = -12477, yaw = 0x8000 },			
            flagBase = true,					
            speed = 3.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,			
            floodScale = 3,					
            overrideName = "Test Level",				
        },
        {
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 3,
            flagPos = { x = 3970, y = 5390, z = -6720, yaw = 0x0000 },		
            flagBase = true,					
            speed = 4.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            startPos = { x = -3205, y = -2690, z = 10070, yaw = 0x6000, airborne = true },					
            overrideName = "Parkour Playground",				
        },
        {
            name = "pss2",
            level = LEVEL_PSS,
            area = 2,
            flagPos = { x = -2129, y = 7917, z = -14651, yaw = 0x0000 },	
            flagBase = true,					
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,		
            floodScale = 2,					
            overrideName = "castle2",			
        },
        {
            name = "rr2",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 3400, y = 1790, z = -3140, yaw = -0x2000 },			
            flagBase = true,					
            speed = 5.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,		
            startPos = { x = 5700, y = -8230, z = -2320, yaw = 0x0000, airborne = true },	
            floodScale = 2,					
            overrideName = "Jolly Roger Bay (Beta)",	
        },
        {
            name = "bitdw2",
            level = LEVEL_BITDW,
            area = 3,
            flagPos = { x = 3180, y = 2710, z = -12330, yaw = 0x0000 },	
            flagBase = true,					
            speed = 5.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,		
            startPos = { x = -1070, y = -4730, z = -13125, yaw = 0x0000, airborne = true },		
            floodScale = 2,			
            overrideName = "Creepy Cove",		
            launchpads = {
                { x = -1070, y = -4730, z = -7010, yaw = 0x0000, vel = 200, forwardVel = 0 },
                { x = 540, y = 2710, z = -6940, yaw = 0x6000, vel = 100, forwardVel = 55 },				
            },			
        },
        {
            name = "wmotr3",
            level = LEVEL_WMOTR,
            area = 4,
            flagPos = { x = -2355, y = 770, z = -4820, yaw = 0x0000 },					
            speed = 5.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            overrideName = "Unnamed Water Level (???)",
            overrideWater = true			
        },
        {
            name = "ccm2",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -21610, y = 3665, z = -520, yaw = 0x6000 },			
            flagBase = true,			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,		
            startPos = { x =  -2215, y = 1100, z = -12930, yaw = -0x4000, airborne = true },	
            floodScale = 2.5,					
            overrideName = "Jolly Roger Lagoon",	
            unwantedBhvs = { id_bhvExclamationBox },			
            launchpads = {
                { x = -15950, y = 1190, z = -6605, yaw = 0x6000, vel = 120, forwardVel = 0 },			
            },					
        },
        {
            name = "wmotr3",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = 4400, y = 2290, z = 11645, yaw = -0x4000},			
            flagBase = true,			
            speed = 2.75,
            author = "ChrisRLillo",
            type = FLOOD_WATER,		
            floodScale = 2,					
            overrideName = "Water Land",
            launchpads = {
                { x = 150, y = -2360, z = 2975, yaw = 0x3000, vel = 170, forwardVel = 0 },				
                { x = 700, y = -2055, z = 14175, yaw = -0x2000, vel = 180, forwardVel = 0 },			
            },						
        },
        {
            name = "lll",
            level = LEVEL_LLL,
            area = 2,
            flagPos = { x = 700, y =   1310, z =   3215, yaw = -0x4000 },			
            flagBase = true,			
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,						
            overrideName = "Peaceful Sewer Maze",		
        },
        {
            name = "ssl",
            level = LEVEL_SSL,
            area = 3,
            flagPos = { x = 105, y = 4327, z = 8295, yaw =  0x5000 },						
            speed = 3.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,			
            floodScale = 3.5,					
            overrideName = "Scary Sewer Maze",		
            unwantedBhvs = { id_bhvExclamationBox }						
        },
        {
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = -520, y = 2975, z = -10905, yaw = 0x0000 },			
            flagBase = true,			
            speed = 1.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            floodScale = 3,					
            overrideName = "Aquatic Tunnel",
            floodHeight = 2000			
        },
        {
            name = "bitdw3",
            level = LEVEL_BITDW,
            area = 4,
            flagPos = { x = 7640, y = -1000, z = 1570, yaw = 0x8000 },			
            flagBase = true,			
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,			
            startPos = { x = -155, y = 800, z = -4430, yaw = -0x4000, airborne = true },				
            overrideName = "Sunken Castle",				
        },
        {
            name = "wdw",
            level = LEVEL_WDW,
            area = 3,
            flagPos = { x = 1550, y = 5465, z = -845, yaw = -0x4000 },			
            flagBase = true,			
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_SNOW,			
            startPos = { x = -1094, y = -1123, z = -6629, yaw = -0x2000, airborne = true },				
            overrideName = "Frosty Highlands",		
        },
        {
            name = "wdw2",
            level = LEVEL_WDW,
            area = 6,
            flagPos = { x = -5858, y = 4623, z = -2360, yaw =  0x0000 },			
            flagBase = true,			
            speed = 4.0,
            author = "ChrisRLillo",
            type = FLOOD_FROSTBITE,						
            overrideName = "Cold, Cold Crevasse",		
            unwantedBhvs = { id_bhvExclamationBox },			
        },
        {
            name = "wdw3",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 1070, y = 10365, z = -1900, yaw = 0x6000 },						
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_SNOW,						
            startPos = { x = 3441, y = 2705, z = -10607, yaw = 0x0000, airborne = true },
            floodScale = 2,		
            overrideName = "Snow Slide 2",		
        },
        {
            name = "wdw4",
            level = LEVEL_WDW,
            area = 7,
            flagPos = { x = -8076, y = 11202, z = 7125, yaw = 0x8000 },			
            flagBase = true,			
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_FROSTBITE,						
            startPos = { x = 1336, y = -1358, z = 4221, yaw =  0x8000, airborne = true },	
            floodScale = 3,					
            overrideName = "Chroma Tundra",		
        },
        {
            name = "wdw5",
            level = LEVEL_WDW,
            area = 4,
            flagPos = { x = -6400, y = 11100, z = -11040, yaw = 0x8000 },			
            flagBase = true,			
            speed = 4.5,
            author = "ChrisRLillo",
            type = FLOOD_FROSTBITE,						
            startPos = { x = -12805, y = 700, z = -14450, yaw = -0x4000, airborne = true },	
            floodScale = 2,					
            overrideName = "Cool, Cool Mountain (Beta)",			
        },
        {
            name = "ddd",
            level = LEVEL_DDD,
            area = 6,
            flagPos = { x = 3262, y = 4863, z =   4790, yaw =  0x0000 },			
            flagBase = true,			
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_SNOW,						
            startPos = { x =  1435, y = 1025, z =  24850, yaw =  0x8000, airborne = true },	
            floodScale = 2.5,				
            overrideName = "Snowman's Land (Beta)",			
        },
        {
            name = "wdw6",
            level = LEVEL_WDW,
            area = 2,
            flagPos = { x = -3290, y = 3080, z = 145, yaw =  0x0000 },			
            speed = 2.75,
            author = "ChrisRLillo",
            type = FLOOD_FROSTBITE,						
            startPos = { x =  1435, y = 1470, z =  24850, yaw =  0x8000, airborne = true },		
            floodScale = 2,				
            overrideName = "Snowman's Darkness",	
            floodHeight = -900			
        },
        {
            name = "wdw7",
            level = LEVEL_WDW,
            area = 5,
            flagPos = { x = 570, y = 6480, z = 7490, yaw =  0x8000 },			
            flagBase = true,			
            speed = 5.5,
            author = "ChrisRLillo",
            type = FLOOD_SNOW,						
            startPos = { x =  0, y = 5835, z = -2265, yaw = 0x0000, airborne = true },				
            overrideName = "Chief Chilly's Ring",	
            floodScale = 2.5			
        },
        {
            name = "pss5",
            level = LEVEL_PSS,
            area = 6,
            flagPos = { x = 13085, y = 3430, z = 17080, yaw = 0x8000 },			
            flagBase = true,			
            speed = 1.5,
            author = "ChrisRLillo",
            type = FLOOD_SNOW,						
            startPos = { x = -11010, y = 1365, z = -6445, yaw = 0x4000, airborne = true },		
            floodScale = 2,				
            overrideName = "Dead Village",	
			floodHeight = -500,
        },
        {
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -6670, y =   6635, z = -13125, yaw = 0x4000 },			
            flagBase = true,			
            speed = 3.5,
            author = "ChrisRLillo",
            type = FLOOD_DARKNESS,						
            startPos = { x = -6941, y = -4484, z = 5295, yaw = 0x8000, airborne = true },			
            floodScale = 3,				
            overrideName = "Big Boo's Haunted Forest",	
            overrideSlide = true			
        },
        {
            name = "ttc2",
            level = LEVEL_TTC,
            area = 5,
            flagPos = { x = 3620, y = 1315, z = -880, yaw = 0x8000 },			
            flagBase = true,			
            speed = 1.0,
            author = "ChrisRLillo",
            type = FLOOD_DARKNESS,						
            startPos = { x = 12465, y = 230, z = -2265, yaw = 0x8000, airborne = true },	
            floodScale = 2,				
            overrideName = "Big Boo's Fortress",	
        },
        {
            name = "hmc3",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = -2379, y = 2810, z = -6216, yaw = 0x0000 },					
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,						
            startPos = { x = -4316, y = 2161, z = 8956, yaw = 0x8000, airborne = true },			
            overrideName = "Hazy Maze Cave (Empty)",		
            floodHeight = -500,			
            unwantedBhvs = { id_bhvExclamationBox }					
        },
        {
            name = "hmc4",
            level = LEVEL_HMC,
            area = 6,
            flagPos = { x = 8916, y = 2268, z = -11680, yaw = 0x0000 },			
            flagBase = true,			
            speed = 1.5,
            author = "ChrisRLillo",
            type = FLOOD_MUD,				
            floodScale = 3,					
            overrideName = "Cave City",	
            floodHeight = -2185,				
        },
        {
            name = "lll2",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -5415, y = 6239, z = -9797, yaw = 0x4000 },			
            flagBase = true,			
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_LAVA,					
            floodScale = 3,					
            overrideName = "Blazing Bully Base",	
			floodHeight = -1750,			
            unwantedBhvs = { id_bhvExclamationBox }				
        },
        {
            name = "lll3",
            level = LEVEL_LLL,
            area = 5,
            flagPos = { x = 2452, y = 1435, z = -1870, yaw = 0x0000 },			
            flagBase = true,			
            speed = 5.0,
            author = "ChrisRLillo",
            type = FLOOD_LAVA,	
            floodScale = 1.5,					
            overrideName = "Fire Bubble (B-Roll)",			
        },
        {
            name = "lll4",
            level = LEVEL_LLL,
            area = 3,
            flagPos = { x = 6963, y = 6195, z = 4680, yaw = 0x0000},			
            flagBase = true,			
            speed = 1.5,
            author = "ChrisRLillo",
            type = FLOOD_SULFUR,				
            startPos = { x = -11211, y = 436, z = 12663, yaw =  0x8000, airborne = true },	
            floodScale = 2,					
            overrideName = "Blazing Bully Base",	
        },
        {
            name = "hmc5",
            level = LEVEL_HMC,
            area = 4,
            flagPos = { x = 31162, y = 2125, z = -2942, yaw = -0x4000 },			
            flagBase = true,			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_SULFUR,		
            floodScale = 2.5,				
            overrideName = "Lethal Cavern",		
            unwantedBhvs = { id_bhvExclamationBox }				
        },
        {
            name = "ssl2",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = 1725, y =   2829, z = -16152, yaw = 0x0000 },			
            flagBase = true,			
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_DESERT,		
            startPos = { x = -5033, y = -485, z = -8143, yaw = 0x0000 , airborne = true },	
            floodScale = 2,				
            overrideName = "Desert Maze",			
        },
        {
            name = "ssl3",
            level = LEVEL_SSL,
            area = 2,
            flagPos = { x = -6096, y = 4155, z = -20608, yaw = 0x0000 },		
            flagBase = true,				
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_SAND,			
            floodScale = 2.5,				
            overrideName = "Shifted Sand Land",		
            unwantedBhvs = { id_bhvGrindel, id_bhvExclamationBox }				
        },
        {
            name = "ssl4",
            level = LEVEL_SSL,
            area = 4,
            flagPos = { x = 1280, y =   2435, z = -10145, yaw =  0x0000},				
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_SAND,					
            startPos = { x = 7520, y = 865, z = -740, yaw = -0x4000, airborne = true },	
            floodScale = 2,				
            overrideName = "Eyerok's Tomb",		
        },
        {
            name = "ssl5",
            level = LEVEL_SSL,
            area = 5,
            flagPos = { x = 16640, y = 3720, z = 7275, yaw = -0x4000 },			
            flagBase = true,			
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_SAND,								
			floodScale = 3,	
            overrideName = "Sandy Skyloft",			
        },
        {
            name = "ssl6",
            level = LEVEL_SSL,
            area = 5,
            flagPos = { x = -21500, y = 210, z = -2795, yaw = 0x4000 },			
            flagBase = true,			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_SAND,		
            startPos = { x = -2880, y = -1500, z = 80, yaw = -0x6000, airborne = true },		
			floodScale = 3,				
            overrideName = "Sandy Sky Road",		
            unwantedBhvs = { id_bhvExclamationBox }							
        },
        {
            name = "ending",
            level = LEVEL_ENDING,
            area = 6,
            flagPos = { x = -1080, y = 4095, z = -355, yaw = 0x6000 },					
            speed = 2.75,
            author = "ChrisRLillo",
            type = FLOOD_WATER,						
            overrideName = "Wet-Dry World (Beta)",	
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe }							
        },
        {
            name = "bbh4",
            level = LEVEL_BBH,
            area = 6,
            flagPos = { x = 2945, y = 6080, z = 2282, yaw = -0x6000 },						
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,						
            startPos = { x = -2310, y = 2780, z = 4270, yaw = 0x4000, airborne = true },				
            overrideName = "Vanish Cap Under The Moat (Beta)",		
        },
        {
            name = "pss6",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -290, y = -2270, z = -1580, yaw = 0x0000 },					
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_DARKNESS,									
            overrideName = "Dark Downtown",				
			floodHeight = -6500,
        },
        {
            name = "sa6",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = 1560, y = 2000, z = -3300, yaw = 0x0000 },			
            flagBase = true,			
            speed = 1.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,						
			floodScale = 4,				
            overrideName = "Dry Town",	
        },
        {
            name = "sa6",
            level = LEVEL_ENDING,
            area = 1,
            flagPos = { x = -10, y =   3040, z = -11230, yaw =  0x0000 },			
            flagBase = true,			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,			
            startPos = { x = 3670, y = 315, z = 11110, yaw =  0x8000, airborne = true },		
			floodScale = 2,				
            overrideName = "Flooded Town",		
            unwantedBhvs = { id_bhvBubba }							
        },
        {
            name = "hmc6",
            level = LEVEL_HMC,
            area = 7,
            flagPos = { x = 972, y = 5694, z = -1734, yaw = -0x2000 },			
            flagBase = true,			
            speed = 5.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,							
            overrideName = "Click Clock Climb",		
        },
        {
            name = "cotmc7",
            level = LEVEL_COTMC,
            area = 3,
            flagPos = { x = -1841, y = 6530, z = -1815, yaw = 0x2000 },					
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_DARKNESS,					
            startPos = { x = -811, y = -4452, z = -49, yaw = -0x20000, airborne = true },					
            overrideName = "Sinister Clockwork",
            unwantedBhvs = { id_bhvWarpPipe },			
            capTimer = 1			
        },
        {
            name = "sl",
            level = LEVEL_SL,
            area = 3,
            flagPos = { x = 1280, y = 10290, z = 4855, yaw =  0x8000 },			
            flagBase = true,			
            speed = 3.5,
            author = "ChrisRLillo",
            type = FLOOD_CLOUDS,					
            startPos = { x = 750, y = 2570, z = -12240, yaw = 0x0000, airborne = true },	
			floodScale = 3,				
            overrideName = "Wing Cap By The Rainbow Highway",		
        },
        {
            name = "sl2",
            level = LEVEL_SL,
            area = 5,
            flagPos = { x = -1580, y = 2430, z = -9590, yaw = -0x6000},			
            flagBase = true,			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_CLOUDS,				
			floodScale = 3,				
            overrideName = "Rainbow Ride (Beta)",
			floodHeight = -2750,
        },
        {
            name = "sa7",
            level = LEVEL_SA,
            area = 4,
            flagPos = { x = -80, y = 6500, z = -5700, yaw = 0x0000 },						
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_CLOUDS,					
            startPos = { x = 0, y = -1900, z = -12700, yaw = 0x00000, airborne = true },
			floodScale = 2,				
            overrideName = "Sky-High Pathway",			
        },
        {
            name = "hmc7",
            level = LEVEL_HMC,
            area = 2,
            flagPos = { x = 28853, y = 2632, z = -495, yaw = -0x4000 },			
            flagBase = true,			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,					
            startPos = { x = -21870, y = -1306, z = 114, yaw = 0x4000, airborne = true },	
			floodScale = 3.5,				
            overrideName = "Tick Tock Blocks",				
        },
        {
            name = "lll5",
            level = LEVEL_LLL,
            area = 4,
            flagPos = { x = 300, y = 17455, z = 90, yaw = -0x6000 },			
            flagBase = true,			
            speed = 4.5,
            author = "ChrisRLillo",
            type = FLOOD_LAVA,										
            overrideName = "Infernal Tower",
        },
        {
            name = "vcutm3",
            level = LEVEL_VCUTM,
            area = 3,
            flagPos = { x = -12045, y = 2300, z = -1950, yaw = 0x8000 },			
            flagBase = true,			
            speed = 1.5,
            author = "ChrisRLillo",
            type = FLOOD_POISON,				
            startPos = { x = 2780, y = 460, z = 8350, yaw = -0x4000, airborne = true },	
			floodScale = 4,				
            overrideName = "Randomized Realm",
			floodHeight = -2250,
            unwantedBhvs = { id_bhvExclamationBox, id_bhvWarpPipe },						
			capTimer = 1
        },
        {
            name = "bowser3",
            level = LEVEL_BOWSER_3,
            area = 1,
            flagPos = { x = 90, y = -3735, z = 29800, yaw = 0x8000 },			
            flagBase = true,			
            speed = 1.5,
            author = "ChrisRLillo",
            type = FLOOD_LAVA,				
            startPos = { x = -60, y = -4290, z = -7730, yaw =  0x0000, airborne = true },		
			floodScale = 3,				
            overrideName = "Eternal Fort (Beta)",	
			floodHeight = -6750,
        },
        {
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = 10, y = 840, z = -2240, yaw =  0x0000 },			
            flagBase = true,			
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            startPos = { x = 25, y = 390, z = -14135, yaw = 0x0000, airborne = true },				
            overrideName = "Castle Grounds (Beta)",			
        },
        {
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 7,
            flagPos = { x = -4110, y = 1285, z = -19845, yaw = 0x0000 },			
            flagBase = true,			
            speed = 3.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            startPos = { x = -4180, y = -825, z = -1495, yaw = 0x8000, airborne = true },	
			floodScale = 2.5,				
            overrideName = "Uncanny Courtyard (Windy)",			
        },
        {
            name = "rr3",
            level = LEVEL_RR,
            area = 5,
            flagPos = { x = 4108, y = 351, z = -755, yaw = -0x4000 },				
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,							
            overrideName = "Balcony",				
			floodHeight = -750,
        },
        {
            name = "wmotr4",
            level = LEVEL_WMOTR,
            area = 5,
            flagPos = { x = 15560, y = -1315, z = -23205, yaw = 0x0000 },			
            flagBase = true,			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            startPos = { x = 15400, y = -1075, z = -2635, yaw = 0x8000, airborne = true },			
			floodScale = 4,				
            overrideName = "Castle Garden",		
        },
        {
            name = "cg2",
            level = LEVEL_CASTLE_GROUNDS,
            area = 5,
            flagPos = { x = 71, y =   -287, z = -19725, yaw =  0x0000 },			
            flagBase = true,			
            speed = 0.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            startPos = { x = -10502, y = -990, z = 17836, yaw = 0x8000, airborne = true },			
			floodScale = 4,				
            overrideName = "Genesis Basement",	
        },
        {
            name = "bitfs2",
            level = LEVEL_BITFS,
            area = 5,
            flagPos = { x = 60, y = -165, z = -1710, yaw = 0x0000 },			
            flagBase = true,			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            startPos = { x = -6655, y = 80, z = -7955, yaw =  0x0000, airborne = true },				
            overrideName = "Funhouse",		
			floodHeight = -2250,
        },
        {
            name = "ttc3",
            level = LEVEL_TTC,
            area = 7,
            flagPos = { x = 6847, y = 629, z = -12573, yaw =  0x8000},			
            flagBase = true,			
            speed = 1.25,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
            startPos = { x = -332, y = -1571, z = 16141, yaw =  0x8000, airborne = true },		
			floodScale = 3,				
            overrideName = "Bowser's Floor / Peach's Floor",	
        },
        {
            name = "vcutm4",
            level = LEVEL_VCUTM,
            area = 2,
            flagPos = { x = -12045, y = 1690, z = 3195, yaw = 0x8000 },			
            flagBase = true,			
            speed = 1.25,
            author = "ChrisRLillo",		
            type = FLOOD_WATER,							
			floodScale = 3,	
            overrideName = "Floor 2B",	
            capTimer = 1			
        },
        {
            name = "wf3",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -1067, y = 216, z = -28448, yaw = 0x0000 },			
            flagBase = true,			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_DARKNESS,			
            startPos = { x = 15978, y = -684, z = -11889, yaw = -0x4000, airborne = true },	
			floodScale = 3,				
            overrideName = "Cryptic Hideout",					
        },
        {
            name = "ending2",
            level = LEVEL_ENDING,
            area = 2,
            flagPos = { x = -840, y = -1070, z = 13785, yaw = 0x8000 },			
            flagBase = true,			
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,			
            startPos = { x = -735, y = -1890, z = -11195, yaw =  0x0000, airborne = true },		
			floodScale = 2,				
            overrideName = "Underground Passegeway",	
        },
        {
            name = "sl3",
            level = LEVEL_SL,
            area = 6,
            flagPos = { x = -30595, y = 1075, z = -7330, yaw = 0x0000},			
            flagBase = true,			
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,			
            startPos = { x = -18630, y = -3470, z = -5875, yaw = -0x4000, airborne = true },		
			floodScale = 4,				
            overrideName = "Vanish Cap Within The Plexus",		
        },
        {
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 4,
            flagPos = { x = -4280, y = 4600, z = 2810, yaw = 0x4000},			
            flagBase = true,			
            speed = 4.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,			
            startPos = { x = 0, y = 300, z = 0, yaw = 0x8000 , airborne = true },		
			floodScale = 3,				
            overrideName = "Plexal Upstairs",		
			capTimer = 1
        },
        {
            name = "ttc4",
            level = LEVEL_TTC,
            area = 3,
            flagPos = { x = -27077, y = 288, z = 4884, yaw = 0x4000 },			
            flagBase = true,			
            speed = 1.5,
            author = "ChrisRLillo",
            type = FLOOD_WATER,				
			floodScale = 3,	
            startPos = { x = 13190, y = -749, z = -1920, yaw = 0x8000, airborne = true },				
            overrideName = "Plexal Lobby",	
			floodHeight = -1640
        },
        {
            name = "ccm3",
            level = LEVEL_CCM,
            area = 5,
            flagPos = { x = 1849, y = 756, z = -8186, yaw = 0x0000},			
            flagBase = true,			
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_DARKNESS,				
            overrideName = "Holy Yellow Switch Palace",
        },
        {
            name = "bitdw4",
            level = LEVEL_BITDW,
            area = 2,
            flagPos = { x = 1455, y = 249, z = -28049, yaw = 0x0000},					
            speed = 2.5,
            author = "ChrisRLillo",
            type = FLOOD_DARKNESS,				
			floodScale = 3,				
            overrideName = "Uncanny Courtyard",		
        },
        {
            name = "thi4",
            level = LEVEL_THI,
            area = 6,
            flagPos = { x = 2342, y = 0, z = -17514, yaw = 0x0000},					
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_DARKNESS,		
			floodScale = 2,				
            overrideName = "Hallway To Peach's Cell",			
        },
        {
            name = "thi5",
            level = LEVEL_THI,
            area = 7,
            flagPos = { x = 2320, y = 0, z = -22680, yaw = 0x0000},					
            speed = 3.0,
            author = "ChrisRLillo",
            type = FLOOD_DARKNESS,				
            startPos = { x = 2310, y = 150, z = -13360, yaw = 0x8000, airborne = true },	
			floodScale = 2.5,				
            overrideName = "Peach's Cell",		
        },
        {
            name = "cc2",
            level = LEVEL_CASTLE_COURTYARD,
            area = 4,
            flagPos = { x = 805, y = 1920, z = -6930, yaw = 0x0000},					
            speed = 4.0,
            author = "ChrisRLillo",
            type = FLOOD_POISON,		
            startPos = { x = 85, y = -3160, z = 7025, yaw = 0x8000, airborne = true },				
            overrideName = "Purple Upstairs",	
        },
        {
            name = "sl4",
            level = LEVEL_SL,
            area = 2,
            flagPos = { x = -390, y = -965, z = -12645, yaw = 0x0000, yaw =  0x0000},		
            flagBase = true,			
            speed = 2.0,
            author = "ChrisRLillo",
            type = FLOOD_DARKNESS,				
            startPos = { x = -1525, y = -880, z = 5915, yaw = 0x8000, airborne = true },				
            overrideName = "Haunted Castle Grounds",				
            floodHeight = -2575,	
            floodScale = 2			
        }
    }
end

-- Star Revenge 7: Park of Time, ported to Flood by ★~¡TOÑO!~★
local function flood_load_star_revenge_7_levels()
    game = GAME_STAR_REVENGE_7
    romhackInfo = "Star Revenge 7: Park of Time"
    romhackLogo = get_texture_info("logo_sr7")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = 2840, y = -1665, z = 920, yaw = 0x6000},
            unwantedBhvs = { id_bhvExclamationBox },
            music = { name = "Leaf Forest (Beta) - Sonic Advance 2" },
            pipes = {
                {
                    { x = 2850, y = -1814, z = -2445 },
                    { x = 2850, y = 495, z = -3195, yaw = 0x0000 }
                }
            }
        },
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 2505, y = -2655, z = 360, yaw = -0x4000},
            music = { name = "Gruntilda's Lair - Banjo-Kazooie" }			
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = 285, y = -2400, z = 4280, yaw = -0x4000},
            music = { name = "Fortress - New Super Mario Bros. Wii" }				
        },
        [4] = {
            level = LEVEL_VCUTM,
            area = 1,
            spawn = {x = -12250, y = -1275, z = -10205, yaw = 0x4000},
            music = { name = "None" }			
        },
        [5] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = -900, y = 1439, z = 0, yaw = 0x4000},
            music = { name = "Never Let Up! - Mario & Luigi: Dream Team" },			
            pipes = {
                {
                    { x = -10, y = 1439, z = 0, yaw = -0x4000 },
                    { x = 4045, y = 989, z = -3880, yaw = 0x6000 }
                },
                {		
                    { x = 5940, y = 2190, z = -5775, yaw = 0x0000 },
                    { x = 1910, y = 389, z = 5515, yaw = 0x6000 }
                },
                {		
                    { x = 3030, y = 389, z = 4390, yaw = -0x2000 },
                    { x = -5840, y = 689, z = 0, yaw = 0x4000 }
                }
            }
        },
        [6] = {
            level = LEVEL_BOWSER_2,
            area = 1,
            spawn = {x = 389, y = 1470, z = 0, yaw = -0x4000},
            unwantedBhvs = { id_bhvChuckya },
            music = { name = "Boss - Kirby 64: The Crystal Shards" },			
            pipes = {
                {
                    { x = -4380, y = 1470, z = 0, yaw = 0x0000 },
                    { x = 6380, y = 975, z = 0, yaw = 0x4000 }
                }
            }			
        },
        [7] = {
            level = LEVEL_BITS,
            area = 1,
            spawn = {x = 403, y = -426, z = 520, yaw = -30220},
            music = { name = "Shadow Queen Battle Part 2 - Paper Mario: The Thousand-Year Door" }			
        }
    }

    gLevels = {
        {	
            name = "bob",
            level = LEVEL_BOB,
            area = 1,
            flagPos = { x = 3370, y =  1170, z =  3980, yaw = -0x6000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_TIDE,		
            startPos = { x = 3180, y = -1155, z = 2825, yaw = 0x8000, airborne = true },
            floodScale = 2,
            music = { name = "Overworld - New Super Mario Bros. Wii U" }			
        },
        {						
            name = "wf",
            level = LEVEL_WF,
            area = 1,
            flagPos = { x = -4155, y =  1765, z = 3230,  yaw = 0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_WATER,	
            startPos = { x = -6725, y = -1685, z = -210, yaw = 0x0000, airborne = false },
            music = { name = "Blanco Hills - Super Mario Sunshine" } 			
        },
        {						
            name = "jrb",
            level = LEVEL_JRB,
            area = 1,
            flagPos = { x = 9505, y =  2535, z = 1790,  yaw =  0x8000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_WATER,	
            startPos = { x = -7820, y = -1440, z = 11955, yaw = 0x0000, airborne = true },		
            floodScale = 2.5,
            music = { name = "March Ahead - Paper Mario" }			
        },
        {						
            name = "ccm",
            level = LEVEL_CCM,
            area = 1,
            flagPos = { x = -795,  y =  1990, z = -3850, yaw =  0x0000 },
            flagBase = true,
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_WATER,		
            startPos = { x = -5195, y = -3210, z = -8140, yaw = 0x4000, airborne = true },
            floodScale = 2,
            music = { name = "Creppy Castle - Donkey Kong 64" }			
        },
        {						
            name = "bbh",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = -5800,  y = 180, z = -1345, yaw = 0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_WATER,
            floodScale = 2,
            floodHeight = -2355,
            music = { name = "Crytal Caves - Donkey Kong 64" }
        },
        {						
            name = "bbh2",
            level = LEVEL_BBH,
            area = 1,
            flagPos = { x = 4950, y = 250, z = 5000, yaw = 20780 },
            flagBase = true,
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_FROSTBITE,
            startPos = { x = 9210, y = -625, z = -6210, yaw = 0x0000, airborne = true },			
            floodScale = 2,
            overrideName = "Frostbite Cave",
            pipes = {
                {
                    { x = 5970, y = -1110, z = -1230 },
                    { x = 12875, y = -724, z = 4320, yaw = -0x4000 }
                }
            },
            music = { name = "Ice Mountain Zone Act 1 - Sonic Advance" }			
        },
        {						
            name = "pss",
            level = LEVEL_PSS,
            area = 1,
            flagPos = { x = -12845, y = 6625, z = 15360, yaw =  0x8000 },
            flagBase = true,
            speed = 5.0,
            author = "BroDute",
            type = FLOOD_TIDE,		
            startPos = { x = 13585, y = -4475, z = -10705, yaw = -0x4000, airborne = true },	
            floodScale = 3,			
            launchpads = {
                { x = 6440, y = -3200, z = -10410, yaw = -0x4000, vel = 90, forwardVel = 0 },
                { x = 11845, y = -4475, z = -10705, yaw = -0x4000, vel = 120, forwardVel = 0 }				
            },			
            overrideSlide = true,
            music = { name = "Stage 3 - Kirby's Block Ball" }			
        },
        {						
            name = "bitdw",
            level = LEVEL_BITDW,
            area = 1,
            flagPos = { x = 5430, y =  4005, z = -3380, yaw = -0x2000 },
            flagBase = true,
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_WATER,		
            floodScale = 1.5,
            unwantedBhvs = { id_bhvWarpPipe },
            pipes = {
                {
                    { x = -5149, y = -2295, z = 2868, yaw = -0x6000 },
                    { x = -5149, y = -2295, z = 2868, yaw = -0x6000 }				
                }
            },
            music = { name = "Dragon Roost Island - The Legend Of Zelda: The Wind Water" }			
        },
        {						
            name = "b1",
            level = LEVEL_BOWSER_1,
            area = 1,
            flagPos = { x = -10, y = 1440, z = 0, yaw = -0x4000 },
            flagBase = true,
            speed = 15,
            author = "BroDute",
            type = FLOOD_WATER,		
            floodScale = 2,		
            overrideName = "Rainbob-Omb Van Color",
            music = { name = "Never Let Up! - Mario & Luigi: Dream Team" }
        },
        {						
            name = "hmc",
            level = LEVEL_HMC,
            area = 1,
            flagPos = { x = 1755, y =  1950, z =  8220, yaw =  0x4000 },
            flagBase = true,
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_POISON,		
            startPos = { x = -2190, y = -2020, z = 6530, yaw = 0x6000, airborne = true },
            music = { name = "Lower Norfair - Super Metroid" }			
        },
        {						
            name = "lll",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = 8445, y = 600, z = -3020, yaw = 0x8000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_MAGMA,	
            startPos = { x = 13910, y = -1972, z = -5490, yaw = 0x0000, airborne = true },	
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe },			
            music = { name = "Piranha Creeper Creek - Super Mario 3D World" }
        },
        {						
            name = "lll2",
            level = LEVEL_LLL,
            area = 1,
            flagPos = { x = -8445, y = 600, z = -3020, yaw = -0x8000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_LAVA,	
            startPos = { x = -7875, y = -2335, z = 4910, yaw = 0x6000, airborne = true },	
            floodScale = 2,
            unwantedBhvs = { id_bhvWarpPipe, id_bhvFloorSwitchHiddenObjects },
            overrideName = "Land Of The Erupted Volcano",			
            music = { name = "Piranha Creeper Creek - Super Mario 3D World" }	
        },
        {						
            name = "ssl",
            level = LEVEL_SSL,
            area = 1,
            flagPos = { x = -7315, y = 2850, z = 230, yaw =  0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_ACID,
            unwantedBhvs = { id_bhvMadPiano },
            floodScale = 2,			
            launchpads = {
                { x = -4250, y = -1200, z = 7695, yaw = -0x6000, vel = 100, forwardVel = 90, capTimer = 135 },
            },
            music = { name = "Mad Monster Mansion - Banjo-Kazooie" }			
        },
        {						
            name = "ddd",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = 3310, y = 2595,  z = -5380, yaw =  0x0000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_DESERT,			
            startPos = { x = 11590, y = -2540, z = -2895, yaw = 0x0000, airborne = true },				
            floodScale = 2,
            music = { name = "Dry Dry Ruins Quest - Paper Mario" }		
        },
        {						
            name = "ddd2",
            level = LEVEL_DDD,
            area = 1,
            flagPos = { x = -13280, y =  885,  z = -4850, yaw = 0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_SAND,					
            startPos = { x = -2820, y = 1655, z = -575, yaw = -0x6000, airborne = true },
            overrideName = "The Old Pyramid",			
            floodHeight = -1365,
            floodScale = 2,
            music = { name = "Dry Dry Ruins Quest - Paper Mario" }
        },
        {						
            name = "cotmc",
            level = LEVEL_COTMC,
            area = 1,
            flagPos = { x = -500, y = 2005,  z = -1840, yaw = -0x4000 },
            flagBase = true,
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_TIDE,		
            startPos = { x = -5520, y = -2045, z = 2505, yaw = 0x4000, airborne = true },		
            floodScale = 2,
            music = { name = "Purple Comet - Super Mario Galaxy" }
        },
        {						
            name = "bitfs",
            level = LEVEL_BITFS,
            area = 1,
            flagPos = { x = 1390, y = 4375, z = 5640,  yaw = 0x8000 },
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_POISON,	
            floodScale = 2.5,
            floodHeight = -1000,
            unwantedBhvs = { id_bhvWarpPipe },			
            pipes = {
                {
                    { x = -6219, y = 859, z = 8408, yaw = 0x8000 },
                    { x = -6219, y = 859, z = 8408, yaw = 0x8000 }
                }
            },
            music = { name = "Rainbow Factory - Wooden Toaster" }			
        },
        {						
            name = "b2",
            level = LEVEL_BOWSER_2,
            area = 1,
            flagPos = { x = -1995, y = 1470, z = -15,  yaw =  0x4000 },
            flagBase = true,
            speed = 8.0,
            author = "BroDute",
            type = FLOOD_POISON,				
            floodScale = 2.5,	
            floodHeight = -1000,		
            overrideName = "Swag Whomp and Weegees",
            music = { name = "Boss - Kirby 64: The Crystal Shards" }
        },
        {						
            name = "wmotr",
            level = LEVEL_WMOTR,
            area = 1,
            flagPos = { x = -11490, y = -2086, z = 4005, yaw = 0x4000 },
            flagBase = true,
            speed = 1.75,
            author = "BroDute",
            type = FLOOD_DARKNESS,
            floodScale = 2.5,
            unwantedBhvs = { id_bhvKoopa },
            overrideName = "BroDute's Sky Heigh Racetrack",
            floodHeight = -5800,
            music = { name = "Waluigi Pinball - Mario Kart DS" }			
        },
        {						
            name = "sl",
            level = LEVEL_SL,
            area = 1,
            flagPos = { x = -9610,   y = 1845, z = 2745,  yaw = 0x2000 },
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_MAGMA,		
            startPos = { x = -325, y = -3025, z = 7410, yaw = -0x6000, airborne = true },	
            floodScale = 2,
            music = { name = "Thwomp Volcano - Mario & Luigi Partners in Time | 2nd Music: Thwomp Caverns - Mario & Luigi Partners in Time" }			
        },
        {						
            name = "wdw",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = 7070, y = -2390, z = -6300, yaw = -0x4000 },
            speed = 1.0,
            author = "BroDute",
            type = FLOOD_SNOW,
            floodScale = 2.5,
            unwantedBhvs = { id_bhvFadingWarp },			
            music = { name = "Snowhead - The Legend of Zelda Majora's Mask" }
        },
        {						
            name = "wdw2",
            level = LEVEL_WDW,
            area = 1,
            flagPos = { x = -13545, y = 450, z = 3750, yaw = -0x4000 },
            speed = 2.0,
            author = "BroDute",
            type = FLOOD_FROSTBITE,	
            startPos = { x = -7490, y = -2845, z = -6150, yaw = 0x4000, airborne = true },
            floodScale = 2.5,
            unwantedBhvs = { id_bhvFadingWarp },			
            overrideName = "Dark Temple Of Time",
            floodHeight = -5250,
            launchpads = {
                { x = -4395, y = -3300, z = 1805, yaw = 0x0000, vel = 90, forwardVel = 0 },
            },			
            music = { name = "Snowhead - The Legend of Zelda Majora's Mask" }	
        },
        {						
            name = "ttm",
            level = LEVEL_TTM,
            area = 1,
            flagPos = { x = 9540, y = 3250, z = -2150, yaw = 0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_CLOUDS,
            floodScale = 2,			
            floodHeight = -4380,
            pipes = {
                {
                    { x = -8035, y = -1510, z = 2820 },
                    { x = -6830, y = -1510, z = 2640, yaw = 0x6000 }
                }
            },
            music = { name = "The Capital City of Flowers in the Sky - Touhou 7: Perfect Cherry Blossom" }			
        },
        {						
            name = "thi",
            level = LEVEL_THI,
            area = 1,
            flagPos = { x = 9590, y =  3390, z = -1830, yaw = -0x4000 },
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,	
            floodScale = 2,
            music = { name = "Bad Apple - Touhou 4: Lotus Land Story" }
        },
        {						
            name = "rr",
            level = LEVEL_RR,
            area = 1,
            flagPos = { x = 3910,  y =  4315, z =  7045, yaw =  0x0000 },
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_RAINBOW,				
            startPos = { x = -870, y = -2503, z = -2840, yaw = 0x0000, airborne = true },	
            floodScale = 2,
            music = { name = "Rainbow Road - Mario Kart 64" }			
        },
        {						
            name = "totwc",
            level = LEVEL_TOTWC,
            area = 1,
            flagPos = { x = -1285, y = 2580,  z = 105, yaw =  0x4000 },
            speed = 1.5,
            author = "BroDute",
            type = FLOOD_WATER,	
            floodScale = 2.5,			
            overrideName = "Super Mario Bros. 3 World 1-1",
            floodHeight = -2680,
            music = { name = "Overworld - Super Mario Bros. 3" }			
        },
        {						
            name = "ttc",
            level = LEVEL_TTC,
            area = 1,
            flagPos = { x = -4980, y = 510, z = -7120, yaw = 0x0000 },
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_MOLTEN,	
            floodScale = 2,
            floodHeight = -8480,
            unwantedBhvs = { id_bhvDoorWarp },
            music = { name = "Lorule Castle (Part 1 & 2) - The Legend Of Zelda: A Link Between Worlds" }			
        },
        {						
            name = "sa",
            level = LEVEL_SA,
            area = 1,
            flagPos = { x = -215,  y = 4650,  z = -910,  yaw = 0x4000 },
            flagBase = true,
            speed = 2.5,
            author = "BroDute",
            type = FLOOD_MOLTEN,				
            startPos = { x = -190, y = -3750, z = -3600, yaw = 0x8000, airborne = true },	
            unwantedBhvs = { id_bhvWarpPipe },
            music = { name = "Lorule Castle (Part 3) - The Legend Of Zelda: A Link Between Worlds" }	
        },
        {						
            name = "cg",
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            flagPos = { x = -6810, y = 610,   z = 2425,  yaw =  0x8000 },
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_TIDE,
            unwantedBhvs = { id_bhvWarpPipe },			
            overrideName = "Water Lands",
            music = { name = "Leaf Forest (Beta) - Sonic Advance 2" }
        },
        {						
            name = "cc",
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            flagPos = { x = -3160, y = 1155, z = 170,  yaw =  0x4000 },
            speed = 4.0,
            author = "BroDute",
            type = FLOOD_POISON,		
            floodHeight = -3560,	
            unwantedBhvs = { id_bhvWarpPipe },				
            overrideName = "Mixed Styles",			
            launchpads = {
                { x = 620, y = -1605, z = 3950, yaw = 0x0000, vel = 175, forwardVel = 0 },
            },
            music = { name = "Gruntilda's Lair - Banjo-Kazooie" }
        },
        {	
            name = "c",
            level = LEVEL_CASTLE,
            area = 1,
            flagPos = { x = 1640, y = 2100, z = -3930,  yaw =  0x0000 },
            flagBase = true,
            speed = 3.0,
            author = "BroDute",
            type = FLOOD_DARKNESS,		
            floodScale = 2,	
            unwantedBhvs = { id_bhvWarpPipe },		
            overrideName = "Endless Heights",		
            launchpads = {
                { x = -3390, y = -1950, z = 5290, yaw = 0x0000, vel = 120, forwardVel = 0 },
            },
            music = { name = "Fortress - New Super Mario Bros. Wii" }	
        }
    }
end


-- Luigi's Mansion 64.5 [Super Player Mode], ported to Flood by ★~¡TOÑO!~★
local function flood_load_luigis_mansion_64_super_player_mode_levels()
    game = GAME_LUIGIS_MANSION_64_5_SUPER_MODE
    romhackInfo = "Luigi's Mansion 64.5 [Super Player Mode]"
	romhackLogo = get_texture_info("logo_lm64.5")
    gLobbies = {
        [1] = {
            level = LEVEL_CASTLE_GROUNDS,
            area = 1,
            spawn = {x = -1328, y = 260, z = 4663, yaw = 0x8000},
            overrideWater = true
        },
        [2] = {
            level = LEVEL_CASTLE_COURTYARD,
            area = 1,
            spawn = {x = 0, y = 0, z = 0, yaw = 0x8000}
        },
        [3] = {
            level = LEVEL_CASTLE,
            area = 1,
            spawn = {x = -1022, y = -50, z = 745, yaw = 0x8000}
        },
        [4] = {
            level = LEVEL_CASTLE,
            area = 2,
            spawn = {x = 665, y = 1203, z = 2303, yaw = 0x8000}
        },
        [5] = {
            level = LEVEL_CASTLE,
            area = 3,
            spawn = {x = -1123, y = -1074, z = 1336, yaw = 0x0000}
        },
        [6] = {
            level = LEVEL_THI,
            area = 3,
            spawn = {x = 1252, y = 1024, z = -611, yaw = -15123}
        },
        [7] = {
            level = LEVEL_THI,
            area = 3,
            spawn = {x = 5, y = 1843, z = 3, yaw = 423}
        },
        [8] = {
            level = LEVEL_TOTWC,
            area = 1,
            spawn = {x = -10, y = -2047, z = 584, yaw = 32729}
        },
        [9] = {
            level = LEVEL_SSL,
            area = 3,
            spawn = {x = 0, y = -1534, z = -2059, yaw = 0x8000}
        },
        [10] = {
            level = LEVEL_BOWSER_1,
            area = 1,
            spawn = {x = 0, y = 307, z = 0, yaw = 0x8000}
        },
        [11] = {
 