-- Rules mod made by Kaje

-- false: Window won't close when mouse hovers over the OK button, only Buttons work
-- true: Window will close when mouse hovers over the OK button, alternatively buttons work too
CLOSE_ON_MOUSE_HOVER = true

-- text-related options
-- sets font, scale (of text) and color for all texts;
globalFont = FONT_MENU
scale = 0.5
color = "#DCDCDC"

local switched = true
local hasConfirmed = false
function displayrules(m)		
    hostnum = network_local_index_from_global(0)
    host = gNetworkPlayers[hostnum]

    -- texts are written inside here.
    --[[ format: 
    {
        string, 
        x, 
        y, 
        font, 
        scale, 
        color (color in "#xxxxxx" format pls)
    }
--]]
    texts = {
        {
            "- Flood               -", 0, -390, globalFont, 0.7, color
        },
        {
            "RomHack", 45, -390, globalFont, 0.7, "#ffc500"
        },
        {		
            "This is a extension to Flood Expanded", 0, -350, globalFont, scale, color
        },
        {	
            "that add compatibility to many romhacks", 0, -320, globalFont, scale, color
        },
        {	
            "and some new stuff like new modifiers.", 0, -290, globalFont, scale, color
        },
        {			
            "- Credits -", 0, -245, globalFont, 0.6, "#FFC500"
        },
        {		
            " : Flood RomHack Creator", 0, -210,  globalFont, scale, color
        },
        {
		-- Ñ
            "~", -205, -225, globalFont, scale, "#ff3030"
        },
        {					
           "TONO!", -200, -210, globalFont, scale, "#ff3030"
        },
        {					
           "  : Flood Expanded Creator", 0, 30, globalFont, scale, color
        },
        {
            "birdekek", -225, 30, globalFont, scale, "#7089b8"
        },
        {		
            " : Original Flood Creator", 0, -10, globalFont, scale, color
        },
        {
            "Agent", -230, -10, globalFont, scale, "#9b9b9b"
        },
        {
            "X", -175, -10, globalFont, scale, "#ec7731"
        },
        {		
		" : Legacy Floods Creator", 25, -50, globalFont, scale, color
        },
        {			
        "MarcoGamer  ", -265, -50, globalFont, scale, "#FeebF7"
        },
        {
            "OJ", -175, -50, globalFont, scale, "#FF0000"
        },
        {			
            " : B3313 Flood and Mod Trailer", 30, -130, globalFont, scale, color
        },
        {
            "Super     ", -265, -130, globalFont, scale, "#4800FF"
        },
        {		
            "Marty", -205, -130, globalFont, scale, "#FFA200"
        },
        {	
            "Super", -330, -170, globalFont, scale, "#009C36"
        },
        {
            "Rodrigo0", -230, -170, globalFont, scale, "#FFFF00"
        },
        {	
            " : Main Helper and Support", 5, -170, globalFont, scale, color
        },
        {		
            "Blocky.cmd", -270, -90, globalFont, scale, "#0000ff"
        },
        {		
            " : Custom Pause Menu Mod", 0, -90, globalFont, scale, color
        },
        {		
            "- Information -", 0, 90, globalFont, 0.6, "#FFc500"
        },
        {		
            "Romhack: " ..romhackText, 0, 140,  globalFont, scale, color
        },
        {			
            "Total Romhacks: " ..total_romhacks.. "   Version: "..version, 0, 180,  globalFont, scale, color
        },
        {				
            "Type '/msg ' to see this message again", 0, 260, globalFont, scale, color
        },
        {		
            "Hover your mouse over OK or press [A] or [START]", 0, 300, globalFont, scale, color
        },
        {
            "to close this message.", 0, 340, globalFont, scale, color
        },
        {		
            "OK", 0, 430, globalFont, 1.0, "#FF0000"
        }
    }

    -----------------------------------------
    -- Main code:
    m = gMarioStates[0]
    if (switched == true) then
        -- render the rectangle.
        renderRect(190, 120, FONT_MENU, 790, 900, "#000000")			

        -- print all texts
        for _, v in ipairs(texts) do
            printColorText(v[1], v[2], v[3], v[4], v[5], v[6])
        end

        -- get relative coordinates of OK text
        local xd = returnX("OK", scale, globalFont)
        local yd = returnY("OK", scale, globalFont) + 430

        -- get mouse_x and mouse_y coordinates
        local mousex = djui_hud_get_mouse_x()
        local mousey = djui_hud_get_mouse_y()

        -- calculate distance between button and mouse
        -- if player presses D_PAD Down or (if mouse_hover is activated) hovers over the OK text,
        -- the window closes.
        local dist = math.sqrt(((xd - mousex) ^ 2) + (((yd + 40) - mousey) ^ 2))
        if (CLOSE_ON_MOUSE_HOVER) then
            if (dist < 40) then
                switched = false
                play_character_sound(m, CHAR_SOUND_OKEY_DOKEY)
                if (hasConfirmed == false) then
                    hasConfirmed = true
                end
            end
        end

        if m.controller.buttonDown & A_BUTTON ~= 0 or m.controller.buttonDown & START_BUTTON ~= 0 then
            switched = false
            play_character_sound(m, CHAR_SOUND_OKEY_DOKEY)
            if (hasConfirmed == false) then
                hasConfirmed = true
            end
        end
    end
end

-- prints text in the center of the screen
function printColorText(text, x, y, font, scale, color)
    local r, g, b, a = 0, 0, 0, 0

    local rgbtable = checkColorFormat(color)
    djui_hud_set_resolution(RESOLUTION_DJUI)
    djui_hud_set_font(font)

    local screenWidth = djui_hud_get_screen_width()
    local width = (djui_hud_measure_text(text) / 2) * scale

    local screenHeight = djui_hud_get_screen_height()
    local height = 64 * scale

    -- get centre of screen
    local halfwidth = screenWidth / 2
    local halfheight = screenHeight / 2

    local xc = halfwidth - width
    local yc = halfheight - height

    djui_hud_set_color(rgbtable.r, rgbtable.g, rgbtable.b, 255)
    djui_hud_print_text(text, xc + x, yc + y, scale)
end

-- returns X coordinate relative to text
function returnX(text, scale, font)
    djui_hud_set_resolution(RESOLUTION_DJUI)
    djui_hud_set_font(font)

    local screenWidth = djui_hud_get_screen_width()
    local width = (djui_hud_measure_text(text) / 2) * scale

    local screenHeight = djui_hud_get_screen_height()
    local height = 64 * scale

    -- get centre of screen
    local halfwidth = screenWidth / 2
    local halfheight = screenHeight / 2

    local xc = halfwidth - width
    local yc = halfheight - height

    return xc
end

-- returns Y coordinate relative to text
function returnY(text, scale, font)
    djui_hud_set_resolution(RESOLUTION_DJUI)
    djui_hud_set_font(font)

    local screenWidth = djui_hud_get_screen_width()
    local width = (djui_hud_measure_text(text) / 2) * scale

    local screenHeight = djui_hud_get_screen_height()
    local height = 64 * scale

    -- get centre of screen
    local halfwidth = screenWidth / 2
    local halfheight = screenHeight / 2

    local xc = halfwidth - width
    local yc = halfheight - height

    return yc
end

-- renders a rectangle in the center of the screen
function renderRect(x, y, font, w, h, color)
    local rgbtable = checkColorFormat(color)
    djui_hud_set_resolution(RESOLUTION_DJUI)
    --djui_hud_set_font(font);

    local screenWidth = djui_hud_get_screen_width()
    local screenHeight = djui_hud_get_screen_height()

    -- get center
    local halfwidth = screenWidth / 2
    local halfheight = screenHeight / 2

    local xc = x + halfwidth
    local yc = y + halfheight

    local xx = xc - halfwidth
    local yy = yc - halfheight

    local xd = x + (screenWidth / 2)
    local yd = y + (screenHeight / 2)

    local xe = x + (w / 2)
    local ye = y + (h / 2)

    local fx = xd - xe
    local fy = yd - ye

    djui_hud_set_color(rgbtable.r, rgbtable.g, rgbtable.b, 170)
    djui_hud_render_rect(fx, fy, w, h)
end

function displayrules2()
    if (switched) then
        djui_chat_message_create("The message is currently opened. Close it first.")
        return true
    end
    switched = true
    return true
end

function checkColorFormat(rgbhex)
    local r, g, b, a = 0, 0, 0, 0

    local d = string.find(color, "#")
    if ((d == 1) and (string.len(rgbhex) == 7)) then
        local colorhex = string.gsub(rgbhex, "#", "")
        r = string.sub(colorhex, 0, 2)
        g = string.sub(colorhex, 3, 4)
        b = string.sub(colorhex, 5, 6)

        r = tonumber(r, 16)
        g = tonumber(g, 16)
        b = tonumber(b, 16)
        return {r = r, g = g, b = b}
    else
        print("Color format is wrong.")
        return
    end
end

hook_event(HOOK_ON_HUD_RENDER, displayrules)
hook_chat_command("msg", "- displays the credits of Flood \\#FFC500\\Romhack", displayrules2)