﻿/*:
 * @target MZ
 * @plugindesc 特定のピクチャIDの上ではメッセージ送りを無効化してピクチャクリックを優先するプラグイン
 * @author ChatGPT
 *
 * @param TargetPictureIDs
 * @text 対象ピクチャID
 * @type string
 * @default 1,2,3
 * @desc クリック優先にしたいピクチャIDをカンマ区切りで指定（例：1,5,10）
 *
 * @help
 * ■ 概要
 * 指定したピクチャIDの上をクリックしたときだけ、
 * メッセージ送り（決定入力）を無効化します。
 *
 * 他ピクチャや画面の他の場所ではメッセージ送りは通常通り動きます。
 *
 * ButtonPictures / PictureCallCommon などと併用可能。
 *
 */

(() => {

    const params = PluginManager.parameters('PictureClickPriorityID');
    const targetIds = (params.TargetPictureIDs || "")
        .split(",")
        .map(id => Number(id.trim()))
        .filter(id => !isNaN(id));

    const _Window_Message_isTriggered = Window_Message.prototype.isTriggered;
    Window_Message.prototype.isTriggered = function() {

        if (!this.isOpen()) {
            return _Window_Message_isTriggered.call(this);
        }

        const x = TouchInput.x;
        const y = TouchInput.y;

        const sprites = SceneManager._scene?._spriteset?._pictureContainer?.children || [];
        
        for (const sprite of sprites) {
            // sprite.pictureId は内部的には picture._pictureId
            const picId = sprite.pictureId || sprite._pictureId;
            if (!targetIds.includes(picId)) continue;

            if (!sprite.bitmap) continue;

            const sx = sprite.x;
            const sy = sprite.y;
            const sw = sprite.bitmap.width * sprite.scale.x;
            const sh = sprite.bitmap.height * sprite.scale.y;

            if (x >= sx && x <= sx + sw && y >= sy && y <= sy + sh) {
                return false;  // ★ 指定ピクチャ上 → メッセージ送り無効化
            }
        }

        return _Window_Message_isTriggered.call(this);
    };

})();
