﻿/*:
 * @target MZ
 * @plugindesc PictureCallCommon のクリック無効時間を延長するパッチ
 * @author ChatGPT
 *
 * @param DisableFrames
 * @text クリック無効フレーム数
 * @type number
 * @min 1
 * @default 5
 * @desc PictureCallCommon の実行直後、何フレームクリックを無効にするか。
 */

(() => {
    const params = PluginManager.parameters('PictureCallCommon_Patch');
    const disableFrames = Number(params.DisableFrames || 5);

    let disableCounter = 0;

    // PictureCallCommon 実行時に無効化フラグを立てるため、
    // TouchInput._pressedTime を監視する。
    const _TouchInput_update = TouchInput.update;
    TouchInput.update = function() {
        _TouchInput_update.call(this);

        if (this._pressedTime === 0 && this._lastPressedTime === 1) {
            // PictureCallCommon が入力を潰した直後と判断
            disableCounter = disableFrames;
        }
        this._lastPressedTime = this._pressedTime;

        // 無効フレーム中は入力を完全遮断
        if (disableCounter > 0) {
            disableCounter--;
            this._pressedTime = 0;
            this._date = 0;    // メッセージ送りも無効化
        }
    };
})();
