﻿/*:
 * @target MZ
 * @plugindesc Prevent advancing messages when clicking on specified pictures.
 * @author トリアコンタン
 *
 * @param GuardPictures
 * @text Guard Picture IDs
 * @type number[]
 * @default []
 * @desc クリック時に文章送りを無効化したいピクチャIDを列挙します。
 */

(() => {
    const parameters = PluginManager.parameters("MessageClickGuard");
    const guardPictures = JSON.parse(parameters["GuardPictures"] || "[]").map(Number);

    const _TouchInput_onTrigger = TouchInput._onTrigger;
    TouchInput._onTrigger = function(x, y) {
        // 対象ピクチャ上にクリックがあるか判定
        if ($gameMessage.isBusy() && isGuardPictureClicked(x, y)) {
            // ピクチャイベントには通常通り届かせるが
            // メッセージ送りは行わない
            this._x = x;
            this._y = y;
            this._triggered = true;
            return;
        }
        _TouchInput_onTrigger.call(this, x, y);
    };

    function isGuardPictureClicked(x, y) {
        const sprites = SceneManager._scene?._spriteset?._pictureContainer?.children;
        if (!sprites) return false;

        for (const sprite of sprites) {
            if (!sprite.picture()) continue;
            const id = sprite.picture().pictureId();
            if (!guardPictures.includes(id)) continue;

            const rect = sprite.getBounds();
            if (rect.contains(x, y)) {
                return true;
            }
        }
        return false;
    }
})();
