//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		SequenceBigFourFire.cpp
 *	@brief  lVCxg̗ij
 *	@author	Masayuki Onoue
 *	@date		2012.06.16
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "SequenceBigFourFire.h"
#include "gimmic_sequence.gaix"

namespace field {


/* -------------------------------------------------------------------------*/
/**
 * @brief RXgN^
 *
 * @param mp_fieldmap tB[h}bv
 * @param p_heap      gpq[v
 */
/* -------------------------------------------------------------------------*/
SequenceBigFourFire::SequenceBigFourFire(field::Fieldmap*  p_fieldmap,gfl::heap::HeapBase* p_heap)
  :mp_seq_arc(NULL),
  mp_seq_sys(NULL),
  mp_seq_file(NULL),
  mp_fieldmap(NULL),
  mp_unique_sequence(NULL)
{
  // p[^ݒ
  mp_fieldmap = p_fieldmap;
  mp_unique_sequence = reinterpret_cast<FieldUniqueSequenceBigFourFire*>(mp_fieldmap->GetFieldUniqueSequence());
  mp_heap = p_heap;

  // V[PXݒ
  tool::seqeditor::InitParam initParam =
  {
    mp_heap,
    NULL
  };
  mp_seq_sys = GFL_NEW(mp_heap)tool::seqeditor::SeqSystem(initParam);

}

/* -------------------------------------------------------------------------*/
/**
 * @brief RXgN^
 */
/* -------------------------------------------------------------------------*/
SequenceBigFourFire::~SequenceBigFourFire()
{
  GFL_SAFE_DELETE( mp_seq_arc );
  GFL_SAFE_DELETE( mp_seq_sys );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief 
 */
/* -------------------------------------------------------------------------*/
void SequenceBigFourFire::Initialize( void )
{
  // A[JCut@CǍݏ
  u32 init_flag = gfl::fs::ArcFile::OPEN;
#if PM_DEBUG
  if( field::FieldDebug::DebugPCLoadFlag ) {
    init_flag |= gfl::fs::ArcFile::HIO;
  }
#endif
  mp_seq_arc = GFL_NEW( mp_heap ) gfl::fs::ArcFile( mp_heap, ARCID_BIG_FOUR_SEQ, init_flag );
  LoadSeqFile();
}

/* -------------------------------------------------------------------------*/
/**
 * @brief V[PXt@C̓ǂݍ
 */
/* -------------------------------------------------------------------------*/
void SequenceBigFourFire::LoadSeqFile( void )
{
  mp_seq_file = mp_seq_sys->LoadFile( mp_seq_arc , GARC_gimmic_sequence_big_four_fire_BSEQ , this );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Abvf[g
 */
/* -------------------------------------------------------------------------*/
void SequenceBigFourFire::Update(void)
{
  if( mp_seq_sys )
  {
    mp_seq_sys->UpdateFrame();
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief ݂̃t[擾
 *
 * @return ݂̃t[
 */
/* -------------------------------------------------------------------------*/
int SequenceBigFourFire::GetSeqFrame(void)
{
  if( mp_seq_file )
  {
    return mp_seq_file->GetFrame();
  }
  return 0;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief R}hR[obN
 *
 * @param seqFile V[PXt@C
 * @param param   p[^
 */
/* -------------------------------------------------------------------------*/
void SequenceBigFourFire::CommnadCallback( tool::seqeditor::SeqFile *seqFile , const tool::seqeditor::CommandParam &param )
{
  switch( param.commandNo )
  {
  case EVENT_SEQ_ID_FIRE_SPARK_START:
    mp_unique_sequence->StartAnimation( FieldUniqueSequenceBigFourFire::MDLID_SPARK );
    break;
  case EVENT_SEQ_ID_FIRE_FIRE01_START:
    mp_unique_sequence->StartAnimation( FieldUniqueSequenceBigFourFire::MDLID_FIRE_01 );
    break;
  case EVENT_SEQ_ID_FIRE_FIRE02_START:
    mp_unique_sequence->StartAnimation( FieldUniqueSequenceBigFourFire::MDLID_FIRE_02 );
    break;
  case EVENT_SEQ_ID_SET_LIGHT01:
    mp_unique_sequence->SetLight( FieldUniqueSequenceBigFourFire::LIGHT_SETTING_EVENT );
    break;
  case EVENT_SEQ_ID_SET_LIGHT02:
    mp_unique_sequence->SetLight( FieldUniqueSequenceBigFourFire::LIGHT_SETTING_NORMAL );
    break;
  case EVENT_SEQ_ID_PLAYT_SE:
    int se_no;
    seqFile->LoadDataInt( &se_no );
    xy_snd::PlaySE( se_no );
    break;
  default:
    GFL_ASSERT_MSG(0,"sȃR}h\n");
    break;
  }
}

}

