//==============================================================================
/**
 * @file form_util.cpp
 * @brief
 * @date  2012.06.15
 * @author  tamada@gamefreak.co.jp
 */
//==============================================================================

#include <gflib.h>
#include <pmlib.h>


#include "poke_tool/poke_tool_Form.h"

#include "gamesystem/TimeZone.h"
#include "field/EvTime.h"

namespace poke_tool {

namespace form {

//======================================================================
//======================================================================
//------------------------------------------------------------------------
/**
 * @brief  PfBItH`FW
 * @param my_party
 */
//------------------------------------------------------------------------
void UpdateKerudhioForm( pml::PokeParty * my_party )
{
  int max = my_party->GetMemberCount();
  for ( int i = 0; i < max; i ++ )
  {
    pml::pokepara::PokemonParam * pp = my_party->GetMemberPointer(i);
    if ( pp->IsEgg(pml::pokepara::CHECK_BOTH_EGG) ) continue;
    if ( pp->GetMonsNo() == MONSNO_KERUDHIO
      && pp->GetFormNo() == FORMNO_KERUDHIO_SWORD
      && pp->HaveWaza( WAZANO_SINPINOTURUGI) == false )
    {
      //\[htHîjł҂̂邬ĂȂꍇ
      //tHm[}ɖ߂
      pp->ChangeFormNo( FORMNO_KERUDHIO_NORMAL );
    }
  }
}

//------------------------------------------------------------------------
/**
 * @brief Y鎞Ԃɖ邪܂܂邩H
 * @param now
 * @param passed_minutes
 * @return bool 邪܂܂
 */
//------------------------------------------------------------------------
static bool IsPassedNight( const gfl::std::DateTime *now, u32 passed_minutes )
{
  int now_hour = now->GetHour();
  if ( passed_minutes > 60 * 24 ) return true;  //24Ԍo߂Ă牽lɖ߂
  int new_hour = now_hour + ( ( now->GetMinute() + passed_minutes ) / 60 );
  int night_start = gamesystem::TimeZone::ConvertTimeZoneToStartHour( gamesystem::TimeZone::NIGHT );
  int morning_start = gamesystem::TimeZone::ConvertTimeZoneToStartHour( gamesystem::TimeZone::MORNING );
  if ( now_hour < morning_start || now_hour >= night_start )
  { //NG߂
    return true;
  }
  if ( new_hour >= night_start )
  { //ɓ or ܂ƂɂȂ̂Ŗ߂
    return true;
  }
  return false;
}

//------------------------------------------------------------------------
/**
 * 
 * @param my_party
 * @param now
 * @param passed_minutes
 * @todo  nꂽOԂƁAoߕ̊Ԃɖ邪ǂ`FbN
 */
//------------------------------------------------------------------------
void UpdateSheimiForm( pml::PokeParty * my_party, const gfl::std::DateTime *now, u32 passed_minutes )
{
  if ( IsPassedNight( now, passed_minutes ) == true )
  {
    int max = my_party->GetMemberCount();
    for ( int i = 0; i < max; i ++ )
    {
      pml::pokepara::PokemonParam * pp = my_party->GetMemberPointer(i);
      if ( pp->IsEgg(pml::pokepara::CHECK_BOTH_EGG) ) continue;
      if ( pp->GetMonsNo() == MONSNO_SHEIMI && pp->GetFormNo() == FORMNO_SHEIMI_SKY )
      {
        pp->ChangeFormNo(  FORMNO_SHEIMI_LAND );
      }
    }
  }
}

//------------------------------------------------------------------------
/**
 * @brief v[h|P̃tHXV
 * @param my_party
 * @param passed_days
 */
//------------------------------------------------------------------------
void UpdatePoodleForm( pml::PokeParty * my_party, u32 passed_days )
{
  //ŎJEg̏255Ȃ̂łȓɊۂ߂
  if ( passed_days > 255 ) passed_days = 255;

  int max = my_party->GetMemberCount();
  for ( int i = 0; i < max; i ++ )
  {
    pml::pokepara::PokemonParam * pp = my_party->GetMemberPointer(i);
    if ( pp->IsEgg(pml::pokepara::CHECK_BOTH_EGG) ) continue;

    if ( pp->GetMonsNo() == MONSNO_701 && pp->GetFormNo() != FORMNO_701_NORMAL )
    {
      //oߓJEg
      int keep = pp->GetKeepDayCount();
      int keep_max = pp->GetKeepDayCount();
      keep += passed_days;
      if ( keep > 255 ) keep = 255;
      pp->SetKeepDayCount( keep );
      if ( keep > keep_max )
      {
        pp->SetKeepMaxDayCount( keep );
      }
      //̖уJEg炷
      int hair_count = pp->GetBodyHairCount();
      if ( hair_count > passed_days )
      {
        hair_count -= passed_days;
      }
      else
      {
        hair_count = 0;
      }
      pp->SetBodyHairCount( hair_count );

      pp->ChangeFormNo( FORMNO_701_NORMAL );
    }
  }
}

  //------------------------------------------------------------------------
  /**
   * @brief v[h|P̃tHZbg
   * @param pp
   * @param formno
   */
  //------------------------------------------------------------------------
  extern void SetPoodleForm( pml::pokepara::PokemonParam * pp, pml::FormNo formno );

};  //namespace form 
}; //namespace poke_tool

