//============================================================================================
/**
 * @file		box_search_graphic.h
 * @brief		OtBbN֘A
 * @author	Hiroyuki Nakamura
 * @date		12.06.16
 *
 * namespace	app::box_search::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#if !defined( __BOX_SEARCH_GRAPHIC_H__ )
#define __BOX_SEARCH_GRAPHIC_H__

#include "app/util/app_util_heap.h"
#include "app/util/app_util_2d.h"
#include "app/util/app_util_3d.h"


namespace app {
namespace box_search {


class GraphicWork {
public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		heap		q[v
	 */
	//--------------------------------------------------------------------------------------------
	GraphicWork( app::util::Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~GraphicWork();

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Abvf[g
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Update(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		`
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Draw(void);

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		OtBbNVXe쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateGraphicsSystem( app::util::Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		OtBbNVXe폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteGraphicsSystem(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		2D֘A쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Create2D( app::util::Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		2D֘A폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Delete2D(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		3D֘A쐬
	 *
	 * @param		heap		q[v
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Create3D( app::util::Heap * heap );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		3D֘A폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void Delete3D(void);


private:
	gfl::grp::GraphicsSystem * pGraSystem;	// OtBbNVXe
	app::util::G2DUtil * pG2dUtil;					// 2D֘A
	app::util::G3DUtil * pG3dUtil;					// 3D֘A

};


}	// box_search
}	// app

#endif	// __BOX_SEARCH_GRAPHIC_H__
