//============================================================================================
/**
 * @file		box_search.cpp
 * @brief		Proc֘A
 * @author	Hiroyuki Nakamura
 * @date		12.06.16
 *
 * namespace	app::box_search::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "app/box_search/box_search.h"
#include "box_search_main.h"


namespace app {
namespace box_search {

//============================================================================================
//	萔`
//============================================================================================
#define	BOX_SEARCH_SYS_HEAP_SIZE		( 0x1000 )		// VXeq[vTCY


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		prm		Oݒp[^
 */
//--------------------------------------------------------------------------------------------
Proc::Proc( APP_PARAM * prm )
{
	CreateHeap();
	pMain = GFL_NEW( pHeap )	MainSystem( prm );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::~Proc()
{
	GFL_DELETE	pMain;
	DeleteHeap();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * proc_manager )
{
	gamesystem::GameProcManager * gpm = reinterpret_cast<gamesystem::GameProcManager*>( proc_manager );
	pMain->SetGameManager( gpm );
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcI
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcAbvf[g
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
	switch( pMain->Update() ){
	case MainSystem::UPDATE_CONTINUE:
		return gfl::proc::RES_CONTINUE;

	case MainSystem::UPDATE_FINISH:
		return gfl::proc::RES_FINISH;

	default:
		GFL_ASSERT( 0 );
		break;
	}

	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc`揈
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
	pMain->Draw();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::CreateHeap(void)
{
	pHeap = GFL_CREATE_HEAP(
						gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ),
						HEAPID_BOX_SEARCH_SYS, BOX_SEARCH_SYS_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP, false );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DeleteHeap(void)
{
	gfl::heap::Manager::DeleteHeap( pHeap );
}


}	// box_search
}	// app
