//============================================================================================
/**
 * @file    sv_config.cpp
 * @brief   RtBOZ[uf[^
 * @author  Nobuhiko Ariizumi
 * @date    12/6/14
 */
//============================================================================================
#include "savedata/sv_config.h"

namespace savedata {

//--------------------------------------------------------------------------------------------
/**
 * @brief   RXgN^
 */
//--------------------------------------------------------------------------------------------
Config::Config(void)
{
    Clear( NULL );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   fXgN^
 */
//--------------------------------------------------------------------------------------------
Config::~Config(void)
{
}


//--------------------------------------------------------------------------------------------
/**
 * @brief Z[uf[^NA
 * @param heap
 */
//--------------------------------------------------------------------------------------------
void Config::Clear( gfl::heap::HeapBase * heap)
{
  mConfigData.langId = LANGID_KANA;
  mConfigData.msgSpeed = MSG_NORMAL;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ID̐ݒ
 *
 * @param   LANGID  `
 */
//--------------------------------------------------------------------------------------------
void Config::SetLangId( const Config::LANGID id )
{
  mConfigData.langId = id;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   ID̐ݒ
 *
 * @return  LANGID  `
 */
//--------------------------------------------------------------------------------------------
Config::LANGID Config::GetLangId(void)const
{
  return static_cast<Config::LANGID>(mConfigData.langId);
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   ID̐ݒ
 *
 * @param   MSG_SPEED  bZ[WXs[h
 */
//--------------------------------------------------------------------------------------------
void Config::SetMsgSpeed( const Config::MSG_SPEED spd )
{
  mConfigData.msgSpeed = spd;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   ID̐ݒ
 *
 * @return  MSG_SPEED  bZ[WXs[h
 */
//--------------------------------------------------------------------------------------------
Config::MSG_SPEED Config::GetMsgSpeed(void)const
{
  return static_cast<Config::MSG_SPEED>(mConfigData.msgSpeed);
}


} // savedata
