//============================================================================================
/**
 * @file    sv_config.h
 * @brief   RtBOZ[uf[^
 * @author  Nobuhiko Ariizumi
 * @date    12/6/14
 */
//============================================================================================
#pragma once

#ifndef __SV_CONFIG_H__
#define __SV_CONFIG_H__

#include <gflib.h>

namespace savedata
{
  
class Config : public SaveDataInterface
{
public:

  typedef enum
  {
    LANGID_KANA = 0,
    LANGID_KANJI,
    LANGID_ENGLISH,
    LANGID_FRENCH,
    LANGID_ITALIAN,
    LANGID_GERMAN,
    LANGID_SPANISH,
    LANGID_KOREAN,
  }LANGID;

  typedef enum
  {
    MSG_SLOW = 0, //1ɂ2t[
    MSG_NORMAL,   //1ɂ1t[
    MSG_FAST,     //1ɂ0.5t[
    
    MSG_SPEED_MAX,
  }MSG_SPEED;

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   RXgN^
   */
  //--------------------------------------------------------------------------------------------
  Config(void);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   fXgN^
   */
  //--------------------------------------------------------------------------------------------
  ~Config(void);


private:
  struct ConfigData {
    u16 langId:4;     //0~7
    u16 msgSpeed:2;   //0~2
    //ȉƂ肠ڐA
    u16 battleRule:1;
    u16 wazaeffMode:1;
    u16 soundMode:2;
    u16 wirelessSaveMode:1;
    u16 networkSearch:1;
    
    u16 padding:4;
    u16 padding2;
  };

  ConfigData mConfigData;  //f[^{

public:
  //-----------------------------------------------------------------------------
  /**
   * @brief    ǂݍ񂾃f[^Zbg֐
   * @param    pData   擪̃|C^
   */
  //-----------------------------------------------------------------------------
  virtual void SetData(void* pData){ gfl::std::MemCopy(pData, reinterpret_cast<void*>(&mConfigData), sizeof(ConfigData)); };
  //-----------------------------------------------------------------------------
  /**
   * @brief    f[^̐擪|C^𓾂֐
   * @return   擪̃|C^
   */
  //-----------------------------------------------------------------------------
  virtual void* GetData(void){ return reinterpret_cast<void*>(&mConfigData); };
  //-----------------------------------------------------------------------------
  /**
   * @brief    f[^TCY
   * @retval   oCg
   */
  //-----------------------------------------------------------------------------
  virtual size_t GetDataSize(void){ return sizeof(ConfigData); };

  //--------------------------------------------------------------------------------------------
  /**
   * @brief Z[uf[^NA
   * @param heap
   */
  //--------------------------------------------------------------------------------------------
  void Clear( gfl::heap::HeapBase * heap);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ID̐ݒ
   *
   * @param   LANGID  `
   */
  //--------------------------------------------------------------------------------------------
  void SetLangId( const LANGID id );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ID̐ݒ
   *
   * @return  LANGID  `
   */
  //--------------------------------------------------------------------------------------------
  LANGID GetLangId(void)const;
  
  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ID̐ݒ
   *
   * @param   MSG_SPEED  bZ[WXs[h
   */
  //--------------------------------------------------------------------------------------------
  void SetMsgSpeed( const MSG_SPEED spd );

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   ID̐ݒ
   *
   * @return  MSG_SPEED  bZ[WXs[h
   */
  //--------------------------------------------------------------------------------------------
  MSG_SPEED GetMsgSpeed(void)const;

};

} //namespace savedata
#endif // __SV_CONFIG_H__
