#if PM_DEBUG

//================================================================================
/**
 * @file   test_ohno_p2pcm.cpp
 * @brief  Ⴂ̃f[^eXg
 * @author k.ohno
 * @date   2010.12.15
 */ 
//================================================================================
#include <nn.h>
#include <gflib.h>
#include <gamesystem/GameManager.h>
#include <gamesystem/GameProcManager.h>
#include "test_ohno_p2pcm.h"


namespace gflnet{
extern nn::nex::qInt GenericInit(nn::nex::qInt argc, nn::nex::qChar** argv,
                                 gfl::heap::HeapBase *systemHeap,gfl::ui::Button*);
extern nn::nex::qInt GenericMain(nn::nex::qInt argc, nn::nex::qChar** argv,
                                 gfl::heap::HeapBase *systemHeap,gfl::ui::Button*);
extern nn::nex::qInt GenericEnd(nn::nex::qInt argc, nn::nex::qChar** argv,
                                 gfl::heap::HeapBase *systemHeap,gfl::ui::Button*);
};

GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)




    //-----------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------
TestOhnoP2pCM::TestOhnoP2pCM( 
  gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
  gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
  gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager ) :
Base( heap, device_heap, heap_allocator, device_allcator, graphics_system, ui_device_manager )
{ 


  mpSsystemHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase *devHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );


 // mpP2pCM = GFL_NEW(mpSsystemHeap) netapp::p2p_matching::P2P_ConnectionManager();
  mpP2pCM=NULL;

}


//-----------------------------------------------------------------------------
// fXgN^
//-----------------------------------------------------------------------------
TestOhnoP2pCM::~TestOhnoP2pCM()
{

  GFL_DELETE(mpP2pCM);
  
}


//-----------------------------------------------------------------------------
// C
//-----------------------------------------------------------------------------
void TestOhnoP2pCM::UpdateTest( void )
{
  if(mpP2pCM){
    mpP2pCM->Update();
  }
  // A {^ŊJn
  if( m_button->IsTrigger( gfl::ui::BUTTON_X ) ) {  //
    bit64 tfi =nn::cfg::CTR::GetTransferableId( gamesystem::GameManager::APLICATION_UNIQUE_ID );
    GFL_PRINT("t  %llu\n", tfi);
    mpP2pCM = GFL_NEW(mpSsystemHeap) netapp::p2p_matching::P2P_ConnectionManager();
    mpP2pCM->Connect(true, 15370845773734235505);
  }
  // B {^ŊJn
  if( m_button->IsTrigger( gfl::ui::BUTTON_Y ) ) {  //
    bit64 tfi =nn::cfg::CTR::GetTransferableId( gamesystem::GameManager::APLICATION_UNIQUE_ID );
    GFL_PRINT("t  %llu\n", tfi);
    mpP2pCM = GFL_NEW(mpSsystemHeap) netapp::p2p_matching::P2P_ConnectionManager();
    mpP2pCM->Connect(false, 1783068936919103316);
  }

} 



//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void TestOhnoP2pCM::DrawTest( void )
{

}


GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)

#endif // PM_DEBUG
