#if PM_DEBUG

#ifndef __DEMO_TEST_PROC_H__
#define __DEMO_TEST_PROC_H__

#include <gflib.h>

#include "test/ito/ProcBase.h"
#include "IScene.h"
#include "system/sequence/Player.h"

GFL_NAMESPACE_BEGIN(demo_test)

class Proc : public test::ito::ProcBase
{
public:
  // override
  virtual gamesystem::FrameMode GetFrameMode( void ) const { return gamesystem::FRAMEMODE_30; }
  virtual void InitLocal();
  virtual void EndLocal(){}
};

class Scene : public test::ito::IChildScene<test::ito::ProcBase>
{
public:
  Scene();
  ~Scene();
  
  void Enter();
  bool Update();
  void Exit();
  
  void DrawTop(gfl::grp::GraphicsSystem* gs);
  void DrawBottom(gfl::grp::GraphicsSystem* gs);
  
private:
  gfl::grp::g3d::System* m_g3d_system;
  gfl::grp::g3d::Scene* m_scene;
  gfl::grp::g3d::Light* m_light;
  gfl::grp::g3d::StereoCamera* m_camera;
  gfl::grp::g3d::Resource* m_environment_resource;
  gfl::grp::g3d::Resource* m_light_resource;
  
  poke_tool::PokeModelSystem* m_poke_sys;
  poke_tool::SimpleParam m_poke_para;
  
  xy_system::sequence::Player* m_player;
};

GFL_NAMESPACE_END(demo_test)

#endif //__DEMO_TEST_PROC_H__

#endif // PM_DEBUG
