#if PM_DEBUG

#include "test/ito/DemoTest.h"
#include "arc/arc_def.h"
#include "arc/demo_test.gaix"
#include <pmlib.h>


GFL_NAMESPACE_BEGIN(demo_test)

enum
{
  DRAWGROUP_NORMAL,
  DRAWGROUP_EDGE,
  DRAWGROUP_POST_EFFECT,
  DRAWGROUP_NUM,
};

void Proc::InitLocal()
{
  this->CreateScene<Scene>();
}

//--------------------------------------------------------------------

Scene::Scene()
{
}

Scene::~Scene()
{
}

void Scene::Enter()
{
  
    m_g3d_system = GFL_NEW( m_owner->GetHeap() ) gfl::grp::g3d::System( m_owner->GetAllocator(), m_owner->GetDeviceAllocator() );
  // J̐
  {
      m_camera = GFL_NEW( m_owner->GetDeviceHeap() ) gfl::grp::g3d::StereoCamera();
      m_camera->Create( m_owner->GetDeviceAllocator(),
        gfl::math::VEC3( 0.0f, 0.0f, 400.0f ),  // Jʒu
        gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),   // _ʒu
        0.1f );

      m_camera->GetBaseCamera()->SetAspect(400.0f/240.0f);
    //m_camera->GetBaseCamera()->SetFarClip(10000.0f);
  }
  
  // Cg̐
  {
      m_light_resource = GFL_NEW( m_owner->GetHeap() ) gfl::grp::g3d::Resource();
      m_light_resource->Load( m_owner->GetDeviceAllocator(), "rom:/ito/FragmentLight.bcenv" );

      m_light = GFL_NEW( m_owner->GetHeap() ) gfl::grp::g3d::Light();
      m_light->Create( m_owner->GetAllocator(), m_owner->GetDeviceAllocator(), m_light_resource, 0 );
  }
  
  // V[̐
  {
      m_environment_resource = GFL_NEW( m_owner->GetHeap() ) gfl::grp::g3d::Resource();
      m_environment_resource->Load( m_owner->GetDeviceAllocator(), "rom:/battle/SceneEnvironment1.bcenv" ); 

      gfl::grp::g3d::Scene::Description description;
      description.scene_draw_group_num = DRAWGROUP_NUM;
      description.own_model_num_max = 128;
      m_scene = GFL_NEW( m_owner->GetHeap() ) gfl::grp::g3d::Scene( m_owner->GetDeviceAllocator(), &description );
      m_scene->BuildSceneUsingResource( m_owner->GetAllocator(), m_owner->GetDeviceAllocator(), m_environment_resource );
  }
  // V[̃ZbgAbv
  {
    m_scene->AddSceneNode( m_camera );
    m_scene->AddSceneNode( m_light );
    m_scene->Initialize();
    m_scene->SetSceneEnvironmentUsingOwnObject();
    m_scene->Calculate();  // Jʒu𐢊EWɂ邽߂ɈxXVĂ܂.
    
    // GbW̐ݒ
    {
      gfl::grp::RenderTarget* render = m_owner->GetGraphicsSystem()->GetFrameBufferManager()->GetRenderTarget(m_owner->GetGraphicsSystem()->GetCurrentFrameBufferID(gfl::grp::DISPLAY_UPPER));
      gfl::grp::RenderTarget::Description desc;
      desc.depth_address = render->GetDepthAddress();
      desc.display_type = gfl::grp::DISPLAY_UPPER;
      m_scene->CreateEdgeMapSystem(
        m_owner->GetAllocator(),
        m_owner->GetDeviceAllocator(),
        DRAWGROUP_EDGE,
        &desc,
        &desc
      );
    }
    
    // |XgVXe̐ݒ
    {
      gfl::grp::g3d::G3DPostEffectSystem::Description desc;
      desc.edge_draw_group_id = DRAWGROUP_POST_EFFECT;
      desc.bloom_filter_enable = false;
      desc.edge_type = gfl::grp::g3d::G3DEdgeFilter::DOUBLE_LAYERED_EDGE;
      desc.edge_enable = true;
      m_scene->CreatePostEffectSystem(
        m_owner->GetAllocator(),
        m_owner->GetDeviceAllocator(),
        &desc,
        m_owner->GetGraphicsSystem()
      );
    }
    m_scene->SetEdgeColor(0.4f,0.4f,0.4f);
    m_scene->SetEdgeEnable(true);
  }
  
  // |PfVXe̍쐬
  {
    m_poke_sys = GFL_NEW(m_owner->GetHeap()) poke_tool::PokeModelSystem();
    m_poke_sys->InitSystem(
      m_owner->GetAllocator(),
      m_owner->GetDeviceAllocator(),
      GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetFileReadManager()
    );
    
    // ꏏɃ|Pp̏s
    m_poke_para.monsNo = MONSNO_MIZYUMARU;
    m_poke_para.formNo = (pml::FormNo)0;
    m_poke_para.sex = pml::SEX_MALE;
    m_poke_para.isRare = false;
    m_poke_para.isEgg = false;
    m_poke_para.perRand = 0;
  }
  
  // V[PXvC[̍쐬
  {
    static xy_system::sequence::Param param = {
      m_owner->GetHeap(),
      m_owner->GetAllocator(),
      m_owner->GetDeviceAllocator(),
      m_scene,
      m_poke_sys,   // Ƀ|PfVXe
      &m_poke_para, // |PSimpleParam̔z
      1,            // Simpleparam̐
      0,//f`
      0,//fvZ
      0,//|Pf`
      0,//|PfvZ
      0,//p[eBN`
      0,//p[eBNvZ
      0,//XN[p[eBN`
      0,//XN[p[eBNvZ
    };
    
    m_player = GFL_NEW(m_owner->GetHeap()) xy_system::sequence::Player(m_owner->GetHeap(), &param);
    //m_player->LoadRequest(ARCID_DEMO_TEST, GARC_demo_test_test2_BSEQ);
    //m_player->LoadRequest(ARCID_DEMO_TEST, GARC_demo_test_test_poke_BSEQ);
    m_player->LoadRequest(ARCID_DEMO_TEST, GARC_demo_test_test_particle_BSEQ);
    m_player->Play();
  }
}

void Scene::Exit()
{
  m_player->UnLoad(true);
  GFL_DELETE(m_player);
  
  // |PfVXe̕Еt
  m_poke_sys->ExitSystem();
  GFL_DELETE(m_poke_sys);
  
  m_scene->RemoveSceneNode(m_camera);
  m_scene->RemoveSceneNode(m_light);
  GFL_DELETE(m_camera);
  GFL_DELETE(m_light);
  
  m_scene->DestroyPostEffectSystem();
  m_scene->DestroyEdgeMapSystem();
  GFL_DELETE(m_scene);
  
  GFL_DELETE(m_environment_resource);
  GFL_DELETE(m_light_resource);
  GFL_DELETE(m_g3d_system);
}

bool Scene::Update()
{
  m_player->Update();
  
  if(m_owner->GetButton()->IsTrigger(gfl::ui::BUTTON_B))
  {
    return false;
  }
  return true;
}

//--------------------------------------------------------------------

void Scene::DrawTop(gfl::grp::GraphicsSystem* gs)
{
  m_poke_sys->UpdateSystem();
  m_poke_sys->UpdateModel();
  
  m_scene->Calculate();
  
  m_poke_sys->UpdateModelAnime();
  
  m_poke_sys->DrawRareEffectOff();
  m_scene->SubmitViewOfEdge(m_camera);
  m_poke_sys->DrawRareEffectOn();
  m_scene->SubmitView(m_camera);
  
  // [xobt@NA
  m_owner->GetGraphicsSystem()->ClearBuffer( gfl::grp::DISPLAY_UPPER, false, gfl::grp::ColorF32( 0, 0, 0, 0 ), true, 1.0f, false, 0 );
  
  m_poke_sys->DrawRareEffectOff();
  m_scene->StereoEdgeMapDraw(m_owner->GetGraphicsSystem(), m_camera);
  m_poke_sys->DrawRareEffectOn();
  
  m_scene->StereoDraw(m_owner->GetGraphicsSystem(), m_camera);
  m_scene->StereoPostEffectDraw(m_owner->GetGraphicsSystem(), m_camera);
  
}

void Scene::DrawBottom(gfl::grp::GraphicsSystem* gs)
{
  gfl::grp::util::DrawUtil::DrawText(0,0, L"Hello Demo World");
  gfl::grp::util::DrawUtil::DrawText(0,30, L"B{^Ŗ߂܂B");
  
}





GFL_NAMESPACE_END(demo_test)

#endif

