//======================================================================
/**
 *  GAME FREAK inc.
 *
 *  @file   Group.h
 *  @brief  V[PXGfB^Ŏw肵O[vKɃANX
 *  @date   2012.05.21
 *  @author ito_isao
 *
 */
//====================================================================== 

#ifndef __SYSTEM_SEQUENCE_GROUP_H__
#define __SYSTEM_SEQUENCE_GROUP_H__

#include <gflib.h>
#include "poke_tool/poke_model_sys.h"

GFL_NAMESPACE_BEGIN(xy_system)
GFL_NAMESPACE_BEGIN(sequence)

const int GROUP_MAX = 20;

enum
{
  GROUP_TYPE_NULL,
  GROUP_TYPE_MODEL,
  GROUP_TYPE_POKEMODEL,
  GROUP_TYPE_PARTICLE,
};

class Group
{
public:
  Group();
  ~Group();
  
  // O[vindexԂƂăfo^܂
  void SetModel(int index, gfl::grp::g3d::Model* p);
  void SetPokeModel(int index, poke_tool::PokeModel* p);
  void SetParticle(int index, gfl::grp::g3d::Particle* p);
  
  // O[vɓo^ꂽ̂̎ނ擾܂
  int GetType(int index);
  
  // Lœo^ꂽ̂܂
  void Clear(int index);
  
  // fƂĎ擾
  gfl::grp::g3d::Model* GetModel(int index);
  // |PfƂĎ擾
  poke_tool::PokeModel* GetPokeModel(int index);
  // p[eBNƂĎ擾
  gfl::grp::g3d::Particle* GetParticle(int index);
  
private:
  void* m_ptr[GROUP_MAX];
  int m_type[GROUP_MAX];
};


GFL_NAMESPACE_END(sequence)
GFL_NAMESPACE_END(xy_system)

#endif //__SYSTEM_SEQUENCE_GROUP_H__
